/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Cache;
import com.detectright.core.ConnectionLostException;
import com.detectright.core.DBLink;
import com.detectright.core.DRLRUMap;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.EntityCore;
import com.detectright.core.Functions;
import com.detectright.core.QuantumDataTree;
import com.detectright.core.Reflection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityProfileCore {
    public static boolean useCache = false;
    public static volatile DRLRUMap QDTs = null;
    public static volatile DRLRUMap largeQDTs = null;
    public static ThreadLocal<DBLink> dbLink = new ThreadLocal();
    protected DBLink db;
    public static ThreadLocal<Cache> cacheLink = new ThreadLocal();
    protected Cache cache;
    public long ID = 0L;
    public long entityid = 0L;
    public String entityhash = "";
    public String hash = "";
    public String source = "";
    public String data = "";
    public ArrayList<String> pkg = new ArrayList();
    public String majorrevision = "";
    public String minorrevision = "";
    public String subclass = "";
    public String connection = "";
    public String build = "";
    public String crchash = "";
    public String ts;
    public String identifier = "";
    public String owner;
    public String pk = "ID";
    public ArrayList<String> fieldList;
    public String tablename;
    public String error = "";
    public static String table = "entity_profiles";
    public static String ERROR = "";
    public static int cache_timeout = 480;
    public static ArrayList<String> fields = new ArrayList<String>(Arrays.asList("ID", "entityid", "entityhash", "source", "data", "majorrevision", "minorrevision", "identifier", "hash", "ts", "owner", "crchash", "subclass", "connection", "build", "ts"));
    protected QuantumDataTree qdt;

    static {
        DetectRight.registerClass("EntityProfileCore");
        try {
            if (Functions.is_null(cacheLink.get())) {
                cacheLink.set(DetectRight.getCacheLink());
            }
            if (Functions.is_null(dbLink.get())) {
                dbLink.set(DetectRight.getDBLink());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
    }

    public EntityProfileCore() throws ConnectionLostException, DetectRightException {
        this.cacheDB();
        this.fieldList = fields;
        this.tablename = table;
    }

    public EntityProfileCore(long ID) throws DetectRightException, ConnectionLostException {
        this(ID, "", new LinkedHashMap<String, Object>());
    }

    public EntityProfileCore(String hash) throws DetectRightException, ConnectionLostException {
        this(0L, hash);
    }

    public EntityProfileCore(long ID, String hash) throws DetectRightException, ConnectionLostException {
        this(0L, hash, new LinkedHashMap<String, Object>());
    }

    public EntityProfileCore(long ID, String hash, LinkedHashMap<String, Object> row) throws DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Object> where = new LinkedHashMap<String, Object>();
        this.cacheDB();
        LinkedHashMap<String, Object> newResult = new LinkedHashMap();
        this.fieldList = fields;
        this.tablename = table;
        if (ID > 0L) {
            where.put(this.pk, String.valueOf(ID));
        } else if (!Functions.isEmpty(hash)) {
            where.put("hash", hash);
        } else if (row != null && row.size() > 0) {
            newResult = row;
        } else {
            return;
        }
        if (where.size() > 0) {
            LinkedHashMap<String, Object> result = this.db.simpleFetch(this.tablename, DBLink.allFields, where);
            if (result == null) {
                this.error = this.db.error;
                return;
            }
            if (result.size() == 0) {
                this.error = "Non-existent profile...";
                return;
            }
            newResult = (LinkedHashMap)Functions.array_shift(result);
        }
        this.fill(newResult);
    }

    void fill(LinkedHashMap<String, Object> data) {
        if (data == null) {
            return;
        }
        if (data.containsKey("ID")) {
            this.ID = Functions.gvLong(data, "ID", 0L);
        }
        if (data.containsKey("hash")) {
            this.hash = Functions.gvString(data, "hash");
        }
        if (data.containsKey("entityhash")) {
            this.entityhash = Functions.gvString(data, "entityhash");
        }
        if (data.containsKey("entityid")) {
            this.entityid = Functions.gvLong(data, "entityid", 0L);
        }
        if (data.containsKey("owner")) {
            this.owner = Functions.gvString(data, "owner");
        }
        if (data.containsKey("data")) {
            this.data = Functions.gvString(data, "data");
        }
        if (data.containsKey("source")) {
            this.source = Functions.gvString(data, "source");
        }
        if (data.containsKey("ts")) {
            this.ts = Functions.gvString(data, "ts");
        }
        if (data.containsKey("identifier")) {
            this.identifier = Functions.gvString(data, "identifier");
        }
        if (data.containsKey("majorrevision")) {
            this.majorrevision = Functions.gvString(data, "majorrevision");
        }
        if (data.containsKey("minorrevision")) {
            this.minorrevision = Functions.gvString(data, "minorrevision");
        }
        if (data.containsKey("subclass")) {
            this.subclass = Functions.gvString(data, "subclass");
        }
        if (data.containsKey("connection")) {
            this.connection = Functions.gvString(data, "connection");
        }
        if (data.containsKey("build")) {
            this.build = Functions.gvString(data, "build");
        }
        if (data.containsKey("crchash")) {
            this.crchash = Functions.gvString(data, "crchash");
        }
    }

    public void cacheDB() throws ConnectionLostException, DetectRightException {
        if (cacheLink.get() == null) {
            cacheLink.set(DetectRight.getCacheLink());
        }
        this.cache = cacheLink.get();
        if (dbLink.get() == null) {
            dbLink.set(DetectRight.getDBLink());
        }
        this.db = dbLink.get();
        if (this.db == null) {
            throw new ConnectionLostException("Lost connection to database");
        }
    }

    public void __wakeup() throws ConnectionLostException, DetectRightException {
        this.cacheDB();
    }

    public ArrayList<String> __sleep() {
        LinkedHashMap<String, Object> ov = Reflection.get_object_vars(this);
        ov.remove("cache");
        ov.remove("db");
        ov.remove("qdt");
        return Functions.array_keys_string(ov);
    }

    public String hash() {
        return this.hash;
    }

    public long id() {
        return this.ID;
    }

    public String toString() {
        return "Entity Profile from source " + this.source + " for entity " + this.entityid + " for majorrevision " + this.majorrevision + ", minorrevision " + this.minorrevision + " subclass " + this.subclass + " connection " + this.connection + " derived from " + this.identifier;
    }

    public long ts() {
        return Functions.strtotime(this.ts);
    }

    public QuantumDataTree getQDT() throws DetectRightException, ConnectionLostException {
        this.fill();
        if (this.qdt == null) {
            return new QuantumDataTree("", null);
        }
        return this.qdt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheQDT(QuantumDataTree qdt) throws DetectRightException {
        Integer epCacheThreshold;
        if (this.data == null || this.data.length() == 0) {
            return;
        }
        boolean epCacheing = DetectRight.epCacheStatus();
        boolean largeEPCacheing = DetectRight.largeEPCacheStatus();
        if (largeEPCacheing) {
            Integer largeEPCacheThreshold = DetectRight.getLargeEPCacheThreshold();
            if (this.data.length() >= largeEPCacheThreshold) {
                ReentrantLock lock;
                ReentrantLock reentrantLock = lock = new ReentrantLock();
                synchronized (reentrantLock) {
                    if (!largeQDTs.containsKey(this.ID)) {
                        largeQDTs.add(this.ID, qdt.clone());
                    }
                }
                return;
            }
        }
        if (epCacheing && (epCacheThreshold = DetectRight.getEPCacheThreshold()) != null && this.data.length() >= epCacheThreshold) {
            ReentrantLock lock;
            ReentrantLock reentrantLock = lock = new ReentrantLock();
            synchronized (reentrantLock) {
                if (!QDTs.containsKey(this.ID)) {
                    QDTs.add(this.ID, qdt.clone());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuantumDataTree getCachedQDT() throws DetectRightException {
        ReentrantLock lock;
        boolean epCacheStatus = DetectRight.epCacheStatus();
        boolean largeEPCacheStatus = DetectRight.largeEPCacheStatus();
        if (!epCacheStatus && !largeEPCacheStatus) {
            return null;
        }
        QuantumDataTree qdt = null;
        ReentrantLock reentrantLock = lock = new ReentrantLock();
        synchronized (reentrantLock) {
            if (epCacheStatus && QDTs.containsKey(this.ID)) {
                qdt = (QuantumDataTree)QDTs.get(this.ID);
            } else if (largeEPCacheStatus && largeQDTs.containsKey(this.ID)) {
                qdt = (QuantumDataTree)largeQDTs.get(this.ID);
            }
        }
        if (qdt != null) {
            return qdt.clone();
        }
        return null;
    }

    public void fill() throws DetectRightException, ConnectionLostException {
        Object tmp;
        if (this.qdt != null || this.pkg != null && this.pkg.size() > 0 || Functions.isEmpty(this.data)) {
            return;
        }
        QuantumDataTree qdt = this.getCachedQDT();
        if (qdt != null) {
            this.qdt = qdt;
            qdt = null;
            return;
        }
        if (this.data != null && this.data.length() > 0 && (tmp = Functions.ungz(this.data)) != null) {
            if (tmp instanceof String) {
                String tmpString = (String)tmp;
                if (!tmpString.contains("source:") && !Functions.isEmpty(this.source)) {
                    tmpString = tmpString.replace("}", ";source:" + this.source + "}");
                }
                ArrayList<String> pkg = this.pkg = Functions.explode("\n", tmpString);
                qdt = new QuantumDataTree("", null);
                qdt.addPackage(pkg);
                qdt.processPackages();
                if (DetectRight.getDiag().booleanValue()) {
                    qdt.print("Entity profile " + this.ID);
                }
                this.qdt = qdt;
            } else if (tmp instanceof QuantumDataTree) {
                this.qdt = (QuantumDataTree)tmp;
                this.qdt.relinkTree();
            }
        }
        if (this.id() > 0L) {
            this.qdt.entityid = this.entityid;
            this.qdt.majorrevision = this.majorrevision;
            this.qdt.minorrevision = this.minorrevision;
            this.qdt.subclass = this.subclass;
            this.qdt.connection = this.connection;
            this.qdt.metadata.put("entityprofileid", this.id());
        }
        this.cacheQDT(this.qdt);
    }

    public String getData() {
        return this.data;
    }

    public ArrayList<String> getPackage() {
        return this.pkg;
    }

    public LinkedHashMap<String, Object> toArray() {
        return this.toArray(false);
    }

    public LinkedHashMap<String, Object> toArray(boolean data) {
        LinkedHashMap<String, Object> retArr = new LinkedHashMap<String, Object>();
        ArrayList<String> include = Functions.explode(",", "ID,source,majorrevision,minorrevision,subclass,connection,identifier,hash,ts,owner,status");
        for (String field : include) {
            try {
                String tmpObj = Reflection.getProperty(this, field).toString();
                retArr.put(field, tmpObj);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (data) {
            retArr.put("data", this.pkg);
        }
        return retArr;
    }

    public LinkedHashMap<String, Object> toExport() {
        return new LinkedHashMap<String, Object>();
    }

    public String description() {
        return "Entity profile " + this.id() + " from " + this.source + " (" + this.subclass + ":" + this.majorrevision + ":" + this.minorrevision + ":" + this.connection + ":" + this.build + ") owned by " + this.owner;
    }

    public void commit() {
    }

    public void update() {
    }

    public EntityCore getEntity() throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(this.ID)) {
            return null;
        }
        if (this.ID == 0L) {
            return null;
        }
        EntityCore entity = EntityCore.get(this.entityid);
        if (entity != null) {
            entity.majorrevision = this.majorrevision;
            entity.minorrevision = this.minorrevision;
            entity.subclass = this.subclass;
            entity.build = this.build;
            entity.connection = this.connection;
        }
        return entity;
    }

    public void cache() {
        this.cache(0);
    }

    public void cache(int timeout) {
        if (timeout == 0) {
            timeout = cache_timeout;
        }
        if (useCache && this.id() > 0L && this.pkg != null && this.pkg.size() > 0) {
            this.cache.cache_set(DetectRight.cacheKey("drep_" + this.id()), this, timeout);
        }
    }

    public static EntityProfileCore get(long id) throws DetectRightException, ConnectionLostException {
        return EntityProfileCore.get(id, "");
    }

    public static EntityProfileCore get(String hash) throws DetectRightException, ConnectionLostException {
        return EntityProfileCore.get(0L, hash);
    }

    public static EntityProfileCore get(long id, String hash) throws DetectRightException, ConnectionLostException {
        EntityProfileCore ep = null;
        Cache cl = cacheLink.get();
        if (id > 0L && cl != null) {
            ep = (EntityProfileCore)cl.cache_get(DetectRight.cacheKey("drEntityProfile_" + String.valueOf(id)));
        }
        if (ep == null) {
            ep = new EntityProfileCore(id, hash);
            if (ep.id() > 0L) {
                if (cl != null) {
                    ep.cache();
                }
            } else {
                ep.error = "";
            }
        }
        return ep;
    }

    public static LinkedHashMap<String, Object> getEPsForEntity(long id) throws DetectRightException, ConnectionLostException {
        return EntityProfileCore.getEPsForEntity(id, "", "", "");
    }

    public static LinkedHashMap<String, Object> getEPsForEntity(long id, String majorrevision, String minorrevision, String source) throws DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Object> profiles = new LinkedHashMap<String, Object>();
        if (id == 0L) {
            return profiles;
        }
        LinkedHashMap<String, Object> where = new LinkedHashMap<String, Object>();
        where.put("entityid", id);
        DBLink dbl = dbLink.get();
        if (dbl == null) {
            throw new ConnectionLostException("Connection to DB lost");
        }
        profiles = dbl.simpleFetch(table, DBLink.allFields, where);
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> tmpMap = profiles;
        for (Map.Entry entry : tmpMap.entrySet()) {
            LinkedHashMap row = (LinkedHashMap)entry.getValue();
            EntityProfileCore ep = new EntityProfileCore(0L, "", row);
            boolean doBool = true;
            if (!Functions.isEmpty(source) && !source.equals(ep.source)) {
                doBool = false;
            }
            if (!Functions.isEmpty(majorrevision) && !majorrevision.equals(ep.majorrevision)) {
                doBool = false;
            }
            if (!Functions.isEmpty(minorrevision) && !minorrevision.equals(ep.minorrevision)) {
                doBool = false;
            }
            if (!doBool) continue;
            output.put(String.valueOf(ep.id()), ep);
            ep.cache();
        }
        return output;
    }

    public static LinkedHashMap<String, Object> getEPsForEntityHash(String hash) throws DetectRightException, ConnectionLostException {
        return EntityProfileCore.getEPsForEntityHash(hash, "", "", "");
    }

    public static LinkedHashMap<String, Object> getEPsForEntityHash(String hash, String majorrevision) throws DetectRightException, ConnectionLostException {
        return EntityProfileCore.getEPsForEntityHash(hash, majorrevision, "", "");
    }

    public static LinkedHashMap<String, Object> getEPsForEntityHash(String hash, String majorrevision, String minorrevision) throws DetectRightException, ConnectionLostException {
        return EntityProfileCore.getEPsForEntityHash(hash, majorrevision, minorrevision, "");
    }

    public static LinkedHashMap<String, Object> getEPsForEntityHash(String hash, String majorrevision, String minorrevision, String source) throws DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        if (Functions.isEmpty(hash)) {
            return output;
        }
        EntityCore entity = EntityCore.getEntityFromHash(hash);
        if (entity != null) {
            return EntityProfileCore.getEPsForEntity(entity.id(), majorrevision, minorrevision, source);
        }
        return output;
    }

    public static EntityProfileCore getEPFromRow(LinkedHashMap<String, Object> row) throws DetectRightException, ConnectionLostException {
        if (row == null) {
            return null;
        }
        EntityProfileCore ep = new EntityProfileCore(0L, "", row);
        return ep;
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean destroyQDT) {
        this.cache = null;
        this.db = null;
        if (this.qdt != null && destroyQDT) {
            this.qdt.close();
        }
        this.qdt = null;
    }
}

