/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Cache;
import com.detectright.core.ConnectionLostException;
import com.detectright.core.DBLink;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.EntityCore;
import com.detectright.core.Functions;
import com.detectright.core.QuantumDataTree;
import com.detectright.core.Reflection;
import java.util.ArrayList;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntitySig {
    String sig;
    ArrayList<String> aDescriptor;
    String descriptor;
    EntityCore entity;
    String path;
    int importance = 0;
    QuantumDataTree qdt;
    public static ThreadLocal<DBLink> dbLink = new ThreadLocal();
    protected DBLink db;
    public static ThreadLocal<Cache> cacheLink = new ThreadLocal();
    protected Cache cache;

    static {
        DetectRight.registerClass("EntitySig");
        try {
            if (Functions.is_null(cacheLink.get())) {
                cacheLink.set(DetectRight.getCacheLink());
            }
            if (Functions.is_null(dbLink.get())) {
                dbLink.set(DetectRight.getDBLink());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void main(String[] args) {
    }

    EntitySig() {
    }

    EntitySig(ArrayList<String> array, String sig) throws ConnectionLostException, DetectRightException {
        this(array, sig, "");
    }

    EntitySig(LinkedHashMap<?, ?> array, String sig) throws ConnectionLostException, DetectRightException {
        this(array, sig, "");
    }

    EntitySig(LinkedHashMap<?, ?> array, String sig, String path) throws ConnectionLostException, DetectRightException {
        ArrayList<String> arr = new ArrayList<String>();
        if (array == null) {
            return;
        }
        if (!array.containsKey("entitytype")) {
            return;
        }
        arr.add(Functions.gv(array, "entitytype", "").toString());
        arr.add(Functions.gv(array, "category", "").toString());
        arr.add(Functions.gv(array, "description", "").toString());
        arr.add(Functions.gv(array, "subclass", "").toString());
        arr.add(Functions.gv(array, "majorrevision", "").toString());
        arr.add(Functions.gv(array, "minorrevision", "").toString());
        arr.add(Functions.gv(array, "connection", "").toString());
        arr.add(Functions.gv(array, "build", "").toString());
        this.newES(arr, sig, path);
    }

    EntitySig(ArrayList<String> array, String sig, String path) throws ConnectionLostException, DetectRightException {
        this.newES(array, sig, path);
    }

    void newES(ArrayList<String> array, String sig, String path) throws ConnectionLostException, DetectRightException {
        if (array == null) {
            return;
        }
        this.cacheDB();
        this.path = path;
        this.sig = sig;
        this.aDescriptor = array;
        int i = 0;
        while (i < array.size()) {
            String string = array.get(i);
            array.set(i, DetectRight.escapeDescriptor(string));
            ++i;
        }
        this.descriptor = Functions.implode(":", array);
        while (this.descriptor.endsWith(":")) {
            this.descriptor = Functions.substr(this.descriptor, 0, -1);
        }
        this.qdt = new QuantumDataTree(this.descriptor, null);
    }

    void cacheDB() throws ConnectionLostException, DetectRightException {
        if (Functions.is_null(cacheLink.get())) {
            cacheLink.set(DetectRight.getCacheLink());
        }
        this.cache = cacheLink.get();
        if (Functions.is_null(dbLink.get())) {
            dbLink.set(DetectRight.getDBLink());
        }
        this.db = dbLink.get();
        if (this.db == null) {
            throw new ConnectionLostException("Lost connection to database");
        }
    }

    void __wakeup() throws ConnectionLostException, DetectRightException {
        this.cacheDB();
    }

    ArrayList<String> __sleep() {
        LinkedHashMap<String, Object> ov = Reflection.get_object_vars(this);
        ov.remove("cache");
        ov.remove("db");
        return Functions.array_keys_string(ov);
    }

    void addQDT(QuantumDataTree qdt) {
        if (qdt == null) {
            return;
        }
        this.qdt.addQDT(qdt);
    }

    void setQDT(QuantumDataTree qdt) {
        if (qdt == null) {
            return;
        }
        this.qdt = qdt;
    }

    void addProperties(ArrayList<String> properties) {
        if (properties == null) {
            return;
        }
        this.qdt.addPackage(properties, 0, "RealTime");
    }

    void addProperty(String property) {
        if (Functions.isEmpty(property)) {
            return;
        }
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(property);
        this.addProperties(tmp);
    }

    String getEntityType() {
        if (this.aDescriptor.size() == 0) {
            return "";
        }
        return this.aDescriptor.get(0);
    }

    EntityCore getEntity() throws DetectRightException, ConnectionLostException {
        this.fillEntity();
        return this.entity;
    }

    long entityid() throws DetectRightException, ConnectionLostException {
        this.fillEntity();
        return this.entity.id();
    }

    void fillEntity() throws DetectRightException, ConnectionLostException {
        if (this.descriptor == null) {
            this.entity = new EntityCore();
        }
        if (this.entity instanceof EntityCore) {
            return;
        }
        EntityCore entity = EntityCore.getEntityFromDescriptor(this.descriptor, true, true);
        if (entity != null) {
            this.entity = entity;
        }
    }
}

