/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.ConnectionLostException;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.PHPDeserializer;
import com.detectright.core.PHPSerializer;
import com.detectright.core.PhpObject;
import com.detectright.core.Reflection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Functions {
    public static LOG_METHODS LOG_METHOD = LOG_METHODS.ECHO;
    public static ArrayList<String> output;
    public static Comparator<?> objectComparatorASC;
    public static Comparator<?> objectComparatorDESC;
    public static List<String> classes;
    public static List<String> noClasses;

    static {
        classes = Collections.synchronizedList(new ArrayList());
        noClasses = Collections.synchronizedList(new ArrayList());
        Functions.init();
    }

    public static void trigger_error(String err) throws DetectRightException, ConnectionLostException {
        Functions.trigger_error(err, new Exception(), true);
    }

    public static void trigger_error(String err, boolean fatal) throws DetectRightException, ConnectionLostException {
        Functions.trigger_error(err, new Exception(), fatal);
    }

    public static void trigger_error(String err, Exception e) throws DetectRightException, ConnectionLostException {
        Functions.trigger_error(err, e, true);
    }

    public static void trigger_error(String err, Exception e, boolean fatal) throws DetectRightException, ConnectionLostException {
        DetectRight.checkPoint("Error " + err);
        System.out.println(err);
        if (fatal) {
            throw new DetectRightException(err, e);
        }
    }

    public static long time() {
        Date date = new Date();
        int iTimeStamp = (int)((double)date.getTime() * 0.001);
        return iTimeStamp;
    }

    public static void init() {
        objectComparatorASC = new Comparator<Object>(){

            @Override
            public int compare(Object value, Object value1) {
                return Functions.objCompare(value, value1, true);
            }
        };
        objectComparatorDESC = new Comparator<Object>(){

            @Override
            public int compare(Object value, Object value1) {
                return Functions.objCompare(value, value1, false);
            }
        };
    }

    public static double parseDoubleLoose(String number) throws NumberFormatException {
        try {
            return Double.parseDouble(number);
        }
        catch (NumberFormatException nfe1) {
            if (Functions.isNumeric(number)) {
                ArrayList<String> tmp = Functions.explode(".", number);
                String test = tmp.get(0);
                if (test.equals("")) {
                    test = "0";
                }
                if (tmp.size() > 1) {
                    test = String.valueOf(test) + "." + tmp.get(1);
                }
                return Double.parseDouble(test);
            }
            throw new NumberFormatException();
        }
    }

    public static int objCompare(Object value, Object value1, boolean ascending) {
        int gt = 1;
        int lt = -1;
        if (value == null) {
            value = "";
        }
        if (value1 == null) {
            value1 = "";
        }
        if (!ascending) {
            gt = -1;
            lt = 1;
        }
        if (value instanceof Integer && value1 instanceof Integer) {
            Integer ival1 = (Integer)value;
            Integer ival2 = (Integer)value1;
            return ival1 == ival2 ? 0 : (ival1 > ival2 ? gt : lt);
        }
        if (value instanceof Long && value1 instanceof Long) {
            long ival2;
            long ival1 = (Long)value;
            return ival1 == (ival2 = ((Long)value1).longValue()) ? 0 : (ival1 > ival2 ? gt : lt);
        }
        if (value instanceof Double && value1 instanceof Double) {
            Double dval1 = (Double)value;
            Double dval2 = (Double)value1;
            return dval1 == dval2 ? 0 : (dval1 > dval2 ? gt : lt);
        }
        double dvalue = 0.0;
        double dvalue1 = 0.0;
        String sval1 = value.toString();
        String sval2 = value1.toString();
        if (sval1.equals("") && sval2.equals("")) {
            return 0;
        }
        if (Functions.is_numeric(sval1) && Functions.is_numeric(sval2)) {
            try {
                dvalue = Double.parseDouble(sval1);
                dvalue1 = Double.parseDouble(sval2);
                return dvalue == dvalue1 ? 0 : (dvalue > dvalue1 ? gt : lt);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (value instanceof String && value1 instanceof String) {
            int comparesTo = sval1.compareToIgnoreCase(sval2);
            if (ascending) {
                return comparesTo;
            }
            return 0 - comparesTo;
        }
        return 0;
    }

    public static boolean to_boolean(String str) {
        String boolStr = Functions.to_booleanString(str);
        if (boolStr == null) {
            return false;
        }
        return boolStr.equals("1");
    }

    public static boolean is_boolean(String str) {
        return Functions.to_booleanString(str) != null;
    }

    public static String to_booleanString(String str) {
        if (str == null) {
            return null;
        }
        String[] trueValues = new String[]{"true", "True", "Yes", "yes", "1", "-1", "yep", "supported"};
        String[] falseValues = new String[]{"false", "no", "False", "No", "0", "nope", "not supported", "not_supported"};
        int i = 0;
        while (i < trueValues.length) {
            if (str.equals(trueValues[i])) {
                return "1";
            }
            ++i;
        }
        i = 0;
        while (i < falseValues.length) {
            if (str.equals(falseValues[i])) {
                return "0";
            }
            ++i;
        }
        return null;
    }

    public static boolean is_integer(String str) {
        if (str == null) {
            return false;
        }
        if (str.equals("")) {
            return false;
        }
        Character c = Character.valueOf(str.charAt(0));
        if (!(c.equals(Character.valueOf('-')) || c.equals("+") || Character.isDigit(c.charValue()))) {
            return false;
        }
        try {
            Integer test = Functions.parseInt(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean in_array(String s, String[] strArr) {
        return Functions.in_array(s, strArr, false);
    }

    public static boolean in_array(String s, String[] strArr, boolean ci) {
        if (strArr == null) {
            return false;
        }
        if (s == null) {
            return false;
        }
        int i = 0;
        while (i < strArr.length) {
            if (!ci ? s.equals(strArr[i]) : s.equalsIgnoreCase(strArr[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean in_array(Object o, ArrayList<?> arr) {
        return Functions.in_array(o, arr, false);
    }

    public static boolean in_array(Object o, ArrayList<?> arr, boolean ci) {
        if (o == null || arr == null) {
            return false;
        }
        for (Object obj : arr) {
            if (!Functions.isEqual(o, obj, ci)) continue;
            return true;
        }
        return false;
    }

    public static boolean in_array(Object o, Map<?, ?> hm) {
        return Functions.in_array(o, hm, false);
    }

    public static boolean in_array(Object o, Map<?, ?> hm, boolean ci) {
        if (o == null || hm == null) {
            return false;
        }
        Map<?, ?> tmpHM = hm;
        for (Map.Entry<?, ?> entry : tmpHM.entrySet()) {
            Object obj = entry.getValue();
            if (!Functions.isEqual(o, obj, ci)) continue;
            return true;
        }
        return false;
    }

    public static boolean array_key_exists(String s, ArrayList<?> arr) {
        Integer key;
        if (s == null || arr == null) {
            return false;
        }
        try {
            key = Integer.valueOf(s);
        }
        catch (Throwable e) {
            return false;
        }
        Object obj = null;
        try {
            obj = arr.get(key);
            if (obj == null) {
            }
        }
        finally {
            return false;
        }
        return true;
    }

    public static boolean array_key_exists(int key, ArrayList<?> arr) {
        if (arr == null) {
            return false;
        }
        try {
            Object obj = arr.get(key);
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public static boolean array_key_exists(String s, Map<?, ?> hm) {
        if (s == null) {
            return false;
        }
        return hm.containsKey(s);
    }

    public static boolean array_key_exists(int s, Map<?, ?> hm) {
        return hm.containsKey(String.valueOf(s));
    }

    public static long strtotime(String string) {
        long now = System.currentTimeMillis();
        return Functions.strtotime(string, now /= 1000L);
    }

    /*
     * Unable to fully structure code
     */
    public static long strtotime(String str, long nowLng) {
        strTmp = "";
        parse = 0L;
        strTmp = str;
        strTmp = strTmp.replaceAll("/\\s{2,}|^\\s|\\s$/g", " ");
        if ((strTmp = strTmp.replaceAll("/[\\t\\r\\n]/g", "")).equalsIgnoreCase("now")) {
            return new Date().getTime() / 1000L;
        }
        try {
            parse = Date.parse(strTmp);
            return parse / 1000L;
        }
        catch (Throwable var8_4) {
            now = new Date(nowLng * 1000L);
            strTmp = strTmp.toLowerCase();
            __is = new HashMap<K, V>();
            days = new HashMap<String, Integer>();
            month = new HashMap<String, Integer>();
            days.put("sun", 0);
            days.put("mon", 1);
            days.put("tue", 2);
            days.put("wed", 3);
            days.put("thu", 4);
            days.put("fri", 5);
            days.put("sat", 6);
            month.put("jan", 0);
            month.put("feb", 1);
            month.put("mar", 2);
            month.put("apr", 3);
            month.put("may", 4);
            month.put("jun", 5);
            month.put("jul", 6);
            month.put("aug", 7);
            month.put("sep", 8);
            month.put("oct", 9);
            month.put("nov", 10);
            month.put("dec", 11);
            ptn = Pattern.compile("(^\\d{2,4}-\\d{2}-\\d{2})(?:\\s(\\d{1,2}:\\d{2}(:\\d{2})?)?(?:\\.(\\d+))?$)");
            matcher = ptn.matcher(strTmp);
            match = new ArrayList<String>(3);
            ** while (matcher.find())
        }
lbl-1000:
        // 1 sources

        {
            gc = matcher.groupCount();
            if (gc <= 1) continue;
            t = 1;
            while (t < gc) {
                match.add(matcher.group(t));
                ++t;
            }
            continue;
        }
lbl67:
        // 1 sources

        if (match.size() < 2 || Functions.isEmpty(match.get(1))) {
            match.add("00:00:00");
        } else if (match.size() < 3 || Functions.isEmpty(match.get(2))) {
            match.set(2, String.valueOf((String)match.get(2)) + ":00");
        }
        s = ((String)match.get(0)).split("-");
        monthMap = month;
        for (Map.Entry<K, V> entry : monthMap.entrySet()) {
            key = (String)entry.getKey();
            value = (Integer)entry.getValue();
            if (value != Functions.parseInt(s[1]) - 1) continue;
            s[1] = key;
            break;
        }
        s2 = -1;
        try {
            s2 = Functions.parseInt(s[2]);
        }
        catch (Throwable var17_20) {
            // empty catch block
        }
        year = -1;
        try {
            year = Functions.parseInt(s[0]);
        }
        catch (Throwable key) {
            // empty catch block
        }
        s[0] = year >= 0 && year <= 69 ? "20" + (year < 10 ? "0" + s[0] : s[0]) : (year >= 70 && year <= 99 ? "19" + s[0] : s[0]);
        ds = String.valueOf(s[2]) + " " + s[1] + " " + s[0] + " " + (String)match.get(1) + (s2 > -1 ? String.valueOf(s2 / 1000) : "");
        return Functions.strtotime(ds);
    }

    private static boolean process(String[] m, Date now, HashMap<String, Integer> days, HashMap<String, Integer> month) {
        boolean ago = m.length > 2 && !Functions.isEmpty(m[2]) && m[2].equals("ago");
        int num = m[0].equals("last") ? -1 : 1;
        num = num * (ago ? -1 : 1);
        if (m[0].equals("last") || m[0].equals("next")) {
            String tc = m[1].substring(0, 3);
            if (tc.equals("yea")) {
                now.setYear(now.getYear() + num);
            } else if (tc.equals("mon")) {
                now.setMonth(now.getMonth() + num);
            } else if (tc.equals("wee")) {
                now.setDate(now.getDate() + num * 7);
            } else if (tc.equals("day")) {
                now.setDate(now.getDate() + num);
            } else if (tc.equals("hou")) {
                now.setHours(now.getHours() + num);
            } else if (tc.equals("min")) {
                now.setMinutes(now.getMinutes() + num);
            } else if (tc.equals("sec")) {
                now.setSeconds(now.getSeconds() + num);
            } else {
                Object dayObj = Functions.gv(days, tc);
                if (dayObj != null) {
                    int day = (Integer)dayObj;
                    int diff = day - now.getDay();
                    if (diff == 0) {
                        diff = 7 * num;
                    } else if (diff > 0) {
                        if (m[0].equals("last")) {
                            diff -= 7;
                        }
                    } else if (m[0].equals("next")) {
                        diff += 7;
                    }
                    now.setDate(now.getDate() + diff);
                }
            }
        } else if (m[0].matches(")/\\d+/")) {
            num *= Functions.parseInt(m[0]);
            String tc = m[1].substring(0, 3);
            if (tc.equals("yea")) {
                now.setYear(now.getYear() + num);
            } else if (tc.equals("mon")) {
                now.setMonth(now.getMonth() + num);
            } else if (tc.equals("wee")) {
                now.setDate(now.getDate() + num * 7);
            } else if (tc.equals("day")) {
                now.setDate(now.getDate() + num);
            } else if (tc.equals("hou")) {
                now.setHours(now.getHours() + num);
            } else if (tc.equals("min")) {
                now.setMinutes(now.getMinutes() + num);
            } else if (tc.equals("sec")) {
                now.setSeconds(now.getSeconds() + num);
            }
        } else {
            return false;
        }
        return true;
    }

    public static Object get_first_value(Map<?, ?> hm) {
        if (hm == null) {
            return null;
        }
        if (hm.size() == 0) {
            return null;
        }
        Object value = null;
        Map.Entry<?, ?> entry = hm.entrySet().iterator().next();
        String firstKey = (String)entry.getKey();
        value = hm.get(firstKey);
        return value;
    }

    public static Object array_shift(Map<?, ?> hm) {
        if (hm == null) {
            return null;
        }
        if (hm.size() == 0) {
            return null;
        }
        Object value = null;
        Map.Entry<?, ?> entry = hm.entrySet().iterator().next();
        String firstKey = (String)entry.getKey();
        value = hm.get(firstKey);
        hm.remove(firstKey);
        return value;
    }

    public static Object array_shift(ArrayList<?> arr) {
        if (arr == null) {
            return null;
        }
        if (arr.size() == 0) {
            return null;
        }
        Object value = arr.get(0);
        arr.remove(0);
        return value;
    }

    public static void array_push(ArrayList<?> arr, Object obj) {
        if (arr == null) {
            return;
        }
        ArrayList<?> arr2 = arr;
        arr2.add(obj);
    }

    public static void array_push(Map<?, ?> map, Object obj) {
        if (map == null) {
            return;
        }
        Map<?, ?> tmpMap = map;
        tmpMap.put(String.valueOf(map.size()), obj);
    }

    public static Object array_pop(Map<?, ?> arr) {
        if (arr == null) {
            return null;
        }
        if (arr.size() == 0) {
            return null;
        }
        Map<?, ?> tmpMap = arr;
        String key = null;
        for (Map.Entry<?, ?> entry : tmpMap.entrySet()) {
            key = entry.getKey().toString();
        }
        Object obj = arr.get(key);
        arr.remove(key);
        return obj;
    }

    public static boolean array_unshift(LinkedHashMap<String, Object> arr, Object obj) {
        return Functions.array_unshift(arr, obj, "0");
    }

    public static boolean array_unshift(LinkedHashMap<String, Object> arr, Object obj, String key) {
        if (arr == null) {
            return false;
        }
        LinkedHashMap<String, Object> tmpMap = new LinkedHashMap<String, Object>();
        tmpMap.putAll(arr);
        arr.clear();
        arr.put(key, obj);
        arr.putAll(tmpMap);
        arr = tmpMap;
        return true;
    }

    public static boolean array_unshift(List<?> lst, Object obj) {
        if (lst == null) {
            return false;
        }
        List<?> lst2 = lst;
        lst2.add(0, obj);
        return true;
    }

    public static Object array_pop(ArrayList<?> arr) {
        if (arr == null) {
            return null;
        }
        if (arr.size() == 0) {
            return null;
        }
        int arrCount = arr.size();
        int index = arrCount - 1;
        Object obj = arr.get(index);
        arr.remove(index);
        return obj;
    }

    public static boolean is_object(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            return false;
        }
        if (obj instanceof Long) {
            return false;
        }
        if (obj instanceof Double) {
            return false;
        }
        if (obj instanceof Integer) {
            return false;
        }
        if (obj instanceof Boolean) {
            return false;
        }
        if (obj instanceof Float) {
            return false;
        }
        if (obj instanceof Character) {
            return false;
        }
        if (obj instanceof ArrayList) {
            return false;
        }
        if (obj instanceof Map) {
            return false;
        }
        if (obj instanceof HashMap) {
            return false;
        }
        return !(obj instanceof LinkedHashMap);
    }

    public static boolean is_null(Object obj) {
        return obj == null;
    }

    public static boolean is_string(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof String;
    }

    public boolean fill(Object obj, Map<String, Object> hm) {
        if (obj == null || hm == null) {
            return false;
        }
        return Reflection.fill(obj, hm);
    }

    public static String trim(String s) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    public static boolean property_exists(Object o, String field) {
        if (o == null || field == null) {
            return false;
        }
        return Reflection.property_exists(o, field);
    }

    public static void parse_str(String string, LinkedHashMap<String, Object> hm) {
        if (hm == null) {
            return;
        }
        if (string == null) {
            return;
        }
        String[] stuff = string.contains("&amp;") ? string.split("&amp;") : string.split("&");
        int i = 0;
        while (i < stuff.length) {
            String part = stuff[i];
            if (part.contains("=")) {
                String[] split = part.split("=");
                try {
                    hm.put(URLDecoder.decode(split[0], "UTF-8"), URLDecoder.decode(split[1], "UTF-8"));
                }
                catch (Throwable e) {
                    hm.clear();
                    return;
                }
            }
            ++i;
        }
    }

    public static double strval(String str) {
        if (str == null) {
            return 0.0;
        }
        try {
            return Double.valueOf(str);
        }
        catch (Throwable e) {
            return 0.0;
        }
    }

    public static int strlen(String str) {
        if (str == null) {
            return 0;
        }
        return str.length();
    }

    public static int count(String str) {
        if (str == null) {
            return 0;
        }
        return str.length();
    }

    public static int count(List<?> arr) {
        if (arr == null) {
            return 0;
        }
        return arr.size();
    }

    public static int count(Map<?, ?> hm) {
        if (hm == null) {
            return 0;
        }
        return hm.size();
    }

    public static int count(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof LinkedHashMap) {
            LinkedHashMap objHM = (LinkedHashMap)obj;
            return objHM.size();
        }
        if (obj instanceof ArrayList) {
            ArrayList objAR = (ArrayList)obj;
            return objAR.size();
        }
        if (obj instanceof String) {
            String objStr = obj.toString();
            return objStr.length();
        }
        return 0;
    }

    public static int count(String[] str) {
        return str.length;
    }

    public static int count(int[] intArr) {
        return intArr.length;
    }

    public static String[] explodeSA(String split, String str) {
        if (split == null || str == null) {
            return new String[0];
        }
        return Functions.explodeSA(split, str, 0);
    }

    public static String[] explodeSA(String split, String str, int limit) {
        if (split == null || str == null) {
            return new String[0];
        }
        String[] data = str.split(Pattern.quote(split), limit);
        if (str.endsWith(split)) {
            String[] newData = new String[data.length + 1];
            System.arraycopy(data, 0, newData, 0, data.length);
            return newData;
        }
        return data;
    }

    /*
     * Unable to fully structure code
     */
    public static ArrayList<String> explode(String split, String str, int limit) {
        output = new ArrayList<String>();
        if (str == null) {
            return output;
        }
        if (split == null) {
            output.add(str);
            return output;
        }
        pos = 0;
        newpos = str.length();
        divLen = split.length();
        newpos = str.indexOf(split);
        if (newpos != -1) ** GOTO lbl21
        output.add(str);
        return output;
lbl-1000:
        // 1 sources

        {
            output.add(str.substring(pos, newpos));
            pos = newpos + divLen;
            if (pos > str.length() || limit > 0 && output.size() == limit - 1) break;
            newpos = str.indexOf(split, pos);
lbl21:
            // 2 sources

            ** while (newpos > -1)
        }
lbl22:
        // 2 sources

        output.add(str.substring(pos));
        return output;
    }

    public static ArrayList<String> explodeRegEx(String split, String str, int limit) {
        ArrayList<String> output = new ArrayList<String>();
        if (str == null) {
            return output;
        }
        if (split == null) {
            output.add(str);
            return output;
        }
        String[] data = str.split(split, limit);
        output.addAll(Arrays.asList(data));
        if (str.endsWith(split)) {
            output.add("");
        }
        return output;
    }

    public static ArrayList<String> explode(String split, String str) {
        return Functions.explode(split, str, 0);
    }

    public static String implode(String delimiter, List<?> arlist) {
        if (arlist == null) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder arlstTostr = new StringBuilder();
        if (arlist.size() > 0) {
            arlstTostr.append(Functions.nn(arlist.get(0)));
            int i = 1;
            while (i < arlist.size()) {
                arlstTostr.append(delimiter);
                arlstTostr.append(Functions.nn(arlist.get(i)));
                ++i;
            }
        }
        return arlstTostr.toString();
    }

    public static String substr(String str, int start) {
        if (str == null) {
            str = "";
        }
        if (start > str.length()) {
            return null;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        return str.substring(start);
    }

    public static String substr(String str, int start, int length) {
        String substring;
        if (str == null) {
            return "";
        }
        if (length == 0) {
            return "";
        }
        if (str == "") {
            return "";
        }
        if (start > str.length()) {
            return null;
        }
        int startpos = start;
        int endpos = str.length();
        if (startpos < 0) {
            startpos = str.length() + startpos;
        }
        if (startpos > str.length()) {
            return "";
        }
        endpos = length < 0 ? (endpos += length) : startpos + length;
        if (endpos > str.length()) {
            endpos = str.length();
        }
        try {
            substring = str.substring(startpos, endpos);
        }
        catch (Throwable e) {
            return "";
        }
        return substring;
    }

    public static int strpos(String str, String contains) {
        if (str == null) {
            return -1;
        }
        if (contains == null) {
            return -1;
        }
        Integer pos = str.indexOf(contains);
        return pos;
    }

    public static String str_replace(String[] a, String[] d, String src) {
        if (a.length != d.length && d.length > 1) {
            return src;
        }
        int i = 0;
        while (i < a.length) {
            src = d.length == 1 ? Functions.str_replace(a[i], d[0], src) : Functions.str_replace(a[i], d[i], src);
            ++i;
        }
        return src;
    }

    /*
     * Unable to fully structure code
     */
    public static String str_replace(String s, String d, String src) {
        if (src == null || s == null || d == null) {
            return "";
        }
        sLen = s.length();
        pos = src.indexOf(s);
        if (pos != -1) ** GOTO lbl10
        return src;
lbl-1000:
        // 1 sources

        {
            src = String.valueOf(src.substring(0, pos)) + d + src.substring(pos + sLen);
            pos = src.indexOf(s, pos + d.length());
            if (s.equals("")) break;
lbl10:
            // 2 sources

            ** while (pos > -1)
        }
lbl11:
        // 2 sources

        return src;
    }

    public static String str_replace(ArrayList<?> a, String d, String src) {
        if (src == null) {
            return "";
        }
        int i = 0;
        while (i < a.size()) {
            String s;
            Object o = a.get(i);
            try {
                s = o.toString();
            }
            catch (Throwable e) {
                s = "";
            }
            src = Functions.str_replace(s, d, src);
            ++i;
        }
        return src;
    }

    public static int stripos(String str, String contains) {
        if (str == null) {
            str = "";
        }
        return Functions.strpos(str.toLowerCase(), contains.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashMap<String, Object> array_flip(Map<String, Object> hm) {
        LinkedHashMap<String, Object> newhm = new LinkedHashMap<String, Object>();
        if (hm == null) {
            return newhm;
        }
        Map<String, Object> map = hm;
        synchronized (map) {
            for (Map.Entry<String, Object> entry : hm.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                String valueStr = "";
                try {
                    if (value != null) {
                        valueStr = value.toString();
                    }
                    newhm.put(valueStr, key);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return newhm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<?> array_keys(Map<?, ?> m) {
        if (m == null) {
            return new ArrayList();
        }
        ArrayList<Object> output = new ArrayList();
        Map<?, ?> map = m;
        synchronized (map) {
            Set<?> keys;
            Set<?> set = keys = m.keySet();
            synchronized (set) {
                output = new ArrayList(keys);
            }
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> array_keys_string(Map<?, ?> m) {
        if (m == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> output = new ArrayList<String>();
        Map<?, ?> map = m;
        synchronized (map) {
            Set<?> keys;
            Set<?> set = keys = m.keySet();
            synchronized (set) {
                for (Object key : keys) {
                    output.add(key.toString());
                }
            }
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> array_values_string(Map<?, ?> m) {
        ArrayList<String> output = new ArrayList<String>();
        if (m == null) {
            return output;
        }
        int i = 0;
        Map<?, ?> map = m;
        synchronized (map) {
            for (Map.Entry<?, ?> entry : m.entrySet()) {
                Object value = entry.getValue();
                output.add(i, value.toString());
                ++i;
            }
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Object> array_values(Map<?, ?> m) {
        ArrayList<Object> output = new ArrayList<Object>();
        if (m == null) {
            return output;
        }
        int i = 0;
        Map<?, ?> map = m;
        synchronized (map) {
            for (Map.Entry<?, ?> entry : m.entrySet()) {
                Object value = entry.getValue();
                output.add(i, value);
                ++i;
            }
        }
        return output;
    }

    public static ArrayList<Integer> array_keys(ArrayList<?> arr) {
        ArrayList<Integer> output = new ArrayList<Integer>();
        if (arr == null) {
            return output;
        }
        int count = arr.size();
        int i = 0;
        while (i < count) {
            output.add(new Integer(i));
            ++i;
        }
        return output;
    }

    public static void echo(String str) {
        System.out.println(str);
    }

    public static LinkedHashMap<String, Object> get_object_vars(Object obj) {
        if (obj == null) {
            return new LinkedHashMap<String, Object>();
        }
        return Reflection.get_object_vars(obj);
    }

    public static String strtoupper(String s) {
        if (s == null) {
            return "";
        }
        return s.toUpperCase();
    }

    public static String strtolower(String s) {
        if (s == null) {
            return "";
        }
        return s.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean class_exists(String classname, boolean loadClass) {
        if (classes.contains(classname)) {
            return true;
        }
        if (noClasses.contains(classname)) {
            return false;
        }
        boolean exists = false;
        List<String> list = classes;
        synchronized (list) {
            if (!classes.contains(classname) && !noClasses.contains(classname)) {
                try {
                    Class<?> c = Class.forName(Reflection.cn(classname));
                    classes.add(classname);
                    exists = true;
                }
                catch (Throwable e) {
                    noClasses.add(classname);
                    exists = false;
                }
            } else {
                if (classes.contains(classname)) {
                    exists = true;
                }
                if (noClasses.contains(classname)) {
                    exists = false;
                }
            }
        }
        return exists;
    }

    public static LinkedHashMap<String, Object> array_change_key_case(Map<String, Object> hm, String upperLower) {
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        if (hm == null) {
            return output;
        }
        if (upperLower == null) {
            upperLower = "LOWER";
        }
        for (Map.Entry<String, Object> entry : hm.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key == null) {
                output.put(key, value);
                continue;
            }
            if (upperLower.equals("LOWER")) {
                output.put(key.toLowerCase(), value);
                continue;
            }
            output.put(key.toUpperCase(), value);
        }
        return output;
    }

    public static double mt() {
        return Double.valueOf(System.nanoTime()) / 1.0E9;
    }

    public static void writeLogEntry(String str) {
    }

    public static void dr_echo(String string) {
        Functions.dr_echo(string, false);
    }

    public static void dr_echo(String string, boolean flush) {
        if (output == null) {
            output = new ArrayList();
        }
        switch (LOG_METHOD) {
            case ECHO: {
                Functions.echo(string);
                if (!flush) break;
                System.out.flush();
                break;
            }
            case LOG: {
                Functions.writeLogEntry(string);
                break;
            }
            case BUFFER: {
                output.add(string);
                if (output.size() <= 10 && !flush) break;
                Functions.echo(Functions.implode("", output));
                output.clear();
            }
        }
    }

    public static boolean in(String needle, String uAgent) {
        return Functions.in(needle, uAgent, false);
    }

    public static boolean in(String needle, String uAgent, boolean toLower) {
        if (needle == null) {
            return false;
        }
        if (uAgent == null) {
            return false;
        }
        if (toLower) {
            needle = needle.toLowerCase();
            uAgent = uAgent.toLowerCase();
        }
        return uAgent.contains(needle);
    }

    public static boolean like(String str1, String str2) {
        if (str1 == null) {
            return false;
        }
        if (str2 == null) {
            return false;
        }
        if (str2.endsWith("*")) {
            str2 = str2.substring(0, str2.length() - 1);
        }
        str1 = str1.toLowerCase();
        str2 = str2.toLowerCase();
        return str1.startsWith(str2);
    }

    public static LinkedHashMap<String, Object> gvHashSO(LinkedHashMap<String, Object> array, String key) {
        if (array == null) {
            return new LinkedHashMap<String, Object>();
        }
        Object retObj = Functions.gv(array, key);
        LinkedHashMap hm = new LinkedHashMap();
        if (retObj instanceof LinkedHashMap) {
            try {
                hm = (LinkedHashMap)retObj;
            }
            finally {
                return hm;
            }
        }
        if (retObj != null) {
            Functions.array_push(hm, retObj);
        }
    }

    public static LinkedHashMap<Object, Object> gvHashOO(LinkedHashMap<String, Object> array, String key) {
        Object retObj = Functions.gv(array, key);
        LinkedHashMap hm = new LinkedHashMap();
        if (retObj instanceof LinkedHashMap) {
            try {
                hm = (LinkedHashMap)retObj;
            }
            finally {
                return hm;
            }
        }
        if (retObj != null) {
            Functions.array_push(hm, retObj);
        }
    }

    public static String gvString(Map<?, ?> array, String key) {
        return Functions.gvString(array, key, "");
    }

    public static long gvLong(Map<?, ?> array, String key, long defLong) {
        if (array == null || key == null) {
            return 0L;
        }
        Object retObj = Functions.gv(array, key);
        if (retObj == null) {
            return defLong;
        }
        long retLng = 0L;
        try {
            retLng = Long.parseLong(retObj.toString());
        }
        catch (Throwable e) {
            retLng = defLong;
        }
        return retLng;
    }

    public static String gvString(Map<?, ?> array, String key, String defValue) {
        if (array == null || key == null) {
            return "";
        }
        Object retObj = Functions.gv(array, key, defValue);
        String retStr = "";
        try {
            retStr = String.valueOf(retObj);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retStr;
    }

    public static Object gv(Map<?, ?> array, String key) {
        return Functions.gv(array, key, null);
    }

    public static Object gv(Map<?, ?> array, String key, Object defaultVal) {
        if (array == null) {
            return defaultVal;
        }
        if (array.size() == 0) {
            return defaultVal;
        }
        if (array.containsKey(key)) {
            return array.get(key);
        }
        return defaultVal;
    }

    public static byte[] gzencode(String inputString) {
        if (inputString == null) {
            inputString = "";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] content = inputString.getBytes("UTF-8");
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gzipOutputStream.write(content);
            gzipOutputStream.close();
        }
        catch (Throwable e) {
            return new byte[0];
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] gzdecode(String inputString) {
        byte[] input;
        if (inputString == null) {
            return new byte[0];
        }
        try {
            input = inputString.getBytes("UTF-8");
        }
        catch (Throwable e) {
            return new byte[0];
        }
        return Functions.gzdecode(input);
    }

    public static byte[] gzdecode(byte[] input) {
        byte[] output;
        int buffSize = 8192;
        byte[] tempBuffer = new byte[8192];
        try {
            int size;
            ByteArrayInputStream in = new ByteArrayInputStream(input);
            GZIPInputStream gz = new GZIPInputStream(in);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((size = gz.read(tempBuffer, 0, 8192)) != -1) {
                baos.write(tempBuffer, 0, size);
            }
            output = baos.toByteArray();
            baos.close();
            gz.close();
            ((InputStream)in).close();
        }
        catch (Throwable e) {
            return null;
        }
        return output;
    }

    public static String gz(Object object) {
        String objStr = !(object instanceof String) ? Functions.serialize(object) : (String)object;
        byte[] compBytes = Functions.gzencode(objStr);
        String envStr = Functions.base64_encode(compBytes);
        return envStr;
    }

    public static String base64_encode(String string) {
        byte[] bytes;
        if (string == null) {
            return "";
        }
        try {
            bytes = string.getBytes("UTF-8");
        }
        catch (Throwable e) {
            return "";
        }
        return Functions.base64_encode(bytes);
    }

    public static String base64_encode(byte[] bytes) {
        String string;
        Base64 b64 = new Base64();
        try {
            string = b64.encodeToString(bytes);
        }
        catch (Throwable e) {
            return "";
        }
        return string;
    }

    public static String base64_decodeStr(String string) {
        byte[] result = Functions.base64_decode(string);
        try {
            return new String(result, "UTF-8");
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static byte[] base64_decode(String string) {
        byte[] byt;
        Base64 b64 = new Base64();
        try {
            byte[] inputByt = string.getBytes("UTF-8");
            byt = b64.decode(inputByt);
            if (byt.length == 0) {
                return byt;
            }
        }
        catch (Throwable e) {
            return new byte[0];
        }
        return byt;
    }

    public static String json_encode(Object object) {
        return new String();
    }

    public static Object json_decode(String string) {
        return new Object();
    }

    public static String gz_json(Object object) {
        String objString = Functions.json_encode(object);
        byte[] objBytes = Functions.gzencode(objString);
        String output = Functions.base64_encode(objBytes);
        return output;
    }

    public static Object ungz(String string) {
        String dcmp;
        byte[] byt;
        if (string == null) {
            return null;
        }
        if (PHPSerializer.isSerialized(string)) {
            return Functions.unserialize(string);
        }
        try {
            byt = Functions.base64_decode(string);
            byt = Functions.gzdecode(byt);
        }
        catch (Throwable e) {
            return "";
        }
        if (byt == null) {
            return null;
        }
        if (byt.length < 2) {
            return null;
        }
        try {
            dcmp = new String(byt, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            return null;
        }
        if (!PHPDeserializer.isSerialized(dcmp)) {
            return dcmp;
        }
        Object newObj = Functions.unserialize(byt);
        if (newObj instanceof PhpObject) {
            PhpObject phpo = (PhpObject)newObj;
            newObj = phpo.getRealObject();
        }
        if (newObj == null) {
            return dcmp;
        }
        return newObj;
    }

    public static String serialize(Object o) {
        return PHPSerializer.serialize(o);
    }

    public static Object unserialize(byte[] objBytes) {
        return PHPDeserializer.unserialize(objBytes);
    }

    public static Object unserialize(String objString) {
        byte[] objBytes = new byte[]{};
        try {
            objBytes = objString.getBytes("UTF-8");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (objBytes.length == 0) {
            return null;
        }
        return PHPDeserializer.unserialize(objBytes);
    }

    public static Object ungz_json(String string) {
        return new Object();
    }

    public static boolean is_numeric(String str) {
        if (str == null || str.equals("")) {
            return false;
        }
        NumberFormat formatter = NumberFormat.getInstance();
        ParsePosition pos = new ParsePosition(0);
        formatter.parse(str, pos);
        return str.length() == pos.getIndex();
    }

    public static boolean is_numeric(Object obj) {
        if (obj instanceof Long) {
            return true;
        }
        if (obj instanceof Integer) {
            return true;
        }
        if (obj instanceof Float) {
            return true;
        }
        if (obj instanceof Double) {
            return true;
        }
        if (obj instanceof Byte) {
            return true;
        }
        return Functions.is_numeric(obj.toString());
    }

    public static String strToXMLKeySafe(String str) {
        if (str == null) {
            return "";
        }
        if (Functions.is_numeric(str)) {
            str = String.valueOf('a') + str;
        } else if (Functions.is_numeric(Functions.substr(str, 0, 1))) {
            str = str.replaceAll("/^(\\d*)/", "");
        }
        return str;
    }

    public static String utf8_encode(String str) {
        try {
            byte[] byt = str.getBytes("ISO-8859-1");
            str = new String(byt, "UTF-8");
        }
        catch (Throwable e) {
            str = "";
        }
        return "";
    }

    public static String strToXMLSafe(String str) {
        return Functions.strToXMLSafe(str, true);
    }

    public static String strToXMLSafe(String str, boolean utf8) {
        if (str == null) {
            return "";
        }
        String[] searchArray = new String[]{"&", "<", ">", "'", "\""};
        String[] replaceArray = new String[]{"&amp;", "&lt;", "&gt;", "&apos;", "&quot;"};
        str = Functions.str_replace(searchArray, replaceArray, str);
        str = Functions.str_replace("&amp;quot;", "&quot;", str);
        if (utf8) {
            str = Functions.utf8_encode(str);
        }
        return str;
    }

    public static String array_isearch(Object obj, Map<?, ?> array) {
        if (obj == null || array == null) {
            return null;
        }
        for (Map.Entry<?, ?> entry : array.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!Functions.isEqual(obj, value, true)) continue;
            return key;
        }
        return null;
    }

    public static String array_isearch(Object obj, List<?> lst) {
        if (lst == null || obj == null) {
            return null;
        }
        int i = 0;
        while (i < lst.size()) {
            Object value = lst.get(i);
            if (Functions.isEqual(obj, value, true)) {
                return String.valueOf(i);
            }
            ++i;
        }
        return null;
    }

    public static String cleanURL(String url) {
        if (Functions.isEmpty(url)) {
            return "";
        }
        ArrayList<String> tmp = Functions.explode(", ", url);
        url = tmp.get(0);
        if (tmp.size() == 2 && Functions.strlen(tmp.get(1)) < 4) {
            url = String.valueOf(url) + "," + tmp.get(1);
        }
        ArrayList<String> replace = new ArrayList<String>();
        replace.add("\n");
        replace.add("\r");
        replace.add("\\");
        replace.add("\"");
        url = Functions.str_replace(replace, "", url);
        url = url.trim();
        if (Functions.strlen(url) < 4) {
            return "";
        }
        String prefix = url.substring(0, 4);
        if (prefix.equals("wap.") || prefix.equals("uapr") || prefix.equals("www.")) {
            url = new String("http://").concat(url);
        }
        if (!Functions.substr(url, 0, 4).equals("http")) {
            url = "";
        }
        return url;
    }

    public static String punctClean(String string) {
        if (string == null) {
            return "";
        }
        String clean = string.replaceAll("[\\s-_/*]", "");
        clean = clean.replace("[", "");
        clean = clean.replace("]", "");
        clean = clean.replace(",", "");
        clean = clean.replace("?", "");
        clean = clean.replace("!", "");
        clean = clean.replace("&", "");
        clean = clean.replace("@", "");
        clean = clean.replace("#", "");
        clean = clean.replace("'", "");
        clean = clean.replace("=", "");
        clean = clean.replace(">", "");
        clean = clean.replace("<", "");
        clean = clean.replace("{", "");
        clean = clean.replace("}", "");
        clean = clean.replace("|", "");
        clean = clean.replace("%", "");
        clean = clean.replace("\\", "");
        clean = clean.replace("$", "");
        String ptn = "#[^\\;\\-\\)\\(\\d\\w\\/\\n\\r:.]#";
        clean = clean.replaceAll(ptn, "");
        return clean;
    }

    public static boolean is_array(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Map) {
            return true;
        }
        if (object instanceof LinkedHashMap) {
            return true;
        }
        if (object instanceof HashMap) {
            return true;
        }
        if (object instanceof ArrayList) {
            return true;
        }
        return object instanceof List;
    }

    public static String today() {
        return "";
    }

    public static boolean is_map(Map<?, ?> map) {
        return true;
    }

    public static boolean is_map(List<?> lst) {
        return false;
    }

    public static boolean is_map(Object obj) {
        if (obj instanceof Map) {
            return true;
        }
        if (obj instanceof HashMap) {
            return true;
        }
        return obj instanceof LinkedHashMap;
    }

    public static boolean is_list(List<?> lst) {
        return true;
    }

    public static boolean is_list(Map<?, ?> map) {
        return false;
    }

    public static boolean is_list(Object obj) {
        if (obj instanceof List) {
            return true;
        }
        return obj instanceof ArrayList;
    }

    public static boolean isEqual(Object val1, Object val2) {
        return Functions.isEqual(val1, val2, false);
    }

    public static boolean isEqual(Object val1, Object val2, boolean ci) {
        if (val1 == null && val2 == null) {
            return true;
        }
        if (val1 == null || val2 == null) {
            return false;
        }
        if (Functions.is_map(val1) && Functions.is_map(val2)) {
            Map tmpMap1 = (Map)val1;
            Map tmpMap2 = (Map)val2;
            return tmpMap1.equals(tmpMap2);
        }
        if (Functions.is_numeric(val1.toString()) && Functions.is_numeric(val2.toString())) {
            try {
                double dbl1 = Double.parseDouble(val1.toString());
                double dbl2 = Double.parseDouble(val2.toString());
                return dbl1 == dbl2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            String val1Str = val1.toString();
            String val2Str = val2.toString();
            if (ci) {
                return val1Str.equalsIgnoreCase(val2Str);
            }
            return val1Str.equals(val2Str);
        }
        catch (Throwable e) {
            return val1.equals(val2);
        }
    }

    public static boolean isEmpty(Object var) {
        Cloneable arrTmp;
        String varStr;
        if (var == null) {
            return true;
        }
        if (var instanceof String && (varStr = (String)var).equals("")) {
            return true;
        }
        if (var instanceof ArrayList) {
            arrTmp = (ArrayList)var;
            return ((ArrayList)arrTmp).size() == 0;
        }
        if (var instanceof LinkedHashMap) {
            arrTmp = (LinkedHashMap)var;
            return ((HashMap)arrTmp).size() == 0;
        }
        return false;
    }

    public static boolean method_exists(String classname, String method) {
        if (Functions.isEmpty(classname)) {
            return false;
        }
        if (Functions.isEmpty(method)) {
            return false;
        }
        return Reflection.method_exists(classname, method);
    }

    public static boolean method_exists(Object object, String method) {
        return Reflection.method_exists(object, method);
    }

    public static Object call_method(Object object, String methodName) {
        Object retObj = null;
        try {
            Class<?> cls = object.getClass();
            Class[] partypes = new Class[]{};
            Method meth = cls.getMethod(methodName, partypes);
            Object[] arglist = new Object[]{};
            retObj = meth.invoke(object, arglist);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retObj;
    }

    public static LinkedHashMap<String, Object> objectToArray(Object object) {
        Object retObj;
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        if (object == null) {
            return data;
        }
        if (Functions.method_exists(object, "toArray") && (retObj = Functions.call_method(object, "toArray")) instanceof LinkedHashMap) {
            return (LinkedHashMap)retObj;
        }
        LinkedHashMap<String, Object> vars = Functions.get_object_vars(object);
        for (Map.Entry entry : vars.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map valueMap = (Map)value;
                data.put(key, Functions.processArray(valueMap));
                continue;
            }
            if (Functions.is_string(value)) {
                data.put(key, value);
                continue;
            }
            if (Functions.is_object(value)) {
                if (!Functions.method_exists(value, "toArray")) {
                    data.put(key, Functions.objectToArray(value));
                    continue;
                }
                Object retObj2 = Functions.call_method(value, "toArray");
                if (!(retObj2 instanceof LinkedHashMap)) continue;
                data.put(key, (LinkedHashMap)retObj2);
                continue;
            }
            data.put(key, value);
        }
        return data;
    }

    public static LinkedHashMap<String, Object> processArray(Map<String, Object> array) {
        LinkedHashMap<String, Object> retArr = new LinkedHashMap<String, Object>();
        if (array == null) {
            return retArr;
        }
        for (Map.Entry<String, Object> entry : array.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map valueMap = (Map)value;
                retArr.put(key, Functions.processArray(valueMap));
                continue;
            }
            if (Functions.is_object(value) && !Functions.is_string(value)) {
                if (!Functions.method_exists(value, "toArray")) {
                    retArr.put(key, Functions.objectToArray(value));
                    continue;
                }
                Object retObj = Functions.call_method(value, "toArray");
                if (!(retObj instanceof LinkedHashMap)) continue;
                retArr.put(key, retObj);
                continue;
            }
            retArr.put(key, value);
        }
        return retArr;
    }

    public static boolean array_in_search(String needle, Map<String, Object> haystack) {
        if (needle == null) {
            return false;
        }
        if (haystack == null) {
            return false;
        }
        String value = "";
        for (Map.Entry<String, Object> entry : haystack.entrySet()) {
            try {
                value = (String)entry.getValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!value.matches(needle)) continue;
            return true;
        }
        return false;
    }

    public static Object array_search(Object needle, Map<?, ?> haystack) {
        if (haystack == null) {
            return null;
        }
        if (needle == null) {
            return null;
        }
        Object retObj = null;
        Set<?> keySet = haystack.keySet();
        for (Object key : keySet) {
            Object value = haystack.get(key);
            if (!value.equals(needle)) continue;
            retObj = key;
        }
        return retObj;
    }

    public static ArrayList<String> arrayToTextArray(Map<String, Object> array) {
        return Functions.arrayToTextArray(array, "");
    }

    public static ArrayList<String> arrayToTextArray(String string) {
        ArrayList<String> array = new ArrayList<String>();
        array.add(string);
        return array;
    }

    public static ArrayList<String> arrayToTextArray(Map<String, Object> array, String baseKey) {
        if (array == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> description = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : array.entrySet()) {
            Cloneable valueArr;
            String key = Functions.nn(entry.getKey());
            Object value = entry.getValue();
            if (value == null) {
                value = "";
            }
            if (!Functions.isEmpty(baseKey)) {
                key = String.valueOf(baseKey) + "_" + key;
            }
            if (value instanceof LinkedHashMap) {
                valueArr = (LinkedHashMap)value;
                description.addAll(Functions.arrayToTextArray(valueArr, String.valueOf(key) + "_"));
                continue;
            }
            if (value instanceof ArrayList) {
                valueArr = (ArrayList)value;
                LinkedHashMap<String, Object> valueHM = Functions.arrayListToLinkedHashMap(valueArr);
                description.addAll(Functions.arrayToTextArray(valueHM, String.valueOf(key) + "_"));
                continue;
            }
            description.add(String.valueOf(key) + "=" + value);
        }
        return description;
    }

    public static LinkedHashMap<String, Object> arrayListToLinkedHashMap(ArrayList<?> arr) {
        if (arr == null) {
            return new LinkedHashMap<String, Object>();
        }
        int i = 0;
        LinkedHashMap<String, Object> hm = new LinkedHashMap<String, Object>();
        for (Object value : arr) {
            hm.put(String.valueOf(i), value);
            ++i;
        }
        return hm;
    }

    public static String replaceSize(String dp) {
        LinkedHashMap<String, String> sizeMap = new LinkedHashMap<String, String>();
        if (dp == null) {
            return "";
        }
        sizeMap.put("whuxga", "7680x4800");
        sizeMap.put("whsxga", "6400x4096");
        sizeMap.put("wquxga", "3840x2400");
        sizeMap.put("wqsxga", "3200x2048");
        sizeMap.put("wsxga+", "1680x1050");
        sizeMap.put("sqcif", "128x96");
        sizeMap.put("wqvga", "240x400");
        sizeMap.put("qqvga", "120x160");
        sizeMap.put("hqvga", "240x160");
        sizeMap.put("fwvga", "480x854");
        sizeMap.put("wsvga", "1024x576");
        sizeMap.put("wuxga", "1920x1200");
        sizeMap.put("1020i", "1920x1020");
        sizeMap.put("1080p", "1920x1020");
        sizeMap.put("qwxga", "2048x1152");
        sizeMap.put("wqxga", "2560x1600");
        sizeMap.put("qsxga", "2560x2048");
        sizeMap.put("quxga", "3200x2400");
        sizeMap.put("whxga", "5120x3200");
        sizeMap.put("hsxga", "5120x4096");
        sizeMap.put("huxga", "6400x4800");
        sizeMap.put("wxga+", "1440x900");
        sizeMap.put("sxga+", "1400x1050");
        sizeMap.put("qcif", "176x220");
        sizeMap.put("svga", "800x600");
        sizeMap.put("wvga", "480x800");
        sizeMap.put("qvga", "240x320");
        sizeMap.put("hvga", "480x320");
        sizeMap.put("dvga", "640x960");
        sizeMap.put("wxga", "1280x768");
        sizeMap.put("xga+", "1152x864");
        sizeMap.put("sxga", "1280x1024");
        sizeMap.put("uxga", "1600x1200");
        sizeMap.put("720p", "1280x720");
        sizeMap.put("wqhd", "2560x1440");
        sizeMap.put("qfhd", "3840x2160");
        sizeMap.put("qxga", "2048x1536");
        sizeMap.put("hxga", "4096x3072");
        sizeMap.put("nhd", "640x360");
        sizeMap.put("qhd", "960x540");
        sizeMap.put("fhd", "1920x1080");
        sizeMap.put("uhd", "7680x4320");
        sizeMap.put("vga", "640x480");
        sizeMap.put("xga", "1024x768");
        sizeMap.put("hd", "1280x720");
        for (Map.Entry entry : sizeMap.entrySet()) {
            String nickname = (String)entry.getKey();
            String dimension = (String)entry.getValue();
            if (Functions.stripos(dp, nickname) <= -1) continue;
            dp = Functions.str_ireplace(nickname, dimension, dp);
        }
        return dp;
    }

    /*
     * Unable to fully structure code
     */
    public static String str_ireplace(String s, String d, String src) {
        if (src == null || s == null || d == null) {
            return "";
        }
        lcSrc = src.toLowerCase();
        lcS = s.toLowerCase();
        sLen = s.length();
        pos = lcSrc.indexOf(lcS);
        if (pos != -1) ** GOTO lbl13
        return src;
lbl-1000:
        // 1 sources

        {
            src = String.valueOf(src.substring(0, pos)) + d + src.substring(pos + sLen);
            lcSrc = String.valueOf(lcSrc.substring(0, pos)) + d + lcSrc.substring(pos + sLen);
            pos = lcSrc.indexOf(lcS, pos + d.length());
            if (s.equals("")) break;
lbl13:
            // 2 sources

            ** while (pos > -1)
        }
lbl14:
        // 2 sources

        return src;
    }

    public static boolean eval(String expression) {
        if (expression == null) {
            return false;
        }
        String[] comparitors = new String[]{"<=", ">=", "<>", "!", ">", "<", "="};
        int i = 0;
        while (i < comparitors.length) {
            if (expression.contains(comparitors[i])) {
                String[] split = expression.split(comparitors[i]);
                return Functions.compares(split[0], split[1], comparitors[i]);
            }
            ++i;
        }
        return false;
    }

    public static boolean is_expression(String expr) {
        if (expr == null) {
            return false;
        }
        return expr.contains("+") || expr.contains(">") || expr.contains("<");
    }

    public static String[] splitFirstDelimiter(String strFragment, String[] delimiters) {
        return Functions.splitFirstDelimiter(strFragment, delimiters, false);
    }

    public static String[] splitFirstDelimiter(String strFragment, String[] delimiters, boolean exact) {
        String description;
        Integer pos;
        if (strFragment == null) {
            strFragment = "";
        }
        if (delimiters == null) {
            return new String[]{strFragment, ""};
        }
        if (delimiters.length == 0) {
            return new String[]{strFragment, ""};
        }
        if (!exact) {
            String[] temp = new String[delimiters.length + 3];
            System.arraycopy(delimiters, 0, temp, 0, delimiters.length);
            temp[delimiters.length] = "Profile";
            temp[delimiters.length + 1] = "Build";
            temp[delimiters.length + 2] = "Configuration";
            delimiters = temp;
        }
        ArrayList<Integer> posArray = new ArrayList<Integer>();
        int i = 0;
        while (i < delimiters.length) {
            String delimiter = delimiters[i];
            pos = strFragment.indexOf(delimiter);
            if (pos > -1) {
                posArray.add(pos);
            }
            ++i;
        }
        Collections.sort(posArray);
        if (posArray.size() == 0) {
            description = strFragment;
            strFragment = "";
        } else {
            pos = (Integer)posArray.get(0);
            description = Functions.substr(strFragment, 0, pos);
            strFragment = Functions.substr(strFragment, pos + 1);
        }
        return new String[]{description, strFragment};
    }

    public static String stringToRegex(String[] delimiters) {
        StringBuffer output = new StringBuffer();
        output.append("(");
        String delim = "";
        int i = 0;
        while (i < delimiters.length) {
            delim = delimiters[i];
            output.append("[");
            output.append(delim);
            output.append("]");
            ++i;
        }
        output.append(")");
        return output.toString();
    }

    public static String[] splitDelimiters(String strFragment, String[] delimiters) {
        if (strFragment == null) {
            return new String[0];
        }
        String regex = Functions.stringToRegex(delimiters);
        String[] output = strFragment.split(regex);
        return output;
    }

    public static boolean is_utf8(String string) {
        if (string == null) {
            return false;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("%^(?:[\\x09\\x0A\\x0D\\x20-\\x7E] | [\\xC2-\\xDF][\\x80-\\xBF]");
        buf.append(" | \\xE0[\\xA0-\\xBF][\\x80-\\xBF] | [\\xE1-\\xEC\\xEE\\xEF][\\x80-\\xBF]{2}");
        buf.append(" | \\xED[\\x80-\\x9F][\\x80-\\xBF] | \\xF0[\\x90-\\xBF][\\x80-\\xBF]{2}");
        buf.append(" | [\\xF1-\\xF3][\\x80-\\xBF]{3} |  \\xF4[\\x80-\\x8F][\\x80-\\xBF]{2})*%xs");
        return string.matches(buf.toString());
    }

    public static boolean isAssociativeArray(ArrayList<?> arr) {
        return false;
    }

    public static boolean isAssociativeArray(Map<String, Object> hm) {
        if (hm == null) {
            return false;
        }
        int r = 0;
        while (r < hm.size()) {
            if (!hm.containsKey(String.valueOf(r))) {
                return true;
            }
            ++r;
        }
        return false;
    }

    public static String round(Double d, int places) {
        String tt = String.format("%." + String.valueOf(places) + "f", d);
        return tt;
    }

    public static long rand(int start, int end) {
        double rnd = Math.random();
        long interval = end - start;
        rnd = rnd * (double)interval + (double)start;
        return Math.round(rnd);
    }

    public static boolean compares(String queryValue, String compareValue, String comparitor) {
        if (queryValue == null || compareValue == null) {
            return false;
        }
        boolean ret = false;
        boolean numeric = false;
        double qd = -1.0;
        double cd = -1.0;
        if (Functions.is_numeric(queryValue) && Functions.is_numeric(compareValue)) {
            try {
                qd = Double.parseDouble(queryValue);
                cd = Double.parseDouble(compareValue);
                numeric = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (numeric) {
            if (comparitor.equals("=")) {
                return qd == cd;
            }
            if (comparitor.equals("<>") || comparitor.equals("!=") || comparitor.equals("!")) {
                return qd != cd;
            }
            if (comparitor.equals(">")) {
                ret = qd > cd;
            } else if (comparitor.equals("<")) {
                ret = qd < cd;
            } else if (comparitor.equals("<=")) {
                ret = qd <= cd;
            } else if (comparitor.equals(">=")) {
                ret = qd >= cd;
            }
        } else {
            int comp = queryValue.compareTo(compareValue);
            if (comparitor.equals("=")) {
                ret = queryValue.equals(compareValue);
            } else if (comparitor.equals("<>") || comparitor.equals("!=") || comparitor.equals("!")) {
                ret = !queryValue.equals(compareValue);
            } else if (comparitor.equals(">")) {
                ret = comp > 0;
            } else if (comparitor.equals("<")) {
                ret = comp < 0;
            } else if (comparitor.equals("<=")) {
                ret = comp <= 0;
            } else if (comparitor.equals(">=")) {
                ret = comp >= 0;
            }
        }
        return ret;
    }

    public static ArrayList<?> Union(ArrayList<?> coll1, ArrayList<?> coll2) {
        LinkedHashSet union = new LinkedHashSet(coll1);
        union.addAll(new LinkedHashSet(coll2));
        return new ArrayList(union);
    }

    public static ArrayList<?> array_unique(ArrayList<?> values) {
        if (values == null) {
            return values;
        }
        if (values.size() == 1) {
            return values;
        }
        return Functions.Union(values, values);
    }

    public static void sort(List<?> list) {
        if (list == null) {
            return;
        }
        Collections.sort(list, objectComparatorASC);
    }

    public static void rsort(List<?> list) {
        if (list == null) {
            return;
        }
        Collections.sort(list, objectComparatorDESC);
    }

    public static void asort(Map map) {
        if (map == null) {
            return;
        }
        Vector list = new Vector(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<?, ?>>(){

            @Override
            public int compare(Map.Entry<?, ?> entry, Map.Entry<?, ?> entry1) {
                Object value = entry.getValue();
                Object value1 = entry1.getValue();
                return Functions.objCompare(value, value1, true);
            }
        });
        map.clear();
        for (Map.Entry entry : list) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static void arsort(Map map) {
        if (map == null) {
            return;
        }
        Vector list = new Vector(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Object, Object>>(){

            @Override
            public int compare(Map.Entry<Object, Object> entry, Map.Entry<Object, Object> entry1) {
                Object value = entry.getValue();
                Object value1 = entry1.getValue();
                return Functions.objCompare(value, value1, false);
            }
        });
        map.clear();
        for (Map.Entry entry : list) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static LinkedHashMap<String, Object> arr2hm(ArrayList<?> arr) {
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        if (arr == null) {
            return output;
        }
        int i = 0;
        while (i < arr.size()) {
            Object obj = arr.get(i);
            if (obj instanceof ArrayList) {
                obj = Functions.arr2hm((ArrayList)obj);
            }
            output.put(String.valueOf(i), obj);
            ++i;
        }
        return output;
    }

    public static void krSortArr(ArrayList arr) {
        if (arr == null) {
            return;
        }
        ArrayList output = new ArrayList();
        int i = arr.size() - 1;
        while (i > -1) {
            output.add(arr.get(i));
            --i;
        }
        arr.clear();
        arr.addAll(output);
    }

    public static void ksort(Map map) {
        if (map == null) {
            return;
        }
        Vector list = new Vector(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Object, Object>>(){

            @Override
            public int compare(Map.Entry<Object, Object> entry, Map.Entry<Object, Object> entry1) {
                Object value = entry.getKey();
                Object value1 = entry1.getKey();
                return Functions.objCompare(value, value1, true);
            }
        });
        map.clear();
        for (Map.Entry entry : list) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static void krsort(Map map) {
        if (map == null) {
            return;
        }
        Vector list = new Vector(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Object, Object>>(){

            @Override
            public int compare(Map.Entry<Object, Object> entry, Map.Entry<Object, Object> entry1) {
                Object value = entry.getKey();
                Object value1 = entry1.getKey();
                return Functions.objCompare(value, value1, false);
            }
        });
        map.clear();
        for (Map.Entry entry : list) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static long inet_pton(String ip) {
        if (ip == null) {
            return -1L;
        }
        String[] tokens = ip.split("\\.");
        if (tokens.length != 4) {
            return -1L;
        }
        try {
            long f1 = Long.parseLong(tokens[0]) << 24;
            long f2 = Long.parseLong(tokens[1]) << 16;
            long f3 = Long.parseLong(tokens[2]) << 8;
            long f4 = Long.parseLong(tokens[3]);
            return f1 + f2 + f3 + f4;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static String inet_ntop(long longValue) {
        StringBuffer ip = new StringBuffer();
        if (longValue < 0L) {
            longValue = (long)((double)longValue + Math.pow(2.0, 32.0));
        }
        int i = 3;
        while (i >= 0) {
            ip.append((int)((double)longValue / Math.pow(256.0, i)));
            longValue = (long)((double)longValue - (double)((int)((double)longValue / Math.pow(256.0, i))) * Math.pow(256.0, i));
            if (i > 0) {
                ip.append(".");
            }
            --i;
        }
        return ip.toString();
    }

    public static ArrayList<String> array(String str) {
        ArrayList<String> arr = new ArrayList<String>();
        arr.add(str);
        return arr;
    }

    public static ArrayList<String> array() {
        return new ArrayList<String>();
    }

    public static String stripslashes(String str) {
        str = str.replace("\\\\", "{c64audio}");
        str = str.replace("\\", "");
        str = str.replace("{c64audio}", "\\");
        return str;
    }

    public static String str_pad(String str, int chars, String pad) {
        return Functions.str_pad(str, chars, pad, STR_PAD.STR_PAD_RIGHT);
    }

    public static String str_pad(String str, int chars, String pad, STR_PAD padType) {
        if (str == null) {
            return "";
        }
        if (Functions.isEmpty(pad)) {
            return str;
        }
        if (str.length() > chars) {
            return str;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(str);
        while (buf.length() < chars) {
            switch (padType) {
                case STR_PAD_RIGHT: {
                    buf.append(pad);
                    break;
                }
                case STR_PAD_LEFT: {
                    buf.insert(0, pad);
                }
            }
        }
        return buf.toString();
    }

    public static List array_chunk(List arr, int page) {
        if (arr == null) {
            return new ArrayList();
        }
        if (page < 1) {
            return arr;
        }
        ArrayList output = new ArrayList();
        int count = 0;
        while (arr.size() > count) {
            int newCount = count + page;
            if (newCount > arr.size()) {
                newCount = arr.size();
            }
            List newArr = arr.subList(count, newCount);
            output.add(newArr);
            count = newCount;
        }
        return output;
    }

    public static boolean deleteFile(String fileName) {
        if (fileName == null) {
            return false;
        }
        File f = new File(fileName);
        if (!f.exists()) {
            return false;
        }
        if (!f.canWrite()) {
            return false;
        }
        if (f.isDirectory()) {
            return false;
        }
        boolean success = f.delete();
        return success;
    }

    public static boolean clearDirectory(File path) {
        if (path == null) {
            return false;
        }
        return Functions.clearDirectory(path, "");
    }

    public static boolean clearDirectory(File path, String filter) {
        if (path == null) {
            return false;
        }
        if (filter == null) {
            filter = "";
        }
        try {
            if (path.exists()) {
                File[] files = path.listFiles();
                int i = 0;
                while (i < files.length) {
                    String name = files[i].getName();
                    if (filter.length() <= 0 || name.contains(filter)) {
                        if (files[i].isDirectory()) {
                            Functions.deleteDirectory(files[i]);
                        } else {
                            files[i].delete();
                        }
                    }
                    ++i;
                }
            }
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean deleteDirectory(File path) {
        if (path == null) {
            return false;
        }
        try {
            if (path.exists()) {
                Functions.clearDirectory(path);
            }
            return path.delete();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean mkdir(String path) {
        if (path == null) {
            return false;
        }
        try {
            boolean success = new File(path).mkdirs();
            return success;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static String nn(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    public static String nn(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static String md5(String str) throws DetectRightException {
        if (str == null) {
            return "";
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(str.getBytes());
            BigInteger n = new BigInteger(1, messageDigest);
            String ht = n.toString(16);
            while (ht.length() < 32) {
                ht = "0" + ht;
            }
            return ht;
        }
        catch (NoSuchAlgorithmException e) {
            throw new DetectRightException("No such algorithm in MD5", e);
        }
    }

    static boolean isNumeric(String var) {
        if (Functions.isEmpty(var)) {
            return false;
        }
        boolean containsNonDigits = var.matches("^(.+)?[^0-9\\.](.+)?$");
        return !containsNonDigits;
    }

    static boolean ctype_digit(Character digit) {
        if (digit == null) {
            return false;
        }
        return Character.isDigit(digit.charValue());
    }

    static boolean isMostlyNumeric(String var) {
        boolean containsNonDigits;
        if (Functions.isEmpty(var)) {
            return false;
        }
        if (Functions.ctype_digit(Character.valueOf(var.charAt(0)))) {
            return true;
        }
        if (Functions.ctype_digit(Character.valueOf(var.charAt(var.length() - 1)))) {
            return true;
        }
        int len = Functions.strlen(var);
        if (len > 2) {
            var = Functions.substr(var, 0, 3);
        }
        return !(containsNonDigits = var.matches("^(.+)?[^0-9\\.](.+)?$"));
    }

    public static ArrayList<String> dpAlign(String str1, String str2) {
        ArrayList<String> output = new ArrayList<String>();
        output.add(str1);
        output.add(str2);
        if (Functions.isEmpty(str1) || Functions.isEmpty(str2)) {
            return output;
        }
        ArrayList<String> tmp1 = Functions.explode(".", str1);
        ArrayList<String> tmp2 = Functions.explode(".", str2);
        int r = -1;
        while (tmp1.size() > ++r && tmp2.size() > r) {
            int len2;
            String part1 = tmp1.get(r);
            String part2 = tmp2.get(r);
            int len1 = Functions.strlen(part1);
            int diff = len1 - (len2 = Functions.strlen(part2));
            if (diff == 0) continue;
            if (diff > 0) {
                tmp2.set(r, Functions.str_pad(part2, len1, "0", STR_PAD.STR_PAD_LEFT));
                continue;
            }
            tmp1.set(r, Functions.str_pad(part1, len2, "0", STR_PAD.STR_PAD_LEFT));
        }
        str1 = Functions.implode(".", tmp1);
        str2 = Functions.implode(".", tmp2);
        output.set(0, str1);
        output.set(1, str2);
        return output;
    }

    public static int parseInt(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("Null string");
        }
        int num = 0;
        int sign = -1;
        int len = s.length();
        if (len == 0) {
            throw new NumberFormatException("Empty String");
        }
        char ch = s.charAt(0);
        if (ch == '-') {
            if (len == 1) {
                throw new NumberFormatException("Missing digits:  " + s);
            }
            sign = 1;
        } else {
            int d = ch - 48;
            if (d < 0 || d > 9) {
                throw new NumberFormatException("Malformed:  " + s);
            }
            num = -d;
        }
        int max = sign == -1 ? -2147483647 : Integer.MIN_VALUE;
        int multmax = max / 10;
        int i = 1;
        while (i < len) {
            int d;
            if ((d = s.charAt(i++) - 48) < 0 || d > 9) {
                throw new NumberFormatException("Malformed:  " + s);
            }
            if (num < multmax) {
                throw new NumberFormatException("Over/underflow:  " + s);
            }
            if ((num *= 10) < max + d) {
                throw new NumberFormatException("Over/underflow:  " + s);
            }
            num -= d;
        }
        return sign * num;
    }

    public static double round(double Rval, int Rpl) {
        double p = Math.pow(10.0, Rpl);
        double tmp = Math.round(Rval *= p);
        return tmp / p;
    }

    static LinkedHashMap<String, Object> lhmCopy(LinkedHashMap<String, Object> lhm) {
        String lhmStr = Functions.serialize(lhm);
        LinkedHashMap retLHM = (LinkedHashMap)Functions.unserialize(lhmStr);
        return retLHM;
    }

    public static Map<?, ?> copyMap(Map<?, ?> m) {
        String ser = Functions.serialize(m);
        Map newMap = (Map)Functions.unserialize(ser);
        return newMap;
    }

    public static List<?> copyList(List<?> l) {
        String ser = Functions.serialize(l);
        List list = (List)Functions.unserialize(ser);
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LOG_METHODS {
        ECHO,
        LOG,
        BUFFER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STR_PAD {
        STR_PAD_LEFT,
        STR_PAD_RIGHT;

    }
}

