/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.ConnectionLostException;
import com.detectright.core.DetectRightException;
import com.detectright.core.EntitySig;
import com.detectright.core.EntitySigCollection;
import com.detectright.core.Functions;
import com.detectright.core.QuantumDataTree;
import com.detectright.core.Sig;
import com.detectright.core.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public final class HTTPAccept {
    private LinkedHashMap<Integer, ArrayList<LinkedHashMap<String, Object>>> accept = new LinkedHashMap();
    private ArrayList<String> doNotAccept = new ArrayList();
    private EntitySigCollection esc = new EntitySigCollection();
    private QuantumDataTree qdt;
    private ArrayList<String> ignore = new ArrayList<String>(Arrays.asList("*/*", "text/html", "text/plain", "application/xml"));

    HTTPAccept() throws ConnectionLostException, DetectRightException {
    }

    static void main(String[] args) {
    }

    EntitySigCollection getESC() {
        return this.esc;
    }

    QuantumDataTree getQDT() {
        return this.qdt;
    }

    void add(String string) {
        if (Functions.isEmpty(string)) {
            return;
        }
        ArrayList<String> tmp = Functions.explode(",", string);
        tmp = Functions.array_unique(tmp);
        for (String accept : tmp) {
            if (this.ignore.contains(accept)) continue;
            int importance = 50;
            accept = Functions.trim(Functions.strtolower(Functions.str_replace("; ", ";", accept)));
            accept = Functions.str_replace("_", "-", accept);
            accept = Functions.str_replace("\n", "", accept);
            ArrayList<String> acceptArray = Functions.explode(";", accept);
            String max = "";
            String acceptBit = "";
            for (String acceptBitTmp : acceptArray) {
                acceptBit = acceptBitTmp.trim();
                if (!acceptBit.contains("=")) continue;
                ArrayList<String> tmp2 = Functions.explode("=", acceptBit);
                String firstBit = tmp2.get(0);
                String secondBit = tmp2.get(1);
                if (firstBit.equals("q")) {
                    float q = Float.parseFloat(tmp2.get(1)) * 50.0f;
                    importance = Math.round(q);
                    continue;
                }
                if (!firstBit.equals("max")) continue;
                max = secondBit;
            }
            if (!this.accept.containsKey(importance)) {
                this.accept.put(importance, new ArrayList());
            }
            ArrayList<LinkedHashMap<String, Object>> tmp2 = this.accept.get(importance);
            LinkedHashMap<String, String> tmpHM = new LinkedHashMap<String, String>();
            tmpHM.put("value", acceptArray.get(0).trim());
            tmpHM.put("max", max);
            tmpHM.put("string", accept);
            tmp2.add(tmpHM);
        }
    }

    void process() throws DetectRightException, ConnectionLostException {
        if (!Functions.is_object(this.qdt)) {
            this.qdt = new QuantumDataTree("", null);
        }
        if (this.accept == null) {
            return;
        }
        LinkedHashMap<Integer, ArrayList<LinkedHashMap<String, Object>>> accept = this.accept;
        Functions.krsort(accept);
        LinkedHashMap<Integer, ArrayList<LinkedHashMap<String, Object>>> tmpMap = accept;
        ArrayList<String> pkg = new ArrayList<String>();
        for (Map.Entry<Integer, ArrayList<LinkedHashMap<String, Object>>> entry : tmpMap.entrySet()) {
            int importance = entry.getKey();
            ArrayList<LinkedHashMap<String, Object>> mimeTypeArray = entry.getValue();
            if (mimeTypeArray == null) continue;
            for (LinkedHashMap<String, Object> arrayObj : mimeTypeArray) {
                if (arrayObj == null) continue;
                LinkedHashMap<String, Object> array = arrayObj;
                String acceptString = Functions.nn(array.get("string"));
                String mime = Functions.nn(array.get("value")).trim();
                if (this.ignore.contains(mime)) continue;
                String path = "Browser//MIME";
                String max = Functions.gvString(array, "max");
                ArrayList<String> mp = new ArrayList<String>();
                String mimePackage = Functions.str_replace("/", ":", mime);
                path = String.valueOf(path) + ":" + mimePackage;
                String status = "1";
                if (importance == 0) {
                    status = "0";
                    mp.add("status->0");
                    mp.add("importance->100");
                } else {
                    mp.add("status->1");
                    mp.add("importance->" + String.valueOf(importance));
                }
                if (!Functions.isEmpty(max)) {
                    mp.add("capacity=size{max:" + max + ";units:bytes;importance:" + String.valueOf(importance) + ";flag:" + status + "}");
                }
                if (mp.size() > 0) {
                    pkg.add(String.valueOf(path) + "//" + Functions.implode("&/&", mp));
                }
                ArrayList<String> valPkg = new ArrayList<String>();
                Validator.validateWithPC("format", acceptString, false, valPkg);
                for (String str : valPkg) {
                    if (str == null) continue;
                    if (str.startsWith("+")) {
                        str = "Browser//" + Functions.substr(str, 1);
                    }
                    pkg.add(str);
                }
                EntitySigCollection esc = Sig.detect(acceptString, "MIMETYPE");
                if (esc == null) continue;
                if (esc.qdt != null) {
                    this.qdt.addQDT(esc.qdt);
                }
                if (esc.es == null) continue;
                for (EntitySig esObj : esc.es) {
                    if (esObj == null) continue;
                    EntitySig es = esObj;
                    mp = new ArrayList();
                    String descriptor = es.descriptor;
                    String fullPath = String.valueOf(es.path) + "//" + descriptor;
                    mimePackage = Functions.str_replace("/", ":", mime);
                    mimePackage = Functions.str_replace(".", ":", mimePackage);
                    fullPath = String.valueOf(fullPath) + "//MIME:" + mimePackage;
                    if (importance == 0) {
                        mp.add("status->0");
                        mp.add("importance->" + String.valueOf(importance));
                    } else {
                        mp.add("status->1");
                        mp.add("importance->" + String.valueOf(importance));
                        if (!Functions.isEmpty(max)) {
                            pkg.add("capacity=size{max:" + max + ";units:bytes;importance:" + String.valueOf(importance) + "}");
                        }
                        if (!Functions.isEmpty(es.entity.ID) && es.entity.ID > 0L) {
                            this.esc.addES(es);
                        }
                    }
                    if (mp.size() <= 0) continue;
                    pkg.add(String.valueOf(fullPath) + "//" + Functions.implode("&/&", mp));
                }
            }
        }
        this.qdt.addPackage(pkg, 0, "ACCEPT");
    }
}

