/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Cache;
import com.detectright.core.ConnectionLostException;
import com.detectright.core.DBLink;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.Functions;
import com.detectright.core.Reflection;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HTTPConnection {
    public static ThreadLocal<DBLink> dbLink = new ThreadLocal();
    protected DBLink db;
    public static ThreadLocal<Cache> cacheLink = new ThreadLocal();
    protected Cache cache;
    public String carrier = "";
    public boolean mobile = false;
    public String connectiontype = "";
    public String currentbearer = "";
    public String connection = "";
    public String stack = "";
    public boolean ssl = false;
    public int sdu = -1;
    public int pdu = -1;
    public String secureURI = "";
    public double confidence = 0.0;

    static {
        DetectRight.registerClass("HTTPConnection");
        try {
            if (Functions.is_null(dbLink.get())) {
                dbLink.set(DetectRight.getDBLink());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
    }

    public HTTPConnection() throws ConnectionLostException, DetectRightException {
        if (Functions.is_null(dbLink.get())) {
            dbLink.set(DetectRight.getDBLink());
        }
        this.db = dbLink.get();
    }

    public void fillFromCarrier(String carrier) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(carrier)) {
            return;
        }
        if (this.db == null) {
            return;
        }
        LinkedHashMap<String, Object> carriers = this.db.simpleFetch("carriers", DBLink.allFields, DBLink.whereClause("carrier", carrier));
        if (Functions.isEmpty(carriers)) {
            return;
        }
        LinkedHashMap carrierArray = (LinkedHashMap)Functions.array_shift(carriers);
        Reflection.fill(this, carrierArray);
    }

    public String getCarrier() {
        return this.carrier;
    }

    public void setCarrier(String carrier) throws DetectRightException, ConnectionLostException {
        this.carrier = carrier;
        if (carrier != null) {
            this.fillFromCarrier(carrier);
        }
    }

    public String getCurrentBearer() {
        return this.currentbearer;
    }

    public void setCurrentBearer(String bearer) {
        this.currentbearer = bearer;
    }

    public String getConnectionType() {
        return this.connectiontype;
    }

    public void setConnection(String type) {
        this.connectiontype = type;
    }

    public String getConnection() {
        return this.connectiontype;
    }

    public boolean getIsMobile() {
        return this.mobile;
    }

    public void setIsMobile(boolean bool) {
        this.mobile = bool;
    }

    public LinkedHashMap<String, Object> getVars() {
        return Reflection.get_object_vars(this);
    }

    public void setStack(String stack) {
        this.stack = stack;
    }

    public String getStack() {
        return this.stack;
    }

    public void setSecure(boolean bool) {
        this.ssl = bool;
    }

    public boolean getSecure() {
        return this.ssl;
    }

    public String getSecureURI() {
        return this.secureURI;
    }

    public void setSecureURI(String uri) {
        this.secureURI = uri;
    }

    public Object getSdu() {
        return this.sdu;
    }

    public void setSdu(int sdu) {
        this.sdu = sdu;
    }
}

