/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Cache;
import com.detectright.core.ConnectionLostException;
import com.detectright.core.DBLink;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.DeviceNotFoundException;
import com.detectright.core.EntityCore;
import com.detectright.core.EntitySig;
import com.detectright.core.EntitySigCollection;
import com.detectright.core.Functions;
import com.detectright.core.HTTPAccept;
import com.detectright.core.HTTPConnection;
import com.detectright.core.HTTPLocale;
import com.detectright.core.IP;
import com.detectright.core.PointerCore;
import com.detectright.core.QuantumDataTree;
import com.detectright.core.Reflection;
import com.detectright.core.Sig;
import com.detectright.core.SigPart;
import com.detectright.core.Validator;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HTTPHeadersCore {
    public static ThreadLocal<DBLink> dbLink = new ThreadLocal();
    protected DBLink db;
    public static ThreadLocal<Cache> cacheLink = new ThreadLocal();
    protected Cache cache;
    LinkedHashMap<String, Object> rawHeaders;
    HTTPConnection connection;
    LinkedHashMap<String, Object> serverVars = new LinkedHashMap();
    HTTPHeadersCore proxy;
    HTTPHeadersCore gateway;
    EntitySigCollection esc = new EntitySigCollection();
    QuantumDataTree qdt = new QuantumDataTree();
    boolean cleaned = false;
    String special = "";
    String uaprof = "";
    IP ip;
    IP localIP;
    public String ua = "";
    LinkedHashMap<String, Object> diags = new LinkedHashMap();
    String uid = "";
    HTTPLocale charset;
    HTTPLocale language;
    HTTPAccept accept;
    EntityCore nominativeEntity;
    static String table = "headers";

    static {
        DetectRight.registerClass("HTTPHeadersCore");
        try {
            if (Functions.is_null(cacheLink.get())) {
                cacheLink.set(DetectRight.getCacheLink());
            }
            if (Functions.is_null(dbLink.get())) {
                dbLink.set(DetectRight.getDBLink());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void main(String[] args) {
    }

    HTTPHeadersCore() throws DetectRightException, ConnectionLostException {
        this(new LinkedHashMap<String, Object>());
    }

    public HTTPHeadersCore(Map<String, Object> headers) throws DetectRightException, ConnectionLostException {
        if (headers == null) {
            return;
        }
        if (this.rawHeaders == null) {
            this.rawHeaders = new LinkedHashMap();
        }
        this.cacheDB();
        this.ip = new IP("");
        this.rawHeaders.putAll(headers);
        if (headers.size() > 0) {
            this.proxy = new HTTPHeadersCore();
            this.gateway = new HTTPHeadersCore();
        }
        this.cleanHeaders(false);
        this.getUid();
    }

    void cacheDB() throws ConnectionLostException, DetectRightException {
        if (Functions.is_null(cacheLink.get())) {
            cacheLink.set(DetectRight.getCacheLink());
        }
        this.cache = cacheLink.get();
        if (Functions.is_null(dbLink.get())) {
            dbLink.set(DetectRight.getDBLink());
        }
        this.db = dbLink.get();
        if (this.db == null) {
            throw new ConnectionLostException("Lost connection to database");
        }
    }

    void __wakeup() throws ConnectionLostException, DetectRightException {
        this.cacheDB();
    }

    ArrayList<String> __sleep() {
        LinkedHashMap<String, Object> ov = Reflection.get_object_vars(this);
        ov.remove("cache");
        ov.remove("db");
        return Functions.array_keys_string(ov);
    }

    void processMini() throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        this.processMini(false);
    }

    void processMini(boolean includeNominativeEntities) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        if (this.serverVars.size() == 0) {
            return;
        }
        this.getAccept();
        this.geoSniff();
        this.deduce(includeNominativeEntities);
    }

    void process() throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        DetectRight.checkPoint("Processing Headers");
        if (this.serverVars.size() == 0) {
            return;
        }
        this.deduceGateway();
        this.processProxy();
        double realtimeStart = Functions.mt();
        DetectRight.checkPoint("Cookies");
        this.processCookies();
        DetectRight.checkPoint("IPs");
        this.getIPs();
        DetectRight.checkPoint("Charset");
        this.getCharset();
        DetectRight.checkPoint("language");
        this.getLanguage();
        DetectRight.checkPoint("Accept");
        this.getAccept();
        DetectRight.checkPoint("Geo");
        this.geoSniff();
        DetectRight.checkPoint("Connection");
        this.getConnectionProperties();
        DetectRight.checkPoint("Deduction");
        this.deduceProfileStuffFrom();
        if (!Functions.isEmpty(this.special)) {
            DetectRight.checkPoint("getSpecial");
            EntitySig es = new EntitySig(Functions.explode(":", this.special), this.getRaw("HTTP_USER_AGENT"));
            this.esc.addES(es);
        }
        this.deduce();
        DetectRight.checkPoint("Get nom");
        EntityCore nom = this.esc.getNominativeEntity();
        if (nom != null && nom.category.equals("Generic") && DetectRight.getThrowOutGenericDevices()) {
            nom = null;
        }
        if (Functions.is_null(nom)) {
            if (DetectRight.deviceNotFoundBehavior().equals("Exception")) {
                this.esc.close();
                throw new DeviceNotFoundException();
            }
            String uaDescriptor = "UserAgent:UserAgent:" + DetectRight.escapeDescriptor(this.ua);
            EntitySig es = new EntitySig(EntityCore.parseEntityDescriptor(uaDescriptor), this.getRaw("HTTP_USER_AGENT"));
            es.fillEntity();
            this.esc.addES(es);
        } else if (nom.ID < 1L && DetectRight.deviceNotFoundBehavior().equals("Exception")) {
            this.esc.close();
            throw new DeviceNotFoundException();
        }
        this.recordHeader();
        double realtimeTime = Functions.mt() - realtimeStart;
        this.diags.put("realtimeTime", realtimeTime);
        DetectRight.checkPoint("Processed Headers");
    }

    String getRaw(String header) {
        if (this.rawHeaders == null) {
            return "";
        }
        if (this.rawHeaders.containsKey(header)) {
            Object tmp = this.rawHeaders.get(header);
            if (tmp == null) {
                return "";
            }
            if (tmp instanceof String) {
                return tmp.toString();
            }
            return String.valueOf(tmp);
        }
        return "";
    }

    void setIP(String ip) throws ConnectionLostException, DetectRightException {
        if (Functions.isEmpty(ip)) {
            return;
        }
        this.ip = new IP(ip);
    }

    void addRawHeader(String key, String value) {
        this.rawHeaders.put(key, value);
    }

    void addCleanedHeader(String key, String value) {
        this.serverVars.put(key, value);
    }

    String getHeader(String header) {
        return this.getHeader(header, "");
    }

    String getHeader(String header, String alternative) {
        if (this.serverVars.containsKey(header)) {
            Object tmp = this.serverVars.get(header);
            if (tmp == null) {
                return alternative;
            }
            if (tmp instanceof String) {
                return tmp.toString();
            }
            return String.valueOf(tmp);
        }
        return alternative;
    }

    void setHeaders(LinkedHashMap<String, Object> serverVars) {
        this.serverVars = serverVars;
    }

    LinkedHashMap<String, Object> getHeaders() {
        return this.serverVars;
    }

    ArrayList<String> getHeaderKeys() {
        ArrayList<String> arr = Functions.array_keys_string(this.serverVars);
        if (arr == null) {
            return new ArrayList<String>();
        }
        return arr;
    }

    void removeHeader(String header) {
        if (Functions.isEmpty(this.serverVars)) {
            return;
        }
        this.serverVars.remove(header);
    }

    void addData(String path) {
        if (path == null) {
            return;
        }
        this.addData(path, "", 0);
    }

    void addData(String path, String value) {
        if (path == null) {
            return;
        }
        this.addData(path, value, 0);
    }

    void addData(String path, String value, int importanceOffset) {
        if (path == null) {
            return;
        }
        if (!Functions.isEmpty(value)) {
            path = String.valueOf(path) + "//" + value;
        }
        ArrayList<String> pkg = new ArrayList<String>();
        pkg.add(path);
        this.qdt.addPackage(pkg, importanceOffset, "DR_Realtime");
    }

    void clear() {
        this.serverVars.clear();
        this.cleaned = false;
        this.special = "";
        this.uaprof = "";
    }

    void normalise() {
        if (Functions.isEmpty(this.serverVars)) {
            this.serverVars = new LinkedHashMap();
            return;
        }
        if (this.serverVars.containsKey("HTTP_USER_AGENT")) {
            return;
        }
        LinkedHashMap<String, Object> serverVars = Functions.array_change_key_case(this.serverVars, "UPPER");
        ArrayList<String> exclude = new ArrayList<String>();
        exclude.add("REMOTE_ADDR");
        LinkedHashMap<String, String> cleanedServerVars = new LinkedHashMap<String, String>();
        ArrayList<String> keys = Functions.array_keys_string(serverVars);
        for (String key : keys) {
            String value;
            if (key == null || (value = (String)serverVars.get(key)) == null) continue;
            if (!exclude.contains(key = Functions.str_replace("-", "_", key)) && !key.startsWith("HTTP")) {
                key = "HTTP_".concat(key);
            }
            cleanedServerVars.put(key, value);
        }
        this.serverVars = cleanedServerVars;
    }

    void cleanUA() throws DetectRightException, ConnectionLostException {
        int is930;
        int pos;
        DetectRight.checkPoint("Cleaning Useragent");
        String uAgent = this.getHeader("HTTP_USER_AGENT");
        String uAgentUC = uAgent.toUpperCase();
        if (uAgentUC.contains("%20") || uAgentUC.contains("%2F") || uAgentUC.contains("%2B")) {
            try {
                uAgent = URLDecoder.decode(uAgent, "ISO-8859-1");
            }
            catch (Throwable e) {
                uAgent = this.getHeader("HTTP_USER_AGENT");
            }
        }
        uAgent = uAgent.replaceAll("[\\x00-\\x19\\x7e-\\xff]*", "");
        if (this.db == null) {
            return;
        }
        uAgent = this.db.arrayFilter("UAClean", uAgent);
        uAgent = this.db.arrayFilter("Crap", uAgent);
        LinkedHashMap<String, Object> languages = this.db.getArray("Languages");
        ArrayList<String> languageDelimiters = new ArrayList<String>();
        languageDelimiters.addAll(Arrays.asList(";", " ", "[", "]", "(", ")"));
        ArrayList<String> strictLanguageDelimiters = new ArrayList<String>();
        strictLanguageDelimiters.addAll(Arrays.asList(";", "[", "]", "(", ")"));
        LinkedHashMap<String, Object> tmpMap = languages;
        for (Map.Entry entry : tmpMap.entrySet()) {
            String cultureKey = Functions.nn((String)entry.getKey());
            String culture = Functions.nn(entry.getValue());
            Object match = "";
            int pos2 = Functions.stripos(uAgent, culture);
            if (pos2 > -1) {
                match = culture;
            } else {
                pos2 = Functions.stripos(uAgent, cultureKey);
                if (pos2 > -1) {
                    match = cultureKey;
                }
            }
            if (Functions.isEmpty(match) || pos2 == 0 || ((String)match).equals("(none)")) continue;
            String prevChar = Functions.substr(uAgent, pos2 - 1, 1);
            String nextChar = Functions.substr(uAgent, pos2 + Functions.strlen((String)match), 1);
            if (((String)match).length() > 2 ? !languageDelimiters.contains(nextChar) || !languageDelimiters.contains(prevChar) : !strictLanguageDelimiters.contains(nextChar) || !strictLanguageDelimiters.contains(prevChar)) continue;
            this.addLanguages(String.valueOf(culture) + ";q=1");
            uAgent = Functions.str_ireplace(String.valueOf(prevChar) + (String)match + nextChar, String.valueOf(prevChar) + "xx-xx" + nextChar, uAgent);
            break;
        }
        int r = 0;
        while (Functions.is_numeric(Functions.substr(uAgent, r, 1))) {
            ++r;
        }
        if (r > 6 && uAgent.length() > r) {
            uAgent = Functions.substr(uAgent, r + 1);
        }
        if ((pos = Functions.stripos(uAgent, "UP.Link")) > -1) {
            SigPart sigPart = new SigPart("(UP.Link{d}{*})");
            String upLinkVersion = sigPart.process(Functions.substr(uAgent, pos), true);
            Functions.isEmpty(upLinkVersion);
            if (sigPart.found) {
                uAgent = String.valueOf(Functions.substr(uAgent, 0, pos)) + sigPart.workingString;
            }
        }
        ArrayList<String> checkFor = new ArrayList<String>();
        checkFor.addAll(Arrays.asList("*", "/SN", "SoftBank;SN", "[TF"));
        for (String checkString : checkFor) {
            pos = Functions.stripos(uAgent, checkString);
            if (pos <= -1) continue;
            SigPart sigPart = new SigPart("(" + checkString + "{*})");
            String imei = sigPart.process(Functions.substr(uAgent, pos));
            if (!sigPart.found || Functions.strlen(imei) <= 7) continue;
            String zeroes = "";
            if (!imei.startsWith("0000") && !imei.startsWith("XXXX")) {
                this.uid = Functions.md5(imei);
            }
            zeroes = Functions.str_pad(zeroes, Functions.strlen(imei), "0");
            uAgent = String.valueOf(Functions.substr(uAgent, 0, pos + Functions.strlen(checkString))) + zeroes + Functions.substr(uAgent, pos + Functions.strlen(checkString) + Functions.strlen(zeroes));
        }
        pos = Functions.strpos(uAgent, "SIMBAR={");
        if (pos > -1) {
            String destString = "00000000-0000-0000-0000-000000000000";
            int startPos = pos + 8;
            String sourceString = Functions.substr(uAgent, startPos, Functions.strlen(destString));
            uAgent = Functions.str_replace(sourceString, destString, uAgent);
        }
        if ((is930 = Functions.strpos(uAgent, "i930")) > -1) {
            ArrayList<String> tmp = Functions.explode(";", uAgent);
            for (String part : tmp) {
                if (part == null) continue;
                if ((part = part.trim()).endsWith(")")) {
                    part = Functions.substr(part, 0, -1);
                }
                if (part.endsWith(";")) {
                    part = Functions.substr(part, 0, -1);
                }
                if (part.length() != 15) continue;
                this.uid = Functions.md5(part);
                String replace = "000000000000000";
                uAgent = Functions.str_replace(part, replace, uAgent);
                break;
            }
        }
        this.addCleanedHeader("HTTP_USER_AGENT", uAgent.trim());
        DetectRight.checkPoint("Cleaned user agent");
    }

    void getUAProfURL() {
        this.uaprof = HTTPHeadersCore.findUAProfURL(this.serverVars);
    }

    void removeIPFromUA() throws ConnectionLostException, DetectRightException {
        String ua = this.getHeader("HTTP_USER_AGENT");
        if (Functions.stripos(ua, "(REAL IP:") > -1) {
            ArrayList<String> tmp = Functions.explode("(REAL IP:", ua);
            this.addCleanedHeader("HTTP_USER_AGENT", tmp.get(0).toString().trim());
            this.setIP(Functions.str_replace(")", "", tmp.get(1).toString().trim()));
        }
    }

    void recordHeader() {
    }

    void commitToAnalytics() {
    }

    void checkHideMe() {
        String ua = this.getHeader("HTTP_USER_AGENT");
        if (Functions.stripos(ua, "HideMe.mobi Browser") > -1) {
            this.special = "Proxy:Proxy:HideMe.mobi";
            this.addCleanedHeader("HTTP_USER_AGENT", Functions.trim(Functions.str_replace("HideMe.mobi Browser", "", ua)));
        }
    }

    void checkSkyfire() throws ConnectionLostException, DetectRightException {
        String version = this.getHeader("HTTP_X_SKYFIRE_VERSION");
        if (!Functions.isEmpty(version)) {
            String skyFireScreenStr;
            ArrayList<String> skyFireScreen;
            String majorrevision = Functions.substr(version, 0, 3);
            this.addCleanedHeader("HTTP_USER_AGENT", "Skyfire/" + majorrevision + " " + this.getHeader("HTTP_USER_AGENT"));
            String originalUA = this.getHeader("HTTP_X_SKYFIRE_PHONE");
            ArrayList<String> tmp = Functions.explode("#", originalUA);
            String feature = tmp.get(1).trim();
            if (feature.equals("touchscreen")) {
                this.addData("", "Input//Display//status=1", 50);
            }
            if ((skyFireScreen = Functions.explode(",", skyFireScreenStr = this.getHeader("HTTP_X_SKYFIRE_SCREEN"))).size() > 1) {
                this.addCleanedHeader("HTTP_UA_PIXELS", Functions.array_shift(skyFireScreen) + "x" + Functions.array_shift(skyFireScreen));
            }
            if (skyFireScreen.size() > 1) {
                this.addCleanedHeader("HTTP_X_UP_DEVCAP_SCREENPIXELS", Functions.implode(",", skyFireScreen));
            }
            this.rewindIP();
        }
    }

    void checkGoogleTranslator() {
        String ua = this.getHeader("HTTP_USER_AGENT");
        if (Functions.stripos(ua, ",gzip(gfe) (via translate.google.com)") > -1) {
            this.special = "Proxy:Google:Translator";
            this.addCleanedHeader("HTTP_USER_AGENT", Functions.str_replace(",gzip(gfe) (via translate.google.com)", "", ua));
        }
    }

    void checkGoogleAppEngine() {
        String ua = this.getHeader("HTTP_USER_AGENT");
        int pos = Functions.stripos(ua, ",gzip(gfe) AppEngine-Google;");
        if (pos > -1) {
            this.special = "Proxy:Google:AppEngine";
            this.addCleanedHeader("HTTP_USER_AGENT", Functions.substr(ua, 0, pos));
        }
    }

    void checkNovarraVision() {
        String originalUA = this.getHeader("HTTP_USER_AGENT");
        if (Functions.stripos(originalUA, "Novarra-Vision/") > -1) {
            this.special = "Browser:Browser:Novarra-Vision";
            int pos = Functions.stripos(originalUA, "Novarra-Vision/");
            String majorrevision = Functions.substr(originalUA, pos + 15);
            if (Functions.is_numeric(majorrevision)) {
                this.special = String.valueOf(this.special) + "::" + majorrevision;
            }
        }
    }

    void checkszn() {
        String originalUA = this.getHeader("HTTP_USER_AGENT");
        int pos = Functions.stripos(originalUA, "/szn-mobile-transcoder");
        if (pos > 0) {
            this.special = "Proxy:SZN:Mobile Transcoder";
            this.addCleanedHeader("HTTP_USER_AGENT", Functions.substr(originalUA, 0, pos).trim());
            this.proxy.addRawHeader("HTTP_USER_AGENT", Functions.substr(originalUA, pos));
        }
    }

    void checkOperaMini() throws DetectRightException, ConnectionLostException {
        String features;
        String operaMiniPhone;
        String originalUA = this.getHeader("HTTP_X_OPERAMINI_PHONE_UA");
        if (!Functions.isEmpty(originalUA)) {
            this.proxy.addRawHeader("HTTP_USER_AGENT", this.getHeader("HTTP_USER_AGENT"));
            this.addCleanedHeader("HTTP_USER_AGENT", originalUA);
            this.proxy.addRawHeader("HTTP_ACCEPT", this.getHeader("HTTP_ACCEPT"));
            this.addCleanedHeader("HTTP_ACCEPT", "");
            this.rewindIP();
            this.special = "Proxy:Opera:Opera Mini";
        }
        if (!Functions.isEmpty(operaMiniPhone = this.getHeader("HTTP_X_OPERAMINI_PHONE"))) {
            ArrayList<String> tmp = Functions.explode("#", operaMiniPhone);
            String manufacturer = tmp.get(0).trim();
            String model = tmp.get(1).trim();
            if (!(Functions.isEmpty(manufacturer) || manufacturer.equals("?") || Functions.isEmpty(model) || model.equals("?"))) {
                LinkedHashMap<String, String> tmpHM = new LinkedHashMap<String, String>();
                tmpHM.put("entitytype", "Device");
                tmpHM.put("category", DetectRight.escapeDescriptor(manufacturer));
                tmpHM.put("description", DetectRight.escapeDescriptor(model));
                EntitySig es = new EntitySig(tmpHM, "OperaMini");
                this.esc.addES(es);
            }
        }
        if (!Functions.isEmpty(features = this.getHeader("HTTP_X_OPERAMINI_FEATURES"))) {
            ArrayList<String> featureArr = Functions.explode(",", features);
            for (String feature : featureArr) {
                if (feature == null) continue;
                this.addData("Browser//Browser:Feature:" + feature, "status=1");
            }
        }
    }

    void checkGoogleWirelessTranscoder() throws ConnectionLostException, DetectRightException {
        String originalUA = this.getHeader("HTTP_X_ORIGINAL_USER_AGENT");
        if (!Functions.isEmpty(originalUA)) {
            this.special = "Proxy:Google:Wireless Transcoder";
            this.proxy.addRawHeader("HTTP_USER_AGENT", this.getHeader("HTTP_USER_AGENT"));
            this.addCleanedHeader("HTTP_USER_AGENT", originalUA);
            this.proxy.addRawHeader("HTTP_ACCEPT", this.getHeader("HTTP_ACCEPT"));
            this.addCleanedHeader("HTTP_ACCEPT", "");
            this.rewindIP();
        }
    }

    void checkGoogleProxy() throws ConnectionLostException, DetectRightException {
        String originalUA = this.getHeader("HTTP_X_MOBILE_UA");
        if (!Functions.isEmpty(originalUA)) {
            this.proxy.addRawHeader("HTTP_USER_AGENT", this.getHeader("HTTP_USER_AGENT"));
            this.addCleanedHeader("HTTP_USER_AGENT", originalUA);
            this.proxy.addRawHeader("HTTP_ACCEPT", this.getHeader("HTTP_ACCEPT"));
            this.addCleanedHeader("HTTP_ACCEPT", "");
            this.special = "Proxy:Google:Google Transcoder";
            this.rewindIP();
        }
    }

    void checkOpenWeb() {
        if (Functions.strpos(this.getHeader("HTTP_USER_AGENT"), "OpenWeb") > -1) {
            this.special = "Proxy:Openwave:Openweb";
        }
    }

    void checkNovarraProxy() throws ConnectionLostException, DetectRightException {
        String originalUA = this.getHeader("HTTP_X_DEVICE_USER_AGENT");
        if (!Functions.isEmpty(originalUA)) {
            this.ua = this.getHeader("HTTP_USER_AGENT");
            this.proxy.addRawHeader("HTTP_USER_AGENT", Functions.str_replace(originalUA, "", this.ua).trim());
            this.addCleanedHeader("HTTP_USER_AGENT", originalUA);
            this.proxy.addRawHeader("HTTP_ACCEPT", this.getHeader("HTTP_ACCEPT"));
            this.addCleanedHeader("HTTP_ACCEPT", this.getHeader("HTTP_X_DEVICE_ACCEPT"));
            this.removeHeader("HTTP_X_DEVICE_USER_AGENT");
            this.removeHeader("HTTP_X_DEVICE_ACCEPT");
        }
        if (!Functions.isEmpty(this.getHeader("HTTP_X_NOVARRA_DEVICE_TYPE"))) {
            this.special = "Proxy:Novarra:Web Proxy";
            this.rewindIP();
        }
        LinkedHashMap<String, Object> serverVars = this.getHeaders();
        ArrayList<String> headers = Functions.array_keys(serverVars);
        for (String key : headers) {
            if (key == null) continue;
            String value = this.getHeader(key);
            if (!key.startsWith("HTTP_X_DEVICE_")) continue;
            String realKey = Functions.str_replace("X_DEVICE_", "", key);
            this.proxy.addRawHeader(realKey, this.getHeader(realKey));
            this.addCleanedHeader(realKey, value);
            this.special = "Proxy:Novarra:Web Proxy";
        }
    }

    void checkIfUAIsUAP() {
        String ua = this.getHeader("HTTP_USER_AGENT");
        if (ua == null) {
            return;
        }
        if (ua.startsWith("http://")) {
            String url = ua;
            if ((url.contains(".xml") || url.contains(".rdf")) && Functions.isEmpty(this.uaprof)) {
                this.addCleanedHeader("HTTP_X_WAP_PROFILE", url);
                this.uaprof = url;
            }
            this.addCleanedHeader("HTTP_USER_AGENT", "Missing");
        }
    }

    void addDownloadAccept() {
        String da = this.getHeader("HTTP_X_UP_DOWNLOAD_ACCEPT");
        String a = this.getHeader("HTTP_ACCEPT");
        if (!Functions.isEmpty(da)) {
            this.addCleanedHeader("HTTP_ACCEPT", String.valueOf(a) + "," + da);
        }
    }

    void cleanHeaders() throws DetectRightException, ConnectionLostException {
        this.cleanHeaders(false);
    }

    void cleanHeaders(boolean reclean) throws DetectRightException, ConnectionLostException {
        if (this.cleaned && !reclean) {
            return;
        }
        if (!Functions.is_array(this.rawHeaders)) {
            return;
        }
        this.serverVars = (LinkedHashMap)this.rawHeaders.clone();
        if (this.rawHeaders.size() == 0) {
            return;
        }
        this.normalise();
        if (this.serverVars.size() == 0) {
            return;
        }
        this.getUAProfURL();
        this.checkIfUAIsUAP();
        this.addDownloadAccept();
        this.removeIPFromUA();
        this.checkOperaMini();
        this.checkHideMe();
        this.checkSkyfire();
        this.checkGoogleTranslator();
        this.checkGoogleAppEngine();
        this.checkNovarraVision();
        this.checkszn();
        if (Functions.isEmpty(this.special)) {
            this.checkGoogleWirelessTranscoder();
        }
        if (Functions.isEmpty(this.special)) {
            this.checkGoogleProxy();
        }
        this.checkOpenWeb();
        if (Functions.isEmpty(this.special)) {
            this.checkNovarraProxy();
        }
        this.cleanUA();
        this.grabUA();
        this.cleaned = true;
    }

    void grabUA() {
        String ua = this.getHeader("HTTP_USER_AGENT");
        if (Functions.isEmpty(ua)) {
            this.ua = "Missing";
        }
        this.ua = ua;
    }

    void rewindIP() throws ConnectionLostException, DetectRightException {
        ArrayList<String> ipArr;
        String ip;
        this.proxy.setIP(this.getHeader("REMOTE_ADDR"));
        String ips = this.getHeader("HTTP_X_FORWARDED_FOR");
        if (!Functions.isEmpty(ips) && !IP.checkLocalIP(ip = (String)Functions.array_shift(ipArr = Functions.explode(",", ips)))) {
            this.addCleanedHeader("REMOTE_ADDR", ip);
            this.setIP(ip);
            ips = Functions.implode(",", ipArr);
            if (!Functions.isEmpty(ips)) {
                this.addCleanedHeader("HTTP_X_FORWARDED_FOR", ips);
            } else {
                this.removeHeader("HTTP_X_FORWARDED_FOR");
            }
        }
    }

    void geoSniff() {
        if (Functions.is_object(this.ip)) {
            this.ip.process(this.getHeaders());
        }
    }

    void getConnectionProperties() throws DetectRightException, ConnectionLostException {
        String sdu;
        String[] stringArray;
        String wc;
        String ni;
        String bs;
        if (!Functions.is_object(this.connection)) {
            this.connection = new HTTPConnection();
        }
        this.connection.secureURI = this.getHeader("HTTP_X_UP_WAPPUSH_SECURE");
        String bytes = this.getHeader("HTTP_X_UP_DEVCAP_MAX_PDU");
        if (!Functions.isEmpty(bytes) && !Functions.isEmpty(bs = Validator.validate("bytesize", bytes))) {
            this.connection.pdu = Functions.parseInt(bs);
        }
        String connection = this.connection.getCarrier();
        String stack = "";
        if (Functions.isEmpty(connection)) {
            connection = this.getHeader("HTTP_X_NOKIA_BEARER");
        }
        if (Functions.isEmpty(connection)) {
            connection = this.getHeader("HTTP_X_NETWORK_TYPE");
        }
        if (!Functions.isEmpty(ni = this.getHeader("HTTP_X_NETWORK_INFO"))) {
            ArrayList<String> tmp = Functions.explode(",", ni);
            for (String string : tmp) {
                if (string == null) continue;
                ni = string.toUpperCase().trim();
                if (!Functions.isEmpty(ni) && (ni.equals("TCP") || ni.equals("UDP"))) {
                    if (!Functions.isEmpty(stack)) continue;
                    stack = ni;
                    continue;
                }
                if (!Functions.isEmpty(connection)) continue;
                connection = ni.toLowerCase();
            }
        }
        if (Functions.isEmpty(connection)) {
            for (String key : this.getHeaderKeys()) {
                if (key == null) continue;
                String value = this.getHeader(key);
                if (!key.toLowerCase().contains("bear") || value == null) continue;
                connection = value.toUpperCase();
            }
        }
        if (Functions.isEmpty(stack) && !Functions.isEmpty(wc = this.getHeader("HTTP_WAP_CONNECTION")) && (stringArray = wc.trim().split("=")).length > 1) {
            stack = stringArray[1].trim().toUpperCase();
        }
        if (!Functions.isEmpty(sdu = this.getHeader("HTTP_X_WAP_CLIENT_SDU_SIZE"))) {
            this.connection.setSdu(Functions.parseInt(sdu));
        }
        if (Functions.isEmpty(connection)) {
            connection = this.getHeader("HTTP_X_NOKIA_MUSICSHOP_BEARER");
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("GPRS/3G", "GPRS/3G");
        linkedHashMap.put("3G", "UMTS");
        linkedHashMap.put("2G", "GPRS");
        linkedHashMap.put("UMTS", "UMTS");
        linkedHashMap.put("WCDMA", "UMTS");
        linkedHashMap.put("EDGE", "EDGE");
        linkedHashMap.put("GPRS", "GPRS");
        linkedHashMap.put("CSD", "CSD");
        linkedHashMap.put("IDEN", "IDEN");
        linkedHashMap.put("USB", "USB");
        linkedHashMap.put("WLAN", "WLAN");
        linkedHashMap.put("80211g", "WLAN");
        linkedHashMap.put("80211n", "WLAN");
        linkedHashMap.put("80211b", "WLAN");
        linkedHashMap.put("CDMA1X", "RTT1X");
        linkedHashMap.put("_1x", "RTT1X");
        linkedHashMap.put("EVDO", "EVDO");
        String uaprof = this.uaprof;
        if (Functions.isEmpty(connection) && !Functions.isEmpty(uaprof)) {
            ArrayList<String> connKeys = Functions.array_keys_string(linkedHashMap);
            for (String conn : connKeys) {
                if (conn == null) continue;
                String conntype = (String)linkedHashMap.get(conn);
                if (!uaprof.toLowerCase().contains(conn.toLowerCase())) continue;
                connection = conntype;
                break;
            }
        }
        if (!Functions.isEmpty(connection)) {
            this.connection.setCarrier(connection);
        }
        if (!Functions.isEmpty(stack)) {
            this.connection.setStack(stack);
        }
        this.qdt.addObject("Connection", this.connection);
    }

    void deduceGateway() throws DetectRightException, ConnectionLostException {
        this.deduceGateway("");
    }

    void deduceGateway(String via) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(via)) {
            via = this.getHeader("HTTP_VIA");
        }
        if (Functions.isEmpty(via)) {
            return;
        }
        ArrayList<String> viaArr = Functions.explode(",", via);
        String gatewayAgent = (String)Functions.array_shift(viaArr);
        if (Functions.isEmpty(gatewayAgent)) {
            return;
        }
        this.gateway = new HTTPHeadersCore(DBLink.whereClause("HTTP_USER_AGENT", gatewayAgent));
        try {
            this.gateway.process();
        }
        catch (DeviceNotFoundException deviceNotFoundException) {
            // empty catch block
        }
    }

    void getUid() throws DetectRightException {
        if (!Functions.isEmpty(this.uid)) {
            return;
        }
        String value = "";
        for (String key : this.getHeaderKeys()) {
            String valueObj = this.getHeader(key);
            if (valueObj == null) continue;
            ArrayList<String> valueArr = new ArrayList<String>();
            if (valueObj instanceof String) {
                valueArr.add(valueObj.toString());
            }
            if (key == null || !key.toUpperCase().startsWith("HTTP")) continue;
            boolean again = true;
            int i = 0;
            while (i < valueArr.size()) {
                again = false;
                value = (String)valueArr.get(i);
                if (Functions.stripos(key, "msisdn") > -1 || Functions.stripos(key, "line_id") > -1 || Functions.stripos(key, "subno") > -1 || Functions.stripos(key, "clid") > -1 || Functions.stripos(key, "subscribe") > -1 || Functions.stripos(key, "imsi") > -1 || Functions.stripos(key, "imei") > -1 || Functions.stripos(key, "gdi") > -1 || Functions.stripos(key, "subnym") > -1 || Functions.stripos(key, "orange_id") > -1) break;
                again = true;
                ++i;
            }
            if (!again) break;
            value = "";
        }
        if (!Functions.isEmpty(value)) {
            this.uid = Functions.md5(value);
            return;
        }
        ArrayList<String> hashHeaders = new ArrayList<String>();
        hashHeaders.addAll(Arrays.asList(this.getHeader("HTTP_ACCEPT_LANGUAGE"), this.getHeader("HTTP_BEARER_INDICATION"), this.getHeader("HTTP_ENCODING_VERSION"), this.getHeader("HTTP_HOST"), this.getHeader("HTTP_USER_AGENT"), this.getHeader("HTTP_X_FORWARDED_FOR"), this.getHeader("HTTP_X_UP_UPLINK"), this.getHeader("REMOTE_ADDR"), this.getHeader("SERVER_ADDR")));
        if (Functions.is_object(this.proxy)) {
            hashHeaders.add(this.proxy.getHeader("HTTP_USER_AGENT"));
            hashHeaders.add(this.proxy.getHeader("HTTP_ACCEPT"));
        }
        String idString = Functions.implode("/", hashHeaders);
        this.uid = Functions.md5(idString);
    }

    void getCharset() {
        if (!Functions.is_object(this.charset)) {
            this.charset = new HTTPLocale();
        }
        this.charset.add(this.getHeader("HTTP_ACCEPT_CHARSET"));
        this.charset.add(this.getHeader("HTTP_X_UP_DEVCAP_CHARSET"));
    }

    void getLanguage() {
        this.addLanguages(this.getHeader("HTTP_ACCEPT_LANGUAGE"));
    }

    void getAccept() throws DetectRightException, ConnectionLostException {
        String accept;
        if (!Functions.is_object(this.accept)) {
            this.accept = new HTTPAccept();
        }
        if (Functions.isEmpty(accept = this.getHeader("HTTP_ACCEPT"))) {
            return;
        }
        this.accept.add(accept);
        this.accept.process();
        this.qdt.addQDT(this.accept.getQDT());
        this.esc.addESC(this.accept.getESC());
    }

    public EntitySigCollection getESC() throws DetectRightException {
        EntitySigCollection esc = this.esc;
        esc.qdt.addQDT(this.qdt);
        esc.qdt.addObject("Headers", this);
        return esc;
    }

    public QuantumDataTree getQDT() {
        return this.qdt;
    }

    void addLanguages(String string) {
        if (!Functions.is_object(this.language)) {
            this.language = new HTTPLocale();
        }
        this.language.add(string);
    }

    void processCookies() throws DetectRightException, ConnectionLostException {
        String cookie = this.getHeader("HTTP_COOKIE");
        if (!Functions.isEmpty(cookie)) {
            ArrayList<String> cookieSplit = Functions.explode(";", cookie);
            for (String value : cookieSplit) {
                ArrayList<String> thing = Functions.explode("=", value, 2);
                String key = thing.get(0);
                if ((key = key.replace("/[0-9]{1}/", "").toLowerCase()).equals("user-identity-forward-msisdn")) {
                    this.uid = thing.get(1);
                    continue;
                }
                if (key.equals("network-access-type")) {
                    this.setConnectionType(thing.get(1).toUpperCase());
                    continue;
                }
                if (!key.equals("bearer-type")) continue;
                this.setBearerType(thing.get(1).toLowerCase());
            }
        }
    }

    void setConnectionType(String type) throws DetectRightException, ConnectionLostException {
        if (!Functions.is_object(this.connection)) {
            this.connection = new HTTPConnection();
        }
        this.connection.setCarrier(type);
    }

    void setBearerType(String type) throws ConnectionLostException, DetectRightException {
        if (!Functions.is_object(this.connection)) {
            this.connection = new HTTPConnection();
        }
        this.connection.setStack(type);
    }

    void getIPs() throws ConnectionLostException, DetectRightException {
        String remoteAddrIP = this.getHeader("REMOTE_ADDR", this.getHeader("HTTP_REMOTE_ADDR"));
        String xff = this.getHeader("HTTP_X_FORWARDED_FOR");
        if (!Functions.isEmpty(xff)) {
            ArrayList<String> xffArray = Functions.explode(",", xff);
            for (String xffp : xffArray) {
                if (!IP.checkLocalIP(xffp)) {
                    this.setIP(xffp);
                    this.proxy.setIP(remoteAddrIP);
                    continue;
                }
                this.setIP(remoteAddrIP);
                this.setLocalIP(xffp);
            }
        } else {
            String xwcip = this.getHeader("HTTP_X_WAP_CLIENT_IP");
            if (!Functions.isEmpty(xwcip)) {
                if (!IP.checkLocalIP(xwcip)) {
                    this.setIP(xwcip);
                    this.proxy.setIP(remoteAddrIP);
                } else {
                    this.setIP(remoteAddrIP);
                    this.setLocalIP(xwcip);
                }
            } else {
                String cip = this.getHeader("HTTP_CLIENT_IP");
                if (!Functions.isEmpty(cip)) {
                    if (!IP.checkLocalIP(cip)) {
                        this.setIP(cip);
                        this.proxy.setIP(remoteAddrIP);
                    } else {
                        this.setIP(remoteAddrIP);
                        this.setLocalIP(cip);
                    }
                } else {
                    String si = this.getHeader("HTTP_X_SUBSCRIBER_INFO");
                    if (!Functions.isEmpty(si)) {
                        if (!IP.checkLocalIP(si)) {
                            this.setIP(si);
                            this.proxy.setIP(remoteAddrIP);
                        } else {
                            this.setIP(remoteAddrIP);
                            this.setLocalIP(si);
                        }
                    } else {
                        this.setIP(remoteAddrIP);
                    }
                }
            }
        }
    }

    void setLocalIP(String ip) throws ConnectionLostException, DetectRightException {
        this.localIP = new IP(ip);
    }

    String getLocalIP() {
        if (this.localIP == null) {
            return "";
        }
        return this.localIP.ip;
    }

    void processProxy() throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(this.proxy) || Functions.isEmpty(this.proxy.rawHeaders)) {
            return;
        }
        try {
            this.proxy.cleanHeaders(false);
            this.proxy.processMini(false);
            this.esc.addESC(this.proxy.getESC());
        }
        catch (DeviceNotFoundException deviceNotFoundException) {
            // empty catch block
        }
    }

    static String findUAProfURL(LinkedHashMap<String, Object> serverVars) {
        int endUrlPos;
        String uaProfURL = "";
        ArrayList<String> keys = Functions.array_keys_string(serverVars);
        for (String key : keys) {
            String keylc;
            boolean kcp;
            if (key == null || !(kcp = (keylc = key.toLowerCase()).contains("profile")) || keylc.contains("diff") || (uaProfURL = (String)serverVars.get(key)) != null) continue;
            uaProfURL = "";
        }
        if (!uaProfURL.contains("/")) {
            uaProfURL = "";
        }
        if (Functions.isEmpty(uaProfURL)) {
            return "";
        }
        int httpPos = Functions.stripos(uaProfURL, "http");
        if (httpPos != -1) {
            uaProfURL = Functions.substr(uaProfURL, httpPos);
        }
        if ((endUrlPos = Functions.strpos(uaProfURL.toLowerCase(), ".rdf")) != -1) {
            uaProfURL = Functions.substr(uaProfURL, 0, endUrlPos + 4);
        }
        if ((endUrlPos = Functions.strpos(uaProfURL.toLowerCase(), ".xml")) != -1) {
            uaProfURL = Functions.substr(uaProfURL, 0, endUrlPos + 4);
        }
        uaProfURL = Functions.stripslashes(uaProfURL);
        uaProfURL = Functions.stripslashes(uaProfURL);
        if (!Functions.isEmpty(uaProfURL = Functions.str_replace("\"", "", uaProfURL)) && !Functions.substr(uaProfURL, 0, 4).equals("http")) {
            uaProfURL = Functions.base64_decodeStr(uaProfURL);
        }
        uaProfURL = Functions.cleanURL(uaProfURL);
        return uaProfURL;
    }

    String getCustomerHash() throws DetectRightException {
        if (Functions.isEmpty(this.uid)) {
            this.getUid();
        }
        return this.uid;
    }

    String hash() throws DetectRightException {
        String uaPixels = this.getHeader("HTTP_UA_PIXELS");
        String uaProfURL = this.uaprof;
        String ua = this.ua;
        String accept = this.getHeader("HTTP_ACCEPT");
        String hash = Functions.md5(Functions.strtolower(Functions.str_replace(" ", "", String.valueOf(ua) + "/" + accept + "/" + uaProfURL + "/" + uaPixels)));
        return hash;
    }

    void deduce() throws DetectRightException, ConnectionLostException {
        this.deduce(true);
    }

    void deduce(boolean allowDeducedNominativeEntities) throws DetectRightException, ConnectionLostException {
        if (!allowDeducedNominativeEntities) {
            this.esc.refuseNominativeEntities();
        }
        try {
            if ((this.ua.length() == 7 || this.ua.length() == 8 || this.ua.length() == 9) && Functions.is_numeric(this.ua)) {
                EntitySigCollection tacESC = PointerCore.getESC("TAC", this.ua);
                this.esc.addESC(tacESC);
            }
        }
        catch (Throwable tacESC) {
            // empty catch block
        }
        DetectRight.checkPoint("Getting ESC From pointers");
        DetectRight.checkPoint("Getting UAP ESC From pointers");
        if (!Functions.isEmpty(this.uaprof)) {
            EntitySigCollection UAProfESC = PointerCore.getESC("UAP", this.uaprof);
            this.esc.addESC(UAProfESC);
        }
        DetectRight.checkPoint("Getting UA Raw ESC From pointers");
        String rawUA = this.getRaw("HTTP_USER_AGENT");
        if (!Functions.isEmpty(rawUA)) {
            EntitySigCollection pointerRawESC = PointerCore.getESC("PhoneID", rawUA);
            this.esc.addESC(pointerRawESC);
        }
        DetectRight.checkPoint("Getting PhoneID ESC From pointers");
        EntitySigCollection phoneIDESC = PointerCore.getESC("PhoneID", this.ua);
        this.esc.addESC(phoneIDESC);
        DetectRight.checkPoint("Getting UA ESC From pointers");
        EntitySigCollection pointerESC = PointerCore.getESC("UserAgent", this.ua);
        this.esc.addESC(pointerESC);
        DetectRight.checkPoint("Getting UA ESC From pointers (raw)");
        if (pointerESC.descriptors != null && pointerESC.descriptors.size() == 0) {
            EntitySigCollection pointerRawESC = PointerCore.getESC("UserAgent", rawUA);
            this.esc.addESC(pointerRawESC);
        }
        ArrayList<String> excludedHeaders = Functions.array("HTTP_ACCEPT");
        excludedHeaders.add("REMOTE_ADDR");
        DetectRight.checkPoint("Going through headers");
        LinkedHashMap<String, Object> tmpMap = this.serverVars;
        for (Map.Entry entry : tmpMap.entrySet()) {
            String key = (String)entry.getKey();
            Object valueObj = entry.getValue();
            if (valueObj == null) continue;
            String value = String.valueOf(valueObj);
            boolean contained = excludedHeaders.contains(key);
            if (contained) continue;
            DetectRight.checkPoint("Detecting " + key + " = " + value);
            EntitySigCollection esc = Sig.detect(value, key);
            if (Functions.is_null(esc)) continue;
            this.esc.addESC(esc);
        }
    }

    void deduceProfileStuffFrom() {
    }
}

