/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Cache;
import com.detectright.core.ConnectionLostException;
import com.detectright.core.DBLink;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.Functions;
import java.util.ArrayList;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IP {
    public String ip = "";
    public long longIP = 0L;
    public Object org;
    public Object geo;
    public String commtype;
    public Object IPRange;
    public Object ipRange;
    public static ThreadLocal<DBLink> dbLink = new ThreadLocal();
    public static ThreadLocal<Cache> cacheLink = new ThreadLocal();

    static {
        try {
            if (cacheLink.get() == null) {
                cacheLink.set(DetectRight.getCacheLink());
            }
            if (dbLink.get() == null) {
                dbLink.set(DetectRight.getDBLink());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
    }

    public IP() throws ConnectionLostException, DetectRightException {
        this("");
    }

    public IP(String ip) throws ConnectionLostException, DetectRightException {
        this.cacheDB();
        if (Functions.isEmpty(ip)) {
            return;
        }
        this.ip = ip;
        this.longIP = IP.tolong(ip);
    }

    public String toString() {
        return this.ip;
    }

    public void cacheDB() throws ConnectionLostException, DetectRightException {
        if (cacheLink.get() == null) {
            cacheLink.set(DetectRight.getCacheLink());
        }
        if (dbLink.get() == null) {
            dbLink.set(DetectRight.getDBLink());
        }
        if (dbLink.get() == null) {
            throw new ConnectionLostException("Lost connection to database");
        }
    }

    public void __wakeup() throws ConnectionLostException, DetectRightException {
        this.cacheDB();
    }

    public void process(LinkedHashMap<String, Object> serverVars) {
        if (Functions.isEmpty(this.longIP) && Functions.isEmpty(this.ip)) {
            return;
        }
        if (Functions.isEmpty(this.longIP)) {
            this.longIP = IP.Dot2LongIP(this.ip);
        }
    }

    public static long Dot2LongIP(String IPaddr) {
        if (IPaddr == null) {
            return 0L;
        }
        if (!IPaddr.contains(".") && !IPaddr.contains(":")) {
            return 0L;
        }
        return Functions.inet_pton(IPaddr);
    }

    public static boolean checkLocalIP(String ip) {
        if (ip == null) {
            return true;
        }
        if (!ip.contains(".")) {
            return true;
        }
        ArrayList<String> ipArr = Functions.explode(".", ip);
        String ip0 = ipArr.get(0);
        String ip1 = ipArr.get(1);
        if (ip0.equals("192") && ip1.equals("168")) {
            return true;
        }
        if (ip0.equals("10")) {
            return true;
        }
        return ip0.equals("172") && Functions.parseInt(ip1) > 15 && Functions.parseInt(ip1) < 32;
    }

    public static long tolong(String ip) {
        return Functions.inet_pton(ip);
    }

    public static String toip(long iplong) {
        return Functions.inet_ntop(iplong);
    }
}

