/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Functions;
import com.detectright.core.Reflection;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class PHPSerializer {
    private ArrayList<Integer> arlHashes;
    private boolean bolXMLSafe;

    public void setXMLSafe(boolean bolXMLSafe) {
        this.bolXMLSafe = bolXMLSafe;
    }

    public boolean getXMLSafe() {
        return this.bolXMLSafe;
    }

    public static String serialize(Object obj) {
        PHPSerializer phps = new PHPSerializer();
        phps.arlHashes = new ArrayList();
        return phps.DoSerialize(obj).toString();
    }

    private StringBuilder DoSerialize(Object obj) {
        StringBuilder sb = new StringBuilder();
        if (obj == null) {
            return sb.append("N;");
        }
        if (obj instanceof String) {
            String strObj = (String)obj;
            if (this.bolXMLSafe) {
                strObj = strObj.replace("\r\n", "\n");
                strObj = strObj.replace("\r", "\n");
            }
            return sb.append("s:" + strObj.length() + ":\"" + strObj + "\";");
        }
        if (obj instanceof Boolean) {
            Boolean bolObj = (Boolean)obj;
            String strBol = bolObj != false ? "1" : "0";
            return sb.append("b:" + strBol + ";");
        }
        if (obj instanceof Integer) {
            Integer intObj = (Integer)obj;
            return sb.append("i:" + String.valueOf(intObj) + ";");
        }
        if (obj instanceof Long) {
            Long longObj = (Long)obj;
            return sb.append("i:" + String.valueOf(longObj) + ";");
        }
        if (obj instanceof Double) {
            Double dblObj = (Double)obj;
            return sb.append("d:" + dblObj.toString() + ";");
        }
        if (obj instanceof ArrayList) {
            if (this.arlHashes.contains(obj.hashCode())) {
                return sb.append("N;");
            }
            this.arlHashes.add(obj.hashCode());
            ArrayList arlObj = (ArrayList)obj;
            sb.append("a:" + arlObj.size() + ":{");
            int i = 0;
            i = 0;
            while (i < arlObj.size()) {
                sb.append((CharSequence)this.DoSerialize(i));
                sb.append((CharSequence)this.DoSerialize(arlObj.get(i)));
                ++i;
            }
            sb.append("}");
            return sb;
        }
        if (obj instanceof LinkedHashMap || obj instanceof HashMap || obj instanceof Map) {
            this.arlHashes.add(obj.hashCode());
            Map htbObj = (Map)obj;
            sb.append("a:" + htbObj.size() + ":{");
            for (Map.Entry entry : htbObj.entrySet()) {
                String key = String.valueOf(entry.getKey());
                Object value = entry.getValue();
                sb.append((CharSequence)this.DoSerialize(key));
                sb.append((CharSequence)this.DoSerialize(value));
            }
            sb.append("}");
            return sb;
        }
        LinkedHashMap<String, Object> htbObj = Reflection.get_object_vars(obj);
        try {
            Class<?> c = obj.getClass();
            Method m = c.getMethod("__sleep", new Class[0]);
            Object[] arglist = new Object[]{};
            Object fields = m.invoke(obj, arglist);
            ArrayList fieldArr = (ArrayList)fields;
            ArrayList<String> htpKeys = Functions.array_keys_string(htbObj);
            for (String key : htpKeys) {
                boolean contains = fieldArr.contains(key);
                if (contains) continue;
                htbObj.remove(key);
            }
        }
        catch (Throwable c) {
            // empty catch block
        }
        Class<?> tmpClass = obj.getClass();
        String tmpClassString = tmpClass.getName();
        ArrayList<String> tmp = Functions.explode(".", tmpClassString);
        tmpClassString = Functions.array_pop(tmp).toString();
        htbObj.put("_DRClassName", tmpClassString);
        sb.append((CharSequence)this.DoSerialize(htbObj));
        return sb;
    }

    public static boolean isSerialized(String string) {
        if (Functions.isEmpty(string)) {
            return false;
        }
        if (string.equals("N;")) {
            return true;
        }
        String prefix = string.substring(0, 2);
        String[] checks = new String[]{"a:", "O:", "s:", "i:", "b:", "d:"};
        ArrayList<String> check = new ArrayList<String>(Arrays.asList(checks));
        return check.contains(prefix);
    }
}

