/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Cache;
import com.detectright.core.ConnectionLostException;
import com.detectright.core.DBLink;
import com.detectright.core.DRLRUMap;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.EntityCore;
import com.detectright.core.EntitySigCollection;
import com.detectright.core.Functions;
import com.detectright.core.Reflection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointerCore {
    public static ThreadLocal<DBLink> dbLink = new ThreadLocal();
    public static ThreadLocal<Cache> cacheLink = new ThreadLocal();
    public static DRLRUMap pointers = new DRLRUMap(1000);
    public long ID;
    public String pointertype;
    public String stringhash;
    public String majorrevision = "";
    public String minorrevision = "";
    public long entityid = 0L;
    public String entityhash = "";
    public String subclass = "";
    public String connection = "";
    public String owner = "SYSTEM";
    public String build = "";
    public String ts;
    public int status = 2;
    public String tablename;
    public LinkedHashMap<String, Object> fieldList;
    public String error;
    public String pk;
    public EntityCore entity;
    public static String table = "pointers";
    public static ArrayList<String> fields = new ArrayList<String>(Arrays.asList("ID", "pointertype", "stringhash", "majorrevision", "minorrevision", "status", "entityid", "entityhash", "subclass", "connection", "ts", "pointerhash", "build", "owner", "ts"));
    public static String PK = "ID";

    static {
        DetectRight.registerClass("PointerCore");
        try {
            if (Functions.is_null(cacheLink.get())) {
                cacheLink.set(DetectRight.getCacheLink());
            }
            if (Functions.is_null(dbLink.get())) {
                dbLink.set(DetectRight.getDBLink());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        String clean = PointerCore.punctClean("MOT-C650?-4+5/0B.D1.18R MIB/2.2.1 Profile/MIDP-2.0 Configuration/CLDC-1.0");
        System.out.println(clean);
        System.out.println(Functions.md5(clean));
    }

    public PointerCore() throws DetectRightException, ConnectionLostException {
        this(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PointerCore(long ID) throws DetectRightException, ConnectionLostException {
        PointerCore.cacheDB();
        this.tablename = table;
        this.fieldList = Functions.arr2hm(fields);
        this.pk = PK;
        if (ID < 1L) {
            return;
        }
        String idStr = String.valueOf(ID);
        LinkedHashMap<String, Object> where = DBLink.whereClause(this.pk, idStr);
        DBLink dbl = dbLink.get();
        if (dbl == null) {
            throw new ConnectionLostException("Lost connection getting pointer");
        }
        boolean sds = DetectRight.getSingleDataSource();
        LinkedHashMap<String, Object> pointer = null;
        if (sds && pointers.containsKey(ID)) {
            pointer = (LinkedHashMap)pointers.get(String.valueOf(ID));
        }
        if (pointer == null) {
            if (sds) {
                DRLRUMap dRLRUMap = pointers;
                synchronized (dRLRUMap) {
                    if (pointers.containsKey(idStr)) {
                        pointer = (LinkedHashMap<String, Object>)pointers.get(idStr);
                    } else {
                        pointer = dbl.simpleFetch(this.tablename, DBLink.allFields, where);
                        if (pointer != null) {
                            pointers.put(idStr, pointer);
                        }
                    }
                }
            } else {
                pointer = dbl.simpleFetch(this.tablename, DBLink.allFields, where);
            }
        }
        if (pointer == null) {
            this.error = dbl.error;
            throw new DetectRightException(dbl.error, null);
        }
        if (pointer.size() == 0) {
            this.error = "Invalid pointer ID";
            return;
        }
        LinkedHashMap data = (LinkedHashMap)Functions.array_shift(pointer);
        this.fill(data);
    }

    void fill(LinkedHashMap<String, Object> data) {
        if (data == null) {
            return;
        }
        if (data.containsKey("ID")) {
            this.ID = Functions.gvLong(data, "ID", 0L);
        }
        if (data.containsKey("entityhash")) {
            this.entityhash = Functions.gvString(data, "entityhash");
        }
        if (data.containsKey("entityid")) {
            this.entityid = Functions.gvLong(data, "entityid", 0L);
        }
        if (data.containsKey("status")) {
            String statusStr = Functions.gvString(data, "status", "2");
            try {
                this.status = Functions.parseInt(statusStr);
            }
            catch (Exception e) {
                this.status = 2;
            }
        }
        if (data.containsKey("majorrevision")) {
            this.majorrevision = Functions.gvString(data, "majorrevision");
        }
        if (data.containsKey("minorrevision")) {
            this.minorrevision = Functions.gvString(data, "minorrevision");
        }
        if (data.containsKey("subclass")) {
            this.subclass = Functions.gvString(data, "subclass");
        }
        if (data.containsKey("connection")) {
            this.connection = Functions.gvString(data, "connection");
        }
        if (data.containsKey("build")) {
            this.build = Functions.gvString(data, "build");
        }
        if (data.containsKey("ts")) {
            this.ts = Functions.gvString(data, "ts");
        }
        if (data.containsKey("pointertype")) {
            this.pointertype = Functions.gvString(data, "pointertype");
        }
        if (data.containsKey("stringhash")) {
            this.stringhash = Functions.gvString(data, "stringhash");
        }
        if (data.containsKey("owner")) {
            this.owner = Functions.gvString(data, "owner");
        }
    }

    public static void cacheDB() throws ConnectionLostException, DetectRightException {
        if (cacheLink.get() == null) {
            cacheLink.set(DetectRight.getCacheLink());
        }
        if (dbLink.get() == null) {
            dbLink.set(DetectRight.getDBLink());
        }
        if (dbLink.get() == null) {
            throw new ConnectionLostException("Lost connection to database");
        }
        DetectRight.checkPoint("Pointer has got a database on thread " + Thread.currentThread().getName());
    }

    public void __wakeup() throws ConnectionLostException, DetectRightException {
        PointerCore.cacheDB();
    }

    public ArrayList<String> __sleep() {
        LinkedHashMap<String, Object> ov = Reflection.get_object_vars(this);
        return Functions.array_keys_string(ov);
    }

    public long id() {
        return this.ID;
    }

    public boolean setid(long value) {
        if (value > 0L) {
            this.ID = value;
        }
        return true;
    }

    public long ts() {
        return Functions.strtotime(this.ts);
    }

    public String description() throws DetectRightException, ConnectionLostException {
        EntityCore entity = this.getEntity();
        if (entity == null) {
            return "";
        }
        return String.valueOf(this.pointertype) + " " + this.stringhash + " connected to " + entity.descriptor() + " (status:" + this.status + ") ts: " + this.ts;
    }

    public String hash() throws DetectRightException {
        return Functions.md5(Functions.strtolower(String.valueOf(this.pointertype) + "/" + this.stringhash + "/" + this.entityhash));
    }

    public LinkedHashMap<String, Object> toArray() throws DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Object> retArray = new LinkedHashMap<String, Object>();
        EntityCore entity = this.getEntity();
        if (entity == null) {
            return retArray;
        }
        retArray.put(this.pointertype, this.pointertype);
        retArray.put("entitytype", entity.entitytype);
        retArray.put("entityid", this.entityid);
        retArray.put("entityhash", this.entityhash);
        retArray.put("category", entity.category);
        retArray.put("description", entity.description);
        retArray.put("majorrevision", this.majorrevision);
        retArray.put("minorrevision", this.minorrevision);
        retArray.put("subclass", this.subclass);
        retArray.put("connection", this.connection);
        retArray.put("build", this.build);
        retArray.put("owner", this.owner);
        retArray.put("status", this.status);
        return retArray;
    }

    public String toString() {
        ArrayList<String> output = new ArrayList<String>();
        LinkedHashMap<String, Object> retArray = null;
        try {
            retArray = this.toArray();
        }
        catch (DetectRightException de) {
            return "DetectRightException";
        }
        catch (ConnectionLostException c) {
            return "ConnectionLostException";
        }
        ArrayList<String> keys = Functions.array_keys_string(retArray);
        for (String key : keys) {
            String value = key.concat(" = " + retArray.get(key).toString());
            output.add(value);
        }
        return Functions.implode("\n", output);
    }

    public long commit() {
        return 0L;
    }

    public EntityCore getEntity() throws DetectRightException, ConnectionLostException {
        DetectRight.checkPoint("Getting Entity for pointer this.stringhash");
        if (Functions.is_object(this.entity)) {
            return this.entity;
        }
        EntityCore entity = null;
        if (this.entityid > 0L && ((entity = EntityCore.getEntity(this.entityid)) == null || entity.id() == 0L) && (entity = EntityCore.getEntityFromHash(this.entityhash)) != null && entity.id() > 0L) {
            this.entityid = entity.id();
        }
        if (!Functions.is_object(entity)) {
            entity = new EntityCore(0L);
            entity.status = 2;
        }
        if (entity.status == 0) {
            this.status = 0;
        }
        entity.majorrevision = this.majorrevision;
        entity.minorrevision = this.minorrevision;
        entity.subclass = this.subclass;
        entity.connection = this.connection;
        entity.build = this.build;
        this.entity = entity;
        DetectRight.checkPoint("Got Entity for pointer this.stringhash");
        return entity;
    }

    public static PointerCore get() throws DetectRightException, ConnectionLostException {
        return new PointerCore(0L);
    }

    public static PointerCore get(long id) throws DetectRightException, ConnectionLostException {
        return new PointerCore(id);
    }

    public static PointerCore pointerFromRow(LinkedHashMap<String, Object> row) throws DetectRightException, ConnectionLostException {
        PointerCore pointer = new PointerCore();
        pointer.fill(row);
        return pointer;
    }

    public static ArrayList<PointerCore> getPointersForPointerString(String pointertype, String pointerstring) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(pointerstring)) {
            return null;
        }
        if (Functions.isEmpty(pointertype)) {
            return null;
        }
        DBLink dbl = dbLink.get();
        if (dbl == null) {
            throw new ConnectionLostException("Connection to DB lost");
        }
        String hash = PointerCore.makeHash(pointerstring);
        LinkedHashMap<String, Object> where = DBLink.whereClause("pointertype", pointertype);
        where.put("stringhash", hash);
        LinkedHashMap<String, Object> rows = dbl.simpleFetch(table, DBLink.allFields, where);
        ArrayList<PointerCore> output = new ArrayList<PointerCore>();
        LinkedHashMap<String, Object> tmpMap = rows;
        for (Map.Entry entry : tmpMap.entrySet()) {
            LinkedHashMap row = (LinkedHashMap)entry.getValue();
            output.add(PointerCore.pointerFromRow(row));
        }
        return output;
    }

    public static String makeHash(String ps) throws DetectRightException {
        if (ps == null) {
            return "";
        }
        String clean = PointerCore.punctClean(ps);
        String md5 = Functions.md5(clean);
        return md5;
    }

    public static String punctClean(String string) {
        if (string == null) {
            return "";
        }
        string = string.toLowerCase();
        String clean = string.replaceAll("[\\s-_/*]", "");
        clean = clean.replace("[", "");
        clean = clean.replace("]", "");
        clean = clean.replace(",", "");
        clean = clean.replace("?", "");
        clean = clean.replace("!", "");
        clean = clean.replace("&", "");
        clean = clean.replace("@", "");
        clean = clean.replace("#", "");
        clean = clean.replace("'", "");
        clean = clean.replace("=", "");
        clean = clean.replace(">", "");
        clean = clean.replace("<", "");
        clean = clean.replace("{", "");
        clean = clean.replace("}", "");
        clean = clean.replace("|", "");
        clean = clean.replace("%", "");
        clean = clean.replace("\\", "");
        clean = clean.replace("$", "");
        String ptn = "#[^\\;\\-\\)\\(\\d\\w\\/\\n\\r:.]#";
        clean = clean.replaceAll(ptn, "");
        return clean;
    }

    public static EntitySigCollection getESC(String pointerType, String pointerString) throws DetectRightException, ConnectionLostException {
        DetectRight.checkPoint("Getting pointer ESC");
        EntitySigCollection esc = new EntitySigCollection();
        DetectRight.checkPoint("Done new ESC");
        if (Functions.isEmpty(pointerType) || Functions.isEmpty(pointerString)) {
            return esc;
        }
        String stringhash = PointerCore.makeHash(pointerString);
        LinkedHashMap<String, Object> where = DBLink.whereClause("pointertype", pointerType);
        where.put("stringhash", stringhash);
        DBLink dbl = dbLink.get();
        if (dbl == null) {
            PointerCore.cacheDB();
            dbl = dbLink.get();
            if (dbl == null) {
                throw new ConnectionLostException("Connection to DB lost for thread" + Thread.currentThread().getName());
            }
        } else {
            DetectRight.checkPoint("Pointer DBL valid");
        }
        DetectRight.checkPoint("Fetching pointer data");
        LinkedHashMap<String, Object> pointers = null;
        try {
            pointers = dbl.simpleFetch(table, DBLink.allFields, where);
            if (pointers == null) {
                DetectRight.checkPoint("Null data");
                return esc;
            }
        }
        catch (ConnectionLostException ce) {
            DetectRight.checkPoint("Lost connection");
        }
        boolean useOwner = false;
        if (pointers.size() > 1) {
            useOwner = true;
        }
        LinkedHashMap<String, Object> tmpMap = pointers;
        for (Map.Entry entry : tmpMap.entrySet()) {
            EntityCore entity;
            LinkedHashMap pointerRow = (LinkedHashMap)entry.getValue();
            if (pointerRow == null) continue;
            PointerCore pointer = PointerCore.pointerFromRow(pointerRow);
            if (useOwner && pointer.owner == "SYSTEM") continue;
            if (pointer == null || (entity = pointer.getEntity()) == null || entity.id() <= -1L) break;
            esc.addEntity(entity);
            break;
        }
        return esc;
    }
}

