/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Datapoint;
import com.detectright.core.DetectRightException;
import com.detectright.core.Functions;
import com.detectright.core.Reflection;
import java.util.ArrayList;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Property
implements Cloneable {
    static int trustMin = 1;
    static Integer nullFlagValue = null;
    LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>>> contexts = new LinkedHashMap();
    ArrayList<String> done = new ArrayList();
    LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>>>> labels = new LinkedHashMap();
    public LinkedHashMap<String, Datapoint> datapoints = new LinkedHashMap();
    boolean locked = false;
    String property;

    static void main(String[] args) {
    }

    Property() {
        this("");
    }

    Property(String property) {
        this.property = property;
    }

    public Property clone() {
        Property cloneProperty = new Property(this.property);
        cloneProperty.datapoints = new LinkedHashMap();
        if (this.datapoints != null && this.datapoints.size() > 0) {
            ArrayList<String> dpKeys = Functions.array_keys_string(this.datapoints);
            for (String dpKey : dpKeys) {
                Datapoint dpClone;
                Datapoint dp = this.datapoints.get(dpKey);
                if (dp == null || (dpClone = dp.clone()) == null) continue;
                cloneProperty.datapoints.put(dpKey, dpClone);
            }
            cloneProperty.reindex();
        }
        return cloneProperty;
    }

    void lock() {
        this.applyLock(true);
    }

    void unlock() {
        this.applyLock(false);
    }

    void applyLock(boolean lockType) {
        this.locked = lockType;
        if (this.datapoints == null) {
            return;
        }
        ArrayList<String> keys = Functions.array_keys_string(this.datapoints);
        for (String key : keys) {
            Datapoint tmp = this.datapoints.get(key);
            if (tmp == null) continue;
            tmp.applyLock(lockType);
            tmp = null;
        }
    }

    boolean isLocked() {
        return this.locked;
    }

    public void __wakeup() {
        this.reindex();
    }

    public ArrayList<String> __sleep() {
        LinkedHashMap<String, Object> ov = Reflection.get_object_vars(this);
        ov.remove("labels");
        ov.remove("contexts");
        return Functions.array_keys_string(ov);
    }

    void addImportance(int importance) {
        if (importance == 0) {
            return;
        }
        ArrayList<String> dps = Functions.array_keys_string(this.datapoints);
        for (String hash : dps) {
            Datapoint dp = this.datapoints.get(hash);
            dp.addImportance(importance);
        }
    }

    void setSource(String source) {
        if (source == null) {
            return;
        }
        ArrayList<Integer> keys = Functions.array_keys(this.datapointHashes());
        for (Integer key : keys) {
            if (keys.get(key) == null) continue;
            this.datapoints.get(key).setSource(source);
        }
    }

    void setImportance(int importance) {
        ArrayList<String> dps = Functions.array_keys_string(this.datapoints);
        for (String hash : dps) {
            Datapoint dp = this.datapoints.get(hash);
            dp.setImportance(importance);
        }
    }

    void rebrand(String brand) {
        this.rebrand(brand, false);
    }

    void rebrand(String brand, boolean clear) {
        ArrayList<String> dps = Functions.array_keys_string(this.datapoints);
        if (dps == null) {
            return;
        }
        for (String hash : dps) {
            Datapoint dp = this.datapoints.get(hash);
            if (dp == null) continue;
            dp.addBrand(brand);
        }
    }

    void delete(Property propertyToDelete) {
        if (this.isLocked()) {
            return;
        }
        if (this.datapoints == null) {
            return;
        }
        if (Functions.isEmpty(propertyToDelete)) {
            return;
        }
        if (Functions.isEmpty(this.property)) {
            return;
        }
        if (!propertyToDelete.property.equals(this.property)) {
            return;
        }
        ArrayList<String> dpHashes = Functions.array_keys_string(propertyToDelete.datapoints);
        if (dpHashes != null) {
            for (String dpHash : dpHashes) {
                this.datapoints.remove(dpHash);
            }
        }
        this.reindex();
    }

    void merge(Property newProperty) {
        if (newProperty == null) {
            return;
        }
        if (newProperty.datapoints == null) {
            return;
        }
        ArrayList<String> hashes = Functions.array_keys_string(newProperty.datapoints);
        if (hashes == null) {
            return;
        }
        for (String hash : hashes) {
            Datapoint dp = newProperty.datapoints.get(hash);
            try {
                this.addDatapoint(dp, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (newProperty.isLocked()) continue;
            newProperty.datapoints.remove(hash);
        }
        this.reindex();
    }

    void reindex() {
        try {
            this.contexts = new LinkedHashMap();
            this.labels = new LinkedHashMap();
            ArrayList<String> hashes = Functions.array_keys_string(this.datapoints);
            for (String hash : hashes) {
                Datapoint datapoint = this.datapoints.get(hash);
                if (datapoint == null) {
                    this.datapoints.remove(hash);
                    continue;
                }
                String dpHash = datapoint.hash();
                this.addDatapointToContext(datapoint, dpHash);
                this.addDatapointToLabels(datapoint, dpHash);
                if (hash.equals(dpHash)) continue;
                this.datapoints.remove(hash);
                this.datapoints.put(dpHash, datapoint);
            }
        }
        catch (DetectRightException detectRightException) {
            // empty catch block
        }
    }

    void prune() {
        if (this.locked) {
            return;
        }
        ArrayList<String> hashes = Functions.array_keys_string(this.datapoints);
        for (String hash : hashes) {
            Datapoint dp = this.datapoints.get(hash);
            if (dp == null || dp.getAccessCount() != 0 || dp.isLocked()) continue;
            dp = null;
            this.datapoints.remove(hash);
        }
    }

    void resetCount(int cnt) {
        ArrayList<String> hashes = Functions.array_keys_string(this.datapoints);
        for (String hash : hashes) {
            Datapoint dp = this.datapoints.get(hash);
            if (dp == null) continue;
            dp.access_count = cnt;
        }
    }

    void resetCount() {
        this.resetCount(0);
    }

    void addDatapoint(Datapoint datapoint) throws DetectRightException {
        this.addDatapoint(datapoint, true);
    }

    void addDatapoint(Datapoint originalDatapoint, boolean index) throws DetectRightException {
        Datapoint datapoint = originalDatapoint.clone();
        datapoint.processValue();
        String ipHash = datapoint.hash();
        if (this.datapoints.containsKey(ipHash)) {
            Datapoint dp = this.datapoints.get(ipHash);
            try {
                dp.mergeWith(datapoint);
            }
            catch (Throwable throwable) {}
        } else {
            this.datapoints.put(ipHash, datapoint);
        }
        if (!index) {
            return;
        }
        this.addDatapointToContext(datapoint);
        try {
            this.addDatapointToLabels(datapoint);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void addDatapointToContext(Datapoint datapoint) throws DetectRightException {
        this.addDatapointToContext(datapoint, "");
    }

    void addDatapointToContext(Datapoint datapoint, String hash) throws DetectRightException {
        LinkedHashMap<String, ArrayList<String>> labels;
        LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>> contexts;
        String context = datapoint.context;
        String label = datapoint.label;
        String units = datapoint.units;
        if (Functions.isEmpty(hash)) {
            hash = datapoint.hash();
        }
        if (this.contexts == null) {
            this.contexts = new LinkedHashMap();
        }
        if (!this.contexts.containsKey(context)) {
            this.contexts.put(context, new LinkedHashMap());
        }
        if (!(contexts = this.contexts.get(context)).containsKey(label)) {
            contexts.put(label, new LinkedHashMap());
        }
        if (!(labels = contexts.get(label)).containsKey(units)) {
            labels.put(units, new ArrayList());
        }
        ArrayList<Object> tmpArray = new ArrayList();
        tmpArray = labels.get(units);
        tmpArray.add(hash);
    }

    void addDatapointToLabels(Datapoint datapoint) throws DetectRightException {
        this.addDatapointToLabels(datapoint, "");
    }

    void addDatapointToLabels(Datapoint datapoint, String hash) throws DetectRightException {
        LinkedHashMap<String, ArrayList<String>> unitsHM;
        LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>> contexts2;
        LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>>> labels;
        if (Functions.isEmpty(hash)) {
            hash = datapoint.hash();
        }
        String context = datapoint.context;
        String label = datapoint.label;
        String units = datapoint.units;
        if (this.labels == null) {
            this.labels = new LinkedHashMap();
        }
        if (!this.labels.containsKey(label)) {
            this.labels.put(label, new LinkedHashMap());
        }
        if (!(labels = this.labels.get(label)).containsKey(context)) {
            labels.put(context, new LinkedHashMap());
        }
        if (!(contexts2 = labels.get(context)).containsKey(units)) {
            contexts2.put(units, new LinkedHashMap());
        }
        if (!(unitsHM = contexts2.get(units)).containsKey(units)) {
            unitsHM.put(units, new ArrayList());
        }
        ArrayList<Object> tmpArray = new ArrayList();
        tmpArray = unitsHM.get(units);
        tmpArray.add(hash);
    }

    ArrayList<String> datapointHashes() {
        return Functions.array_keys_string(this.datapoints);
    }

    ArrayList<Datapoint> getValueFromExampleDP(Datapoint datapoint) throws DetectRightException {
        String context = Functions.nn(datapoint.context);
        String label = Functions.nn(datapoint.label);
        String units = Functions.nn(datapoint.units);
        String key = datapoint.getWildcardField();
        if (Functions.isEmpty(key)) {
            return new ArrayList<Datapoint>();
        }
        LinkedHashMap<Object, Object> tmpHM = new LinkedHashMap();
        ArrayList<Datapoint> output = new ArrayList<Datapoint>();
        if (this.contexts == null) {
            return output;
        }
        if (!this.contexts.containsKey(context)) {
            return output;
        }
        tmpHM = this.contexts.get(context);
        if (!tmpHM.containsKey(label)) {
            return output;
        }
        LinkedHashMap tmpHM2 = (LinkedHashMap)tmpHM.get(label);
        if (!tmpHM2.containsKey(units)) {
            return output;
        }
        ArrayList dpHashArray = (ArrayList)tmpHM2.get(units);
        LinkedHashMap<String, Datapoint> datapoints = new LinkedHashMap<String, Datapoint>();
        for (String hash : dpHashArray) {
            Datapoint dp = null;
            if (this.datapoints.containsKey(hash)) {
                dp = this.datapoints.get(hash);
            } else {
                ArrayList<String> dpKeys = Functions.array_keys_string(this.datapoints);
                for (String dpKey : dpKeys) {
                    Datapoint tmpDP2 = this.datapoints.get(dpKey);
                    String tmpDP2Hash = tmpDP2.hash();
                    if (tmpDP2Hash.equals(hash)) continue;
                    this.datapoints.remove(hash);
                    this.datapoints.put(tmpDP2Hash, tmpDP2);
                    dp = tmpDP2;
                    tmpDP2 = null;
                    hash = tmpDP2Hash;
                    break;
                }
            }
            if (dp == null || !dp.compliesWithDP(datapoint)) continue;
            dp.recordAccess();
            datapoints.put(hash, dp.clone());
        }
        ArrayList<Datapoint> dpArr = Datapoint.sortDatapoints(datapoints, key, "version", true);
        return dpArr;
    }

    ArrayList<String> toStringArray() {
        return this.toStringArray(false);
    }

    ArrayList<String> toStringArray(boolean optimize) {
        ArrayList<String> output = new ArrayList<String>();
        ArrayList<String> dps = this.datapointHashes();
        if (dps == null) {
            return output;
        }
        for (String hash : dps) {
            Datapoint dp = this.datapoints.get(hash);
            if (dp == null || optimize && dp.getAccessCount() == 0) continue;
            output.add(dp.toString());
        }
        return output;
    }

    ArrayList<Object> toArray() {
        ArrayList<Object> output = new ArrayList<Object>();
        ArrayList<String> dps = this.datapointHashes();
        if (dps == null) {
            return output;
        }
        for (String hash : dps) {
            Datapoint dp = this.datapoints.get(hash);
            if (dp == null) continue;
            output.add(dp.toArray());
        }
        return output;
    }

    public String toString() {
        ArrayList<String> output = this.toStringArray();
        return Functions.implode("\n", output);
    }

    void close() {
        ArrayList<String> keys;
        this.contexts = null;
        this.labels = null;
        if (this.datapoints != null && (keys = Functions.array_keys_string(this.datapoints)) != null) {
            for (String key : keys) {
                this.datapoints.put(key, null);
            }
            this.datapoints.clear();
        }
        this.datapoints = null;
    }
}

