/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Datapoint;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.Functions;
import com.detectright.core.Property;
import com.detectright.core.Reflection;
import java.util.ArrayList;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuantumDataCollection {
    public LinkedHashMap<String, Object> metadata = new LinkedHashMap();
    public ArrayList<Object> addedData = new ArrayList();
    public LinkedHashMap<String, Property> properties = new LinkedHashMap();
    public ArrayList<String> creator = new ArrayList();
    public ArrayList<String> brand = new ArrayList();
    public boolean branded;
    public boolean locked = false;

    public static void main(String[] args) {
    }

    public QuantumDataCollection() {
        this(new ArrayList<String>());
    }

    public QuantumDataCollection(ArrayList<String> creator) {
        if (creator == null) {
            creator = new ArrayList();
        }
        if (creator.size() == 0) {
            creator.add("Unknown");
        }
        this.brand.addAll(creator);
        this.branded = true;
    }

    public QuantumDataCollection(String creator) {
        if (Functions.isEmpty(creator)) {
            creator = "Unknown";
        }
        if (this.creator == null) {
            this.creator = new ArrayList();
        }
        if (this.brand == null) {
            this.brand = new ArrayList();
        }
        this.creator.add(creator);
        this.brand.add(creator);
        this.branded = true;
    }

    public QuantumDataCollection clone() {
        QuantumDataCollection qdcClone = new QuantumDataCollection();
        if (this.metadata != null) {
            qdcClone.metadata.putAll(this.metadata);
        }
        if (this.addedData != null) {
            qdcClone.addedData.addAll(this.addedData);
        }
        qdcClone.properties = new LinkedHashMap();
        if (this.properties != null && this.properties.size() > 0) {
            ArrayList<String> propKeys = Functions.array_keys_string(this.properties);
            for (String propKey : propKeys) {
                Property prop = this.properties.get(propKey);
                if (prop == null) continue;
                qdcClone.properties.put(propKey, prop.clone());
            }
        }
        if (this.creator != null) {
            qdcClone.creator.addAll(this.creator);
        }
        if (this.brand != null) {
            qdcClone.brand.addAll(this.brand);
        }
        qdcClone.branded = this.branded;
        return qdcClone;
    }

    public void __wakeup() {
    }

    public ArrayList<String> __sleep() {
        LinkedHashMap<String, Object> ov = Reflection.get_object_vars(this);
        ov.remove("locked");
        return Functions.array_keys_string(ov);
    }

    public void prune() {
        if (this.locked) {
            return;
        }
        ArrayList<String> propKeys = Functions.array_keys_string(this.properties);
        for (String propKey : propKeys) {
            Property propertyObject = this.properties.get(propKey);
            if (propertyObject == null) continue;
            propertyObject.prune();
            if (propertyObject.datapoints.size() != 0 || propertyObject.isLocked()) continue;
            propertyObject = null;
            this.properties.remove(propKey);
        }
    }

    boolean isLocked() {
        return this.locked;
    }

    void lock() {
        this.applyLock(true);
    }

    void unlock() {
        this.applyLock(false);
    }

    void applyLock(boolean lockType) {
        this.locked = lockType;
        if (this.properties == null) {
            return;
        }
        ArrayList<String> propKeys = Functions.array_keys_string(this.properties);
        for (String propKey : propKeys) {
            Property propertyObject = this.properties.get(propKey);
            if (propertyObject == null) continue;
            propertyObject.applyLock(lockType);
        }
    }

    public boolean addQDC(QuantumDataCollection newQDC) throws DetectRightException {
        boolean log = DetectRight.getLOG();
        if (!Functions.is_object(newQDC)) {
            return false;
        }
        if (newQDC.properties == null) {
            return false;
        }
        if (newQDC.properties.size() == 0) {
            return true;
        }
        ArrayList<String> propKeys = Functions.array_keys_string(newQDC.properties);
        for (String propKey : propKeys) {
            Property propertyObject = newQDC.properties.get(propKey);
            if (!this.properties.containsKey(propKey)) {
                this.properties.put(propKey, propertyObject);
            } else {
                Property tmpProperty = this.properties.get(propKey);
                tmpProperty.merge(propertyObject);
                if (log) {
                    Functions.dr_echo("Done " + propKey + "\n");
                }
            }
            if (this.locked) continue;
            newQDC.properties.remove(propKey);
        }
        if (newQDC.metadata != null) {
            this.metadata.putAll(newQDC.metadata);
        }
        return true;
    }

    public void addDatapoint(Datapoint datapoint) throws DetectRightException {
        if (datapoint == null) {
            return;
        }
        String property = datapoint.property;
        Property propertyObject = this.addProperty(property);
        if (propertyObject != null) {
            propertyObject.addDatapoint(datapoint);
        }
    }

    public Property addProperty(String property) {
        if (property == null) {
            return null;
        }
        if (!this.properties.containsKey(property)) {
            Property propertyObject = new Property(property);
            this.properties.put(property, propertyObject);
            return propertyObject;
        }
        return this.properties.get(property);
    }

    public void addBrand() {
        this.addBrand("", false);
    }

    public void addBrand(String brand) {
        this.addBrand(brand, false);
    }

    public void addBrand(String brand, boolean force) {
        if (this.brand == null) {
            this.brand = new ArrayList();
        }
        if (this.creator == null) {
            this.creator = new ArrayList();
        }
        if (!this.brand.contains(brand)) {
            this.brand.add(brand);
        }
        if (!this.creator.contains(brand)) {
            this.creator.add(brand);
        }
        if (this.properties == null) {
            return;
        }
        if (!this.branded || !this.creator.contains(brand) || force) {
            if (this.properties.size() == 0) {
                return;
            }
            ArrayList<String> keys = Functions.array_keys_string(this.properties);
            for (String key : keys) {
                Property tmpProp = this.properties.get(key);
                if (tmpProp == null) continue;
                tmpProp.rebrand(brand);
            }
        }
        this.branded = true;
    }

    public void addImportance(int importance) {
        if (this.properties == null) {
            return;
        }
        if (this.properties.size() == 0) {
            return;
        }
        if (importance == 0) {
            return;
        }
        ArrayList<String> keys = Functions.array_keys_string(this.properties);
        for (String key : keys) {
            Property tmpProp = this.properties.get(key);
            if (tmpProp == null) continue;
            tmpProp.addImportance(importance);
        }
    }

    public void resetCount(int cnt) {
        if (this.properties == null) {
            return;
        }
        if (this.properties.size() == 0) {
            return;
        }
        ArrayList<String> keys = Functions.array_keys_string(this.properties);
        for (String key : keys) {
            Property tmpProp = this.properties.get(key);
            tmpProp.resetCount(cnt);
        }
    }

    public void resetCount() {
        this.resetCount(0);
    }

    public void setImportance(int importance) {
        if (this.properties == null) {
            return;
        }
        if (this.properties.size() == 0) {
            return;
        }
        ArrayList<String> keys = Functions.array_keys_string(this.properties);
        for (String key : keys) {
            Property tmpProp = this.properties.get(key);
            tmpProp.setImportance(importance);
        }
    }

    public void rebrand() {
        this.rebrand("");
    }

    public void rebrand(String brand) {
        if (brand == null) {
            return;
        }
        this.addBrand(brand, true);
    }

    public ArrayList<Datapoint> getValueArrayFromExampleDP(Datapoint datapoint) throws DetectRightException {
        if (datapoint == null) {
            return null;
        }
        if (this.properties == null) {
            return null;
        }
        ArrayList<Datapoint> datapoints = new ArrayList<Datapoint>();
        String property = datapoint.property;
        if (!this.properties.containsKey(property)) {
            return datapoints;
        }
        Property propertyObject = this.properties.get(property);
        datapoints = propertyObject.getValueFromExampleDP(datapoint);
        return datapoints;
    }

    public ArrayList<String> toStringArray() {
        return this.toStringArray("//");
    }

    public ArrayList<String> toStringArray(String path) {
        return this.toStringArray(path, false);
    }

    public void setSource(String source) {
        ArrayList<String> properties = Functions.array_keys_string(this.properties);
        for (String propKey : properties) {
            Property property = this.properties.get(propKey);
            property.setSource(source);
        }
    }

    public ArrayList<String> toStringArray(String path, boolean optimize) {
        ArrayList<String> output = new ArrayList<String>();
        if (this.properties == null) {
            return output;
        }
        if (path == null) {
            path = "";
        }
        ArrayList<String> properties = Functions.array_keys_string(this.properties);
        for (String propKey : properties) {
            Property property = this.properties.get(propKey);
            if (property == null) continue;
            ArrayList<String> dps = property.toStringArray(optimize);
            for (String dp : dps) {
                output.add(String.valueOf(path) + dp);
            }
        }
        return output;
    }

    public String toString() {
        ArrayList<String> array = this.toStringArray();
        if (Functions.isEmpty(array)) {
            return "";
        }
        return Functions.implode("\n", array);
    }

    void close() {
        if (this.locked) {
            return;
        }
        if (this.properties != null) {
            ArrayList<String> keys = Functions.array_keys_string(this.properties);
            for (String key : keys) {
                if (this.properties.get(key) != null) {
                    Property prop = this.properties.get(key);
                    prop.close();
                    prop = null;
                }
                this.properties.put(key, null);
            }
        }
        this.properties = null;
    }

    int propSize() {
        if (this.properties == null) {
            return 0;
        }
        return this.properties.size();
    }
}

