/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.Functions;
import com.detectright.core.PhpObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Reflection {
    static String packageName;

    static {
        Reflection ref = new Reflection();
        packageName = ref.getClass().getPackage().getName();
    }

    static void main(String[] args) {
    }

    static String cn(String className) {
        if (className == null) {
            return null;
        }
        if (className.startsWith(packageName)) {
            return className;
        }
        String output = String.valueOf(packageName) + "." + className;
        return output;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean function_exists(String className, String function) {
        if (Functions.isEmpty(className)) {
            return false;
        }
        if (Functions.isEmpty(function)) {
            return false;
        }
        try {
            String mName;
            Method m;
            Class<?> c;
            if (!className.contains(".")) {
                className = Reflection.cn(className);
            }
            if ((c = Class.forName(className)) == null) {
                return false;
            }
            Method[] mColl = c.getDeclaredMethods();
            if (mColl == null) {
                return false;
            }
            Method[] methodArray = mColl;
            int n = mColl.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    mColl = c.getMethods();
                    if (mColl != null) break;
                    return false;
                }
                m = methodArray[n2];
                if (m != null && (mName = m.getName()) != null && mName.equals(function)) {
                    return true;
                }
                ++n2;
            }
            methodArray = mColl;
            n = mColl.length;
            n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                m = methodArray[n2];
                if (m != null && (mName = m.getName()).equals(function)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    static boolean function_exists(Object obj, String function) {
        if (Functions.isEmpty(function)) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        try {
            Class<?> cls = obj.getClass();
            if (cls == null) {
            }
            String className = cls.getName();
            return Reflection.function_exists(className, function);
        }
        finally {
            return false;
        }
    }

    static boolean property_serializable(Object obj, String property) {
        if (obj == null) {
            return false;
        }
        if (Functions.isEmpty(property)) {
            return false;
        }
        try {
            Class<?> c = obj.getClass();
            if (c == null) {
            }
            if (c.isEnum()) {
            }
            Field f = Reflection.getField(c, property);
            if (f == null) {
            }
            f.setAccessible(true);
            if (Reflection.isStatic(f)) {
            }
            return true;
        }
        finally {
            return false;
        }
    }

    static boolean property_serializable(String className, String property) {
        if (Functions.isEmpty(className)) {
            return false;
        }
        if (Functions.isEmpty(property)) {
            return false;
        }
        try {
            Class<?> c;
            if (!className.contains(".")) {
                className = Reflection.cn(className);
            }
            if ((c = Class.forName(className)) == null) {
            }
            if (c.isEnum()) {
            }
            Field f = Reflection.getField(c, property);
            if (f == null) {
            }
            f.setAccessible(true);
            if (Reflection.isStatic(f)) {
            }
            return true;
        }
        finally {
            return false;
        }
    }

    static boolean isPublic(Method method) throws NoSuchMethodException {
        if (method == null) {
            throw new NoSuchMethodException("Modifier requested for null method");
        }
        return Modifier.isPublic(method.getModifiers());
    }

    static boolean isPublic(Field field) throws NoSuchFieldException {
        if (field == null) {
            throw new NoSuchFieldException("Modifier requested for null field");
        }
        return Modifier.isPublic(field.getModifiers());
    }

    static boolean isProtected(Method method) throws NoSuchMethodException {
        if (method == null) {
            throw new NoSuchMethodException("Modifier requested for null method");
        }
        return Modifier.isProtected(method.getModifiers());
    }

    static boolean isProtected(Field field) throws NoSuchFieldException {
        if (field == null) {
            throw new NoSuchFieldException("Modifier requested for null field");
        }
        return Modifier.isProtected(field.getModifiers());
    }

    static boolean isPrivate(Method method) throws NoSuchMethodException {
        if (method == null) {
            throw new NoSuchMethodException("Modifier requested for null method");
        }
        return Modifier.isPrivate(method.getModifiers());
    }

    static boolean isPrivate(Field field) throws NoSuchFieldException {
        if (field == null) {
            throw new NoSuchFieldException("Modifier requested for null field");
        }
        return Modifier.isPrivate(field.getModifiers());
    }

    static boolean isStatic(Method method) throws NoSuchMethodException {
        if (method == null) {
            throw new NoSuchMethodException("Modifier requested for null method");
        }
        return Modifier.isStatic(method.getModifiers());
    }

    static boolean isStatic(Field field) throws NoSuchFieldException {
        if (field == null) {
            throw new NoSuchFieldException("Modifier requested for null field");
        }
        return Modifier.isStatic(field.getModifiers());
    }

    static boolean property_exists(String className, String property) {
        if (Functions.isEmpty(className)) {
            return false;
        }
        if (Functions.isEmpty(property)) {
            return false;
        }
        try {
            Class<?> c;
            if (!className.contains(".")) {
                className = Reflection.cn(className);
            }
            if ((c = Class.forName(className)) == null) {
            }
            if (c.isEnum()) {
            }
            Field f = Reflection.getField(c, property);
            if (f == null) {
            }
            return true;
        }
        finally {
            return false;
        }
    }

    static boolean property_exists(Object obj, String property) {
        if (obj == null) {
            return false;
        }
        if (Functions.isEmpty(property)) {
            return false;
        }
        try {
            Class<?> c = obj.getClass();
            if (c == null) {
            }
            if (c.isEnum()) {
            }
            Field f = Reflection.getField(c, property);
            if (f == null) {
            }
            return true;
        }
        finally {
            return false;
        }
    }

    static boolean method_exists(String className, String property) {
        if (Functions.isEmpty(property)) {
            return false;
        }
        if (Functions.isEmpty(className)) {
            return false;
        }
        if (!className.contains(".")) {
            className = Reflection.cn(className);
        }
        return Reflection.function_exists(className, property);
    }

    static boolean method_exists(Object obj, String property) {
        if (obj == null) {
            return false;
        }
        if (Functions.isEmpty(property)) {
            return false;
        }
        return Reflection.function_exists(obj, property);
    }

    static Field getField(String className, String key) throws DetectRightException {
        Class<?> c;
        if (Functions.isEmpty(key)) {
            return null;
        }
        if (Functions.isEmpty(className)) {
            return null;
        }
        if (!className.contains(".")) {
            className = Reflection.cn(className);
        }
        try {
            c = Class.forName(className);
            if (c == null) {
                return null;
            }
        }
        catch (Throwable e) {
            DetectRight.checkPoint(e.toString());
            return null;
        }
        return Reflection.getField(c, key);
    }

    static Field getField(Object o, String key) throws DetectRightException {
        if (o == null) {
            return null;
        }
        if (Functions.isEmpty(key)) {
            return null;
        }
        Class<?> c = o.getClass();
        return Reflection.getField(c, key);
    }

    static Field getStaticField(Class<?> c, String key) throws DetectRightException {
        if (c == null) {
            return null;
        }
        if (Functions.isEmpty(key)) {
            return null;
        }
        try {
            Field f = c.getDeclaredField(key);
            return f;
        }
        catch (NoSuchFieldException e) {
            DetectRight.checkPoint("Get Field 2" + key + " " + c.toString() + " " + e.toString());
        }
        catch (SecurityException e) {
            DetectRight.checkPoint(e.toString());
            return null;
        }
        try {
            Field f = c.getField(key);
            return f;
        }
        catch (NoSuchFieldException e) {
            c.toString().equals("java.lang.String");
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    static Field getField(Class<?> c, String key) throws DetectRightException {
        if (Functions.isEmpty(key)) {
            return null;
        }
        if (c == null) {
            return null;
        }
        try {
            Field f = c.getField(key);
            return f;
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException e) {
            return null;
        }
        try {
            Field f = c.getDeclaredField(key);
            return f;
        }
        catch (NoSuchFieldException e) {
            DetectRight.checkPoint("Get Field 2" + key + " " + c.toString() + " " + e.toString());
            return null;
        }
        catch (SecurityException e) {
            DetectRight.checkPoint(e.toString());
            return null;
        }
    }

    static boolean fill(Object obj, Map<String, Object> hm) {
        if (obj == null) {
            return false;
        }
        if (hm == null) {
            return false;
        }
        if (hm.size() == 0) {
            return false;
        }
        try {
            for (Map.Entry<String, Object> entry : hm.entrySet()) {
                String key = entry.getKey();
                if (key == null) continue;
                ArrayList<Object> value = entry.getValue();
                if (value != null && ((Object)value).toString().toUpperCase().equals("NULL")) {
                    value = null;
                }
                if (value instanceof PhpObject) {
                    PhpObject phpTmp = (PhpObject)((Object)value);
                    value = phpTmp.getRealObject();
                }
                Field f = null;
                try {
                    f = Reflection.getField(obj, key);
                }
                catch (Throwable e) {
                    DetectRight.checkPoint("Error getting field " + key + " from " + obj.toString());
                    DetectRight.checkPoint(e.toString());
                }
                if (f == null) continue;
                String fname = "";
                try {
                    f.setAccessible(true);
                    Class<?> varType = f.getType();
                    fname = varType.getName();
                    if (fname == null) continue;
                    if (value == null) {
                        if (!fname.contains(".")) continue;
                        f.set(obj, null);
                        continue;
                    }
                    if (fname.equals("java.lang.Integer") || fname.equals("int")) {
                        value = Integer.valueOf(((Object)value).toString());
                    } else if (fname.equals("java.lang.Long") || fname.equals("long")) {
                        value = Long.valueOf(((Object)value).toString());
                    } else if (fname.equals("java.lang.Boolean") || fname.equals("boolean")) {
                        value = Functions.to_boolean(((Object)value).toString());
                    } else if (fname.equals("java.lang.Double") || fname.equals("double")) {
                        value = Double.parseDouble(((Object)value).toString());
                    } else if (fname.equals("java.lang.Float") || fname.equals("float")) {
                        value = Float.valueOf(Float.parseFloat(((Object)value).toString()));
                    } else if (fname.equals("java.util.ArrayList")) {
                        if (value instanceof LinkedHashMap) {
                            value = Functions.array_values((LinkedHashMap)((Object)value));
                        } else if (value instanceof String) {
                            String valueStr = (String)((Object)value);
                            ArrayList<String> valueArr = new ArrayList<String>();
                            valueArr.add(valueStr);
                            value = valueArr;
                        }
                    } else if (fname.equals("java.lang.String")) {
                        value = ((Object)value).toString();
                    }
                    f.set(obj, value);
                }
                catch (Throwable e) {
                    DetectRight.checkPoint("Reflection fill error " + fname + " " + e.getMessage() + " on value " + value + " for field " + f.toString());
                }
            }
            return true;
        }
        catch (Exception e) {
            try {
                DetectRight.checkPoint("Reflection fill error " + e.getMessage() + " for object " + obj.toString() + " with data " + hm.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    static boolean setThreadedLocal(String classname, String field, Object value) {
        Class<?> c;
        block7: {
            block6: {
                if (Functions.isEmpty(classname)) {
                    return false;
                }
                if (Functions.isEmpty(field)) {
                    return false;
                }
                try {
                    c = Class.forName(Reflection.cn(classname));
                    if (c != null) break block6;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (!c.isEnum()) break block7;
            return false;
        }
        Field f = Reflection.getField(c, field);
        ThreadLocal o = (ThreadLocal)f.get(null);
        o.set(value);
        return true;
    }

    static boolean setStaticValue(String classname, String field, Object value) {
        if (Functions.isEmpty(classname)) {
            return false;
        }
        if (Functions.isEmpty(field)) {
            return false;
        }
        if (!classname.contains(".")) {
            classname = Reflection.cn(classname);
        }
        try {
            Class<?> c = Class.forName(classname);
            if (c == null) {
            }
            if (c.isEnum()) {
            }
            Field f = Reflection.getStaticField(c, field);
            if (f == null) {
            }
            if (!Reflection.isStatic(f)) {
            }
            Class<?> varType = f.getType();
            String fname = varType.getName();
            if (fname.equals("java.lang.Integer") || fname.equals("int")) {
                value = Integer.valueOf(((Object)value).toString());
            } else if (fname.equals("java.lang.Long") || fname.equals("long")) {
                value = Long.valueOf(((Object)value).toString());
            } else if (fname.equals("java.lang.Boolean") || fname.equals("boolean")) {
                value = Functions.to_boolean(((Object)value).toString());
            } else if (fname.equals("java.lang.Double") || fname.equals("double")) {
                value = Double.parseDouble(((Object)value).toString());
            } else if (fname.equals("java.lang.Float") || fname.equals("float")) {
                value = Float.valueOf(Float.parseFloat(((Object)value).toString()));
            } else if (fname.equals("java.util.ArrayList") && value instanceof LinkedHashMap) {
                value = Functions.array_values((LinkedHashMap)((Object)value));
            }
            f.setAccessible(true);
            f.set(null, value);
        }
        finally {
            return false;
        }
        return true;
    }

    static boolean setValue(Object o, String field, Object value) {
        if (o == null) {
            return false;
        }
        if (Functions.isEmpty(field)) {
            return false;
        }
        try {
            Class<?> c = o.getClass();
            if (c == null) {
            }
            if (c.isEnum()) {
            }
            Field f = Reflection.getField(c, field);
            if (f == null) {
            }
            Class<?> varType = f.getType();
            String fname = varType.getName();
            if (fname.equals("java.lang.Integer") || fname.equals("int")) {
                value = Integer.valueOf(((Object)value).toString());
            } else if (fname.equals("java.lang.Long") || fname.equals("long")) {
                value = Long.valueOf(((Object)value).toString());
            } else if (fname.equals("java.lang.Boolean") || fname.equals("boolean")) {
                value = Functions.to_boolean(((Object)value).toString());
            } else if (fname.equals("java.lang.Double") || fname.equals("double")) {
                value = Double.parseDouble(((Object)value).toString());
            } else if (fname.equals("java.lang.Float") || fname.equals("float")) {
                value = Float.valueOf(Float.parseFloat(((Object)value).toString()));
            } else if (fname.equals("java.util.ArrayList") && value instanceof LinkedHashMap) {
                value = Functions.array_values((LinkedHashMap)((Object)value));
            }
            f.set(o, value);
        }
        finally {
            return false;
        }
    }

    static Object invokeStaticMethodWithObject(String classname, String methodName, Object object) throws DetectRightException {
        if (Functions.isEmpty(classname)) {
            return false;
        }
        if (Functions.isEmpty(methodName)) {
            return false;
        }
        if (object == null) {
            return null;
        }
        return Reflection.invokeStaticMethodWithObject(classname, methodName, object.getClass().getName(), object);
    }

    static Object invokeStaticMethodWithObject(String classname, String methodName, String objectClass, Object object) throws DetectRightException {
        Class<?> c;
        block7: {
            if (Functions.isEmpty(classname)) {
                return false;
            }
            if (Functions.isEmpty(methodName)) {
                return false;
            }
            if (Functions.isEmpty(objectClass)) {
                return false;
            }
            try {
                c = Class.forName(Reflection.cn(classname));
                if (c != null) break block7;
                return null;
            }
            catch (Throwable e) {
                DetectRight.checkPoint(e.getMessage());
                DetectRight.checkPoint("Failed to invoke static method with object " + classname + " " + methodName);
                return null;
            }
        }
        Class[] classList = new Class[]{Class.forName(Reflection.cn(objectClass))};
        Method m = c.getDeclaredMethod(methodName, classList);
        if (m == null) {
            return false;
        }
        Object[] arglist = new Object[]{object};
        Object retObj = m.invoke(null, arglist);
        return retObj;
    }

    static Object invokeMethod(Object o, String methodName) {
        Object retObj;
        if (Functions.isEmpty(methodName)) {
            return null;
        }
        if (o == null) {
            return null;
        }
        try {
            Class<?> c = o.getClass();
            if (c == null) {
            }
            Method m = c.getMethod(methodName, new Class[0]);
            retObj = m.invoke(o, new Object[0]);
        }
        finally {
            return null;
        }
        return retObj;
    }

    static Object invokeMethodWithString(Object o, String methodName, String value) {
        Object retObj;
        if (o == null) {
            return null;
        }
        if (Functions.isEmpty(methodName)) {
            return null;
        }
        try {
            Class<?> c = o.getClass();
            if (c == null) {
            }
            Method m = c.getMethod(methodName, new Class[0]);
            Object[] arglist = new Object[]{value};
            retObj = m.invoke(o, arglist);
        }
        finally {
            return null;
        }
        return retObj;
    }

    static Object getProperty(Object o, String field) {
        Object retObj;
        if (o == null) {
            return null;
        }
        if (Functions.isEmpty(field)) {
            return null;
        }
        try {
            Class<?> c = o.getClass();
            Field f = Reflection.getField(c, field);
            if (f == null) {
            }
            f.setAccessible(true);
            retObj = f.get(o);
        }
        finally {
            return null;
        }
        return retObj;
    }

    static ArrayList<Field> getFields(Class<?> cls) {
        if (cls == null) {
            return new ArrayList<Field>();
        }
        ArrayList<Field> output = new ArrayList<Field>();
        try {
            Field[] fieldlist = cls.getFields();
            output.addAll(Arrays.asList(fieldlist));
            fieldlist = cls.getDeclaredFields();
            int i = 0;
            while (i < fieldlist.length) {
                Field fld = fieldlist[i];
                if (fld != null && !output.contains(fld)) {
                    output.add(fld);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return output;
    }

    static LinkedHashMap<String, Object> get_object_vars(Object o) {
        if (o == null) {
            return new LinkedHashMap<String, Object>();
        }
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        try {
            Class<?> cls = o.getClass();
            ArrayList<Field> fieldlist = Reflection.getFields(cls);
            int i = 0;
            while (i < fieldlist.size()) {
                Field fld = fieldlist.get(i);
                if (fld != null && !fld.isEnumConstant() && !Reflection.isStatic(fld)) {
                    fld.setAccessible(true);
                    String key = fld.getName();
                    Object value = fld.get(o);
                    output.put(key, value);
                }
                ++i;
            }
        }
        catch (Throwable e) {
            return null;
        }
        return output;
    }

    static Object wakeUp(String className, Map<String, Object> data) {
        Object newObject;
        Class<?> c;
        if (Functions.isEmpty(className)) {
            return null;
        }
        if (className == null) {
            return null;
        }
        try {
            c = Class.forName(Reflection.cn(className));
            if (c == null) {
                return null;
            }
        }
        catch (Throwable e) {
            return null;
        }
        try {
            Method m = c.getMethod("wakeUp", new Class[0]);
            Object[] arglist = new Object[]{data};
            newObject = m.invoke(null, arglist);
        }
        catch (NoSuchMethodException e) {
            return Reflection.wakeUpNaked(c, data);
        }
        catch (IllegalAccessException e) {
            return Reflection.wakeUpNaked(c, data);
        }
        catch (InvocationTargetException e) {
            return null;
        }
        return newObject;
    }

    static Object newObject(String className) {
        Object returnObject;
        Class<?> c;
        if (Functions.isEmpty(className)) {
            return null;
        }
        try {
            c = Class.forName(Reflection.cn(className));
        }
        catch (Throwable e) {
            return null;
        }
        try {
            returnObject = c.newInstance();
        }
        catch (Throwable e) {
            return null;
        }
        return returnObject;
    }

    private static Object wakeUpNaked(Class<?> c, Map<String, Object> data) {
        Object returnObject;
        if (c == null) {
            return null;
        }
        try {
            returnObject = c.newInstance();
        }
        catch (Throwable e) {
            return null;
        }
        if (data != null && data.size() > 0) {
            Reflection.fill(returnObject, data);
        }
        try {
            Method m = c.getMethod("__wakeup", new Class[0]);
            Object[] arglist = new Object[]{};
            m.invoke(returnObject, arglist);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnObject;
    }
}

