/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Cache;
import com.detectright.core.ConnectionLostException;
import com.detectright.core.DBLink;
import com.detectright.core.Dataquery;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.Functions;
import com.detectright.core.QuantumDataTree;
import com.detectright.core.Reflection;
import com.detectright.core.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaPropertyCore {
    public static ThreadLocal<DBLink> dbLink = new ThreadLocal();
    public static ThreadLocal<Cache> cacheLink = new ThreadLocal();
    public static volatile LinkedHashMap<String, Object> cacheArray = new LinkedHashMap();
    public long ID;
    public String property;
    public String property_desc;
    public String type;
    public String component;
    public String schema;
    public String validation_type;
    public String validation_type_export;
    public int validate_on_export = 1;
    public int error_trap = 0;
    public String default_value = "";
    public String delimiter;
    public String display_name;
    public String misc_properties;
    public int trust_offset = 0;
    public String output_map;
    public ArrayList<String> ignore_values;
    public ArrayList<String> true_values;
    public ArrayList<String> false_values;
    public boolean export_property;
    public String preferred_order;
    public boolean use_subtree;
    public String pk;
    public String error;
    public LinkedHashMap<String, Object> fieldList;
    public static String table = "schema_properties";
    public String tablename = "";
    private static LinkedHashMap<String, LinkedHashMap<String, SchemaPropertyCore>> schemas = new LinkedHashMap();
    public static String PK = "ID";
    public static ArrayList<String> fields = new ArrayList<String>(Arrays.asList("ID", "property", "type", "component", "schema", "validate_on_export", "validation_type", "validation_type_export", "delimiter", "output_map", "trust_offset", "display_name", "error_trap", "default_value", "property_desc", "ignore_values", "true_values", "false_values", "export_property", "preferred_order", "misc_properties", "use_subtree"));

    static {
        DetectRight.registerClass("SchemaPropertyCore");
        try {
            if (Functions.is_null(cacheLink.get())) {
                cacheLink.set(DetectRight.getCacheLink());
            }
            if (Functions.is_null(dbLink.get())) {
                dbLink.set(DetectRight.getDBLink());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
    }

    public SchemaPropertyCore() throws DetectRightException, ConnectionLostException {
        this(0L, "", "");
    }

    public SchemaPropertyCore(long ID) throws DetectRightException, ConnectionLostException {
        this(ID, "", "");
    }

    public SchemaPropertyCore(String schema, String property) throws DetectRightException, ConnectionLostException {
        this(0L, schema, property);
    }

    public SchemaPropertyCore(String property) throws DetectRightException, ConnectionLostException {
        this(0L, "", property);
    }

    public SchemaPropertyCore(long ID, String schema, String property) throws DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Object> result;
        SchemaPropertyCore.cacheDB();
        if (ID == 0L && Functions.isEmpty(property)) {
            return;
        }
        LinkedHashMap data = new LinkedHashMap();
        this.fieldList = Functions.arr2hm(fields);
        this.pk = PK;
        this.tablename = table;
        LinkedHashMap<String, Object> where = new LinkedHashMap<String, Object>();
        if (ID > 0L) {
            where.put(this.pk, String.valueOf(ID));
        } else {
            if (!Functions.isEmpty(schema)) {
                where.put("schema", schema);
            }
            where.put("property", property);
        }
        DBLink dbl = dbLink.get();
        if (dbl == null) {
            SchemaPropertyCore.cacheDB();
            dbl = dbLink.get();
            if (dbl == null) {
                throw new ConnectionLostException("Connection lost in Schema Properties");
            }
        }
        if ((result = dbl.simpleFetch(this.tablename, DBLink.allFields, where)) == null) {
            return;
        }
        if (result.size() == 0) {
            return;
        }
        data = (LinkedHashMap)Functions.array_shift(result);
        this.true_values = new ArrayList();
        this.false_values = new ArrayList();
        this.ignore_values = new ArrayList();
        SchemaPropertyCore.process(data);
        this.fill(data);
    }

    public void fill(LinkedHashMap<String, Object> data) {
        Object tmpObj;
        String vol;
        if (data == null) {
            return;
        }
        if (data.containsKey("ID")) {
            this.ID = Functions.gvLong(data, "ID", 0L);
        }
        if (data.containsKey("validate_on_export")) {
            vol = Functions.gvString(data, "validate_on_export");
            if (vol.equals("1")) {
                this.validate_on_export = 1;
            } else if (vol.equals("0")) {
                this.validate_on_export = 0;
            }
        }
        if (data.containsKey("error_trap")) {
            vol = Functions.gvString(data, "error_trap");
            if (vol.equals("1")) {
                this.error_trap = 1;
            } else if (vol.equals("0")) {
                this.error_trap = 0;
            }
        }
        if (data.containsKey("trust_offset")) {
            vol = Functions.gvString(data, "trust_offset");
            try {
                this.trust_offset = Functions.parseInt(vol);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (data.containsKey("use_subtree")) {
            vol = Functions.gvString(data, "use_subtree");
            if (vol.equals("1")) {
                this.use_subtree = true;
            } else if (vol.equals("0")) {
                this.use_subtree = false;
            }
        }
        if (data.containsKey("export_property")) {
            vol = Functions.gvString(data, "export_property");
            if (vol.equals("1")) {
                this.export_property = true;
            } else if (vol.equals("0")) {
                this.export_property = false;
            }
        }
        if (data.containsKey("property")) {
            this.property = Functions.gvString(data, "property");
        }
        if (data.containsKey("type")) {
            this.type = Functions.gvString(data, "type");
        }
        if (data.containsKey("component")) {
            this.component = Functions.gvString(data, "component");
        }
        if (data.containsKey("schema")) {
            this.schema = Functions.gvString(data, "schema");
        }
        if (data.containsKey("validation_type_export")) {
            this.validation_type_export = Functions.gvString(data, "validation_type_export");
        }
        if (data.containsKey("validation_type")) {
            this.validation_type = Functions.gvString(data, "validation_type");
        }
        if (data.containsKey("delimiter")) {
            this.delimiter = Functions.gvString(data, "delimiter");
        }
        if (data.containsKey("output_map")) {
            this.output_map = Functions.gvString(data, "output_map");
        }
        if (data.containsKey("display_name")) {
            this.display_name = Functions.gvString(data, "display_name");
        }
        if (data.containsKey("default_value")) {
            this.default_value = Functions.gvString(data, "default_value");
        }
        if (data.containsKey("property_desc")) {
            this.property_desc = Functions.gvString(data, "property_desc");
        }
        if (data.containsKey("preferred_order")) {
            this.preferred_order = Functions.gvString(data, "preferred_order");
        }
        if (data.containsKey("misc_properties")) {
            this.misc_properties = Functions.gvString(data, "misc_properties");
        }
        if (data.containsKey("true_values")) {
            tmpObj = data.get("true_values");
            this.true_values = tmpObj != null && tmpObj instanceof ArrayList ? (ArrayList)tmpObj : new ArrayList();
        }
        if (data.containsKey("false_values")) {
            tmpObj = data.get("false_values");
            this.false_values = tmpObj != null && tmpObj instanceof ArrayList ? (ArrayList)tmpObj : new ArrayList();
        }
        if (data.containsKey("ignore_values")) {
            tmpObj = data.get("ignore_values");
            this.ignore_values = tmpObj != null && tmpObj instanceof ArrayList ? (ArrayList)tmpObj : new ArrayList();
        }
    }

    public static void cacheDB() throws ConnectionLostException, DetectRightException {
        if (Functions.is_null(cacheLink.get())) {
            cacheLink.set(DetectRight.getCacheLink());
        }
        if (Functions.is_null(dbLink.get())) {
            dbLink.set(DetectRight.getDBLink());
        }
        if (dbLink.get() == null) {
            throw new ConnectionLostException("Lost connection to database");
        }
    }

    public void __wakeup() throws ConnectionLostException, DetectRightException {
        SchemaPropertyCore.cacheDB();
    }

    public static void process(LinkedHashMap<String, Object> data) {
        if (data == null) {
            return;
        }
        String tv = Functions.gv(data, "true_values", "").toString();
        String fv = Functions.gv(data, "false_values", "").toString();
        String iv = Functions.gv(data, "ignore_values", "").toString();
        if (!Functions.isEmpty(tv)) {
            data.put("true_values", Functions.explode(",", tv));
        } else {
            data.put("true_values", new ArrayList());
        }
        if (!Functions.isEmpty(fv)) {
            data.put("false_values", Functions.explode(",", fv));
        } else {
            data.put("false_values", new ArrayList());
        }
        if (!Functions.isEmpty(iv)) {
            data.put("ignore_values", Functions.explode(",", iv));
        } else {
            data.put("ignore_values", new ArrayList());
        }
        String fd = Functions.gvString(data, "property_desc").toString();
        if (Functions.isEmpty(fd)) {
            data.put("property_desc", Functions.strtolower(Functions.punctClean(data.get("property").toString())));
        }
    }

    public static LinkedHashMap<String, SchemaPropertyCore> getSchema() throws DetectRightException, ConnectionLostException {
        return SchemaPropertyCore.getSchema("", false);
    }

    public static LinkedHashMap<String, SchemaPropertyCore> getSchema(String schema) throws DetectRightException, ConnectionLostException {
        return SchemaPropertyCore.getSchema(schema, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashMap<String, SchemaPropertyCore> getSchema(String schema, boolean returnID) throws DetectRightException, ConnectionLostException {
        if (schema == null) {
            schema = "";
        }
        String keyField = !returnID ? "property" : PK;
        String cacheKey = DetectRight.cacheKey("DRSchema_" + schema + "_" + keyField);
        LinkedHashMap<String, SchemaPropertyCore> lhm = null;
        LinkedHashMap<String, LinkedHashMap<String, SchemaPropertyCore>> linkedHashMap = schemas;
        synchronized (linkedHashMap) {
            if (schemas.containsKey(cacheKey)) {
                lhm = schemas.get(cacheKey);
            }
        }
        if (lhm != null && lhm.size() > 0) {
            return lhm;
        }
        linkedHashMap = schemas;
        synchronized (linkedHashMap) {
            if (schemas.containsKey(cacheKey) && schemas.containsKey(cacheKey)) {
                lhm = schemas.get(cacheKey);
            }
            if (lhm == null || lhm.size() == 0) {
                LinkedHashMap<String, Object> result;
                DBLink dbl;
                LinkedHashMap<String, Object> where = new LinkedHashMap();
                lhm = new LinkedHashMap();
                if (!Functions.isEmpty(schema)) {
                    where = DBLink.whereClause("schema", schema);
                }
                if ((dbl = dbLink.get()) == null) {
                    SchemaPropertyCore.cacheDB();
                    dbl = dbLink.get();
                    if (dbl == null) {
                        throw new ConnectionLostException("Database not valid");
                    }
                }
                if ((result = dbl.simpleFetch(table, DBLink.allFields, where)) != null) {
                    LinkedHashMap<String, Object> tmpMap = result;
                    for (Map.Entry entry : tmpMap.entrySet()) {
                        String tmpStr;
                        LinkedHashMap row = (LinkedHashMap)entry.getValue();
                        if (row == null) continue;
                        SchemaPropertyCore sp = SchemaPropertyCore.tempSchemaProperty(row, false);
                        try {
                            tmpStr = Functions.nn(Reflection.getProperty(sp, keyField)).toLowerCase();
                        }
                        catch (Throwable e) {
                            continue;
                        }
                        lhm.put(tmpStr, sp);
                    }
                }
                schemas.put(cacheKey, lhm);
            }
        }
        return lhm;
    }

    public static SchemaPropertyCore getSchemaProperty(String property) throws DetectRightException, ConnectionLostException {
        return SchemaPropertyCore.getSchemaProperty("", property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchemaPropertyCore getSchemaProperty(String schema, String property) throws DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Object> linkedHashMap;
        boolean containsKey;
        if (schema == null) {
            schema = "";
        }
        if (property == null) {
            return null;
        }
        String cacheKey = DetectRight.cacheKey("DRSP_" + schema + "_" + property);
        LinkedHashMap<String, Object> linkedHashMap2 = cacheArray;
        synchronized (linkedHashMap2) {
            containsKey = cacheArray.containsKey(cacheKey);
        }
        if (containsKey && !DetectRight.getRedetect()) {
            SchemaPropertyCore nsp = null;
            linkedHashMap = cacheArray;
            synchronized (linkedHashMap) {
                if (cacheArray.containsKey(cacheKey)) {
                    nsp = (SchemaPropertyCore)cacheArray.get(cacheKey);
                }
            }
            if (nsp != null) {
                return nsp;
            }
        }
        SchemaPropertyCore sp = new SchemaPropertyCore(0L, schema, property);
        linkedHashMap = cacheArray;
        synchronized (linkedHashMap) {
            if (cacheArray != null && !cacheArray.containsKey(cacheKey) || DetectRight.getRedetect()) {
                cacheArray.put(cacheKey, sp);
            }
        }
        return sp;
    }

    public static Object getObjectValue(QuantumDataTree qdt, SchemaPropertyCore nsp) throws DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Integer> importances = new LinkedHashMap<String, Integer>();
        return SchemaPropertyCore.getObjectValue(qdt, nsp, importances);
    }

    /*
     * WARNING - void declaration
     */
    public static Object getObjectValue(QuantumDataTree qdt, SchemaPropertyCore nsp, LinkedHashMap<String, Integer> importances) throws DetectRightException, ConnectionLostException {
        void var10_17;
        if (nsp == null) {
            return null;
        }
        if (nsp.error_trap != 0) {
            return null;
        }
        if (qdt == null) {
            return null;
        }
        if (qdt.treeCount() == 0 && qdt.qdcCount() == 0 && Functions.isEmpty(nsp.default_value)) {
            return null;
        }
        boolean flat = DetectRight.getPropertyBool("flat");
        if (Functions.isEmpty(nsp.output_map) && !flat) {
            return null;
        }
        boolean augmentQuery = false;
        boolean tempAugment = false;
        ArrayList<Object> output_map_array = new ArrayList();
        if (Functions.in("\n", nsp.output_map)) {
            output_map_array = Functions.explode("\n", nsp.output_map);
        } else if (Functions.in("^+", nsp.output_map)) {
            output_map_array = Functions.explode("^+", nsp.output_map);
            augmentQuery = true;
        } else if (Functions.in("^", nsp.output_map)) {
            output_map_array = Functions.explode("^", nsp.output_map);
        } else {
            output_map_array.add(nsp.output_map);
        }
        if (flat) {
            String path = String.valueOf(nsp.schema) + ":" + nsp.property;
            if (nsp.type.equals("Literal")) {
                Functions.array_unshift(output_map_array, (Object)(String.valueOf(path) + "//description"));
            } else if (nsp.type.equals("LiteralArray")) {
                Functions.array_unshift(output_map_array, (Object)(String.valueOf(path) + "//description"));
            } else if (nsp.type.equals("Dimension")) {
                Functions.array_unshift(output_map_array, (Object)(String.valueOf(path) + "//has=dimension{value:*;units:none}"));
            } else if (nsp.type.equals("Boolean")) {
                Functions.array_unshift(output_map_array, (Object)(String.valueOf(path) + "//status"));
            } else if (nsp.type.equals("Integer")) {
                Functions.array_unshift(output_map_array, (Object)(String.valueOf(path) + "//has=integer{value:*;units:none;flag:1}"));
            } else if (nsp.type.equals("Float")) {
                Functions.array_unshift(output_map_array, (Object)(String.valueOf(path) + "//has=float{value:*;units:none;flag:1}"));
            }
            tempAugment = true;
        }
        ArrayList<Object> valueArray = new ArrayList();
        ArrayList<Object> valueObj = null;
        Dataquery dataQuery = null;
        for (String string : output_map_array) {
            ArrayList<Object> qdts = new ArrayList();
            if (string.contains("*//") && !string.contains(":*/")) {
                ArrayList<String> tmp = Functions.explode("*//", string);
                String rootPath = (String)Functions.array_shift(tmp);
                QuantumDataTree node = qdt.getQDT(rootPath);
                if (node == null) {
                    return null;
                }
                String remainder = (String)Functions.array_shift(tmp);
                String descriptor = (String)Functions.array_shift(tmp = Functions.explode("//", remainder));
                if (descriptor == null) {
                    Functions.echo(String.valueOf(string) + " generated null descriptor");
                    System.exit(1);
                }
                qdts = node.getQDTsWithDescriptor(descriptor);
                remainder = Functions.implode("//", tmp);
                dataQuery = new Dataquery(remainder);
                dataQuery.array = nsp.type.equals("LiteralArray");
                dataQuery.useSubtree = nsp.use_subtree;
                for (Object newQDT : qdts) {
                    dataQuery.queryQDTWithPath((QuantumDataTree)newQDT);
                    valueArray.addAll(dataQuery.result);
                }
                valueArray = Functions.array_unique(valueArray);
            } else {
                dataQuery = new Dataquery(string);
                dataQuery.array = nsp.type.equals("LiteralArray");
                dataQuery.useSubtree = nsp.use_subtree;
                dataQuery.queryQDTWithPath(qdt);
                if (dataQuery.result != null) {
                    valueArray.addAll(dataQuery.result);
                }
            }
            if (tempAugment) {
                tempAugment = false;
                continue;
            }
            if (Functions.isEmpty(valueArray) || augmentQuery) continue;
        }
        if (valueArray.size() == 0) {
            if (Functions.isEmpty(nsp.default_value)) {
                return null;
            }
            valueArray.add(nsp.default_value);
        }
        valueArray = Functions.array_unique(valueArray);
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        valueObj = valueArray.get(0);
        if (Functions.isEmpty(valueObj)) {
            if (Functions.isEmpty(nsp.default_value)) {
                return null;
            }
            valueObj = nsp.default_value;
            valueArray.set(0, (String)((Object)valueObj));
        } else {
            ArrayList<String> valueArray2 = new ArrayList<String>();
            while (valueArray.size() > 0) {
                String valueStr = Functions.nn(Functions.array_shift(valueArray));
                int tmpImportance = 50;
                ArrayList<String> tmpSplit = Functions.explode("%/%", valueStr);
                if (tmpSplit.size() <= 1) {
                    Functions.array_unshift(valueArray, (Object)tmpSplit.get(0));
                    break;
                }
                try {
                    tmpImportance = Functions.parseInt(tmpSplit.get(1));
                }
                catch (Throwable node) {
                    // empty catch block
                }
                valueArray2.add(tmpSplit.get(0));
                String tmpSplitKey = tmpSplit.get(0);
                if (!linkedHashMap.containsKey(tmpSplitKey)) {
                    linkedHashMap.put(tmpSplitKey, tmpImportance);
                    continue;
                }
                int oldImportance = (Integer)linkedHashMap.get(tmpSplitKey);
                if (tmpImportance <= oldImportance) continue;
                linkedHashMap.put(tmpSplitKey, tmpImportance);
            }
            if (valueArray2.size() > 0) {
                valueArray = valueArray2;
            }
        }
        boolean validated = false;
        String vt = "none";
        boolean vtExp = true;
        if (!Functions.isEmpty(nsp.validation_type_export)) {
            vt = nsp.validation_type_export;
            vtExp = false;
        } else {
            vt = nsp.validation_type;
        }
        boolean prefFound = false;
        if (nsp.type.equals("LiteralArray")) {
            if (nsp.validate_on_export == 1) {
                int i = 0;
                while (i < valueArray.size()) {
                    String tmpValue = (String)valueArray.get(i);
                    if (!Functions.isEmpty(tmpValue = Validator.validate(vt, tmpValue, vtExp))) {
                        valueArray.set(i, tmpValue.trim());
                    }
                    ++i;
                }
                validated = true;
            }
            valueArray = Functions.array_unique(valueArray);
            String delimiter = nsp.delimiter;
            valueObj = !Functions.isEmpty(delimiter) ? Functions.implode(delimiter, valueArray).trim() : valueArray;
        } else if (valueArray.size() > 0) {
            if (nsp.preferred_order.equals("max")) {
                Functions.rsort(valueArray);
                valueObj = valueArray.get(0);
                linkedHashMap.clear();
                prefFound = true;
            } else if (nsp.preferred_order.equals("min")) {
                Functions.sort(valueArray);
                valueObj = valueArray.get(0);
                linkedHashMap.clear();
                prefFound = true;
            } else if (!Functions.isEmpty(nsp.preferred_order)) {
                ArrayList<String> preferred_order = Functions.explode(",", nsp.preferred_order);
                if (flat) {
                    for (String order : preferred_order) {
                        if (!valueArray.contains(order = Functions.nn(Validator.validate(vt, order, vtExp)))) continue;
                        valueObj = order;
                        importances.put(order, (Integer)linkedHashMap.get(order));
                        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
                        validated = true;
                        prefFound = true;
                        break;
                    }
                }
                if (!prefFound) {
                    for (String order : preferred_order) {
                        void var10_15;
                        if (!valueArray.contains(order)) continue;
                        valueObj = order;
                        importances.put(order, (Integer)var10_15.get(order));
                        LinkedHashMap linkedHashMap3 = new LinkedHashMap();
                        prefFound = true;
                        break;
                    }
                }
            }
            if (!prefFound) {
                if (var10_17.size() > 0 && !dataQuery.queryType.equals("qdc")) {
                    Functions.arsort((Map)var10_17);
                    ArrayList<String> vhKeys = Functions.array_keys(var10_17);
                    int topImportance = (Integer)var10_17.get(vhKeys.get(0));
                    ArrayList<String> topValues = new ArrayList<String>(3);
                    for (String vhKey : vhKeys) {
                        if ((Integer)var10_17.get(vhKey) != topImportance) continue;
                        topValues.add(vhKey);
                    }
                    Functions.rsort(topValues);
                    valueObj = Functions.array_shift(topValues);
                } else if (valueArray != null && valueArray.size() > 0) {
                    valueObj = Functions.array_shift(valueArray);
                }
            }
        }
        if (!(nsp.type.equals("Dimension") || nsp.type.equals("Version") || nsp.type.equals("Literal"))) {
            if (nsp.type.equals("Integer") || nsp.type.equals("ByteSize")) {
                try {
                    valueObj = Long.parseLong(((Object)valueObj).toString());
                }
                catch (Throwable e) {
                    return null;
                }
            } else if (!nsp.type.equals("DateTime") && nsp.type.equals("Boolean")) {
                Boolean boolAsString = DetectRight.getPropertyBool("booleansAsStrings");
                if (boolAsString == null) {
                    boolAsString = true;
                }
                boolean valBool = Functions.to_boolean(((Object)valueObj).toString());
                valueObj = boolAsString != false && valBool && nsp.true_values.size() > 0 ? nsp.true_values.get(0) : (boolAsString != false && !valBool && nsp.false_values.size() > 0 ? nsp.false_values.get(0) : Boolean.valueOf(valBool));
            }
        }
        if (importances != null) {
            importances.putAll((Map<String, Integer>)var10_17);
        }
        if (!validated && nsp.validate_on_export == 1 && valueObj != null && !Functions.is_array(valueObj)) {
            valueObj = Validator.validate(vt, ((Object)valueObj).toString(), vtExp);
        }
        return valueObj;
    }

    public static LinkedHashMap<String, Object> export(QuantumDataTree qdt) throws DetectRightException, ConnectionLostException {
        return SchemaPropertyCore.export(qdt, "");
    }

    public static LinkedHashMap<String, Object> export(QuantumDataTree qdt, String destSchema) throws DetectRightException, ConnectionLostException {
        if (destSchema == null) {
            destSchema = "";
        }
        DetectRight.checkPoint("Processing packages");
        if (qdt == null) {
            return new LinkedHashMap<String, Object>();
        }
        qdt.processPackages();
        DetectRight.checkPoint("Importing schemas");
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        ArrayList<String> schemas = Functions.explode(",", destSchema);
        QuantumDataTree rootQDT = qdt;
        for (String toSchema : schemas) {
            LinkedHashMap<String, SchemaPropertyCore> translate = SchemaPropertyCore.getSchema(toSchema);
            DetectRight.checkPoint("Translating");
            if (translate == null) continue;
            LinkedHashMap<String, SchemaPropertyCore> tmpMap = translate;
            for (Map.Entry entry : tmpMap.entrySet()) {
                LinkedHashMap<String, Integer> importances;
                Object valueObj;
                String display_name;
                SchemaPropertyCore nsp = (SchemaPropertyCore)entry.getValue();
                if (nsp == null || nsp.error_trap != 0 || Functions.isEmpty(nsp.output_map)) continue;
                if (DetectRight.getStrictExportNames()) {
                    display_name = nsp.display_name;
                    if (Functions.isEmpty(display_name)) {
                        display_name = nsp.property;
                    }
                } else {
                    display_name = nsp.property;
                }
                if (Functions.isEmpty(valueObj = SchemaPropertyCore.getObjectValue(qdt, nsp, importances = new LinkedHashMap<String, Integer>()))) continue;
                output.put(display_name, valueObj);
            }
            translate = null;
        }
        return output;
    }

    public static SchemaPropertyCore tempSchemaProperty(LinkedHashMap<String, Object> data) throws DetectRightException, ConnectionLostException {
        return SchemaPropertyCore.tempSchemaProperty(data, false);
    }

    public long commit() {
        return -1L;
    }

    public static SchemaPropertyCore tempSchemaProperty(LinkedHashMap<String, Object> data, boolean commit) throws DetectRightException, ConnectionLostException {
        if (data == null) {
            return null;
        }
        SchemaPropertyCore nsp = new SchemaPropertyCore();
        SchemaPropertyCore.process(data);
        Reflection.fill(nsp, data);
        if (nsp.ID == 0L && commit) {
            if (DetectRight.canLearn()) {
                if (nsp.commit() > -1L) {
                    return null;
                }
                DBLink dbl = dbLink.get();
                if (dbl == null) {
                    throw new ConnectionLostException("Connection to DB lost");
                }
                dbl.recordInsert(nsp.tablename, String.valueOf(nsp.ID));
            } else {
                Functions.trigger_error("New schema item from unqualified person: " + data.get("property").toString() + " " + data.get("schema").toString(), null, true);
                return null;
            }
        }
        return nsp;
    }
}

