/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Cache;
import com.detectright.core.ConnectionLostException;
import com.detectright.core.DBLink;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.Functions;
import com.detectright.core.Reflection;
import com.detectright.core.Splitter;
import com.detectright.core.Validator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

final class SigPart {
    static ThreadLocal<DBLink> dbLink = new ThreadLocal();
    static ThreadLocal<Cache> cacheLink = new ThreadLocal();
    String originalString;
    ArrayList<String> strings = new ArrayList();
    String startPart = "";
    String endPart = "";
    String expression = "";
    ArrayList<Object> parts = new ArrayList();
    boolean found = true;
    String workingString = "";
    ArrayList<String> properties = new ArrayList();
    static String[] delimiters;

    static {
        DetectRight.registerClass("SigPart");
        try {
            if (Functions.is_null(cacheLink.get())) {
                cacheLink.set(DetectRight.getCacheLink());
            }
            if (Functions.is_null(dbLink.get())) {
                dbLink.set(DetectRight.getDBLink());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        delimiters = new String[]{" ", "/", "*", "{", "}", ")", "(", "*", ":", ";", "[", "]"};
    }

    static void main(String[] args) {
    }

    SigPart() throws ConnectionLostException, DetectRightException {
    }

    SigPart(String string) throws ConnectionLostException, DetectRightException {
        if (string == null) {
            return;
        }
        this.originalString = string;
        ArrayList<String> tmp = Functions.explode("(", string, 2);
        if (tmp.size() > 2) {
            return;
        }
        if (tmp.size() == 1) {
            this.startPart = string;
            return;
        }
        this.startPart = tmp.get(0);
        String expression = tmp.get(1);
        int strpos = -1;
        int len = expression.length();
        int r = len - 1;
        while (r > -1) {
            if (Functions.substr(expression, r, 1).equals(")")) {
                strpos = r;
                break;
            }
            --r;
        }
        if (strpos == -1) {
            return;
        }
        this.expression = Functions.substr(expression, 0, strpos);
        String remainder = Functions.substr(expression, strpos + 1);
        if (!Functions.isEmpty(remainder)) {
            this.endPart = remainder;
        }
        this.processExpression();
    }

    void cacheDB() throws ConnectionLostException, DetectRightException {
        if (Functions.is_null(cacheLink.get())) {
            cacheLink.set(DetectRight.getCacheLink());
        }
        if (Functions.is_null(dbLink.get())) {
            dbLink.set(DetectRight.getDBLink());
        }
        if (dbLink.get() == null) {
            throw new ConnectionLostException("Lost connection to database");
        }
    }

    void __wakeup() throws ConnectionLostException, DetectRightException {
        this.cacheDB();
    }

    void processExpression() {
        Splitter split = new Splitter("[\\{\\}]", true);
        String[] array = split.split(this.expression);
        boolean special = false;
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (!Functions.isEmpty(value)) {
                if (value.equals("{")) {
                    special = true;
                } else if (value.equals("}")) {
                    special = false;
                } else if (!value.equals("")) {
                    LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>();
                    tmp.put("special", special);
                    tmp.put("value", value);
                    this.parts.add(tmp);
                }
            }
            ++n2;
        }
    }

    String process(String string) throws DetectRightException, ConnectionLostException {
        return this.process(string, false);
    }

    String process(String string, boolean retainWorkString) throws DetectRightException, ConnectionLostException {
        String retStr;
        if (string == null) {
            string = "";
        }
        LinkedHashMap<String, Object> lookup = null;
        LinkedHashMap part = null;
        String output = "";
        String command = "";
        String partValue = "";
        String[] delims = null;
        String value = "";
        int pos = 0;
        int chars = 0;
        this.found = true;
        boolean notFoundEmpty = false;
        String workString = string;
        DBLink dbl = dbLink.get();
        if (dbl == null) {
            this.cacheDB();
            dbl = dbLink.get();
            if (dbl == null) {
                throw new ConnectionLostException("Connection to DB lost");
            }
        }
        block22: for (Object partObj : this.parts) {
            boolean matched;
            String prevChar;
            part = (LinkedHashMap)partObj;
            boolean special = Functions.to_boolean(Functions.gvString(part, "special"));
            partValue = Functions.gvString(part, "value");
            if (special) {
                char op = Functions.substr(partValue, 0, 1).charAt(0);
                command = Functions.strlen(partValue) > 1 ? Functions.substr(partValue, 1) : "";
                switch (op) {
                    case '+': {
                        output = String.valueOf(output) + command;
                        break;
                    }
                    case 'd': {
                        boolean exact;
                        if (Functions.isEmpty(command)) {
                            delims = delimiters;
                            exact = false;
                        } else {
                            delims = new String[command.length()];
                            int i = 0;
                            while (i < command.length()) {
                                delims[i] = String.valueOf(command.charAt(i));
                                ++i;
                            }
                            exact = true;
                        }
                        String[] tmp = Functions.splitFirstDelimiter(workString, delims, exact);
                        workString = tmp[1];
                        break;
                    }
                    case '*': 
                    case '^': {
                        String[] tmp;
                        while (!workString.equals("") && Functions.in_array(Functions.substr(workString, 0, 1), delimiters)) {
                            workString = Functions.substr(workString, 1);
                        }
                        delims = delimiters;
                        chars = 0;
                        if (!Functions.isEmpty(command)) {
                            if (Functions.is_numeric(command)) {
                                chars = Functions.parseInt(command);
                            } else {
                                delims = new String[command.length()];
                                int r = 0;
                                while (r < command.length()) {
                                    delims[r] = Functions.substr(command, r, 1);
                                    ++r;
                                }
                            }
                        }
                        if ((tmp = Functions.splitFirstDelimiter(workString, delims)).length > 0) {
                            value = tmp[0];
                            if (chars > 0 && Functions.strlen(value) >= chars) {
                                value = Functions.substr(value, 0, chars);
                            }
                            workString = tmp.length > 1 ? tmp[1] : "";
                        }
                        output = output.concat(value);
                        break;
                    }
                    case '|': {
                        lookup = dbl.getArray(command);
                        if (lookup != null && lookup.size() > 0) {
                            LinkedHashMap<String, Object> tmpMap = lookup;
                            for (Map.Entry entry : tmpMap.entrySet()) {
                                String lKey = (String)entry.getKey();
                                String lValue = entry.getValue().toString();
                                if (lKey.startsWith("%")) {
                                    lKey = Functions.substr(lKey, 1);
                                    output = Functions.str_ireplace(lKey, lValue, output).trim();
                                    continue;
                                }
                                output = Functions.gv(lookup, output, output).toString().trim();
                            }
                            continue block22;
                        }
                        if (lookup != null && lookup.size() != 0) continue block22;
                        if ((output = Validator.validate(command, output)) == null) {
                            output = "";
                        }
                        this.properties.addAll(Validator.profileChanges);
                        break;
                    }
                    case '.': {
                        chars = !Functions.isEmpty(command) && Functions.is_numeric(command) ? Functions.parseInt(command) : 1;
                        workString = Functions.substr(workString, chars);
                        break;
                    }
                    case '=': {
                        if (value.equals(command)) continue block22;
                        this.found = false;
                        return "";
                    }
                    case '>': {
                        try {
                            if (Double.parseDouble(output) > Double.parseDouble(command)) continue block22;
                            this.found = false;
                            return "";
                        }
                        catch (Throwable e) {
                            if (output.compareTo(command) > 0) continue block22;
                            this.found = false;
                            return "";
                        }
                    }
                    case '<': {
                        try {
                            if (Double.parseDouble(output) < Double.parseDouble(command)) continue block22;
                            this.found = false;
                            return "";
                        }
                        catch (Throwable e) {
                            if (output.compareTo(command) < 0) continue block22;
                            this.found = false;
                            return "";
                        }
                    }
                    case '!': {
                        if (!output.equals(command)) continue block22;
                        this.found = false;
                        return "";
                    }
                }
                continue;
            }
            boolean negate = false;
            boolean mustMatch = true;
            Boolean atStart = null;
            char newOp = partValue.charAt(0);
            switch (newOp) {
                case '@': {
                    notFoundEmpty = true;
                    partValue = Functions.substr(partValue, 1);
                    break;
                }
                case '#': {
                    mustMatch = true;
                    negate = false;
                    atStart = false;
                    partValue = Functions.substr(partValue, 1);
                    break;
                }
                case '$': {
                    mustMatch = true;
                    negate = false;
                    atStart = true;
                    partValue = Functions.substr(partValue, 1);
                    break;
                }
                case '!': {
                    mustMatch = true;
                    negate = true;
                    partValue = Functions.substr(partValue, 1);
                    break;
                }
                case '&': {
                    mustMatch = false;
                    negate = false;
                    partValue = Functions.substr(partValue, 1);
                    break;
                }
                default: {
                    mustMatch = true;
                    negate = false;
                }
            }
            if (atStart != null) {
                while (!this.workingString.equals("") && Functions.in_array(Functions.substr(this.workingString, 0, 1), delimiters)) {
                    this.workingString = Functions.substr(this.workingString, 1);
                }
            }
            if ((pos = Functions.stripos(workString, partValue)) > -1 && pos > 0 && (prevChar = Functions.substr(workString, pos - 1, 1)).matches("[A-Za-z]")) {
                pos = -1;
            }
            boolean bl = matched = pos > -1;
            if (atStart != null) {
                if (atStart.booleanValue()) {
                    if (pos != 0) {
                        matched = false;
                    }
                } else if (!atStart.booleanValue() && pos == 0) {
                    matched = false;
                }
            }
            if (matched) {
                if (mustMatch && negate) {
                    this.found = false;
                    return "";
                }
                workString = Functions.substr(workString, pos + Functions.strlen(partValue));
                continue;
            }
            if (mustMatch && !negate) {
                this.found = false;
                return "";
            }
            if (mustMatch) continue;
            return "";
        }
        if (retainWorkString) {
            this.workingString = workString;
        }
        if ((retStr = String.valueOf(this.startPart) + output + this.endPart).equals("") && notFoundEmpty) {
            this.found = false;
        }
        return retStr;
    }

    protected SigPart clone() {
        SigPart clone = null;
        try {
            clone = new SigPart();
        }
        catch (Exception exception) {
            // empty catch block
        }
        LinkedHashMap<String, Object> vars = Reflection.get_object_vars(this);
        Reflection.fill(clone, vars);
        return clone;
    }
}

