/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Cache;
import com.detectright.core.ConnectionLostException;
import com.detectright.core.DBLink;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.Functions;
import com.detectright.core.Reflection;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Validator {
    static ThreadLocal<DBLink> dbLink;
    static ThreadLocal<Cache> cacheLink;
    static ArrayList<String> profileChanges;
    static boolean doNotAddToTranslationTable;
    static boolean storeValidatorsInCache;
    public String type;
    LinkedHashMap<String, Object> translation;
    private ReentrantLock tLock = new ReentrantLock();
    String validKey;
    String translateKey;
    boolean returnOriginalValueOnValidationFail = true;
    ArrayList<String> pcArray = new ArrayList();
    String version;
    String source = "NEW";
    static LinkedHashMap<String, Object> validators;
    static int cache_timeout;
    static String table_translation;

    static {
        DetectRight.registerClass("Validator");
        dbLink = new ThreadLocal();
        cacheLink = new ThreadLocal();
        profileChanges = new ArrayList();
        doNotAddToTranslationTable = true;
        storeValidatorsInCache = false;
        validators = new LinkedHashMap();
        cache_timeout = 14400;
        table_translation = "schema_property_values";
    }

    static void main(String[] args) {
    }

    Validator() {
    }

    Validator(String type) throws ConnectionLostException, DetectRightException {
        if (Functions.isEmpty(type)) {
            return;
        }
        Validator.cacheDB();
        this.type = type;
        this.translateKey = "DR_TRANSLATE_" + type;
        this.pcArray = new ArrayList();
    }

    static void cacheDB() throws ConnectionLostException, DetectRightException {
        if (Functions.is_null(cacheLink.get())) {
            cacheLink.set(DetectRight.getCacheLink());
        }
        if (Functions.is_null(dbLink.get())) {
            dbLink.set(DetectRight.getDBLink());
        }
        if (dbLink.get() == null) {
            throw new ConnectionLostException("Lost connection to database");
        }
    }

    void __wakeup() throws ConnectionLostException, DetectRightException {
        Validator.cacheDB();
    }

    boolean addTranslation(String value, String realString) throws DetectRightException, ConnectionLostException {
        if (value == null || realString == null) {
            return false;
        }
        return this.addTranslation(value, realString, new ArrayList<String>(), 2);
    }

    boolean addTranslation(String value, String replacement, ArrayList<String> data, int status) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(value)) {
            return false;
        }
        String pcString = Functions.implode("\n", data);
        LinkedHashMap<String, Object> array = new LinkedHashMap<String, Object>();
        array.put("validation_type", this.type);
        array.put("value", value);
        array.put("replacement", replacement);
        array.put("data", pcString);
        array.put("status", status);
        DBLink dbl = dbLink.get();
        if (dbl == null) {
            throw new ConnectionLostException("Connection to DB lost");
        }
        dbl.insertData(table_translation, array, 0L, true);
        LinkedHashMap<String, Object> translationValue = new LinkedHashMap<String, Object>();
        translationValue.put("ID", "TBA");
        translationValue.put("validation_type", this.type);
        translationValue.put("value", value);
        translationValue.put("replacement", replacement);
        translationValue.put("data", pcString);
        translationValue.put("status", status);
        this.translation.put(value, translationValue);
        return true;
    }

    static boolean addTranslationForType(String type, String value, String realString) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(value)) {
            return false;
        }
        Validator validator = Validator.getValidator(type);
        return validator.addTranslation(value, realString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Validator getValidator(String type) throws DetectRightException, ConnectionLostException {
        Validator.cacheDB();
        Validator validator = null;
        String classname = String.valueOf(type) + "_validator";
        String key = "";
        boolean inbuilt = false;
        if (!(classname.equals("boolean_validator") || classname.equals("positive_integer_validator") || Functions.class_exists(classname, true))) {
            classname = "content_validator";
            key = "content_validator_" + type;
            inbuilt = false;
        } else {
            key = classname;
            inbuilt = true;
        }
        LinkedHashMap<String, Object> linkedHashMap = validators;
        synchronized (linkedHashMap) {
            if (Functions.array_key_exists(key, validators) && (validator = (Validator)validators.get(key)) != null) {
                validator.source = "MEMORY";
            }
        }
        if (validator == null) {
            linkedHashMap = validators;
            synchronized (linkedHashMap) {
                if (Functions.array_key_exists(key, validators) && (validator = (Validator)validators.get(key)) != null) {
                    validator.source = "MEMORY";
                }
            }
            if (validator != null) {
                return validator;
            }
            Constructor<?> ct = null;
            try {
                Class<?> c = Class.forName(Reflection.cn(classname));
                if (!inbuilt) {
                    Class[] params = new Class[]{Class.forName("java.lang.String")};
                    Object[] argList = new Object[]{new String(type)};
                    ct = c.getConstructor(params);
                    validator = (Validator)ct.newInstance(argList);
                } else {
                    ct = c.getConstructor(new Class[0]);
                    validator = (Validator)ct.newInstance(new Object[0]);
                }
            }
            catch (Throwable e) {
                return null;
            }
            LinkedHashMap<String, Object> linkedHashMap2 = validators;
            synchronized (linkedHashMap2) {
                validators.put(key, validator);
            }
        }
        return validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean storeValidator(Validator validator) throws DetectRightException, ConnectionLostException {
        String key;
        Validator.cacheDB();
        if (!Functions.is_object(validator)) {
            return false;
        }
        String type = validator.type;
        if (validator.source.equals("MEMORY")) {
            return false;
        }
        String classname = String.valueOf(type) + "_validator";
        if (!DetectRight.classExists(classname)) {
            classname = "content_validator";
            key = "content_validator_type";
        } else {
            key = classname;
        }
        LinkedHashMap<String, Object> linkedHashMap = validators;
        synchronized (linkedHashMap) {
            if (!Functions.array_key_exists(key, validators)) {
                validators.put(key, validator);
            }
        }
        return true;
    }

    boolean load() throws DetectRightException, ConnectionLostException {
        return this.load(new String("value"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean load(String pk) throws DetectRightException, ConnectionLostException {
        Validator.cacheDB();
        boolean success = false;
        ReentrantLock reentrantLock = this.tLock;
        synchronized (reentrantLock) {
            if (Functions.is_array(this.translation) && this.translation.size() > 0 && !DetectRight.getFlush()) {
                success = true;
            }
        }
        if (success) {
            return true;
        }
        DBLink dbl = dbLink.get();
        if (dbl == null) {
            throw new ConnectionLostException("Connection to DB lost");
        }
        ReentrantLock reentrantLock2 = this.tLock;
        synchronized (reentrantLock2) {
            if (this.translation == null || this.translation.size() == 0) {
                LinkedHashMap<String, Object> where = new LinkedHashMap<String, Object>();
                where.put("validation_type", this.type);
                where.put("status", "1");
                try {
                    this.translation = dbl.simpleFetch(table_translation, DBLink.allFields, where, DBLink.emptyHash, DBLink.emptyHash, pk);
                    if (this.translation == null) {
                        this.translation = new LinkedHashMap();
                    }
                    this.translation = Functions.array_change_key_case(this.translation, "LOWER");
                }
                catch (DetectRightException de) {
                    this.tLock.unlock();
                    throw de;
                }
                catch (ConnectionLostException ce) {
                    this.tLock.unlock();
                    throw ce;
                }
            }
        }
        return true;
    }

    static String validate(String type, String value) throws DetectRightException, ConnectionLostException {
        return Validator.validate(type, value, false);
    }

    static String validate(String type, String value, boolean export) throws DetectRightException, ConnectionLostException {
        return Validator.validateWithPC(type, value, export, new ArrayList<String>());
    }

    String process(String value) throws DetectRightException, ConnectionLostException {
        return value;
    }

    String export(String value) throws DetectRightException, ConnectionLostException {
        return value;
    }

    static String validateWithPC(String type, String value, boolean export, ArrayList<String> pc) throws DetectRightException, ConnectionLostException {
        Validator.cacheDB();
        String[] delims = new String[]{"\n", "\r", "\t"};
        value = Functions.trim(Functions.str_replace(delims, new String[]{""}, value));
        if (type == null) {
            return value;
        }
        if (type.equals("none")) {
            return value;
        }
        if (Functions.isEmpty(type)) {
            return value;
        }
        Validator validator = Validator.getValidator(type);
        if (validator == null) {
            return value;
        }
        validator.pcArray = new ArrayList();
        value = !export ? validator.process(value) : validator.export(value);
        pc.addAll(validator.pcArray);
        if (validator.pcArray.size() > 0) {
            validator.pcArray.clear();
        }
        Validator.storeValidator(validator);
        return value;
    }

    static String validateExport(String type, String value) throws DetectRightException, ConnectionLostException {
        return Validator.validate(type, value, true);
    }

    static String translation(String thing, String type) throws DetectRightException, ConnectionLostException {
        ArrayList<String> pc = new ArrayList<String>();
        return Validator.translation(thing, type, pc);
    }

    static String translation(String thing, String type, ArrayList<String> pc) throws DetectRightException, ConnectionLostException {
        Validator.cacheDB();
        pc.clear();
        LinkedHashMap<String, Object> where = new LinkedHashMap<String, Object>();
        where.put("value", thing);
        where.put("validation_type", type);
        LinkedHashMap<String, Object> limit = new LinkedHashMap<String, Object>();
        limit.put("limit", "1");
        DBLink dbl = dbLink.get();
        if (dbl == null) {
            throw new ConnectionLostException("Connection to DB lost");
        }
        LinkedHashMap<String, Object> result = dbl.simpleFetch(table_translation, DBLink.allFields, where, DBLink.emptyHash, limit);
        if (result == null) {
            return thing;
        }
        LinkedHashMap row = (LinkedHashMap)Functions.array_shift(result);
        if (row == null) {
            return thing;
        }
        if (!row.containsKey("replacement")) {
            return thing;
        }
        String realString = row.get("replacement").toString();
        if (!Functions.isEmpty(realString)) {
            thing = row.get("replacement").toString();
        }
        if (!row.containsKey("data")) {
            return thing;
        }
        String newChanges = row.get("data").toString();
        if (!Functions.isEmpty(newChanges)) {
            ArrayList<String> ncArray = Functions.explode("\n", newChanges);
            for (String newChange : ncArray) {
                pc.add(Functions.str_replace(new String[]{"\r", "\n"}, new String[]{""}, newChange));
            }
        }
        return thing;
    }
}

