/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public final class strToTime {
    private static final List<Matcher> matchers = new LinkedList<Matcher>();

    static {
        matchers.add(new NowMatcher());
        matchers.add(new TomorrowMatcher());
        matchers.add(new DaysMatcher());
        matchers.add(new DateFormatMatcher(new SimpleDateFormat("yyyy.MM.dd G 'at' HH:mm:ss z")));
        matchers.add(new DateFormatMatcher(new SimpleDateFormat("d/MMM/yyyy:HH:mm:ss Z")));
        matchers.add(new DateFormatMatcher(new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z")));
        matchers.add(new DateFormatMatcher(new SimpleDateFormat("yyyy MM dd")));
    }

    public static synchronized void registerMatcher(Matcher matcher) {
        matchers.add(matcher);
    }

    public static Date strtotime(String input) {
        for (Matcher matcher : matchers) {
            Date date = matcher.tryConvert(input);
            if (date == null) continue;
            return date;
        }
        return null;
    }

    private strToTime() {
        throw new UnsupportedOperationException();
    }

    private static class DateFormatMatcher
    implements Matcher {
        private final DateFormat dateFormat;

        public DateFormatMatcher(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public Date tryConvert(String input) {
            try {
                return this.dateFormat.parse(input);
            }
            catch (ParseException ex) {
                return null;
            }
        }
    }

    private static class DaysMatcher
    implements Matcher {
        private final Pattern days = Pattern.compile("[\\-\\+]?\\d+ days");

        private DaysMatcher() {
        }

        public Date tryConvert(String input) {
            if (this.days.matcher(input).matches()) {
                int d = Integer.parseInt(input.split(" ")[0]);
                Calendar calendar = Calendar.getInstance();
                calendar.add(6, d);
                return calendar.getTime();
            }
            return null;
        }
    }

    public static interface Matcher {
        public Date tryConvert(String var1);
    }

    private static class NowMatcher
    implements Matcher {
        private final Pattern now = Pattern.compile("now");

        private NowMatcher() {
        }

        public Date tryConvert(String input) {
            if (this.now.matcher(input).matches()) {
                return new Date();
            }
            return null;
        }
    }

    private static class TomorrowMatcher
    implements Matcher {
        private final Pattern tomorrow = Pattern.compile("tomorrow");

        private TomorrowMatcher() {
        }

        public Date tryConvert(String input) {
            if (this.tomorrow.matcher(input).matches()) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(6, 1);
                return calendar.getTime();
            }
            return null;
        }
    }
}

