/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Cache;
import com.detectright.core.ConnectionLostException;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.Functions;
import com.detectright.core.RecordSet;
import com.detectright.core.Reflection;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBLink {
    public Connection db;
    public ConcurrentHashMap<String, LinkedHashMap<String, Object>> arrays = new ConcurrentHashMap();
    public ReentrantLock aLock = new ReentrantLock();
    static LinkedHashMap<String, String> typeMap = new LinkedHashMap();
    static LinkedHashMap<Integer, String> jdbcTypeMap = new LinkedHashMap();
    static LinkedHashMap<String, Object> allFields = new LinkedHashMap();
    static LinkedHashMap<String, Object> emptyHash = new LinkedHashMap();
    static LinkedHashMap<String, String> emptyHashS = new LinkedHashMap();
    LinkedHashMap<String, String> params = new LinkedHashMap();
    String name;
    int status;
    String hash;
    double queryTime = 0.0;
    int affectedRows = 0;
    static ThreadLocal<Cache> cacheLink = new ThreadLocal();
    protected Cache cache;
    static LinkedHashMap<String, DBLink> dbs = new LinkedHashMap();
    static ThreadLocal<LinkedHashMap<String, String>> connections = new ThreadLocal<LinkedHashMap<String, String>>(){

        @Override
        protected synchronized LinkedHashMap<String, String> initialValue() {
            return new LinkedHashMap<String, String>();
        }
    };
    static LinkedHashMap<String, Object> queryCache;
    static boolean RECORD_INSERT;
    static boolean useQueryCache;
    static volatile boolean useGlobalLink;
    static volatile DBLink global;
    String engine;
    boolean useCache = false;
    ArrayList<String> queryLog = new ArrayList();
    boolean dbOK = false;
    String currentDB = "";
    boolean logQueries = false;
    String error = "";
    protected double qt = 0.0;
    String lastSQL = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        useGlobalLink = true;
        DetectRight.registerClass("DBLink");
        allFields.put("0", "*");
        LinkedHashMap<Integer, String> linkedHashMap = jdbcTypeMap;
        synchronized (linkedHashMap) {
            jdbcTypeMap.put(-7, "BIT");
            jdbcTypeMap.put(-6, "TINYINT");
            jdbcTypeMap.put(5, "SMALLINT");
            jdbcTypeMap.put(4, "INTEGER");
            jdbcTypeMap.put(-5, "BIGINT");
            jdbcTypeMap.put(6, "FLOAT");
            jdbcTypeMap.put(7, "REAL");
            jdbcTypeMap.put(8, "DOUBLE");
            jdbcTypeMap.put(2, "NUMERIC");
            jdbcTypeMap.put(3, "DECIMAL");
            jdbcTypeMap.put(1, "CHAR");
            jdbcTypeMap.put(12, "VARCHAR");
            jdbcTypeMap.put(-1, "LONGVARCHAR");
            jdbcTypeMap.put(91, "DATE");
            jdbcTypeMap.put(92, "TIME");
            jdbcTypeMap.put(93, "TIMESTAMP");
            jdbcTypeMap.put(-2, "BINARY");
            jdbcTypeMap.put(-3, "VARBINARY");
            jdbcTypeMap.put(-4, "LONGVARBINARY");
            jdbcTypeMap.put(0, "NULL");
            jdbcTypeMap.put(1111, "OTHER");
            jdbcTypeMap.put(2004, "BLOB");
            jdbcTypeMap.put(2005, "CLOB");
        }
    }

    static void main(String[] args) {
    }

    DBLink(String hash) throws DetectRightException {
        if (hash == null) {
            hash = "";
        }
        this.hash = hash;
        if (Functions.is_null(DBLink.getCacheLink())) {
            DBLink.setCacheLink(DetectRight.getCacheLink());
        }
        this.cache = DBLink.getCacheLink();
        this.useCache = useQueryCache;
        this.logQueries = DetectRight.getLogQueries();
    }

    static Cache getCacheLink() {
        Cache c = cacheLink.get();
        if (c == null) {
            return null;
        }
        return c;
    }

    static boolean copyToGlobal(DBLink source) throws DetectRightException, ConnectionLostException {
        return false;
    }

    static void initConnections() {
        LinkedHashMap newconnections = new LinkedHashMap();
        connections.set(newconnections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DBLink getDBLink(String classname) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(classname)) {
            return new DBLink("dummy");
        }
        DetectRight.checkPoint("getting DBLink for " + classname);
        DBLink dbLink = null;
        Map connections = DBLink.connections.get();
        if (connections == null) {
            DBLink.initConnections();
        }
        if (!connections.containsKey(classname)) {
            classname = "DetectRight";
        }
        if (!connections.containsKey(classname)) {
            DetectRight.checkPoint("Failed to get DBLink for classname");
            return new DBLink("dummy");
        }
        String connection = (String)connections.get(classname);
        if (connection == null) {
            throw new ConnectionLostException("Cannot get " + connection);
        }
        String hash = connection;
        if (dbs == null) {
            dbs = new LinkedHashMap();
        }
        if (dbs.containsKey(hash)) {
            dbLink = dbs.get(connection);
            if (dbLink == null) {
                throw new ConnectionLostException("dbLink.dbs[" + hash + "] is null");
            }
            try {
                if (dbLink.db == null || dbLink.db.isClosed()) {
                    dbLink.connect();
                }
            }
            catch (Exception e) {
                DetectRight.checkPoint(e.getMessage());
                throw new ConnectionLostException(e.getMessage());
            }
        }
        if (dbLink != null) {
            return dbLink;
        }
        dbLink = DBLink.getConnection(connection);
        if (dbLink == null) {
            throw new ConnectionLostException("Cannot get connection " + connection);
        }
        LinkedHashMap<String, DBLink> linkedHashMap = dbs;
        synchronized (linkedHashMap) {
            dbs.put(hash, dbLink);
        }
        return dbLink;
    }

    static void assign(String classname, String connectString) {
        if (Functions.isEmpty(classname)) {
            return;
        }
        if (Functions.isEmpty(connectString)) {
            return;
        }
        if (!Functions.class_exists(classname, true)) {
            return;
        }
        LinkedHashMap<String, String> conn = connections.get();
        if (conn == null) {
            DBLink.initConnections();
            conn = connections.get();
            if (conn == null) {
                return;
            }
        }
        conn.put(classname, connectString);
    }

    static void setCacheLink(Cache cache) {
        if (cache == null) {
            return;
        }
        cacheLink.set(cache);
    }

    void __destruct() throws DetectRightException, ConnectionLostException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized boolean init() throws DetectRightException, ConnectionLostException {
        DBLink dbLink = null;
        DetectRight.checkPoint("Entering DBLink init", 0);
        Map connections = DBLink.connections.get();
        ArrayList<String> keys = Functions.array_keys_string(connections);
        ArrayList<String> done = new ArrayList<String>();
        for (String key : keys) {
            String connection;
            if (key == null) continue;
            if (key.equals("DetectRight") && useGlobalLink && global != null && DBLink.global.dbOK) {
                dbLink = global;
            }
            String classname = key;
            done.add(classname);
            String hash = connection = Functions.gvString(connections, key);
            if (dbLink == null && dbs.containsKey(hash)) {
                dbLink = dbs.get(hash);
                if (dbLink.db == null) {
                    dbLink = null;
                    DetectRight.checkPoint("dbs contained a DBLink object, but it was unusable", 0);
                } else {
                    DetectRight.checkPoint("dbs contains " + connection + " for " + classname, 0);
                }
            }
            if (dbLink == null) {
                DetectRight.checkPoint("Connecting to " + connection, 0);
                dbLink = DBLink.getConnection(connection);
                if (dbLink == null) {
                    DetectRight.checkPoint("Failed to get connection " + connection, 0);
                } else {
                    if (!dbLink.dbOK) {
                        return false;
                    }
                    LinkedHashMap<String, DBLink> linkedHashMap = dbs;
                    synchronized (linkedHashMap) {
                        if (!dbs.containsKey(hash)) {
                            dbs.put(hash, dbLink);
                        }
                    }
                }
            }
            if (classname.equals("DetectRight")) {
                DetectRight.setDBLink(dbLink);
                continue;
            }
            try {
                Field field = Reflection.getField(classname, "dbLink");
                if (field == null) continue;
                field.setAccessible(true);
                ThreadLocal o = (ThreadLocal)field.get(null);
                DBLink dbl = null;
                if (o == null) continue;
                dbl = (DBLink)o.get();
                if (dbl != null && dbl != dbLink) {
                    try {
                        dbl.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                o.set(dbLink);
            }
            catch (Throwable e) {
                DetectRight.checkPoint(e.getMessage(), 0);
            }
        }
        dbLink = DetectRight.getDBLink();
        if (dbLink != null) {
            if (!dbLink.dbOK) {
                return false;
            }
            if (!DetectRight.isClassesNull()) {
                int i = 0;
                while (i < DetectRight.classesSize()) {
                    block30: {
                        String clsname = DetectRight.getClass(i);
                        if (!(clsname.equals("DBLink") || clsname.equals("Functions") || clsname.equals("Reflection") || clsname.equals("SQLite") || clsname.equals("MySQL") || done.contains(clsname))) {
                            try {
                                Field field = Reflection.getField(clsname, "dbLink");
                                if (field == null) break block30;
                                field.setAccessible(true);
                                ThreadLocal o = (ThreadLocal)field.get(null);
                                DBLink dbl = (DBLink)o.get();
                                if (dbl != null && dbl.db != null && dbl != dbLink) {
                                    try {
                                        dbl.close();
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                                o.set(dbLink);
                            }
                            catch (Throwable e) {
                                DetectRight.checkPoint(e.getMessage(), 0);
                            }
                        }
                    }
                    ++i;
                }
            }
        } else {
            DetectRight.checkPoint("Failed to get DBLink on DBLink init", 0);
            throw new ConnectionLostException("Failed to get DBLink on init");
        }
        DetectRight.checkPoint(String.valueOf(Thread.currentThread().getName()) + " got DB " + dbLink.getConnectionInfo(), 0);
        return true;
    }

    static DBLink getConnection(String connection) throws DetectRightException, ConnectionLostException {
        if (connection == null) {
            connection = "";
        }
        return DBLink.getConnection(connection, false);
    }

    static DBLink getConnection(String connection, boolean redetect) throws DetectRightException, ConnectionLostException {
        if (connection == null) {
            connection = "";
        }
        if (!redetect && useGlobalLink && DBLink.testConnection(global)) {
            return global;
        }
        String hash = connection;
        DBLink dummyDBLink = new DBLink(hash);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        ArrayList<String> connectionArray = Functions.explode("//", connection);
        if (connectionArray.size() < 2) {
            throw new ConnectionLostException("Failed DB connection, too few parts " + connection);
        }
        params.put("engine", Functions.array_shift(connectionArray).toString());
        params.put("address", Functions.array_shift(connectionArray).toString());
        if (connectionArray.size() > 0) {
            params.put("port", Functions.array_shift(connectionArray).toString());
        }
        if (connectionArray.size() > 0) {
            params.put("username", Functions.array_shift(connectionArray).toString());
        }
        if (connectionArray.size() > 0) {
            params.put("password", Functions.array_shift(connectionArray).toString());
        }
        if (connectionArray.size() > 0) {
            params.put("bucket", Functions.array_shift(connectionArray).toString());
        }
        if (connectionArray.size() > 0) {
            params.put("useQueryCache", Functions.array_shift(connectionArray).toString());
        }
        params.put("timestamp", String.valueOf(Functions.time()));
        String engine = (String)params.get("engine");
        DBLink dbLink = null;
        try {
            Class<?> cls = Class.forName(Reflection.cn(engine));
            Class[] partypes = new Class[]{engine.getClass()};
            Constructor<?> ct = cls.getConstructor(partypes);
            Object[] arglist = new Object[]{new String(hash)};
            dbLink = (DBLink)ct.newInstance(arglist);
        }
        catch (Exception e) {
            throw new DetectRightException("Failed to create new " + engine, e);
        }
        dbLink.params = params;
        dbLink.connect();
        if (!dbLink.dbOK) {
            return dummyDBLink;
        }
        return dbLink;
    }

    void reset() {
        this.error = "";
    }

    boolean clearLogs() throws DetectRightException, ConnectionLostException {
        boolean success = this.deleteAllData("logs");
        return success;
    }

    boolean writeLogEntry(String entry) throws DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Object> array = new LinkedHashMap<String, Object>();
        array.put("Comment", entry);
        array.put("Datetime", "{NOW}");
        long success = this.insertData("logs", array, 0L);
        if (success == -1L) {
            Functions.dr_echo(this.sql_error());
        }
        return success > -1L;
    }

    double queryTime() {
        return this.qt;
    }

    ArrayList<?> getHashList(String table, String hashname) throws DetectRightException, ConnectionLostException {
        return this.getIDs(table, hashname);
    }

    String arrayFilter(String name, String value) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(name)) {
            return value;
        }
        if (value == null) {
            return value;
        }
        LinkedHashMap<String, Object> array = this.getArray(name);
        if (array == null) {
            return value;
        }
        for (Map.Entry entry : array.entrySet()) {
            String key = (String)entry.getKey();
            if (key == null) {
                return value;
            }
            String part = (String)entry.getValue();
            if (part == null) {
                return value;
            }
            if (Functions.substr(key, 0, 1).equals("%")) {
                if (Functions.stripos(value, key = Functions.substr(key, 1)) <= -1) continue;
                value = Functions.str_ireplace(Pattern.quote(key), part, value);
                continue;
            }
            if (!key.toLowerCase().equals(value.toLowerCase())) continue;
            value = part;
            break;
        }
        return value;
    }

    ArrayList<String> getArrayListString(String name) throws DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Object> lhm;
        ArrayList<String> output = new ArrayList<String>();
        LinkedHashMap<String, Object> tmp = lhm = this.getArray(name);
        for (Map.Entry e : tmp.entrySet()) {
            Object value = e.getValue();
            if (value == null) continue;
            output.add(value.toString());
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LinkedHashMap<String, Object> getArray(String name) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(name)) {
            return emptyHash;
        }
        LinkedHashMap<String, Object> retObj = null;
        if (this.arrays.containsKey(name)) {
            retObj = this.arrays.get(name);
        }
        if (retObj != null) {
            return retObj;
        }
        LinkedHashMap<String, Object> array = new LinkedHashMap();
        ConcurrentHashMap<String, LinkedHashMap<String, Object>> concurrentHashMap = this.arrays;
        synchronized (concurrentHashMap) {
            if (this.arrays.containsKey(name)) {
                array = this.arrays.get(name);
            } else {
                int exact;
                LinkedHashMap<String, Object> where = new LinkedHashMap<String, Object>();
                where.put("mapname", name);
                LinkedHashMap<String, Object> maps = this.simpleFetch("lookups", allFields, where);
                if (maps == null) {
                    return new LinkedHashMap<String, Object>();
                }
                if (maps.size() == 0) {
                    this.arrays.put(name, maps);
                    return maps;
                }
                LinkedHashMap mapRow = (LinkedHashMap)Functions.array_shift(maps);
                if (mapRow == null) {
                    return new LinkedHashMap<String, Object>();
                }
                String map = (String)mapRow.get("map");
                try {
                    exact = Functions.parseInt(mapRow.get("exact").toString());
                }
                catch (Throwable e) {
                    exact = 0;
                }
                ArrayList<String> mapArray = Functions.explode("\n", map);
                for (String mapPart : mapArray) {
                    ArrayList<String> tmp;
                    if (exact == 0) {
                        mapPart = "%" + mapPart;
                    }
                    if ((tmp = Functions.explode("=>", mapPart)).size() > 1) {
                        String key = tmp.get(0).toString();
                        String value = tmp.get(1).toString().trim();
                        array.put(key, value);
                        continue;
                    }
                    array.put(String.valueOf(array.size()), mapPart.trim());
                }
                this.arrays.put(name, array);
            }
        }
        return array;
    }

    boolean checkStatus() throws DetectRightException, ConnectionLostException {
        this.status = this.db == null ? -1 : (!this._ping() ? 0 : 1);
        return this.status == 1;
    }

    LinkedHashMap<String, Object> getTable(String tablename) throws DetectRightException, ConnectionLostException {
        return this.getTable(tablename, "");
    }

    LinkedHashMap<String, Object> getTable(String tablename, String orderBy) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(tablename)) {
            return new LinkedHashMap<String, Object>();
        }
        tablename = this.idd(tablename);
        if (!Functions.isEmpty(orderBy)) {
            orderBy = this.idd(orderBy);
            orderBy = " order by " + orderBy;
        }
        String sql = "select * from tablename" + orderBy;
        return this.getSQL(sql);
    }

    ArrayList<String> getIDs(Object table, String field, LinkedHashMap<String, Object> where, LinkedHashMap<String, Object> orderBy, LinkedHashMap<String, Object> limit, String sqlOp) throws DetectRightException, ConnectionLostException {
        String tableString;
        this.error = "";
        if (Functions.isEmpty(field)) {
            return new ArrayList<String>();
        }
        if (table instanceof String) {
            tableString = this.tableClauseFromArray((String)table);
        } else if (table instanceof LinkedHashMap) {
            LinkedHashMap table2 = (LinkedHashMap)table;
            tableString = this.tableClauseFromArray(table2);
        } else {
            return new ArrayList<String>();
        }
        if (Functions.isEmpty(sqlOp)) {
            sqlOp = "select";
        }
        String orderString = "";
        String limitString = "";
        String fieldListString = this.idd(field);
        String whereString = this.whereClauseFromArray(where);
        if (orderBy.size() > 0) {
            orderString = this.orderByFromArray(orderBy);
        }
        if (limit.size() > 0) {
            limitString = this._limit_string(limit);
        }
        if (Functions.isEmpty(this.error)) {
            String sql = String.valueOf(sqlOp) + " " + fieldListString + " from " + tableString + " " + whereString + " " + orderString + " " + limitString;
            return this.getIDsFromSQL(sql, field);
        }
        return null;
    }

    ArrayList<String> getIDs(Object table, String field, LinkedHashMap<String, Object> where, LinkedHashMap<String, Object> orderBy, LinkedHashMap<String, Object> limit) throws DetectRightException, ConnectionLostException {
        return this.getIDs(table, field, where, orderBy, limit, "select");
    }

    ArrayList<String> getIDs(Object table, String field, LinkedHashMap<String, Object> where, LinkedHashMap<String, Object> orderBy) throws DetectRightException, ConnectionLostException {
        return this.getIDs(table, field, where, orderBy, emptyHash, "select");
    }

    ArrayList<String> getIDs(Object table, String field, LinkedHashMap<String, Object> where) throws DetectRightException, ConnectionLostException {
        return this.getIDs(table, field, where, emptyHash, emptyHash, "select");
    }

    ArrayList<String> getIDs(Object table, String field) throws DetectRightException, ConnectionLostException {
        return this.getIDs(table, field, emptyHash, emptyHash, emptyHash, "select");
    }

    ArrayList<String> getIDsFromSQL(String sql) throws DetectRightException, ConnectionLostException {
        return this.getIDsFromSQL(sql, "ID");
    }

    ArrayList<String> getIDsFromSQL(String sql, String keyname) throws DetectRightException, ConnectionLostException {
        ArrayList<String> ids = new ArrayList<String>();
        if (Functions.isEmpty(sql)) {
            return ids;
        }
        LinkedHashMap<String, Object> result = this.query(sql);
        if (result == null) {
            return ids;
        }
        LinkedHashMap row = null;
        ArrayList<String> rowKeys = Functions.array_keys_string(result);
        for (String rowKey : rowKeys) {
            if (rowKey == null) continue;
            row = (LinkedHashMap)result.get(rowKey);
            if (row == null) break;
            String id = Functions.gvString(row, keyname);
            if (id == null) continue;
            ids.add(id);
        }
        return ids;
    }

    ArrayList<String> getFields(String table) throws DetectRightException, ConnectionLostException {
        if (table == null) {
            return new ArrayList<String>();
        }
        return this._getFields(table);
    }

    boolean setOption(String optionKey, String optionValue) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(optionKey) || Functions.isEmpty(optionValue)) {
            return false;
        }
        LinkedHashMap<String, Object> where = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        where.put("options", optionKey);
        data.put("optionKey", optionKey);
        data.put("optionValue", optionValue);
        boolean success = this.deleteData("options", where);
        success = success && this.insertData("options", data) > -1L;
        return success;
    }

    String getOption(String optionKey) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(optionKey)) {
            return "";
        }
        LinkedHashMap<String, Object> where = new LinkedHashMap<String, Object>();
        where.put("optionKey", optionKey);
        ArrayList<String> optionArray = this.getIDs("options", "optionValue", where);
        if (optionArray == null) {
            return "";
        }
        if (optionArray.size() > 0) {
            return optionArray.get(0);
        }
        return "";
    }

    boolean updateObject(Object obj) throws DetectRightException, ConnectionLostException {
        if (obj == null) {
            return false;
        }
        LinkedHashMap<String, Object> vars = Functions.get_object_vars(obj);
        if (vars == null) {
            return false;
        }
        LinkedHashMap<String, Object> varMap = vars;
        if (!vars.containsKey("fieldList")) {
            return false;
        }
        Object tmp = vars.get("fieldList");
        if (tmp == null) {
            return false;
        }
        if (!(tmp instanceof ArrayList)) {
            return false;
        }
        ArrayList fieldArray = (ArrayList)tmp;
        if (!vars.containsKey("pk")) {
            return false;
        }
        String pk = (String)vars.get("pk");
        fieldArray.remove(pk);
        for (Map.Entry entry : varMap.entrySet()) {
            String key = (String)entry.getKey();
            if (fieldArray.contains(key)) continue;
            vars.remove(key);
        }
        if (fieldArray.contains("ts")) {
            vars.put("ts", this._ts2Date(Functions.time()));
        }
        if (vars == null || vars.size() == 0) {
            throw new DetectRightException("update object failed for" + Functions.serialize(obj), null);
        }
        LinkedHashMap<String, Object> where = new LinkedHashMap<String, Object>();
        where.put(pk, vars.get(pk));
        String table = (String)vars.get("tablename");
        if (table == null) {
            return false;
        }
        boolean result = this.updateData(table, vars, where);
        return result;
    }

    LinkedHashMap<String, Object> getSQL(String sql) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(sql)) {
            return new LinkedHashMap<String, Object>();
        }
        LinkedHashMap output = null;
        DetectRight.checkPoint("Asked for sql", 4);
        String key = Functions.md5(String.valueOf(sql) + "/" + this.name);
        if (queryCache != null && queryCache.containsKey(key)) {
            output = (LinkedHashMap)queryCache.get(key);
            DetectRight.checkPoint("Served sql from querycache from this.name", 4);
            if (output != null) {
                return output;
            }
        }
        if (output == null && this.cache.cache_ok() && !DetectRight.getFlush()) {
            output = (LinkedHashMap)this.cache.cache_get(key);
        }
        if (output == null) {
            output = new LinkedHashMap();
            LinkedHashMap<String, Object> result = this.query(sql);
            if (result == null) {
                return null;
            }
            ArrayList<String> rowKeys = Functions.array_keys_string(result);
            for (String rowKey : rowKeys) {
                if (rowKey == null) continue;
                LinkedHashMap row = (LinkedHashMap)result.get(rowKey);
                if (row == null) break;
                output.put(rowKey, row);
            }
            if (this.cache != null) {
                this.cache.cache_set(key, output, 600);
            }
        } else {
            DetectRight.checkPoint("Served sql from memcache");
        }
        if (output.size() < 5000 && useQueryCache) {
            queryCache.put(key, output);
        }
        return output;
    }

    boolean bulkInsert(String table, ArrayList<Object> values) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(table)) {
            return false;
        }
        if (values == null) {
            return false;
        }
        table = this.idd(table);
        ArrayList<String> valueStrings = new ArrayList<String>();
        LinkedHashMap first = (LinkedHashMap)values.get(0);
        ArrayList<String> fields = Functions.array_keys_string(first);
        String fieldString = this.idd(fields);
        int i = 0;
        while (i < values.size()) {
            LinkedHashMap array = (LinkedHashMap)values.get(i);
            valueStrings.add("(" + this.qd(array) + ")");
            ++i;
        }
        boolean result = this._bulk_insert(table, fieldString, valueStrings);
        return result;
    }

    boolean bulkInsert(String table, ArrayList<String> fields, ArrayList<ArrayList<String>> values) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(table)) {
            return false;
        }
        if (fields == null) {
            return false;
        }
        if (values == null) {
            return false;
        }
        table = this.idd(table);
        ArrayList<String> valueStrings = new ArrayList<String>();
        String fieldString = this.idd(fields);
        int i = 0;
        while (i < values.size()) {
            ArrayList<String> array = values.get(i);
            valueStrings.add("(" + this.qd(array) + ")");
            ++i;
        }
        boolean result = this._bulk_insert(table, fieldString, valueStrings);
        return result;
    }

    String tableClauseFromArray(String table) {
        return this.idd(table);
    }

    String tableClauseFromArray(LinkedHashMap<String, Object> table) {
        if (table == null) {
            return "";
        }
        LinkedHashMap<String, Object> tables = Functions.gvHashSO(table, "tables");
        if (tables.size() == 0) {
            tables = Functions.gvHashSO(table, "table");
        }
        if (tables.size() == 0) {
            return "";
        }
        String op = Functions.gvString(table, "op", "=");
        String joinOp = Functions.gvString(table, "joinop", "inner join");
        LinkedHashMap<String, Object> on = Functions.gvHashSO(table, "on");
        ArrayList<String> onArray = new ArrayList<String>();
        ArrayList<String> sql = new ArrayList<String>();
        ArrayList<String> joinTables = new ArrayList<String>();
        LinkedHashMap<String, Object> tmpMap = tables;
        block0: for (Map.Entry entry : tmpMap.entrySet()) {
            Object tableObj = entry.getValue();
            if (tableObj instanceof String) {
                joinTables.add(this.idd((String)tableObj));
                continue;
            }
            if (!(tableObj instanceof LinkedHashMap)) continue;
            Map tmpMap2 = (Map)tableObj;
            for (Map.Entry tmpEntry : tmpMap2.entrySet()) {
                String asTable = (String)tmpEntry.getKey();
                if (asTable == null) continue block0;
                LinkedHashMap array = (LinkedHashMap)tmpEntry.getValue();
                asTable = this.idd(asTable);
                joinTables.add("( " + this.tableClauseFromArray(array) + " ) as " + asTable);
            }
        }
        sql.add(Functions.implode(" " + joinOp + " ", joinTables));
        tmpMap = on;
        for (Map.Entry entry : tmpMap.entrySet()) {
            String field1 = (String)entry.getKey();
            String field2 = (String)entry.getValue();
            field1 = this.idd(field1);
            field2 = this.idd(field2);
            onArray.add(String.valueOf(field1) + " " + op + " " + field2);
        }
        sql.add("on " + Functions.implode(" AND ", onArray));
        return Functions.implode(" ", sql);
    }

    String whereClauseFromArray(String where) {
        return this.whereClauseFromArray(where, false);
    }

    String whereClauseFromArray(String where, boolean suppressWhere) {
        if (Functions.isEmpty(where)) {
            return "";
        }
        String result = this.fix_delimiters(where);
        if (suppressWhere) {
            result = result.replace("where ", "");
        }
        return result;
    }

    String whereClauseFromArray(LinkedHashMap<String, Object> where) throws DetectRightException, ConnectionLostException {
        return this.whereClauseFromArray(where, false);
    }

    String whereClauseFromArray(LinkedHashMap<String, Object> where, boolean suppressWhere) throws DetectRightException, ConnectionLostException {
        if (where == null) {
            return "";
        }
        String op = "";
        String whereString = "";
        if (where.size() == 0) {
            return "";
        }
        ArrayList<String> whereClause = new ArrayList<String>();
        String joinOp = Functions.gvString(where, "op", "AND");
        where.remove("op");
        LinkedHashMap<String, Object> valueHM = null;
        String valueStr = "";
        LinkedHashMap<String, Object> whereMap = where;
        LinkedHashMap<String, Object> tmpMap = null;
        for (Map.Entry entry : whereMap.entrySet()) {
            String key = (String)entry.getKey();
            if (key == null) {
                Functions.trigger_error("Null Key in where clause");
                return null;
            }
            Object valueObj = entry.getValue();
            op = " = ";
            if (Functions.is_integer(key)) {
                if (!(valueObj instanceof LinkedHashMap)) continue;
                key = Functions.gvString((LinkedHashMap)valueObj, "field");
            }
            key = this.idd(key);
            if (valueObj instanceof LinkedHashMap) {
                valueHM = (LinkedHashMap<String, Object>)valueObj;
                if (!valueHM.containsKey("op") && !valueHM.containsKey("value")) {
                    Functions.trigger_error("Misformed something in where clause", null);
                    return null;
                }
                op = (String)valueHM.get("op");
                valueObj = valueHM.get("value");
            }
            if (valueObj instanceof LinkedHashMap) {
                valueHM = (LinkedHashMap)valueObj;
            } else if (valueObj instanceof ArrayList) {
                valueHM = Functions.arr2hm((ArrayList)valueObj);
            } else {
                valueStr = valueObj == null ? "null" : String.valueOf(valueObj);
            }
            if (op.equals("in") || op.equals("not in")) {
                String inItems = "";
                if (valueHM != null && valueHM.size() == 1) {
                    valueObj = Functions.array_shift(valueHM);
                } else if (valueHM != null && valueHM.size() == 0) {
                    key = op.equals("in") ? "false" : "true";
                    op = "";
                    valueObj = "";
                } else {
                    boolean doBool = true;
                    Object tmpObject = null;
                    tmpMap = valueHM;
                    for (Map.Entry tmpEntry : tmpMap.entrySet()) {
                        tmpObject = tmpEntry.getValue();
                        if (!Functions.is_array(tmpObject)) continue;
                        doBool = false;
                    }
                    if (!doBool) {
                        this.error = "Malformed in clause " + Functions.serialize(where);
                        return null;
                    }
                }
                if (!Functions.isEmpty(valueObj)) {
                    inItems = this.qd(valueObj);
                    valueStr = "(" + inItems + ")";
                } else {
                    valueStr = "";
                }
            } else if (op.equals("where")) {
                key = "";
                op = "";
                valueStr = "(" + Functions.nn(this.whereClauseFromArray(valueHM, true)) + ")";
            } else if (op.equals("expression")) {
                key = "";
                op = "";
                valueStr = "(" + this.fix_delimiters(valueStr) + ")";
            } else {
                String valueUpper = valueStr.toUpperCase();
                if (!valueUpper.equals("NOW()") && !valueUpper.equals("NULL")) {
                    valueStr = this.qd(valueStr);
                }
            }
            whereClause.add(Functions.trim(String.valueOf(key) + " " + op + " " + valueStr));
        }
        whereString = Functions.implode(" " + joinOp + " ", whereClause);
        if (!suppressWhere) {
            whereString = "where " + whereString;
        }
        return whereString;
    }

    int dcount(String table, String field, LinkedHashMap<String, Object> where) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(table)) {
            return 0;
        }
        if (Functions.isEmpty(field)) {
            return 0;
        }
        if (where == null) {
            where = new LinkedHashMap();
        }
        field = this.idd(field);
        String whereString = this.whereClauseFromArray(where);
        table = this.idd(table);
        String alias = this.idd("cnt");
        return this._dcount(table, field, alias, whereString);
    }

    int _dcount(String table, String field, String alias, String where) throws DetectRightException, ConnectionLostException {
        String sqlString;
        LinkedHashMap<String, Object> result;
        if (table == null) {
            return 0;
        }
        if (field == null) {
            return 0;
        }
        if (alias == null) {
            alias = "";
        }
        if (where == null) {
            where = "";
        }
        if ((result = this.query(sqlString = "select count(" + field + ") as " + alias + " from " + table + " " + where)) == null) {
            return 0;
        }
        if (result.size() == 0) {
            throw new DetectRightException("Failure to get dcount with SQL " + sqlString, null);
        }
        LinkedHashMap tmp = (LinkedHashMap)Functions.array_shift(result);
        if (tmp == null) {
            return 0;
        }
        int cnt = Integer.valueOf(Functions.gvString(tmp, "cnt", "0"));
        return cnt;
    }

    int dcount(LinkedHashMap<String, Object> table, String field, LinkedHashMap<String, Object> where) throws DetectRightException, ConnectionLostException {
        if (table == null) {
            return 0;
        }
        if (field == null) {
            return 0;
        }
        if (where == null) {
            where = new LinkedHashMap();
        }
        String tableString = this.tableClauseFromArray(table);
        field = this.idd(field);
        String whereString = this.whereClauseFromArray(where);
        String alias = this.idd("cnt");
        return this._dcount(tableString, field, alias, whereString);
    }

    ArrayList<String> dlookup(String fieldToReturn, LinkedHashMap<String, Object> table, LinkedHashMap<String, Object> where) throws DetectRightException, ConnectionLostException {
        if (table == null) {
            return new ArrayList<String>();
        }
        String tableString = this.tableClauseFromArray(table);
        return this.dlookup(fieldToReturn, tableString, where);
    }

    ArrayList<String> dlookup(String fieldToReturn, String table, LinkedHashMap<String, Object> where) throws DetectRightException, ConnectionLostException {
        ArrayList<String> output = new ArrayList<String>();
        if (Functions.isEmpty(table)) {
            return output;
        }
        String whereClause = this.whereClauseFromArray(where);
        table = this.idd(table);
        String field = this.idd(fieldToReturn);
        String sqlStr = "select " + field + " from " + table + whereClause;
        LinkedHashMap<String, Object> values = this.query(sqlStr);
        if (values == null) {
            throw new DetectRightException("Null values from sqlStr", null);
        }
        int numRows = values.size();
        if (numRows == 0) {
            return null;
        }
        if (numRows == 1) {
            LinkedHashMap value = (LinkedHashMap)Functions.array_shift(values);
            output.add((String)value.get(fieldToReturn));
        } else {
            ArrayList<String> arrayKeys = Functions.array_keys_string(values);
            for (String arrayKey : arrayKeys) {
                LinkedHashMap value;
                if (arrayKey == null || (value = (LinkedHashMap)values.get(arrayKey)) == null) continue;
                output.add((String)value.get(fieldToReturn));
            }
        }
        return output;
    }

    String setClauseFromArray(LinkedHashMap<String, Object> set) {
        return this.setClauseFromArray(set, false);
    }

    String setClauseFromArray(LinkedHashMap<String, Object> set, boolean suppressSet) {
        if (set == null) {
            return "";
        }
        ArrayList<String> setArray = new ArrayList<String>();
        LinkedHashMap<String, Object> tmpMap = set;
        for (Map.Entry entry : tmpMap.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            String valueStr = Functions.is_array(value) || Functions.is_object(value) ? Functions.serialize(value) : (String)value;
            if (key.equals("expression")) {
                setArray.add(this.fix_delimiters(valueStr));
                continue;
            }
            key = this.idd(key);
            value = this.qd(value);
            setArray.add(String.valueOf(key) + " = " + value);
        }
        String returnStr = "";
        if (!suppressSet) {
            returnStr = "set ";
        }
        return String.valueOf(returnStr) + Functions.implode(",", setArray);
    }

    String orderByFromArray(String orderBy) {
        return this.fix_delimiters(orderBy);
    }

    String orderByFromArray(LinkedHashMap<String, Object> orderBy) {
        if (orderBy.size() == 0) {
            return "";
        }
        ArrayList<String> orderClause = new ArrayList<String>();
        LinkedHashMap<String, Object> tmpMap = orderBy;
        for (Map.Entry entry : tmpMap.entrySet()) {
            String key = (String)entry.getKey();
            Object valueObj = entry.getValue();
            if (!(valueObj instanceof String)) continue;
            String value = (String)valueObj;
            if (Functions.is_numeric(key)) {
                key = value;
                value = "ASC";
            }
            if (key.equals("expression")) {
                orderClause.add(value);
                continue;
            }
            key = this.idd(key);
            if (!(Functions.isEmpty(value) || value.toUpperCase().equals("ASC") || value.toUpperCase().equals("DESC"))) {
                value = "";
            }
            orderClause.add(String.valueOf(key) + " " + value);
        }
        return "order by " + Functions.implode(",", orderClause);
    }

    long commitObject(Object object) throws DetectRightException, ConnectionLostException {
        return this.commitObject(object, false);
    }

    long commitObject(Object object, boolean delayed) throws DetectRightException, ConnectionLostException {
        if (object == null) {
            return -1L;
        }
        LinkedHashMap<String, Object> vars = Functions.get_object_vars(object);
        if (!vars.containsKey("fieldList")) {
            return -1L;
        }
        ArrayList fieldArray = (ArrayList)vars.get("fieldList");
        if (fieldArray == null) {
            return -1L;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        ArrayList<Object> data = new ArrayList<Object>();
        for (String property : fieldArray) {
            if (property == null) continue;
            Object use = vars.get(property);
            String useStr = Functions.is_object(use) || Functions.is_array(use) ? Functions.serialize(use) : (String)use;
            if (property.equals("ts") || useStr.equals("NOW()")) {
                useStr = "{NOW}";
            }
            result.put(property, useStr);
        }
        data.add(result);
        String tablename = (String)vars.get("tablename");
        String pk = (String)vars.get("pk");
        return this.commitData(data, tablename, false, pk, delayed);
    }

    long commitData(ArrayList<Object> data, String table, boolean preserveIDs, String pkid) throws DetectRightException, ConnectionLostException {
        return this.commitData(data, table, preserveIDs, pkid, false);
    }

    long commitData(ArrayList<Object> data, String table) throws DetectRightException, ConnectionLostException {
        return this.commitData(data, table, false, "ID", false);
    }

    long commitData(ArrayList<Object> data, String table, boolean preserveIDs, String pkid, boolean delayedBool) throws DetectRightException, ConnectionLostException {
        String delayed = "";
        if (data == null) {
            return -1L;
        }
        if (data.size() == 0) {
            return -1L;
        }
        delayed = delayedBool ? this._delayed_string() : "";
        table = this.idd(table);
        for (Object row : data) {
            if (row instanceof String) {
                row = Functions.ungz(row.toString());
            }
            if (!(row instanceof LinkedHashMap)) {
                return -1L;
            }
            LinkedHashMap rowHM = (LinkedHashMap)row;
            ArrayList<String> fieldList = Functions.array_keys_string(rowHM);
            if (!preserveIDs) {
                fieldList.remove(pkid);
            }
            ArrayList<String> values = new ArrayList<String>();
            int i = 0;
            while (i < fieldList.size()) {
                String field = fieldList.get(i);
                String value = (String)rowHM.get(field);
                if (value == null) {
                    fieldList.remove(i);
                } else {
                    value = this.qd(value);
                    values.add(value);
                }
                ++i;
            }
            String fieldListStr = this.idd(fieldList);
            String sqlStr = "insert " + delayed + " into " + table + "(" + fieldListStr + ") VALUES (" + Functions.implode(",", values) + ")";
            boolean result = this.queryBool(sqlStr);
            if (result) continue;
            return -1L;
        }
        if (delayedBool) {
            return 0L;
        }
        return this.insert_id();
    }

    boolean tableExists(String tablename) throws DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Object> result = this.query("SHOW CREATE TABLE `tablename`");
        if (result == null) {
            return false;
        }
        return result.size() != 0;
    }

    boolean updateData(String table, LinkedHashMap<String, Object> data, LinkedHashMap<String, Object> where) throws DetectRightException, ConnectionLostException {
        return this.updateData(table, data, where, "update");
    }

    boolean updateData(String table, LinkedHashMap<String, Object> data, LinkedHashMap<String, Object> where, String sqlOp) throws DetectRightException, ConnectionLostException {
        this.error = "";
        table = this.idd(table);
        String whereString = this.whereClauseFromArray(where);
        String setString = this.setClauseFromArray(data);
        if (Functions.isEmpty(setString)) {
            return false;
        }
        if (Functions.isEmpty(whereString)) {
            return false;
        }
        if (!Functions.isEmpty(this.error)) {
            return false;
        }
        String sqlStr = String.valueOf(sqlOp) + " " + table + " " + setString + " " + whereString;
        boolean success = this.queryBool(sqlStr);
        return success;
    }

    String fieldListFromArray(String fieldList) {
        return fieldList;
    }

    String fieldListFromArray(LinkedHashMap<String, Object> fieldList) {
        ArrayList<String> output = new ArrayList<String>();
        String[] noQuoteChars = new String[]{"*", "("};
        LinkedHashMap<String, Object> tmpMap = fieldList;
        for (Map.Entry entry : tmpMap.entrySet()) {
            String fieldName;
            Object field = entry.getValue();
            String as = "";
            if (Functions.is_array(field)) {
                LinkedHashMap tmp = (LinkedHashMap)field;
                fieldName = (String)tmp.get("field");
                as = (String)tmp.get("as");
            } else {
                fieldName = (String)field;
            }
            boolean doField = true;
            boolean doAs = true;
            String[] stringArray = noQuoteChars;
            int n = noQuoteChars.length;
            int n2 = 0;
            while (n2 < n) {
                String charStr = stringArray[n2];
                if (Functions.strpos(fieldName, charStr) > -1) {
                    doField = false;
                }
                if (Functions.strpos(as, charStr) > -1) {
                    doAs = false;
                }
                ++n2;
            }
            if (doField) {
                fieldName = this.idd(fieldName);
            }
            if (doAs && !Functions.isEmpty(as)) {
                as = this.idd(as);
            }
            if (!Functions.isEmpty(as)) {
                output.add(String.valueOf(fieldName) + " as " + as);
                continue;
            }
            output.add(fieldName);
        }
        String fieldListString = Functions.implode(",", output);
        return fieldListString;
    }

    LinkedHashMap<String, Object> simpleFetch(Object table, LinkedHashMap<String, Object> fieldList, LinkedHashMap<String, Object> where, LinkedHashMap<String, Object> orderBy, LinkedHashMap<String, Object> limitClause, String keyField) throws DetectRightException, ConnectionLostException {
        return this.simpleFetch(table, fieldList, where, orderBy, limitClause, keyField, "select");
    }

    LinkedHashMap<String, Object> simpleFetch(Object table, LinkedHashMap<String, Object> fieldList, LinkedHashMap<String, Object> where, LinkedHashMap<String, Object> orderBy, LinkedHashMap<String, Object> limitClause) throws DetectRightException, ConnectionLostException {
        return this.simpleFetch(table, fieldList, where, orderBy, limitClause, "", "select");
    }

    LinkedHashMap<String, Object> simpleFetch(Object table, LinkedHashMap<String, Object> fieldList, LinkedHashMap<String, Object> where, LinkedHashMap<String, Object> orderBy) throws DetectRightException, ConnectionLostException {
        return this.simpleFetch(table, fieldList, where, orderBy, emptyHash, "", "select");
    }

    LinkedHashMap<String, Object> simpleFetch(Object table, LinkedHashMap<String, Object> fieldList, LinkedHashMap<String, Object> where) throws DetectRightException, ConnectionLostException {
        return this.simpleFetch(table, fieldList, where, emptyHash, emptyHash, "", "select");
    }

    LinkedHashMap<String, Object> simpleFetch(Object table, LinkedHashMap<String, Object> fieldList) throws DetectRightException, ConnectionLostException {
        return this.simpleFetch(table, fieldList, emptyHash, emptyHash, emptyHash, "", "select");
    }

    LinkedHashMap<String, Object> simpleFetch(Object tableObj, LinkedHashMap<String, Object> fieldList, LinkedHashMap<String, Object> where, LinkedHashMap<String, Object> orderBy, LinkedHashMap<String, Object> limitClause, String keyField, String sqlOp) throws DetectRightException, ConnectionLostException {
        if (tableObj == null) {
            return null;
        }
        this.error = "";
        String whereString = "";
        String orderString = "";
        String limitString = "";
        String tableString = "";
        tableString = tableObj instanceof LinkedHashMap ? this.tableClauseFromArray((LinkedHashMap)tableObj) : this.idd((String)tableObj);
        if (Functions.isEmpty(tableString)) {
            return null;
        }
        String fieldListString = this.fieldListFromArray(fieldList);
        if (Functions.isEmpty(fieldListString)) {
            this.error = "Field List Error";
            return null;
        }
        whereString = this.whereClauseFromArray(where);
        LinkedHashMap<String, Object> result = null;
        if (orderBy != null && orderBy.size() > 0) {
            orderString = this.orderByFromArray(orderBy);
        }
        if (limitClause != null && limitClause.size() > 0) {
            limitString = this._limit_string(limitClause);
        }
        if (Functions.isEmpty(this.error)) {
            String sql = String.valueOf(sqlOp) + " " + fieldListString + " from " + tableString + " " + whereString + " " + orderString + " " + limitString;
            try {
                result = this.query(sql, keyField);
            }
            catch (DetectRightException de) {
                throw de;
            }
            catch (ConnectionLostException ce) {
                throw ce;
            }
            catch (Exception e) {
                throw new DetectRightException("Misc Query problem", e);
            }
        } else {
            return null;
        }
        return result;
    }

    long insertData(Object table, LinkedHashMap<String, Object> array, long id, boolean delayed) throws DetectRightException, ConnectionLostException {
        return this.insertData(table, array, id, delayed, "insert");
    }

    long insertData(Object table, LinkedHashMap<String, Object> array, long id) throws DetectRightException, ConnectionLostException {
        return this.insertData(table, array, id, false, "insert");
    }

    long insertData(Object table, LinkedHashMap<String, Object> array) throws DetectRightException, ConnectionLostException {
        return this.insertData(table, array, 0L, false, "insert");
    }

    long insertData(Object tableObj, LinkedHashMap<String, Object> array, long id, boolean delayed, String sqlOp) throws DetectRightException, ConnectionLostException {
        this.error = "";
        String table = tableObj instanceof LinkedHashMap ? this.tableClauseFromArray((LinkedHashMap)tableObj) : (String)tableObj;
        table = table.toLowerCase();
        if (delayed) {
            sqlOp = String.valueOf(sqlOp) + " " + this._delayed_string();
        }
        String fields = this.idd(Functions.array_keys(array));
        ArrayList<Object> values = Functions.array_values(array);
        ArrayList<String> newValues = new ArrayList<String>();
        int i = 0;
        while (i < values.size()) {
            Object value = values.get(i);
            boolean serialize = true;
            if (value instanceof String) {
                serialize = false;
            } else if (value instanceof Integer) {
                serialize = false;
            } else if (value instanceof Long) {
                serialize = false;
            } else if (value instanceof Float) {
                serialize = false;
            } else if (value instanceof Double) {
                serialize = false;
            } else if (value instanceof Boolean) {
                boolean valueBool = Functions.to_boolean(value.toString());
                value = valueBool ? "1" : "0";
                serialize = false;
            }
            if (serialize) {
                newValues.add(Functions.serialize(value));
            } else {
                newValues.add(String.valueOf(value));
            }
            ++i;
        }
        String valueString = this.qd(newValues);
        if (!Functions.isEmpty(this.error)) {
            return -1L;
        }
        if (id == 0L) {
            String sqlStr = String.valueOf(sqlOp) + " into {idd}" + table + "{idd} (" + fields + ") VALUES (" + valueString + ")";
            boolean result = this.queryBool(sqlStr);
            if (!result) {
                return -1L;
            }
            return this.insert_id();
        }
        LinkedHashMap<String, Object> rs = this.query("select ID from " + table + "where ID=" + String.valueOf(id));
        if (rs.size() == 0) {
            String sqlStr = String.valueOf(sqlOp) + " into " + table + "(" + fields + ") VALUES (" + valueString + ")";
            boolean result = this.queryBool(sqlStr);
            if (!result) {
                return -1L;
            }
            long insert_id = this.insert_id();
            return insert_id;
        }
        ArrayList<String> clause = new ArrayList<String>();
        LinkedHashMap<String, Object> tmpMap = array;
        for (Map.Entry entry : tmpMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            clause.add(String.valueOf(key) + "=" + value);
        }
        String clauseStr = Functions.implode(",", clause);
        String sqlStr = "update " + table + " set " + clauseStr + " where ID=" + String.valueOf(id);
        boolean result = this.queryBool(sqlStr);
        if (result) {
            return id;
        }
        return -1L;
    }

    LinkedHashMap<String, Object> fillArrayFromSQL(String sql) throws DetectRightException, ConnectionLostException {
        return this.fillArrayFromSQL(sql, "ID", false, false);
    }

    LinkedHashMap<String, Object> fillArrayFromSQL(String sql, String keyColumn) throws DetectRightException, ConnectionLostException {
        return this.fillArrayFromSQL(sql, keyColumn, false, false);
    }

    LinkedHashMap<String, Object> fillArrayFromSQL(String sql, String keyColumn, boolean cleanKeys) throws DetectRightException, ConnectionLostException {
        return this.fillArrayFromSQL(sql, keyColumn, cleanKeys, false);
    }

    LinkedHashMap<String, Object> fillArrayFromSQL(String sql, String keyColumn, boolean cleanKeys, boolean arrayOfArrays) throws DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Object> rs;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        String keyColumn2 = "";
        if (Functions.strpos(keyColumn, ",") > -1) {
            ArrayList<String> keyTmp = Functions.explode(",", keyColumn);
            keyColumn = keyTmp.get(0);
            keyColumn2 = keyTmp.get(1);
        }
        try {
            rs = this.query(sql, keyColumn);
        }
        catch (ConnectionLostException e) {
            rs = null;
            throw e;
        }
        catch (DetectRightException de) {
            rs = null;
            throw de;
        }
        if (rs == null) {
            return null;
        }
        ArrayList<String> keys = Functions.array_keys_string(rs);
        String key = "";
        for (String rowKey : keys) {
            if (rowKey == null) continue;
            LinkedHashMap row = (LinkedHashMap)rs.get(rowKey);
            if (row == null) break;
            Object tmpObj = row.get(keyColumn);
            if (tmpObj == null) {
                return rs;
            }
            if (cleanKeys) {
                key = Functions.str_replace(" ", "", tmpObj.toString());
                key = key.toLowerCase();
            } else {
                key = tmpObj.toString();
                key = row.get(keyColumn).toString();
            }
            if (result.containsKey(key)) {
                Object value = result.get(key);
                if (!(value instanceof LinkedHashMap)) {
                    LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>();
                    if (!Functions.isEmpty(keyColumn2)) {
                        String kc2 = (String)row.get(keyColumn2);
                        tmp.put(kc2, value);
                    } else {
                        tmp.put(String.valueOf(tmp.size()), value);
                    }
                    result.put(key, tmp);
                    continue;
                }
                LinkedHashMap valueHM = (LinkedHashMap)value;
                if (!Functions.isEmpty(keyColumn2)) {
                    valueHM.put(row.get(keyColumn2).toString(), row);
                    continue;
                }
                valueHM.put(String.valueOf(valueHM.size()), row);
                continue;
            }
            if (!arrayOfArrays) {
                result.put(key, row);
                continue;
            }
            LinkedHashMap<String, LinkedHashMap> tmp = new LinkedHashMap<String, LinkedHashMap>();
            if (!Functions.isEmpty(keyColumn2)) {
                tmp.put(row.get(keyColumn2).toString(), row);
            } else {
                tmp.put(String.valueOf(tmp.size()), row);
            }
            result.put(key, tmp);
        }
        return result;
    }

    String idd(String identifier) {
        if (identifier.equals("*")) {
            return identifier;
        }
        ArrayList<String> arr = new ArrayList<String>();
        arr.add(identifier);
        return this.idd(arr);
    }

    String idd(ArrayList<?> id) {
        ArrayList<?> identifier = id;
        String identifier_delimiter = this._identifier_delimiter();
        int i = 0;
        while (i < identifier.size()) {
            String value = (String)identifier.get(i);
            if (value != null) {
                ArrayList<String> tmp1 = Functions.explode(".", value);
                ArrayList<String> tmp2 = new ArrayList<String>();
                for (String tmpValue : tmp1) {
                    tmp2.add(String.valueOf(identifier_delimiter) + this.escape_string(tmpValue) + identifier_delimiter);
                }
                value = Functions.implode(".", tmp2);
                identifier.set(i, value);
            }
            ++i;
        }
        String result = Functions.implode(",", identifier);
        return result;
    }

    String qd(Object value) {
        if (Functions.is_null(value)) {
            return this._null();
        }
        String quoted_delimiter = this._quoted_delimiter();
        String resultStr = "";
        if (value instanceof ArrayList) {
            ArrayList valArr = (ArrayList)value;
            int i = 0;
            while (i < valArr.size()) {
                String tmpValue = (String)valArr.get(i);
                LinkedHashMap<String, Object> result = this.qd_doValue(tmpValue);
                boolean doBool = Functions.to_boolean(result.get("do").toString());
                tmpValue = (String)result.get("value");
                if (doBool) {
                    tmpValue = String.valueOf(quoted_delimiter) + this.escape_string(tmpValue) + quoted_delimiter;
                }
                valArr.set(i, tmpValue);
                ++i;
            }
            resultStr = Functions.implode(",", valArr);
        } else if (value instanceof Integer || value instanceof String || value instanceof Float || value instanceof Double || Functions.is_numeric(String.valueOf(value)) || Functions.strlen(String.valueOf(value)) > 10) {
            LinkedHashMap<String, Object> result = this.qd_doValue(String.valueOf(value));
            boolean doBool = Functions.to_boolean(result.get("do").toString());
            resultStr = (String)result.get("value");
            if (doBool) {
                resultStr = String.valueOf(quoted_delimiter) + this.escape_string(resultStr) + quoted_delimiter;
            }
        }
        return resultStr;
    }

    LinkedHashMap<String, Object> qd_doValue(String value) {
        String mcw = this._multichar_wildcard();
        String scw = this._singlechar_wildcard();
        String now = this._now();
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>(2);
        value = Functions.str_ireplace("{mcw}", mcw, value);
        value = Functions.str_ireplace("{scw}", scw, value);
        boolean doBool = true;
        if (value.equals("{NOW}") || value.equals("NOW()")) {
            value = Functions.str_ireplace("{NOW}", now, value);
            value = Functions.str_ireplace("NOW()", now, value);
            doBool = false;
        } else if (value.length() > 31) {
            doBool = true;
        } else if (value.equals("\\N") || value.equals("null") || value.equals("NULL")) {
            value = "null";
            doBool = false;
        } else {
            doBool = true;
        }
        output.put("value", value);
        output.put("do", doBool);
        return output;
    }

    boolean deleteDataSeries(String table, ArrayList<String> list, String field) throws DetectRightException, ConnectionLostException {
        this.error = "";
        if (table == null) {
            return false;
        }
        if (list == null || list.size() == 0) {
            return false;
        }
        LinkedHashMap<String, Object> where = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> arg = new LinkedHashMap<String, Object>();
        arg.put("op", "in");
        arg.put("value", list);
        where.put(field, arg);
        if (this.checkTable(table)) {
            table = this.idd(table);
            String whereString = this.whereClauseFromArray(where);
            String sqlStr = "delete from " + table + " " + whereString;
            boolean result = this.queryBool(sqlStr);
            return result;
        }
        return false;
    }

    boolean deleteData(String table, LinkedHashMap<String, Object> where) throws DetectRightException, ConnectionLostException {
        this.error = "";
        table = this.idd(table);
        if (where.size() == 0) {
            return false;
        }
        String whereString = this.whereClauseFromArray(where);
        if (!Functions.isEmpty(whereString)) {
            String sqlStr = "delete from " + table + " " + whereString;
            return this.queryBool(sqlStr);
        }
        this.error = "No where clause supplied";
        return false;
    }

    boolean deleteAllData(String table) throws DetectRightException, ConnectionLostException {
        table = this.idd(table);
        String sqlStr = "truncate table table";
        boolean success = this.queryBool(sqlStr);
        return success;
    }

    void recordInsert(String table, String id) throws DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("table", table);
        data.put("added", id);
        if (RECORD_INSERT) {
            this.insertData("new", data);
        }
    }

    boolean replaceData(String tablename, LinkedHashMap<String, Object> data) {
        return true;
    }

    boolean connect() throws DetectRightException, ConnectionLostException {
        return false;
    }

    boolean selectDatabase(String database) throws DetectRightException, ConnectionLostException {
        boolean retval = this._selectDatabase(database);
        if (!retval && this.connect()) {
            retval = this._selectDatabase(database);
        }
        if (retval) {
            this.currentDB = database;
        }
        return retval;
    }

    LinkedHashMap<String, Object> fetch_array(ResultSet result) throws DetectRightException, ConnectionLostException {
        if (result == null) {
            this.error = "Not a resource";
            return null;
        }
        return this._fetch_array(result);
    }

    boolean free_result(ResultSet result) throws DetectRightException, ConnectionLostException {
        return this._free_result(result);
    }

    String escape_string(String string) {
        if (string == null) {
            return "";
        }
        return this._escape_string(string);
    }

    int num_rows(ResultSet result) throws DetectRightException, ConnectionLostException {
        if (result == null) {
            return 0;
        }
        return this._num_rows(result);
    }

    long insert_id() throws DetectRightException, ConnectionLostException {
        return this._insert_id();
    }

    int affected_rows() {
        return this._affected_rows();
    }

    String sql_error() {
        String error = this._sql_error();
        if (error != null && !Functions.isEmpty(error)) {
            this.error = error;
        }
        return error;
    }

    void close() throws DetectRightException, ConnectionLostException {
        DetectRight.checkPoint(String.valueOf(Thread.currentThread().getName()) + " closed the DBLink");
        this._close();
        dbs.remove(this.hash);
    }

    void _close() throws DetectRightException, ConnectionLostException {
    }

    Connection getDBObject() {
        return this.db;
    }

    boolean queryBool(String sql) throws DetectRightException, ConnectionLostException {
        this.error = "";
        this.lastSQL = "";
        if (this.logQueries && DetectRight.getDiag().booleanValue()) {
            this.queryLog.add(sql);
            DetectRight.checkPoint(sql);
        }
        double start = Functions.mt();
        sql = this.fix_delimiters(sql);
        boolean ret = this._queryBool(sql);
        this.lastSQL = sql;
        if (!ret) {
            this.error = this._sql_error();
            if (this.logQueries && !Functions.isEmpty(this.error)) {
                this.queryLog.add(this.error);
            }
        }
        if (this.logQueries && DetectRight.getDiag().booleanValue()) {
            double timeTaken = Functions.mt() - start;
            this.queryTime += timeTaken;
            String log = String.valueOf(this._affected_rows()) + " affected rows, (" + Functions.round(timeTaken, 4) + " s)";
            DetectRight.checkPoint(log);
            this.queryLog.add(log);
        }
        if (!ret) {
            this.error = this._sql_error();
            if (this.logQueries) {
                this.queryLog.add(this.error);
            }
        }
        return ret;
    }

    private LinkedHashMap<String, Object> query(String sql) throws DetectRightException, ConnectionLostException {
        return this.query(sql, "");
    }

    private LinkedHashMap<String, Object> query(String sql, String keyField) throws DetectRightException, ConnectionLostException {
        this.error = "";
        this.lastSQL = "";
        boolean logQueries = this.logQueries;
        Field dbLink = Reflection.getField(this, "db");
        if (dbLink == null) {
            Functions.trigger_error("Database connection has gone to null for dbLink " + this.params, true);
        }
        if (logQueries && DetectRight.getDiag().booleanValue()) {
            this.queryLog.add(sql);
            DetectRight.checkPoint(sql);
        }
        double start = Functions.mt();
        sql = this.fix_delimiters(sql);
        LinkedHashMap<String, Object> query = this._query(sql, keyField);
        this.lastSQL = sql;
        if (query == null) {
            this.error = this._sql_error();
            if (logQueries) {
                this.queryLog.add(this.error);
            }
        }
        if (logQueries && DetectRight.getDiag().booleanValue()) {
            double timeTaken = Functions.mt() - start;
            this.queryTime += timeTaken;
            String log = String.valueOf(this._affected_rows()) + " affected rows, (" + Functions.round(timeTaken, 4) + " s)";
            DetectRight.checkPoint(log);
            this.queryLog.add(log);
        }
        if (query == null) {
            this.error = this._sql_error();
            if (logQueries) {
                this.queryLog.add(this.error);
            }
        }
        return query;
    }

    RecordSet fetchRecordset(String table, LinkedHashMap<String, Object> fieldList, LinkedHashMap<String, Object> where) throws DetectRightException, ConnectionLostException {
        return this.fetchRecordset(table, fieldList, where, emptyHash, emptyHash, "", "select", "ID");
    }

    RecordSet fetchRecordset(String table, LinkedHashMap<String, Object> fieldList, LinkedHashMap<String, Object> where, LinkedHashMap<String, Object> orderBy) throws DetectRightException, ConnectionLostException {
        return this.fetchRecordset(table, fieldList, where, orderBy, emptyHash, "", "select", "ID");
    }

    RecordSet fetchRecordset(String table, LinkedHashMap<String, Object> fieldList, LinkedHashMap<String, Object> where, LinkedHashMap<String, Object> orderBy, LinkedHashMap<String, Object> limitClause) throws DetectRightException, ConnectionLostException {
        return this.fetchRecordset(table, fieldList, where, orderBy, limitClause, "", "select", "ID");
    }

    RecordSet fetchRecordset(String table, LinkedHashMap<String, Object> fieldList, LinkedHashMap<String, Object> where, LinkedHashMap<String, Object> orderBy, LinkedHashMap<String, Object> limitClause, String keyField) throws DetectRightException, ConnectionLostException {
        return this.fetchRecordset(table, fieldList, where, orderBy, limitClause, keyField, "select", "ID");
    }

    RecordSet fetchRecordset(String table, LinkedHashMap<String, Object> fieldList, LinkedHashMap<String, Object> where, LinkedHashMap<String, Object> orderBy, LinkedHashMap<String, Object> limitClause, String keyField, String sqlOp) throws DetectRightException, ConnectionLostException {
        return this.fetchRecordset(table, fieldList, where, orderBy, limitClause, keyField, sqlOp, "ID");
    }

    RecordSet fetchRecordset(String table, LinkedHashMap<String, Object> fieldList, LinkedHashMap<String, Object> where, LinkedHashMap<String, Object> orderBy, LinkedHashMap<String, Object> limitClause, String keyField, String sqlOp, String idField) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(this.error)) {
            RecordSet result = new RecordSet(this, table, fieldList, where, orderBy, limitClause, keyField, sqlOp, idField);
            return result;
        }
        return null;
    }

    ArrayList<String> queryLog() {
        return this.queryLog;
    }

    LinkedHashMap<String, Object> fetch_assoc(ResultSet result) throws DetectRightException, ConnectionLostException {
        if (result == null) {
            return null;
        }
        return this._fetch_assoc(result);
    }

    String fix_delimiters(String string) {
        if (Functions.isEmpty(string)) {
            return "";
        }
        string = Functions.str_ireplace("{idd}", this._identifier_delimiter(), string);
        string = Functions.str_ireplace("{dd}", this._quoted_delimiter(), string);
        string = Functions.str_ireplace("{qd}", this._quoted_delimiter(), string);
        string = Functions.str_ireplace("{MCW}", this._multichar_wildcard(), string);
        string = Functions.str_ireplace("{SCW}", this._singlechar_wildcard(), string);
        string = Functions.str_ireplace("{NOW}", this._now(), string);
        return string;
    }

    LinkedHashMap<String, Object> fetch_all(ResultSet result) throws DetectRightException, ConnectionLostException {
        if (result == null) {
            return null;
        }
        LinkedHashMap<String, Object> rawRows = this._fetch_all(result);
        return rawRows;
    }

    LinkedHashMap<String, Object> fetch_all(ResultSet result, String keyField) throws DetectRightException, ConnectionLostException {
        return this.fetch_all(result, keyField, false);
    }

    LinkedHashMap<String, Object> fetch_all(ResultSet result, ArrayList<String> keyField) throws DetectRightException, ConnectionLostException {
        return this.fetch_all(result, keyField, false);
    }

    LinkedHashMap<String, Object> fetch_all(ResultSet result, String keyField, boolean arrayOfArrays) throws DetectRightException, ConnectionLostException {
        ArrayList<String> keyFieldArr = new ArrayList<String>();
        if (!Functions.isEmpty(keyField)) {
            keyFieldArr.add(keyField);
        }
        return this.fetch_all(result, keyFieldArr, arrayOfArrays);
    }

    LinkedHashMap<String, Object> fetch_all(ResultSet result, ArrayList<String> keyField, boolean arrayOfArrays) throws DetectRightException, ConnectionLostException {
        if (result == null) {
            return null;
        }
        if (keyField == null || keyField.size() == 0) {
            return this.fetch_all(result);
        }
        LinkedHashMap<String, Object> rawRows = this._fetch_all(result);
        LinkedHashMap output = new LinkedHashMap();
        LinkedHashMap<String, Object> tmpMap = rawRows;
        for (Map.Entry entry : tmpMap.entrySet()) {
            LinkedHashMap row = (LinkedHashMap)entry.getValue();
            if (row == null) continue;
            ArrayList<String> keys = new ArrayList<String>();
            for (String field : keyField) {
                keys.add((String)row.get(field));
            }
            LinkedHashMap currentNode = output;
            for (String tmpKey : keys) {
                if (arrayOfArrays) {
                    if (!output.containsKey(tmpKey)) {
                        output.put(tmpKey, new LinkedHashMap());
                    }
                    currentNode = (LinkedHashMap)output.get(tmpKey);
                    currentNode.put(String.valueOf(currentNode.size()), row);
                    continue;
                }
                output.put((String)tmpKey, (Object)row);
            }
        }
        return output;
    }

    boolean checkTable(String tablename) throws DetectRightException, ConnectionLostException {
        ArrayList<String> tables = this._getTableList();
        return Functions.in_array((Object)tablename, tables);
    }

    String getMaxPK(String table) throws DetectRightException, ConnectionLostException {
        return this.getMaxPK(table, "ID");
    }

    String getMaxPK(String table, String pk) throws DetectRightException, ConnectionLostException {
        String sql;
        LinkedHashMap<String, Object> result;
        if (Functions.isEmpty(table)) {
            return "";
        }
        if (Functions.isEmpty(pk)) {
            pk = "ID";
        }
        if ((result = this.query(sql = "select max({IDD}" + pk + "{IDD}) as maxid from {IDD}" + table + "{IDD}")) == null) {
            return String.valueOf(0);
        }
        LinkedHashMap row = (LinkedHashMap)Functions.array_shift(result);
        if (row.size() == 0) {
            return String.valueOf(0);
        }
        return (String)row.get("maxid");
    }

    String ts2Date(long ts) {
        return this._ts2Date(ts);
    }

    ArrayList<String> _getTableList() throws DetectRightException, ConnectionLostException {
        return new ArrayList<String>();
    }

    String _ts2Date(long ts) {
        return "";
    }

    boolean _ping() throws DetectRightException, ConnectionLostException {
        return false;
    }

    boolean _connect() throws DetectRightException, ConnectionLostException {
        return false;
    }

    boolean _selectDatabase(String database) throws DetectRightException, ConnectionLostException {
        return false;
    }

    String _limit_string(LinkedHashMap<String, Object> hm) {
        return "";
    }

    LinkedHashMap<String, Object> _fetch_array(ResultSet result) throws DetectRightException, ConnectionLostException {
        return new LinkedHashMap<String, Object>();
    }

    boolean _free_result(ResultSet result) throws DetectRightException, ConnectionLostException {
        return true;
    }

    String _escape_string(String string) {
        return string;
    }

    int _num_rows(ResultSet result) throws DetectRightException, ConnectionLostException {
        return 0;
    }

    long _insert_id() throws DetectRightException, ConnectionLostException {
        return -1L;
    }

    int _affected_rows() {
        return 0;
    }

    String _sql_error() {
        return "";
    }

    LinkedHashMap<String, Object> _query(String sql) throws DetectRightException, ConnectionLostException {
        return null;
    }

    LinkedHashMap<String, Object> _query(String sql, String keyField) throws DetectRightException, ConnectionLostException {
        return null;
    }

    boolean _queryBool(String sql) throws DetectRightException, ConnectionLostException {
        return false;
    }

    LinkedHashMap<String, Object> _fetch_assoc(ResultSet result) throws DetectRightException, ConnectionLostException {
        return new LinkedHashMap<String, Object>();
    }

    LinkedHashMap<String, Object> _fetch_all(ResultSet result) throws DetectRightException, ConnectionLostException {
        return new LinkedHashMap<String, Object>();
    }

    LinkedHashMap<String, Object> _fetch_all(ResultSet result, String keyField) throws DetectRightException, ConnectionLostException {
        return new LinkedHashMap<String, Object>();
    }

    String _identifier_delimiter() {
        return "";
    }

    String _quoted_delimiter() {
        return "\"";
    }

    String _multichar_wildcard() {
        return "*";
    }

    String _singlechar_wildcard() {
        return "_";
    }

    boolean _bulk_insert(String table, String fields, ArrayList<String> values) throws DetectRightException, ConnectionLostException {
        return false;
    }

    String _delayed_string() {
        return "delayed";
    }

    String _now() {
        return "NOW()";
    }

    String _null() {
        return "null";
    }

    ArrayList<String> _getFields(String str) throws DetectRightException, ConnectionLostException {
        return new ArrayList<String>();
    }

    static String getCurClassName() {
        return new CurClassNameGetter().getClassName();
    }

    static LinkedHashMap<String, Object> limitMap(int limit) {
        LinkedHashMap<String, Object> lm = new LinkedHashMap<String, Object>();
        lm.put("limit", String.valueOf(limit));
        return lm;
    }

    static LinkedHashMap<String, Object> fieldMap(String fields) {
        LinkedHashMap<String, Object> fm = new LinkedHashMap<String, Object>();
        if (Functions.isEmpty(fields)) {
            return fm;
        }
        ArrayList<String> arr = Functions.explode(",", fields);
        for (String part : arr) {
            fm.put(String.valueOf(fm.size()), part);
        }
        return fm;
    }

    public static LinkedHashMap<String, Object> whereClause(String initialKey, String initialValue) {
        LinkedHashMap<String, Object> where = new LinkedHashMap<String, Object>();
        if (Functions.isEmpty(initialKey)) {
            return where;
        }
        where.put(initialKey, initialValue);
        return where;
    }

    ArrayList<String> getTables() throws DetectRightException, ConnectionLostException {
        ArrayList<String> tables = new ArrayList<String>();
        try {
            DatabaseMetaData meta = this.getConnectionObject().getMetaData();
            ResultSet res = meta.getTables(null, null, null, new String[]{"TABLE"});
            while (res.next()) {
                tables.add(res.getString("TABLE_NAME"));
            }
            res.close();
        }
        catch (Throwable e) {
            return new ArrayList<String>();
        }
        return tables;
    }

    ArrayList<String> getDDL(String tablename, LinkedHashMap<?, ?> pk, LinkedHashMap<?, ?> index, LinkedHashMap<?, ?> fields) throws DetectRightException, ConnectionLostException {
        return new ArrayList<String>();
    }

    String getDDLQuick(String table, DBLink formatFor) throws DetectRightException, ConnectionLostException {
        String ddl = "";
        return ddl;
    }

    LinkedHashMap<String, Object> getTableMap(String tableName) {
        LinkedHashMap<String, Object> table = new LinkedHashMap<String, Object>();
        if (Functions.isEmpty(tableName)) {
            return table;
        }
        try {
            DatabaseMetaData dbmd = this.getConnectionObject().getMetaData();
            ResultSet columns = dbmd.getColumns(this.currentDB, null, tableName, null);
            boolean success = columns.first();
            if (!success) {
                return table;
            }
            do {
                LinkedHashMap<String, Object> field = new LinkedHashMap<String, Object>();
                String colName = columns.getString("COLUMN_NAME");
                int dataType = columns.getInt("DATA_TYPE");
                boolean takesNulls = false;
                int nullable = columns.getInt("NULLABLE");
                if (nullable == 1) {
                    takesNulls = true;
                }
                int colSize = columns.getInt("COLUMN_SIZE");
                field.put("colName", colName);
                field.put("dataType", dataType);
                field.put("takesNulls", takesNulls);
                field.put("colSize", colSize);
                table.put(colName, field);
            } while (success = columns.next());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return table;
    }

    LinkedHashMap<String, Object> getTableIndices(String tableName) {
        LinkedHashMap<String, Object> indexCollection = new LinkedHashMap<String, Object>();
        if (tableName == null) {
            return indexCollection;
        }
        try {
            DatabaseMetaData dbmd = this.getConnectionObject().getMetaData();
            ResultSet indices = dbmd.getIndexInfo(this.currentDB, null, tableName, false, false);
            boolean success = indices.first();
            if (!success) {
                return indexCollection;
            }
            do {
                LinkedHashMap<String, Object> indexColumn = new LinkedHashMap<String, Object>();
                String indexName = indices.getString("INDEX_NAME");
                if (indexName == null) continue;
                if (!indexCollection.containsKey(indexName)) {
                    indexCollection.put(indexName, new LinkedHashMap());
                }
                LinkedHashMap lhm = (LinkedHashMap)indexCollection.get(indexName);
                boolean nonUnique = indices.getBoolean("NON_UNIQUE");
                int ordinalPosition = indices.getInt("ORDINAL_POSITION");
                String colName = indices.getString("COLUMN_NAME");
                String ascOrDesc = indices.getString("ASC_OR_DESC");
                indexColumn.put("colName", colName);
                indexColumn.put("nonUnique", nonUnique);
                indexColumn.put("ascOrDesc", ascOrDesc);
                lhm.put(ordinalPosition, indexColumn);
            } while (success = indices.next());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return indexCollection;
    }

    LinkedHashMap<Integer, Object> getPrimaryKey(String tableName) {
        LinkedHashMap<Integer, Object> primaryKey = new LinkedHashMap<Integer, Object>();
        if (tableName == null) {
            return primaryKey;
        }
        try {
            DatabaseMetaData dbmd = this.getConnectionObject().getMetaData();
            ResultSet pk = dbmd.getPrimaryKeys(this.currentDB, null, tableName);
            boolean success = pk.first();
            if (!success) {
                return primaryKey;
            }
            do {
                LinkedHashMap<String, String> pkColumn = new LinkedHashMap<String, String>();
                String pkName = pk.getString("PK_NAME");
                String colName = pk.getString("COLUMN_NAME");
                int ordinal = pk.getInt("KEY_SEQ");
                pkColumn.put("pkName", pkName);
                pkColumn.put("colName", colName);
                primaryKey.put(ordinal, pkColumn);
            } while (success = pk.next());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return primaryKey;
    }

    LinkedHashMap<String, String> getColumnsQuick(String table) {
        LinkedHashMap<String, String> output = new LinkedHashMap<String, String>();
        try {
            PreparedStatement WSps = this.getConnectionObject().prepareStatement("SELECT * from " + table + " WHERE 1 = 0");
            ResultSetMetaData WSsmd = WSps.getMetaData();
            int numcols = WSsmd.getColumnCount();
            int i = 1;
            while (i < numcols + 1) {
                String ctype = WSsmd.getColumnTypeName(i);
                String cname = WSsmd.getColumnName(i);
                output.put(ctype, cname);
                ++i;
            }
        }
        catch (Throwable e) {
            return new LinkedHashMap<String, String>();
        }
        return output;
    }

    boolean createTable(String tableName, LinkedHashMap<?, ?> pk, LinkedHashMap<?, ?> index, LinkedHashMap<?, ?> fields) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeHash(String hash) throws DetectRightException, ConnectionLostException {
        if (hash == null) {
            return;
        }
        if (dbs.containsKey(hash)) {
            LinkedHashMap<String, DBLink> linkedHashMap = dbs;
            synchronized (linkedHashMap) {
                block13: {
                    try {
                        if (!dbs.containsKey(hash)) break block13;
                        DBLink old = dbs.get(hash);
                        if (old != null) {
                            DBLink dBLink = old;
                            synchronized (dBLink) {
                                try {
                                    old.close();
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }
                        dbs.remove(hash);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public Connection getConnectionObject() throws ConnectionLostException {
        if (this.db == null) {
            throw new ConnectionLostException(this.params.toString());
        }
        return this.db;
    }

    public String getConnectionInfo() throws ConnectionLostException {
        return Reflection.get_object_vars(this.getConnectionObject()).toString();
    }

    public static boolean testConnection(DBLink dbl) throws DetectRightException, ConnectionLostException {
        if (dbl == null) {
            return false;
        }
        Connection conn = dbl.getConnectionObject();
        if (conn == null) {
            return false;
        }
        try {
            if (conn.isClosed()) {
            }
        }
        finally {
            return false;
        }
        return true;
    }

    static class CurClassNameGetter
    extends SecurityManager {
        CurClassNameGetter() {
        }

        String getClassName() {
            return this.getClassContext()[1].getName();
        }
    }
}

