/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.ConnectionLostException;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.Functions;
import com.detectright.core.Reflection;
import com.detectright.core.Validator;
import com.detectright.core.boolean_validator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Datapoint
implements Cloneable {
    static ArrayList<String> fields = new ArrayList();
    static String[] fieldList = new String[]{"source", "label", "trust", "value", "units", "flag", "version", "max", "min", "arg", "partofset", "type", "importance", "importanceOffset", "hash"};
    static final int TRUST_IMPORTANCE_MULTIPLIER = 10;
    public String map = "";
    public String command = "";
    public String wildcard;
    public String type = "none";
    public String source = "";
    public int importance = 0;
    public int importanceOffset = 0;
    public int trust = 0;
    public String hash = "";
    public ArrayList<String> brand = new ArrayList();
    public String context = "";
    public String property = "";
    public String label = "";
    public boolean negate = false;
    public int access_count = 0;
    public boolean locked = false;
    public String value = "";
    public String units = "none";
    public String flag = "";
    public String version = "";
    public String max = "";
    public String min = "";
    public int arg = 0;
    public int partofset = 0;
    public boolean validated = false;
    public boolean parsed = false;

    static void main(String[] args) {
    }

    Datapoint() {
    }

    Datapoint(String string) throws DetectRightException, ConnectionLostException {
        this(string, "");
    }

    void addBrand(String brand) {
        if (!this.brand.contains(brand)) {
            this.brand.add(brand);
        }
    }

    void lock() {
        this.applyLock(true);
    }

    void unlock() {
        this.applyLock(false);
    }

    void applyLock(boolean lockType) {
        this.locked = lockType;
    }

    void setSource(String source) {
        this.source = source;
    }

    boolean isLocked() {
        return this.locked;
    }

    Datapoint(String command, String wildcard) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(command)) {
            return;
        }
        if (Functions.substr(command, 0, 1).equals("!")) {
            this.negate = true;
            if (Functions.strpos(command = Functions.substr(command, 1), "status=1") > -1) {
                command = Functions.str_replace("status=1", "status=0", command);
            } else if (Functions.strpos(command, "status=0") > -1) {
                command = Functions.str_replace("status=0", "status=1", command);
            }
        }
        if (Functions.strpos(command, "|") > -1) {
            ArrayList<String> tmp = Functions.explode("|", command);
            command = tmp.get(0);
            this.type = tmp.get(1);
        }
        this.command = command;
        this.wildcard = wildcard;
        this.parse();
        this.parseValue();
    }

    public int getAccessCount() {
        return this.access_count;
    }

    public void recordAccess() {
        ++this.access_count;
    }

    public Datapoint clone() {
        try {
            Datapoint cloned = (Datapoint)super.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            return this;
        }
    }

    ArrayList<String> __sleep() {
        LinkedHashMap<String, Object> ov = Reflection.get_object_vars(this);
        ov.remove("parsed");
        ov.remove("access_count");
        ov.remove("locked");
        return Functions.array_keys_string(ov);
    }

    LinkedHashMap<String, Object> toArray() {
        return Reflection.get_object_vars(this);
    }

    void mergeWith(Datapoint datapoint) {
    }

    boolean compliesWithDP(Datapoint datapoint) {
        if (datapoint == null) {
            return false;
        }
        String[] fieldsToDo = new String[]{"units", "flag", "version", "max", "min", "value"};
        String[] comparitors = new String[]{"<>", "!=", ">=", "<=", "=", "!", "<", ">"};
        String queryValue = null;
        String compareValue = null;
        String[] stringArray = fieldsToDo;
        int n = fieldsToDo.length;
        int n2 = 0;
        while (n2 < n) {
            block20: {
                boolean ret;
                String comparitor;
                block21: {
                    String field = stringArray[n2];
                    comparitor = "=";
                    try {
                        if (field.equals("units")) {
                            queryValue = datapoint.units;
                        } else if (field.equals("flag")) {
                            queryValue = datapoint.flag;
                        } else if (field.equals("version")) {
                            queryValue = datapoint.version;
                        } else if (field.equals("max")) {
                            queryValue = datapoint.max;
                        } else if (field.equals("value")) {
                            queryValue = datapoint.value;
                        }
                        if (Functions.is_null(queryValue) || Functions.strpos(queryValue, "*") > -1) break block20;
                        if (field.equals("units")) {
                            compareValue = this.units;
                            break block21;
                        }
                        if (field.equals("flag")) {
                            compareValue = this.flag;
                            break block21;
                        }
                        if (field.equals("version")) {
                            compareValue = this.version;
                            break block21;
                        }
                        if (field.equals("max")) {
                            compareValue = this.max;
                            break block21;
                        }
                        if (!field.equals("value")) break block21;
                        compareValue = this.value;
                    }
                    catch (Throwable e) {
                        break block20;
                    }
                }
                String[] stringArray2 = comparitors;
                int n3 = comparitors.length;
                int n4 = 0;
                while (n4 < n3) {
                    String testComparitor = stringArray2[n4];
                    if (queryValue.startsWith(testComparitor)) {
                        comparitor = testComparitor;
                        queryValue = Functions.substr(queryValue, Functions.strlen(testComparitor));
                        break;
                    }
                    ++n4;
                }
                if (!((Functions.isEmpty(queryValue) || Functions.isEmpty(compareValue)) && comparitor.equals("=") || (ret = Functions.compares(queryValue, compareValue, comparitor)))) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    String getWildcardField() {
        String[] fieldsToDo;
        String[] stringArray = fieldsToDo = new String[]{"value", "max", "flag", "version", "min"};
        int n = fieldsToDo.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            try {
                String value = this.getProperty(field);
                if (value != null) {
                    if (value.equals("*")) {
                        return field;
                    }
                    if (value.equals("!*")) {
                        return field;
                    }
                    if (Functions.strpos(value, "*") > -1) {
                        return field;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n2;
        }
        return "";
    }

    String getProperty(String field) throws Exception {
        if (field == null) {
            return null;
        }
        if (field.equals("value")) {
            return this.value;
        }
        if (field.equals("max")) {
            return this.max;
        }
        if (field.equals("flag")) {
            return this.flag;
        }
        if (field.equals("version")) {
            return this.version;
        }
        if (field.equals("min")) {
            return this.min;
        }
        if (field.equals("type")) {
            return this.type;
        }
        if (field.equals("hash")) {
            return this.hash;
        }
        return String.valueOf(Reflection.getProperty(this, field));
    }

    static boolean hasProperty(String field) {
        if (field == null) {
            return false;
        }
        if (field.equals("value")) {
            return true;
        }
        if (field.equals("max")) {
            return true;
        }
        if (field.equals("flag")) {
            return true;
        }
        if (field.equals("version")) {
            return true;
        }
        if (field.equals("min")) {
            return true;
        }
        if (field.equals("type")) {
            return true;
        }
        if (field.equals("hash")) {
            return true;
        }
        return Reflection.property_exists("Datapoint", field);
    }

    public void setWildcard(String value) throws DetectRightException, ConnectionLostException {
        String testBool;
        if (this.negate && value != null && !Functions.is_array(value) && (testBool = Validator.validate("boolean", value.toString())) != null) {
            value = testBool;
        }
        this.wildcard = value;
    }

    public String toString() {
        LinkedHashMap<String, String> vars = new LinkedHashMap<String, String>();
        String[] stringArray = fieldList;
        int n = fieldList.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            try {
                vars.put(field, this.getProperty(field));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        String context = this.context;
        String label = this.label;
        String property = this.property;
        vars.remove("map");
        vars.remove("validated");
        vars.remove("command");
        vars.remove("negate");
        vars.remove("parsed");
        vars.remove("label");
        vars.remove("access_count");
        vars.remove("locked");
        vars.remove("importance");
        vars.remove("importanceOffset");
        vars.remove("directHit");
        ArrayList<String> args = new ArrayList<String>();
        args.add("importance:" + String.valueOf(this.getImportance()));
        for (Map.Entry entry : vars.entrySet()) {
            boolean boolVal;
            String valueStr;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null || Functions.is_array(value) || Functions.isEmpty(valueStr = String.valueOf(value))) continue;
            value = Functions.is_boolean(valueStr) ? ((boolVal = Functions.to_boolean(valueStr)) ? new String("1") : new String("0")) : Functions.str_replace(";", "\\;", valueStr);
            args.add(String.valueOf(key) + ":" + value);
        }
        StringBuffer output = new StringBuffer();
        if (!Functions.isEmpty(context)) {
            output.append(String.valueOf(context) + ".");
        }
        output.append(property);
        output.append("=");
        output.append(label);
        output.append("{");
        output.append(Functions.implode("; ", args));
        output.append("}");
        return output.toString();
    }

    int getDataStatus() {
        String strippedCommand;
        if (this.flag.equals("0")) {
            return 0;
        }
        if (Functions.str_replace(" ", "", this.command).equals("status=0")) {
            return 0;
        }
        if (this.command.equals("status") && this.wildcard != null) {
            if (this.wildcard instanceof String && this.wildcard.toString().equals("0")) {
                return 0;
            }
            if (String.valueOf(this.wildcard).equals("0")) {
                return 0;
            }
        }
        if ((strippedCommand = Functions.str_replace(" ", "", this.command)).contains("status->0")) {
            return 0;
        }
        if (strippedCommand.contains("sc->0")) {
            return 0;
        }
        if (strippedCommand.contains("|0:")) {
            return 0;
        }
        return 1;
    }

    void fromString(String string) {
        if (Functions.isEmpty(string)) {
            return;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        Functions.parse_str(string, args);
        this.fill(args);
    }

    void fill(LinkedHashMap<String, Object> args) {
        if (args == null) {
            return;
        }
        LinkedHashMap<String, Object> map = args;
        for (Map.Entry e : map.entrySet()) {
            String key = (String)e.getKey();
            if (key == null) continue;
            String obj = (String)e.getValue();
            this.setValue(key, obj);
        }
    }

    String hash() throws DetectRightException {
        if (this.hash == null || this.hash.equals("")) {
            this.hash = Functions.md5(this.toString());
        }
        return this.hash;
    }

    void addImportance(int importance) {
        this.importanceOffset += importance;
    }

    void setImportance(int importance) {
        this.importance = importance;
    }

    int getImportance() {
        if (this.importance == 0 && this.command != null && this.command.contains("importance")) {
            String impString = Functions.substr(this.command, Functions.stripos(this.command, "importance->") + Functions.strlen("importance->"));
            int pos = Functions.strpos(impString, "&/&");
            if (pos > -1) {
                impString = Functions.substr(impString, 0, pos);
            }
            try {
                this.importance = Functions.parseInt(impString);
            }
            catch (NumberFormatException ne) {
                this.importance = -1;
            }
        }
        return this.importance + this.importanceOffset;
    }

    boolean isPath() {
        if (Functions.isEmpty(this.map)) {
            return false;
        }
        String map = Functions.str_replace("://", "{cdbs}", this.map);
        return Functions.strpos(map, "//") > -1;
    }

    String shiftPath() {
        String map = Functions.str_replace("://", "{cdbs}", this.map);
        ArrayList<String> array = Functions.explode("//", this.map);
        String path = (String)Functions.array_shift(array);
        this.map = map = Functions.str_replace("{cdbs}", "://", Functions.implode("//", array));
        return path;
    }

    void initValues() {
        this.value = "";
        this.min = "";
        this.max = "";
        this.flag = "0";
        this.type = "none";
        this.context = "";
        this.property = "";
        this.label = "";
        this.units = "none";
        this.version = "";
        this.arg = 0;
        this.partofset = 0;
    }

    boolean parse() {
        String valuePart;
        if (Functions.isEmpty(this.command)) {
            return false;
        }
        this.initValues();
        ArrayList<String> parts = Functions.explode("=", this.command, 2);
        if (parts.size() < 2) {
            return false;
        }
        String propertyPart = parts.get(0);
        this.value = valuePart = parts.get(1);
        if (Functions.strpos(propertyPart, ".") > -1) {
            ArrayList<String> tmp = Functions.explode(".", propertyPart);
            this.property = (String)Functions.array_pop(tmp);
            this.context = Functions.implode(".", tmp);
        } else if (Functions.strpos(propertyPart, "}") > -1) {
            ArrayList<String> tmp = Functions.explode("}", propertyPart);
            this.property = (String)Functions.array_pop(tmp);
            this.context = Functions.str_replace("{", "", Functions.implode(".", tmp));
        } else {
            this.property = propertyPart;
            this.context = "";
        }
        return true;
    }

    void parseValue() throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(this.command)) {
            return;
        }
        boolean_validator bv = new boolean_validator();
        String valuePart = String.valueOf(this.value);
        this.value = "";
        ArrayList<String> tmp = Functions.explode("{", valuePart, 2);
        this.label = (String)Functions.array_shift(tmp);
        if (Functions.isEmpty(tmp)) {
            return;
        }
        String dataPart = (String)Functions.array_shift(tmp);
        dataPart = Functions.str_replace("}", ";", dataPart);
        String[] stringArray = fieldList;
        int n = fieldList.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            int pos = Functions.stripos(dataPart, String.valueOf(field) + ":");
            int fieldLen = Functions.strlen(field) + 1;
            if (pos != -1) {
                int endpos = -1;
                int marker = (pos += fieldLen) + 1;
                while (endpos == -1) {
                    endpos = dataPart.indexOf(";", marker);
                    if (endpos == 0) {
                        Functions.trigger_error("Zero position semicolon endpos in dataPart for field " + field, null, false);
                        continue;
                    }
                    if (endpos == -1) {
                        Functions.trigger_error("Datapart fragment with missing semicolon/curly bracket dataPart for field " + field, null, false);
                        endpos = Functions.strlen(dataPart);
                        break;
                    }
                    String checkChar = Functions.substr(dataPart, endpos - 1, 1);
                    if (!checkChar.equals("\\")) continue;
                    marker = endpos + 1;
                    endpos = -1;
                }
                String value = Functions.substr(dataPart, pos, endpos - pos).trim();
                value = Functions.str_replace("\\", "", value);
                if (field.equals("flag") && !value.equals("*") && !value.equals("!*")) {
                    value = bv.process(value);
                }
                if (value != null) {
                    if (value.equals(";")) {
                        value = "";
                    }
                    this.setValue(field, value);
                }
            }
            ++n2;
        }
        this.parsed = true;
        this.command = "";
    }

    void setValue(String field, String value) {
        if (field == null) {
            return;
        }
        if (value == null) {
            return;
        }
        try {
            if (field.equals("value")) {
                this.value = value;
            } else if (field.equals("units")) {
                this.units = value;
            } else if (field.equals("trust")) {
                this.trust = Functions.parseInt(value);
            } else if (field.equals("max")) {
                this.max = value;
            } else if (field.equals("min")) {
                this.min = value;
            } else if (field.equals("type")) {
                this.type = value;
            } else if (field.equals("hash")) {
                this.hash = value;
            } else if (field.equals("partofset")) {
                this.partofset = Functions.parseInt(value);
            } else if (field.equals("flag")) {
                this.flag = value;
            } else if (field.equals("source")) {
                this.source = value;
            } else if (field.equals("importance")) {
                this.importance = Functions.parseInt(value);
            } else if (field.equals("importanceOffset")) {
                this.importanceOffset = Functions.parseInt(value);
            } else if (field.equals("arg")) {
                this.arg = Functions.parseInt(value);
            } else if (field.equals("version")) {
                this.version = value;
            } else if (field.equals("label")) {
                this.label = value;
            } else if (field.equals("property")) {
                this.property = value;
            } else if (field.equals("context")) {
                this.context = value;
            } else {
                Reflection.setValue(this, field, value);
            }
        }
        catch (NumberFormatException nfe) {
            return;
        }
    }

    void processValue() {
        if (Functions.isEmpty(this.wildcard)) {
            return;
        }
        if (Functions.is_array(this.wildcard)) {
            return;
        }
        String[] keysToUse = new String[]{"value", "max", "min", "flag", "type", "version"};
        String wildcard = this.wildcard;
        String value = Functions.trim(wildcard);
        String[] stringArray = keysToUse;
        int n = keysToUse.length;
        int n2 = 0;
        while (n2 < n) {
            block14: {
                String field = stringArray[n2];
                try {
                    String prefix;
                    Integer pos;
                    String valueToUse = this.getProperty(field);
                    if (valueToUse == null || (pos = Integer.valueOf(Functions.strpos(valueToUse, "*"))) <= -1) break block14;
                    value = Functions.trim(value);
                    if (pos > 0 && (prefix = Functions.substr(value, 0, pos)).equals("!") && Functions.is_boolean(value = Functions.substr(value, 1))) {
                        value = String.valueOf(!Functions.to_boolean(value = Functions.substr(value, 1)));
                    }
                    if (valueToUse.equals("pow(2,*)")) {
                        try {
                            double dValue = Double.parseDouble(value);
                            value = String.valueOf(Math.pow(2.0, dValue));
                            valueToUse = "*";
                        }
                        catch (Throwable e) {
                            value = "";
                        }
                    } else if (valueToUse.equals("root(2,*)")) {
                        try {
                            Integer iValue = Integer.parseInt(value);
                            String bValue = Integer.toBinaryString(iValue);
                            value = String.valueOf(bValue.length() - 1);
                            valueToUse = "*";
                        }
                        catch (Throwable e) {
                            value = "";
                        }
                    }
                    if (field.equals("flag")) {
                        value = Validator.validate("boolean", value);
                    }
                    value = Functions.str_replace("\\", "", value);
                    this.setValue(field, Functions.str_replace("*", value, valueToUse));
                    this.wildcard = "";
                    break;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    static Datapoint dataPointFromParts(String value, String flag, String min, String max, String units, String version, int importance, int partOfSet) {
        return Datapoint.dataPointFromParts(value, flag, min, max, units, version, importance, partOfSet, "");
    }

    static Datapoint dataPointFromParts(String value, String flag, String min, String max, String units, String version, int importance) {
        return Datapoint.dataPointFromParts(value, flag, min, max, units, version, importance, 0, "");
    }

    static Datapoint dataPointFromParts(String value, String flag, String min, String max, String units, String version) {
        return Datapoint.dataPointFromParts(value, flag, min, max, units, version, 1, 0, "");
    }

    static Datapoint dataPointFromParts(String value, String flag, String min, String max, String units) {
        return Datapoint.dataPointFromParts(value, flag, min, max, units, "", 1, 0, "");
    }

    static Datapoint dataPointFromParts(String value, String flag, String min, String max) {
        return Datapoint.dataPointFromParts(value, flag, min, max, "none", "", 1, 0, "");
    }

    static Datapoint dataPointFromParts(String value, String flag, String min) {
        return Datapoint.dataPointFromParts(value, flag, min, "", "none", "", 1, 0, "");
    }

    static Datapoint dataPointFromParts(String value, String flag) {
        return Datapoint.dataPointFromParts(value, flag, "", "", "none", "", 1, 0, "");
    }

    static Datapoint dataPointFromParts(String value) {
        return Datapoint.dataPointFromParts(value, "1", "", "", "none", "", 1, 0, "");
    }

    static Datapoint dataPointFromParts(String value, String flag, String min, String max, String units, String version, int importance, int partOfSet, String brand) {
        Datapoint datapoint = null;
        datapoint = new Datapoint();
        datapoint.value = value;
        datapoint.min = min;
        datapoint.max = max;
        if (Functions.is_expression(flag)) {
            boolean tbool = Functions.eval(flag);
            flag = tbool ? "1" : "0";
        }
        datapoint.flag = flag;
        datapoint.units = units;
        datapoint.version = version;
        datapoint.importance = importance;
        boolean pos = Functions.to_boolean(String.valueOf(partOfSet));
        if (pos) {
            datapoint.partofset = 1;
        }
        if (!pos) {
            datapoint.partofset = 0;
        }
        datapoint.brand = new ArrayList();
        datapoint.brand.add(brand);
        return datapoint;
    }

    boolean match(LinkedHashMap<String, Object> criteriaHM, String need) {
        if (criteriaHM == null) {
            return false;
        }
        LinkedHashMap criteria = (LinkedHashMap)criteriaHM.clone();
        LinkedHashMap<String, Object> fields = Reflection.get_object_vars(this);
        boolean match = true;
        criteria.remove("partofset");
        if (!fields.containsKey(need) || Functions.isEmpty(fields.get(need))) {
            match = false;
        }
        String method = "";
        String value = "";
        LinkedHashMap tmpMap = criteria;
        if (match) {
            for (Map.Entry entry : tmpMap.entrySet()) {
                method = ((String)entry.getKey()).toString();
                value = entry.getValue().toString();
                if (!fields.containsKey(method) || Functions.isEqual(fields.get(method), value)) continue;
                match = false;
                break;
            }
        }
        if (Functions.to_boolean(String.valueOf(this.flag)) && Functions.isEmpty(this.version) && this.units.equals(Functions.gv(criteria, "units", "").toString()) && this.value.equals(Functions.gv(criteria, "value", ""))) {
            match = true;
        }
        return match;
    }

    boolean isIdentical(Datapoint newDatapoint) throws DetectRightException {
        if (newDatapoint == null) {
            return false;
        }
        boolean log = DetectRight.getLOG();
        if (log) {
            Functions.dr_echo("Checking values\n");
        }
        if (!Functions.isEqual(this.value, newDatapoint.value)) {
            return false;
        }
        if (log) {
            Functions.dr_echo("Checking max\n");
        }
        if (!Functions.isEqual(this.max, newDatapoint.max)) {
            return false;
        }
        if (log) {
            Functions.dr_echo("Checking min\n");
        }
        if (!Functions.isEqual(this.min, newDatapoint.min)) {
            return false;
        }
        if (log) {
            Functions.dr_echo("Checking units\n");
        }
        if (!Functions.isEqual(this.units, newDatapoint.units)) {
            return false;
        }
        if (log) {
            Functions.dr_echo("Checking flag\n");
        }
        if (!Functions.isEqual(this.flag, newDatapoint.flag)) {
            return false;
        }
        if (log) {
            Functions.dr_echo("Checking version\n");
        }
        return Functions.isEqual(this.version, newDatapoint.version);
    }

    void merge(Datapoint datapoint) {
        boolean better;
        if (datapoint == null) {
            return;
        }
        ArrayList<Object> version = new ArrayList();
        if (!Functions.isEmpty(this.version)) {
            version = Functions.explode(",", this.version);
        }
        boolean bl = better = datapoint.getImportance() > this.getImportance();
        if (Functions.isEmpty(this.max) && !Functions.isEmpty(datapoint.max)) {
            this.max = datapoint.max;
        }
        if (Functions.isEmpty(this.min) && !Functions.isEmpty(datapoint.min)) {
            this.min = datapoint.min;
        }
        if (Functions.isEmpty(this.version) && !Functions.isEmpty(datapoint.version) && !version.contains(datapoint.version)) {
            version.add(datapoint.version);
        }
        if (Functions.isEmpty(this.value) && !Functions.isEmpty(datapoint.value)) {
            this.value = datapoint.value;
        }
        if (!Functions.isEmpty(datapoint.version) && !version.contains(datapoint.version)) {
            version.add(datapoint.version);
        }
        this.brand.addAll(datapoint.brand);
        this.brand = Functions.array_unique(this.brand);
        if (better) {
            if (!Functions.isEmpty(datapoint.value)) {
                this.value = datapoint.value;
                this.importance = datapoint.importance;
                this.importanceOffset = datapoint.importanceOffset;
                if (!Functions.isEmpty(datapoint.flag)) {
                    this.flag = datapoint.flag;
                }
            }
            if (!Functions.isEmpty(datapoint.max)) {
                this.max = datapoint.max;
            }
            if (!Functions.isEmpty(datapoint.min)) {
                this.min = datapoint.min;
            }
        }
        this.version = Functions.implode(",", version);
    }

    void brand(String brand) {
        if (this.brand == null) {
            return;
        }
        if (brand == null) {
            return;
        }
        if (!this.brand.contains(brand)) {
            this.brand.add(brand);
        }
    }

    boolean isFlagOnly() {
        if (!Functions.isEmpty(this.value)) {
            return false;
        }
        if (!Functions.isEmpty(this.max)) {
            return false;
        }
        if (!Functions.isEmpty(this.min)) {
            return false;
        }
        if (!Functions.isEmpty(this.units)) {
            return false;
        }
        return Functions.isEmpty(this.version);
    }

    static LinkedHashMap<String, Datapoint> dealWithArgs(LinkedHashMap<String, Datapoint> datapointsIn, String key) throws DetectRightException {
        if (datapointsIn == null) {
            return null;
        }
        if (key == null) {
            key = "";
        }
        LinkedHashMap datapoints = (LinkedHashMap)datapointsIn.clone();
        LinkedHashMap<String, ArrayList> args = new LinkedHashMap<String, ArrayList>();
        ArrayList argArr = new ArrayList();
        LinkedHashMap tmpDPMap = datapoints;
        for (Map.Entry entry : tmpDPMap.entrySet()) {
            String hash = (String)entry.getKey();
            Datapoint datapoint = (Datapoint)entry.getValue();
            if (datapoint.arg <= 0) continue;
            String id = String.valueOf(datapoint.source) + "/" + datapoint.trust + "/" + datapoint.getImportance();
            if (datapoint.brand != null && datapoint.brand.size() > 0) {
                id = String.valueOf(datapoint.brand.get(0)) + "/" + id;
            }
            if (!args.containsKey(id)) {
                argArr = new ArrayList();
                args.put(id, argArr);
            }
            argArr = (ArrayList)args.get(id);
            argArr.add(hash);
        }
        LinkedHashMap<String, ArrayList> tmpMap = args;
        for (Map.Entry entry : tmpMap.entrySet()) {
            ArrayList hashArray = (ArrayList)entry.getValue();
            TreeMap<Integer, String> argMap = new TreeMap<Integer, String>();
            String firstArg = "";
            for (String hash : hashArray) {
                Datapoint dp = (Datapoint)datapoints.get(hash);
                int argInt = dp.arg;
                if (argInt == 1) {
                    firstArg = hash;
                    continue;
                }
                try {
                    argMap.put(argInt, dp.getProperty(key));
                    datapoints.remove(hash);
                }
                catch (Throwable e) {
                    System.exit(999);
                }
            }
            if (Functions.isEmpty(firstArg)) continue;
            argArr = new ArrayList();
            Datapoint dp = (Datapoint)datapoints.get(firstArg);
            if (dp == null) continue;
            try {
                String string = dp.getProperty(key);
                if (!Functions.isEmpty(string)) {
                    argArr.add(string);
                }
            }
            catch (Throwable throwable) {
                System.exit(999);
            }
            for (Map.Entry entry2 : argMap.entrySet()) {
                String value = (String)entry2.getValue();
                argArr.add(value);
            }
            String string = Functions.implode("x", argArr);
            Datapoint dpFirstArg = (Datapoint)datapoints.get(firstArg);
            dpFirstArg.setValue(key, string);
            dpFirstArg.arg = 0;
            String newHash = dpFirstArg.hash();
            datapoints.remove(firstArg);
            datapoints.put(newHash, dpFirstArg);
        }
        return datapoints;
    }

    static ArrayList<Datapoint> sortDatapoints(LinkedHashMap<String, Datapoint> datapoints, String key) throws DetectRightException {
        return Datapoint.sortDatapoints(datapoints, key, "version", false);
    }

    static ArrayList<Datapoint> sortDatapoints(LinkedHashMap<String, Datapoint> datapoints, String key, String sortKey) throws DetectRightException {
        return Datapoint.sortDatapoints(datapoints, key, sortKey, false);
    }

    static ArrayList<Datapoint> sortDatapoints(LinkedHashMap<String, Datapoint> datapointsIn, String key, String sortKey, boolean sortKeyDescending) throws DetectRightException {
        int importance;
        Datapoint datapoint;
        ArrayList<Datapoint> output = new ArrayList<Datapoint>();
        if (datapointsIn == null) {
            return output;
        }
        LinkedHashMap<String, Datapoint> datapoints = (LinkedHashMap<String, Datapoint>)datapointsIn.clone();
        if (!Datapoint.hasProperty(key)) {
            return output;
        }
        if (datapoints.size() == 0) {
            return output;
        }
        if (datapoints.size() == 1) {
            Datapoint tmpDP = Datapoint.array_shift(datapoints);
            output.add(tmpDP);
            return output;
        }
        if ((datapoints = Datapoint.dealWithArgs(datapoints, key)) == null) {
            return output;
        }
        LinkedHashMap<String, Datapoint> retArr = new LinkedHashMap<String, Datapoint>();
        ArrayList<String> done = new ArrayList<String>();
        LinkedHashMap<String, Integer> frequency = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Integer> importances = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Boolean> seenValues = new LinkedHashMap<String, Boolean>();
        LinkedHashMap dps = new LinkedHashMap();
        LinkedHashMap<String, Integer> scores = new LinkedHashMap<String, Integer>();
        String hash = "";
        String value = null;
        String doneKey = null;
        LinkedHashMap<String, Datapoint> tmpMap = datapoints;
        for (Map.Entry entry : tmpMap.entrySet()) {
            hash = (String)entry.getKey();
            datapoint = (Datapoint)entry.getValue();
            importances.put(hash, datapoint.getImportance());
        }
        Functions.arsort(importances);
        ArrayList<String> dpKeys = Functions.array_keys_string(importances);
        importances.clear();
        for (String dpKey : dpKeys) {
            datapoint = datapoints.get(dpKey);
            if (datapoint == null) continue;
            String source = datapoint.source;
            try {
                value = datapoint.getProperty(key);
            }
            catch (Throwable e) {
                System.exit(999);
            }
            if (value == null) continue;
            doneKey = Functions.md5(value);
            String seenValue = Functions.md5(String.valueOf(value) + "/" + source);
            if (!done.contains(doneKey)) {
                Datapoint newDP = new Datapoint();
                newDP.importance = importance = datapoint.getImportance();
                newDP.brand = datapoint.brand;
                newDP.setValue(key, value);
                retArr.put(doneKey, newDP);
                done.add(doneKey);
                frequency.put(doneKey, new Integer(1));
                importances.put(doneKey, new Integer(importance));
            } else if (!seenValues.containsKey(seenValue)) {
                Integer freq = (Integer)frequency.get(doneKey);
                freq = freq + 1;
                frequency.put(doneKey, freq);
            }
            seenValues.put(seenValue, new Boolean(true));
            if (!dps.containsKey(doneKey)) {
                dps.put(doneKey, new ArrayList());
            }
            ArrayList dpArray = (ArrayList)dps.get(doneKey);
            dpArray.add(datapoint);
        }
        if (retArr.size() == 1) {
            Datapoint tmpDP = (Datapoint)Functions.array_shift(retArr);
            output.add(tmpDP);
            return output;
        }
        for (String dk : done) {
            datapoint = (Datapoint)retArr.get(dk);
            if (datapoint == null) continue;
            importance = datapoint.getImportance();
            double importanceWeight = importance;
            importanceWeight = Math.exp(importanceWeight / 100.0);
            double dblFrequency = Functions.parseInt(frequency.get(dk).toString());
            dblFrequency = Math.exp(dblFrequency / 4.0);
            double score = (importanceWeight + dblFrequency) * 100.0;
            int scoreInt = (int)Math.floor(score + 0.5);
            scores.put(dk, scoreInt);
        }
        int max = 0;
        ArrayList<String> scoreHashes = Functions.array_keys(scores);
        for (String scoreHash : scoreHashes) {
            int score = (Integer)scores.get(scoreHash);
            if (score <= max) continue;
            max = score;
        }
        ArrayList<String> ties = new ArrayList<String>(2);
        for (String scoreHash : scoreHashes) {
            int score = (Integer)scores.get(scoreHash);
            if (score != max) continue;
            ties.add(scoreHash);
        }
        if (ties.size() > 1) {
            String maxHash = "";
            String maxValue = "";
            for (String tieHash : ties) {
                Datapoint tieDP = (Datapoint)retArr.get(tieHash);
                String tieValue = "";
                try {
                    tieValue = tieDP.getProperty(key);
                }
                catch (Exception e) {
                    continue;
                }
                if (!Functions.compares(tieValue, maxValue, ">")) continue;
                maxValue = tieValue;
                maxHash = tieHash;
            }
            Integer newScore = (Integer)scores.get(maxHash);
            if (newScore != null) {
                newScore = newScore + 1;
                scores.put(maxHash, newScore);
            }
        }
        Functions.arsort(scores);
        ArrayList<String> scoreKeys = Functions.array_keys_string(scores);
        for (String dpKey : scoreKeys) {
            ArrayList<Datapoint> dpsToPush = (ArrayList<Datapoint>)dps.get(dpKey);
            if (!Functions.isEmpty(sortKey) && dpsToPush.size() > 1) {
                dpsToPush = Datapoint.sortByField(dpsToPush, sortKey, sortKeyDescending);
            }
            for (Datapoint tmpDP2 : dpsToPush) {
                output.add(tmpDP2);
            }
        }
        return output;
    }

    static ArrayList<Datapoint> sortByField(ArrayList<Datapoint> datapoints, String field) throws DetectRightException {
        return Datapoint.sortByField(datapoints, field, false);
    }

    static ArrayList<Datapoint> sortByField(ArrayList<Datapoint> datapoints, String field, boolean descending) throws DetectRightException {
        if (datapoints == null) {
            return null;
        }
        if (field == null) {
            return datapoints;
        }
        if (!Datapoint.hasProperty(field)) {
            return datapoints;
        }
        ArrayList<Datapoint> output = new ArrayList<Datapoint>();
        LinkedHashMap<Integer, String> array = new LinkedHashMap<Integer, String>();
        int i = 0;
        while (i < datapoints.size()) {
            Datapoint datapoint = datapoints.get(i);
            try {
                array.put(i, datapoint.getProperty(field));
            }
            catch (Exception e) {
                throw new DetectRightException("sortByFieldError", e);
            }
            ++i;
        }
        if (descending) {
            Functions.arsort(array);
        } else {
            Functions.asort(array);
        }
        ArrayList<?> keys = Functions.array_keys(array);
        for (Object key : keys) {
            output.add(datapoints.get((Integer)key));
        }
        return output;
    }

    static Datapoint array_shift(LinkedHashMap<String, Datapoint> hm) {
        if (hm == null) {
            return null;
        }
        LinkedHashMap<String, Datapoint> tmpMap = hm;
        Datapoint value = null;
        Iterator iterator = tmpMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            value = (Datapoint)entry.getValue();
            hm.remove(key);
        }
        return value;
    }

    String toXMLFragment() {
        return "";
    }

    public void __wakeup() {
    }
}

