/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Cache;
import com.detectright.core.ConnectionLostException;
import com.detectright.core.DBLink;
import com.detectright.core.DRLRUMap;
import com.detectright.core.DetectRightException;
import com.detectright.core.DeviceNotFoundException;
import com.detectright.core.EntityAliasCore;
import com.detectright.core.EntityCore;
import com.detectright.core.EntityPackage;
import com.detectright.core.EntityProfileCore;
import com.detectright.core.EntitySig;
import com.detectright.core.EntitySigCollection;
import com.detectright.core.Functions;
import com.detectright.core.HTTPHeadersCore;
import com.detectright.core.PointerCore;
import com.detectright.core.QuantumDataTree;
import com.detectright.core.RecordSet;
import com.detectright.core.Reflection;
import com.detectright.core.SchemaPropertyCore;
import com.detectright.core.Sig;
import com.detectright.core.Validator;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectRight {
    static final String VERSION = "2.3.1";
    static final boolean catManagement = false;
    static volatile DRLRUMap uaCache = null;
    private static volatile Properties globals = new Properties();
    private static ThreadLocal properties = new ThreadLocal(){

        protected synchronized Object initialValue() {
            if (globals == null || globals.size() == 0) {
                try {
                    URL url = this.getClass().getResource("detectright.properties");
                    if (url == null) {
                        throw new DetectRightException("Missing property file", null);
                    }
                    globals.load(url.openStream());
                }
                catch (Exception e) {
                    try {
                        throw new DetectRightException("Missing property file", null);
                    }
                    catch (DetectRightException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            LinkedHashMap<Object, Object> properties = new LinkedHashMap<Object, Object>();
            properties.putAll(globals);
            return properties;
        }
    };
    static volatile ArrayList<String> classes = new ArrayList();

    public static void main(String[] args) {
    }

    static void initCheckpoints() throws DetectRightException {
        DetectRight.setProperty("checkPoints", new ArrayList());
    }

    public static List<String> testDB() throws DetectRightException, ConnectionLostException {
        ArrayList<String> output = new ArrayList<String>();
        DBLink dbLink = DetectRight.getDBLink();
        if (dbLink == null) {
            throw new ConnectionLostException("Database is not initialized or is null");
        }
        ArrayList<String> tables = dbLink.getTables();
        for (String table : tables) {
            String testStr = "Table " + table;
            String query = "select count(*) as {IDD}cnt{IDD} from {IDD}" + table + "{IDD}";
            try {
                LinkedHashMap<String, Object> rs = dbLink.fillArrayFromSQL(query);
                if (rs == null || rs.size() == 0) {
                    testStr = String.valueOf(testStr) + " - No data could be read";
                }
                LinkedHashMap row = (LinkedHashMap)Functions.array_shift(rs);
                String cnt = row.get("cnt").toString();
                testStr = String.valueOf(testStr) + " has " + cnt + " rows";
            }
            catch (Exception e) {
                testStr = String.valueOf(testStr) + " couldn't read table";
            }
            output.add(testStr);
        }
        EntityCore entity = EntityCore.getEntityFromCatDesc("Apple", "iPhone");
        if (entity == null || entity.ID < 1L) {
            output.add("ERROR GETTING IPHONE");
        } else {
            output.add("Got iPhone successfully");
        }
        return output;
    }

    static Map<String, Object> getTestHeader(String url, int start) throws DetectRightException, ConnectionLostException {
        URL u = null;
        InputStream is = null;
        StringBuffer sb = new StringBuffer();
        try {
            try {
                String s;
                u = start > 0 ? new URL(String.valueOf(url) + "?start=" + String.valueOf(start)) : new URL(url);
                is = u.openStream();
                DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
                while ((s = dis.readLine()) != null) {
                    sb.append(String.valueOf(s) + "\n");
                }
            }
            catch (MalformedURLException mue) {
                throw new DetectRightException("Error reading url " + url, mue);
            }
            catch (IOException ioe) {
                throw new DetectRightException("Error reading url " + url, ioe);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        Object test = Functions.unserialize(sb.toString());
        if (test instanceof LinkedHashMap) {
            return (LinkedHashMap)test;
        }
        return new LinkedHashMap<String, Object>();
    }

    public static String getVersion() {
        return VERSION;
    }

    public static int getThread() {
        Thread me = Thread.currentThread();
        int hash = me.hashCode();
        return hash;
    }

    public static EntitySigCollection getLastDetection() throws ConnectionLostException, DetectRightException {
        Object obj = DetectRight.getProperty("lastDetection");
        if (obj == null) {
            throw new DetectRightException("No detection has been performed yet", null);
        }
        if (!(obj instanceof EntitySigCollection)) {
            throw new DetectRightException("Returned detection is an invalid object", null);
        }
        return (EntitySigCollection)obj;
    }

    static void removeLastDetection() throws ConnectionLostException, DetectRightException {
        EntitySigCollection ld = DetectRight.getLastDetection();
        if (ld != null) {
            ld.close();
        }
        DetectRight.removeProperty("lastDetection");
    }

    static void removeLastHeaders() throws DetectRightException {
        HTTPHeadersCore hd = DetectRight.getLastHeaders();
        if (hd != null) {
            hd.esc = null;
            hd = null;
        }
        DetectRight.removeProperty("lastHeaders");
    }

    private static void removeProperty(String property) {
        LinkedHashMap<String, Object> props = DetectRight.getProperties();
        if (props.containsKey(property)) {
            props.put("property", null);
        }
    }

    private static LinkedHashMap<String, Object> getProperties() {
        LinkedHashMap lhm = (LinkedHashMap)properties.get();
        return lhm;
    }

    static void setProperty(String property, Object object) throws DetectRightException {
        LinkedHashMap<String, Object> props = DetectRight.getProperties();
        if (props == null) {
            throw new DetectRightException("Thread property array is null!", null);
        }
        props.put(property, object);
    }

    private static Double getPropertyDouble(String property) throws DetectRightException {
        Double output;
        Object obj = DetectRight.getProperty(property);
        if (obj == null) {
            return null;
        }
        try {
            output = Double.parseDouble(obj.toString());
        }
        catch (Throwable e) {
            return null;
        }
        return output;
    }

    static Object getProperty(String property) throws DetectRightException {
        LinkedHashMap props = (LinkedHashMap)properties.get();
        if (props == null) {
            throw new DetectRightException("Appication Properties are null!", null);
        }
        if (!props.containsKey(property)) {
            return null;
        }
        Object obj = props.get(property);
        return obj;
    }

    static Integer getPropertyInt(String property) throws DetectRightException {
        Integer output;
        Object obj = DetectRight.getProperty(property);
        if (obj == null) {
            return null;
        }
        try {
            output = Functions.parseInt(obj.toString());
        }
        catch (Throwable e) {
            return null;
        }
        return output;
    }

    static Boolean getPropertyBool(String property) throws DetectRightException {
        Object obj = DetectRight.getProperty(property);
        if (obj == null) {
            return null;
        }
        return Functions.to_boolean(obj.toString());
    }

    public static DBLink getDBLink() throws ConnectionLostException, DetectRightException {
        Object obj = DetectRight.getProperty("dbLink");
        if (obj == null) {
            return null;
        }
        DBLink dbl = (DBLink)obj;
        if (dbl.db == null) {
            throw new ConnectionLostException("Connection has been lost");
        }
        DetectRight.checkPoint(String.valueOf(Thread.currentThread().getName()) + " got DB " + dbl.getConnectionInfo(), 0);
        return dbl;
    }

    static void setDBLink(DBLink db) throws DetectRightException {
        DBLink dbl;
        if (db == null) {
            return;
        }
        Connection ndb = db.getDBObject();
        if (ndb == null) {
            DetectRight.checkPoint("NDB Null!", 0);
        }
        if ((dbl = (DBLink)DetectRight.getProperty("dbLink")) != null && !dbl.hash.equals(db.hash) || dbl == null || !dbl.hash.equals(db.hash) || dbl.getDBObject() != null) {
            // empty if block
        }
        DetectRight.setProperty("dbLink", db);
    }

    static Cache getCacheLink() throws DetectRightException {
        Object obj = DetectRight.getProperty("cacheLink");
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Cache)) {
            return null;
        }
        return (Cache)obj;
    }

    static void setCacheLink(Cache cache) throws DetectRightException {
        Cache c = (Cache)DetectRight.getProperty("cacheLink");
        if (c != null && cache != c) {
            try {
                c.cache_close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        DetectRight.setProperty("cacheLink", cache);
    }

    static boolean getLOG() throws DetectRightException {
        Boolean bool = DetectRight.getPropertyBool("LOG");
        if (bool == null) {
            return false;
        }
        return bool;
    }

    static boolean getEnableUserAgentEntityType() throws DetectRightException {
        Boolean bool = DetectRight.getPropertyBool("enableUserAgentEntityType");
        if (bool == null) {
            return true;
        }
        return bool;
    }

    static void setEnableUserAgentEntityType(boolean bool) throws DetectRightException {
        DetectRight.setProperty("enableUserAgentEntityType", bool);
    }

    static boolean getSingleDataSource() throws DetectRightException {
        Boolean bool = DetectRight.getPropertyBool("singleDataSource");
        if (bool == null) {
            return true;
        }
        return bool;
    }

    static void setSingleDataSource(boolean bool) throws DetectRightException {
        DetectRight.setProperty("singleDataSource", bool);
    }

    public static void setReadersAsTablets(boolean status) throws DetectRightException {
        DetectRight.setProperty("readersAsTablets", status ? "true" : "false");
    }

    public static void setBooleansAsString(boolean status) throws DetectRightException {
        DetectRight.setProperty("booleansAsString", status ? "true" : "false");
    }

    public static void setThrowOutGenericDevices(boolean status) throws DetectRightException {
        DetectRight.setProperty("throwOutGenericDevices", status ? "true" : "false");
    }

    public static boolean getThrowOutGenericDevices() throws DetectRightException {
        Boolean bool = DetectRight.getPropertyBool("throwOutGenericDevicesSource");
        if (bool == null) {
            return true;
        }
        return bool;
    }

    public static List<Object> getCheckpoints() throws DetectRightException {
        ArrayList<Object> obj = DetectRight.getProperty("checkPoints");
        if (obj == null || !(obj instanceof ArrayList)) {
            obj = new ArrayList<Object>();
            DetectRight.setProperty("checkPoints", obj);
        }
        return obj;
    }

    static synchronized void initUACache() throws DetectRightException {
        if (uaCache == null) {
            int cacheSize = DetectRight.getUACacheSize();
            uaCache = new DRLRUMap(cacheSize);
        }
    }

    static boolean uaCacheStatus() throws DetectRightException {
        Boolean bool = DetectRight.getPropertyBool("uaCache");
        if (bool == null) {
            bool = true;
        }
        if (bool.booleanValue() && uaCache == null) {
            DetectRight.initUACache();
        }
        return bool;
    }

    public static void disableUACache() throws DetectRightException {
        DetectRight.setProperty("uaCache", "false");
    }

    public static void enableUACache() throws DetectRightException {
        DetectRight.setProperty("uaCache", "true");
    }

    public static void setUACacheSize(Integer numItems) throws DetectRightException {
        if (numItems == null || numItems < 1) {
            return;
        }
        DetectRight.setProperty("uaCacheSize", numItems);
    }

    static Integer getUACacheSize() throws DetectRightException {
        Integer ret = DetectRight.getPropertyInt("uaCacheSize");
        if (ret == null) {
            return 128;
        }
        return ret;
    }

    static synchronized void initCompositeQDTCache() throws DetectRightException {
        if (EntityCore.QDTs == null) {
            Integer cacheSize = DetectRight.getCompositeQDTCacheSize();
            if (cacheSize == null || cacheSize < 0) {
                cacheSize = 16;
            }
            EntityCore.QDTs = new DRLRUMap(cacheSize);
        }
    }

    static boolean compositeQDTCacheStatus() throws DetectRightException {
        Boolean bool = DetectRight.getPropertyBool("compositeQDTCache");
        if (bool == null) {
            bool = false;
        }
        if (bool.booleanValue() && EntityCore.QDTs == null) {
            DetectRight.initCompositeQDTCache();
        }
        return bool;
    }

    public static void enableCompositeQDTCache() throws DetectRightException {
        DetectRight.setProperty("compositeQDTCache", "true");
    }

    public static void disableCompositeQDTCache() throws DetectRightException {
        DetectRight.setProperty("compositeQDTCache", "false");
    }

    static Integer getCompositeQDTCacheSize() throws DetectRightException {
        Integer ret = DetectRight.getPropertyInt("compositeQDTCacheSize");
        if (ret == null) {
            return 128;
        }
        return ret;
    }

    public static void setCompositeQDTCacheSize(Integer numItems) throws DetectRightException {
        if (numItems == null || numItems < 0) {
            return;
        }
        DetectRight.setProperty("compositeQDTCacheSize", numItems);
    }

    static synchronized void initEPCache() throws DetectRightException {
        if (EntityProfileCore.QDTs == null) {
            Integer cacheSize = DetectRight.getEPCacheSize();
            if (cacheSize == null || cacheSize < 0) {
                cacheSize = 16;
            }
            EntityProfileCore.QDTs = new DRLRUMap(cacheSize);
        }
    }

    public static void enableEPCache() throws DetectRightException {
        DetectRight.setProperty("epCache", "true");
    }

    public static void disableEPCache() throws DetectRightException {
        DetectRight.setProperty("epCache", "false");
    }

    static boolean epCacheStatus() throws DetectRightException {
        Boolean bool = DetectRight.getPropertyBool("epCache");
        if (bool == null) {
            bool = false;
        }
        if (bool.booleanValue() && EntityProfileCore.QDTs == null) {
            DetectRight.initEPCache();
        }
        return bool;
    }

    static int getEPCacheSize() throws DetectRightException {
        Integer i = DetectRight.getPropertyInt("epCacheSize");
        if (i == null || i < 0) {
            return 128;
        }
        return i;
    }

    public static void setEPCacheSize(Integer numItems) throws DetectRightException {
        if (numItems != null && numItems > 0) {
            DetectRight.setProperty("epCacheSize", numItems);
        }
    }

    public static void setEPCacheThreshold(Integer bytesize) throws DetectRightException {
        if (bytesize != null && bytesize > -1) {
            DetectRight.setProperty("epCacheThreshold", bytesize);
        }
    }

    static Integer getEPCacheThreshold() throws DetectRightException {
        Integer ret = DetectRight.getPropertyInt("epCacheThreshold");
        if (ret == null || ret < -1) {
            ret = 9999999;
        }
        return ret;
    }

    static synchronized void initLargeEPCache() throws DetectRightException {
        if (EntityProfileCore.largeQDTs == null) {
            Integer cacheSize = DetectRight.getLargeEPCacheSize();
            if (cacheSize == null || cacheSize < 0) {
                cacheSize = 16;
            }
            EntityProfileCore.largeQDTs = new DRLRUMap(cacheSize);
        }
    }

    static boolean largeEPCacheStatus() throws DetectRightException {
        Boolean bool = DetectRight.getPropertyBool("largeEPCache");
        if (bool == null) {
            bool = true;
        }
        if (bool.booleanValue() && EntityProfileCore.largeQDTs == null) {
            DetectRight.initLargeEPCache();
        }
        return bool;
    }

    public static void enableLargeEPCache() throws DetectRightException {
        DetectRight.setProperty("largeEPCache", "true");
    }

    public static void disableLargeEPCache() throws DetectRightException {
        DetectRight.setProperty("largeEPCache", "false");
    }

    public static void setLargeEPCacheSize(Integer numItems) throws DetectRightException {
        if (numItems == null) {
            return;
        }
        if (numItems > 0) {
            DetectRight.setProperty("largeEPCacheSize", numItems);
        }
    }

    static int getLargeEPCacheSize() throws DetectRightException {
        Integer ret = DetectRight.getPropertyInt("largeEPCacheSize");
        if (ret == null || ret < 0) {
            ret = 128;
        }
        return ret;
    }

    static int getLargeEPCacheThreshold() throws DetectRightException {
        Integer ret = DetectRight.getPropertyInt("largeEPCacheThreshold");
        if (ret == null) {
            ret = 10000;
        }
        return ret;
    }

    public static void setLargeEPCacheThreshold(Integer bytesize) throws DetectRightException {
        if (bytesize > -1) {
            DetectRight.setProperty("largeEPCacheThreshold", bytesize);
        }
    }

    static Boolean getDiag() throws DetectRightException {
        return DetectRight.getPropertyBool("DIAG");
    }

    public static void setDiag(boolean status) throws DetectRightException {
        if (status) {
            DetectRight.setProperty("DIAG", "true");
        } else {
            DetectRight.setProperty("DIAG", "false");
        }
    }

    static Boolean getLogQueries() throws DetectRightException {
        return DetectRight.getPropertyBool("logQueries");
    }

    public static void enableQueryLogging() throws ConnectionLostException, DetectRightException {
        DetectRight.setProperty("logQueries", "true");
        DBLink dbLink = DetectRight.getDBLink();
        if (dbLink != null) {
            dbLink.logQueries = true;
        }
    }

    public static void disableQueryLogging() throws ConnectionLostException, DetectRightException {
        DetectRight.setProperty("logQueries", "false");
        DBLink dbLink = DetectRight.getDBLink();
        if (dbLink != null) {
            dbLink.logQueries = true;
        }
    }

    public static List<String> getQueryLog() throws ConnectionLostException, DetectRightException {
        DBLink dbl = DetectRight.getDBLink();
        if (dbl == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> ql = dbl.queryLog;
        if (ql == null) {
            return new ArrayList<String>();
        }
        return ql;
    }

    static void setStartTime() throws DetectRightException {
        double start = Functions.mt();
        DetectRight.setStartTime(start);
    }

    static void setStartTime(double start) throws DetectRightException {
        DetectRight.setProperty("startTime", start);
    }

    public static double getStartTime() throws DetectRightException {
        return DetectRight.getPropertyDouble("startTime");
    }

    static void setPrevTime(double prevtime) throws DetectRightException {
        DetectRight.setProperty("prevTime", prevtime);
    }

    public static void setMaxCheckPointLevel(int level) throws DetectRightException {
        if (level > 0) {
            DetectRight.setProperty("maxCheckpointLevel", level);
        }
    }

    public static synchronized boolean removeTemporaryOverride(String deviceId, String key) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        return DetectRight.addTemporaryOverride(deviceId, key, "");
    }

    public static synchronized boolean addTemporaryOverride(String deviceId, String key, String value) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Object> maxHM;
        if (Functions.isEmpty(deviceId)) {
            return false;
        }
        if (Functions.isEmpty(key)) {
            return false;
        }
        if (value == null) {
            return false;
        }
        DBLink db = DetectRight.getDBLink();
        if (db == null || !db.dbOK) {
            return false;
        }
        EntityCore entity = EntityCore.get(deviceId);
        if (entity == null || entity.id() == 0L) {
            throw new DeviceNotFoundException();
        }
        String mode = "add";
        if (Functions.isEmpty(value)) {
            mode = "remove";
        }
        LinkedHashMap<String, Object> wc = new LinkedHashMap<String, Object>();
        wc.put("entityid", entity.id());
        wc.put("key", key);
        ArrayList<String> result = db.getIDs("entity_overrides", "ID", wc);
        long ID = -1L;
        if (!Functions.isEmpty(result)) {
            try {
                ID = Long.parseLong(Functions.array_shift(result).toString());
            }
            catch (Throwable e) {
                db.close();
                return false;
            }
            if (ID > 0L) {
                boolean success = !mode.equals("remove") ? db.updateData("entity_overrides", DBLink.whereClause("value", value), wc) : db.deleteData("entity_overrides", wc);
                return success;
            }
        }
        if (Functions.isEmpty(value)) {
            return false;
        }
        ID = 1L;
        try {
            maxHM = db.fillArrayFromSQL("select max({idd}ID{idd}) as {idd}maxid{idd} from {idd}entity_overrides{idd}");
        }
        catch (Throwable e) {
            return false;
        }
        if (!Functions.isEmpty(maxHM)) {
            Object tmp = Functions.array_shift(maxHM);
            LinkedHashMap row = null;
            if (tmp instanceof LinkedHashMap) {
                row = (LinkedHashMap)tmp;
            }
            if (row != null) {
                try {
                    Object obj = Functions.gv(row, "maxid");
                    ID = Long.parseLong(obj.toString()) + 1L;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("ID", ID);
        data.put("entityid", entity.id());
        data.put("entityhash", entity.hash());
        data.put("key", key);
        data.put("value", value);
        data.put("ts", db.ts2Date(Functions.time()));
        long insID = db.insertData("entity_overrides", data, ID);
        return insID > 0L;
    }

    static boolean getRedetect() throws DetectRightException {
        return DetectRight.getPropertyBool("redetect");
    }

    public static void setRedetect(boolean status) throws DetectRightException {
        if (status) {
            DetectRight.setProperty("redetect", "true");
        } else {
            DetectRight.setProperty("redetect", "false");
        }
    }

    static boolean getOverrideHighlight() throws DetectRightException {
        return DetectRight.getPropertyBool("overrideHighlight");
    }

    public static void setOverrideHighlight(boolean value) throws DetectRightException {
        if (value) {
            DetectRight.setProperty("overrideHighlight", "true");
        } else {
            DetectRight.setProperty("overrideHighlight", "false");
        }
    }

    static boolean getFlush() throws DetectRightException {
        return DetectRight.getPropertyBool("flush");
    }

    public static void setFlush(boolean status) throws DetectRightException {
        if (status) {
            DetectRight.setProperty("flush", "true");
        } else {
            DetectRight.setProperty("flush", "false");
        }
    }

    public static void userAgentsAsBrowsers(boolean uab) throws DetectRightException {
        if (uab) {
            DetectRight.setProperty("userAgentsAsBrowsers", "true");
        } else {
            DetectRight.setProperty("userAgentsAsBrowsers", "false");
        }
    }

    static String deviceNotFoundBehavior() throws DetectRightException {
        Object ret = DetectRight.getProperty("deviceNotFoundBehavior");
        if (ret == null) {
            ret = new String("Adaptation");
        }
        return ret.toString();
    }

    public static void generateExceptionOnDeviceNotFound() throws DetectRightException {
        DetectRight.setProperty("deviceNotFoundBehavior", "Exception");
    }

    public static void adaptiveProfileOnDeviceNotFound() throws DetectRightException {
        DetectRight.setProperty("deviceNotFoundBehavior", "Adaptation");
    }

    static void setAccessLevel(int level) throws DetectRightException {
        if (level < -1) {
            return;
        }
        DetectRight.setProperty("accessLevel", level);
    }

    static int getAccessLevel() throws DetectRightException {
        Integer level = DetectRight.getPropertyInt("accessLevel");
        if (level == null) {
            return 1;
        }
        return level;
    }

    static void setDataOwner(String owner) throws DetectRightException {
        if (!Functions.isEmpty(owner)) {
            DetectRight.setProperty("data_owner", owner);
        } else {
            DetectRight.setProperty("data_owner", "");
        }
    }

    static String getDataOwner() throws DetectRightException {
        String owner = (String)DetectRight.getProperty("data_owner");
        if (Functions.isEmpty(owner)) {
            return "SYSTEM";
        }
        return owner;
    }

    static void setDataMode(String mode) throws DetectRightException {
        DetectRight.setProperty("data_mode", mode);
    }

    static String getDataMode() throws DetectRightException {
        String mode = (String)DetectRight.getProperty("data_mode");
        if (Functions.isEmpty(mode)) {
            return "SystemUser";
        }
        return mode;
    }

    static void setSchema(String schema) throws DetectRightException {
        DetectRight.setProperty("schema", schema);
    }

    static String getSchema() throws DetectRightException {
        return (String)DetectRight.getProperty("schema");
    }

    static void setError(String error) throws DetectRightException {
        if (error == null) {
            error = "";
        }
        DetectRight.setProperty("error", error);
    }

    static String getError() throws DetectRightException {
        return (String)DetectRight.getProperty("error");
    }

    static String getLogMethod() throws DetectRightException {
        return (String)DetectRight.getProperty("LOG_METHOD");
    }

    static void addDataEngine(String classname, String connectString, boolean queryCacheing) throws DetectRightException, ConnectionLostException {
        Class<?> c = null;
        try {
            c = Class.forName(Reflection.cn(classname));
        }
        catch (Exception e) {
            throw new DetectRightException("Class " + classname + " doesn't exist", e);
        }
        if (c == null) {
            throw new DetectRightException("Problem loading " + classname, null);
        }
        boolean success = Reflection.setThreadedLocal(classname, "dbLink", null);
        if (!success) {
            throw new DetectRightException("Data engine added to class without DBLink field", null);
        }
        DBLink dbLink = DBLink.getConnection(connectString);
        dbLink.useCache = queryCacheing;
        Reflection.setThreadedLocal(classname, "dbLink", dbLink);
    }

    public static void initialize() throws IOException, DetectRightException, ConnectionLostException {
        DetectRight.initialize("");
    }

    public static void initialize(String defaultDBLink) throws DetectRightException, ConnectionLostException {
        Map props = (Map)properties.get();
        if (props == null) {
            throw new DetectRightException("Cannot find detectright properties", null);
        }
        ArrayList<String> keys = Functions.array_keys_string(props);
        for (String key : keys) {
            String classname;
            ArrayList<String> tmp;
            if (key == null) continue;
            if (key.contains(".dbLink")) {
                tmp = Functions.explode(".dbLink", key);
                classname = tmp.get(0);
                String dbLinkString = (String)props.get(key);
                DBLink.assign(classname, dbLinkString);
                continue;
            }
            if (key.contains(".cacheLink")) {
                tmp = Functions.explode(".", key);
                classname = tmp.get(0);
                String cacheLinkString = (String)props.get(key);
                Cache.assign(classname, cacheLinkString);
                continue;
            }
            if (!key.contains(".")) continue;
            tmp = Functions.explode(".", key);
            classname = tmp.get(0);
            String field = tmp.get(1);
            Reflection.setStaticValue(classname, field, props.get(key));
            props.remove(key);
        }
        if (!Functions.isEmpty(defaultDBLink)) {
            DBLink.assign("DetectRight", defaultDBLink);
        }
        DetectRight.setStartTime(Functions.mt());
        DetectRight.setProperty("user", null);
        DetectRight.setProperty("access_level", 1);
        DetectRight.setProperty("username", "Anonymous");
        Cache.init();
        DBLink.init();
        DBLink dbLink = DetectRight.getDBLink();
        if (dbLink == null) {
            DetectRight.checkPoint("Database null", 0);
            throw new ConnectionLostException("Database null");
        }
        if (!dbLink.dbOK) {
            DetectRight.checkPoint("Database not OK", 0);
            throw new ConnectionLostException("Database not OK");
        }
        String classname = dbLink.getClass().getName();
        if (classname.equals("DBLink")) {
            DetectRight.checkPoint("Bad database error, got " + classname, 0);
            throw new ConnectionLostException("Bad database error, got DBLink ");
        }
    }

    public static void setStrictExportNames(boolean status) throws DetectRightException {
        if (status) {
            DetectRight.setProperty("strictExportNames", "true");
        } else {
            DetectRight.setProperty("strictExportNames", "false");
        }
    }

    static boolean getStrictExportNames() throws DetectRightException {
        return DetectRight.getPropertyBool("strictExportNames");
    }

    public static boolean detect(Map<?, ?> headers) throws IllegalAccessException, DeviceNotFoundException, DetectRightException, ConnectionLostException {
        if (headers == null) {
            return false;
        }
        LinkedHashMap lhm = (LinkedHashMap)headers;
        HTTPHeadersCore httpHeaders = new HTTPHeadersCore(lhm);
        return DetectRight.detect(httpHeaders);
    }

    public static boolean detect(HTTPHeadersCore httpHeaders) throws IllegalAccessException, DeviceNotFoundException, DetectRightException, ConnectionLostException {
        if (httpHeaders == null) {
            return false;
        }
        httpHeaders.process();
        DetectRight.setLastHeaders(httpHeaders);
        return DetectRight.processDetection(httpHeaders.getESC());
    }

    static void setLastHeaders(HTTPHeadersCore headers) throws DetectRightException {
        if (headers == null) {
            return;
        }
        DetectRight.setProperty("lastHeaders", headers);
    }

    public static HTTPHeadersCore getLastHeaders() throws DetectRightException {
        Object obj = DetectRight.getProperty("lastHeaders");
        if (obj == null) {
            throw new DetectRightException("No detection involving headers has been run", null);
        }
        if (!(obj instanceof HTTPHeadersCore)) {
            throw new DetectRightException("Last Headers were faulty", null);
        }
        return (HTTPHeadersCore)obj;
    }

    public static boolean processDetection(EntitySigCollection esc) throws DetectRightException, ConnectionLostException {
        if (esc == null) {
            return false;
        }
        esc.filter();
        esc.addEntityContains();
        DetectRight.checkPoint("Getting QDT");
        esc.getQDT();
        DetectRight.checkPoint("Got QDT");
        if (esc.qdt != null) {
            esc.qdt.processPackages();
        }
        esc.resetRootEntity();
        DetectRight.setProperty("lastDetection", esc);
        return true;
    }

    private static boolean catManagementAllowed() {
        return false;
    }

    public static Map<String, String> getCatalog(String manufacturer) throws DetectRightException, ConnectionLostException {
        if (!DetectRight.catManagementAllowed()) {
            throw new DetectRightException("Catalogue management not enabled in this build", null);
        }
        if (Functions.isEmpty(manufacturer)) {
            throw new DetectRightException("Empty manufacturer.", null);
        }
        LinkedHashMap<String, String> lhm = EntityCore.getDescriptions(manufacturer);
        return lhm;
    }

    public static Object getDatapoint(String fieldname) throws DetectRightException, ConnectionLostException {
        return DetectRight.getDatapoint(fieldname, "");
    }

    public static Object getDatapoint(String fieldname, String schema) throws DetectRightException, ConnectionLostException {
        if (schema == null) {
            schema = "";
        }
        if (Functions.isEmpty(fieldname)) {
            throw new DetectRightException("Empty fieldname", null);
        }
        EntitySigCollection lastDetection = DetectRight.getLastDetection();
        if (lastDetection == null) {
            throw new DetectRightException("No detection performed yet", null);
        }
        if (lastDetection.qdt == null) {
            throw new DetectRightException("Last detection contained invalid QDT Object", null);
        }
        SchemaPropertyCore sp = SchemaPropertyCore.getSchemaProperty(schema, fieldname);
        if (sp == null) {
            throw new DetectRightException("Invalid schema or fieldname", null);
        }
        Object valueObj = SchemaPropertyCore.getObjectValue(lastDetection.qdt, sp);
        return valueObj;
    }

    public static Map<String, Object> getProfile() throws DetectRightException, ConnectionLostException {
        return DetectRight.getProfile("");
    }

    public static Map<String, Object> getProfile(String schema) throws DetectRightException, ConnectionLostException {
        EntitySigCollection lastDetection;
        if (schema == null) {
            schema = "";
        }
        if ((lastDetection = DetectRight.getLastDetection()) == null) {
            throw new DetectRightException("No valid detection has been done", null);
        }
        LinkedHashMap<String, Object> profile = lastDetection.getExportProfile(schema);
        if (profile == null) {
            profile = new LinkedHashMap();
        }
        if (!Functions.isEmpty(schema)) {
            profile.put("schema", schema);
        }
        DetectRight.postProcess(profile);
        return profile;
    }

    static void postProcess(LinkedHashMap<String, Object> profile) throws ConnectionLostException, DetectRightException {
        String diagScreenSize;
        String browserName;
        String prefMarkup;
        if (profile == null) {
            return;
        }
        if (!DetectRight.getPropertyBool("doPostProcessing").booleanValue()) {
            return;
        }
        HTTPHeadersCore headers = null;
        try {
            headers = DetectRight.getLastHeaders();
        }
        catch (DetectRightException detectRightException) {
            // empty catch block
        }
        if (profile.containsKey("preferred_markup")) {
            prefMarkup = (String)profile.get("preferred_markup");
            if (prefMarkup.equals("html_web_4_0")) {
                if (!Functions.gvString(profile, "device_claims_web_support", "").equals("true")) {
                    profile.put("preferred_markup", "html_wi_oma_xhtmlmp_1_0");
                }
            } else if (prefMarkup.equals("html_web_5_0")) {
                browserName = Functions.gvString(profile, "mobile_browser");
                if (browserName.equals("NetFront") && Functions.gvString(profile, "mobile_browser_version").startsWith("3")) {
                    profile.put("preferred_markup", "html_wi_oma_xhtmlmp_1_0");
                }
            } else if (Functions.stripos(prefMarkup, "xhtml") > -1 && profile.get("type").equals("Desktop")) {
                profile.put("preferred_markup", "html_web_4_0");
            }
        }
        if (profile.containsKey("markup.preferred")) {
            prefMarkup = (String)profile.get("markup.preferred");
            if (prefMarkup.equals("HTML 4.0")) {
                if (!Functions.gvString(profile, "markup.webcapable", "").equals("true")) {
                    profile.put("markup.preferred", "XHTML Mobile Profile 1.0");
                }
            } else if (prefMarkup.equals("HTML 5.0")) {
                browserName = Functions.gvString(profile, "browsername", "");
                if (browserName.equals("NetFront") && Functions.gvString(profile, "browserversion", "").startsWith("3")) {
                    profile.put("markup.preferred", "XHTML Mobile Profile 1.1");
                }
            } else if (Functions.stripos(prefMarkup, "xhtml") > -1 && profile.get("type").equals("Desktop")) {
                profile.put("markup.preferred", "HTML 4.0");
            }
        }
        if (profile.containsKey("preferredmarkup")) {
            prefMarkup = (String)profile.get("preferredmarkup");
            if (prefMarkup.equals("HTML 4.0") || prefMarkup.equals("HTML")) {
                if (!Functions.gvString(profile, "isweb", "").equals("true")) {
                    profile.put("preferredmarkup", "XHTML Mobile Profile 1.0");
                }
            } else if (prefMarkup.equals("HTML 5.0")) {
                browserName = Functions.gvString(profile, "browsername", "");
                if (browserName.equals("NetFront") && Functions.gvString(profile, "browserversion", "").startsWith("3")) {
                    profile.put("preferredcorner", "XHTML Mobile Profile 1.1");
                }
            } else if (Functions.stripos(prefMarkup, "xhtml") > -1 && profile.get("type").equals("Desktop")) {
                profile.put("preferredmarkup", "HTML 4.0");
            }
        }
        EntitySigCollection esc = DetectRight.getLastDetection();
        EntityCore nom = esc.getNominativeEntity();
        Boolean readersAsTablets = DetectRight.getPropertyBool("readersAsTablets");
        if (readersAsTablets == null) {
            readersAsTablets = false;
        }
        if (readersAsTablets.booleanValue() && nom != null && (nom.entitytype.equals("e-Reader") || nom.entitytype.equals("Reader"))) {
            if (profile.containsKey("model_name")) {
                profile.put("is_tablet", "true");
            } else {
                profile.put("istablet", "true");
            }
        }
        String entitytype = "";
        if (nom != null) {
            entitytype = nom.entitytype;
        }
        DetectRight.checkScreensizes(profile, entitytype);
        if (profile.containsKey("screendiagonalin") && !Functions.isEmpty(diagScreenSize = (String)profile.get("screendiagonalin")) && Functions.is_numeric(diagScreenSize)) {
            try {
                double ddiagScreenSize = Double.parseDouble(diagScreenSize);
                if (ddiagScreenSize >= 7.0) {
                    profile.put("istablet", "true");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    static void checkScreensizes(LinkedHashMap<String, Object> profile, String entitytype) throws DetectRightException {
        LinkedHashMap<String, ArrayList<String>> modes = new LinkedHashMap<String, ArrayList<String>>();
        modes.put("resolution_width", new ArrayList<String>(Arrays.asList("resolution_width", "resolution_height", "max_image_width", "max_image_height")));
        modes.put("screenx", new ArrayList<String>(Arrays.asList("screenx", "screeny", "contentx", "contenty")));
        modes.put("displayWidth", new ArrayList<String>(Arrays.asList("displayWidth", "displayHeight", "usableDisplayWidth", "usableDisplayHeight")));
        modes.put("displaywidth", new ArrayList<String>(Arrays.asList("displaywidth", "displayheight", "usabledisplaywidth", "usabledisplayheight")));
        LinkedHashMap<String, ArrayList> activeModes = new LinkedHashMap<String, ArrayList>();
        for (Map.Entry modeEntry : modes.entrySet()) {
            ArrayList array = (ArrayList)modeEntry.getValue();
            String mode = (String)modeEntry.getKey();
            if (!profile.containsKey(mode)) continue;
            activeModes.put(mode, array);
        }
        for (Map.Entry modeEntry : activeModes.entrySet()) {
            int yc;
            int xc;
            int y;
            int x;
            String ycStr;
            String xcStr;
            String yStr;
            ArrayList fields = (ArrayList)modeEntry.getValue();
            String xField = (String)fields.get(0);
            String yField = (String)fields.get(1);
            String xcField = (String)fields.get(2);
            String ycField = (String)fields.get(3);
            String xStr = Functions.gvString(profile, xField, "-1");
            if (Functions.isEmpty(xStr)) {
                xStr = "-1";
            }
            if (Functions.isEmpty(yStr = Functions.gvString(profile, yField, "-1"))) {
                yStr = "-1";
            }
            if (Functions.isEmpty(xcStr = Functions.gvString(profile, xcField, "-1"))) {
                xcStr = "-1";
            }
            if (Functions.isEmpty(ycStr = Functions.gvString(profile, ycField, "-1"))) {
                ycStr = "-1";
            }
            try {
                x = Functions.parseInt(xStr);
                y = Functions.parseInt(yStr);
                xc = Functions.parseInt(xcStr);
                yc = Functions.parseInt(ycStr);
            }
            catch (Exception e) {
                continue;
            }
            boolean hasx = x > 0;
            boolean hasy = y > 0;
            boolean hasxc = xc > 0;
            boolean hasyc = yc > 0;
            int tmp = 0;
            if (DetectRight.getForcePortraitTablets() && entitytype.equals("Tablet") && hasx && hasy && x > y) {
                tmp = y;
                y = x;
                x = tmp;
                profile.put(xField, String.valueOf(x));
                profile.put(yField, String.valueOf(y));
            }
            if (!hasxc || !hasyc || (x <= y || xc >= yc) && (y <= x || xc <= yc)) continue;
            tmp = yc;
            yc = xc;
            xc = tmp;
            profile.put(xcField, String.valueOf(xc));
            profile.put(ycField, String.valueOf(yc));
        }
    }

    static boolean getForcePortraitTablets() throws DetectRightException {
        boolean fpt = DetectRight.getPropertyBool("forcePortraitTablets");
        return fpt;
    }

    static void setForcePortraitTablets(boolean status) throws DetectRightException {
        DetectRight.setProperty("forcePortraitTablets", status);
    }

    public static Map<String, Object> getProfileFromHeaders(Map<?, ?> lhm) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        return DetectRight.getProfileFromHeaders(lhm, "");
    }

    public static Map<String, Object> getProfileFromHeaders(Map<?, ?> lhm, String schema) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        if (schema == null) {
            schema = "";
        }
        if (lhm == null) {
            throw new DetectRightException("Null headers passed in", null);
        }
        try {
            if (!DetectRight.detect(lhm)) {
                return new LinkedHashMap<String, Object>();
            }
        }
        catch (IllegalAccessException e) {
            throw new DetectRightException("Illegal access exception. This shouldn't happen.", null);
        }
        return DetectRight.getProfile(schema);
    }

    public static Map<String, Object> getProfileFromPhoneID(String id) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        return DetectRight.getProfileFromPhoneID(id, "");
    }

    public static Map<String, Object> getProfileFromPhoneID(String id, String schema) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        if (schema == null) {
            schema = "";
        }
        if (Functions.isEmpty(id)) {
            throw new DetectRightException("Empty ID!", null);
        }
        EntitySigCollection phoneIDESC = PointerCore.getESC("PhoneID", id);
        if (phoneIDESC == null || phoneIDESC.entities == null || phoneIDESC.entities.size() == 0) {
            throw new DeviceNotFoundException("Phone ID " + id + " Not Found");
        }
        DetectRight.processDetection(phoneIDESC);
        return DetectRight.getProfile(schema);
    }

    public static Map<String, Object> getProfileFromUAProfile(String uap) throws DetectRightException, ConnectionLostException, DeviceNotFoundException {
        return DetectRight.getProfileFromUAProfile(uap, "");
    }

    public static Map<String, Object> getProfileFromUAProfile(String uap, String schema) throws DetectRightException, ConnectionLostException, DeviceNotFoundException {
        if (schema == null) {
            schema = "";
        }
        if (Functions.isEmpty(uap)) {
            throw new DetectRightException("Empty URL!", null);
        }
        String url = "";
        try {
            url = Functions.cleanURL(uap);
        }
        catch (Exception e) {
            throw new DetectRightException("Invalidly formatted URL", e);
        }
        EntitySigCollection uapESC = PointerCore.getESC("UAP", url);
        if (uapESC == null || uapESC.entities == null || uapESC.entities.size() == 0) {
            throw new DeviceNotFoundException("UAProfile link " + uap + " Not Found");
        }
        DetectRight.processDetection(uapESC);
        return DetectRight.getProfile(schema);
    }

    public static Map<String, Object> getProfileFromUA(String useragent) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        return DetectRight.getProfileFromUA(useragent, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getProfileFromUA(String useragent, String schema) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        Object profileObj;
        LinkedHashMap profile = null;
        if (schema == null) {
            schema = "";
        }
        if (Functions.isEmpty(useragent)) {
            throw new DetectRightException("Useragent is missing", null);
        }
        String key = "";
        String profileStr = "";
        LinkedHashMap<String, Object> lhm = DBLink.whereClause("HTTP_USER_AGENT", useragent);
        HTTPHeadersCore headers = new HTTPHeadersCore(lhm);
        if (DetectRight.uaCacheStatus() && !Functions.isEmpty(profileStr = (String)uaCache.get(key = PointerCore.makeHash(String.valueOf(headers.ua) + "/" + schema))) && (profileObj = Functions.ungz(profileStr)) != null && profileObj instanceof LinkedHashMap) {
            return (LinkedHashMap)profileObj;
        }
        try {
            if (!DetectRight.detect(headers)) {
                return new LinkedHashMap<String, Object>();
            }
            profile = (LinkedHashMap)DetectRight.getProfile(schema);
        }
        catch (IllegalAccessException e) {
            return new LinkedHashMap<String, Object>();
        }
        catch (DeviceNotFoundException dnfe) {
            throw dnfe;
        }
        catch (DetectRightException de) {
            throw de;
        }
        catch (ConnectionLostException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new DetectRightException(e.getMessage(), e);
        }
        if (profile == null) {
            throw new DetectRightException("Detection did not generate profile", null);
        }
        if (DetectRight.uaCacheStatus()) {
            profileStr = Functions.gz(profile);
            if (!Functions.isEmpty(profile)) {
                DRLRUMap dRLRUMap = uaCache;
                synchronized (dRLRUMap) {
                    if (!uaCache.containsKey(key)) {
                        uaCache.put(key, profileStr);
                    }
                }
            }
        }
        return profile;
    }

    public static Map<String, Object> getProfileFromTAC(String tac) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        return DetectRight.getProfileFromTAC(tac, "");
    }

    public static Map<String, Object> getProfileFromTAC(String tac, String schema) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(tac)) {
            throw new DetectRightException("TAC is empty", null);
        }
        if (schema == null) {
            schema = "";
        }
        if (tac.length() > 8) {
            tac = Functions.substr(tac, 0, 8);
        }
        if (tac.length() < 7) {
            throw new DetectRightException("Invalid TAC, less than 7 characters", null);
        }
        EntitySigCollection tacESC = null;
        tacESC = PointerCore.getESC("TAC", tac);
        if (tacESC == null || tacESC.entities == null || tacESC.entities.size() == 0) {
            throw new DeviceNotFoundException();
        }
        DetectRight.processDetection(tacESC);
        return DetectRight.getProfile(schema);
    }

    public static Map<String, Object> getProfileFromDeviceID(long id) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        return DetectRight.getProfileFromDeviceID(id, "");
    }

    public static Map<String, Object> getProfileFromDeviceID(long id, String schema) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        if (schema == null) {
            schema = "";
        }
        LinkedHashMap<String, Object> dummy = new LinkedHashMap<String, Object>();
        try {
            if (!DetectRight.detectDevice(id)) {
                return dummy;
            }
        }
        catch (DeviceNotFoundException dnfe) {
            throw dnfe;
        }
        catch (ConnectionLostException ce) {
            throw ce;
        }
        catch (DetectRightException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DetectRightException("Detection error", e);
        }
        return DetectRight.getProfile(schema);
    }

    public static Map<String, Object> getProfileFromDeviceID(String hash) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        return DetectRight.getProfileFromDeviceID(hash, "");
    }

    public static Map<String, Object> getProfileFromDeviceID(String hash, String schema) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        if (schema == null) {
            schema = "";
        }
        if (Functions.isEmpty(hash)) {
            throw new DetectRightException("Empty device id", null);
        }
        LinkedHashMap<String, Object> dummy = new LinkedHashMap<String, Object>();
        try {
            if (!DetectRight.detectDevice(hash)) {
                return dummy;
            }
        }
        catch (DeviceNotFoundException dnfe) {
            throw dnfe;
        }
        catch (ConnectionLostException ce) {
            throw ce;
        }
        catch (DetectRightException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DetectRightException("Detection error", e);
        }
        LinkedHashMap profile = (LinkedHashMap)DetectRight.getProfile(schema);
        if (profile == null) {
            return dummy;
        }
        EntityCore e = EntityCore.get(hash);
        if (e == null) {
            return profile;
        }
        profile.put("deviceid", e.hash);
        profile.put("devicedescriptor", e.descriptor());
        return profile;
    }

    public static Map<?, ?> getProfileFromDevice(String entitytype, String category, String description) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        return DetectRight.getProfileFromDevice(entitytype, category, description, "");
    }

    public static Map<?, ?> getProfileFromDevice(String entitytype, String category, String description, String schema) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        if (schema == null) {
            schema = "";
        }
        if (Functions.isEmpty(entitytype) || Functions.isEmpty(category) || Functions.isEmpty(description)) {
            throw new DetectRightException("Entitytype, category, or description missing", null);
        }
        EntityCore entity = EntityCore.getEntityFromCatDesc(category, description, entitytype, false);
        if (entity == null || entity.id() == 0L) {
            throw new DeviceNotFoundException();
        }
        String hash = entity.hash;
        if (Functions.isEmpty(hash)) {
            throw new DeviceNotFoundException();
        }
        return DetectRight.getProfileFromDeviceID(hash, schema);
    }

    public static String getDetectedManufacturer() throws DetectRightException, ConnectionLostException {
        EntitySigCollection lastDetection = DetectRight.getLastDetection();
        if (lastDetection == null) {
            throw new DetectRightException("No previous detection done", null);
        }
        return lastDetection.getManufacturer();
    }

    public static String getDetectedModel() throws DetectRightException, ConnectionLostException {
        EntitySigCollection lastDetection = DetectRight.getLastDetection();
        if (lastDetection == null) {
            throw new DetectRightException("No previous detection done", null);
        }
        return lastDetection.getModel();
    }

    static void checkAccess() throws DetectRightException, ConnectionLostException {
        if (DetectRight.getAccessLevel() < 1) {
            throw new DetectRightException("Permission Access Error", null);
        }
    }

    static boolean classExists(String classname) {
        if (classname == null) {
            return false;
        }
        if (classes != null && classes.contains(classname)) {
            return true;
        }
        return Functions.class_exists(classname, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerClass(String classname) {
        if (classname == null) {
            return;
        }
        if (!classes.contains(classname)) {
            ArrayList<String> arrayList = classes;
            synchronized (arrayList) {
                if (!classes.contains(classname)) {
                    classes.add(classname);
                }
            }
        }
    }

    public static void checkPoint(String str) throws DetectRightException {
        if (Functions.isEmpty(str)) {
            return;
        }
        DetectRight.checkPoint(str, 0);
    }

    public static void checkPoint(String str, int level) throws DetectRightException {
        Double delta;
        if (Math.random() > 0.9) {
            DetectRight.getProperty("dbLink");
        }
        if (Functions.isEmpty(str)) {
            return;
        }
        if (level < 0) {
            return;
        }
        boolean diag = DetectRight.getPropertyBool("DIAG");
        if (!diag) {
            return;
        }
        ArrayList cp = (ArrayList)DetectRight.getProperty("checkPoints");
        if (cp == null) {
            cp = new ArrayList();
            DetectRight.setProperty("checkPoints", cp);
        }
        Double prevTime = DetectRight.getPropertyDouble("prevTime");
        Double startTime = DetectRight.getPropertyDouble("startTime");
        int maxCheckPointLevel = DetectRight.getPropertyInt("maxCheckPointLevel");
        LinkedHashMap<String, Object> checkPoint = new LinkedHashMap<String, Object>();
        if (level > 0 && maxCheckPointLevel > 0 && level > maxCheckPointLevel) {
            return;
        }
        Double thisTime = Functions.mt();
        if (prevTime == null) {
            DetectRight.setProperty("prevTime", startTime);
        }
        if ((delta = Double.valueOf(thisTime - DetectRight.getPropertyDouble("prevTime"))) > 0.0) {
            checkPoint.put("delta", delta);
            checkPoint.put("elapsed", thisTime - startTime);
            checkPoint.put("comment", str);
            cp.add(checkPoint);
            DetectRight.setProperty("prevTime", Functions.mt());
        } else {
            checkPoint.put("comment", str);
            cp.add(checkPoint);
        }
    }

    public static void printCheckpoints() throws DetectRightException {
        Object co = DetectRight.getProperty("checkPoints");
        if (co == null) {
            return;
        }
        if (!(co instanceof ArrayList)) {
            return;
        }
        ArrayList cp = (ArrayList)co;
        if (cp.size() == 0) {
            return;
        }
        for (Object array : cp) {
            if (!(array instanceof LinkedHashMap)) continue;
            LinkedHashMap hm = (LinkedHashMap)array;
            StringBuffer buf = new StringBuffer();
            buf.append(hm.get("elapsed").toString());
            buf.append(":");
            buf.append(hm.get("comment"));
            buf.append(" (");
            buf.append(hm.get("delta").toString());
            buf.append(")\n");
            Functions.dr_echo(buf.toString());
        }
    }

    static Map<String, Object> addOwner() throws DetectRightException {
        return DetectRight.addOwner(new LinkedHashMap<String, Object>());
    }

    static Map<String, Object> addOwner(Map<String, Object> array) throws DetectRightException {
        String owner;
        if (array == null) {
            array = new LinkedHashMap<String, Object>();
        }
        if (Functions.isEmpty(owner = DetectRight.getDataOwner())) {
            owner = "SYSTEM";
        }
        if (owner.equals("SYSTEM")) {
            array.put("owner", "SYSTEM");
            return array;
        }
        LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>();
        tmp.put("op", "in");
        ArrayList<String> owners = new ArrayList<String>();
        owners.addAll(Arrays.asList(owner, "SYSTEM"));
        tmp.put("value", owners);
        array.put("owner", tmp);
        return array;
    }

    public static void close() throws DetectRightException {
        DetectRight.setProperty("username", "Anonymous");
        DetectRight.setProperty("access_level", 1);
        DetectRight.clear();
    }

    public static void clear() {
        try {
            Object obj;
            HTTPHeadersCore lastHeaders;
            EntitySigCollection lastDetection = DetectRight.getLastDetection();
            if (lastDetection != null) {
                lastDetection.close();
                DetectRight.removeLastDetection();
            }
            if ((lastHeaders = DetectRight.getLastHeaders()) != null) {
                lastHeaders.esc = null;
                DetectRight.removeLastHeaders();
            }
            if ((obj = DetectRight.getProperty("checkPoints")) instanceof ArrayList) {
                ArrayList arr = (ArrayList)obj;
                arr.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static boolean canLearn() {
        return false;
    }

    static ArrayList<String> getClasses() {
        return classes;
    }

    static String cacheKey(String keyStr) {
        StringBuffer key = new StringBuffer();
        key.append("DRJAVA");
        key.append("/");
        key.append(keyStr);
        return key.toString();
    }

    static String escapeDescriptor(String string) {
        string = Functions.str_replace("//", "{df}", string);
        string = Functions.str_replace(":", "{colon}", string);
        string = Functions.str_replace("\\", "{backslash}", string);
        return string;
    }

    static String unescapeDescriptor(String string) {
        if (Functions.isEmpty(string)) {
            return string;
        }
        if (Functions.strpos(string, "{") == -1) {
            return string;
        }
        string = Functions.str_replace("{df}", "//", string);
        string = Functions.str_replace("{colon}", ":", string);
        string = Functions.str_replace("{backslash}", "\\", string);
        return string;
    }

    public static boolean detectDevice(long id) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        EntityCore entity = EntityCore.get(id);
        if (entity == null || entity.id() == 0L) {
            throw new DeviceNotFoundException();
        }
        return DetectRight.detectDevice(entity.hash);
    }

    public static boolean detectDevice(String hash) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        EntityCore entity = EntityCore.get(hash);
        if (entity == null || entity.id() == 0L) {
            throw new DeviceNotFoundException();
        }
        EntitySigCollection esc = new EntitySigCollection();
        esc.addEntity(entity);
        esc.filter();
        esc.addEntityContains();
        DetectRight.checkPoint("Getting QDT");
        esc.getQDT();
        esc.qdt.processPackages();
        DetectRight.setProperty("lastDetection", esc);
        return true;
    }

    public static boolean detectDevice(String entitytype, String manufacturer, String model) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(manufacturer) || Functions.isEmpty(model)) {
            throw new DetectRightException("Missing manufacturer or model", null);
        }
        EntityCore entity = EntityCore.getEntityFromCatDesc(manufacturer, model, entitytype);
        if (entity == null || entity.id() == 0L) {
            throw new DeviceNotFoundException();
        }
        return DetectRight.detectDevice(entity.hash);
    }

    public static boolean detectDevice(String manufacturer, String model) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        return DetectRight.detectDevice("", manufacturer, model);
    }

    static void recordAccess(String string) {
    }

    static void stop() {
        System.exit(0);
    }

    public static Map<String, Object> getAllDevices() throws DetectRightException, ConnectionLostException {
        return DetectRight.getAllDevices(null);
    }

    public static Map<String, Object> getAllDevices(List<String> deviceIDs) throws DetectRightException, ConnectionLostException {
        if (!DetectRight.catManagementAllowed()) {
            throw new DetectRightException("Catalogue management not enabled in this build", null);
        }
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        DBLink db = DetectRight.getDBLink();
        if (db == null) {
            throw new ConnectionLostException();
        }
        RecordSet rs = null;
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        fields.put("0", "ID");
        fields.put("1", "hash");
        fields.put("2", "firstua");
        fields.put("3", "category");
        fields.put("4", "entitytype");
        fields.put("5", "description");
        if (deviceIDs != null) {
            if (deviceIDs.size() == 0) {
                return output;
            }
            LinkedHashMap<String, Object> wc = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> wc2 = new LinkedHashMap<String, Object>();
            wc2.put("op", "in");
            wc2.put("value", deviceIDs);
            wc.put("hash", wc2);
            rs = new RecordSet(db, EntityCore.table, fields, wc);
        } else {
            rs = new RecordSet(db, EntityCore.table, fields);
        }
        while (true) {
            LinkedHashMap<String, String> ed = new LinkedHashMap<String, String>();
            LinkedHashMap<String, Object> row = rs.fetch();
            if (row == null) break;
            String deviceId = Functions.gvString(row, "hash");
            String manufacturer = Functions.gvString(row, "category");
            String model = Functions.gvString(row, "description");
            String ua = Functions.gvString(row, "firstua");
            String entitytype = Functions.gvString(row, "entitytype");
            ed.put("deviceId", deviceId);
            ed.put("model", model);
            ed.put("manufacturer", manufacturer);
            ed.put("useragent", ua);
            ed.put("entitytype", entitytype);
            output.put(deviceId, ed);
        }
        rs = null;
        return output;
    }

    public static List<String> getDeltaDeviceIDs(List<String> oldDevices) throws DetectRightException, ConnectionLostException {
        return DetectRight.getDeltaDeviceIDs(oldDevices, new ArrayList<String>(), new LinkedHashMap<String, String>());
    }

    public static List<String> getDeltaDeviceIDs(List<String> oldDevices, ArrayList<String> exceptions) throws DetectRightException, ConnectionLostException {
        return DetectRight.getDeltaDeviceIDs(oldDevices, exceptions, new LinkedHashMap<String, String>());
    }

    public static List<String> getDeltaDeviceIDs(List<String> oldDevices, List<String> exceptions, Map<String, String> remaps) throws DetectRightException, ConnectionLostException {
        if (!DetectRight.catManagementAllowed()) {
            throw new DetectRightException("Catalogue management not enabled in this build", null);
        }
        if (oldDevices == null) {
            throw new DetectRightException("Device ID List Missing", null);
        }
        DBLink db = DetectRight.getDBLink();
        if (db == null) {
            throw new ConnectionLostException();
        }
        ArrayList<String> hashes = db.getIDs(EntityCore.table, "hash");
        if (oldDevices.size() == 0) {
            return hashes;
        }
        ArrayList<String> missedDevices = new ArrayList<String>();
        for (String oldHash : oldDevices) {
            if (hashes.contains(oldHash)) {
                hashes.remove(oldHash);
                continue;
            }
            missedDevices.add(oldHash);
        }
        for (String missedDevice : missedDevices) {
            EntityCore e = EntityCore.get(missedDevice);
            if (e == null) {
                exceptions.add(missedDevice);
                continue;
            }
            hashes.remove(e.hash);
            remaps.put(missedDevice, e.hash);
        }
        return hashes;
    }

    public static String getDeviceIDMap(String deviceID, List<String> aliases) throws DetectRightException, ConnectionLostException {
        EntityCore entity = EntityCore.get(deviceID);
        if (entity == null || entity.ID == 0L) {
            throw new DetectRightException("Device ID " + deviceID + "doesn't exist", null);
        }
        if (aliases != null) {
            DBLink dbl = entity.db;
            if (dbl == null) {
                throw new ConnectionLostException("Connection lost in getDeviceIDMap");
            }
            ArrayList<String> aliasIDs = dbl.getIDs(EntityAliasCore.table, "hash", DBLink.whereClause("entityhash", entity.hash));
            aliases.addAll(aliasIDs);
        }
        return entity.hash;
    }

    public static Map<String, String> getDeviceIDDetails(String deviceID) throws DetectRightException, ConnectionLostException {
        if (deviceID == null) {
            throw new DetectRightException("No Device ID present", null);
        }
        EntityCore entity = EntityCore.get(deviceID);
        if (entity == null || entity.ID == 0L) {
            throw new DetectRightException("Device ID " + deviceID + " does not exist", null);
        }
        LinkedHashMap<String, String> descriptor = new LinkedHashMap<String, String>();
        if (deviceID.equals(entity.hash)) {
            descriptor.put("entitytype", entity.entitytype);
            descriptor.put("category", entity.category);
            descriptor.put("description", entity.description);
        } else {
            EntityAliasCore ea = EntityAliasCore.get(deviceID);
            if (ea == null || ea.ID == 0L) {
                throw new DetectRightException("Device ID " + deviceID + " cannot be found in aliases", null);
            }
            descriptor.put("entitytype", ea.entitytype);
            descriptor.put("category", ea.category);
            descriptor.put("description", ea.description);
        }
        return descriptor;
    }

    static void importEntity(String hash, String dbString) throws DetectRightException, ConnectionLostException {
        DBLink src = DBLink.getConnection(dbString);
        DBLink dest = DetectRight.getDBLink();
        EntityPackage srcEP = EntityPackage.getPkg(hash, src);
        EntityPackage destEP = EntityPackage.getPkg(hash, dest);
        destEP.addFrom(srcEP);
    }

    static void updateEntities(String dbString) throws DetectRightException, ConnectionLostException {
        EntityPackage destEP;
        EntityPackage srcEP;
        DBLink src = DBLink.getConnection(dbString);
        DBLink dest = DetectRight.getDBLink();
        ArrayList<String> srcEntities = src.getIDs(EntityCore.table, "hash");
        ArrayList<String> destEntities = src.getIDs(EntityCore.table, "hash");
        ArrayList<String> sameEntities = new ArrayList<String>();
        for (String srcHash : srcEntities) {
            if (!destEntities.contains(srcHash)) continue;
            sameEntities.add(srcHash);
        }
        srcEntities.removeAll(sameEntities);
        destEntities.removeAll(sameEntities);
        for (String hash : sameEntities) {
            srcEP = EntityPackage.getPkg(hash, src);
            destEP = EntityPackage.getPkg(hash, dest);
            destEP.addFrom(srcEP);
        }
        for (String hash : srcEntities) {
            srcEP = EntityPackage.getPkg(hash, src);
            destEP = EntityPackage.getPkg(hash, dest);
            destEP.addFrom(srcEP);
        }
        for (String hash : destEntities) {
            EntityPackage destEP2 = EntityPackage.getPkg(hash, dest);
            destEP2.delete();
        }
    }

    static boolean updateLookups(String dbString) throws DetectRightException, ConnectionLostException {
        DBLink src = DBLink.getConnection(dbString);
        DBLink dest = DetectRight.getDBLink();
        boolean success = true;
        String lookupTables = (String)DetectRight.getProperty("lookups");
        ArrayList<String> tables = Functions.explode(",", lookupTables);
        for (String table : tables) {
            RecordSet srcRS = src.fetchRecordset(table, DBLink.allFields, DBLink.emptyHash);
            RecordSet destRS = dest.fetchRecordset(table, DBLink.allFields, DBLink.emptyHash);
            success &= RecordSet.syncRS(srcRS, destRS);
        }
        return success;
    }

    public static String getDBConnectionInfo() throws ConnectionLostException, DetectRightException {
        DBLink dbl = DetectRight.getDBLink();
        if (dbl == null) {
            return "";
        }
        String activeConnInfo = dbl.getConnectionInfo();
        return "Active Connection info: " + activeConnInfo;
    }

    public static List<String> status() throws DetectRightException, ConnectionLostException {
        return DetectRight.status(false);
    }

    public static String getCurrentDatasource() throws ConnectionLostException, DetectRightException {
        String activeDatasource = "";
        String ts = "";
        DBLink dbl = DetectRight.getDBLink();
        if (dbl == null) {
            return "";
        }
        if (dbl.params == null) {
            return "";
        }
        if (dbl.params.containsKey("address")) {
            activeDatasource = dbl.params.get("address");
        }
        if (dbl.params.containsKey("timestamp")) {
            ts = dbl.params.get("timestamp");
        }
        return String.valueOf(activeDatasource) + "/" + ts;
    }

    public static List<String> status(boolean gc) throws DetectRightException, ConnectionLostException {
        DBLink dbl;
        List<String> output = DetectRight.testDB();
        if (output == null) {
            output = new ArrayList<String>();
        }
        if ((dbl = DetectRight.getDBLink()) == null) {
            output.add("DBLink is null");
            return output;
        }
        Connection dbConn = dbl.getConnectionObject();
        if (dbConn == null) {
            output.add("DBConnection is null");
            return output;
        }
        String activeConnInfo = dbConn.toString();
        output.add("Active Connection: " + activeConnInfo);
        String threadNum = Thread.currentThread().getName();
        activeConnInfo = dbl.getConnectionInfo();
        if (activeConnInfo != null) {
            output.add("Active Connection info: " + activeConnInfo);
        }
        output.add("For thread " + threadNum);
        try {
            if (DetectRight.uaCacheStatus()) {
                output.add("uaCache enabled");
            } else {
                output.add("uaCache disabled");
            }
            if (uaCache != null) {
                output.add("uaCache size: " + String.valueOf(uaCache.size()));
                output.add("uaCache max size: " + String.valueOf(uaCache.maxSize()));
            } else {
                output.add("uaCache is null");
            }
            if (DetectRight.compositeQDTCacheStatus()) {
                output.add("Composite QDT Cache enabled");
            } else {
                output.add("Composite QDT Cache disabled");
            }
            if (EntityCore.QDTs != null) {
                output.add("Composite QDT Cache size: " + String.valueOf(EntityCore.QDTs.size()));
                output.add("Composite QDT Cache max size: " + String.valueOf(EntityCore.QDTs.maxSize()));
            } else {
                output.add("Composite QDT Cache is null");
            }
            if (DetectRight.epCacheStatus()) {
                output.add("EP Cache enabled");
            } else {
                output.add("EP Cache disabled");
            }
            if (EntityProfileCore.QDTs != null) {
                output.add("EP Cache size: " + String.valueOf(EntityProfileCore.QDTs.size()));
                output.add("EP Cache max size: " + String.valueOf(EntityProfileCore.QDTs.maxSize()));
            } else {
                output.add("EP Cache is null");
            }
            if (DetectRight.largeEPCacheStatus()) {
                output.add("Large EP Cache enabled");
            } else {
                output.add("Large EP Cache disabled");
            }
            if (EntityProfileCore.largeQDTs != null) {
                output.add("Large EP Cache size: " + String.valueOf(EntityProfileCore.largeQDTs.size()));
                output.add("Large EP Cache max size: " + String.valueOf(EntityProfileCore.largeQDTs.maxSize()));
            } else {
                output.add("Large EP Cache is null");
            }
            output.add("Sig cache size:" + String.valueOf(Sig.sigs.size()));
            output.add("SchemaProperty size: " + String.valueOf(SchemaPropertyCore.cacheArray.size()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Runtime rt = Runtime.getRuntime();
        output.add("Before Garbage Collection");
        output.add("Total memory available : " + rt.totalMemory());
        output.add("Free memory available : " + rt.freeMemory());
        if (gc) {
            System.gc();
            rt = Runtime.getRuntime();
            output.add("After Garbage Collection");
            output.add("Total memory available : " + rt.totalMemory());
            output.add("Free memory available : " + rt.freeMemory());
        }
        return output;
    }

    static void gc() {
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean storeDatabaseInMemory(String srcConn) throws DetectRightException, ConnectionLostException {
        Object object;
        if (Functions.isEmpty(srcConn)) {
            throw new DetectRightException("Database Store Source is empty", null);
        }
        boolean dummy = EntityCore.useCache;
        dummy = EntityProfileCore.useCache;
        dummy = Sig.flushed;
        DBLink db = DBLink.getConnection(srcConn, true);
        if (db == null) {
            return false;
        }
        if (!db.dbOK) {
            return false;
        }
        Object result = Reflection.invokeStaticMethodWithObject(db.getClass().getCanonicalName(), "copyToGlobal", "DBLink", db);
        if (result == null) {
            return false;
        }
        boolean success = Boolean.parseBoolean(result.toString());
        if (success) {
            Sig.dbLink.set(DetectRight.getDBLink());
            Sig.loadSigs_all(true);
        }
        EntityCore.dbLink.set(DetectRight.getDBLink());
        if (uaCache != null) {
            object = uaCache;
            synchronized (object) {
                uaCache.clear();
            }
        }
        if (EntityProfileCore.largeQDTs != null) {
            object = EntityProfileCore.largeQDTs;
            synchronized (object) {
                EntityProfileCore.largeQDTs.clear();
            }
        }
        if (EntityProfileCore.QDTs != null) {
            object = EntityProfileCore.QDTs;
            synchronized (object) {
                EntityProfileCore.QDTs.clear();
            }
        }
        if (EntityCore.QDTs != null) {
            object = EntityCore.QDTs;
            synchronized (object) {
                EntityCore.QDTs.clear();
            }
        }
        if (EntityCore.entities != null) {
            object = EntityCore.entities;
            synchronized (object) {
                EntityCore.entities.clear();
            }
        }
        if (EntityCore.epRows != null) {
            object = EntityCore.epRows;
            synchronized (object) {
                EntityCore.epRows.clear();
            }
        }
        if (EntityCore.containedRows != null) {
            object = EntityCore.containedRows;
            synchronized (object) {
                EntityCore.containedRows.clear();
            }
        }
        if (SchemaPropertyCore.cacheArray != null) {
            object = SchemaPropertyCore.cacheArray;
            synchronized (object) {
                SchemaPropertyCore.cacheArray.clear();
            }
        }
        if (EntitySigCollection.gOverrides != null) {
            object = EntitySigCollection.gOverrides;
            synchronized (object) {
                EntitySigCollection.gOverrides.clear();
            }
        }
        if (EntityAliasCore.aliases != null) {
            object = EntityAliasCore.aliases;
            synchronized (object) {
                EntityAliasCore.aliases.clear();
            }
        }
        if (PointerCore.pointers != null) {
            object = PointerCore.pointers;
            synchronized (object) {
                PointerCore.pointers.clear();
            }
        }
        db.close();
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void removeDatabaseFromMemory() throws DetectRightException, ConnectionLostException {
        Object object;
        DBLink.useGlobalLink = false;
        if (DBLink.global == null) {
            return;
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (DBLink.global != null) {
            object = DBLink.global;
            synchronized (object) {
                try {
                    DBLink.global.close();
                    DBLink.global = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        object = DBLink.dbs;
        synchronized (object) {
            DBLink.dbs.clear();
        }
    }

    static synchronized boolean isClassesNull() {
        return classes == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized int classesSize() {
        int size = 0;
        if (classes == null) {
            return size;
        }
        ArrayList<String> arrayList = classes;
        synchronized (arrayList) {
            size = classes.size();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized String getClass(int i) {
        String classStr = "";
        if (classes == null) {
            return "";
        }
        ArrayList<String> arrayList = classes;
        synchronized (arrayList) {
            try {
                classStr = classes.get(i);
            }
            catch (Exception e) {
                return "";
            }
        }
        return classStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void shutdown() {
        try {
            DetectRight.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (properties == null) {
            return;
        }
        ThreadLocal threadLocal = properties;
        synchronized (threadLocal) {
            properties = null;
        }
    }

    public static void testFile(String input) throws FileNotFoundException, IOException, ConnectionLostException, DetectRightException {
        DetectRight.testFile(input, "", "UA");
    }

    public static void testFile(String input, String output, String detectionMethod) throws FileNotFoundException, IOException, ConnectionLostException, DetectRightException {
        OutputStreamWriter out = null;
        if (!Functions.isEmpty(output)) {
            out = new OutputStreamWriter(new FileOutputStream(output));
        }
        DetectRight.testFile(input, out, detectionMethod);
    }

    public static void testFile(String input, Writer output, String detectionMethod) throws FileNotFoundException, IOException, ConnectionLostException, DetectRightException {
        Scanner scanner = new Scanner(new FileInputStream(input));
        DetectRight.testFile(scanner, output, detectionMethod);
    }

    public static void testFile(Scanner scanner, Writer out, String detectionMethod) throws FileNotFoundException, IOException, ConnectionLostException, DetectRightException {
        block31: {
            if (DetectRight.getDBLink() == null) {
                throw new DetectRightException("DetectRight not initialized", null);
            }
            if (Functions.isEmpty(detectionMethod)) {
                detectionMethod = "UA";
            }
            ArrayList<String> booleans = new ArrayList<String>();
            LinkedHashMap<String, SchemaPropertyCore> schemas = SchemaPropertyCore.getSchema();
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<String> schemaKeys = Functions.array_keys_string(schemas);
            for (String sKey : schemaKeys) {
                boolean isBool = false;
                SchemaPropertyCore sp = schemas.get(sKey);
                if (sp.type.equals("Boolean")) {
                    isBool = true;
                }
                if (DetectRight.getPropertyBool("strictExportNames").booleanValue()) {
                    if (isBool) {
                        booleans.add(sp.display_name);
                    }
                    fields.add(sp.display_name);
                    continue;
                }
                if (isBool) {
                    booleans.add(sp.property);
                }
                fields.add(sp.property);
            }
            Functions.sort(fields);
            Functions.array_unshift(fields, (Object)"devicedescriptor");
            Functions.array_unshift(fields, (Object)"deviceid");
            String outStr = "Item\t" + Functions.implode("\t", fields) + "\ttimetaken\tmemoryUsed\tfreeMem\ttotalMem\tdatasource";
            if (out != null) {
                out.write(String.valueOf(outStr) + "\n");
            } else {
                System.out.println(outStr);
            }
            int r = 0;
            int n = 0;
            double totalTime = 0.0;
            Runtime rt = Runtime.getRuntime();
            try {
                try {
                    while (scanner.hasNextLine()) {
                        ArrayList<String> propString = new ArrayList<String>();
                        String useragent = scanner.nextLine();
                        propString.add(useragent);
                        double start = Functions.mt();
                        Map<String, Object> profile = null;
                        boolean miss = false;
                        try {
                            profile = detectionMethod.equals("UA") ? DetectRight.getProfileFromUA(useragent, "") : (detectionMethod.equals("ID") ? DetectRight.getProfileFromDeviceID(useragent, "") : new LinkedHashMap<String, Object>());
                        }
                        catch (DeviceNotFoundException dnfe) {
                            if (out != null) {
                                System.out.println(String.valueOf(useragent) + " missed");
                            }
                            miss = true;
                        }
                        catch (DetectRightException de) {
                            System.out.println(de.getMessage());
                            if (de.ex != null) {
                                de.ex.printStackTrace();
                            } else {
                                de.printStackTrace();
                            }
                            miss = true;
                        }
                        double end = Functions.mt();
                        for (String field : fields) {
                            if (!miss && profile != null && profile.containsKey(field)) {
                                boolean isBool = booleans.contains(field);
                                Object thingObj = profile.get(field);
                                try {
                                    String thing = thingObj.toString();
                                    if (isBool && (thing = Validator.validate("wurfl_boolean", thing, true)) == null) {
                                        thing = "";
                                    }
                                    propString.add(thing);
                                }
                                catch (Throwable e) {
                                    propString.add("xxx");
                                }
                                continue;
                            }
                            propString.add("---");
                        }
                        propString.add(String.valueOf(end - start));
                        totalTime += end - start;
                        ++n;
                        long freeMem = rt.freeMemory();
                        long totalMem = rt.totalMemory();
                        long usedMem = totalMem - freeMem;
                        propString.add(String.valueOf(usedMem));
                        propString.add(String.valueOf(freeMem));
                        propString.add(String.valueOf(totalMem));
                        DBLink db = DetectRight.getDBLink();
                        String datasource = db.params.get("address");
                        propString.add(datasource);
                        String property = Functions.implode("\t", propString);
                        if (out != null) {
                            out.write(String.valueOf(property) + "\n");
                        } else {
                            System.out.println(property);
                        }
                        ++r;
                        Thread.yield();
                        DetectRight.clear();
                    }
                    double average = totalTime / (double)n;
                    System.out.println("Average time: " + average);
                }
                catch (Throwable throwable) {
                    scanner.close();
                    if (out != null) {
                        out.close();
                    }
                    break block31;
                }
            }
            catch (Throwable throwable) {
                scanner.close();
                if (out != null) {
                    out.close();
                }
                throw throwable;
            }
            scanner.close();
            if (out != null) {
                out.close();
            }
        }
        DetectRight.close();
    }

    public static List<String> testDR(String useragent) throws IOException, DetectRightException, ConnectionLostException {
        return DetectRight.testDR(useragent, "");
    }

    public static List<String> testDR(String useragent, String field) throws IOException, DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Object> lhm = new LinkedHashMap<String, Object>();
        lhm.put("HTTP_USER_AGENT", useragent);
        return DetectRight.testDR(lhm, field);
    }

    public static List<String> testDR(Map<String, Object> headers, String field) throws IOException, DetectRightException, ConnectionLostException {
        ArrayList<String> out = new ArrayList<String>();
        try {
            if (headers == null || headers.size() == 0) {
                throw new DetectRightException("No Input headers", null);
            }
            Map<String, Object> lhm = DetectRight.getProfileFromHeaders(headers);
            EntitySigCollection esc = DetectRight.getLastDetection();
            QuantumDataTree qdt = esc.qdt;
            ArrayList<String> pkg = qdt.packageMe();
            out.add("Entity sigs");
            ArrayList<EntitySig> ess = esc.es;
            for (EntitySig es : ess) {
                out.add(String.valueOf(es.descriptor) + " --- " + es.sig);
            }
            out.add("Last Detection QDT");
            out.add(Functions.implode("\n", pkg));
            qdt.resetCount();
            if (!Functions.isEmpty(field)) {
                SchemaPropertyCore nsp = new SchemaPropertyCore(field);
                Object value = SchemaPropertyCore.getObjectValue(qdt, nsp);
                pkg = qdt.packageMe(true);
                out.add((String)value);
                out.add(Functions.implode("\n", pkg));
            }
            ArrayList<String> keys = Functions.array_keys_string(lhm);
            for (String key : keys) {
                String property = String.valueOf(lhm.get(key));
                String outStr = String.valueOf(key) + " = " + property;
                out.add(outStr);
            }
        }
        catch (DeviceNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (DetectRightException e) {
            e.printStackTrace();
        }
        catch (ConnectionLostException e) {
            e.printStackTrace();
        }
        return out;
    }

    public static Map<String, SchemaPropertyCore> getAllFieldNames() throws DetectRightException, ConnectionLostException {
        return SchemaPropertyCore.getSchema();
    }

    public static List<String> getCapabilities() throws DetectRightException, ConnectionLostException {
        LinkedHashMap<String, SchemaPropertyCore> schema = SchemaPropertyCore.getSchema();
        ArrayList<String> output = new ArrayList<String>();
        boolean displayNames = DetectRight.getStrictExportNames();
        for (Map.Entry spe : schema.entrySet()) {
            SchemaPropertyCore sp = (SchemaPropertyCore)spe.getValue();
            if (!sp.export_property || sp.error_trap == 1) continue;
            if (displayNames) {
                output.add(sp.display_name);
                continue;
            }
            output.add(sp.property);
        }
        return output;
    }
}

