/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Cache;
import com.detectright.core.ConnectionLostException;
import com.detectright.core.DBLink;
import com.detectright.core.DRLRUMap;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.Functions;
import com.detectright.core.Reflection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityAliasCore {
    public static ThreadLocal<DBLink> dbLink = new ThreadLocal();
    public static volatile DRLRUMap aliases = new DRLRUMap(1000);
    protected DBLink db;
    public static ThreadLocal<Cache> cacheLink = new ThreadLocal();
    protected Cache cache;
    boolean cached = false;
    public long ID;
    public String owner = "SYSTEM";
    public String hash = "";
    public int status = 0;
    public long entityid = -1L;
    public String entityhash = "";
    public String entitytype = "";
    public String category = "";
    public String description = "";
    public String ts = "";
    public String catDescSearch = "";
    public String descSearch = "";
    public String postPart = "";
    public String prePart = "";
    public String subclass = "";
    public String majorrevision = "";
    public String error = "";
    public static String ERROR = "";
    public String tablename = "";
    public LinkedHashMap<String, Object> fieldList = new LinkedHashMap();
    public String pk = "";
    public static String table = "entity_alias";
    public static int cache_timeout = 600;
    public static ArrayList<String> fields = new ArrayList<String>(Arrays.asList("ID", "hash", "entityid", "entityhash", "entitytype", "category", "description", "ts", "descSearch", "catDescSearch", "postPart", "prePart", "subclass", "majorrevision", "status", "owner", "ts"));
    public static String PK = "ID";

    static {
        DetectRight.registerClass("EntityAliasCore");
        try {
            if (Functions.is_null(cacheLink.get())) {
                cacheLink.set(DetectRight.getCacheLink());
            }
            if (Functions.is_null(dbLink.get())) {
                dbLink.set(DetectRight.getDBLink());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
    }

    public EntityAliasCore() throws ConnectionLostException, DetectRightException {
        this.cacheDB();
        this.tablename = table;
        this.fieldList = Functions.arr2hm(fields);
        this.pk = PK;
    }

    public EntityAliasCore(long ID) throws DetectRightException, ConnectionLostException {
        this(ID, "");
    }

    public EntityAliasCore(String hash) throws DetectRightException, ConnectionLostException {
        this(0L, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityAliasCore(long ID, String hash) throws DetectRightException, ConnectionLostException {
        this.cacheDB();
        if (!Functions.isEmpty(hash) && Functions.strlen(hash) != 32) {
            hash = "";
        }
        this.tablename = table;
        this.fieldList = Functions.arr2hm(fields);
        this.pk = PK;
        LinkedHashMap<String, Object> where = new LinkedHashMap<String, Object>();
        if (!Functions.isEmpty(hash)) {
            where.put("hash", hash);
            String owner = DetectRight.getDataOwner();
            if (!owner.equals("SYSTEM")) {
                LinkedHashMap<String, Object> tmpWC = new LinkedHashMap<String, Object>();
                ArrayList<String> owners = new ArrayList<String>();
                owners.add(DetectRight.getDataOwner());
                if (!owners.contains("SYSTEM")) {
                    owners.add("SYSTEM");
                }
                tmpWC.put("op", "in");
                tmpWC.put("value", owners);
                where.put("owner", tmpWC);
            }
        } else if (ID > 0L) {
            where.put(this.pk, String.valueOf(ID));
        } else {
            this.error = "No alias available";
            return;
        }
        LinkedHashMap<String, Object> result = null;
        String key = String.valueOf(String.valueOf(ID) + "/" + hash);
        boolean sds = DetectRight.getSingleDataSource();
        if (sds && aliases.containsKey(key)) {
            result = (LinkedHashMap)aliases.get(key);
        }
        if (result == null) {
            if (sds) {
                DRLRUMap dRLRUMap = aliases;
                synchronized (dRLRUMap) {
                    if (aliases.containsKey(key)) {
                        result = (LinkedHashMap<String, Object>)aliases.get(key);
                    } else {
                        result = this.db.simpleFetch(this.tablename, DBLink.allFields, where);
                        if (result != null) {
                            aliases.put(key, result);
                        }
                    }
                }
            } else {
                result = this.db.simpleFetch(this.tablename, DBLink.allFields, where);
            }
        }
        if (result == null) {
            this.error = this.db.sql_error();
            return;
        }
        if (result.size() == 0) {
            return;
        }
        LinkedHashMap data = (LinkedHashMap)Functions.get_first_value(result);
        this.fill(data);
        this.generateSearchStrings();
    }

    void fill(LinkedHashMap<String, Object> data) {
        if (data == null) {
            return;
        }
        if (data.containsKey("ID")) {
            this.ID = Functions.gvLong(data, "ID", 0L);
        }
        if (data.containsKey("hash")) {
            this.hash = Functions.gvString(data, "hash");
        }
        if (data.containsKey("category")) {
            this.category = Functions.gvString(data, "category");
        }
        if (data.containsKey("description")) {
            this.description = Functions.gvString(data, "description");
        }
        if (data.containsKey("entitytype")) {
            this.entitytype = Functions.gvString(data, "entitytype");
        }
        if (data.containsKey("entityhash")) {
            this.entityhash = Functions.gvString(data, "entityhash");
        }
        if (data.containsKey("entityid")) {
            this.entityid = Functions.gvLong(data, "entityid", 0L);
        }
        if (data.containsKey("owner")) {
            this.owner = Functions.gvString(data, "owner");
        }
        if (data.containsKey("descSearch")) {
            this.descSearch = Functions.gvString(data, "descSearch");
        }
        if (data.containsKey("catDescSearch")) {
            this.catDescSearch = Functions.gvString(data, "catDescSearch");
        }
        if (data.containsKey("postPart")) {
            this.postPart = Functions.gvString(data, "postPart");
        }
        if (data.containsKey("prePart")) {
            this.prePart = Functions.gvString(data, "prePart");
        }
        if (data.containsKey("status")) {
            try {
                this.status = Functions.parseInt(Functions.gvString(data, "status"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (data.containsKey("majorrevision")) {
            this.majorrevision = Functions.gvString(data, "majorrevision");
        }
        if (data.containsKey("subclass")) {
            this.subclass = Functions.gvString(data, "subclass");
        }
        if (data.containsKey("ts")) {
            this.ts = Functions.gvString(data, "ts");
        }
    }

    public void cacheDB() throws ConnectionLostException, DetectRightException {
        if (Functions.is_null(cacheLink.get())) {
            cacheLink.set(DetectRight.getCacheLink());
        }
        this.cache = cacheLink.get();
        if (Functions.is_null(dbLink.get())) {
            dbLink.set(DetectRight.getDBLink());
        }
        this.db = dbLink.get();
        if (this.db == null) {
            throw new ConnectionLostException("Lost connection to database");
        }
    }

    public void __wakeup() throws ConnectionLostException, DetectRightException {
        this.cacheDB();
    }

    public ArrayList<String> __sleep() {
        LinkedHashMap<String, Object> ov = Reflection.get_object_vars(this);
        ov.remove("cache");
        ov.remove("db");
        return Functions.array_keys_string(ov);
    }

    public String hash() {
        return this.hash;
    }

    public long id() {
        return this.ID;
    }

    public boolean setid(long value) {
        if (value > 0L) {
            this.ID = value;
            return true;
        }
        return false;
    }

    public String toString() {
        return "";
    }

    public long ts() {
        return Functions.strtotime(this.ts);
    }

    public static ArrayList<EntityAliasCore> getAliasCollection(long entityid) throws DetectRightException, ConnectionLostException {
        return EntityAliasCore.getAliasCollection(entityid, new ArrayList<String>());
    }

    public static ArrayList<EntityAliasCore> getAliasCollection(long entityid, ArrayList<String> status) throws DetectRightException, ConnectionLostException {
        ArrayList<EntityAliasCore> eas = new ArrayList<EntityAliasCore>();
        LinkedHashMap<String, Object> where = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> in = new LinkedHashMap<String, Object>();
        if (!Functions.isEmpty(status)) {
            in.put("op", "in");
            in.put("value", status);
            where.put("status", in);
        }
        where.put("entityid", String.valueOf(entityid));
        DBLink dbl = dbLink.get();
        if (dbl == null) {
            throw new ConnectionLostException("Connection to DB Lost");
        }
        ArrayList<String> ids = dbl.getIDs(table, "ID", where);
        for (String id : ids) {
            EntityAliasCore ea = EntityAliasCore.getEntityAlias(Long.parseLong(id));
            eas.add(ea);
        }
        return eas;
    }

    public static ArrayList<Long> getEntities(LinkedHashMap<String, Object> where) throws DetectRightException, ConnectionLostException {
        return EntityAliasCore.getEntities(where, 1);
    }

    public static ArrayList<Long> getEntities(LinkedHashMap<String, Object> where, int limit) throws DetectRightException, ConnectionLostException {
        ArrayList<Long> output = new ArrayList<Long>();
        DBLink dbl = dbLink.get();
        if (dbl == null) {
            throw new ConnectionLostException("Lost connection getting entities for alias");
        }
        ArrayList<String> ids = dbl.getIDs(table, "entityid", where, DBLink.emptyHash, DBLink.limitMap(limit));
        if (!Functions.isEmpty(ids)) {
            ids = Functions.array_unique(ids);
        }
        for (String idStr : ids) {
            output.add(Long.parseLong(idStr));
        }
        return output;
    }

    public static EntityAliasCore getEntityAlias(long id) throws DetectRightException, ConnectionLostException {
        return EntityAliasCore.get(id);
    }

    public static EntityAliasCore get(long id) throws DetectRightException, ConnectionLostException {
        return EntityAliasCore.get(id, "");
    }

    public static EntityAliasCore get(String hash) throws DetectRightException, ConnectionLostException {
        return EntityAliasCore.get(0L, hash);
    }

    public static EntityAliasCore get(long id, String hash) throws DetectRightException, ConnectionLostException {
        if (id > 0L) {
            return new EntityAliasCore(id);
        }
        return EntityAliasCore.getEntityAliasFromHash(hash);
    }

    public static EntityAliasCore getEntityAliasFromHash(String hash) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(hash)) {
            return new EntityAliasCore(0L);
        }
        EntityAliasCore ea = new EntityAliasCore(0L, hash);
        if (ea.error.length() > 0) {
            ERROR = ea.error;
        }
        return ea;
    }

    public String cacheKey() {
        return DetectRight.cacheKey("EA_" + String.valueOf(this.id()));
    }

    public void cache() {
        this.cache(0, true);
    }

    public void cache(int timeout) {
        this.cache(timeout, true);
    }

    public void cache(int timeout, boolean overwrite) {
        if (timeout < 0) {
            return;
        }
        if (timeout == 0) {
            timeout = cache_timeout;
        }
        if (this.id() == 0L) {
            return;
        }
        if (!overwrite && this.cached) {
            return;
        }
        this.cached = true;
        this.cache.cache_set(this.cacheKey(), this, timeout);
    }

    public void generateSearchStrings() {
        String cleanCat = Functions.nn(this.category);
        String cleanDesc = Functions.nn(this.description);
        this.catDescSearch = Functions.punctClean(String.valueOf(cleanCat) + cleanDesc);
        this.descSearch = Functions.punctClean(cleanDesc);
        this.postPart = EntityAliasCore.postPart(cleanDesc);
        this.prePart = EntityAliasCore.prePart(cleanDesc);
    }

    public static String postPart(String description) {
        if (description == null) {
            return "";
        }
        ArrayList<String> tmp = Functions.explode("-", description);
        if (tmp.size() > 1) {
            return tmp.get(tmp.size() - 1).toString();
        }
        tmp = Functions.explode(" ", description);
        if (tmp.size() > 1) {
            return tmp.get(tmp.size() - 1).toString();
        }
        return "";
    }

    public static String prePart(String description) {
        if (description == null) {
            return "";
        }
        ArrayList<String> tmp = Functions.explode("-", description);
        if (tmp.size() > 1) {
            return tmp.get(0).toString();
        }
        tmp = Functions.explode(" ", description);
        if (tmp.size() > 1) {
            return tmp.get(0).toString();
        }
        return "";
    }

    public String descriptor() {
        String entitytype = DetectRight.escapeDescriptor(this.entitytype);
        String category = DetectRight.escapeDescriptor(this.category);
        String description = DetectRight.escapeDescriptor(this.description);
        String descriptor = String.valueOf(entitytype) + ":" + category + ":" + description;
        String subclass = DetectRight.escapeDescriptor(this.subclass);
        String majorRevision = DetectRight.escapeDescriptor(this.majorrevision);
        descriptor = descriptor.concat(":" + subclass + ":" + majorRevision);
        while (descriptor.endsWith(":")) {
            descriptor = Functions.substr(descriptor, 0, -1);
        }
        return descriptor;
    }
}

