/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Cache;
import com.detectright.core.ConnectionLostException;
import com.detectright.core.DBLink;
import com.detectright.core.DRLRUMap;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.EntityAliasCore;
import com.detectright.core.EntityProfileCore;
import com.detectright.core.EntitySigCollection;
import com.detectright.core.Functions;
import com.detectright.core.HTTPHeadersCore;
import com.detectright.core.Property;
import com.detectright.core.QuantumDataCollection;
import com.detectright.core.QuantumDataTree;
import com.detectright.core.Reflection;
import com.detectright.core.Sig;
import com.detectright.core.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityCore {
    static volatile ArrayList<String> nominativeEntityTypes = new ArrayList();
    static volatile DRLRUMap QDTs = null;
    static volatile DRLRUMap entities = new DRLRUMap(1000);
    static volatile DRLRUMap epRows = new DRLRUMap(1000);
    static volatile DRLRUMap containedRows = new DRLRUMap(1000);
    public static ThreadLocal<DBLink> dbLink = new ThreadLocal();
    public static boolean useCache = false;
    public static boolean eCache = false;
    protected DBLink db;
    public static ThreadLocal<Cache> cacheLink = new ThreadLocal();
    protected Cache cache;
    boolean cached = false;
    public long ID = 0L;
    public String hash = "";
    public String category = "";
    public String description = "";
    String ts = "";
    public int status = 2;
    public String entitytype = "";
    String catDescSearch = "";
    String descSearch = "";
    String revisionfallback = "fallback";
    String postPart = "";
    String prePart = "";
    public int year;
    int exclusivity = 2;
    LinkedHashMap<String, Object> profiles = new LinkedHashMap();
    boolean isCustom = false;
    QuantumDataTree qdt;
    QuantumDataCollection qdc;
    ArrayList<String> profileChanges = new ArrayList();
    String owner = "SYSTEM";
    @Deprecated
    String editable = "";
    String error = "";
    static String ERROR = "";
    String tablename = "";
    LinkedHashMap<String, Object> linkedTables = new LinkedHashMap();
    LinkedHashMap<String, Object> tables = new LinkedHashMap();
    public String majorrevision = "";
    public String minorrevision = "";
    String subclass = "";
    public String connection = "";
    public String build = "";
    int currentTrust = 0;
    ArrayList<Object> contains = null;
    EntitySigCollection esc;
    LinkedHashMap<String, Object> orgs = new LinkedHashMap();
    LinkedHashMap<String, Object> aliases = new LinkedHashMap();
    EntityAliasCore alias;
    Object ees = new LinkedHashMap();
    String pk = "";
    LinkedHashMap<String, Object> canned = new LinkedHashMap();
    LinkedHashMap<String, Object> fieldList = new LinkedHashMap();
    static String table = "entity";
    static String staticTable = "entity_data";
    static int cache_timeout = 600;
    static volatile ArrayList<String> fields = new ArrayList<String>(Arrays.asList("ID", "hash", "category", "description", "status", "entitytype", "owner", "revisionfallback", "descSearch", "catDescSearch", "postPart", "prePart", "year", "exclusivity", "ts"));
    static ConcurrentHashMap<String, Object> LINKED_TABLES = new ConcurrentHashMap<String, Object>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("contains", "entity_contains");
        }
    };
    static String PK = "ID";

    static {
        try {
            DetectRight.checkPoint("Static entity code");
            DetectRight.registerClass("EntityCore");
            try {
                if (Functions.is_null(cacheLink.get())) {
                    cacheLink.set(DetectRight.getCacheLink());
                }
                if (Functions.is_null(dbLink.get())) {
                    dbLink.set(DetectRight.getDBLink());
                }
            }
            catch (ConnectionLostException connectionLostException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            EntityCore.fillNET();
        }
        catch (DetectRightException detectRightException) {
        }
        catch (ConnectionLostException connectionLostException) {
            // empty catch block
        }
    }

    static void main(String[] args) {
    }

    void __destruct() {
        this.qdt = null;
        this.profiles = null;
    }

    public EntityCore() throws DetectRightException, ConnectionLostException {
        this.cacheDB();
        this.tablename = table;
        this.fieldList = Functions.arr2hm(fields);
        this.linkedTables = new LinkedHashMap();
        this.linkedTables.putAll(LINKED_TABLES);
        this.pk = PK;
    }

    public EntityCore(long ID) throws DetectRightException, ConnectionLostException {
        this(ID, "");
    }

    EntityCore(String hash) throws DetectRightException, ConnectionLostException {
        this(0L, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EntityCore(long ID, String hash) throws DetectRightException, ConnectionLostException {
        DRLRUMap dRLRUMap;
        this.cacheDB();
        if (!Functions.isEmpty(hash) && hash.length() != 32) {
            hash = "";
        }
        this.tablename = table;
        this.fieldList = Functions.arr2hm(fields);
        this.linkedTables = new LinkedHashMap();
        this.linkedTables.putAll(LINKED_TABLES);
        this.pk = PK;
        DetectRight.checkPoint("Fields: " + fields.toString());
        LinkedHashMap<String, Object> where = new LinkedHashMap<String, Object>();
        LinkedHashMap data = new LinkedHashMap();
        if (!Functions.isEmpty(hash)) {
            where.put("hash", hash);
        } else if (ID > 0L) {
            where.put(this.pk, ID);
        } else {
            DetectRight.checkPoint("No category, description or entitytype supplied");
            return;
        }
        String key = hash;
        if (Functions.isEmpty(hash)) {
            key = String.valueOf(ID);
        }
        LinkedHashMap<String, Object> entity = null;
        boolean sds = DetectRight.getSingleDataSource();
        boolean fromCache = false;
        if (sds) {
            if (!Functions.isEmpty(key) && entities.containsKey(key)) {
                entity = (LinkedHashMap<String, Object>)entities.get(key);
                fromCache = true;
            }
            if (entity == null) {
                dRLRUMap = entities;
                synchronized (dRLRUMap) {
                    if (entities.containsKey(key)) {
                        entity = (LinkedHashMap)entities.get(key);
                        fromCache = true;
                    } else {
                        entity = this.db.simpleFetch(this.tablename, DBLink.allFields, where);
                    }
                }
            }
        } else {
            entity = this.db.simpleFetch(this.tablename, DBLink.allFields, where);
        }
        if (entity == null) {
            throw new DetectRightException("SQL Error!" + this.db.sql_error(), null);
        }
        if (entity.size() == 0) {
            this.error = "Non existent handset and no data";
            DetectRight.checkPoint("Non-existent handset and no data...");
            return;
        }
        data = (LinkedHashMap)Functions.get_first_value(entity);
        data.size();
        if (sds && !fromCache) {
            dRLRUMap = entities;
            synchronized (dRLRUMap) {
                Object hashObj;
                if (data.containsKey("hash") && (hashObj = data.get("hash")) != null && !entities.containsKey(hashObj.toString())) {
                    entities.add(hashObj.toString(), entity);
                }
                if (data.containsKey("ID") && (hashObj = data.get("ID")) != null && !entities.containsKey(hashObj.toString())) {
                    entities.add(hashObj.toString(), entity);
                }
            }
        }
        this.fill(data);
        this.generateSearchStrings();
    }

    void fill(LinkedHashMap<String, Object> data) {
        if (data == null) {
            return;
        }
        if (data.containsKey("ID")) {
            this.ID = Functions.gvLong(data, "ID", 0L);
        }
        if (data.containsKey("hash")) {
            this.hash = Functions.gvString(data, "hash");
        }
        if (data.containsKey("category")) {
            this.category = Functions.gvString(data, "category");
        }
        if (data.containsKey("description")) {
            this.description = Functions.gvString(data, "description");
        }
        if (data.containsKey("entitytype")) {
            this.entitytype = Functions.gvString(data, "entitytype");
        }
        if (data.containsKey("owner")) {
            this.owner = Functions.gvString(data, "owner");
        }
        if (data.containsKey("revisionfallback")) {
            this.revisionfallback = Functions.gvString(data, "revisionfallback");
        }
        if (data.containsKey("descSearch")) {
            this.descSearch = Functions.gvString(data, "descSearch");
        }
        if (data.containsKey("catDescSearch")) {
            this.catDescSearch = Functions.gvString(data, "catDescSearch");
        }
        if (data.containsKey("postPart")) {
            this.postPart = Functions.gvString(data, "postPart");
        }
        if (data.containsKey("prePart")) {
            this.prePart = Functions.gvString(data, "prePart");
        }
        if (data.containsKey("year")) {
            try {
                this.year = Functions.parseInt(Functions.gvString(data, "year"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (data.containsKey("status")) {
            try {
                this.status = Functions.parseInt(Functions.gvString(data, "status"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (data.containsKey("exclusivity")) {
            try {
                this.exclusivity = Functions.parseInt(Functions.gvString(data, "exclusivity"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (data.containsKey("ts")) {
            this.ts = Functions.gvString(data, "ts");
        }
    }

    ArrayList<Object> getContains() throws DetectRightException, ConnectionLostException {
        return this.getContains(999);
    }

    ArrayList<Object> getContains(int maxLevel) throws DetectRightException, ConnectionLostException {
        if (this.contains != null) {
            return this.contains;
        }
        LinkedHashMap output = new LinkedHashMap();
        LinkedHashMap<String, String> entityIndex = new LinkedHashMap<String, String>();
        ArrayList<Object> array = EntityCore.getContainsArray(this.ID, 1);
        if (array == null) {
            return null;
        }
        for (Object containsArrayObj : array) {
            String containsID;
            LinkedHashMap outputLevel;
            String levelStr;
            EntityCore contains;
            String levelKey;
            LinkedHashMap outputLevel2;
            EntityCore tmpEntity;
            LinkedHashMap containsArray = (LinkedHashMap)containsArrayObj;
            if (containsArray == null) continue;
            long entityid = 0L;
            String strEntityID = "";
            try {
                strEntityID = (String)containsArray.get("entityid");
                entityid = Long.valueOf(strEntityID);
            }
            catch (Exception e) {
                continue;
            }
            String entityDescriptor = (String)containsArray.get("entitydescriptor");
            if (Functions.isEmpty(entityDescriptor)) {
                EntityCore entity = EntityCore.get(entityid);
                if (entity == null) continue;
                entityDescriptor = entity.descriptor();
            }
            if (entityid != this.id() ? entityIndex.containsKey(strEntityID) && ((tmpEntity = (EntityCore)(outputLevel2 = (LinkedHashMap)output.get(levelKey = (String)entityIndex.get(strEntityID))).get(strEntityID)) == null || !tmpEntity.isDescriptorCompatible(entityDescriptor)) : !this.isDescriptorCompatible(entityDescriptor)) continue;
            String descriptor = (String)containsArray.get("containsdescriptor");
            if (!Functions.isEmpty(descriptor)) {
                contains = EntityCore.getEntityFromDescriptor(descriptor, false, false);
                if (contains == null) {
                    continue;
                }
            } else {
                String containshash = (String)containsArray.get("containshash");
                String subclass = Functions.gvString(containsArray, "subclass", "");
                String majorrevision = Functions.gvString(containsArray, "majorrevision");
                contains = EntityCore.get(containshash);
                if (contains == null) continue;
                contains.subclass = subclass;
                contains.majorrevision = majorrevision;
            }
            if (!Functions.isEmpty(contains.error)) continue;
            boolean bl = contains.isCustom = !Functions.gvString(containsArray, "owner", "SYSTEM").equals("SYSTEM");
            if (contains.isCustom && !this.isCustom) {
                this.isCustom = true;
            }
            if (!output.containsKey(levelStr = containsArray.get("level").toString())) {
                output.put(levelStr, new LinkedHashMap());
            }
            if ((outputLevel = (LinkedHashMap)output.get(levelStr)).containsKey(containsID = String.valueOf(contains.id()))) continue;
            outputLevel.put(String.valueOf(contains.id()), contains);
            entityIndex.put(String.valueOf(contains.id()), levelStr);
        }
        Functions.ksort(output);
        ArrayList<Object> entities = new ArrayList<Object>();
        LinkedHashMap tmpMap = output;
        for (Map.Entry entry : tmpMap.entrySet()) {
            LinkedHashMap entityArray = (LinkedHashMap)entry.getValue();
            String levelStr = (String)entry.getKey();
            int levelInt = 999;
            try {
                levelInt = Functions.parseInt(levelStr);
            }
            catch (NumberFormatException entityDescriptor) {
                // empty catch block
            }
            if (levelInt > maxLevel || entityArray == null) continue;
            ArrayList<Object> et = Functions.array_values(entityArray);
            entities.addAll(et);
        }
        this.contains = entities;
        return this.contains;
    }

    static ArrayList<Object> getContainsArray(long entityid) throws DetectRightException, ConnectionLostException {
        return EntityCore.getContainsArray(entityid, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ArrayList<Object> getContainsArray(long entityid, int level) throws DetectRightException, ConnectionLostException {
        if (level > 10) {
            return new ArrayList<Object>();
        }
        ArrayList<Object> output = null;
        String key = String.valueOf(String.valueOf(entityid)) + "/" + String.valueOf(level);
        DRLRUMap dRLRUMap = containedRows;
        synchronized (dRLRUMap) {
            if (containedRows.containsKey(key)) {
                output = (ArrayList<Object>)containedRows.get(key);
            }
        }
        if (output != null) {
            return output;
        }
        boolean sds = DetectRight.getSingleDataSource();
        DBLink dbl = dbLink.get();
        if (dbl == null) {
            throw new ConnectionLostException("Contains lost connection to database");
        }
        if (sds) {
            DRLRUMap dRLRUMap2 = containedRows;
            synchronized (dRLRUMap2) {
                if (containedRows.containsKey(key)) {
                    output = (ArrayList)containedRows.get(key);
                } else {
                    LinkedHashMap<String, Object> ids;
                    DetectRight.setDataMode("SystemUser");
                    LinkedHashMap where = new LinkedHashMap();
                    where.put("entityid", String.valueOf(entityid));
                    where.put("valid", String.valueOf(1));
                    LinkedHashMap<String, String> tmp = new LinkedHashMap<String, String>();
                    tmp.put("op", "<>");
                    tmp.put("value", String.valueOf(entityid));
                    where.put("contains", tmp);
                    where = (LinkedHashMap)DetectRight.addOwner(where);
                    LinkedHashMap<String, Object> orderBy = new LinkedHashMap<String, Object>();
                    orderBy.put("trust", "DESC");
                    orderBy.put("containsdescriptor", "DESC");
                    orderBy.put("majorrevision", "DESC");
                    output = new ArrayList();
                    LinkedHashMap<String, Object> tmpMap = ids = dbl.simpleFetch(LINKED_TABLES.get("contains"), DBLink.allFields, where, orderBy);
                    for (Map.Entry entry : tmpMap.entrySet()) {
                        LinkedHashMap array = (LinkedHashMap)entry.getValue();
                        array.put("level", String.valueOf(level));
                        entityid = Long.parseLong(array.get("contains").toString());
                        output.add(array);
                        ArrayList<Object> containIDs = EntityCore.getContainsArray(entityid, level + 1);
                        output.addAll(containIDs);
                    }
                    containedRows.put(key, output);
                }
            }
        } else {
            LinkedHashMap<String, Object> ids;
            DetectRight.setDataMode("SystemUser");
            LinkedHashMap where = new LinkedHashMap();
            where.put("entityid", String.valueOf(entityid));
            where.put("valid", String.valueOf(1));
            LinkedHashMap<String, String> tmp = new LinkedHashMap<String, String>();
            tmp.put("op", "<>");
            tmp.put("value", String.valueOf(entityid));
            where.put("contains", tmp);
            where = (LinkedHashMap)DetectRight.addOwner(where);
            LinkedHashMap<String, Object> orderBy = new LinkedHashMap<String, Object>();
            orderBy.put("trust", "DESC");
            orderBy.put("containsdescriptor", "DESC");
            output = new ArrayList<Object>();
            LinkedHashMap<String, Object> tmpMap = ids = dbl.simpleFetch(LINKED_TABLES.get("contains"), DBLink.allFields, where, orderBy);
            for (Map.Entry entry : tmpMap.entrySet()) {
                LinkedHashMap array = (LinkedHashMap)entry.getValue();
                array.put("level", String.valueOf(level));
                entityid = Long.parseLong(array.get("contains").toString());
                output.add(array);
                ArrayList<Object> containIDs = EntityCore.getContainsArray(entityid, level + 1);
                output.addAll(containIDs);
            }
        }
        return output;
    }

    public String descriptor() {
        String entitytype = DetectRight.escapeDescriptor(this.entitytype);
        String category = DetectRight.escapeDescriptor(this.category);
        String description = DetectRight.escapeDescriptor(this.description);
        String descriptor = String.valueOf(entitytype) + ":" + category + ":" + description;
        String subclass = DetectRight.escapeDescriptor(this.subclass);
        String majorRevision = DetectRight.escapeDescriptor(this.majorrevision);
        String minorRevision = DetectRight.escapeDescriptor(this.minorrevision);
        String connection = DetectRight.escapeDescriptor(this.connection);
        String build = DetectRight.escapeDescriptor(this.build);
        descriptor = descriptor.concat(":" + subclass + ":" + majorRevision + ":" + minorRevision + ":" + connection + ":" + build);
        while (descriptor.endsWith(":")) {
            descriptor = Functions.substr(descriptor, 0, -1);
        }
        return descriptor;
    }

    public String hash() {
        return this.hash;
    }

    void checkHash() throws DetectRightException {
        String testHash = EntityCore.makeHash(this.entitytype, this.category, this.description);
        if (!testHash.equals(this.hash)) {
            this.fixHash();
        }
    }

    Object fixHash() {
        return null;
    }

    long id() {
        return this.ID;
    }

    boolean setid(long value) {
        try {
            this.ID = value;
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    long ts() {
        return Functions.strtotime(this.ts);
    }

    public String toString() {
        ArrayList<String> retArray = new ArrayList<String>();
        String majorRevision = this.majorrevision;
        String minorRevision = this.minorrevision;
        String subclass = this.subclass;
        String connection = this.connection;
        String build = this.build;
        if (this.entitytype.equals("Developer Platform") && this.category.equals("Nokia") && this.description.startsWith("Series")) {
            String dp = Functions.substr(majorRevision, 0, 1);
            String fp = "fp" + Functions.substr(majorRevision, 2, 1);
            if (Functions.substr(majorRevision, -2).toLowerCase().equals("le")) {
                fp = "le";
            }
            if (!Functions.isEmpty(dp)) {
                majorRevision = String.valueOf(dp) + "ed_" + fp;
                minorRevision = "";
            }
        }
        retArray.add(this.entitytype);
        retArray.add(this.category);
        retArray.add(this.description);
        retArray.add(subclass);
        retArray.add(majorRevision);
        retArray.add(minorRevision);
        retArray.add(connection);
        retArray.add(build);
        String retStr = Functions.implode(":", retArray);
        return retStr;
    }

    public static EntityCore getEntityFromDescriptor(String descriptor) throws DetectRightException, ConnectionLostException {
        return EntityCore.getEntityFromDescriptor(descriptor, true, true);
    }

    static EntityCore getEntityFromDescriptor(String descriptor, boolean allowAdd) throws DetectRightException, ConnectionLostException {
        return EntityCore.getEntityFromDescriptor(descriptor, allowAdd, true);
    }

    static EntityCore getEntityFromDescriptor(String descriptor, boolean allowAdd, boolean fuzzy) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(descriptor)) {
            return null;
        }
        LinkedHashMap<String, String> parse = EntityCore.parseEntityDescriptor(descriptor);
        String et = (String)Functions.gv(parse, "entitytype");
        String cat = (String)Functions.gv(parse, "category");
        String desc = (String)Functions.gv(parse, "description");
        String majorrevision = (String)Functions.gv(parse, "majorrevision");
        String minorrevision = (String)Functions.gv(parse, "minorrevision");
        DBLink dbl = dbLink.get();
        if (dbl == null) {
            EntityCore.checkDB();
            dbl = dbLink.get();
            if (dbl == null) {
                throw new ConnectionLostException("Connection to DB Lost");
            }
        }
        majorrevision = dbl.arrayFilter("invalidrev", majorrevision);
        majorrevision = majorrevision.trim();
        if ((desc = desc.trim()).startsWith("-") || desc.startsWith("_")) {
            desc = Functions.substr(desc, 1);
        }
        if (desc.contains(")") && !desc.contains("(")) {
            String test = Functions.explode(")", desc).get(0).toString();
            if (Functions.isEmpty(test)) {
                return null;
            }
            desc = test.trim();
        }
        desc = desc.trim();
        desc = Functions.str_replace("_", " ", desc);
        EntityCore entity = EntityCore.getEntityFromCatDesc(cat, desc, et, fuzzy);
        if (allowAdd && entity == null) {
            String hash = EntityCore.makeHash(et, cat, desc);
            entity = EntityCore.addEntity(et, cat, desc, hash);
        } else if (entity == null) {
            DetectRight.setError("Entity doesn't exist");
            return null;
        }
        if (entity != null) {
            entity.majorrevision = majorrevision;
            entity.subclass = Functions.gv(parse, "subclass", "").toString();
            entity.minorrevision = minorrevision;
            entity.build = Functions.gv(parse, "build", "").toString();
            entity.connection = Functions.gv(parse, "connection", "").toString();
        }
        return entity;
    }

    LinkedHashMap<String, Object> toArray() {
        return Functions.objectToArray(this);
    }

    public void generateSearchStrings() {
        String cleanCat = Functions.nn(this.category);
        String cleanDesc = Functions.nn(this.description);
        this.catDescSearch = Functions.punctClean(String.valueOf(cleanCat) + cleanDesc);
        this.descSearch = Functions.punctClean(cleanDesc);
        this.postPart = EntityCore.postPart(cleanDesc);
        this.prePart = EntityCore.prePart(cleanDesc);
    }

    public static String postPart(String description) {
        if (description == null) {
            return "";
        }
        ArrayList<String> tmp = Functions.explode("-", description);
        if (tmp.size() > 1) {
            return tmp.get(tmp.size() - 1).toString();
        }
        tmp = Functions.explode(" ", description);
        if (tmp.size() > 1) {
            return tmp.get(tmp.size() - 1).toString();
        }
        return "";
    }

    public static String prePart(String description) {
        if (description == null) {
            return "";
        }
        ArrayList<String> tmp = Functions.explode("-", description);
        if (tmp.size() > 1) {
            return tmp.get(0).toString();
        }
        tmp = Functions.explode(" ", description);
        if (tmp.size() > 1) {
            return tmp.get(0).toString();
        }
        return "";
    }

    boolean commit() {
        return true;
    }

    String description() {
        return String.valueOf(this.entitytype) + ":" + this.category + ":" + this.description + " (status: " + this.status + ")";
    }

    boolean isDescriptorCompatible(String descriptor) throws DetectRightException {
        if (descriptor == null) {
            return false;
        }
        return this.isDescriptorCompatible(descriptor, false);
    }

    boolean isDescriptorCompatible(String descriptor, boolean strict) throws DetectRightException {
        if (descriptor == null) {
            return false;
        }
        LinkedHashMap<String, String> ed = EntityCore.parseEntityDescriptor(descriptor);
        return this.isDescriptorCompatible(ed, strict);
    }

    boolean isDescriptorCompatible(LinkedHashMap<String, String> descriptor) {
        if (descriptor == null) {
            return false;
        }
        return this.isDescriptorCompatible(descriptor, false);
    }

    boolean isDescriptorCompatible(LinkedHashMap<String, String> ed, boolean strict) {
        if (ed == null) {
            return false;
        }
        if (!Functions.nn(ed.get("entitytype")).equals(this.entitytype)) {
            return false;
        }
        if (!Functions.nn(ed.get("category")).equals(this.category)) {
            return false;
        }
        if (!Functions.nn(ed.get("description")).equals(this.description)) {
            return false;
        }
        String subclass = Functions.nn(ed.get("subclass"));
        String majorrevision = Functions.nn(ed.get("majorrevision"));
        String build = Functions.nn(ed.get("build"));
        String minorrevision = Functions.nn(ed.get("minorrevision"));
        if (strict && !Functions.isEmpty(this.minorrevision) && minorrevision.compareTo(this.minorrevision) > 1) {
            return false;
        }
        if (Functions.isEmpty(this.subclass) ? !Functions.isEmpty(subclass) : !Functions.isEmpty(subclass) && !this.subclass.equals(subclass) || Functions.isEmpty(subclass) && !Functions.isEmpty(majorrevision) && !majorrevision.equals("1.0") && !majorrevision.contains("100")) {
            return false;
        }
        if (Functions.isEmpty(this.build) ? !Functions.isEmpty(build) : !Functions.isEmpty(build) && !this.build.equals(build)) {
            return false;
        }
        boolean include = false;
        String fallback = this.revisionfallback;
        String tmr = this.majorrevision;
        String pmr = majorrevision;
        boolean isProfileEmpty = Functions.isEmpty(pmr);
        boolean isEntityEmpty = Functions.isEmpty(tmr) & isProfileEmpty;
        if (isEntityEmpty) {
            return true;
        }
        if (tmr.equals(pmr)) {
            return true;
        }
        int tpos = Functions.strpos(tmr, ".");
        int ppos = Functions.strpos(pmr, ".");
        if (tpos > -1 && ppos > -1) {
            ArrayList<String> dpa = Functions.dpAlign(tmr, pmr);
            tmr = dpa.get(0);
            pmr = dpa.get(1);
        }
        if (!fallback.equals("discrete")) {
            if (fallback.equals("fallback")) {
                if (isProfileEmpty) {
                    include = true;
                }
                if (!include && Functions.strpos(tmr, pmr) == 0) {
                    include = true;
                }
                boolean isProfileNumeric = Functions.isNumeric(pmr);
                boolean isEntityNumeric = Functions.isNumeric(tmr);
                Double pmrNumeric = null;
                Double tmrNumeric = null;
                ArrayList<Object> tmp = new ArrayList();
                try {
                    if (isProfileNumeric) {
                        tmp = Functions.explode(".", pmr);
                        if (Functions.isEmpty(tmp.get(0))) {
                            tmp.set(0, "0");
                        }
                        String tmpPMR = (String)Functions.array_shift(tmp);
                        if (tmp.size() > 0) {
                            tmpPMR = String.valueOf(tmpPMR) + "." + Functions.implode("", tmp);
                        }
                        pmrNumeric = Double.parseDouble(tmpPMR);
                    }
                    if (isEntityNumeric) {
                        tmp = Functions.explode(".", tmr);
                        if (Functions.isEmpty(tmp.get(0))) {
                            tmp.set(0, "0");
                        }
                        String tmpTMR = (String)Functions.array_shift(tmp);
                        if (tmp.size() > 0) {
                            tmpTMR = String.valueOf(tmpTMR) + "." + Functions.implode("", tmp);
                        }
                        tmrNumeric = Double.parseDouble(tmpTMR);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (isEntityEmpty && isProfileNumeric) {
                    include = false;
                } else if (tmrNumeric != null && pmrNumeric != null && pmrNumeric <= tmrNumeric) {
                    include = true;
                } else if (Functions.stripos(pmr, String.valueOf(tmr) + ".") == 0) {
                    include = true;
                } else if (tmr.equals(pmr)) {
                    include = true;
                }
            } else if (isProfileEmpty) {
                include = true;
            } else if (isEntityEmpty) {
                include = false;
            } else if (Functions.strpos(tmr, pmr) == 0) {
                include = true;
            }
        }
        return include;
    }

    public boolean isMobile() throws DetectRightException, ConnectionLostException {
        ArrayList<EntityCore> contains = new ArrayList<EntityCore>();
        EntitySigCollection esc = DetectRight.getLastDetection();
        if (esc != null && esc.entities != null) {
            contains = esc.entities;
        }
        return this.isMobile(contains);
    }

    public boolean isMobile(ArrayList<EntityCore> contains) throws DetectRightException, ConnectionLostException {
        double uaImportance;
        EntitySigCollection esc;
        if (contains == null) {
            contains = new ArrayList();
        }
        String ua = this.description;
        if (!this.entitytype.equals("UserAgent") && this.status > 0 && !this.category.equals("Generic")) {
            HTTPHeadersCore headers = DetectRight.getLastHeaders();
            if (headers != null) {
                ua = headers.ua;
            }
            boolean doBool = true;
            DBLink dbl = dbLink.get();
            if (!Functions.isEmpty(ua)) {
                if (dbl == null) {
                    throw new ConnectionLostException("Entity lost connection at isMobile");
                }
                ArrayList<String> md = dbl.getArrayListString("MobileDisqualifiers");
                if (!Functions.isEmpty(md)) {
                    for (String token : md) {
                        if (Functions.isEmpty(token) || Functions.strpos(ua, token) <= -1) continue;
                        doBool = false;
                        break;
                    }
                }
            }
            if (doBool) {
                if (Functions.stripos(this.entitytype, "Mobile") > -1) {
                    return true;
                }
                if (Functions.stripos(this.entitytype, "Handheld") > -1) {
                    return true;
                }
                ArrayList<String> mobileETs = null;
                ArrayList<String> nonMobileETs = null;
                mobileETs = dbl.getArrayListString("MobileEntityTypes");
                if (Functions.isEmpty(mobileETs)) {
                    mobileETs = new ArrayList();
                    mobileETs.addAll(Arrays.asList("Device", "Tablet", "e-Reader", "Reader", "PDA", "Hardware Platform", "Wristwatch"));
                }
                if (mobileETs.contains(this.entitytype)) {
                    return true;
                }
                nonMobileETs = dbl.getArrayListString("NonMobileEntityTypes");
                if (Functions.isEmpty(nonMobileETs)) {
                    nonMobileETs = new ArrayList();
                    nonMobileETs.addAll(Arrays.asList("BDP", "Smart TV", "SmartTV", "Desktop", "Netbook", "STB", "Set-Top Box", "Games Console", "Laptop", "Bot", "Emulator", "RSS", "Application", "ProgLang", "Programming Language"));
                }
                if (nonMobileETs.contains(this.entitytype)) {
                    return false;
                }
                ua = headers.ua;
            }
            if (Functions.isEmpty(ua)) {
                return false;
            }
        }
        if ((esc = DetectRight.getLastDetection()) != null && esc.entities != null) {
            contains = esc.entities;
        }
        if (Functions.isEmpty(contains)) {
            EntitySigCollection detection = Sig.detect(ua, "HTTP_USER_AGENT");
            contains = detection.entities;
        }
        return (uaImportance = EntityCore.uaImportance(ua, contains)) > 0.0;
    }

    LinkedHashMap<String, Object> getAKAs() throws DetectRightException, ConnectionLostException {
        return this.getAKAs(true, true);
    }

    LinkedHashMap<String, Object> getAKAs(boolean system) throws DetectRightException, ConnectionLostException {
        return this.getAKAs(system, true);
    }

    LinkedHashMap<String, Object> getAKAs(boolean system, boolean user) throws DetectRightException, ConnectionLostException {
        ArrayList<EntityAliasCore> eas;
        LinkedHashMap<String, Object> akas = new LinkedHashMap<String, Object>();
        ArrayList<String> status = new ArrayList<String>();
        status.add("1");
        status.add("2");
        if (DetectRight.getAccessLevel() > 8) {
            status.add("0");
        }
        if ((eas = EntityAliasCore.getAliasCollection(this.id(), status)) == null) {
            return null;
        }
        for (EntityAliasCore ea : eas) {
            String description = String.valueOf(ea.category) + " " + ea.description;
            akas.put(String.valueOf(ea.id()), description);
        }
        return akas;
    }

    void setVersion(String majorRevision, String minorRevision, String subclass, String connection, String build) {
        this.majorrevision = Functions.nn(majorRevision);
        this.minorrevision = Functions.nn(minorRevision);
        this.subclass = Functions.nn(subclass);
        this.connection = Functions.nn(connection);
        this.build = Functions.nn(build);
    }

    LinkedHashMap<String, Object> fillProfiles() throws DetectRightException, ConnectionLostException {
        DetectRight.checkPoint("Filling properties for this.category this.description");
        if (this.profiles == null) {
            return new LinkedHashMap<String, Object>();
        }
        this.profiles = EntityProfileCore.getEPsForEntity(this.id());
        DetectRight.checkPoint("Filled properties for this.category this.description");
        this.cache();
        return this.profiles;
    }

    boolean isNominative() throws ConnectionLostException, DetectRightException {
        if (Functions.isEmpty(this.entitytype)) {
            return false;
        }
        if (nominativeEntityTypes == null) {
            EntityCore.fillNET();
        }
        String entitytype = this.entitytype;
        return nominativeEntityTypes.contains(entitytype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QuantumDataTree getCachedQDT(String qdt_key) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(qdt_key)) {
            return null;
        }
        if (QDTs == null) {
            return null;
        }
        boolean containsQDT = QDTs.containsKey(qdt_key);
        if (!containsQDT) {
            return null;
        }
        Object test = QDTs.get(qdt_key);
        if (test != null && test instanceof QuantumDataTree) {
            QuantumDataTree tmpQDT = (QuantumDataTree)test;
            this.qdt = tmpQDT.clone();
            this.postProcessQDT();
            return this.qdt;
        }
        DRLRUMap dRLRUMap = QDTs;
        synchronized (dRLRUMap) {
            QDTs.remove(qdt_key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void cacheQDT(String qdt_key, QuantumDataTree qdt) throws DetectRightException {
        if (Functions.isEmpty(qdt_key)) {
            return;
        }
        if (qdt == null) {
            return;
        }
        DRLRUMap dRLRUMap = QDTs;
        synchronized (dRLRUMap) {
            if (!QDTs.containsKey(qdt_key) || DetectRight.getRedetect()) {
                QDTs.add(qdt_key, qdt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QuantumDataTree getQDT() throws DetectRightException, ConnectionLostException {
        LinkedHashMap row;
        String owner = DetectRight.getDataOwner();
        String majorrevision = Functions.nn(this.majorrevision).trim();
        String minorrevision = Functions.nn(this.minorrevision).trim();
        String subclass = Functions.nn(this.subclass).trim();
        this.connection = Functions.nn(this.connection).trim();
        this.build = Functions.nn(this.build).trim();
        ArrayList<String> array = new ArrayList<String>();
        String qdt_key = "";
        boolean compositeQDTStatus = DetectRight.compositeQDTCacheStatus();
        if (compositeQDTStatus && !DetectRight.getRedetect()) {
            array.addAll(Arrays.asList(String.valueOf(this.ID), majorrevision, subclass, this.connection, this.build, String.valueOf(Property.trustMin), owner));
            qdt_key = Functions.serialize(array);
            QuantumDataTree qdt = this.getCachedQDT(qdt_key);
            if (qdt != null) {
                return qdt.clone();
            }
        }
        String creator = new String(String.valueOf(Functions.nn(this.entitytype)) + "/" + Functions.nn(this.category) + "/" + Functions.nn(this.description)).toLowerCase();
        QuantumDataTree qdt = new QuantumDataTree(this.descriptor(), null);
        qdt.brand(creator);
        LinkedHashMap<String, Object> wc = new LinkedHashMap<String, Object>();
        wc.put("entityhash", String.valueOf(this.hash()));
        if (!owner.equals("SYSTEM")) {
            LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>();
            tmp.put("op", "in");
            ArrayList<String> owners = new ArrayList<String>();
            owners.addAll(Arrays.asList(owner, "SYSTEM"));
            tmp.put("value", owners);
            wc.put("owner", tmp);
        }
        ArrayList<LinkedHashMap> profiles = new ArrayList<LinkedHashMap>();
        String table = EntityProfileCore.table;
        LinkedHashMap<String, Object> result = null;
        if (DetectRight.getSingleDataSource()) {
            String key = Functions.md5(Functions.serialize(wc));
            DRLRUMap dRLRUMap = epRows;
            synchronized (dRLRUMap) {
                if (epRows.containsKey(key)) {
                    result = (LinkedHashMap<String, Object>)epRows.get(key);
                }
            }
            if (result == null) {
                dRLRUMap = epRows;
                synchronized (dRLRUMap) {
                    if (epRows.containsKey(key)) {
                        result = (LinkedHashMap)epRows.get(key);
                    } else {
                        result = this.db.simpleFetch(table, DBLink.allFields, wc);
                        if (result != null) {
                            epRows.put(key, result);
                        }
                    }
                }
            }
        } else {
            result = this.db.simpleFetch(table, DBLink.allFields, wc);
        }
        if (result == null) {
            DetectRight.checkPoint("Entity Profile fetch problem: null resultset");
            result = new LinkedHashMap();
        }
        LinkedHashMap<String, Object> tmpMap = result;
        for (Map.Entry entry : tmpMap.entrySet()) {
            row = (LinkedHashMap)entry.getValue();
            LinkedHashMap<String, String> ed = new LinkedHashMap<String, String>();
            if (row == null) {
                DetectRight.checkPoint("Null row being returned for entity profiles");
                continue;
            }
            ed.put("majorrevision", row.get("majorrevision").toString());
            ed.put("subclass", row.get("subclass").toString());
            ed.put("connection", row.get("connection").toString());
            ed.put("build", row.get("build").toString());
            ed.put("minorrevision", row.get("minorrevision").toString());
            ed.put("entitytype", this.entitytype);
            ed.put("category", this.category);
            ed.put("description", this.description);
            if (!this.isDescriptorCompatible(ed)) continue;
            profiles.add(row);
        }
        DetectRight.checkPoint("Doing Entity Profiles");
        for (Object e : profiles) {
            boolean isCustom;
            row = (LinkedHashMap)e;
            DetectRight.checkPoint("New Entity Profile " + row.get("ID").toString(), 4);
            EntityProfileCore profile = EntityProfileCore.getEPFromRow(row);
            if (profile == null) continue;
            DetectRight.checkPoint("Done New Entity Profile " + row.get("ID").toString(), 4);
            int nearness = 0;
            if (majorrevision.equalsIgnoreCase(profile.majorrevision) && minorrevision.equalsIgnoreCase(profile.minorrevision)) {
                nearness = !majorrevision.equals("") ? 8 : 5;
            } else if (!Functions.isEmpty(majorrevision) && majorrevision.equals(profile.majorrevision) || !Functions.isEmpty(minorrevision) && minorrevision.equals(profile.minorrevision)) {
                nearness = 7;
            } else if ((Functions.compares(majorrevision, "1", "=") || Functions.compares(majorrevision, "100", "=")) && Functions.isEmpty(profile.majorrevision)) {
                nearness = 5;
            } else if (Functions.isEmpty(majorrevision) && Functions.isEmpty(minorrevision) && Functions.isEmpty(profile.majorrevision) && Functions.isEmpty(profile.minorrevision)) {
                nearness = 5;
            } else if (!Functions.isEmpty(majorrevision) && !Functions.isEmpty(profile.majorrevision) && Functions.stripos(majorrevision, profile.majorrevision) == 0) {
                nearness = 7;
            } else if (!Functions.isEmpty(majorrevision) && !Functions.isEmpty(profile.majorrevision)) {
                try {
                    double versionDifference = Functions.parseDoubleLoose(majorrevision) - Functions.parseDoubleLoose(profile.majorrevision);
                    double vdd = Math.floor(versionDifference);
                    int vdi = (int)vdd;
                    nearness = 7 - vdi;
                }
                catch (Throwable e2) {
                    nearness = 3;
                }
            } else {
                nearness = 3;
            }
            if (nearness <= 0) continue;
            if (!Functions.isEmpty(subclass) && subclass.equals(profile.subclass)) {
                nearness += 5;
            }
            if (!Functions.isEmpty(this.connection) && !Functions.isEmpty(profile.connection)) {
                nearness = profile.connection == this.connection ? ++nearness : --nearness;
            }
            DetectRight.checkPoint("Adding QDT", 4);
            boolean bl = isCustom = !row.get("owner").toString().equals("SYSTEM");
            if (isCustom && !this.isCustom) {
                this.isCustom = true;
            }
            QuantumDataTree tmpQDT = null;
            try {
                tmpQDT = profile.getQDT();
                tmpQDT.addImportance(nearness - 5);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (tmpQDT.pkg != null && tmpQDT.pkg.size() > 0) {
                    qdt.addQDT(tmpQDT);
                } else {
                    qdt.subsume(tmpQDT);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            DetectRight.checkPoint("Added QDT", 4);
        }
        DetectRight.checkPoint("Done Entity Profiles");
        qdt.setDescriptor(this.descriptor());
        qdt.entityid = this.ID;
        DetectRight.checkPoint("Cleaning QDT", 4);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList("Browser", "Developer Platform", "OS"));
        if (arrayList.contains(this.entitytype) && compositeQDTStatus) {
            EntityCore.cacheQDT(qdt_key, qdt.clone());
        }
        this.qdt = qdt;
        this.postProcessQDT();
        return this.qdt;
    }

    void postProcessQDT() throws DetectRightException, ConnectionLostException {
        DetectRight.checkPoint("Postprocessing QDT");
        String descriptor = this.descriptor();
        ArrayList<String> pkg = new ArrayList<String>();
        pkg.add("System//" + descriptor + "//status=1");
        this.qdt.addPackage(pkg, 999, descriptor);
    }

    String cacheKey() throws DetectRightException {
        return EntityCore.getCacheKey(this.id());
    }

    void cache() throws DetectRightException {
        this.cache(0, true);
    }

    void cache(int timeout) throws DetectRightException {
        this.cache(timeout, true);
    }

    void cache(int timeout, boolean overwrite) throws DetectRightException {
        if (!useCache) {
            return;
        }
        if (timeout == 0) {
            timeout = cache_timeout;
        }
        if (this.id() == 0L) {
            return;
        }
        if (!overwrite && this.cached) {
            return;
        }
        this.cached = true;
        this.cache.cache_set(this.cacheKey(), this, timeout);
    }

    public static String makeHash(String entitytype, String category, String description) throws DetectRightException {
        String hash = Functions.md5(new String(String.valueOf(entitytype) + "/" + category + "/" + description).toLowerCase());
        return hash;
    }

    static LinkedHashMap<String, String> parseEntityDescriptor(String string) throws DetectRightException {
        if (string == null) {
            return new LinkedHashMap<String, String>();
        }
        LinkedHashMap<String, String> retArray = new LinkedHashMap<String, String>();
        ArrayList<String> tmpPad = Functions.explode(":", string);
        while (tmpPad.size() < 8) {
            tmpPad.add("");
        }
        retArray.put("entitytype", DetectRight.unescapeDescriptor(tmpPad.get(0)));
        retArray.put("category", DetectRight.unescapeDescriptor(tmpPad.get(1)));
        if (!((String)retArray.get("entitytype")).toString().equals("UserAgent")) {
            retArray.put("description", DetectRight.unescapeDescriptor(tmpPad.get(2)));
            retArray.put("subclass", DetectRight.unescapeDescriptor(tmpPad.get(3)));
            retArray.put("majorrevision", DetectRight.unescapeDescriptor(tmpPad.get(4)));
            retArray.put("minorrevision", DetectRight.unescapeDescriptor(tmpPad.get(5)));
            retArray.put("connection", DetectRight.unescapeDescriptor(tmpPad.get(6)));
            retArray.put("build", DetectRight.unescapeDescriptor(tmpPad.get(7)));
        } else {
            int size = tmpPad.size() - 1;
            List<String> descArray = tmpPad.subList(2, size);
            String description = Functions.implode(":", descArray);
            while (description.endsWith(":")) {
                description = Functions.substr(description, 0, -1);
            }
            retArray.put("description", DetectRight.unescapeDescriptor(description));
            retArray.put("subclass", "");
            retArray.put("majorrevision", "");
            retArray.put("minorrevision", "");
            retArray.put("connection", "");
        }
        if (DetectRight.getAccessLevel() > 8) {
            LinkedHashMap<String, String> etMap = new LinkedHashMap<String, String>();
            etMap.put("D", "Device");
            etMap.put("HP", "Hardware Platform");
            etMap.put("DP", "Developer Platform");
            etMap.put("B", "Browser");
            if (etMap.containsKey(retArray.get("entitytype"))) {
                retArray.put("entitytype", (String)etMap.get(retArray.get("entitytype")));
            }
        }
        return retArray;
    }

    static String getCacheKey(long id) throws DetectRightException {
        return DetectRight.cacheKey("drEntity_" + DetectRight.getDataOwner() + "_" + String.valueOf(id));
    }

    static ArrayList<String> getEntityTypes() throws DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Object> orderBy = new LinkedHashMap<String, Object>();
        orderBy.put("entitytype", "ASC");
        DBLink dbl = dbLink.get();
        if (dbl == null) {
            throw new ConnectionLostException("Connection to DB Lost");
        }
        ArrayList<String> types = dbl.getIDs(table, "entitytype", DBLink.emptyHash, orderBy, DBLink.emptyHash, "select distinct");
        return types;
    }

    static ArrayList<String> getCategories(String entitytypes) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(entitytypes)) {
            entitytypes = "Device,Hardware Platform,Tablet";
        }
        return EntityCore.getCategories(entitytypes, false);
    }

    static ArrayList<String> getCategories(String entitytypes, boolean unlimited) throws DetectRightException, ConnectionLostException {
        ArrayList<String> ets = Functions.explode(",", entitytypes);
        return EntityCore.getCategories(ets, unlimited);
    }

    static ArrayList<String> getCategories(ArrayList<String> entitytypes) throws DetectRightException, ConnectionLostException {
        return EntityCore.getCategories(entitytypes, false);
    }

    static ArrayList<String> getCategories(ArrayList<String> entitytypes, boolean unlimited) throws DetectRightException, ConnectionLostException {
        Object retObj;
        Cache cl;
        if (entitytypes == null) {
            entitytypes = Functions.explode(",", "Device,Hardware Platform,Tablet");
        }
        if (unlimited && DetectRight.getAccessLevel() < 9) {
            unlimited = false;
        }
        String key = "DRCategories";
        if (unlimited) {
            key = key.concat("_unlimited");
        }
        key = DetectRight.cacheKey(key);
        boolean redetect = DetectRight.getRedetect();
        if (!redetect && (cl = cacheLink.get()) != null && (retObj = cl.cache_get(key)) instanceof ArrayList) {
            return (ArrayList)retObj;
        }
        LinkedHashMap<String, Object> where = new LinkedHashMap<String, Object>();
        where.put("op", "in");
        where.put("value", entitytypes);
        if (!unlimited) {
            where.put("status", 1);
        }
        LinkedHashMap<String, String> hm = new LinkedHashMap<String, String>();
        hm.put("op", "<>");
        hm.put("value", "");
        where.put("category", hm);
        LinkedHashMap<String, Object> orderBy = new LinkedHashMap<String, Object>();
        orderBy.put("category", "ASC");
        DBLink dbl = dbLink.get();
        if (dbl == null) {
            throw new ConnectionLostException("Problem getting categories");
        }
        ArrayList<String> retArray = dbl.getIDs(table, "category", where, orderBy, DBLink.emptyHash, "select distinct");
        Cache cl2 = cacheLink.get();
        if (cl2 != null) {
            cl2.cache_set(key, retArray, cache_timeout);
        }
        return retArray;
    }

    static LinkedHashMap<String, String> getDescriptions(String category) throws DetectRightException, ConnectionLostException {
        ArrayList<String> et = new ArrayList<String>();
        return EntityCore.getDescriptions(category, false, et);
    }

    static LinkedHashMap<String, String> getDescriptions(String category, boolean unlimited) throws DetectRightException, ConnectionLostException {
        ArrayList<String> et = new ArrayList<String>();
        return EntityCore.getDescriptions(category, unlimited, et);
    }

    static LinkedHashMap<String, String> getDescriptions(String category, boolean unlimited, String entitytypes) throws DetectRightException, ConnectionLostException {
        ArrayList<String> et = new ArrayList<String>();
        if (!Functions.isEmpty(entitytypes)) {
            et = Functions.explode(",", entitytypes);
        }
        return EntityCore.getDescriptions(category, unlimited, et);
    }

    static LinkedHashMap<String, String> getDescriptions(String category, boolean unlimited, ArrayList<String> entitytypes) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(category)) {
            return new LinkedHashMap<String, String>();
        }
        if (entitytypes == null) {
            entitytypes = new ArrayList();
        }
        if (entitytypes.size() == 0) {
            entitytypes.addAll(nominativeEntityTypes);
        }
        LinkedHashMap<String, Object> where = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>();
        tmp.put("op", "in");
        tmp.put("value", entitytypes);
        where.put("entitytype", tmp);
        if (!unlimited) {
            where.put("status", "1");
        }
        where.put("category", category);
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        fields.put("0", "hash");
        fields.put("1", "description");
        LinkedHashMap<String, Object> orderBy = new LinkedHashMap<String, Object>();
        orderBy.put("description", "ASC");
        DBLink dbl = dbLink.get();
        if (dbl == null) {
            throw new ConnectionLostException("Connection lost getting descriptions");
        }
        LinkedHashMap<String, Object> result = dbl.simpleFetch(table, fields, where, orderBy, DBLink.emptyHash, "hash");
        if (result == null) {
            throw new DetectRightException("Couldn't get descriptions from database", null);
        }
        LinkedHashMap<String, Object> tmpMap = result;
        LinkedHashMap<String, String> output = new LinkedHashMap<String, String>();
        for (Map.Entry entry : tmpMap.entrySet()) {
            LinkedHashMap row;
            String key = (String)entry.getKey();
            if (key == null || (row = (LinkedHashMap)entry.getValue()) == null) continue;
            output.put(key, row.get("description").toString());
        }
        return output;
    }

    static ArrayList<String> getIDs(String entitytypes) throws DetectRightException, ConnectionLostException {
        return EntityCore.getIDs(entitytypes, -1, false);
    }

    static ArrayList<String> getIDs(String entitytypes, String status) throws DetectRightException, ConnectionLostException {
        int statusInt;
        try {
            statusInt = Functions.parseInt(status);
        }
        catch (Throwable e) {
            statusInt = -1;
        }
        return EntityCore.getIDs(entitytypes, statusInt, false);
    }

    static ArrayList<String> getIDs(String entitytypes, int status, boolean returnHash) throws DetectRightException, ConnectionLostException {
        ArrayList<String> ets = Functions.explode(",", entitytypes);
        ArrayList<Integer> arr = new ArrayList<Integer>();
        if (status > -1) {
            arr.add(status);
        }
        return EntityCore.getIDs(ets, arr, returnHash);
    }

    static ArrayList<String> getIDs(ArrayList<String> entitytypes, ArrayList<Integer> status, boolean returnHash) throws DetectRightException, ConnectionLostException {
        DBLink dbl;
        String returnField = !returnHash ? PK : "hash";
        LinkedHashMap<String, Object> where = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>();
        tmp.put("op", "in");
        tmp.put("value", entitytypes);
        where.put("entitytype", tmp);
        if (status.size() > 0) {
            LinkedHashMap<String, Object> tmp2 = new LinkedHashMap<String, Object>();
            tmp2.put("op", "in");
            tmp2.put("value", status);
            where.put("status", tmp2);
        }
        if ((dbl = dbLink.get()) == null) {
            throw new ConnectionLostException("Lost connection getting entity ids");
        }
        return dbl.getIDs(table, returnField, where);
    }

    static EntityCore getEntityFromCatDesc(String category, String description) throws DetectRightException, ConnectionLostException {
        return EntityCore.getEntityFromCatDesc(category, description, "", true);
    }

    static EntityCore getEntityFromCatDesc(String category, String description, String entityType) throws DetectRightException, ConnectionLostException {
        return EntityCore.getEntityFromCatDesc(category, description, entityType, true);
    }

    static EntityCore getEntityFromCatDesc(String category, String description, String entityType, boolean heuristics) throws DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Object> orderBy;
        LinkedHashMap<String, Object> whereTmp;
        String testHash;
        EntityCore entity;
        DBLink dbl;
        if (category == null) {
            category = "";
        }
        if (description == null) {
            description = "";
        }
        if (entityType == null) {
            entityType = "";
        }
        if ((dbl = dbLink.get()) == null) {
            throw new ConnectionLostException("Lost Connection to db");
        }
        if (Functions.isEmpty(entityType) && category.equals("Browser")) {
            entityType = "Browser";
        }
        ArrayList<String> et = new ArrayList<String>();
        if (!Functions.isEmpty(entityType)) {
            et.add(entityType);
        } else {
            entityType = "Device";
            et.addAll(nominativeEntityTypes);
        }
        boolean fuzzyUsed = false;
        if (category.toLowerCase().equals("blackberry")) {
            description = "BlackBerry " + description;
            category = "RIM";
        }
        if (category.toLowerCase().equals("spv")) {
            description = "spv " + description;
            category = "Orange";
        }
        if (((entity = EntityCore.get(0L, testHash = EntityCore.makeHash(entityType, category, description))) == null || entity.id() == 0L) && Functions.strpos(description, "_") > -1) {
            testHash = EntityCore.makeHash(entityType, category, Functions.str_replace("_", " ", description));
            entity = EntityCore.get(testHash);
        }
        if ((entity == null || entity.id() == 0L) && Functions.strpos(description, " ") > -1) {
            String testHash2 = EntityCore.makeHash(entityType, category, Functions.str_replace(" ", "", description));
            entity = EntityCore.get(testHash2);
        }
        if (entity == null || entity.id() == 0L) {
            EntityAliasCore alias = EntityAliasCore.getEntityAliasFromHash(testHash);
            if (alias.entityid > 0L) {
                entity = EntityCore.get(alias.entityid);
                if (entity == null || entity.id() == 0L) {
                    entity = EntityCore.getEntityFromHash(alias.entityhash);
                }
                if (entity != null) {
                    entity.majorrevision = alias.majorrevision;
                    entity.subclass = alias.subclass;
                }
            }
        }
        if (entity != null && entity.id() > 0L) {
            return entity;
        }
        LinkedHashMap<String, Object> where = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> etWhere = new LinkedHashMap<String, Object>();
        etWhere.put("op", "in");
        etWhere.put("value", et);
        where.put("category", category);
        where.put("description", description);
        where.put("entitytype", etWhere);
        if (entityType.equals("UserAgent") || !heuristics) {
            ArrayList<String> result = dbl.getIDs(table, PK, where);
            if (result == null) {
                return null;
            }
            if (result.size() == 0) {
                entity = EntityCore.addEntity(entityType, category, description, testHash);
            } else {
                long entityid = Long.parseLong(Functions.array_shift(result).toString());
                entity = EntityCore.getEntity(entityid);
            }
            if (entity == null) {
                return null;
            }
            return entity;
        }
        ArrayList<String> knownCategoryTypes = new ArrayList<String>(Arrays.asList("Browser", "OS", "Chipset"));
        ArrayList<String> knownManufacturers = new ArrayList<String>();
        knownManufacturers.addAll(Arrays.asList("Nokia", "Sony Ericsson", "LG", "Motorola", "HTC", "Samsung", "RIM", "Sanyo", "Fujitsu", "Lenovo", "Audiovox", "Philips", "Grundig", "Mitsubishi", "O2", "Orange", "Vodafone", "Symbian", "Opera", "Openwave", "Alcatel", "NTT DoCoMo", "Google"));
        if (Functions.isEmpty(category) || Functions.isEmpty(description)) {
            return null;
        }
        category = category.trim();
        if (Functions.isEmpty(entityType)) {
            entityType = "Device";
        }
        ArrayList<String> delim = new ArrayList<String>();
        delim.addAll(Arrays.asList("\t", "\n", "\r"));
        category = Functions.str_replace(delim, "", category);
        description = description.trim();
        description = Functions.str_replace(delim, "", description);
        if (!knownCategoryTypes.contains(category) && !knownManufacturers.contains(category)) {
            category = Validator.translation(category, "Manufacturer");
        }
        if (Functions.isEmpty(description)) {
            return null;
        }
        ArrayList<Object> entities = dbl.getIDs(table, PK, where, DBLink.emptyHash, DBLink.limitMap(1));
        if (Functions.isEmpty(entities)) {
            String catDescSearch = Functions.punctClean(String.valueOf(category) + description);
            where = DBLink.whereClause("catDescSearch", catDescSearch);
            if (!Functions.isEmpty(entityType)) {
                where.put("entitytype", entityType);
            }
            entities = dbl.getIDs(table, PK, where, DBLink.emptyHash, DBLink.limitMap(1));
        }
        if (Functions.isEmpty(entities)) {
            entities = EntityAliasCore.getEntities(where, 1);
        }
        String cleanDesc = "";
        String entityTypeEnc = "";
        if (entities.size() == 0) {
            entityTypeEnc = dbl.escape_string(entityType);
            cleanDesc = Functions.punctClean(description);
            if (Functions.strlen(cleanDesc) < 3) {
                cleanDesc = "";
            }
            if (!Functions.isEmpty(cleanDesc)) {
                whereTmp = DBLink.whereClause("postPart", cleanDesc);
                whereTmp.put("category", category);
                orderBy = new LinkedHashMap();
                orderBy.put("expression", "(entitytype='" + entityTypeEnc + "') DESC");
                entities = dbl.getIDs(table, PK, whereTmp, orderBy, DBLink.limitMap(1));
                if (!Functions.isEmpty(entities)) {
                    fuzzyUsed = true;
                }
            }
        }
        if (entities.size() == 0 && !Functions.isEmpty(cleanDesc)) {
            whereTmp = DBLink.whereClause("prePart", cleanDesc);
            whereTmp.put("category", category);
            orderBy = new LinkedHashMap<String, Object>();
            orderBy.put("expression", "(entitytype='" + entityTypeEnc + "') DESC");
            entities = dbl.getIDs(table, PK, whereTmp, orderBy, DBLink.limitMap(1));
            if (!Functions.isEmpty(entities)) {
                fuzzyUsed = true;
            }
        }
        for (Object entityIDStr : entities) {
            if (entityIDStr == null) continue;
            long entityid = 0L;
            try {
                entityid = Long.parseLong(entityIDStr.toString());
            }
            catch (Exception e) {
                break;
            }
            entity = EntityCore.getEntity(entityid);
            if (!fuzzyUsed || entity == null || Functions.substr(entity.category, 0, 2).equalsIgnoreCase(Functions.substr(category, 0, 2))) break;
            entity = null;
            break;
        }
        if (entity == null || entity.id() == 0L) {
            if (DetectRight.getLOG()) {
                Functions.dr_echo("Adding entity\n");
            }
            entity = EntityCore.addEntity(entityType, category, description, testHash);
            if (DetectRight.getLOG()) {
                Functions.dr_echo("New Entity: category description");
            }
        }
        if (entity != null) {
            return entity;
        }
        return null;
    }

    static EntityCore addEntity(String entityType, String category, String description) throws DetectRightException, ConnectionLostException {
        String hash = EntityCore.makeHash(entityType, category, description);
        return EntityCore.addEntity(entityType, category, description, hash);
    }

    static EntityCore addEntity(String entityType, String category, String description, String hash) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(entityType)) {
            return null;
        }
        if (Functions.isEmpty(category)) {
            return null;
        }
        if (Functions.isEmpty(description)) {
            return null;
        }
        EntityCore entity = new EntityCore();
        entity.entitytype = entityType;
        entity.category = category;
        entity.description = description;
        entity.hash = hash;
        entity.owner = DetectRight.getDataOwner();
        entity.ID = 0L;
        if (nominativeEntityTypes == null) {
            EntityCore.fillNET();
        }
        entity.exclusivity = !Functions.in_array((Object)entityType, nominativeEntityTypes) ? 0 : 2;
        entity.status = 2;
        return entity;
    }

    static LinkedHashMap<String, Object> getExportProfileForManModel(String schema, String entitytype, String category, String description) throws DetectRightException, ConnectionLostException {
        return EntityCore.getExportProfileForManModel(schema, entitytype, category, description, "", 0L);
    }

    static LinkedHashMap<String, Object> getExportProfileForManModel(String schema, String entitytype, String category, String description, String hash) throws DetectRightException, ConnectionLostException {
        return EntityCore.getExportProfileForManModel(schema, entitytype, category, description, hash, 0L);
    }

    static LinkedHashMap<String, Object> getExportProfileForManModel(String schema, String entitytype, String category, String description, String hash, long ID) throws DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        EntityCore entity = EntityCore.findEntity(entitytype, category, description, hash, ID);
        if (entity == null) {
            return output;
        }
        ArrayList<String> schemas = Functions.explode(",", schema);
        for (String schemaToUse : schemas) {
            LinkedHashMap<String, Object> result = entity.getExportProfile(schemaToUse);
            if (result == null) continue;
            if (result.containsKey("audit")) {
                result.remove("audit");
            }
            output.putAll(result);
        }
        return output;
    }

    LinkedHashMap<String, Object> getExportProfile(String schema) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(schema)) {
            return null;
        }
        EntitySigCollection esc = new EntitySigCollection();
        esc.addEntity(this);
        return esc.getExportProfile(schema);
    }

    static EntityCore findEntity(String entitytype, String category, String description, String hash, long ID) throws DetectRightException, ConnectionLostException {
        if (ID > 0L) {
            return new EntityCore(ID);
        }
        if (!Functions.isEmpty(hash)) {
            return new EntityCore(hash);
        }
        return EntityCore.getEntityFromCatDesc(category, description, entitytype, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    static EntityCore getEntity(long id) throws DetectRightException, ConnectionLostException {
        Object tmpObj;
        Cache cl;
        DetectRight.checkPoint("Asked for Entity " + String.valueOf(id));
        EntityCore entity = null;
        if (!DetectRight.getRedetect() && Cache.useCache && (cl = cacheLink.get()) != null && (tmpObj = cl.cache_get(EntityCore.getCacheKey(id))) instanceof EntityCore) {
            DetectRight.checkPoint("Served Entity " + String.valueOf(id) + " from memcache");
            entity = (EntityCore)tmpObj;
            entity.cached = true;
        }
        if (entity != null) {
            DetectRight.checkPoint("Served Entity " + entity.ID + " from cache");
            return entity;
        }
        entity = new EntityCore(id);
        DetectRight.checkPoint("Returned entity " + entity.descriptor() + " has ID " + String.valueOf(entity.ID));
        if (entity.id() > 0L) {
            entity.cache();
            return entity;
        }
        DetectRight.checkPoint("Failed to get entity " + String.valueOf(id));
        return null;
    }

    static EntityCore get(long id) throws DetectRightException, ConnectionLostException {
        return EntityCore.get(id, "");
    }

    static EntityCore get(String hash) throws DetectRightException, ConnectionLostException {
        return EntityCore.get(0L, hash);
    }

    static EntityCore get(long id, String hash) throws DetectRightException, ConnectionLostException {
        if (id > 0L) {
            return EntityCore.getEntity(id);
        }
        return EntityCore.getEntityFromHash(hash);
    }

    public static EntityCore getEntityFromHash(String hash) throws DetectRightException, ConnectionLostException {
        if (hash == null) {
            return new EntityCore();
        }
        if (Functions.isEmpty(hash)) {
            return new EntityCore();
        }
        EntityCore entity = new EntityCore(0L, hash);
        if (!Functions.isEmpty(entity.error)) {
            EntityAliasCore alias = EntityAliasCore.getEntityAliasFromHash(hash);
            if (alias != null && alias.ID > 0L) {
                entity = new EntityCore(alias.entityid);
                entity.majorrevision = alias.majorrevision;
                entity.subclass = alias.subclass;
                entity.alias = alias;
            }
            if (alias != null) {
                ERROR = alias.error;
            }
        }
        return entity;
    }

    static void checkDB() throws DetectRightException, ConnectionLostException {
        DBLink dbl;
        if (cacheLink.get() == null) {
            cacheLink.set(DetectRight.getCacheLink());
        }
        if ((dbl = dbLink.get()) == null || dbl.db == null) {
            dbLink.set(DetectRight.getDBLink());
        }
    }

    void cacheDB() throws DetectRightException, ConnectionLostException {
        if (cacheLink.get() == null) {
            cacheLink.set(DetectRight.getCacheLink());
        }
        this.cache = cacheLink.get();
        DBLink dbl = dbLink.get();
        if (dbl == null || dbl.db == null) {
            dbLink.set(DetectRight.getDBLink());
        }
        this.db = dbl;
        if (this.db == null) {
            throw new ConnectionLostException("Lost connection to database");
        }
        EntityCore.fillNET();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fillNET() throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(nominativeEntityTypes)) {
            if (nominativeEntityTypes == null) {
                ReentrantLock lock;
                ReentrantLock reentrantLock = lock = new ReentrantLock();
                synchronized (reentrantLock) {
                    nominativeEntityTypes = new ArrayList();
                }
            }
            ArrayList<String> arrayList = nominativeEntityTypes;
            synchronized (arrayList) {
                LinkedHashMap<String, Object> lhm = null;
                DBLink dbl = dbLink.get();
                if (dbl == null) {
                    throw new ConnectionLostException("Lost connection to database");
                }
                try {
                    lhm = dbl.getArray("NominativeEntityTypes");
                    nominativeEntityTypes = Functions.array_values_string(lhm);
                }
                catch (DetectRightException e) {
                    throw e;
                }
                catch (ConnectionLostException e) {
                    throw e;
                }
            }
        }
    }

    void __wakeup() throws DetectRightException, ConnectionLostException {
        this.cacheDB();
    }

    ArrayList<String> __sleep() {
        LinkedHashMap<String, Object> ov = Reflection.get_object_vars(this);
        ov.remove("cache");
        ov.remove("db");
        return Functions.array_keys_string(ov);
    }

    static LinkedHashMap<String, Object> total() throws DetectRightException, ConnectionLostException {
        LinkedHashMap<Object, Object> result = new LinkedHashMap();
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        DBLink dbl = dbLink.get();
        if (dbl == null) {
            throw new ConnectionLostException("Lost connection in entitycore.total");
        }
        result = dbl.fillArrayFromSQL("select entitytype,count(*) as cnt from entity group by entitytype", "entitytype");
        if (result == null) {
            throw new DetectRightException("Can't get entity totals", null);
        }
        LinkedHashMap<Object, Object> tmpMap = result;
        for (Map.Entry entry : tmpMap.entrySet()) {
            LinkedHashMap array;
            String entitytype = (String)entry.getKey();
            if (entitytype == null || (array = (LinkedHashMap)entry.getValue()) == null) continue;
            output.put(entitytype, array.get("cnt"));
        }
        return output;
    }

    public static double uaImportance(String ua, ArrayList<EntityCore> entities) throws DetectRightException, ConnectionLostException {
        String marker;
        if (Functions.isEmpty(ua)) {
            return 0.0;
        }
        double importance = 0.0;
        double totalPossibleScore = 0.0;
        EntityCore os = null;
        EntityCore dp = null;
        EntityCore browser = null;
        if (entities == null) {
            entities = new ArrayList();
        }
        for (EntityCore entity : entities) {
            if (entity.entitytype.equals("OS")) {
                os = entity;
                continue;
            }
            if (entity.entitytype.equals("Browser") || entity.entitytype.equals("Mobile Browser")) {
                browser = entity;
                continue;
            }
            if (!entity.entitytype.equals("Developer Platform")) continue;
            dp = entity;
        }
        DBLink dbLink = EntityCore.dbLink.get();
        if (dbLink == null) {
            throw new ConnectionLostException("Lost connection, can't get mobile markers");
        }
        LinkedHashMap<String, Object> markers = dbLink.getArray("mobile_markers");
        if (markers == null) {
            return 0.0;
        }
        ArrayList<String> markerKeys = Functions.array_keys_string(markers);
        totalPossibleScore += (double)markers.size() * 10.0;
        for (String markerKey : markerKeys) {
            marker = (String)markers.get(markerKey);
            if (Functions.stripos(ua, marker) <= -1) continue;
            importance += 10.0;
        }
        markers = dbLink.getArray("non_mobile_markers");
        if (markers == null) {
            return 0.0;
        }
        markerKeys = Functions.array_keys_string(markers);
        for (String markerKey : markerKeys) {
            marker = (String)markers.get(markerKey);
            if (Functions.stripos(ua, marker) <= -1) continue;
            importance -= 10.0;
        }
        LinkedHashMap<String, Object> os_to_ignore = dbLink.getArray("ignore_os");
        if (os_to_ignore == null) {
            return 0.0;
        }
        totalPossibleScore += 15.0;
        if (os != null) {
            importance = !os_to_ignore.containsValue(os.description) ? (importance += 15.0) : (importance -= 15.0);
        }
        totalPossibleScore += 30.0;
        if (dp != null) {
            importance = dp.description != null && !dp.description.equals(".NET") ? (importance += 30.0) : (importance -= 10.0);
        }
        totalPossibleScore += 20.0;
        if (browser != null) {
            if (browser.entitytype.equals("Mobile Browser")) {
                totalPossibleScore += 30.0;
                importance += 50.0;
            } else if (browser.entitytype.equals("Browser")) {
                importance -= 20.0;
            }
        }
        return importance / totalPossibleScore * 100.0;
    }

    boolean hasProperty(String property) {
        if (property.equals("entitytype")) {
            return true;
        }
        if (property.equals("category")) {
            return true;
        }
        if (property.equals("description")) {
            return true;
        }
        if (property.equals("status")) {
            return true;
        }
        return property.equals("ID");
    }

    boolean hasMethod(String method) {
        if (method.equals("isMobile")) {
            return true;
        }
        if (method.equals("descriptor")) {
            return true;
        }
        if (method.equals("id")) {
            return true;
        }
        if (method.equals("hash")) {
            return true;
        }
        if (method.equals("isNominative")) {
            return true;
        }
        if (method.equals("uaImportance")) {
            return true;
        }
        return method.equals("ts");
    }
}

