/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Cache;
import com.detectright.core.ConnectionLostException;
import com.detectright.core.DBLink;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.EntityAliasCore;
import com.detectright.core.EntityCore;
import com.detectright.core.EntityProfileCore;
import com.detectright.core.Functions;
import com.detectright.core.PointerCore;
import com.detectright.core.RecordSet;
import java.util.LinkedHashMap;

public class EntityPackage {
    public static ThreadLocal<DBLink> dbLink = new ThreadLocal();
    protected DBLink db;
    public static ThreadLocal<Cache> cacheLink = new ThreadLocal();
    protected Cache cache;
    RecordSet entityRS = null;
    LinkedHashMap<String, Object> entity = null;
    RecordSet entity_alias = null;
    RecordSet pointers = null;
    RecordSet entity_profiles = null;
    RecordSet entity_contains = null;
    RecordSet entity_overrides = null;

    public EntityPackage() throws ConnectionLostException, DetectRightException {
        this.cacheDB();
    }

    public void cacheDB() throws ConnectionLostException, DetectRightException {
        if (cacheLink.get() == null) {
            cacheLink.set(DetectRight.getCacheLink());
        }
        this.cache = cacheLink.get();
        if (dbLink.get() == null) {
            dbLink.set(DetectRight.getDBLink());
        }
        this.db = dbLink.get();
        if (this.db == null) {
            throw new ConnectionLostException("Lost connection to database");
        }
    }

    public void __wakeup() throws ConnectionLostException, DetectRightException {
        this.cacheDB();
    }

    String getEntityID() {
        return Functions.gvString(this.entity, "ID");
    }

    String getEntityHash() {
        return Functions.gvString(this.entity, "hash");
    }

    void fill(String hash) throws DetectRightException, ConnectionLostException {
        this.entityRS = this.db.fetchRecordset(EntityCore.table, DBLink.allFields, DBLink.whereClause("hash", hash));
        this.entity = this.entityRS.fetch();
        String entityid = "-1";
        if (this.entity != null) {
            entityid = Functions.gvString(this.entity, "ID");
        }
        LinkedHashMap<String, Object> wc = DBLink.whereClause("entityid", String.valueOf(entityid));
        this.entity_alias = this.db.fetchRecordset(EntityAliasCore.table, DBLink.allFields, wc);
        this.pointers = this.db.fetchRecordset(PointerCore.table, DBLink.allFields, wc);
        this.entity_profiles = this.db.fetchRecordset(EntityProfileCore.table, DBLink.allFields, wc);
        this.entity_contains = this.db.fetchRecordset("entity_contains", DBLink.allFields, wc);
        this.entity_overrides = this.db.fetchRecordset("entity_overrides", DBLink.allFields, wc);
    }

    public boolean addFrom(EntityPackage ep) throws DetectRightException, ConnectionLostException {
        boolean success = this.entityRS.processRow(ep.entity);
        success &= RecordSet.syncRS(ep.entity_alias, this.entity_alias);
        success &= RecordSet.syncRS(ep.pointers, this.pointers);
        success &= RecordSet.syncRS(ep.entity_profiles, this.entity_profiles);
        success &= RecordSet.syncRS(ep.entity_contains, this.entity_contains);
        return success &= RecordSet.syncRS(ep.entity_overrides, this.entity_overrides);
    }

    public boolean isCompatibleWith(EntityPackage ep) {
        String srcID = this.getEntityID();
        String srcHash = this.getEntityHash();
        String destID = ep.getEntityID();
        String destHash = ep.getEntityHash();
        return srcID.equals(destID) && srcHash.equals(destHash);
    }

    static EntityPackage getPkg(String hash, DBLink source) throws DetectRightException, ConnectionLostException {
        DBLink db = source;
        EntityPackage ep = new EntityPackage();
        ep.db = db;
        ep.fill(hash);
        return ep;
    }

    void delete() throws DetectRightException, ConnectionLostException {
        this.entity_alias.delete();
        this.entity_contains.delete();
        this.entity_profiles.delete();
        this.entity_overrides.delete();
        this.pointers.delete();
        this.db.deleteData(EntityCore.table, DBLink.whereClause("hash", this.getEntityHash()));
    }
}

