/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Cache;
import com.detectright.core.ConnectionLostException;
import com.detectright.core.DBLink;
import com.detectright.core.DRLRUMap;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.EntityAliasCore;
import com.detectright.core.EntityCore;
import com.detectright.core.EntitySig;
import com.detectright.core.Functions;
import com.detectright.core.QuantumDataTree;
import com.detectright.core.Reflection;
import com.detectright.core.SchemaPropertyCore;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntitySigCollection {
    public static int containedComponentOffset = -15;
    public static int containedNominativeComponentOffset = -5;
    public static volatile DRLRUMap gOverrides = new DRLRUMap(1000);
    public LinkedHashMap<String, Object> metadata = new LinkedHashMap();
    public ArrayList<EntitySig> es = new ArrayList();
    public ArrayList<String> entityTypes = new ArrayList();
    public ArrayList<EntityCore> entities = new ArrayList();
    public ArrayList<String> entityHashes = new ArrayList();
    public ArrayList<EntitySig> rejected = new ArrayList();
    public LinkedHashMap<Integer, String> descriptors = new LinkedHashMap();
    public QuantumDataTree qdt;
    public EntityCore nom;
    public static ThreadLocal<DBLink> dbLink = new ThreadLocal();
    protected DBLink db;
    public static ThreadLocal<Cache> cacheLink = new ThreadLocal();
    protected Cache cache;
    private boolean allowNominativeEntities = true;

    static {
        DetectRight.registerClass("EntitySigCollection");
        try {
            if (Functions.is_null(cacheLink.get())) {
                cacheLink.set(DetectRight.getCacheLink());
            }
            if (Functions.is_null(dbLink.get())) {
                dbLink.set(DetectRight.getDBLink());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
    }

    public EntitySigCollection() throws ConnectionLostException, DetectRightException {
        this.cacheDB();
        this.qdt = new QuantumDataTree("", null);
    }

    public void close() {
        this.cache = null;
        this.db = null;
        this.entityTypes = null;
        this.entityHashes = null;
        this.entities = null;
        this.es = null;
        this.rejected = null;
        if (this.qdt != null) {
            this.qdt.close();
        }
        this.qdt = null;
    }

    public void cacheDB() throws ConnectionLostException, DetectRightException {
        if (Functions.is_null(cacheLink.get())) {
            cacheLink.set(DetectRight.getCacheLink());
        }
        this.cache = cacheLink.get();
        if (Functions.is_null(dbLink.get())) {
            dbLink.set(DetectRight.getDBLink());
        }
        this.db = dbLink.get();
        if (this.db == null) {
            throw new ConnectionLostException("Lost connection to database");
        }
    }

    public void __wakeup() throws ConnectionLostException, DetectRightException {
        this.cacheDB();
    }

    public ArrayList<String> __sleep() {
        LinkedHashMap<String, Object> ov = Reflection.get_object_vars(this);
        ov.remove("cache");
        ov.remove("db");
        return Functions.array_keys_string(ov);
    }

    public QuantumDataTree process() throws DetectRightException, ConnectionLostException {
        QuantumDataTree qdt = this.getQDT();
        qdt.processPackages();
        return qdt;
    }

    public EntityCore getEntityForEntityType(String entitytype) {
        if (Functions.isEmpty(entitytype)) {
            return null;
        }
        int i = 0;
        while (i < this.entities.size()) {
            EntityCore entity = this.entities.get(i);
            if (entity.entitytype.equals(entitytype)) {
                return entity;
            }
            ++i;
        }
        return null;
    }

    public EntityCore getNominativeEntity() throws DetectRightException {
        int bestPos = EntityCore.nominativeEntityTypes.size();
        int browserPos = -1;
        if (this.nom != null) {
            return this.nom;
        }
        if (this.entities == null) {
            return null;
        }
        if (this.entities.size() == 0) {
            return null;
        }
        EntityCore nom = null;
        int i = 0;
        while (i < this.entities.size()) {
            EntityCore entity = this.entities.get(i);
            if (entity.entitytype.equals("Browser") || entity.entitytype.equals("Mobile Browser")) {
                browserPos = i;
            } else {
                String entitytype = entity.entitytype;
                int pos = EntityCore.nominativeEntityTypes.indexOf(entitytype);
                if (pos > -1 && (pos < bestPos || nom != null && nom.ID < 1L) && (nom == null || nom != null && nom.ID > 1L && entity.ID > 1L)) {
                    bestPos = pos;
                    nom = entity;
                }
            }
            ++i;
        }
        if (browserPos > -1) {
            Boolean userAgentsAsBrowsers = DetectRight.getPropertyBool("userAgentsAsBrowsers");
            if (userAgentsAsBrowsers == null) {
                userAgentsAsBrowsers = false;
            }
            if (userAgentsAsBrowsers.booleanValue() && nom != null && nom.entitytype.equals("UserAgent")) {
                nom = this.entities.get(browserPos);
            } else if (userAgentsAsBrowsers.booleanValue() && nom == null) {
                nom = this.entities.get(browserPos);
            }
        }
        this.nom = nom;
        return nom;
    }

    public void filter() {
    }

    public void addEntityContains() throws DetectRightException, ConnectionLostException {
        if (this.entities == null) {
            return;
        }
        ArrayList entities = (ArrayList)this.entities.clone();
        int key = 0;
        while (key < entities.size()) {
            EntityCore entity = (EntityCore)entities.get(key);
            ArrayList<Object> contains = entity.getContains();
            if (contains != null) {
                int cKey = 0;
                while (cKey < contains.size()) {
                    EntityCore newEntity = (EntityCore)contains.get(cKey);
                    int offset = 0;
                    offset = newEntity.isNominative() ? containedNominativeComponentOffset : containedComponentOffset;
                    String descriptor = newEntity.descriptor();
                    String tmpDescriptor = "";
                    boolean remove = false;
                    if (this.descriptors.containsValue(descriptor)) {
                        remove = true;
                        tmpDescriptor = descriptor;
                    }
                    if (!remove) {
                        ArrayList<Object> descKeys = Functions.array_values(this.descriptors);
                        for (Object tmpObj : descKeys) {
                            String tmpString = tmpObj.toString();
                            if (!tmpString.startsWith(String.valueOf(descriptor) + ":")) continue;
                            remove = true;
                            tmpDescriptor = tmpString;
                        }
                    }
                    if (!remove) {
                        int r = 0;
                        for (EntityCore e : this.entities) {
                            if (e.ID == newEntity.ID) {
                                remove = true;
                                tmpDescriptor = this.descriptors.get(r);
                                if (Functions.stripos(e.majorrevision, newEntity.majorrevision) == 0) {
                                    offset = -5;
                                }
                            }
                            ++r;
                        }
                    }
                    if (remove) {
                        Object eskey = Functions.array_search(tmpDescriptor, this.descriptors);
                        if (eskey instanceof Integer) {
                            EntitySig es = this.es.get((Integer)eskey);
                            es.importance = offset;
                        }
                    } else if (newEntity.entitytype.equals(entity.entitytype)) {
                        int esOffset = this.es.get((int)key).importance;
                        this.addEntity(newEntity, true, newEntity.entitytype.concat("/" + String.valueOf(newEntity.ID)), offset + esOffset);
                    } else {
                        this.addEntity(newEntity, false, "", offset);
                    }
                    ++cKey;
                }
            }
            ++key;
        }
    }

    public void addESC(EntitySigCollection esc) throws DetectRightException, ConnectionLostException {
        if (esc == null) {
            return;
        }
        ArrayList<EntitySig> ess = esc.es;
        if (ess == null) {
            return;
        }
        for (EntitySig es : ess) {
            this.addES(es);
        }
        this.qdt.addQDT(esc.qdt);
    }

    public QuantumDataTree getQDT() throws DetectRightException, ConnectionLostException {
        DetectRight.checkPoint("Getting nom entity");
        EntityCore entity = this.getNominativeEntity();
        if (entity == null) {
            DetectRight.checkPoint("Null entity returned for nominative");
        } else {
            DetectRight.checkPoint("Got nom entity " + entity.descriptor());
        }
        if (DetectRight.getDiag().booleanValue()) {
            this.qdt.print("Current QDT for ESC");
        }
        QuantumDataTree qdt = new QuantumDataTree("", null);
        String nomEntityHash = "";
        if (entity != null && !Functions.isEmpty(nomEntityHash = entity.hash())) {
            DetectRight.checkPoint("Processing nomEntity hash " + nomEntityHash);
            qdt = entity.getQDT();
            if (qdt == null) {
                qdt = new QuantumDataTree(entity.descriptor(), null);
            }
            DetectRight.checkPoint("Got QDT, tree is " + qdt.getPackages().size());
            qdt.addState(1, 999, 1);
        }
        qdt.subsume(this.qdt);
        if (DetectRight.getDiag().booleanValue()) {
            qdt.print("QDT After initial entity");
        }
        for (EntitySig esObj : this.es) {
            EntitySig es = esObj;
            if (es == null || (entity = es.getEntity()).hash().equals(nomEntityHash)) continue;
            entity.getQDT();
            if (DetectRight.getDiag().booleanValue()) {
                entity.qdt.print("Entity " + entity.ID + "QDT");
            }
            es.qdt.addImportance(es.importance);
            entity.qdt.addImportance(es.importance);
            if (DetectRight.getDiag().booleanValue()) {
                entity.qdt.print("Entity " + entity.ID + "QDT");
            }
            qdt.subsume(es.qdt);
            qdt.subsume(entity.qdt);
            qdt.addEntity(es.path, entity, es.importance);
            if (!DetectRight.getDiag().booleanValue()) continue;
            qdt.print("QDT After Entity " + entity.ID);
        }
        this.qdt = qdt;
        if (DetectRight.getDiag().booleanValue()) {
            qdt.print("Final QDT");
        }
        return qdt;
    }

    public void resetRootEntity() throws DetectRightException, ConnectionLostException {
        EntityCore nom = this.getNominativeEntity();
        if (nom == null) {
            return;
        }
        if (this.qdt == null) {
            return;
        }
        this.qdt.resetRootEntity(nom);
    }

    public void addDescriptor(String descriptor) throws DetectRightException, ConnectionLostException {
        this.addDescriptor(descriptor, "");
    }

    public void addDescriptor(String descriptor, String sig) throws DetectRightException, ConnectionLostException {
        ArrayList<String> descArray = Functions.explode(":", descriptor);
        EntitySig es = new EntitySig(descArray, sig);
        this.addES(es);
    }

    public void addEntity(EntityCore entity) throws DetectRightException, ConnectionLostException {
        this.addEntity(entity, false, "", 0);
    }

    public void addEntity(EntityCore entity, boolean force) throws DetectRightException, ConnectionLostException {
        this.addEntity(entity, false, "", 0);
    }

    public void addEntity(EntityCore entity, boolean force, String entitytype) throws DetectRightException, ConnectionLostException {
        this.addEntity(entity, false, entitytype, 0);
    }

    public void addEntity(EntityCore entity, boolean force, String entitytype, int importanceOffset) throws DetectRightException, ConnectionLostException {
        this.nom = null;
        ArrayList<String> desc = new ArrayList<String>();
        desc.add(entity.entitytype);
        desc.add(entity.category);
        desc.add(entity.description);
        desc.add(Functions.nn(entity.subclass));
        desc.add(Functions.nn(entity.majorrevision));
        desc.add(Functions.nn(entity.minorrevision));
        desc.add(Functions.nn(entity.connection));
        desc.add(Functions.nn(entity.build));
        EntitySig es = new EntitySig(desc, "");
        es.entity = entity;
        if (Functions.isEmpty(entitytype)) {
            entitytype = entity.entitytype;
        }
        es.importance = importanceOffset;
        this.addES(es, force, entitytype);
    }

    public void addES(EntitySig es) throws DetectRightException, ConnectionLostException {
        this.addES(es, false);
    }

    public void addES(EntitySig es, boolean force) throws DetectRightException, ConnectionLostException {
        this.addES(es, false, "");
    }

    public void addES(EntitySig es, boolean force, String entitytype) throws DetectRightException, ConnectionLostException {
        String descriptor;
        if (es == null) {
            return;
        }
        String emptyHash = "4501c091b0366d76ea3218b6cfdd8097";
        if (Functions.isEmpty(entitytype)) {
            entitytype = es.getEntityType();
        }
        this.qdt.addQDT(es.qdt);
        if (Functions.isEmpty(entitytype)) {
            return;
        }
        boolean doBool = false;
        if (!this.entityTypes.contains(entitytype)) {
            doBool = true;
        }
        es.fillEntity();
        EntityCore entity = es.entity;
        if (entity == null) {
            return;
        }
        if (!this.allowNominativeEntities && entity.isNominative()) {
            return;
        }
        if (doBool) {
            int r = 0;
            while (r < this.entities.size()) {
                if (entity.entitytype.equals(this.entities.get((int)r).entitytype)) {
                    doBool = false;
                    break;
                }
                ++r;
            }
        }
        if (Functions.in_array((Object)(descriptor = entity.descriptor()), this.descriptors)) {
            return;
        }
        if (!doBool && !force) {
            block1 : switch (entity.exclusivity) {
                case 1: {
                    if (this.entityHashes.contains(entity.hash)) break;
                    doBool = true;
                    break;
                }
                case 0: {
                    if (!this.entityHashes.contains(entity.hash)) {
                        doBool = true;
                        break;
                    }
                    doBool = true;
                    int i = 0;
                    while (i < this.entities.size()) {
                        EntityCore testEntity = this.entities.get(i);
                        if (entity.hash.equals(testEntity.hash)) {
                            String evHash = Functions.md5(String.valueOf(entity.subclass) + ":" + entity.majorrevision + ":" + entity.build);
                            String testHash = Functions.md5(String.valueOf(testEntity.subclass) + ":" + testEntity.majorrevision + ":" + testEntity.build);
                            if (testHash.equals(emptyHash) && !evHash.equals(emptyHash)) {
                                this.entities.set(i, entity);
                                doBool = false;
                                break block1;
                            }
                            if (evHash.equals(testHash)) {
                                doBool = false;
                                break block1;
                            }
                        }
                        ++i;
                    }
                    break;
                }
                case 2: {
                    doBool = false;
                    if (Functions.isEmpty(es.sig) && this.entityHashes.contains(entity.hash)) {
                        for (EntityCore cEntity : this.entities) {
                            if (cEntity == null || !cEntity.hash.equals(entity.hash)) continue;
                            String oldDescriptor = cEntity.descriptor();
                            boolean changed = false;
                            if (!Functions.isEmpty(entity.build) && Functions.isEmpty(cEntity.build)) {
                                cEntity.build = entity.build;
                                changed = true;
                            }
                            if (!Functions.isEmpty(entity.subclass) && Functions.isEmpty(cEntity.subclass)) {
                                cEntity.subclass = entity.subclass;
                                changed = true;
                            }
                            if (!Functions.isEmpty(entity.connection) && Functions.isEmpty(cEntity.connection)) {
                                cEntity.connection = entity.connection;
                                changed = true;
                            }
                            if (Functions.isEmpty(cEntity.majorrevision) && !Functions.isEmpty(entity.majorrevision)) {
                                cEntity.majorrevision = entity.majorrevision;
                                changed = true;
                            }
                            if (!changed) continue;
                            String sKey = String.valueOf(Functions.array_search(oldDescriptor, this.descriptors));
                            if (sKey != null && !sKey.equals("null")) {
                                try {
                                    Integer dKey = Functions.parseInt(sKey);
                                    if (dKey != null) {
                                        this.descriptors.put(dKey, entity.descriptor());
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            this.es.add(es);
                        }
                        break;
                    }
                    if (!Functions.isEmpty(es.sig)) break;
                    ArrayList<Integer> keys = Functions.array_keys(this.es);
                    for (Integer key : keys) {
                        EntitySig ces = this.es.get(key);
                        if (!ces.entity.entitytype.equals(es.entity.entitytype) || es.importance <= ces.importance) continue;
                        this.descriptors.put(key, es.entity.descriptor());
                        this.entities.set(key, null);
                        this.entities.set(key, es.entity);
                        this.entityHashes.set(key, es.entity.hash);
                        this.es.set(key, null);
                        this.es.set(key, es);
                        doBool = false;
                    }
                    break;
                }
                default: {
                    doBool = false;
                }
            }
        }
        if (doBool || force) {
            this.es.add(es);
            this.entities.add(entity);
            this.entityHashes.add(entity.hash);
            this.descriptors.put(this.es.size() - 1, entity.descriptor());
            if (!this.entityTypes.contains(entitytype)) {
                this.entityTypes.add(entitytype);
            }
        } else {
            this.rejected.add(es);
        }
    }

    public ArrayList<EntityCore> getEntities() {
        return this.entities;
    }

    public ArrayList<String> getDescriptors() {
        ArrayList<String> output = new ArrayList<String>();
        if (this.es == null) {
            return output;
        }
        for (EntitySig esObj : this.es) {
            if (esObj == null) continue;
            EntitySig es = esObj;
            output.add(es.descriptor);
        }
        return output;
    }

    public LinkedHashMap<String, Object> getDescriptorTree() {
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        for (EntitySig esObj : this.es) {
            EntitySig es = esObj;
            String et = es.getEntityType();
            if (!output.containsKey(et)) {
                output.put(et, new ArrayList());
            }
            ArrayList tmp = (ArrayList)output.get(et);
            tmp.add(es.descriptor);
        }
        return output;
    }

    public LinkedHashMap<String, Object> getEntityTree() {
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        for (EntitySig esObj : this.es) {
            EntitySig es = esObj;
            String et = es.getEntityType();
            if (!output.containsKey(et)) {
                output.put(et, new ArrayList());
            }
            ArrayList tmp = (ArrayList)output.get(et);
            tmp.add(es.entity);
        }
        return output;
    }

    public String getManufacturer() throws DetectRightException {
        EntityCore nomEntity = this.getNominativeEntity();
        if (nomEntity == null) {
            return "";
        }
        return nomEntity.category;
    }

    public String getModel() throws DetectRightException {
        EntityCore nomEntity = this.getNominativeEntity();
        if (nomEntity == null) {
            return "";
        }
        return nomEntity.description;
    }

    public LinkedHashMap<String, Object> getExportProfile() throws DetectRightException, ConnectionLostException {
        return this.getExportProfile("");
    }

    public LinkedHashMap<String, Object> getExportProfile(String schema) throws DetectRightException, ConnectionLostException {
        if (schema == null) {
            schema = "";
        }
        DetectRight.checkPoint("Generating profile");
        LinkedHashMap<String, Object> profile = SchemaPropertyCore.export(this.qdt, schema);
        DetectRight.checkPoint("Generated Profile");
        profile.put("components", Functions.implode(",", Functions.array_values(this.descriptors)));
        EntityCore nomEntity = this.getNominativeEntity();
        if (nomEntity != null) {
            if (schema.contains("W3C")) {
                profile.put("vendor", nomEntity.category);
                profile.put("model", nomEntity.description);
            }
            if (schema.contains("WURFL")) {
                profile.put("brand_name", nomEntity.category);
                profile.put("model_name", nomEntity.description);
            }
            if (schema.contains("UAProfile")) {
                profile.put("vendor", nomEntity.category);
                profile.put("model", nomEntity.description);
            }
            if (schema.contains("DR")) {
                profile.put("manufacturer", nomEntity.category);
                profile.put("model", nomEntity.description);
            }
            ArrayList<String> status = new ArrayList<String>();
            status.add("1");
            status.add("2");
            ArrayList<EntityAliasCore> akas = EntityAliasCore.getAliasCollection(nomEntity.id(), status);
            ArrayList<String> descriptors = new ArrayList<String>();
            ArrayList<String> hashes = new ArrayList<String>();
            for (EntityAliasCore eaObj : akas) {
                if (eaObj == null) continue;
                EntityAliasCore ea = eaObj;
                String desc = String.valueOf(ea.entitytype) + ":" + ea.category + ":" + ea.description;
                hashes.add(ea.hash);
                descriptors.add(desc);
            }
            profile.put("deviceid", nomEntity.hash);
            profile.put("id", nomEntity.hash);
            profile.put("devicedescriptor", String.valueOf(nomEntity.entitytype) + ":" + nomEntity.category + ":" + nomEntity.description);
            profile.put("altdescriptors", Functions.implode(",", descriptors));
            profile.put("altids", Functions.implode(",", hashes));
            ArrayList<String> eHashes = new ArrayList<String>();
            eHashes.addAll(hashes);
            LinkedHashMap<String, Object> where = new LinkedHashMap();
            if (eHashes.size() > 0) {
                LinkedHashMap<String, Object> whereHashes = new LinkedHashMap<String, Object>();
                whereHashes.put("op", "in");
                whereHashes.put("value", eHashes);
                where.put("entityhash", whereHashes);
                DBLink dbLink = EntityCore.dbLink.get();
                if (dbLink == null) {
                    dbLink = DetectRight.getDBLink();
                }
                profile.put("dbconn", dbLink.getConnectionInfo());
                this.addOverrides(profile, where, true);
            }
            where = DBLink.whereClause("entityhash", this.nom.hash);
            this.addOverrides(profile, where, true);
            where.clear();
            String deviceType = nomEntity.entitytype;
            Boolean readersAsTablets = DetectRight.getPropertyBool("readersAsTablets");
            if (readersAsTablets == null) {
                readersAsTablets = false;
            }
            if (readersAsTablets.booleanValue() && nomEntity != null && nomEntity.entitytype.equals("e-Reader")) {
                deviceType = "Tablet";
            }
            LinkedHashMap<String, Object> et = null;
            if (nomEntity != null && nomEntity.entitytype.equals("UserAgent")) {
                et = this.getEntityTree();
                if (et != null && et.containsKey("Mobile Browser")) {
                    deviceType = "Mobile Device";
                } else if (et != null && et.containsKey("Browser")) {
                    deviceType = "Desktop";
                    ArrayList eArr = (ArrayList)et.get("Browser");
                    if (eArr != null) {
                        EntityCore e = (EntityCore)Functions.array_shift(eArr);
                        if (e.entitytype.equals("Mobile Browser")) {
                            deviceType = "Mobile Device";
                        }
                    }
                }
            }
            if (deviceType.equals("UserAgent")) {
                deviceType = "Desktop";
            }
            where.put("entityhash", "generic_" + deviceType);
            this.addOverrides(profile, where, false);
            where.clear();
            where.put("entityhash", "generic");
            this.addOverrides(profile, where, false);
            profile.put("type", deviceType);
            if (et != null && et.containsKey("UserAgent") && !DetectRight.getEnableUserAgentEntityType()) {
                String uaKey;
                while ((uaKey = (String)Functions.array_search(nomEntity.category, profile)) != null) {
                    profile.put(uaKey, "Generic");
                }
                while ((uaKey = (String)Functions.array_search(nomEntity.description, profile)) != null) {
                    profile.put(uaKey, deviceType);
                }
            }
        }
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addOverrides(LinkedHashMap<String, Object> profile, LinkedHashMap<String, Object> where, boolean override) throws DetectRightException, ConnectionLostException {
        boolean doHighlights = DetectRight.getOverrideHighlight();
        if (where == null) {
            throw new DetectRightException("Null where passed into addOverrides", null);
        }
        if (where.size() == 0) {
            return;
        }
        DBLink dbl = dbLink.get();
        if (dbl != null) {
            LinkedHashMap<String, Object> overrides = null;
            String cacheKey = Functions.md5(Functions.serialize(where));
            DRLRUMap dRLRUMap = gOverrides;
            synchronized (dRLRUMap) {
                if (gOverrides.containsKey(cacheKey)) {
                    overrides = (LinkedHashMap<String, Object>)gOverrides.get(cacheKey);
                }
            }
            if (overrides == null) {
                dRLRUMap = gOverrides;
                synchronized (dRLRUMap) {
                    if (gOverrides.containsKey(cacheKey)) {
                        overrides = (LinkedHashMap)gOverrides.get(cacheKey);
                    } else {
                        overrides = dbl.simpleFetch("entity_overrides", DBLink.allFields, where);
                        if (overrides != null) {
                            gOverrides.add(cacheKey, overrides);
                        }
                    }
                }
            }
            if (overrides != null) {
                LinkedHashMap<String, Object> tmpMap = overrides;
                for (Map.Entry entry : tmpMap.entrySet()) {
                    Object rowObj = entry.getValue();
                    if (!(rowObj instanceof LinkedHashMap)) continue;
                    LinkedHashMap row = (LinkedHashMap)rowObj;
                    String key = Functions.gvString(row, "key");
                    if (!override && profile.containsKey(key)) continue;
                    String oldValue = Functions.gvString(profile, key);
                    String value = Functions.gvString(row, "value");
                    if (doHighlights) {
                        if (Functions.isEmpty(key) || Functions.isEmpty(value) || value.equals(oldValue)) continue;
                        if (Functions.isEmpty(oldValue)) {
                            if (override) {
                                profile.put(key, value.concat("+"));
                                continue;
                            }
                            profile.put(key, value.concat("^"));
                            continue;
                        }
                        profile.put(key, value.concat("!"));
                        continue;
                    }
                    profile.put(key, value);
                }
            }
        }
    }

    void refuseNominativeEntities() {
        this.allowNominativeEntities = false;
    }

    void permitNominativeEntities() {
        this.allowNominativeEntities = true;
    }
}

