/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.ConnectionLostException;
import com.detectright.core.DBLink;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.Functions;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MySQL
extends DBLink {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        DetectRight.registerClass("MySQL");
        LinkedHashMap linkedHashMap = typeMap;
        synchronized (linkedHashMap) {
            typeMap.put("BIGINT", "BIGINT(M)");
            typeMap.put("BIT", "BIT(1)");
            typeMap.put("BIT1", "BIT(1)");
            typeMap.put("BLOB", "BLOB");
            typeMap.put("CHAR", "CHAR(M)");
            typeMap.put("CLOB", "LONGTEXT");
            typeMap.put("DATE", "DATE");
            typeMap.put("DECIMAL", "DECIMAL(M)");
            typeMap.put("DOUBLE", "DOUBLE(M)");
            typeMap.put("FLOAT", "FLOAT(M)");
            typeMap.put("INTEGER", "INT(M)");
            typeMap.put("LONGVARBINARY", "VARBINARY(M)");
            typeMap.put("LONGVARCHAR", "MEDIUMTEXT");
            typeMap.put("NUMERIC", "DOUBLE");
            typeMap.put("REAL", "DOUBLE");
            typeMap.put("SMALLINT", "SMALLINT(M)");
            typeMap.put("SQLXML3", "LONGTEXT");
            typeMap.put("TIME", "TIME");
            typeMap.put("TIMESTAMP", "TIMESTAMP(M)");
            typeMap.put("VARBINARY", "VARBINARY");
            typeMap.put("VARCHAR", "VARCHAR(M)");
        }
    }

    public static void main(String[] args) {
    }

    public MySQL(String hash) throws DetectRightException {
        super(hash);
        this.engine = "MySQL";
    }

    @Override
    public boolean _ping() {
        return true;
    }

    @Override
    public String _multichar_wildcard() {
        return "%";
    }

    @Override
    public String _singlechar_wildcard() {
        return "_";
    }

    @Override
    public String _identifier_delimiter() {
        return "`";
    }

    @Override
    public String _quoted_delimiter() {
        return "'";
    }

    @Override
    public boolean connect() throws DetectRightException, ConnectionLostException {
        return this.connect(this.params);
    }

    public boolean connect(LinkedHashMap<String, String> params) throws DetectRightException, ConnectionLostException {
        DetectRight.checkPoint("Connecting to database");
        String host = Functions.gvString(params, "address", "localhost");
        String port = Functions.gvString(params, "port", "3306");
        String database = Functions.gvString(params, "bucket");
        String user = Functions.gvString(params, "username");
        String password = Functions.gvString(params, "password");
        try {
            Connection retval;
            String mysql_driver = "com.mysql.jdbc.Driver";
            Class.forName(mysql_driver);
            String mysql_connectionURL = "jdbc:mysql://" + host + ":" + port + "?CLIENT_INTERACTIVE=true&zeroDateTimeBehavior=convertToNull";
            this.db = retval = DriverManager.getConnection(mysql_connectionURL, user, password);
        }
        catch (Exception x) {
            DetectRight.checkPoint(x.toString());
            throw new DetectRightException(x.getMessage(), x);
        }
        if (!Functions.isEmpty(database)) {
            boolean success = this._selectDatabase(database);
            if (!success) {
                throw new ConnectionLostException("Couldn't select database " + database);
            }
            this.currentDB = database;
        }
        this.dbOK = true;
        DetectRight.checkPoint("Connected to Database");
        return true;
    }

    @Override
    public void _close() throws DetectRightException, ConnectionLostException {
        try {
            if (this.db != null) {
                this.db.close();
            }
            this.db = null;
        }
        catch (Exception x) {
            Functions.trigger_error("Database closing error", x, false);
        }
    }

    @Override
    public boolean _selectDatabase(String database) throws DetectRightException, ConnectionLostException {
        if (database == null) {
            return false;
        }
        try {
            this.db.setCatalog(database);
            return true;
        }
        catch (Exception x) {
            throw new DetectRightException("Error selecting database " + database + " " + x.getMessage(), x);
        }
    }

    @Override
    public boolean _free_result(ResultSet result) throws DetectRightException, ConnectionLostException {
        if (result == null) {
            return true;
        }
        try {
            result.close();
        }
        catch (Exception e) {
            Functions.trigger_error("Free result error", e, false);
            result = null;
            return true;
        }
        result = null;
        return true;
    }

    @Override
    public String _escape_string(String string) {
        if (Functions.isEmpty(string)) {
            return "";
        }
        string = string.replaceAll("\u0000", "\\0");
        string = string.replaceAll("'", "\\'");
        string = string.replaceAll("\"", "\\\"");
        string = string.replaceAll("\b", "\\b");
        string = string.replaceAll("\n", "\\n");
        string = string.replaceAll("\r", "\\r");
        string = string.replaceAll("\t", "\\t");
        string = string.replaceAll("\t", "\\t");
        string = string.replaceAll("\u001a", "\\Z");
        string = string.replaceAll("\\\\", "\\\\\\\\");
        string = string.replaceAll("%", "\\%");
        string = string.replaceAll("_", "\\_");
        return string;
    }

    @Override
    public int _num_rows(ResultSet rs) throws DetectRightException {
        if (rs == null) {
            return 0;
        }
        int count = 0;
        try {
            int current = rs.getRow();
            rs.last();
            count = rs.getRow();
            if (count == -1) {
                count = 0;
            }
            if (current == 0) {
                rs.beforeFirst();
            } else {
                rs.absolute(current);
            }
        }
        catch (Exception e) {
            throw new DetectRightException("Error reading numRows", e);
        }
        return count;
    }

    @Override
    public long _insert_id() throws DetectRightException, ConnectionLostException {
        if (this.db == null) {
            throw new ConnectionLostException("Connection Lost getting insert ID");
        }
        Statement stmt = null;
        ResultSet rs = null;
        int autoIncKeyFromFunc = 0;
        try {
            try {
                if (this.db.isClosed()) {
                    this.connect();
                }
                stmt = this.db.createStatement();
                autoIncKeyFromFunc = -1;
                rs = stmt.executeQuery("SELECT LAST_INSERT_ID()");
                autoIncKeyFromFunc = rs.next() ? rs.getInt(1) : 0;
                rs.close();
            }
            catch (Exception e) {
                throw new DetectRightException("Error getting insert ID", e);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return autoIncKeyFromFunc;
    }

    @Override
    public int _affected_rows() {
        return this.affectedRows;
    }

    @Override
    public String _sql_error() {
        return this.error;
    }

    @Override
    public LinkedHashMap<String, Object> _query(String sql) throws DetectRightException, ConnectionLostException {
        return this._query(sql, "");
    }

    @Override
    public LinkedHashMap<String, Object> _query(String sql, String keyField) throws DetectRightException, ConnectionLostException {
        if (this.db == null) {
            throw new ConnectionLostException("Lost Connection to Database");
        }
        ResultSet rs = null;
        Statement stmt = null;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (Functions.isEmpty(sql)) {
            return result;
        }
        try {
            if (this.db.isClosed()) {
                this.connect();
            }
            stmt = this.db.createStatement();
            rs = stmt.executeQuery(sql);
            result = this._fetch_all(rs, keyField);
            rs.close();
            stmt.close();
        }
        catch (SQLException ex) {
            this.error = ex.getMessage();
        }
        return result;
    }

    @Override
    public boolean _queryBool(String sql) throws DetectRightException, ConnectionLostException {
        boolean success;
        block15: {
            if (this.db == null) {
                throw new ConnectionLostException("Lost Connection to Database");
            }
            if (Functions.isEmpty(sql)) {
                return false;
            }
            success = false;
            Statement stmt = null;
            try {
                try {
                    int rows;
                    if (this.db.isClosed()) {
                        this.connect();
                    }
                    stmt = this.db.createStatement();
                    this.affectedRows = rows = stmt.executeUpdate(sql);
                    success = true;
                }
                catch (SQLException ex) {
                    this.error = ex.getMessage();
                    if (stmt == null) break block15;
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    stmt = null;
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {}
                    stmt = null;
                }
            }
        }
        return success;
    }

    @Override
    public LinkedHashMap<String, Object> _fetch_assoc(ResultSet result) {
        if (result == null) {
            return null;
        }
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        try {
            boolean success = result.next();
            if (!success) {
            }
            ResultSetMetaData metadata = result.getMetaData();
            int columns = metadata.getColumnCount();
            int i = 1;
            while (i < columns + 1) {
                block12: {
                    String key = metadata.getColumnName(i);
                    String value = "";
                    try {
                        try {
                            value = result.getString(i);
                        }
                        catch (Throwable e) {
                            value = "";
                            output.put(key, value);
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        output.put(key, value);
                        throw throwable;
                    }
                    output.put(key, value);
                }
                ++i;
            }
        }
        finally {
            return null;
        }
        return output;
    }

    @Override
    public String _ts2Date(long ts) {
        Date x = new Date(ts);
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df1.format(x);
    }

    @Override
    public LinkedHashMap<String, Object> _fetch_all(ResultSet result) {
        return this._fetch_all(result, "");
    }

    @Override
    public LinkedHashMap<String, Object> _fetch_all(ResultSet result, String keyField) {
        LinkedHashMap<String, Object> row;
        if (result == null) {
            return null;
        }
        LinkedHashMap<String, Object> retArray = new LinkedHashMap<String, Object>();
        while ((row = this._fetch_assoc(result)) != null) {
            if (!Functions.isEmpty(keyField) && row.containsKey(keyField)) {
                String keyFieldValue = (String)row.get(keyField);
                retArray.put(keyFieldValue, row);
                continue;
            }
            retArray.put(String.valueOf(retArray.size()), row);
        }
        return retArray;
    }

    @Override
    public String _limit_string(LinkedHashMap<String, Object> array) {
        if (array == null || array.size() == 0) {
            return "";
        }
        String limit = Functions.gvString(array, "limit");
        String offset = Functions.gvString(array, "offset", "");
        if (!Functions.is_numeric(limit)) {
            this.error = "Non-numeric Limit";
            return "";
        }
        if (!Functions.isEmpty(offset) && !Functions.is_numeric(offset)) {
            this.error = "Non-numeric offset";
            return "";
        }
        String retStr = "limit " + limit;
        if (!Functions.isEmpty(offset)) {
            retStr.concat(" OFFSET " + offset);
        }
        return retStr;
    }

    @Override
    public String _now() {
        return "NOW()";
    }

    @Override
    public String _delayed_string() {
        return "delayed";
    }

    @Override
    public ArrayList<String> _getTableList() throws DetectRightException, ConnectionLostException {
        ArrayList<String> output = new ArrayList<String>();
        LinkedHashMap<String, Object> result = this._query("show tables from `" + this.currentDB + "`");
        if (result == null) {
            return null;
        }
        ArrayList<String> rowKeys = Functions.array_keys_string(result);
        for (String rowKey : rowKeys) {
            LinkedHashMap row = (LinkedHashMap)result.get(rowKey);
            if (row == null) break;
            output.add(Functions.array_shift(row).toString());
        }
        return output;
    }

    @Override
    public boolean _bulk_insert(String table, String fields, ArrayList<String> values) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(table)) {
            return false;
        }
        if (Functions.isEmpty(fields)) {
            return false;
        }
        if (values == null) {
            return false;
        }
        if (values.size() == 0) {
            return true;
        }
        int page = 10000;
        boolean success = true;
        ArrayList chunks = (ArrayList)Functions.array_chunk(values, page);
        for (Object valueObj : chunks) {
            if (!(valueObj instanceof ArrayList)) {
                return false;
            }
            ArrayList valueArray = (ArrayList)valueObj;
            String valueStrings = Functions.implode(",", valueArray);
            String sql = "insert ignore into " + table + "(" + fields + ") VALUES " + valueStrings;
            boolean bl = success = this._queryBool(sql) && success;
        }
        return success;
    }

    @Override
    public String _null() {
        return "null";
    }

    @Override
    public ArrayList<String> _getFields(String table) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(table)) {
            return new ArrayList<String>();
        }
        table = this.idd(table);
        String query = "show fields from " + table;
        LinkedHashMap<String, Object> result = this.fillArrayFromSQL(query, "Field");
        ArrayList<String> fields = Functions.array_keys_string(result);
        return fields;
    }

    @Override
    public ArrayList<String> getDDL(String tablename, LinkedHashMap<?, ?> pk, LinkedHashMap<?, ?> index, LinkedHashMap<?, ?> fields) {
        ArrayList<String> output = new ArrayList<String>();
        if (Functions.isEmpty(tablename)) {
            return output;
        }
        if (pk == null) {
            return output;
        }
        if (index == null) {
            return output;
        }
        if (fields == null) {
            return output;
        }
        ArrayList<String> keys = Functions.array_keys_string(fields);
        for (String key : keys) {
            String dataName;
            int dataType;
            LinkedHashMap lhm = (LinkedHashMap)fields.get(key);
            if (lhm == null) continue;
            String colName = (String)lhm.get("colName");
            Object dataTypeObj = lhm.get("dataType");
            if (dataTypeObj == null || !jdbcTypeMap.containsKey(dataType = Functions.parseInt(dataTypeObj.toString())) || !typeMap.containsKey(dataName = (String)jdbcTypeMap.get(dataType))) continue;
            dataName = (String)typeMap.get(dataName);
            Object colSizeObject = lhm.get("colSize");
            int colSize = 0;
            if (colSizeObject != null) {
                colSize = Functions.parseInt(colSizeObject.toString());
            }
            if (colSize > 0 && dataName.contains("(M)")) {
                dataName = dataName.replace("(M)", "(" + String.valueOf(colSize) + ")");
            } else if (colSize < 1 && dataName.contains("(M)")) {
                dataName = Functions.substr(dataName, 0, Functions.strpos(dataName, "(M)"));
            }
            Object takesNullObjects = lhm.get("takesNulls");
            boolean takesNulls = true;
            if (takesNullObjects != null) {
                takesNulls = Functions.to_boolean(takesNullObjects.toString());
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add("`" + colName + "`");
            command.add(dataName);
            if (dataName.equals("INT(10)") || dataName.equals("INT(12)")) {
                command.add("UNSIGNED");
            }
            if (takesNulls) {
                command.add("NULL");
            } else {
                command.add("NOT NULL");
            }
            output.add(Functions.implode(" ", command));
        }
        Functions.ksort(pk);
        String pkString = "";
        String pkName = "";
        if (pk.size() > 0) {
            pkString = "PRIMARY KEY (";
            LinkedHashMap<?, ?> tmpMap = pk;
            ArrayList<String> keyList = new ArrayList<String>();
            for (Map.Entry entry : tmpMap.entrySet()) {
                Object lhmObj = entry.getValue();
                if (!(lhmObj instanceof LinkedHashMap)) continue;
                LinkedHashMap lhm = (LinkedHashMap)lhmObj;
                String colName = (String)lhm.get("colName");
                if (Functions.isEmpty(pkName)) {
                    pkName = (String)lhm.get("pkName");
                }
                keyList.add("`" + colName + "`");
            }
            output.add(String.valueOf(pkString) + Functions.implode(",", keyList) + ")");
        }
        if (index.size() > 0) {
            ArrayList<String> indexNames = Functions.array_keys_string(index);
            for (String indexName : indexNames) {
                LinkedHashMap lhm;
                boolean establishedUniqueness = false;
                if (indexName.equals(pkName)) continue;
                String indexString = "KEY ";
                ArrayList<String> indexBits = new ArrayList<String>();
                Object lhmObj = index.get(indexName);
                if (!(lhmObj instanceof LinkedHashMap) || (lhm = (LinkedHashMap)lhmObj).size() == 0) continue;
                Functions.ksort(lhm);
                LinkedHashMap tmpMap = lhm;
                for (Map.Entry entry : tmpMap.entrySet()) {
                    boolean nonUnique;
                    LinkedHashMap ihm;
                    String colName;
                    Object ihmObj = entry.getValue();
                    if (!(ihmObj instanceof LinkedHashMap) || Functions.isEmpty(colName = Functions.gvString(ihm = (LinkedHashMap)ihmObj, "colName", ""))) continue;
                    if (!establishedUniqueness && !(nonUnique = Functions.to_boolean(Functions.gvString(ihm, "nonUnique", "0")))) {
                        indexString = "UNIQUE " + indexString;
                    }
                    indexBits.add("`" + colName + "`");
                }
                output.add(String.valueOf(indexString) + " `" + indexName + "` (" + Functions.implode(",", indexBits) + ")");
            }
        }
        String innerBrackets = Functions.implode(", ", output);
        String resultStr = "CREATE TABLE `" + tablename + "` (" + innerBrackets + ") ENGINE MYISAM DEFAULT CHARSET=LATIN1";
        ArrayList<String> resultArr = new ArrayList<String>();
        resultArr.add(resultStr);
        return resultArr;
    }

    @Override
    public Connection getConnectionObject() {
        return this.db;
    }
}

