/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Functions;
import com.detectright.core.PHPSerializer;
import com.detectright.core.PhpObject;
import com.detectright.core.Reflection;
import java.io.StreamCorruptedException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class PHPDeserializer {
    private ArrayList<Object> objHistory = new ArrayList();
    private final CharBuffer input;
    public static final Object NULL = new Object(){

        public String toString() {
            return "NULL";
        }
    };

    public PHPDeserializer(char[] input) {
        this.input = CharBuffer.wrap(input);
    }

    public PHPDeserializer(byte[] input) {
        this.input = CharBuffer.wrap(new String(input).toCharArray());
    }

    public PHPDeserializer(String input) {
        this.input = CharBuffer.wrap(input);
    }

    public Object parse() throws StreamCorruptedException {
        char type = this.input.get();
        switch (type) {
            case 'i': {
                this.indexPlus(1);
                return this.parseInt();
            }
            case 'd': {
                this.indexPlus(1);
                return this.parseFloat();
            }
            case 'b': {
                this.indexPlus(1);
                return this.parseBoolean();
            }
            case 's': {
                this.indexPlus(1);
                return this.parseString();
            }
            case 'a': {
                this.indexPlus(1);
                return this.parseArray();
            }
            case 'O': {
                this.indexPlus(1);
                return this.parseObject();
            }
            case 'N': {
                this.indexPlus(1);
                this.objHistory.add(new Object());
                return null;
            }
            case 'R': 
            case 'r': {
                this.indexPlus(1);
                int reference = Integer.valueOf(this.parseInt().toString());
                if (reference > this.objHistory.size()) {
                    throw new StreamCorruptedException("Reference is pointing to an element bigger than the history");
                }
                Object refObject = this.objHistory.get(reference);
                return refObject;
            }
        }
        return new PhpObject();
    }

    private Object parseObject() throws StreamCorruptedException {
        int strLen = this.readLength();
        this.indexPlus(1);
        String className = "";
        int r = 0;
        while (this.input.remaining() > 0 && r < strLen) {
            char ch = this.input.get();
            className = className.concat(String.valueOf(ch));
            ++r;
        }
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        this.indexPlus(2);
        int attrLen = this.readLength();
        this.indexPlus(1);
        int i = 0;
        while (i < attrLen) {
            block10: {
                Object tmp = this.parse();
                String key = "";
                try {
                    if (tmp instanceof CharBuffer) {
                        CharBuffer tmpChar = (CharBuffer)tmp;
                        tmpChar.rewind();
                        StringBuffer objName = new StringBuffer();
                        tmpChar.mark();
                        block4: while (tmpChar.remaining() > 0) {
                            Character ch = Character.valueOf(tmpChar.get());
                            if (!ch.equals(Character.valueOf('\u0000'))) continue;
                            while (tmpChar.remaining() > 0) {
                                ch = Character.valueOf(tmpChar.get());
                                if (ch.equals(Character.valueOf('\u0000'))) break block4;
                                objName.append(ch);
                            }
                            break block4;
                        }
                        if (objName.length() == 0) {
                            tmpChar.rewind();
                        }
                        key = tmpChar.toString();
                    } else {
                        key = tmp.toString();
                    }
                }
                catch (Throwable e) {
                    break block10;
                }
                Object value = this.parse();
                if (value instanceof CharBuffer) {
                    value = value.toString();
                }
                attributes.put(key, value);
                this.objHistory.add(value);
            }
            ++i;
        }
        this.indexPlus(1);
        Object serObj = Reflection.wakeUp(className, attributes);
        this.objHistory.add(serObj);
        return serObj;
    }

    private Object parseArray() throws StreamCorruptedException {
        ArrayList resultObj;
        int arrayLen = this.readLength();
        this.indexPlus(1);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        int i = 0;
        while (i < arrayLen) {
            block8: {
                Object tmp = this.parse();
                String key = "";
                try {
                    key = tmp.toString();
                }
                catch (Throwable e) {
                    break block8;
                }
                Object value = this.parse();
                result.put(key, value);
                this.objHistory.add(value);
            }
            ++i;
        }
        this.indexPlus(1);
        if (result.containsKey("_DRClassName")) {
            String className = (String)result.get("_DRClassName");
            result.remove("_DRClassName");
            resultObj = Reflection.wakeUp(className, result);
        } else if (result.size() > 0 && !Functions.isAssociativeArray(result)) {
            ArrayList resultArr = new ArrayList();
            LinkedHashMap<String, Object> map = result;
            for (Map.Entry entry : map.entrySet()) {
                resultArr.add(entry.getValue());
            }
            resultObj = resultArr;
        } else {
            resultObj = result;
        }
        this.objHistory.add(resultObj);
        return resultObj;
    }

    private int readLength() throws StreamCorruptedException {
        StringBuffer lenStr = new StringBuffer();
        while (this.input.remaining() > 0) {
            char ch = this.input.get();
            if (ch == ':') break;
            lenStr.append(ch);
        }
        int arrayLen = 0;
        try {
            arrayLen = Integer.valueOf(lenStr.toString());
        }
        catch (Throwable e) {
            throw new StreamCorruptedException("Integer of length failed to serialize");
        }
        return arrayLen;
    }

    private Object parseString() throws StreamCorruptedException {
        int strLen = this.readLength();
        this.indexPlus(1);
        CharBuffer cb = CharBuffer.allocate(strLen);
        boolean containsZeroChar = false;
        int r = 0;
        while (r < strLen) {
            char ch;
            try {
                ch = this.input.get();
                if (ch == '\u0000') {
                    containsZeroChar = true;
                }
            }
            catch (Throwable e) {
                throw new StreamCorruptedException("Char failed to parse, got " + cb.toString() + " so far");
            }
            cb.put(ch);
            ++r;
        }
        this.indexPlus(2);
        cb.rewind();
        String test = cb.toString();
        CharSequence output = !containsZeroChar ? test : cb;
        this.objHistory.add(output);
        return output;
    }

    private void indexPlus(int inc) {
        int r = 0;
        while (r < inc) {
            this.input.get();
            ++r;
        }
    }

    private Boolean parseBoolean() throws StreamCorruptedException {
        StringBuffer lenStr = new StringBuffer();
        while (this.input.remaining() > 0) {
            char ch = this.input.get();
            if (ch == ';') break;
            lenStr.append(ch);
        }
        if (lenStr.toString().equals("1")) {
            lenStr = new StringBuffer().append("true");
        } else if (lenStr.toString().equals("0")) {
            lenStr = new StringBuffer().append("false");
        } else {
            throw new StreamCorruptedException("Boolean has invalid value of " + lenStr);
        }
        if (lenStr.length() == 0) {
            throw new StreamCorruptedException("Boolean has no value");
        }
        Boolean value = null;
        try {
            value = Boolean.valueOf(lenStr.toString());
        }
        catch (Throwable e) {
            throw new StreamCorruptedException("boolean " + lenStr.toString() + " failed to deserialize");
        }
        this.objHistory.add(value);
        return value;
    }

    private Double parseFloat() throws StreamCorruptedException {
        StringBuffer lenStr = new StringBuffer();
        while (this.input.remaining() > 0) {
            char ch = this.input.get();
            if (ch == ';') break;
            lenStr.append(ch);
        }
        Double value = 0.0;
        try {
            value = Double.valueOf(lenStr.toString());
        }
        catch (Throwable e) {
            throw new StreamCorruptedException("Float value" + lenStr.toString() + " failed to go to float at" + String.valueOf(this.input.position()));
        }
        this.objHistory.add(value);
        return value;
    }

    private Integer parseInt() throws StreamCorruptedException {
        StringBuffer lenStr = new StringBuffer();
        while (this.input.remaining() > 0) {
            char ch = this.input.get();
            if (ch == ';') break;
            lenStr.append(ch);
        }
        Integer value = 0;
        try {
            value = Integer.valueOf(lenStr.toString());
        }
        catch (Throwable e) {
            throw new StreamCorruptedException("Integer value" + lenStr + " failed to go to float at" + String.valueOf(this.input.position()));
        }
        this.objHistory.add(value);
        return value;
    }

    public static Object unserialize(byte[] objBytes) {
        Object returnObject;
        PHPDeserializer serializedPhpParser = new PHPDeserializer(objBytes);
        try {
            returnObject = serializedPhpParser.parse();
        }
        catch (Throwable e) {
            return null;
        }
        if (returnObject instanceof String && PHPSerializer.isSerialized((String)returnObject)) {
            returnObject = Functions.unserialize((String)returnObject);
        }
        if (returnObject == null) {
            return null;
        }
        if (returnObject instanceof PhpObject) {
            PhpObject phpo = (PhpObject)returnObject;
            return phpo.getRealObject();
        }
        serializedPhpParser.objHistory.clear();
        return returnObject;
    }

    public static boolean isSerialized(String string) {
        if (Functions.isEmpty(string)) {
            return false;
        }
        if (string.equals("N;")) {
            return true;
        }
        String prefix = string.substring(0, 2);
        String[] checks = new String[]{"a:", "O:", "s:", "i:", "b:", "d:"};
        ArrayList<String> check = new ArrayList<String>(Arrays.asList(checks));
        return check.contains(prefix);
    }
}

