/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.ConnectionLostException;
import com.detectright.core.DBLink;
import com.detectright.core.Datapoint;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.Functions;
import com.detectright.core.State;
import com.detectright.core.StateCollection;
import com.detectright.core.Validator;
import java.util.ArrayList;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QDTMessage {
    public StateCollection sc;
    public ArrayList<String> wildcards = new ArrayList();
    public LinkedHashMap<String, ArrayList<String>> edits;
    public ArrayList<Datapoint> datapoints;
    public String path = "";
    public String brand = "";
    public String defaultState = "1:50:1";
    public int valid = 1;
    private ArrayList<QDTMessage> ps = new ArrayList();

    public static void main(String[] args) {
    }

    public QDTMessage(String string) throws DetectRightException, ConnectionLostException {
        this(string, null, 0, "");
    }

    public QDTMessage(String string, ArrayList<String> wildcards) throws DetectRightException, ConnectionLostException {
        this(string, wildcards, 0, "");
    }

    public QDTMessage(String string, ArrayList<String> wildcards, int importanceOffset) throws DetectRightException, ConnectionLostException {
        this(string, wildcards, importanceOffset, "", "");
    }

    public QDTMessage(String string, ArrayList<String> wildcards, int importanceOffset, String brand) throws DetectRightException, ConnectionLostException {
        this(string, wildcards, importanceOffset, brand, "");
    }

    public QDTMessage(String string, ArrayList<String> wildcards, int importanceOffset, String brand, String validation_type) throws DetectRightException, ConnectionLostException {
        if (wildcards == null) {
            wildcards = new ArrayList();
        }
        this.sc = new StateCollection();
        this.datapoints = new ArrayList();
        this.edits = new LinkedHashMap();
        this.edits.put("", new ArrayList());
        this.brand = brand;
        if (Functions.isEmpty(string)) {
            return;
        }
        string = Functions.str_replace("://", "{cdbs}", string);
        ArrayList<String> tmp = Functions.explode("//", string);
        String command = Functions.nn(Functions.array_pop(tmp));
        this.path = Functions.implode("//", tmp);
        command = Functions.str_replace("{cdbs}", "://", command);
        this.path = Functions.str_replace("{cdbs}", "://", this.path);
        ArrayList<String> commands = Functions.explode("&/&", command);
        commands = this.sc.extractStates(commands);
        if (importanceOffset != 0) {
            this.sc.addImportance(importanceOffset);
        }
        int importance = this.sc.getImportance();
        int i = 0;
        while (i < wildcards.size()) {
            String wildCardString = wildcards.get(i);
            if (!Functions.isEmpty(validation_type) && !validation_type.equals("none")) {
                this.wildcards.add(this.validateWildcardString(wildCardString, validation_type, Math.round((double)importance * 0.75)));
            } else {
                this.wildcards.add(wildCardString);
            }
            ++i;
        }
        ArrayList<String> dpWildcards = (ArrayList<String>)this.wildcards.clone();
        boolean pathWildcards = false;
        if (!this.path.equals("") && Functions.substr(this.path, -2, 2).equals(":*")) {
            if (wildcards.size() == 0) {
                this.valid = 0;
                this.path = "";
                return;
            }
            pathWildcards = true;
            dpWildcards = new ArrayList<String>();
            for (String wildCardString : this.wildcards) {
                this.edits.put(wildCardString, new ArrayList());
            }
            this.path = Functions.substr(this.path, 0, -2);
        }
        this.wildcards = wildcards;
        for (String cmd : commands) {
            if (Functions.strpos(cmd, "{") > -1 && Functions.strpos(cmd, "}") > -1) {
                if (dpWildcards.size() == 0) {
                    dpWildcards.add("");
                }
                int i2 = 0;
                while (i2 < dpWildcards.size()) {
                    String dpw = (String)dpWildcards.get(i2);
                    if (Functions.strpos(cmd, "*") <= -1 || !Functions.isEmpty(dpw)) {
                        dpw = Functions.str_replace(";", "\\;", dpw);
                        Datapoint datapoint = new Datapoint(cmd, dpw);
                        if (datapoint.importance == 0) {
                            datapoint.importance = importance;
                        }
                        this.validateDP(datapoint, Math.round((double)importance * 0.75));
                        datapoint.importanceOffset = importanceOffset;
                        if (!Functions.isEmpty(brand)) {
                            datapoint.brand(brand);
                        }
                        this.datapoints.add(datapoint);
                    }
                    ++i2;
                }
                continue;
            }
            if (pathWildcards) {
                for (String wildCardString : this.wildcards) {
                    this.edits.get(wildCardString).add(cmd);
                }
                continue;
            }
            this.edits.get("").add(cmd);
        }
    }

    public boolean isPath() {
        if (this.path == null) {
            return false;
        }
        String map = this.path;
        if (Functions.isEmpty(map)) {
            return false;
        }
        if (map.contains("://")) {
            map = Functions.str_replace("://", "{cdbs}", map);
        }
        return Functions.strpos(map, "//") > -1;
    }

    public String shiftPath() {
        String map = Functions.str_replace("://", "{cdbs}", this.path);
        ArrayList<String> array = Functions.explode("//", map);
        String path = Functions.nn(Functions.array_shift(array));
        this.path = map = Functions.str_replace("{cdbs}", "://", Functions.implode("//", array));
        return path;
    }

    public void pkgToPS(ArrayList<String> pkg) throws DetectRightException, ConnectionLostException {
        this.pkgToPS(pkg, 0L);
    }

    public void pkgToPS(ArrayList<String> pkg, long importance) throws DetectRightException, ConnectionLostException {
        if (pkg == null) {
            return;
        }
        int pcKey = 0;
        while (pcKey < pkg.size()) {
            String pcValue = pkg.get(pcKey);
            if (Functions.substr(pcValue, 0, 1).equals("+")) {
                pcValue = Functions.substr(pcValue, 1);
                if (!this.path.equals("")) {
                    pkg.set(pcKey, this.path.concat("//" + pcValue));
                } else {
                    ArrayList<String> tmp = Functions.explode("//", pcValue);
                    String branch = (String)Functions.array_shift(tmp);
                    tmp = Functions.explode(":", branch);
                    branch = (String)Functions.array_shift(tmp);
                    DBLink dbl = DetectRight.getDBLink();
                    String path = "";
                    if (dbl != null) {
                        LinkedHashMap<String, Object> hints = dbl.getArray("PathHints");
                        path = Functions.gvString(hints, branch);
                    }
                    if (Functions.isEmpty(path)) {
                        path = "System//";
                    }
                    if (!path.endsWith("//")) {
                        path = String.valueOf(path) + "//";
                    }
                    pkg.set(pcKey, String.valueOf(path) + pcValue);
                }
            }
            ++pcKey;
        }
        if (pkg.size() == 0) {
            return;
        }
        State state = this.sc.getCollapsedState();
        if (state == null) {
            state = new State(this.defaultState);
        }
        for (String string : pkg) {
            if (!Functions.in("status", string)) {
                string = String.valueOf(string) + "&/&status->" + String.valueOf(state.getStatus());
            }
            if (importance == 0L) {
                importance = state.getImportance();
            }
            string = string.concat("&/&importance->" + String.valueOf(importance));
            QDTMessage ps = new QDTMessage(string, new ArrayList<String>());
            this.ps.add(ps);
        }
    }

    public String validateWildcardString(String wildcard, String validation_type) throws DetectRightException, ConnectionLostException {
        return this.validateWildcardString(wildcard, validation_type, 0L);
    }

    public String validateWildcardString(String wildcard, String validation_type, long importance) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(validation_type)) {
            return wildcard;
        }
        if (Functions.isEmpty(wildcard)) {
            return wildcard;
        }
        ArrayList<String> pkg = new ArrayList<String>();
        wildcard = Functions.nn(Validator.validateWithPC(validation_type, wildcard, false, pkg));
        this.pkgToPS(pkg, importance);
        return wildcard;
    }

    public void validateDP(Datapoint datapoint) throws DetectRightException, ConnectionLostException {
        this.validateDP(datapoint, 0L);
    }

    public void validateDP(Datapoint datapoint, long importance) throws DetectRightException, ConnectionLostException {
        if (datapoint == null) {
            return;
        }
        if (datapoint.type == null) {
            return;
        }
        String validation_type = datapoint.type.toLowerCase();
        if (validation_type.equals("none") || Functions.isEmpty(validation_type)) {
            return;
        }
        ArrayList<String> pkg = new ArrayList<String>();
        if (!Functions.isEmpty(datapoint.value) && Functions.strpos(datapoint.value, "*") == -1) {
            datapoint.value = Functions.nn(Validator.validateWithPC(validation_type, datapoint.value, false, pkg));
        }
        if (!Functions.isEmpty(datapoint.wildcard)) {
            datapoint.wildcard = Functions.nn(Validator.validateWithPC(validation_type, datapoint.wildcard, false, pkg));
        }
        this.pkgToPS(pkg, importance);
        datapoint.validated = true;
    }

    public ArrayList<QDTMessage> getExtraMessages() {
        return this.ps;
    }

    public LinkedHashMap<String, ArrayList<String>> getEdits() {
        return this.edits;
    }

    public ArrayList<Datapoint> getDatapoints() {
        return this.datapoints;
    }
}

