/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.ConnectionLostException;
import com.detectright.core.Datapoint;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.EntityCore;
import com.detectright.core.Functions;
import com.detectright.core.QDTMessage;
import com.detectright.core.QuantumDataCollection;
import com.detectright.core.Reflection;
import com.detectright.core.State;
import com.detectright.core.StateCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuantumDataTree {
    public QuantumDataTree top = null;
    public QuantumDataTree parent = null;
    public String value;
    public String descriptor = "";
    public LinkedHashMap<String, QuantumDataTree> tree = new LinkedHashMap();
    public ArrayList<String> brand = new ArrayList();
    public LinkedHashMap<String, QuantumDataTree> index = new LinkedHashMap();
    public String entitytype;
    public String category;
    public String description;
    public String subclass;
    public String majorrevision;
    public String minorrevision;
    public String connection;
    public String build;
    public boolean isClosed = false;
    public int access_count = 0;
    public LinkedHashMap<String, Object> metadata = new LinkedHashMap();
    public boolean useSubtree = false;
    public boolean locked = false;
    public QuantumDataCollection qdc;
    public long entityid = -1L;
    private EntityCore entity;
    private Object object;
    public ArrayList<LinkedHashMap<String, Object>> pkg = new ArrayList();
    private StateCollection sc = new StateCollection();

    public static void main(String[] args) {
    }

    public QuantumDataTree() {
        this("", null);
    }

    public int status() {
        int status = this.sc.getStatus();
        return status;
    }

    public QuantumDataTree(String value, QuantumDataTree parent) {
        if (!Functions.is_null(parent)) {
            this.parent = parent;
            this.top = parent.top;
        }
        this.value = value;
        this.qdc = new QuantumDataCollection("AUTO");
        this.tree = new LinkedHashMap();
        this.pkg = new ArrayList();
        this.sc = new StateCollection();
    }

    public void __wakeup() {
        this.relinkTree();
        this.access_count = 0;
        this.useSubtree = false;
    }

    public ArrayList<String> __sleep() {
        LinkedHashMap<String, Object> ov = Reflection.get_object_vars(this);
        ov.remove("entity");
        ov.remove("object");
        ov.remove("useSubtree");
        ov.remove("locked");
        ov.remove("parent");
        ov.remove("top");
        ov.remove("index");
        return Functions.array_keys_string(ov);
    }

    public void setStatus(int statusInt, int importance, int directHit) {
        this.sc.addState(statusInt, importance, directHit);
    }

    public void setStatus(String stateString) {
        this.sc.addState(stateString);
    }

    public void reindex() {
    }

    void setSource(String source) {
        this.qdc.setSource(source);
        ArrayList<String> treeKeys = Functions.array_keys_string(this.tree);
        for (String treeKey : treeKeys) {
            QuantumDataTree qdt = this.tree.get(treeKey);
            if (qdt == null) continue;
            qdt.setSource(source);
        }
    }

    public static QuantumDataTree unpackage(ArrayList<String> pkg) throws DetectRightException, ConnectionLostException {
        QuantumDataTree qdt = new QuantumDataTree("", null);
        if (pkg == null) {
            return qdt;
        }
        for (String pkgPart : pkg) {
            if (pkgPart == null) continue;
            QDTMessage qdtMessage = new QDTMessage(pkgPart);
            qdt.deliverQDTMessage(qdtMessage);
        }
        return qdt;
    }

    public void insertPackage(ArrayList<String> pkg) throws DetectRightException, ConnectionLostException {
        if (pkg == null) {
            return;
        }
        for (String pkgPart : pkg) {
            if (pkgPart == null) continue;
            QDTMessage qdtMessage = new QDTMessage(pkgPart);
            this.deliverQDTMessage(qdtMessage);
        }
    }

    public void addEntity(String path, EntityCore entity) {
        this.addEntity(path, entity, 0);
    }

    public void addEntity(String path, EntityCore entity, int importanceOffset) {
        if (entity == null) {
            return;
        }
        if (path == null) {
            return;
        }
        String descriptor = entity.descriptor();
        path = String.valueOf(path) + "//" + descriptor;
        ArrayList<String> pkg = new ArrayList<String>();
        pkg.add(String.valueOf(path) + "//status=1");
        if (entity.id() > 0L) {
            pkg.add(String.valueOf(path) + "//entityid=" + entity.id());
        }
        this.addPackage(pkg, importanceOffset, entity.descriptor());
    }

    public void resetRootEntity(EntityCore entity) throws DetectRightException, ConnectionLostException {
        if (entity == null) {
            return;
        }
        if (entity.entitytype == null) {
            return;
        }
        if (entity.ID > 0L) {
            this.entityid = entity.ID;
        }
        this.entity = entity;
        String descriptor = String.valueOf(entity.descriptor()) + "//sc->1:1000:1";
        QDTMessage qdtm = new QDTMessage(descriptor);
        this.deliverQDTMessage(qdtm);
    }

    public void addObject(String path, Object object) throws DetectRightException {
        if (object == null) {
            return;
        }
        if (path == null) {
            return;
        }
        QuantumDataTree qdt = this.addNode(path, path);
        qdt.object = object;
    }

    public QuantumDataTree clone() {
        QuantumDataTree qdtClone = new QuantumDataTree(this.value, this.parent);
        qdtClone.descriptor = this.descriptor;
        if (this.brand != null) {
            qdtClone.brand.addAll(this.brand);
        }
        qdtClone.entitytype = this.entitytype;
        qdtClone.category = this.category;
        qdtClone.description = this.description;
        qdtClone.subclass = this.subclass;
        qdtClone.majorrevision = this.majorrevision;
        qdtClone.minorrevision = this.minorrevision;
        qdtClone.entityid = this.entityid;
        qdtClone.connection = this.connection;
        qdtClone.build = this.build;
        qdtClone.access_count = this.access_count;
        if (this.metadata != null) {
            qdtClone.metadata.putAll(this.metadata);
        }
        qdtClone.useSubtree = this.useSubtree;
        qdtClone.entity = this.entity;
        qdtClone.object = this.object;
        qdtClone.locked = false;
        if (this.pkg != null) {
            qdtClone.pkg.addAll(this.pkg);
        }
        if (this.qdc != null) {
            qdtClone.qdc = this.qdc.clone();
        }
        qdtClone.sc.addSC(this.sc);
        if (this.tree != null && this.tree.size() > 0) {
            ArrayList<String> treeKeys = Functions.array_keys_string(this.tree);
            for (String treeKey : treeKeys) {
                QuantumDataTree qdt = this.tree.get(treeKey);
                if (qdt == null) continue;
                qdtClone.tree.put(treeKey, qdt.clone());
            }
        }
        return qdtClone;
    }

    public void lock() {
        this.applyLock(true);
    }

    public void unlock() {
        this.applyLock(false);
    }

    private void applyLock(boolean lockValue) {
        this.locked = lockValue;
        if (this.qdc != null) {
            this.qdc.applyLock(lockValue);
        }
        if (this.tree == null) {
            return;
        }
        ArrayList<String> keys = Functions.array_keys_string(this.tree);
        for (String key : keys) {
            QuantumDataTree qdt = this.tree.get(key);
            if (qdt == null) continue;
            qdt.applyLock(lockValue);
        }
    }

    boolean getZeroCountQDTs(ArrayList<QuantumDataTree> list) {
        if (list == null) {
            return false;
        }
        if (this.access_count == 0) {
            list.add(this);
            return true;
        }
        if (list.size() < 10) {
            ArrayList<String> keys = Functions.array_keys_string(this.tree);
            for (String key : keys) {
                this.tree.get(key).getZeroCountQDTs(list);
            }
            return true;
        }
        return false;
    }

    boolean preprune() {
        ArrayList<QuantumDataTree> list = new ArrayList<QuantumDataTree>();
        ArrayList<String> keys = Functions.array_keys_string(this.tree);
        for (String key : keys) {
            boolean success = this.tree.get(key).getZeroCountQDTs(list);
            if (!success) break;
        }
        int r = 0;
        while (r < list.size()) {
            if (Functions.is_object(list.get(r))) {
                list.get(r).close();
            }
            list.set(r, null);
            ++r;
        }
        return true;
    }

    public void prune() {
        if (this.locked) {
            return;
        }
        ArrayList<String> keys = Functions.array_keys_string(this.tree);
        for (String key : keys) {
            QuantumDataTree qdt = this.tree.get(key);
            qdt.prune();
            if (!qdt.isEmpty()) continue;
            qdt = null;
            this.tree.remove(key);
        }
        if (this.access_count == 0) {
            this.close();
        } else {
            this.qdc.prune();
        }
    }

    public ArrayList<String> packageMe() {
        return this.packageMe(false);
    }

    public ArrayList<String> packageMe(boolean optimize) {
        String path = this.getPath();
        ArrayList<String> pkg = new ArrayList<String>();
        ArrayList<Object> nodePackage = new ArrayList();
        if (this.qdc != null && (nodePackage = this.qdc.toStringArray("", optimize)) == null) {
            nodePackage = new ArrayList();
        }
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("brand", this.brand);
        values.put("sc", this.sc);
        values.put("metadata", this.metadata);
        values.put("useSubtree", this.useSubtree);
        values.put("entityid", this.entityid);
        boolean doBool = true;
        if (optimize) {
            doBool = false;
            if (this.access_count > 0) {
                doBool = true;
            }
        }
        if (doBool) {
            if (this.sc == null) {
                doBool = false;
            } else {
                State state = this.sc.getCollapsedState();
                if (state == null) {
                    doBool = false;
                } else {
                    Integer dh = state.getDirectHit();
                    if (dh == 0) {
                        doBool = true;
                        ArrayList<String> treeKeys = Functions.array_keys_string(this.tree);
                        for (String key : treeKeys) {
                            QuantumDataTree testTree = this.tree.get(key);
                            if (testTree.access_count <= 0) continue;
                            doBool = false;
                            break;
                        }
                    }
                }
            }
        }
        if (nodePackage.size() > 0) {
            doBool = true;
        }
        if (doBool) {
            for (Map.Entry entry : values.entrySet()) {
                String key = (String)entry.getKey();
                if (key == null) continue;
                Object value = entry.getValue();
                if (value != null && !Functions.is_array(value) && !Functions.isEmpty(value)) {
                    String valueStr = value.toString();
                    valueStr = Functions.str_replace("\\n", "", valueStr);
                    valueStr = Functions.str_replace("\\t", "", valueStr);
                    if ((valueStr = Functions.str_replace("\\r", "", valueStr)).equals("false")) {
                        valueStr = "0";
                    }
                    if (valueStr.equals("true")) {
                        valueStr = "1";
                    }
                    if (key.equals("entityid") && valueStr.equals("-1") || key.equals("useSubtree") && valueStr.equals("0")) continue;
                    nodePackage.add(String.valueOf(key) + "->" + valueStr);
                    continue;
                }
                if (!Functions.is_array(value)) continue;
                if (value instanceof ArrayList) {
                    ArrayList valueArr = (ArrayList)value;
                    for (Object o : valueArr) {
                        if (o == null) continue;
                        try {
                            String tmpValue = o.toString();
                            nodePackage.add(String.valueOf(key) + "-->" + tmpValue);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                if (!(value instanceof LinkedHashMap)) continue;
                boolean assoc = Functions.isAssociativeArray((Map)value);
                Map tmpMap2 = (Map)value;
                for (Map.Entry tmpEntry : tmpMap2.entrySet()) {
                    String tmpKey = Functions.nn((String)tmpEntry.getKey());
                    String tmpValue = Functions.nn(tmpEntry.getValue());
                    if (assoc) {
                        nodePackage.add(String.valueOf(key) + "-->" + tmpKey + "^" + tmpValue);
                        continue;
                    }
                    nodePackage.add(String.valueOf(key) + "-->" + tmpValue);
                }
            }
        }
        if (nodePackage.size() > 0) {
            String string = Functions.implode("&/&", nodePackage);
            pkg.add(String.valueOf(path) + "//" + string);
        }
        if (this.tree != null) {
            LinkedHashMap<String, QuantumDataTree> treeMap = this.tree;
            for (Map.Entry entry : treeMap.entrySet()) {
                QuantumDataTree qdt = (QuantumDataTree)entry.getValue();
                if (qdt == null) continue;
                ArrayList<String> qdtPackage = qdt.packageMe(optimize);
                pkg.addAll(qdtPackage);
            }
        }
        return pkg;
    }

    public ArrayList<LinkedHashMap<String, Object>> getPackages() {
        if (this.pkg == null) {
            return new ArrayList<LinkedHashMap<String, Object>>();
        }
        return this.pkg;
    }

    public void addQDT(QuantumDataTree qdt) {
        if (qdt == null) {
            return;
        }
        ArrayList<LinkedHashMap<String, Object>> packages = qdt.getPackages();
        this.pkg.addAll(packages);
    }

    public void relinkTree() {
        ArrayList<String> keys = Functions.array_keys_string(this.tree);
        for (String key : keys) {
            QuantumDataTree qdt = this.tree.get(key);
            if (qdt == null) continue;
            qdt.top = this;
            qdt.relink(this);
        }
    }

    public void relink(QuantumDataTree parent) {
        if (parent == null) {
            return;
        }
        this.top = parent.top == null ? parent : parent.top;
        this.parent = parent;
        ArrayList<String> keys = Functions.array_keys_string(this.tree);
        for (String key : keys) {
            QuantumDataTree qdt = this.tree.get(key);
            qdt.relink(this);
        }
    }

    public boolean isEmpty() {
        if (this.locked) {
            return false;
        }
        if (this.access_count > 0) {
            return false;
        }
        if (this.tree != null && !this.tree.isEmpty()) {
            return false;
        }
        if (this.qdc != null && this.qdc.propSize() > 0) {
            return false;
        }
        return this.entityid <= 0L;
    }

    public void subsume(QuantumDataTree qdt) throws DetectRightException, ConnectionLostException {
        if (qdt == null) {
            return;
        }
        if (this.pkg == null) {
            this.pkg = new ArrayList();
        }
        if (this.pkg.size() > 0) {
            this.processPackages();
        }
        if (qdt.getPackages().size() > 0) {
            qdt.processPackages();
        }
        if (qdt.tree != null) {
            ArrayList<String> keys = Functions.array_keys_string(qdt.tree);
            for (String key : keys) {
                QuantumDataTree thatQDT = qdt.tree.get(key);
                if (thatQDT == null) continue;
                if (this.tree.containsKey(key)) {
                    QuantumDataTree thisQDT = this.tree.get(key);
                    thisQDT.subsume(thatQDT);
                    if (!thatQDT.locked) {
                        thatQDT.close();
                    }
                    thatQDT = null;
                } else {
                    this.tree.put(key, thatQDT);
                }
                if (qdt.locked) continue;
                qdt.tree.remove(key);
            }
        }
        this.merge(qdt);
    }

    public void merge(QuantumDataTree qdt) throws DetectRightException {
        if (qdt == null) {
            return;
        }
        if (!Functions.isEmpty(qdt.descriptor)) {
            if (Functions.isEmpty(this.descriptor)) {
                this.descriptor = qdt.descriptor;
                this.addNode("System", Functions.nn(qdt.descriptor), 999, 1, 1);
            } else if (!qdt.descriptor.equals(this.descriptor)) {
                if (qdt.parent == null && this.parent == null) {
                    this.addNode("System", Functions.nn(qdt.descriptor), 999, 1, 1);
                } else {
                    return;
                }
            }
        }
        try {
            if (this.qdc == null) {
                this.qdc = qdt.qdc;
            } else if (qdt.qdc != null) {
                this.qdc.addQDC(qdt.qdc);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.entity == null && qdt.entity != null) {
            this.entityid = qdt.entityid;
            this.entity = qdt.entity;
        }
        if (this.brand == null) {
            this.brand = new ArrayList();
        }
        if (qdt.brand != null) {
            this.brand.addAll(qdt.brand);
        }
        if (this.object == null && qdt.object != null) {
            this.object = qdt.object;
        }
        if (this.metadata == null) {
            this.metadata = new LinkedHashMap();
        }
        if (qdt.metadata != null) {
            this.metadata.putAll(qdt.metadata);
        }
        if (this.sc == null) {
            this.sc = new StateCollection();
        }
        if (qdt.sc != null) {
            this.sc.addSC(qdt.sc);
        }
    }

    public void processPackages() throws DetectRightException, ConnectionLostException {
        DetectRight.checkPoint("Processing packages");
        if (this.pkg == null) {
            return;
        }
        for (LinkedHashMap<String, Object> arrayObj : this.pkg) {
            Object pkgObj;
            if (!(arrayObj instanceof LinkedHashMap)) continue;
            LinkedHashMap<String, Object> array = arrayObj;
            int importanceOffset = 0;
            if (!array.containsKey("package")) continue;
            if (array.containsKey("importanceOffset")) {
                importanceOffset = Functions.parseInt(array.get("importanceOffset").toString());
            }
            String brand = "";
            if (array.containsKey("brand")) {
                brand = (String)array.get("brand");
            }
            if (!((pkgObj = array.get("package")) instanceof ArrayList)) continue;
            ArrayList pkg = (ArrayList)pkgObj;
            for (String string : pkg) {
                QDTMessage qdtMessage = new QDTMessage(string, null, importanceOffset, brand);
                this.deliverQDTMessage(qdtMessage);
            }
        }
        this.pkg.clear();
        DetectRight.checkPoint("Processed packages");
    }

    public void addPackage(ArrayList<String> pkg, int importanceOffset) {
        this.addPackage(pkg, importanceOffset, "");
    }

    public void addPackage(ArrayList<String> pkg) {
        this.addPackage(pkg, 0, "");
    }

    public void addPackage(ArrayList<String> pkg, int importanceOffset, String brand) {
        if (pkg == null) {
            return;
        }
        if (brand == null) {
            brand = "";
        }
        LinkedHashMap<String, Object> newHM = new LinkedHashMap<String, Object>();
        if (this.pkg == null) {
            this.pkg = new ArrayList();
        }
        newHM.put("package", pkg);
        newHM.put("importanceOffset", importanceOffset);
        newHM.put("brand", brand);
        this.pkg.add(newHM);
    }

    public void brand(String brand) {
        if (this.brand == null) {
            this.brand = new ArrayList();
        }
        if (!this.brand.contains(brand)) {
            this.brand.add(brand);
        }
    }

    public ArrayList<QuantumDataTree> getQDTsWithDescriptor(String descriptor) {
        if (this.tree == null) {
            this.tree = new LinkedHashMap();
        }
        ArrayList<QuantumDataTree> qdts = new ArrayList<QuantumDataTree>();
        if (descriptor == null || descriptor.equals("")) {
            return qdts;
        }
        if (this.descriptor != null && this.descriptor.equals(descriptor)) {
            qdts.add(this);
        }
        LinkedHashMap<String, QuantumDataTree> tmpMap = this.tree;
        for (Map.Entry entry : tmpMap.entrySet()) {
            QuantumDataTree qdt = (QuantumDataTree)entry.getValue();
            if (qdt == null) continue;
            ArrayList<QuantumDataTree> array = qdt.getQDTsWithDescriptor(descriptor);
            for (QuantumDataTree tmpqdt : array) {
                qdts.add(tmpqdt);
            }
        }
        return qdts;
    }

    public void recordAccess() {
        ++this.access_count;
        if (this.parent != null) {
            this.parent.recordAccess();
        }
    }

    public ArrayList<String> getDescriptors() {
        return this.getDescriptors(1, false);
    }

    public ArrayList<String> getDescriptors(int requiredStatus) {
        return this.getDescriptors(requiredStatus, false);
    }

    public ArrayList<String> getDescriptors(int requiredStatus, boolean includeImportances) {
        ArrayList<String> descriptors = new ArrayList<String>();
        if (!Functions.isEmpty(this.descriptor) && this.sc.getStatus() == requiredStatus) {
            if (includeImportances) {
                int importance = this.getImportance();
                descriptors.add(String.valueOf(this.descriptor) + "%/%" + importance);
            } else {
                descriptors.add(this.descriptor);
            }
        }
        LinkedHashMap<String, QuantumDataTree> tmpMap = this.tree;
        for (Map.Entry entry : tmpMap.entrySet()) {
            ArrayList<String> array;
            QuantumDataTree qdt = (QuantumDataTree)entry.getValue();
            if (qdt == null || (array = qdt.getDescriptors(requiredStatus, includeImportances)) == null) continue;
            ++qdt.access_count;
            for (String s : array) {
                if (s == null || descriptors.contains(s)) continue;
                if (s.endsWith(":")) {
                    s = Functions.substr(s, 0, -1);
                }
                if (s.indexOf(this.descriptor) != 0) continue;
                descriptors.add(s);
            }
        }
        return descriptors;
    }

    public void addDatapointToQDC(Datapoint datapoint) throws DetectRightException {
        if (datapoint == null) {
            return;
        }
        if (this.qdc == null) {
            this.qdc = new QuantumDataCollection(datapoint.brand);
        }
        DetectRight.checkPoint("Adding datapoint to QDC" + datapoint.command);
        this.addState(datapoint.getDataStatus(), datapoint.importance, 1);
        this.qdc.addDatapoint(datapoint);
        DetectRight.checkPoint("Added datapoint to QDC");
    }

    public ArrayList<Datapoint> getData(Datapoint datapoint) throws DetectRightException {
        ArrayList<Datapoint> datapoints = new ArrayList<Datapoint>();
        if (datapoint == null) {
            return datapoints;
        }
        if (this.qdc != null) {
            datapoints = this.qdc.getValueArrayFromExampleDP(datapoint);
        }
        if (this.useSubtree) {
            ArrayList<String> treeKeys = Functions.array_keys_string(this.tree);
            for (String treeKey : treeKeys) {
                ArrayList<Datapoint> dps;
                QuantumDataTree qdt = this.tree.get(treeKey);
                if (qdt == null || Functions.stripos(qdt.descriptor, this.descriptor) != 0 || (dps = qdt.getData(datapoint)) == null || dps.size() <= 0) continue;
                datapoints.addAll(dps);
            }
        }
        return datapoints;
    }

    public LinkedHashMap<String, QuantumDataTree> getChildren() {
        return this.tree;
    }

    public String getPath() {
        String path = Functions.is_object(this.parent) ? this.parent.getPath() : "";
        if (this.value != null && this.top != null) {
            path = Functions.in(":" + this.value, this.descriptor) ? String.valueOf(path) + ":" + this.value : String.valueOf(path) + "//" + this.value;
        }
        if (path.startsWith("//")) {
            path = Functions.substr(path, 2);
        }
        return path;
    }

    public void fillQDTWithDescriptor(QuantumDataTree descriptorQDT, String descriptor) {
        if (Functions.isEmpty(descriptor)) {
            return;
        }
        if (descriptorQDT == null) {
            return;
        }
        LinkedHashMap<String, QuantumDataTree> tmpMap = this.tree;
        if (tmpMap == null) {
            return;
        }
        if (this.descriptor.equals(descriptor)) {
            descriptorQDT.tree.put(this.getPath(), this);
        }
        for (Map.Entry entry : tmpMap.entrySet()) {
            QuantumDataTree qdt = (QuantumDataTree)entry.getValue();
            qdt.fillQDTWithDescriptor(descriptorQDT, descriptor);
        }
    }

    public static boolean hasProperty(String property) {
        return true;
    }

    public static boolean hasMethod(String property) {
        return true;
    }

    public String getDirectValue(String command) throws DetectRightException, ConnectionLostException {
        String resultStr;
        boolean doIt;
        if (command == null) {
            return "";
        }
        if (command == "") {
            return "";
        }
        Object result = new String("");
        if (command.equals("status")) {
            if (this.sc != null) {
                result = this.sc.getStatus();
                return result.toString();
            }
            return "";
        }
        boolean bl = doIt = this.sc != null && this.sc.getStatus() == 1;
        if (doIt) {
            if (command.equals("entitytype")) {
                return this.entitytype;
            }
            if (command.equals("category")) {
                return this.category;
            }
            if (command.equals("description")) {
                return this.description;
            }
            if (command.equals("descriptor")) {
                return this.descriptor;
            }
            if (command.equals("subclass")) {
                return this.subclass;
            }
            if (command.equals("majorrevision")) {
                return this.majorrevision;
            }
            if (command.equals("minorrevision")) {
                return this.minorrevision;
            }
            if (command.equals("build")) {
                return this.build;
            }
            if (command.equals("connection")) {
                return this.connection;
            }
            if (command.equals("value")) {
                return this.value;
            }
        }
        try {
            if (this.entityid > 0L && !Functions.is_object(this.entity)) {
                this.entity = EntityCore.get(this.entityid);
            }
            if (this.entity != null) {
                if (this.entity.hasProperty(command)) {
                    result = Reflection.getProperty(this.entity, command);
                } else if (this.entity.hasMethod(command)) {
                    result = Reflection.invokeMethod(this.entity, command);
                }
            } else if (Functions.is_object(this.object) && Reflection.property_exists(this.object, command)) {
                result = Reflection.getProperty(this.object, command);
            } else if (Functions.is_object(this.object) && Reflection.function_exists(this.object, command)) {
                result = Reflection.invokeMethod(this.object, command);
            }
        }
        catch (Throwable e) {
            return "";
        }
        if (result == null && doIt && Reflection.property_exists(this, command)) {
            try {
                result = Reflection.getProperty(this, command);
                if (!Functions.isEmpty(result)) {
                    return result.toString();
                }
            }
            catch (Throwable e) {
                return "";
            }
        }
        if (result == null) {
            return "";
        }
        try {
            resultStr = result.toString();
        }
        catch (Throwable e) {
            return "";
        }
        return resultStr;
    }

    public ArrayList<String> getDirectValueArray(String command, boolean includeRoot) throws DetectRightException, ConnectionLostException {
        return this.getDirectValueArray(command, includeRoot, true);
    }

    public ArrayList<String> getDirectValueArray(String command) throws DetectRightException, ConnectionLostException {
        return this.getDirectValueArray(command, false, true);
    }

    public ArrayList<String> getDirectValueArray(String command, boolean includeRoot, boolean includeImportances) throws DetectRightException, ConnectionLostException {
        ArrayList<String> output = new ArrayList<String>();
        if (Functions.isEmpty(command)) {
            return output;
        }
        String result = new String("");
        if (includeRoot) {
            result = this.getDirectValue(command);
            if (result != null && result.equals("true")) {
                result = "1";
            }
            if (result != null && result.equals("false")) {
                result = "0";
            }
            if (!Functions.isEmpty(result) && includeImportances) {
                output.add(String.valueOf(result) + "%/%" + this.getImportance());
            } else if (!Functions.isEmpty(result)) {
                output.add(result);
            }
        }
        if (!this.useSubtree) {
            return output;
        }
        LinkedHashMap<String, QuantumDataTree> tmpMap = this.tree;
        for (Map.Entry entry : tmpMap.entrySet()) {
            QuantumDataTree qdt = (QuantumDataTree)entry.getValue();
            if (qdt == null) continue;
            qdt.useSubtree = true;
            if (!qdt.descriptor.contains(this.descriptor)) continue;
            ++qdt.access_count;
            ArrayList<String> tmp = qdt.getDirectValueArray(command, true, includeImportances);
            for (String s : tmp) {
                if (output.contains(s)) continue;
                output.add(s);
            }
        }
        return output;
    }

    public boolean evaluateBool(String command) throws Exception {
        if (command == null) {
            return false;
        }
        ArrayList<String> comparitors = new ArrayList<String>();
        comparitors.addAll(Arrays.asList(" contains ", " in ", "<>", "!=", ">=", "<=", "=", "!", "<", ">"));
        String comparitor = "";
        String queryCommand = "";
        String compareValue = "";
        for (String testComparitor : comparitors) {
            if (!command.contains(testComparitor)) continue;
            ArrayList<String> tmp = Functions.explode(testComparitor, command);
            queryCommand = tmp.get(0).trim();
            compareValue = tmp.get(1).trim();
            comparitor = testComparitor;
            break;
        }
        if (Functions.isEmpty(comparitor)) {
            return false;
        }
        if (Functions.isEmpty(queryCommand)) {
            return false;
        }
        String queryValue = this.getDirectValue(queryCommand);
        if (compareValue.endsWith("*")) {
            compareValue = Functions.substr(compareValue, 0, -1);
            if (Functions.strlen(queryValue) > Functions.strlen(compareValue)) {
                queryValue = Functions.substr(queryValue, 0, Functions.strlen(compareValue));
            }
        }
        boolean result = false;
        if (comparitor.trim().equals("in")) {
            result = false;
            ArrayList<String> compare = Functions.explode(",", compareValue);
            for (String compareStr : compare) {
                boolean doBool = false;
                if (queryValue.equals(compareStr)) {
                    doBool = true;
                }
                if (Functions.substr(compareStr, -1, 1).equals("*") && Functions.substr(compareStr, 0, -1).equals(Functions.substr(queryValue, 0, Functions.strlen(compareStr) - 1))) {
                    doBool = true;
                }
                if (!doBool) continue;
                result = true;
                break;
            }
        } else {
            result = comparitor.trim().equals("contains") ? Functions.stripos(queryValue, compareValue) > -1 : Functions.compares(queryValue, compareValue, comparitor);
        }
        return result;
    }

    public boolean getBoolean(String command, String mode) throws Exception {
        boolean boolResult2;
        ArrayList<Boolean> results;
        block17: {
            block16: {
                if (Functions.isEmpty(command)) {
                    return false;
                }
                if (Functions.isEmpty(mode)) {
                    mode = "and";
                }
                ++this.access_count;
                results = new ArrayList<Boolean>();
                boolResult2 = this.evaluateBool(command);
                if (boolResult2 || !mode.equals("and")) break block16;
                return false;
            }
            if (!boolResult2 || !mode.equals("none")) break block17;
            return false;
        }
        try {
            results.add(new Boolean(boolResult2));
        }
        catch (Throwable boolResult2) {
            // empty catch block
        }
        if (this.useSubtree) {
            LinkedHashMap<String, QuantumDataTree> tmpMap = this.tree;
            for (Map.Entry entry : tmpMap.entrySet()) {
                try {
                    QuantumDataTree qdt = (QuantumDataTree)entry.getValue();
                    if (qdt.descriptor == null || !qdt.descriptor.contains(this.descriptor)) continue;
                    qdt.useSubtree = true;
                    results.add(qdt.getBoolean(command, mode));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (mode.equals("and")) {
            for (Boolean result : results) {
                if (result.booleanValue()) continue;
                return false;
            }
            return true;
        }
        if (mode.equals("or")) {
            for (Boolean result : results) {
                if (!result.booleanValue()) continue;
                return true;
            }
            return false;
        }
        if (mode.equals("none")) {
            for (Boolean result : results) {
                if (!result.booleanValue()) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public QuantumDataTree getQDT(String s) {
        ArrayList<String> arr;
        if (Functions.isEmpty(s)) {
            ++this.access_count;
            return this;
        }
        if (s.endsWith("//")) {
            s = Functions.substr(s, 0, -2);
        }
        if ((arr = Functions.explode("//", s)) == null) {
            ++this.access_count;
            return null;
        }
        return this.getQDT(arr);
    }

    public QuantumDataTree getQDT(ArrayList<String> pathArray) {
        if (this.tree == null) {
            this.tree = new LinkedHashMap();
        }
        ++this.access_count;
        if (pathArray == null) {
            return null;
        }
        if (pathArray.size() == 0) {
            return this;
        }
        String path = (String)Functions.array_shift(pathArray);
        if (path.contains(":")) {
            ArrayList<String> pathTmp = Functions.explode(":", path);
            path = (String)Functions.array_shift(pathTmp);
            Functions.krSortArr(pathTmp);
            for (String tmp : pathTmp) {
                pathArray.add(0, tmp);
            }
        }
        if (this.tree.containsKey(path)) {
            QuantumDataTree tmpQDT = this.tree.get(path);
            return tmpQDT.getQDT(pathArray);
        }
        return null;
    }

    public boolean applyToEntity(String key, String value) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(key)) {
            return false;
        }
        if (this.entityid == -1L) {
            return false;
        }
        if (this.entity == null && this.entityid > 0L) {
            this.entity = EntityCore.get(this.entityid);
        }
        if (this.entity == null) {
            return false;
        }
        if (this.entity.hasProperty(key)) {
            try {
                Reflection.setValue(this.entity, key, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        if (this.entity.hasMethod(key)) {
            try {
                if (Functions.isEmpty(value)) {
                    Reflection.invokeMethod(this.entity, key);
                } else {
                    Reflection.invokeMethodWithString(this.entity, key, value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return true;
    }

    public boolean applyToObject(String key, String value) {
        if (Functions.isEmpty(key)) {
            return false;
        }
        if (this.object == null) {
            return false;
        }
        if (Reflection.property_exists(this.object, key)) {
            try {
                Reflection.setValue(this.object, key, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        if (Reflection.method_exists(this.object, key)) {
            try {
                if (Functions.isEmpty(value)) {
                    Reflection.invokeMethod(this.object, key);
                } else {
                    Reflection.invokeMethodWithString(this.object, key, value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public QuantumDataTree addNode(String value, String descriptor) throws DetectRightException {
        return this.addNode(value, descriptor, 0, 0, 0);
    }

    public QuantumDataTree addNode(String value, String descriptor, int importance) throws DetectRightException {
        return this.addNode(value, descriptor, importance, 0, 0);
    }

    void addState(int status, int importance, int directHit) {
        if (this.sc == null) {
            this.sc = new StateCollection();
        }
        this.sc.addState(status, importance, directHit);
    }

    public State lastState() {
        if (this.sc == null) {
            this.sc = new StateCollection();
        }
        return this.sc.getLastState();
    }

    public void directHit(int hitStatus) {
        this.sc.directHit(hitStatus);
    }

    public QuantumDataTree addNode(String value, String descriptor, int importance, int initialStatus, int directHit) throws DetectRightException {
        QuantumDataTree newQDT;
        if (this.tree == null) {
            this.tree = new LinkedHashMap();
        }
        if (value == null) {
            value = "";
        }
        if (!this.tree.containsKey(value)) {
            newQDT = new QuantumDataTree(value, this);
            if (Functions.is_null(this.top)) {
                newQDT.top = this;
            }
            newQDT.setDescriptor(descriptor);
            this.tree.put(value, newQDT);
            newQDT.indexMe();
        } else {
            newQDT = this.tree.get(value);
        }
        if (newQDT != null && (initialStatus > 0 || directHit > 0) && importance > 0) {
            newQDT.addState(initialStatus, importance, directHit);
        }
        return newQDT;
    }

    public void indexMe() throws DetectRightException {
    }

    public void refreshDescriptor() {
        this.setDescriptor(this.descriptor, false);
    }

    public void refreshDescriptor(boolean doParents) {
        this.setDescriptor(this.descriptor, doParents);
    }

    public void setDescriptor(String descriptor) {
        this.setDescriptor(descriptor, false);
    }

    public void setDescriptor(String descriptor, boolean doParents) {
        this.descriptor = descriptor;
        ArrayList<String> descriptorParts = Functions.explode(":", descriptor);
        int cnt = descriptorParts.size();
        if (cnt > 0) {
            this.entitytype = DetectRight.unescapeDescriptor(descriptorParts.get(0));
        }
        if (cnt > 1) {
            this.category = DetectRight.unescapeDescriptor(descriptorParts.get(1));
        }
        if (cnt > 2) {
            this.description = DetectRight.unescapeDescriptor(descriptorParts.get(2));
        }
        if (cnt > 3) {
            this.subclass = DetectRight.unescapeDescriptor(descriptorParts.get(3));
        }
        if (cnt > 4) {
            this.majorrevision = DetectRight.unescapeDescriptor(descriptorParts.get(4));
        }
        if (cnt > 5) {
            this.minorrevision = DetectRight.unescapeDescriptor(descriptorParts.get(5));
        }
        if (cnt > 6) {
            this.connection = DetectRight.unescapeDescriptor(descriptorParts.get(6));
        }
        if (cnt > 7) {
            this.build = DetectRight.unescapeDescriptor(descriptorParts.get(7));
        }
        if (cnt == 1) {
            return;
        }
        if (doParents && this.parent != null && !this.parent.descriptor.contains(":")) {
            Functions.array_pop(descriptorParts);
            this.parent.setDescriptor(Functions.implode(":", descriptorParts));
        }
    }

    public static String makePathHash(ArrayList<String> paths) throws DetectRightException {
        if (paths == null) {
            return "";
        }
        return QuantumDataTree.makePathHash(Functions.implode("//", paths));
    }

    public static String makePathHash(String path) throws DetectRightException {
        if (path == null) {
            return "";
        }
        path = Functions.str_replace("://", "{cdbs}", path);
        path = Functions.str_replace(":", "//", path);
        return Functions.md5(path);
    }

    public int getImportance() {
        if (this.sc != null) {
            return this.sc.getImportance();
        }
        return 0;
    }

    public void setImportance(int importance) {
        this.setStatus(1, importance, 1);
    }

    public void addImportance(int importance) {
        if (this.pkg != null) {
            int r = 0;
            while (r < this.pkg.size()) {
                LinkedHashMap<String, Object> thisPkg = this.pkg.get(r);
                int thisOffset = Functions.parseInt(Functions.nn(thisPkg.get("importanceOffset")));
                thisPkg.put("importanceOffset", thisOffset + importance);
                ++r;
            }
        }
        if (importance == 0) {
            return;
        }
        this.sc.addImportance(importance);
        if (this.qdc != null) {
            this.qdc.addImportance(importance);
        }
        ArrayList<String> keys = Functions.array_keys_string(this.tree);
        for (String key : keys) {
            QuantumDataTree qdt = this.tree.get(key);
            if (qdt == null) continue;
            qdt.addImportance(importance);
        }
    }

    void resetCount(int cnt) {
        this.access_count = cnt;
        if (this.qdc != null) {
            this.qdc.resetCount(cnt);
        }
        ArrayList<String> keys = Functions.array_keys_string(this.tree);
        for (String key : keys) {
            QuantumDataTree qdt = this.tree.get(key);
            if (qdt == null) continue;
            qdt.resetCount(cnt);
        }
    }

    void resetCount() {
        this.resetCount(0);
    }

    void close() {
        if (this.locked) {
            return;
        }
        this.index.clear();
        this.entity = null;
        this.object = null;
        if (this.qdc != null && !this.qdc.locked) {
            this.qdc.close();
        }
        this.qdc = null;
        this.isClosed = true;
        if (this.tree == null) {
            return;
        }
        ArrayList<String> keys = Functions.array_keys_string(this.tree);
        for (String key : keys) {
            QuantumDataTree qdt = this.tree.get(key);
            if (qdt != null) {
                qdt.close();
            }
            qdt = null;
        }
        this.tree = null;
    }

    public void deliverQDTMessage(QDTMessage msg) throws DetectRightException, ConnectionLostException {
        ArrayList<String> nodes;
        if (msg == null) {
            return;
        }
        QuantumDataTree destQDT = this.getQDTMessageTarget(msg);
        DetectRight.checkPoint("Got QDT " + msg.path);
        if (destQDT == null) {
            return;
        }
        destQDT.infect(msg, false);
        LinkedHashMap<String, ArrayList<String>> edits = msg.getEdits();
        ArrayList<String> meEdits = edits.get("");
        edits.remove("");
        if (meEdits != null) {
            for (String command : meEdits) {
                if (Functions.isEmpty(command)) continue;
                destQDT.applyCommand(command);
            }
        }
        if ((nodes = Functions.array_keys_string(edits)) == null) {
            return;
        }
        for (String node : nodes) {
            if (node == null || node.equals("")) continue;
            String descriptor = destQDT.descriptor;
            if (Functions.isEmpty(descriptor)) {
                descriptor = this.value;
            }
            destQDT.addNode(node, String.valueOf(descriptor) + ":" + node);
            QuantumDataTree tmpQDT = destQDT.tree.get(node);
            tmpQDT.infect(msg, false);
        }
        for (String node : nodes) {
            if (node == null) continue;
            ArrayList<String> payloadArray = edits.get(node);
            QuantumDataTree target = destQDT.tree.get(node);
            if (target == null) {
                throw new DetectRightException("Horrible QDT fault with node " + node + " at path " + this.getPath(), null);
            }
            Iterator iterator = payloadArray.iterator();
            while (iterator.hasNext()) {
                String command = (String)iterator.next();
                target.applyCommand(command);
            }
        }
        ArrayList<Datapoint> datapoints = msg.getDatapoints();
        for (Datapoint datapoint : datapoints) {
            if (datapoint == null) {
                throw new DetectRightException("Horrible QDT fault with adding " + this.getPath(), null);
            }
            destQDT.qdc.addDatapoint(datapoint);
        }
        ArrayList<QDTMessage> extraMessages = msg.getExtraMessages();
        for (QDTMessage newMSG : extraMessages) {
            if (newMSG == null) continue;
            this.deliverQDTMessage(newMSG);
        }
    }

    public QuantumDataTree getQDTMessageTarget(QDTMessage msg) throws DetectRightException {
        if (msg == null) {
            return null;
        }
        String path = Functions.str_replace("{cdbs}", "://", msg.path);
        ArrayList<String> pathArr = Functions.explode("//", path);
        QuantumDataTree rootQDT = this;
        if (this.index.size() > 0) {
            QuantumDataTree qdt;
            String testHash = QuantumDataTree.makePathHash(path);
            if (this.index.containsKey(testHash) && (qdt = this.index.get(testHash)) != null) {
                return qdt;
            }
            ArrayList notMatched = new ArrayList();
            while (pathArr.size() > 0) {
                Functions.array_unshift(notMatched, Functions.array_pop(pathArr));
                testHash = QuantumDataTree.makePathHash(pathArr);
                if (!this.index.containsKey(testHash)) continue;
                rootQDT = this.index.get(testHash);
                pathArr = notMatched;
                break;
            }
        }
        if (pathArr.size() == 0) {
            pathArr = Functions.explode("//", path);
            rootQDT = this;
        }
        ArrayList nodes = new ArrayList();
        ArrayList<Object> descriptor = new ArrayList();
        ArrayList<String> descCumulative = new ArrayList<String>();
        LinkedHashMap<String, String> tmpHMS = new LinkedHashMap<String, String>();
        block1: for (String pathFragment : pathArr) {
            if (pathFragment.contains(":")) {
                descriptor = Functions.explode(":", pathFragment);
                descCumulative = new ArrayList();
                for (String string : descriptor) {
                    String string2 = Functions.str_replace("{cdbs}", "://", string);
                    if (string2.equals("*")) continue block1;
                    descCumulative.add(string2);
                    tmpHMS = new LinkedHashMap();
                    tmpHMS.put("path", string2);
                    tmpHMS.put("descriptor", Functions.implode(":", descCumulative));
                    nodes.add(tmpHMS);
                }
                continue;
            }
            if ((pathFragment = Functions.str_replace("{cdbs}", "://", pathFragment)) != null && !pathFragment.equals("*")) {
                tmpHMS = new LinkedHashMap();
                tmpHMS.put("path", pathFragment);
                tmpHMS.put("descriptor", pathFragment);
                nodes.add(tmpHMS);
                continue;
            }
            pathFragment.equals("*");
        }
        QuantumDataTree qdt = rootQDT;
        int i = 1;
        int n = nodes.size();
        for (Object e : nodes) {
            LinkedHashMap node = (LinkedHashMap)e;
            String descString = (String)node.get("descriptor");
            String nodePath = (String)node.get("path");
            qdt = qdt.addNode(nodePath, descString);
            if (i < n) {
                qdt.infect(msg, true);
            }
            ++i;
        }
        return qdt;
    }

    public void infect(QDTMessage msg) {
        this.infect(msg, false);
    }

    public void infect(QDTMessage msg, boolean treadLightly) {
        if (msg == null) {
            return;
        }
        if (msg.sc == null) {
            return;
        }
        if (this.sc == null) {
            this.sc = new StateCollection();
        }
        if (!treadLightly) {
            this.sc.addSC(msg.sc);
        } else {
            int status = msg.sc.getStatus();
            if (status == 1) {
                this.sc.addSC(msg.sc, true);
            }
        }
    }

    int treeCount() {
        if (this.tree == null) {
            return 0;
        }
        return this.tree.size();
    }

    int qdcCount() {
        if (this.qdc == null) {
            return 0;
        }
        return this.qdc.propSize();
    }

    void print(String comment) {
        this.print(comment, false);
    }

    void print(String comment, boolean optimize) {
        ArrayList<String> pkg1 = this.packageMe(optimize);
        System.out.println(comment);
        System.out.println(Functions.implode("\n", pkg1));
        System.out.println("\n\n\n");
    }

    void printSC(String path) {
        QuantumDataTree qdt = this.getQDT(path);
        System.out.println(qdt.sc);
    }

    public void applyCommand(String key) throws DetectRightException, ConnectionLostException {
        if (key == null) {
            return;
        }
        boolean array = false;
        String value = "";
        if (key.contains("-->")) {
            ArrayList<String> tmp = Functions.explode("-->", key, 2);
            key = tmp.get(0).trim();
            value = tmp.get(1).trim();
            array = true;
        } else if (key.contains("->")) {
            ArrayList<String> tmp = Functions.explode("->", key, 2);
            key = tmp.get(0).trim();
            value = tmp.get(1).trim();
        } else if (key.contains("=")) {
            ArrayList<String> tmp = Functions.explode("=", key, 2);
            key = tmp.get(0).trim();
            value = tmp.get(1).trim();
        }
        if (array) {
            if (key.equals("metadata")) {
                ArrayList<String> explode = Functions.explode("^", value);
                this.metadata.put(explode.get(0), explode.get(1).trim());
            }
            if (key.equals("brand")) {
                this.brand.add(value);
            }
        }
        if (key.equals("value")) {
            this.value = value;
            return;
        }
        if (key.equals("entitytype")) {
            this.entitytype = value;
            return;
        }
        if (key.equals("category")) {
            this.category = value;
            return;
        }
        if (key.equals("description")) {
            this.description = value;
            return;
        }
        if (key.equals("subclass")) {
            this.subclass = value;
            return;
        }
        if (key.equals("majorrevision")) {
            this.majorrevision = value;
            return;
        }
        if (key.equals("minorrevision")) {
            this.minorrevision = value;
            return;
        }
        if (key.equals("connection")) {
            this.connection = value;
            return;
        }
        if (key.equals("build")) {
            this.build = value;
        }
        if (key.equals("useSubtree")) {
            if (value.equals("1")) {
                this.useSubtree = true;
            } else if (value.equals("0")) {
                this.useSubtree = false;
            }
        }
        if (key.equals("descriptor")) {
            this.setDescriptor(value, true);
            return;
        }
        if (key.equals("entityid")) {
            try {
                this.entityid = Functions.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                this.entityid = 0L;
            }
            return;
        }
        if (!this.applyToEntity(key, value)) {
            this.applyToObject(key, value);
        }
    }

    public void applyCommandWithReflection(String key) throws DetectRightException, ConnectionLostException {
        ArrayList<String> tmp;
        boolean array = false;
        String value = "";
        if (key.contains("-->")) {
            tmp = Functions.explode("-->", key, 2);
            key = tmp.get(0).trim();
            value = tmp.get(1).trim();
            array = true;
        } else if (key.contains("->")) {
            tmp = Functions.explode("->", key, 2);
            key = tmp.get(0).trim();
            value = tmp.get(1).trim();
        } else if (key.contains("=")) {
            tmp = Functions.explode("=", key, 2);
            key = tmp.get(0).trim();
            value = tmp.get(1).trim();
        }
        if (Reflection.property_exists(this, key)) {
            if (array) {
                Cloneable tmpValue;
                try {
                    tmpValue = Reflection.getProperty(this, key);
                }
                catch (Throwable e) {
                    return;
                }
                if (value.contains("^")) {
                    if (!(tmpValue instanceof LinkedHashMap)) {
                        try {
                            tmpValue = new LinkedHashMap();
                            Reflection.setValue(this, key, tmpValue);
                        }
                        catch (Throwable e) {
                            return;
                        }
                    }
                    LinkedHashMap tmpHM = tmpValue;
                    tmp = Functions.explode("^", value);
                    tmpHM.put(tmp.get(0).trim(), tmp.get(1).trim());
                } else {
                    ArrayList tmpArr;
                    if (!(tmpValue instanceof ArrayList)) {
                        try {
                            tmpValue = new ArrayList();
                            Reflection.setValue(this, key, tmpValue);
                        }
                        catch (Throwable e) {
                            return;
                        }
                    }
                    if (!(tmpArr = (ArrayList)tmpValue).contains(value)) {
                        tmpArr.add(value);
                    }
                }
            } else if (!Functions.isEmpty(value)) {
                Reflection.setValue(this, key, value);
            }
        } else if (!this.applyToEntity(key, value)) {
            this.applyToObject(key, value);
        }
    }

    void addMetadata(String key, Object value) {
        this.addMetadata(key, value, false);
    }

    void addMetadata(String key, Object value, boolean filterByParent) {
        if (!filterByParent) {
            this.metadata.put(key, value);
        } else if (this.parent != null && !this.parent.hasMetadata(key, value)) {
            this.metadata.put(key, value);
        }
    }

    boolean hasMetadata(String key, Object value) {
        if (this.metadata.containsKey(key)) {
            return this.metadata.get(key).equals(value);
        }
        if (this.parent != null) {
            return this.parent.hasMetadata(key, value);
        }
        return false;
    }

    void setObject(Object object) {
        this.object = object;
    }

    Object getObject() {
        return this.object;
    }
}

