/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.ConnectionLostException;
import com.detectright.core.DBLink;
import com.detectright.core.DetectRightException;
import com.detectright.core.Functions;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecordSet {
    public static LinkedHashMap<String, Object> emptyHash = new LinkedHashMap();
    public boolean IDadded = false;
    public String lastID;
    public LinkedHashMap<String, Object> data;
    public String table;
    public LinkedHashMap<String, Object> fieldList;
    public LinkedHashMap<String, Object> whereClause;
    public LinkedHashMap<String, Object> orderBy;
    public LinkedHashMap<String, Object> limitClause;
    public String keyField;
    public String idField;
    public String sqlOp;
    public boolean eor = false;
    public DBLink db;
    public int buffersize = 50;

    public static void main(String[] args) {
    }

    public RecordSet(DBLink dbLink, String table, LinkedHashMap<String, Object> fieldList, LinkedHashMap<String, Object> where, LinkedHashMap<String, Object> orderBy, LinkedHashMap<String, Object> limitClause, String keyField, String sqlOp) throws DetectRightException, ConnectionLostException {
        this(dbLink, table, fieldList, where, orderBy, limitClause, keyField, sqlOp, "ID");
    }

    public RecordSet(DBLink dbLink, String table, LinkedHashMap<String, Object> fieldList, LinkedHashMap<String, Object> where, LinkedHashMap<String, Object> orderBy, LinkedHashMap<String, Object> limitClause, String keyField) throws DetectRightException, ConnectionLostException {
        this(dbLink, table, fieldList, where, orderBy, limitClause, keyField, "select", "ID");
    }

    public RecordSet(DBLink dbLink, String table, LinkedHashMap<String, Object> fieldList, LinkedHashMap<String, Object> where, LinkedHashMap<String, Object> orderBy, LinkedHashMap<String, Object> limitClause) throws DetectRightException, ConnectionLostException {
        this(dbLink, table, fieldList, where, orderBy, limitClause, "", "select", "ID");
    }

    public RecordSet(DBLink dbLink, String table, LinkedHashMap<String, Object> fieldList, LinkedHashMap<String, Object> where, LinkedHashMap<String, Object> orderBy) throws DetectRightException, ConnectionLostException {
        this(dbLink, table, fieldList, where, orderBy, emptyHash, "", "select", "ID");
    }

    public RecordSet(DBLink dbLink, String table, LinkedHashMap<String, Object> fieldList, LinkedHashMap<String, Object> where) throws DetectRightException, ConnectionLostException {
        this(dbLink, table, fieldList, where, emptyHash, emptyHash, "", "select", "ID");
    }

    public RecordSet(DBLink dbLink, String table, LinkedHashMap<String, Object> fieldList) throws DetectRightException, ConnectionLostException {
        this(dbLink, table, fieldList, emptyHash, emptyHash, emptyHash, "", "select", "ID");
    }

    public RecordSet(DBLink dbLink, String table, LinkedHashMap<String, Object> fieldList, LinkedHashMap<String, Object> where, LinkedHashMap<String, Object> orderBy, LinkedHashMap<String, Object> limitClause, String keyField, String sqlOp, String idField) throws DetectRightException, ConnectionLostException {
        this.db = dbLink;
        this.table = table;
        this.fieldList = fieldList;
        this.whereClause = where;
        this.orderBy = orderBy;
        this.limitClause = limitClause;
        this.keyField = keyField;
        this.sqlOp = sqlOp;
        this.idField = idField;
        if (!Functions.in_array((Object)idField, fieldList) && !Functions.in_array((Object)"*", fieldList)) {
            this.IDadded = true;
            this.fieldList.put(String.valueOf(this.fieldList.size()), idField);
        }
        this.buffer();
    }

    public LinkedHashMap<String, Object> fetch() throws DetectRightException, ConnectionLostException {
        if (this.data == null) {
            return null;
        }
        if (this.data.size() == 0 && this.eor) {
            return null;
        }
        if (this.data.size() == 0) {
            this.buffer();
        }
        if (this.data.size() == 0) {
            return null;
        }
        LinkedHashMap row = (LinkedHashMap)Functions.array_shift(this.data);
        return row;
    }

    public void buffer() throws DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Object> data;
        if (this.db == null) {
            throw new ConnectionLostException("DB is null for recordset");
        }
        if (this.limitClause == null) {
            this.limitClause = new LinkedHashMap();
        }
        LinkedHashMap limitClause = new LinkedHashMap();
        if (this.limitClause.size() == 0) {
            limitClause.put("limit", this.buffersize);
        } else if (this.limitClause.containsKey("limit")) {
            Object bufferSizeObj = this.limitClause.get("limit");
            long bufferSize = 0L;
            if (!Functions.isEmpty(bufferSizeObj)) {
                try {
                    bufferSize = Long.parseLong(bufferSizeObj.toString(), 10);
                    if (bufferSize >= (long)this.buffersize) {
                        limitClause.put("limit", this.buffersize);
                        this.limitClause.put("limit", String.valueOf(bufferSize - (long)this.buffersize));
                    }
                    limitClause = (LinkedHashMap)this.limitClause.clone();
                }
                catch (Exception e) {
                    throw new DetectRightException("Limit without Limit in Recordset LimitClause", null);
                }
            }
        } else {
            limitClause.put("limit", this.buffersize);
        }
        if (this.whereClause == null) {
            return;
        }
        LinkedHashMap<String, Object> rsWhere = Functions.lhmCopy(this.whereClause);
        if (this.lastID != null) {
            LinkedHashMap<String, Object> firstWhere = new LinkedHashMap<String, Object>();
            firstWhere.putAll(rsWhere);
            LinkedHashMap secondWhere = new LinkedHashMap();
            LinkedHashMap<String, String> secondWhereTmp = new LinkedHashMap<String, String>();
            secondWhereTmp.put("op", ">");
            secondWhereTmp.put("value", this.lastID);
            secondWhere.put(this.idField, secondWhereTmp);
            rsWhere.clear();
            rsWhere.put("op", "and");
            if (firstWhere.size() > 0) {
                LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>();
                tmp.put("op", "where");
                tmp.put("value", firstWhere);
                Functions.array_push(rsWhere, tmp);
            }
            LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>();
            tmp.put("op", "where");
            tmp.put("value", secondWhere);
            Functions.array_push(rsWhere, tmp);
        }
        LinkedHashMap orderBy = (LinkedHashMap)this.orderBy.clone();
        if (this.orderBy.size() == 0) {
            orderBy.put(this.idField, "ASC");
        }
        if ((data = this.db.simpleFetch(this.table, this.fieldList, rsWhere, orderBy, limitClause, this.keyField, this.sqlOp)) == null) {
            this.data = null;
            return;
        }
        if (data.size() < this.buffersize) {
            this.eor = true;
        } else {
            LinkedHashMap lastRow = (LinkedHashMap)data.get(String.valueOf(data.size() - 1));
            this.lastID = lastRow.get(this.idField).toString();
        }
        if (this.IDadded) {
            LinkedHashMap<String, Object> tmpMap = data;
            for (Map.Entry entry : tmpMap.entrySet()) {
                String key = (String)entry.getKey();
                LinkedHashMap row = (LinkedHashMap)data.get(key);
                row.remove(this.idField);
            }
        }
        this.data = data;
    }

    static boolean syncRS(RecordSet srcEA, RecordSet destEA) throws DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Object> row;
        if (srcEA == null) {
            return false;
        }
        if (destEA == null) {
            return false;
        }
        if (srcEA.data == null) {
            return false;
        }
        if (destEA.data == null) {
            return false;
        }
        if (srcEA.data.size() == 0) {
            return true;
        }
        boolean success = true;
        while ((row = srcEA.fetch()) != null) {
            String id = Functions.gvString(row, srcEA.idField);
            if (Functions.isEmpty(id)) continue;
            destEA.processRow(row);
        }
        return success;
    }

    boolean processRow(LinkedHashMap<String, Object> row) throws DetectRightException, ConnectionLostException {
        if (this.db == null) {
            throw new ConnectionLostException("DB is null for recordset");
        }
        if (row == null) {
            return false;
        }
        boolean success = true;
        String id = Functions.gvString(row, this.idField);
        success = this.IDExists(id) ? (success &= this.db.updateData(this.table, row, DBLink.whereClause(this.idField, id))) : (success &= this.db.insertData(this.table, row, Long.parseLong(id)) > 0L);
        return success;
    }

    boolean IDExists(String ID) throws DetectRightException, ConnectionLostException {
        if (this.db == null) {
            throw new ConnectionLostException("DB is null for recordset");
        }
        ArrayList<String> ids = this.db.getIDs(this.table, this.idField, DBLink.whereClause(this.idField, ID));
        return ids.size() != 0;
    }

    boolean delete() throws DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Object> row;
        boolean success = true;
        while ((row = this.fetch()) != null) {
            String id = Functions.gvString(row, this.idField);
            if (Functions.isEmpty(id)) continue;
            success &= this.db.deleteData(this.table, DBLink.whereClause(this.idField, id));
        }
        return success;
    }
}

