/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.ConnectionLostException;
import com.detectright.core.DBLink;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.Functions;
import com.detectright.core.Reflection;
import java.io.File;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SQLite
extends DBLink {
    private int affectedRows = 0;
    private long lastInsertID = 0L;
    private static ReentrantLock qLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        LinkedHashMap linkedHashMap = typeMap;
        synchronized (linkedHashMap) {
            typeMap.put("BIGINT", "INTEGER");
            typeMap.put("BIT", "NUMERIC");
            typeMap.put("BIT1", "NUMERIC");
            typeMap.put("BLOB", "NONE");
            typeMap.put("CHAR", "TEXT");
            typeMap.put("CLOB", "TEXT");
            typeMap.put("DATE", "NUMERIC");
            typeMap.put("DECIMAL", "NUMERIC");
            typeMap.put("DOUBLE", "REAL");
            typeMap.put("FLOAT", "REAL");
            typeMap.put("INTEGER", "INTEGER");
            typeMap.put("LONGVARBINARY", "NONE");
            typeMap.put("LONGVARCHAR", "TEXT");
            typeMap.put("NUMERIC", "NUMERIC");
            typeMap.put("REAL", "REAL");
            typeMap.put("SMALLINT", "INTEGER");
            typeMap.put("SQLXML3", "TEXT");
            typeMap.put("TIME", "NUMERIC");
            typeMap.put("TIMESTAMP", "STRING");
            typeMap.put("VARBINARY", "NONE");
            typeMap.put("VARCHAR", "TEXT");
        }
    }

    public static void main(String[] args) {
    }

    public SQLite(String hash) throws DetectRightException {
        super(hash);
        this.engine = "SQLite";
    }

    @Override
    public boolean _ping() {
        return true;
    }

    @Override
    public String _multichar_wildcard() {
        return "%";
    }

    @Override
    public String _singlechar_wildcard() {
        return "_";
    }

    @Override
    public String _identifier_delimiter() {
        return "\"";
    }

    @Override
    public String _quoted_delimiter() {
        return "'";
    }

    @Override
    public boolean connect() throws DetectRightException, ConnectionLostException {
        return this.connect(this.params);
    }

    @Override
    ArrayList<String> getTables() throws DetectRightException, ConnectionLostException {
        ArrayList<String> tables = new ArrayList<String>();
        try {
            LinkedHashMap<String, Object> res = this._query("SELECT name FROM sqlite_master WHERE type='table' ORDER BY name");
            ArrayList<String> rowKeys = Functions.array_keys_string(res);
            for (String rowKey : rowKeys) {
                LinkedHashMap row = (LinkedHashMap)res.get(rowKey);
                String name = Functions.gvString(row, "name");
                tables.add(name);
            }
        }
        catch (Throwable e) {
            return new ArrayList<String>();
        }
        return tables;
    }

    public synchronized boolean connect(LinkedHashMap<String, String> params) throws DetectRightException, ConnectionLostException {
        String host = Functions.gv(params, "address").toString();
        if (this.db != null && this.dbOK) {
            return true;
        }
        DetectRight.checkPoint("SQLite connect..." + Thread.currentThread().getName());
        try {
            String driver = "org.sqlite.JDBC";
            Class.forName(driver);
            if (!host.equals(":memory:")) {
                File f = new File(host);
                if (!f.exists()) {
                    throw new ConnectionLostException("Database file does not exist");
                }
                if (f.length() < 1024L) {
                    throw new ConnectionLostException("Database File is less than 1k long!");
                }
                f = null;
            }
            String connectionURL = "jdbc:sqlite:" + host;
            Connection retval = DriverManager.getConnection(connectionURL);
            PreparedStatement stmt = retval.prepareStatement("select count(*) from sqlite_master where type='table'");
            stmt.close();
            this.db = retval;
        }
        catch (ConnectionLostException ce) {
            throw ce;
        }
        catch (Exception x) {
            throw new DetectRightException(x.getMessage(), x);
        }
        DetectRight.checkPoint("SQLite connecting leave..." + Thread.currentThread().getName());
        this.dbOK = true;
        return true;
    }

    public static boolean testConnection(DBLink dbl) throws DetectRightException, ConnectionLostException {
        if (dbl == null) {
            return false;
        }
        Connection conn = dbl.getConnectionObject();
        if (conn == null) {
            throw new ConnectionLostException("Connection is null");
        }
        try {
            if (conn.isClosed()) {
                throw new ConnectionLostException("SQLite connection " + dbl.getConnectionInfo() + "is closed");
            }
        }
        catch (Exception e) {
            throw new DetectRightException("DB Error checking close status connection", e);
        }
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
        }
        catch (Exception e) {
            throw new DetectRightException("DB Error creating statement", e);
        }
        ResultSet rs = null;
        String countResult = "";
        String cnt = "select count(*) from sqlite_master where type='table'";
        try {
            rs = stmt.executeQuery(cnt);
            while (rs.next()) {
                countResult = rs.getString(1);
            }
        }
        catch (Exception e) {
            throw new DetectRightException("DB Error checking master tables", e);
        }
        try {
            rs.close();
            stmt.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return !Functions.isEmpty(countResult) && !countResult.equals("0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyToGlobal(DBLink source) throws DetectRightException, ConnectionLostException {
        SQLite mem = new SQLite(Functions.md5("SQLite//:memory:"));
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("engine", "SQLite");
        params.put("address", ":memory:");
        params.put("timestamp", String.valueOf(Functions.time()));
        mem.params = params;
        mem.connect();
        if (!mem.dbOK) {
            return false;
        }
        Connection globalTmp = mem.getConnectionObject();
        String engine = Functions.gvString(source.params, "engine");
        String host = Functions.gv(source.params, "address").toString();
        if (engine.equals("SQLite")) {
            try {
                LinkedHashMap<String, DBLink> linkedHashMap;
                source._close();
                Statement stmt = globalTmp.createStatement();
                ResultSet rs = null;
                String attachStmt = "ATTACH '" + host + "' AS src";
                stmt.execute(attachStmt);
                String countResult = "";
                String cnt = "select count(*) from src.sqlite_master where type='table'";
                rs = stmt.executeQuery(cnt);
                while (rs.next()) {
                    countResult = rs.getString(1);
                }
                ArrayList<String> sql = new ArrayList<String>();
                String tableQuery = "SELECT sql FROM src.sqlite_master WHERE type='table'";
                rs = stmt.executeQuery(tableQuery);
                while (rs.next()) {
                    sql.add(rs.getString(1));
                }
                for (String sqlStr : sql) {
                    stmt.execute(sqlStr);
                }
                sql.clear();
                String tableNameQuery = "SELECT name FROM sqlite_master WHERE type='table'";
                rs = stmt.executeQuery(tableNameQuery);
                while (rs.next()) {
                    String copyDataQuery = "INSERT INTO " + rs.getString(1) + " SELECT * FROM src." + rs.getString(1);
                    sql.add(copyDataQuery);
                }
                for (String sqlStr : sql) {
                    stmt.execute(sqlStr);
                    Thread.yield();
                }
                sql.clear();
                String nonTableQuery = "SELECT sql FROM src.sqlite_master WHERE type!='table'";
                rs = stmt.executeQuery(nonTableQuery);
                while (rs.next()) {
                    sql.add(rs.getString(1));
                }
                for (String sqlStr : sql) {
                    stmt.execute(sqlStr);
                }
                sql.clear();
                String detachStmt = "DETACH src";
                stmt.execute(detachStmt);
                if (global == null) {
                    global = mem;
                } else {
                    linkedHashMap = global;
                    synchronized (linkedHashMap) {
                        global = mem;
                    }
                }
                linkedHashMap = DBLink.dbs;
                synchronized (linkedHashMap) {
                    DBLink.dbs.put(mem.hash, mem);
                }
                DBLink.useGlobalLink = true;
                return true;
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public void _close() throws DetectRightException, ConnectionLostException {
        try {
            if (this.db != null && !this.db.isClosed()) {
                this.db.close();
                this.db = null;
            }
        }
        catch (Exception x) {
            Functions.trigger_error("Error closing connection", x, false);
        }
    }

    @Override
    public boolean _selectDatabase(String database) throws DetectRightException, ConnectionLostException {
        return true;
    }

    @Override
    public boolean _free_result(ResultSet result) throws DetectRightException, ConnectionLostException {
        try {
            if (result != null) {
                result.close();
            }
        }
        catch (Exception e) {
            result = null;
            return true;
        }
        result = null;
        return true;
    }

    @Override
    public String _escape_string(String string) {
        string = string.replaceAll("'", "''");
        return string;
    }

    @Override
    public int _num_rows(ResultSet rs) throws DetectRightException, ConnectionLostException {
        if (rs == null) {
            return 0;
        }
        int count = 0;
        try {
            int current = rs.getRow();
            rs.last();
            count = rs.getRow();
            if (count == -1) {
                count = 0;
            }
            if (current == 0) {
                rs.beforeFirst();
            } else {
                rs.absolute(current);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return count;
    }

    @Override
    public long _insert_id() throws DetectRightException, ConnectionLostException {
        return this.lastInsertID;
    }

    @Override
    public int _affected_rows() {
        return this.affectedRows;
    }

    @Override
    public String _sql_error() {
        return this.error;
    }

    @Override
    public LinkedHashMap<String, Object> _query(String sql) throws DetectRightException, ConnectionLostException {
        return this._query(sql, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized LinkedHashMap<String, Object> _query(String sql, String keyField) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(sql)) {
            return new LinkedHashMap<String, Object>();
        }
        ResultSet rs = null;
        Statement stmt = null;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (this.db == null) {
            throw new ConnectionLostException();
        }
        ReentrantLock reentrantLock = qLock;
        synchronized (reentrantLock) {
            block15: {
                try {
                    try {
                        Connection conn = this.getConnectionObject();
                        if (conn == null) {
                            try {
                                qLock.unlock();
                            }
                            catch (IllegalMonitorStateException illegalMonitorStateException) {
                                // empty catch block
                            }
                            throw new ConnectionLostException();
                        }
                        if (conn.isClosed()) {
                            qLock.unlock();
                            throw new ConnectionLostException();
                        }
                        stmt = conn.createStatement();
                        rs = stmt.executeQuery(sql);
                        result = keyField.equals("") ? this._fetch_all(rs) : this._fetch_all(rs, keyField);
                        rs.close();
                        stmt.close();
                    }
                    catch (SQLException ex) {
                        throw new DetectRightException("SQL Problem in SQLite connection" + this.getConnectionInfo(), ex);
                    }
                    catch (Exception exception) {
                        rs = null;
                        stmt = null;
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    rs = null;
                    stmt = null;
                    throw throwable;
                }
                rs = null;
                stmt = null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean _queryBool(String sql) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(sql)) {
            return false;
        }
        if (this.db == null) {
            throw new ConnectionLostException("Connection to database lost");
        }
        boolean success = false;
        Statement stmt = null;
        ReentrantLock reentrantLock = qLock;
        synchronized (reentrantLock) {
            block23: {
                try {
                    int rows;
                    Connection conn = this.getConnectionObject();
                    if (conn.isClosed()) {
                        qLock.unlock();
                        throw new ConnectionLostException();
                    }
                    stmt = this.db.createStatement();
                    this.affectedRows = rows = stmt.executeUpdate(sql);
                    if (sql.startsWith("insert") || sql.startsWith("INSERT")) {
                        ResultSet rs = stmt.executeQuery("SELECT last_insert_rowid()");
                        this.lastInsertID = rs.next() ? (long)rs.getInt(1) : 0L;
                        rs.close();
                    }
                    stmt.close();
                    stmt = null;
                    success = true;
                }
                catch (SQLException ex) {
                    this.error = ex.getMessage();
                    if (stmt == null) break block23;
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    stmt = null;
                    break block23;
                }
                catch (Exception e) {
                    try {
                        this.error = e.getMessage();
                        break block23;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (SQLException sQLException) {}
                            stmt = null;
                        }
                    }
                }
                if (stmt == null) break block23;
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                stmt = null;
            }
        }
        return success;
    }

    @Override
    public LinkedHashMap<String, Object> _fetch_assoc(ResultSet result) throws DetectRightException, ConnectionLostException {
        if (result == null) {
            return null;
        }
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        try {
            boolean success = result.next();
            if (!success) {
            }
            ResultSetMetaData metadata = result.getMetaData();
            int columns = metadata.getColumnCount();
            int i = 1;
            while (i < columns + 1) {
                String key = metadata.getColumnName(i);
                String value = result.getString(i);
                output.put(key, value);
                ++i;
            }
        }
        finally {
            return null;
        }
        return output;
    }

    @Override
    public String _ts2Date(long ts) {
        Date x = new Date(ts);
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df1.format(x);
    }

    @Override
    public LinkedHashMap<String, Object> _fetch_all(ResultSet result) throws DetectRightException, ConnectionLostException {
        return this._fetch_all(result, "");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public LinkedHashMap<String, Object> _fetch_all(ResultSet result, String keyField) throws DetectRightException, ConnectionLostException {
        retArray = new LinkedHashMap<String, Object>();
        if (result != null) ** GOTO lbl11
        return null;
lbl-1000:
        // 1 sources

        {
            if (!Functions.isEmpty(keyField) && row.containsKey(keyField)) {
                keyFieldValue = (String)row.get(keyField);
                retArray.put(keyFieldValue, row);
                continue;
            }
            retArray.put(String.valueOf(retArray.size()), row);
lbl11:
            // 3 sources

            ** while ((row = this._fetch_assoc((ResultSet)result)) != null)
        }
lbl12:
        // 1 sources

        return retArray;
    }

    @Override
    public String _limit_string(LinkedHashMap<String, Object> array) {
        if (array == null) {
            return "";
        }
        String limit = Functions.gvString(array, "limit");
        String offset = Functions.gvString(array, "offset", "");
        if (!Functions.is_numeric(limit)) {
            this.error = "Non-numeric Limit";
            return "";
        }
        if (!Functions.isEmpty(offset) && !Functions.is_numeric(offset)) {
            this.error = "Non-numeric offset";
            return "";
        }
        String retStr = "limit " + limit;
        if (!Functions.isEmpty(offset)) {
            retStr.concat(" OFFSET " + offset);
        }
        return retStr;
    }

    @Override
    public String _now() {
        return "DATETIME('NOW')";
    }

    @Override
    public String _delayed_string() {
        return "";
    }

    @Override
    public ArrayList<String> _getTableList() throws DetectRightException, ConnectionLostException {
        ArrayList<String> tables = new ArrayList<String>();
        try {
            LinkedHashMap<String, Object> res = this._query("SELECT name FROM sqlite_master WHERE type='table' ORDER BY name");
            ArrayList<String> rowKeys = Functions.array_keys_string(res);
            for (String rowKey : rowKeys) {
                LinkedHashMap row = (LinkedHashMap)res.get(rowKey);
                String name = Functions.gvString(row, "name");
                tables.add(name);
            }
        }
        catch (Throwable e) {
            return new ArrayList<String>();
        }
        return tables;
    }

    @Override
    public boolean _bulk_insert(String table, String fields, ArrayList<String> values) throws DetectRightException, ConnectionLostException {
        int page = 10000;
        boolean success = true;
        if (Functions.isEmpty(table) || Functions.isEmpty(fields)) {
            return false;
        }
        ArrayList chunks = (ArrayList)Functions.array_chunk(values, page);
        for (Object valueObj : chunks) {
            if (!(valueObj instanceof ArrayList)) {
                return false;
            }
            ArrayList valueArray = (ArrayList)valueObj;
            String valueStrings = Functions.implode(",", valueArray);
            String sql = "insert ignore into " + table + "(" + fields + ") VALUES " + valueStrings;
            boolean bl = success = this._queryBool(sql) && success;
        }
        return success;
    }

    @Override
    public String _null() {
        return "null";
    }

    @Override
    public ArrayList<String> getDDL(String tablename, LinkedHashMap<?, ?> pk, LinkedHashMap<?, ?> index, LinkedHashMap<?, ?> fields) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(tablename)) {
            return null;
        }
        if (pk == null) {
            return null;
        }
        if (index == null) {
            return null;
        }
        if (fields == null) {
            return null;
        }
        ArrayList<String> output = new ArrayList<String>();
        ArrayList<String> keys = Functions.array_keys_string(fields);
        for (String key : keys) {
            String dataName;
            int dataType;
            LinkedHashMap lhm = (LinkedHashMap)fields.get(key);
            if (lhm == null) continue;
            String colName = (String)lhm.get("colName");
            Object dataTypeObj = lhm.get("dataType");
            if (dataTypeObj == null || !jdbcTypeMap.containsKey(dataType = Functions.parseInt(dataTypeObj.toString())) || !typeMap.containsKey(dataName = (String)jdbcTypeMap.get(dataType))) continue;
            if ((dataName = (String)typeMap.get(dataName)).contains("TEXT")) {
                dataName = dataName.concat(" COLLATE NOCASE");
            }
            Object colSizeObject = lhm.get("colSize");
            int colSize = 0;
            if (colSizeObject != null) {
                colSize = Functions.parseInt(colSizeObject.toString());
            }
            if (colSize > 0 && dataName.contains("(M)")) {
                dataName = dataName.replace("(M)", "(" + String.valueOf(colSize) + ")");
            } else if (colSize < 1 && dataName.contains("(M)")) {
                dataName = Functions.substr(dataName, 0, Functions.strpos(dataName, "(M)"));
            }
            Object takesNullObjects = lhm.get("takesNulls");
            boolean takesNulls = true;
            if (takesNullObjects != null) {
                takesNulls = Functions.to_boolean(takesNullObjects.toString());
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add("{IDD}" + colName + "{IDD}");
            command.add(dataName);
            if (takesNulls) {
                command.add("NULL");
            } else {
                command.add("NOT NULL");
            }
            output.add(Functions.implode(" ", command));
        }
        Functions.ksort(pk);
        String pkString = "";
        String pkName = "";
        if (pk.size() > 0) {
            pkString = "PRIMARY KEY (";
            LinkedHashMap<?, ?> tmpMap = pk;
            ArrayList<String> keyList = new ArrayList<String>();
            for (Map.Entry entry : tmpMap.entrySet()) {
                Object lhmObj = entry.getValue();
                if (!(lhmObj instanceof LinkedHashMap)) continue;
                LinkedHashMap lhm = (LinkedHashMap)lhmObj;
                String colName = (String)lhm.get("colName");
                if (Functions.isEmpty(pkName)) {
                    pkName = (String)lhm.get("pkName");
                }
                if (!pkName.contains(tablename)) {
                    pkName = pkName.concat(tablename);
                }
                keyList.add("{IDD}" + colName + "{IDD}");
            }
            output.add(String.valueOf(pkString) + Functions.implode(",", keyList) + ")");
        }
        ArrayList<String> indexStrings = new ArrayList<String>();
        if (index.size() > 0) {
            ArrayList<String> indexNames = Functions.array_keys_string(index);
            Iterator<String> dataType = indexNames.iterator();
            while (dataType.hasNext()) {
                LinkedHashMap lhm;
                String indexName;
                String iName = indexName = dataType.next();
                if (!indexName.contains(tablename)) {
                    iName = indexName.concat(tablename);
                }
                boolean establishedUniqueness = false;
                if (iName.equals(pkName)) continue;
                ArrayList<String> indexBits = new ArrayList<String>();
                Object lhmObj = index.get(indexName);
                if (!(lhmObj instanceof LinkedHashMap) || (lhm = (LinkedHashMap)lhmObj).size() == 0) continue;
                Functions.ksort(lhm);
                LinkedHashMap tmpMap = lhm;
                for (Map.Entry entry : tmpMap.entrySet()) {
                    boolean nonUnique;
                    LinkedHashMap ihm;
                    String colName;
                    Object ihmObj = entry.getValue();
                    if (!(ihmObj instanceof LinkedHashMap) || Functions.isEmpty(colName = Functions.gvString(ihm = (LinkedHashMap)ihmObj, "colName", ""))) continue;
                    if (!establishedUniqueness && !(nonUnique = Functions.to_boolean(Functions.gvString(ihm, "nonUnique", "0")))) {
                        establishedUniqueness = true;
                    }
                    indexBits.add("{IDD}" + colName + "{IDD}");
                }
                if (!establishedUniqueness) {
                    indexStrings.add("CREATE INDEX {IDD}" + iName + "{IDD} ON {IDD}" + tablename + "{IDD} (" + Functions.implode(",", indexBits) + ")");
                    continue;
                }
                indexStrings.add("CREATE UNIQUE INDEX {IDD}" + iName + "{IDD} ON {IDD}" + tablename + "{IDD} (" + Functions.implode(",", indexBits) + ")");
            }
        }
        String innerBrackets = Functions.implode(", ", output);
        String returnStr = "CREATE TABLE {IDD}" + tablename + "{IDD} (" + innerBrackets + ")";
        ArrayList<String> resultArr = new ArrayList<String>();
        resultArr.add(returnStr);
        if (indexStrings.size() > 0) {
            resultArr.addAll(indexStrings);
        }
        return resultArr;
    }

    @Override
    public Connection getConnectionObject() throws ConnectionLostException {
        if (this.db == null) {
            throw new ConnectionLostException("Connection Lost");
        }
        return this.db;
    }

    @Override
    public String getConnectionInfo() throws ConnectionLostException {
        return Reflection.get_object_vars(this.getConnectionObject()).toString();
    }

    @Override
    ArrayList<String> _getFields(String table) throws DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(table)) {
            return null;
        }
        table = this.idd(table);
        String query = "pragma table_info(" + table + ")";
        LinkedHashMap<String, Object> result = this.fillArrayFromSQL(query);
        ArrayList<String> fields = Functions.array_keys_string(result);
        return fields;
    }
}

