/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Cache;
import com.detectright.core.ConnectionLostException;
import com.detectright.core.DBLink;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.EntitySig;
import com.detectright.core.EntitySigCollection;
import com.detectright.core.Functions;
import com.detectright.core.PhpObject;
import com.detectright.core.Reflection;
import com.detectright.core.SigPart;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Sig {
    static boolean load_all = true;
    static ThreadLocal<DBLink> dbLink = new ThreadLocal();
    static ThreadLocal<Cache> cacheLink = new ThreadLocal();
    static volatile LinkedHashMap<String, Sig> sigs = new LinkedHashMap();
    static volatile LinkedHashMap<String, LinkedHashMap<String, Sig>> sigsByPath = new LinkedHashMap();
    static volatile LinkedHashMap<String, LinkedHashMap<String, Sig>> sigsByHeader = new LinkedHashMap();
    public static boolean flushed = false;
    private String sigString = "";
    private String path = "";
    private ArrayList<Object> sigArray = new ArrayList();
    private String propertySig = "";
    private ArrayList<String> properties = new ArrayList();
    private int importance = 0;

    static {
        DetectRight.registerClass("Sig");
        try {
            if (Functions.is_null(cacheLink.get())) {
                cacheLink.set(DetectRight.getCacheLink());
            }
            if (Functions.is_null(dbLink.get())) {
                dbLink.set(DetectRight.getDBLink());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void main(String[] args) {
    }

    Sig() throws ConnectionLostException, DetectRightException {
        this("");
    }

    Sig(String string) throws ConnectionLostException, DetectRightException {
        Sig.cacheDB();
        this.sigString = string;
        this.parse();
    }

    static void cacheDB() throws ConnectionLostException, DetectRightException {
        if (Functions.is_null(cacheLink.get())) {
            cacheLink.set(DetectRight.getCacheLink());
        }
        if (Functions.is_null(dbLink.get())) {
            dbLink.set(DetectRight.getDBLink());
        }
        if (dbLink.get() == null) {
            throw new ConnectionLostException("Lost connection to database");
        }
    }

    void __wakeup() throws ConnectionLostException, DetectRightException {
        Sig.cacheDB();
    }

    ArrayList<String> __sleep() {
        LinkedHashMap<String, Object> ov = Reflection.get_object_vars(this);
        return Functions.array_keys_string(ov);
    }

    void parse() throws ConnectionLostException, DetectRightException {
        if (Functions.isEmpty(this.sigString)) {
            return;
        }
        ArrayList<String> tmp = Functions.explode("//", this.sigString);
        if (tmp.size() > 1) {
            this.propertySig = tmp.get(1);
        }
        ArrayList<String> array = Functions.explode(":", tmp.get(0));
        for (String string : array) {
            string = DetectRight.unescapeDescriptor(string);
            SigPart sig = new SigPart(string);
            this.sigArray.add(sig);
        }
    }

    EntitySig getES(String string) throws DetectRightException, ConnectionLostException {
        SigPart sig;
        if (Functions.isEmpty(string)) {
            return null;
        }
        ArrayList<String> output = new ArrayList<String>();
        if (this.sigArray == null) {
            return null;
        }
        for (Object sigObj : this.sigArray) {
            sig = (SigPart)sigObj;
            String result = sig.process(string);
            if (result == null) {
                return null;
            }
            if (!sig.found) {
                return null;
            }
            output.add(result);
            this.properties.addAll(sig.properties);
        }
        if (!Functions.isEmpty(this.propertySig)) {
            ArrayList<Object> propSigArray = null;
            if (Functions.strpos("^", this.propertySig) > -1) {
                propSigArray = Functions.explode("^", this.propertySig);
            } else {
                propSigArray = new ArrayList();
                propSigArray.add(this.propertySig);
            }
            for (String string2 : propSigArray) {
                sig = new SigPart(string2);
                String property = sig.process(string);
                if (!Functions.isEmpty(property)) continue;
                this.properties.add(String.valueOf(this.path) + "//" + property);
            }
        }
        EntitySig es = new EntitySig(output, this.sigString, this.path);
        es.importance = this.importance;
        if (this.properties.size() > 0) {
            es.addProperties(this.properties);
        }
        this.properties.clear();
        return es;
    }

    static synchronized void loadSigs_all() throws DetectRightException, ConnectionLostException {
        Sig.loadSigs_all(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void loadSigs_all(boolean flush) throws DetectRightException, ConnectionLostException {
        if (sigs != null && sigs.size() > 0 && sigsByPath != null && sigsByPath.size() > 0 && sigsByHeader != null && sigsByHeader.size() > 0 && (!DetectRight.getFlush() || flushed)) {
            return;
        }
        DetectRight.checkPoint("Loading sigs");
        LinkedHashMap<String, Object> sigs = null;
        Sig sig = null;
        String header = "";
        String path = "";
        String importance = "";
        LinkedHashMap<Object, Object> tmpHM = new LinkedHashMap();
        LinkedHashMap<String, Object> orderClause = new LinkedHashMap<String, Object>();
        orderClause.put("ordinal", "ASC");
        DBLink db = dbLink.get();
        if (db == null) {
            Sig.cacheDB();
            db = dbLink.get();
            if (db == null) {
                throw new ConnectionLostException("Sigs lost DB");
            }
        }
        if ((sigs = db.simpleFetch("sigs", DBLink.allFields, DBLink.emptyHash, orderClause)) == null) {
            return;
        }
        LinkedHashMap<String, Object> tmpMap = sigs;
        for (Map.Entry entry : tmpMap.entrySet()) {
            String sp;
            LinkedHashMap row = (LinkedHashMap)entry.getValue();
            if (row == null || (sp = row.get("sig").toString()) == null) continue;
            sig = new Sig(sp);
            header = Functions.gvString(row, "header");
            path = Functions.gvString(row, "path");
            if (row.containsKey("importance")) {
                importance = (String)row.get("importance");
                try {
                    sig.importance = Functions.parseInt(importance);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            sig.path = path;
            LinkedHashMap<String, Object> linkedHashMap = Sig.sigs;
            synchronized (linkedHashMap) {
                Sig.sigs.put(String.valueOf(Sig.sigs.size()), sig);
            }
            linkedHashMap = sigsByHeader;
            synchronized (linkedHashMap) {
                if (!sigsByHeader.containsKey(header)) {
                    sigsByHeader.put(header, new LinkedHashMap());
                }
                tmpHM = sigsByHeader.get(header);
                tmpHM.put(String.valueOf(tmpHM.size()), sig);
            }
            linkedHashMap = sigsByPath;
            synchronized (linkedHashMap) {
                if (!sigsByPath.containsKey(path)) {
                    sigsByPath.put(path, new LinkedHashMap());
                }
                tmpHM = sigsByPath.get(path);
                tmpHM.put(String.valueOf(tmpHM.size()), sig);
            }
        }
        flushed = true;
        DetectRight.checkPoint("Loaded Sigs");
    }

    static LinkedHashMap<String, Sig> getSigsForHeader(String header) throws DetectRightException, ConnectionLostException {
        Sig.loadSigs_all();
        LinkedHashMap<String, Sig> sigs = null;
        if (sigsByHeader.containsKey(header)) {
            sigs = sigsByHeader.get(header);
        }
        if (sigs != null && sigs.size() > 0) {
            return sigs;
        }
        return new LinkedHashMap<String, Sig>();
    }

    static LinkedHashMap<String, Sig> getSigsForPath(String path) throws DetectRightException, ConnectionLostException {
        Sig.loadSigs_all();
        LinkedHashMap<String, Sig> sigs = null;
        if (sigsByPath.containsKey(path)) {
            sigs = sigsByPath.get(path);
        }
        if (sigs != null && sigs.size() > 0) {
            return sigs;
        }
        return new LinkedHashMap<String, Sig>();
    }

    static EntitySigCollection detect(String string) throws DetectRightException, ConnectionLostException {
        return Sig.detect(string, "", "");
    }

    static EntitySigCollection detect(String string, String header) throws DetectRightException, ConnectionLostException {
        return Sig.detect(string, header, "");
    }

    static EntitySigCollection detect(String string, String header, String path) throws DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Sig> sigP = null;
        Sig.loadSigs_all();
        if (!Functions.isEmpty(header)) {
            if (sigsByHeader.containsKey(header)) {
                sigP = sigsByHeader.get(header);
            }
        } else if (!Functions.isEmpty(path)) {
            if (sigsByPath.containsKey(path)) {
                sigP = sigsByPath.get(path);
            }
        } else {
            sigP = sigs;
        }
        if (sigP == null || sigP.size() == 0) {
            return null;
        }
        LinkedHashMap sigs = (LinkedHashMap)sigP.clone();
        EntitySigCollection contains = new EntitySigCollection();
        if (string == null) {
            return contains;
        }
        if (path == null) {
            path = Functions.nn(path);
        }
        PhpObject phpo = null;
        int size = sigs.size();
        int i = 0;
        while (i < size) {
            Object obj = null;
            String key = String.valueOf(i);
            if (sigs.containsKey(key)) {
                obj = sigs.get(key);
            }
            if (obj != null) {
                if (obj instanceof PhpObject) {
                    phpo = (PhpObject)obj;
                    obj = phpo.getRealObject();
                }
                if (obj instanceof Sig) {
                    Sig sig = (Sig)obj;
                    if (Functions.stripos(sig.sigString, "(") != -1 && sig.sigArray != null && sig.sigArray.size() != 0) {
                        EntitySig es;
                        SigPart sp = (SigPart)sig.sigArray.get(0);
                        String et = String.valueOf(sp.startPart) + sp.endPart;
                        if (!((et.equals("Device") || et.equals("Browser") || et.equals("Tablet")) && contains.entityTypes.contains(et) || (es = sig.getES(string)) == null)) {
                            DetectRight.checkPoint("Added Sig " + es.sig);
                            contains.addES(es);
                        }
                    }
                }
            }
            ++i;
        }
        return contains;
    }

    ArrayList<String> _sleep() {
        LinkedHashMap<String, Object> ov = Reflection.get_object_vars(this);
        return Functions.array_keys_string(ov);
    }
}

