/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Functions;
import java.util.ArrayList;

public class State {
    private int directHit = 0;
    private int importance = 0;
    private int status = 0;

    public static void main(String[] args) {
    }

    public State() {
    }

    public State(int status, int importance, int directHit) {
        this.directHit = directHit;
        this.status = status;
        this.importance = importance;
    }

    public int getDirectHit() {
        return this.directHit;
    }

    public void setDirectHit(int directHit) {
        this.directHit = directHit;
    }

    public int getImportance() {
        return this.importance;
    }

    public void setImportance(int importance) {
        this.importance = importance;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public State(String sid) {
        if (Functions.isEmpty(sid)) {
            return;
        }
        try {
            ArrayList<String> sidArr = Functions.explode(":", sid);
            int statusInt = Functions.parseInt(sidArr.get(0));
            if (statusInt < 0 || statusInt > 1) {
                statusInt = 1;
            }
            this.status = statusInt;
            if (sidArr.size() > 1) {
                int importanceInt;
                this.importance = importanceInt = Functions.parseInt(sidArr.get(1));
            }
            if (sidArr.size() > 2) {
                int directHitInt;
                this.directHit = directHitInt = Functions.parseInt(sidArr.get(2));
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void directHit(int hitStatus) {
        this.directHit = hitStatus;
    }

    public void addImportance(int importance) {
        this.importance += importance;
    }

    public void invert() {
        this.status = this.status == 0 ? 1 : 0;
    }

    public String toString() {
        StringBuilder sid = new StringBuilder();
        sid.append(this.status);
        sid.append(":");
        sid.append(this.importance);
        sid.append(":");
        sid.append(this.directHit);
        return sid.toString();
    }
}

