/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Functions;
import com.detectright.core.State;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateCollection {
    private LinkedHashMap<String, State> states = new LinkedHashMap();
    private State lastState;
    private State collapsedState;
    private boolean dirty = false;

    public static void main(String[] args) {
    }

    public State getCollapsedState() {
        if (this.dirty) {
            this.collapse();
        }
        return this.collapsedState;
    }

    public State getLastState() {
        return this.lastState;
    }

    public State getState(String stateStr) {
        if (this.states == null) {
            return null;
        }
        if (!this.states.containsKey(stateStr)) {
            return null;
        }
        return this.states.get(stateStr);
    }

    public ArrayList<String> toArray() {
        ArrayList<String> retArray = Functions.array_keys_string(this.states);
        return retArray;
    }

    public void addSC(StateCollection sc) {
        this.addSC(sc, false);
    }

    public void addSC(StateCollection sc, boolean indirect) {
        ArrayList<String> scKeys = sc.toArray();
        if (scKeys == null) {
            return;
        }
        for (String scKey : scKeys) {
            if (indirect && Functions.substr(scKey, -2, 2).equals(":1")) {
                scKey = String.valueOf(Functions.substr(scKey, 0, -2)) + ":0";
            }
            this.addState(scKey);
        }
        this.dirty = true;
    }

    public void collapse() {
        State nullState = new State("0:0:0");
        if (this.states == null || this.states.size() == 0) {
            this.collapsedState = nullState;
            return;
        }
        if (this.states.size() == 1) {
            this.collapsedState = this.lastState;
            return;
        }
        int statusZeroMaxImportance = 0;
        int statusOneMaxImportance = 0;
        int statusZeroDirectHit = 0;
        int statusOneDirectHit = 0;
        int collapsedDirectHit = 0;
        int collapsedStatus = 0;
        int collapsedImportance = 0;
        int statusOneCount = 0;
        int statusZeroCount = 0;
        LinkedHashMap<String, State> tmpMap = this.states;
        for (Map.Entry entry : tmpMap.entrySet()) {
            State s = (State)entry.getValue();
            if (s == null) continue;
            int status = s.getStatus();
            int importance = s.getImportance();
            if (status == 0) {
                ++statusZeroCount;
                if (importance > statusZeroMaxImportance) {
                    statusZeroMaxImportance = importance;
                }
                if (statusZeroDirectHit != 1 && s.getDirectHit() != 1) continue;
                statusZeroDirectHit = 1;
                continue;
            }
            if (status != 1) continue;
            ++statusOneCount;
            if (importance > statusOneMaxImportance) {
                statusOneMaxImportance = importance;
            }
            if (!statusOneDirectHit && s.getDirectHit() != 1) continue;
            statusOneDirectHit = 1;
        }
        collapsedDirectHit = statusZeroDirectHit;
        collapsedStatus = 0;
        collapsedImportance = statusZeroMaxImportance;
        if (statusOneDirectHit == collapsedDirectHit && statusOneDirectHit) {
            if (statusOneMaxImportance >= collapsedImportance) {
                collapsedImportance = statusOneMaxImportance;
                collapsedStatus = 1;
                collapsedDirectHit = 1;
            }
        } else if (statusOneDirectHit == collapsedDirectHit) {
            if (statusOneMaxImportance >= collapsedImportance) {
                collapsedImportance = statusOneMaxImportance;
                collapsedStatus = 1;
            }
        } else if (statusOneDirectHit) {
            collapsedImportance = statusOneMaxImportance;
            collapsedStatus = 1;
            collapsedDirectHit = 1;
        } else if (statusOneMaxImportance == 0) {
            collapsedStatus = 0;
        } else if (statusOneMaxImportance > statusZeroMaxImportance - 20) {
            collapsedImportance = statusOneMaxImportance;
            collapsedStatus = 1;
        }
        this.collapsedState = new State(collapsedStatus, collapsedImportance, collapsedDirectHit);
        this.dirty = false;
    }

    public int getStatus() {
        if (this.dirty) {
            this.collapse();
        }
        if (this.collapsedState == null) {
            return 0;
        }
        return this.collapsedState.getStatus();
    }

    public int getImportance() {
        if (this.dirty) {
            this.collapse();
        }
        if (this.collapsedState == null) {
            return 0;
        }
        return this.collapsedState.getImportance();
    }

    public String toString() {
        ArrayList<String> keys = Functions.array_keys_string(this.states);
        return Functions.implode("|", keys);
    }

    public void fromString(String statesStr) {
        ArrayList<String> states = Functions.explode("|", statesStr);
        for (String state : states) {
            this.addState(new State(state));
        }
    }

    public void addImportance(int importance) {
        LinkedHashMap oldStates = (LinkedHashMap)this.states.clone();
        this.states.clear();
        for (Map.Entry kvp : oldStates.entrySet()) {
            State s = (State)kvp.getValue();
            if (s == null) continue;
            s.addImportance(importance);
            this.addState(s);
        }
        this.dirty = true;
    }

    public void invert() {
        LinkedHashMap oldStates = (LinkedHashMap)this.states.clone();
        this.states.clear();
        for (Map.Entry kvp : oldStates.entrySet()) {
            State s = (State)kvp.getValue();
            if (s == null) continue;
            s.invert();
            this.addState(s);
        }
        this.dirty = true;
    }

    public void resolve() {
        this.collapse();
        this.states.clear();
        this.addState(this.collapsedState);
    }

    public int size() {
        if (this.states == null) {
            return 0;
        }
        return this.states.size();
    }

    public int count() {
        return this.size();
    }

    public void addState(String stateStr) {
        State state = new State(stateStr);
        this.addState(state);
    }

    public void addState(int status, int importance, int directHit) {
        State state = new State(status, importance, directHit);
        this.addState(state);
    }

    public void addState(State state) {
        if (state == null) {
            return;
        }
        String stateKey = state.toString();
        if (this.states == null) {
            this.states = new LinkedHashMap();
        }
        if (this.states.containsKey(stateKey)) {
            return;
        }
        this.states.put(stateKey, state);
        this.lastState = state;
        this.dirty = true;
    }

    public void directHit(int hitStatus) {
        if (this.lastState == null) {
            return;
        }
        this.lastState.directHit(hitStatus);
    }

    ArrayList<String> extractStates(ArrayList<String> sidArr) {
        ArrayList<String> output = new ArrayList<String>();
        State state = new State();
        boolean stateSeen = false;
        int i = 0;
        while (i < sidArr.size()) {
            String item = sidArr.get(i);
            if ((item = Functions.str_replace("=", "->", item)).startsWith("sc->")) {
                this.fromString(Functions.substr(item, 4));
            }
            if (item.startsWith("state->")) {
                this.addState(Functions.substr(item, 7));
            } else if (item.startsWith("importance->")) {
                try {
                    String importance = Functions.substr(item, 12).trim();
                    state.setImportance(Functions.parseInt(importance));
                    stateSeen = true;
                }
                catch (NumberFormatException importance) {}
            } else if (item.startsWith("status->")) {
                try {
                    String status = Functions.substr(item, 8).trim();
                    state.setStatus(Functions.parseInt(status));
                    stateSeen = true;
                }
                catch (NumberFormatException status) {}
            } else if (item.startsWith("directHit->")) {
                try {
                    String directHit = Functions.substr(item, 11).trim();
                    state.setDirectHit(Functions.parseInt(directHit));
                    stateSeen = true;
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                output.add(sidArr.get(i));
            }
            ++i;
        }
        if (stateSeen) {
            this.addState(state);
        }
        return output;
    }
}

