"""
utility functions for python setup
"""
import tempfile
import os
import sys
import shutil
from distutils.ccompiler import new_compiler

# From http://stackoverflow.com/questions/
# 7018879/disabling-output-when-compiling-with-distutils
def hasfunction(cc, funcname):
    tmpdir = tempfile.mkdtemp(prefix='hasfunction-')
    devnull = oldstderr = None
    try:
        try:
            fname = os.path.join(tmpdir, 'funcname.c')
            f = open(fname, 'w')
            f.write('int main(void) {\n')
            f.write(' %s();\n' % funcname)
            f.write('}\n')
            f.close()
            # Redirect stderr to /dev/null to hide any error messages
            # from the compiler.
            # This will have to be changed if we ever have to check
            # for a function on Windows.
            devnull = open('/dev/null', 'w')
            oldstderr = os.dup(sys.stderr.fileno())
            os.dup2(devnull.fileno(), sys.stderr.fileno())
            objects = cc.compile([fname], output_dir=tmpdir)
            cc.link_executable(objects, os.path.join(tmpdir, "a.out"))
        except:
            return False
        return True
    finally:
        if oldstderr is not None:
            os.dup2(oldstderr, sys.stderr.fileno())
        if devnull is not None:
            devnull.close()
        shutil.rmtree(tmpdir)


def detect_openmp():
    compiler = new_compiler()
    hasopenmp = hasfunction(compiler, 'omp_get_num_threads')
    needs_gomp = hasopenmp
    if not hasopenmp:
        compiler.add_library('gomp')
        hasopenmp = hasfunction(compiler, 'omp_get_num_threads')
        needs_gomp = hasopenmp
    return hasopenmp, needs_gomp


def getSetuptoolsError():
    bootstrap_setuptools = """\
python2.7 -c "import urllib2;
url=\'https://bootstrap.pypa.io/ez_setup.py\';\n
exec urllib2.urlopen(url).read()\""""
    cmd = ((80 * '=') + '\n' + bootstrap_setuptools + '\n' + (80 * '='))
    s = 'You can use the following command to upgrade/install it:\n%s' % cmd
    return s
