/* soapC.c
   Generated by gSOAP 2.8.8 from TurbulenceService.h

Copyright(C) 2000-2012, Robert van Engelen, Genivia Inc. All Rights Reserved.
The generated code is released under one of the following licenses:
1) GPL or 2) Genivia's license for commercial use.
This program is released under the GPL with the additional exemption that
compiling, linking, and/or using OpenSSL is allowed.
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif

#include "soapH.h"

#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) soapC.c ver 2.8.8 2014-08-01 18:48:23 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		if (soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL))
			return soap->error;
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
{
	if (!soap->header)
	{	if ((soap->header = (struct SOAP_ENV__Header*)soap_malloc(soap, sizeof(struct SOAP_ENV__Header))))
			soap_default_SOAP_ENV__Header(soap, soap->header);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		if (!soap->fault)
			return;
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2 && soap->fault->SOAP_ENV__Code)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char * SOAP_FMAC4 soap_check_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (soap->fault->SOAP_ENV__Code && soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode && soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
			return soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
		return NULL;
	}
	return soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

SOAP_FMAC3 const char * SOAP_FMAC4 soap_check_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2 && soap->fault->SOAP_ENV__Detail)
		return soap->fault->SOAP_ENV__Detail->__any;
	if (soap->fault->detail)
		return soap->fault->detail->__any;
	return NULL;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	if (soap->version == 1)
	{	for (;;)
		{	if (!soap_getelement(soap, &t))
				if (soap->error || soap_ignore_element(soap))
					break;
		}
	}
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{	(void)type;
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_float:
		return soap_in_float(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_unsignedByte:
		return soap_in_unsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedInt:
		return soap_in_unsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_turb1__TemporalInterpolation:
		return soap_in_turb1__TemporalInterpolation(soap, NULL, NULL, "turb1:TemporalInterpolation");
	case SOAP_TYPE_turb1__SpatialInterpolation:
		return soap_in_turb1__SpatialInterpolation(soap, NULL, NULL, "turb1:SpatialInterpolation");
	case SOAP_TYPE_turb1__ThresholdInfo:
		return soap_in_turb1__ThresholdInfo(soap, NULL, NULL, "turb1:ThresholdInfo");
	case SOAP_TYPE_turb1__ArrayOfThresholdInfo:
		return soap_in_turb1__ArrayOfThresholdInfo(soap, NULL, NULL, "turb1:ArrayOfThresholdInfo");
	case SOAP_TYPE_turb1__SGSTensor:
		return soap_in_turb1__SGSTensor(soap, NULL, NULL, "turb1:SGSTensor");
	case SOAP_TYPE_turb1__ArrayOfSGSTensor:
		return soap_in_turb1__ArrayOfSGSTensor(soap, NULL, NULL, "turb1:ArrayOfSGSTensor");
	case SOAP_TYPE_turb1__VelocityHessian:
		return soap_in_turb1__VelocityHessian(soap, NULL, NULL, "turb1:VelocityHessian");
	case SOAP_TYPE_turb1__ArrayOfVelocityHessian:
		return soap_in_turb1__ArrayOfVelocityHessian(soap, NULL, NULL, "turb1:ArrayOfVelocityHessian");
	case SOAP_TYPE_turb1__VelocityGradient:
		return soap_in_turb1__VelocityGradient(soap, NULL, NULL, "turb1:VelocityGradient");
	case SOAP_TYPE_turb1__ArrayOfVelocityGradient:
		return soap_in_turb1__ArrayOfVelocityGradient(soap, NULL, NULL, "turb1:ArrayOfVelocityGradient");
	case SOAP_TYPE_turb1__Vector3P:
		return soap_in_turb1__Vector3P(soap, NULL, NULL, "turb1:Vector3P");
	case SOAP_TYPE_turb1__ArrayOfVector3P:
		return soap_in_turb1__ArrayOfVector3P(soap, NULL, NULL, "turb1:ArrayOfVector3P");
	case SOAP_TYPE_turb1__PressureHessian:
		return soap_in_turb1__PressureHessian(soap, NULL, NULL, "turb1:PressureHessian");
	case SOAP_TYPE_turb1__ArrayOfPressureHessian:
		return soap_in_turb1__ArrayOfPressureHessian(soap, NULL, NULL, "turb1:ArrayOfPressureHessian");
	case SOAP_TYPE_turb1__Pressure:
		return soap_in_turb1__Pressure(soap, NULL, NULL, "turb1:Pressure");
	case SOAP_TYPE_turb1__ArrayOfPressure:
		return soap_in_turb1__ArrayOfPressure(soap, NULL, NULL, "turb1:ArrayOfPressure");
	case SOAP_TYPE_turb1__Vector3:
		return soap_in_turb1__Vector3(soap, NULL, NULL, "turb1:Vector3");
	case SOAP_TYPE_turb1__ArrayOfVector3:
		return soap_in_turb1__ArrayOfVector3(soap, NULL, NULL, "turb1:ArrayOfVector3");
	case SOAP_TYPE_turb1__Point3:
		return soap_in_turb1__Point3(soap, NULL, NULL, "turb1:Point3");
	case SOAP_TYPE_turb1__ArrayOfPoint3:
		return soap_in_turb1__ArrayOfPoint3(soap, NULL, NULL, "turb1:ArrayOfPoint3");
	case SOAP_TYPE_xsd__base64Binary:
		return soap_in_xsd__base64Binary(soap, NULL, NULL, "xsd:base64Binary");
	case SOAP_TYPE_PointerTo_turb1__GetLaplacianOfGradientResponse:
		return soap_in_PointerTo_turb1__GetLaplacianOfGradientResponse(soap, NULL, NULL, "turb1:GetLaplacianOfGradientResponse");
	case SOAP_TYPE_PointerTo_turb1__GetLaplacianOfGradient:
		return soap_in_PointerTo_turb1__GetLaplacianOfGradient(soap, NULL, NULL, "turb1:GetLaplacianOfGradient");
	case SOAP_TYPE_PointerTo_turb1__GetThresholdResponse:
		return soap_in_PointerTo_turb1__GetThresholdResponse(soap, NULL, NULL, "turb1:GetThresholdResponse");
	case SOAP_TYPE_PointerTo_turb1__GetThreshold:
		return soap_in_PointerTo_turb1__GetThreshold(soap, NULL, NULL, "turb1:GetThreshold");
	case SOAP_TYPE_PointerTo_turb1__GetBoxFilterGradientResponse:
		return soap_in_PointerTo_turb1__GetBoxFilterGradientResponse(soap, NULL, NULL, "turb1:GetBoxFilterGradientResponse");
	case SOAP_TYPE_PointerTo_turb1__GetBoxFilterGradient:
		return soap_in_PointerTo_turb1__GetBoxFilterGradient(soap, NULL, NULL, "turb1:GetBoxFilterGradient");
	case SOAP_TYPE_PointerTo_turb1__GetBoxFilterSGSResponse:
		return soap_in_PointerTo_turb1__GetBoxFilterSGSResponse(soap, NULL, NULL, "turb1:GetBoxFilterSGSResponse");
	case SOAP_TYPE_PointerTo_turb1__GetBoxFilterSGS:
		return soap_in_PointerTo_turb1__GetBoxFilterSGS(soap, NULL, NULL, "turb1:GetBoxFilterSGS");
	case SOAP_TYPE_PointerTo_turb1__GetBoxFilterResponse:
		return soap_in_PointerTo_turb1__GetBoxFilterResponse(soap, NULL, NULL, "turb1:GetBoxFilterResponse");
	case SOAP_TYPE_PointerTo_turb1__GetBoxFilter:
		return soap_in_PointerTo_turb1__GetBoxFilter(soap, NULL, NULL, "turb1:GetBoxFilter");
	case SOAP_TYPE_PointerTo_turb1__GetPositionResponse:
		return soap_in_PointerTo_turb1__GetPositionResponse(soap, NULL, NULL, "turb1:GetPositionResponse");
	case SOAP_TYPE_PointerTo_turb1__GetPosition:
		return soap_in_PointerTo_turb1__GetPosition(soap, NULL, NULL, "turb1:GetPosition");
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotentialLaplacianResponse:
		return soap_in_PointerTo_turb1__GetVectorPotentialLaplacianResponse(soap, NULL, NULL, "turb1:GetVectorPotentialLaplacianResponse");
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotentialLaplacian:
		return soap_in_PointerTo_turb1__GetVectorPotentialLaplacian(soap, NULL, NULL, "turb1:GetVectorPotentialLaplacian");
	case SOAP_TYPE_PointerTo_turb1__GetMagneticFieldLaplacianResponse:
		return soap_in_PointerTo_turb1__GetMagneticFieldLaplacianResponse(soap, NULL, NULL, "turb1:GetMagneticFieldLaplacianResponse");
	case SOAP_TYPE_PointerTo_turb1__GetMagneticFieldLaplacian:
		return soap_in_PointerTo_turb1__GetMagneticFieldLaplacian(soap, NULL, NULL, "turb1:GetMagneticFieldLaplacian");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityLaplacianResponse:
		return soap_in_PointerTo_turb1__GetVelocityLaplacianResponse(soap, NULL, NULL, "turb1:GetVelocityLaplacianResponse");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityLaplacian:
		return soap_in_PointerTo_turb1__GetVelocityLaplacian(soap, NULL, NULL, "turb1:GetVelocityLaplacian");
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotentialHessianResponse:
		return soap_in_PointerTo_turb1__GetVectorPotentialHessianResponse(soap, NULL, NULL, "turb1:GetVectorPotentialHessianResponse");
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotentialHessian:
		return soap_in_PointerTo_turb1__GetVectorPotentialHessian(soap, NULL, NULL, "turb1:GetVectorPotentialHessian");
	case SOAP_TYPE_PointerTo_turb1__GetMagneticHessianResponse:
		return soap_in_PointerTo_turb1__GetMagneticHessianResponse(soap, NULL, NULL, "turb1:GetMagneticHessianResponse");
	case SOAP_TYPE_PointerTo_turb1__GetMagneticHessian:
		return soap_in_PointerTo_turb1__GetMagneticHessian(soap, NULL, NULL, "turb1:GetMagneticHessian");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityHessianResponse:
		return soap_in_PointerTo_turb1__GetVelocityHessianResponse(soap, NULL, NULL, "turb1:GetVelocityHessianResponse");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityHessian:
		return soap_in_PointerTo_turb1__GetVelocityHessian(soap, NULL, NULL, "turb1:GetVelocityHessian");
	case SOAP_TYPE_PointerTo_turb1__GetPressureHessianResponse:
		return soap_in_PointerTo_turb1__GetPressureHessianResponse(soap, NULL, NULL, "turb1:GetPressureHessianResponse");
	case SOAP_TYPE_PointerTo_turb1__GetPressureHessian:
		return soap_in_PointerTo_turb1__GetPressureHessian(soap, NULL, NULL, "turb1:GetPressureHessian");
	case SOAP_TYPE_PointerTo_turb1__GetPressureGradientResponse:
		return soap_in_PointerTo_turb1__GetPressureGradientResponse(soap, NULL, NULL, "turb1:GetPressureGradientResponse");
	case SOAP_TYPE_PointerTo_turb1__GetPressureGradient:
		return soap_in_PointerTo_turb1__GetPressureGradient(soap, NULL, NULL, "turb1:GetPressureGradient");
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotentialGradientResponse:
		return soap_in_PointerTo_turb1__GetVectorPotentialGradientResponse(soap, NULL, NULL, "turb1:GetVectorPotentialGradientResponse");
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotentialGradient:
		return soap_in_PointerTo_turb1__GetVectorPotentialGradient(soap, NULL, NULL, "turb1:GetVectorPotentialGradient");
	case SOAP_TYPE_PointerTo_turb1__GetMagneticFieldGradientResponse:
		return soap_in_PointerTo_turb1__GetMagneticFieldGradientResponse(soap, NULL, NULL, "turb1:GetMagneticFieldGradientResponse");
	case SOAP_TYPE_PointerTo_turb1__GetMagneticFieldGradient:
		return soap_in_PointerTo_turb1__GetMagneticFieldGradient(soap, NULL, NULL, "turb1:GetMagneticFieldGradient");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityGradientResponse:
		return soap_in_PointerTo_turb1__GetVelocityGradientResponse(soap, NULL, NULL, "turb1:GetVelocityGradientResponse");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityGradient:
		return soap_in_PointerTo_turb1__GetVelocityGradient(soap, NULL, NULL, "turb1:GetVelocityGradient");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityAndPressureResponse:
		return soap_in_PointerTo_turb1__GetVelocityAndPressureResponse(soap, NULL, NULL, "turb1:GetVelocityAndPressureResponse");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityAndPressure:
		return soap_in_PointerTo_turb1__GetVelocityAndPressure(soap, NULL, NULL, "turb1:GetVelocityAndPressure");
	case SOAP_TYPE_PointerTo_turb1__GetForceResponse:
		return soap_in_PointerTo_turb1__GetForceResponse(soap, NULL, NULL, "turb1:GetForceResponse");
	case SOAP_TYPE_PointerTo_turb1__GetForce:
		return soap_in_PointerTo_turb1__GetForce(soap, NULL, NULL, "turb1:GetForce");
	case SOAP_TYPE_PointerTo_turb1__GetRawDensityResponse:
		return soap_in_PointerTo_turb1__GetRawDensityResponse(soap, NULL, NULL, "turb1:GetRawDensityResponse");
	case SOAP_TYPE_PointerTo_turb1__GetRawDensity:
		return soap_in_PointerTo_turb1__GetRawDensity(soap, NULL, NULL, "turb1:GetRawDensity");
	case SOAP_TYPE_PointerTo_turb1__GetDensityHessianResponse:
		return soap_in_PointerTo_turb1__GetDensityHessianResponse(soap, NULL, NULL, "turb1:GetDensityHessianResponse");
	case SOAP_TYPE_PointerTo_turb1__GetDensityHessian:
		return soap_in_PointerTo_turb1__GetDensityHessian(soap, NULL, NULL, "turb1:GetDensityHessian");
	case SOAP_TYPE_PointerTo_turb1__GetDensityGradientResponse:
		return soap_in_PointerTo_turb1__GetDensityGradientResponse(soap, NULL, NULL, "turb1:GetDensityGradientResponse");
	case SOAP_TYPE_PointerTo_turb1__GetDensityGradient:
		return soap_in_PointerTo_turb1__GetDensityGradient(soap, NULL, NULL, "turb1:GetDensityGradient");
	case SOAP_TYPE_PointerTo_turb1__GetDensityResponse:
		return soap_in_PointerTo_turb1__GetDensityResponse(soap, NULL, NULL, "turb1:GetDensityResponse");
	case SOAP_TYPE_PointerTo_turb1__GetDensity:
		return soap_in_PointerTo_turb1__GetDensity(soap, NULL, NULL, "turb1:GetDensity");
	case SOAP_TYPE_PointerTo_turb1__GetRawVectorPotentialResponse:
		return soap_in_PointerTo_turb1__GetRawVectorPotentialResponse(soap, NULL, NULL, "turb1:GetRawVectorPotentialResponse");
	case SOAP_TYPE_PointerTo_turb1__GetRawVectorPotential:
		return soap_in_PointerTo_turb1__GetRawVectorPotential(soap, NULL, NULL, "turb1:GetRawVectorPotential");
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotentialResponse:
		return soap_in_PointerTo_turb1__GetVectorPotentialResponse(soap, NULL, NULL, "turb1:GetVectorPotentialResponse");
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotential:
		return soap_in_PointerTo_turb1__GetVectorPotential(soap, NULL, NULL, "turb1:GetVectorPotential");
	case SOAP_TYPE_PointerTo_turb1__GetRawMagneticFieldResponse:
		return soap_in_PointerTo_turb1__GetRawMagneticFieldResponse(soap, NULL, NULL, "turb1:GetRawMagneticFieldResponse");
	case SOAP_TYPE_PointerTo_turb1__GetRawMagneticField:
		return soap_in_PointerTo_turb1__GetRawMagneticField(soap, NULL, NULL, "turb1:GetRawMagneticField");
	case SOAP_TYPE_PointerTo_turb1__GetMagneticFieldResponse:
		return soap_in_PointerTo_turb1__GetMagneticFieldResponse(soap, NULL, NULL, "turb1:GetMagneticFieldResponse");
	case SOAP_TYPE_PointerTo_turb1__GetMagneticField:
		return soap_in_PointerTo_turb1__GetMagneticField(soap, NULL, NULL, "turb1:GetMagneticField");
	case SOAP_TYPE_PointerTo_turb1__GetRawPressureResponse:
		return soap_in_PointerTo_turb1__GetRawPressureResponse(soap, NULL, NULL, "turb1:GetRawPressureResponse");
	case SOAP_TYPE_PointerTo_turb1__GetRawPressure:
		return soap_in_PointerTo_turb1__GetRawPressure(soap, NULL, NULL, "turb1:GetRawPressure");
	case SOAP_TYPE_PointerTo_turb1__GetPressureResponse:
		return soap_in_PointerTo_turb1__GetPressureResponse(soap, NULL, NULL, "turb1:GetPressureResponse");
	case SOAP_TYPE_PointerTo_turb1__GetPressure:
		return soap_in_PointerTo_turb1__GetPressure(soap, NULL, NULL, "turb1:GetPressure");
	case SOAP_TYPE_PointerTo_turb1__GetRawVelocityResponse:
		return soap_in_PointerTo_turb1__GetRawVelocityResponse(soap, NULL, NULL, "turb1:GetRawVelocityResponse");
	case SOAP_TYPE_PointerTo_turb1__GetRawVelocity:
		return soap_in_PointerTo_turb1__GetRawVelocity(soap, NULL, NULL, "turb1:GetRawVelocity");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityBatchResponse:
		return soap_in_PointerTo_turb1__GetVelocityBatchResponse(soap, NULL, NULL, "turb1:GetVelocityBatchResponse");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityBatch:
		return soap_in_PointerTo_turb1__GetVelocityBatch(soap, NULL, NULL, "turb1:GetVelocityBatch");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityResponse:
		return soap_in_PointerTo_turb1__GetVelocityResponse(soap, NULL, NULL, "turb1:GetVelocityResponse");
	case SOAP_TYPE_PointerTo_turb1__GetVelocity:
		return soap_in_PointerTo_turb1__GetVelocity(soap, NULL, NULL, "turb1:GetVelocity");
	case SOAP_TYPE_PointerTo_turb1__NullOpResponse:
		return soap_in_PointerTo_turb1__NullOpResponse(soap, NULL, NULL, "turb1:NullOpResponse");
	case SOAP_TYPE_PointerTo_turb1__NullOp:
		return soap_in_PointerTo_turb1__NullOp(soap, NULL, NULL, "turb1:NullOp");
	case SOAP_TYPE_PointerToturb1__ArrayOfThresholdInfo:
		return soap_in_PointerToturb1__ArrayOfThresholdInfo(soap, NULL, NULL, "turb1:ArrayOfThresholdInfo");
	case SOAP_TYPE_PointerToturb1__ArrayOfSGSTensor:
		return soap_in_PointerToturb1__ArrayOfSGSTensor(soap, NULL, NULL, "turb1:ArrayOfSGSTensor");
	case SOAP_TYPE_PointerToturb1__ArrayOfVelocityHessian:
		return soap_in_PointerToturb1__ArrayOfVelocityHessian(soap, NULL, NULL, "turb1:ArrayOfVelocityHessian");
	case SOAP_TYPE_PointerToturb1__ArrayOfVelocityGradient:
		return soap_in_PointerToturb1__ArrayOfVelocityGradient(soap, NULL, NULL, "turb1:ArrayOfVelocityGradient");
	case SOAP_TYPE_PointerToturb1__ArrayOfVector3P:
		return soap_in_PointerToturb1__ArrayOfVector3P(soap, NULL, NULL, "turb1:ArrayOfVector3P");
	case SOAP_TYPE_PointerToturb1__ArrayOfPressureHessian:
		return soap_in_PointerToturb1__ArrayOfPressureHessian(soap, NULL, NULL, "turb1:ArrayOfPressureHessian");
	case SOAP_TYPE_PointerToturb1__ArrayOfPressure:
		return soap_in_PointerToturb1__ArrayOfPressure(soap, NULL, NULL, "turb1:ArrayOfPressure");
	case SOAP_TYPE_PointerToxsd__base64Binary:
		return soap_in_PointerToxsd__base64Binary(soap, NULL, NULL, "xsd:base64Binary");
	case SOAP_TYPE_PointerToturb1__ArrayOfVector3:
		return soap_in_PointerToturb1__ArrayOfVector3(soap, NULL, NULL, "turb1:ArrayOfVector3");
	case SOAP_TYPE_PointerToturb1__ArrayOfPoint3:
		return soap_in_PointerToturb1__ArrayOfPoint3(soap, NULL, NULL, "turb1:ArrayOfPoint3");
	case SOAP_TYPE_PointerToturb1__ThresholdInfo:
		return soap_in_PointerToturb1__ThresholdInfo(soap, NULL, NULL, "turb1:ThresholdInfo");
	case SOAP_TYPE_PointerToturb1__SGSTensor:
		return soap_in_PointerToturb1__SGSTensor(soap, NULL, NULL, "turb1:SGSTensor");
	case SOAP_TYPE_PointerToturb1__VelocityHessian:
		return soap_in_PointerToturb1__VelocityHessian(soap, NULL, NULL, "turb1:VelocityHessian");
	case SOAP_TYPE_PointerToturb1__VelocityGradient:
		return soap_in_PointerToturb1__VelocityGradient(soap, NULL, NULL, "turb1:VelocityGradient");
	case SOAP_TYPE_PointerToturb1__Vector3P:
		return soap_in_PointerToturb1__Vector3P(soap, NULL, NULL, "turb1:Vector3P");
	case SOAP_TYPE_PointerToturb1__PressureHessian:
		return soap_in_PointerToturb1__PressureHessian(soap, NULL, NULL, "turb1:PressureHessian");
	case SOAP_TYPE_PointerToturb1__Pressure:
		return soap_in_PointerToturb1__Pressure(soap, NULL, NULL, "turb1:Pressure");
	case SOAP_TYPE_PointerToturb1__Vector3:
		return soap_in_PointerToturb1__Vector3(soap, NULL, NULL, "turb1:Vector3");
	case SOAP_TYPE_PointerToturb1__Point3:
		return soap_in_PointerToturb1__Point3(soap, NULL, NULL, "turb1:Point3");
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_in_PointerTounsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "xsd:QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:float"))
		{	*type = SOAP_TYPE_float;
			return soap_in_float(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedByte"))
		{	*type = SOAP_TYPE_unsignedByte;
			return soap_in_unsignedByte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedInt"))
		{	*type = SOAP_TYPE_unsignedInt;
			return soap_in_unsignedInt(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:TemporalInterpolation"))
		{	*type = SOAP_TYPE_turb1__TemporalInterpolation;
			return soap_in_turb1__TemporalInterpolation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:SpatialInterpolation"))
		{	*type = SOAP_TYPE_turb1__SpatialInterpolation;
			return soap_in_turb1__SpatialInterpolation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:ThresholdInfo"))
		{	*type = SOAP_TYPE_turb1__ThresholdInfo;
			return soap_in_turb1__ThresholdInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:ArrayOfThresholdInfo"))
		{	*type = SOAP_TYPE_turb1__ArrayOfThresholdInfo;
			return soap_in_turb1__ArrayOfThresholdInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:SGSTensor"))
		{	*type = SOAP_TYPE_turb1__SGSTensor;
			return soap_in_turb1__SGSTensor(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:ArrayOfSGSTensor"))
		{	*type = SOAP_TYPE_turb1__ArrayOfSGSTensor;
			return soap_in_turb1__ArrayOfSGSTensor(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:VelocityHessian"))
		{	*type = SOAP_TYPE_turb1__VelocityHessian;
			return soap_in_turb1__VelocityHessian(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:ArrayOfVelocityHessian"))
		{	*type = SOAP_TYPE_turb1__ArrayOfVelocityHessian;
			return soap_in_turb1__ArrayOfVelocityHessian(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:VelocityGradient"))
		{	*type = SOAP_TYPE_turb1__VelocityGradient;
			return soap_in_turb1__VelocityGradient(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:ArrayOfVelocityGradient"))
		{	*type = SOAP_TYPE_turb1__ArrayOfVelocityGradient;
			return soap_in_turb1__ArrayOfVelocityGradient(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:Vector3P"))
		{	*type = SOAP_TYPE_turb1__Vector3P;
			return soap_in_turb1__Vector3P(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:ArrayOfVector3P"))
		{	*type = SOAP_TYPE_turb1__ArrayOfVector3P;
			return soap_in_turb1__ArrayOfVector3P(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:PressureHessian"))
		{	*type = SOAP_TYPE_turb1__PressureHessian;
			return soap_in_turb1__PressureHessian(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:ArrayOfPressureHessian"))
		{	*type = SOAP_TYPE_turb1__ArrayOfPressureHessian;
			return soap_in_turb1__ArrayOfPressureHessian(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:Pressure"))
		{	*type = SOAP_TYPE_turb1__Pressure;
			return soap_in_turb1__Pressure(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:ArrayOfPressure"))
		{	*type = SOAP_TYPE_turb1__ArrayOfPressure;
			return soap_in_turb1__ArrayOfPressure(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:Vector3"))
		{	*type = SOAP_TYPE_turb1__Vector3;
			return soap_in_turb1__Vector3(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:ArrayOfVector3"))
		{	*type = SOAP_TYPE_turb1__ArrayOfVector3;
			return soap_in_turb1__ArrayOfVector3(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:Point3"))
		{	*type = SOAP_TYPE_turb1__Point3;
			return soap_in_turb1__Point3(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:ArrayOfPoint3"))
		{	*type = SOAP_TYPE_turb1__ArrayOfPoint3;
			return soap_in_turb1__ArrayOfPoint3(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:base64Binary"))
		{	*type = SOAP_TYPE_xsd__base64Binary;
			return soap_in_xsd__base64Binary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "turb1:GetLaplacianOfGradientResponse"))
		{	*type = SOAP_TYPE__turb1__GetLaplacianOfGradientResponse;
			return soap_in__turb1__GetLaplacianOfGradientResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetLaplacianOfGradient"))
		{	*type = SOAP_TYPE__turb1__GetLaplacianOfGradient;
			return soap_in__turb1__GetLaplacianOfGradient(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetThresholdResponse"))
		{	*type = SOAP_TYPE__turb1__GetThresholdResponse;
			return soap_in__turb1__GetThresholdResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetThreshold"))
		{	*type = SOAP_TYPE__turb1__GetThreshold;
			return soap_in__turb1__GetThreshold(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetBoxFilterGradientResponse"))
		{	*type = SOAP_TYPE__turb1__GetBoxFilterGradientResponse;
			return soap_in__turb1__GetBoxFilterGradientResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetBoxFilterGradient"))
		{	*type = SOAP_TYPE__turb1__GetBoxFilterGradient;
			return soap_in__turb1__GetBoxFilterGradient(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetBoxFilterSGSResponse"))
		{	*type = SOAP_TYPE__turb1__GetBoxFilterSGSResponse;
			return soap_in__turb1__GetBoxFilterSGSResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetBoxFilterSGS"))
		{	*type = SOAP_TYPE__turb1__GetBoxFilterSGS;
			return soap_in__turb1__GetBoxFilterSGS(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetBoxFilterResponse"))
		{	*type = SOAP_TYPE__turb1__GetBoxFilterResponse;
			return soap_in__turb1__GetBoxFilterResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetBoxFilter"))
		{	*type = SOAP_TYPE__turb1__GetBoxFilter;
			return soap_in__turb1__GetBoxFilter(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetPositionResponse"))
		{	*type = SOAP_TYPE__turb1__GetPositionResponse;
			return soap_in__turb1__GetPositionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetPosition"))
		{	*type = SOAP_TYPE__turb1__GetPosition;
			return soap_in__turb1__GetPosition(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetVectorPotentialLaplacianResponse"))
		{	*type = SOAP_TYPE__turb1__GetVectorPotentialLaplacianResponse;
			return soap_in__turb1__GetVectorPotentialLaplacianResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetVectorPotentialLaplacian"))
		{	*type = SOAP_TYPE__turb1__GetVectorPotentialLaplacian;
			return soap_in__turb1__GetVectorPotentialLaplacian(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetMagneticFieldLaplacianResponse"))
		{	*type = SOAP_TYPE__turb1__GetMagneticFieldLaplacianResponse;
			return soap_in__turb1__GetMagneticFieldLaplacianResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetMagneticFieldLaplacian"))
		{	*type = SOAP_TYPE__turb1__GetMagneticFieldLaplacian;
			return soap_in__turb1__GetMagneticFieldLaplacian(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetVelocityLaplacianResponse"))
		{	*type = SOAP_TYPE__turb1__GetVelocityLaplacianResponse;
			return soap_in__turb1__GetVelocityLaplacianResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetVelocityLaplacian"))
		{	*type = SOAP_TYPE__turb1__GetVelocityLaplacian;
			return soap_in__turb1__GetVelocityLaplacian(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetVectorPotentialHessianResponse"))
		{	*type = SOAP_TYPE__turb1__GetVectorPotentialHessianResponse;
			return soap_in__turb1__GetVectorPotentialHessianResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetVectorPotentialHessian"))
		{	*type = SOAP_TYPE__turb1__GetVectorPotentialHessian;
			return soap_in__turb1__GetVectorPotentialHessian(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetMagneticHessianResponse"))
		{	*type = SOAP_TYPE__turb1__GetMagneticHessianResponse;
			return soap_in__turb1__GetMagneticHessianResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetMagneticHessian"))
		{	*type = SOAP_TYPE__turb1__GetMagneticHessian;
			return soap_in__turb1__GetMagneticHessian(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetVelocityHessianResponse"))
		{	*type = SOAP_TYPE__turb1__GetVelocityHessianResponse;
			return soap_in__turb1__GetVelocityHessianResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetVelocityHessian"))
		{	*type = SOAP_TYPE__turb1__GetVelocityHessian;
			return soap_in__turb1__GetVelocityHessian(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetPressureHessianResponse"))
		{	*type = SOAP_TYPE__turb1__GetPressureHessianResponse;
			return soap_in__turb1__GetPressureHessianResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetPressureHessian"))
		{	*type = SOAP_TYPE__turb1__GetPressureHessian;
			return soap_in__turb1__GetPressureHessian(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetPressureGradientResponse"))
		{	*type = SOAP_TYPE__turb1__GetPressureGradientResponse;
			return soap_in__turb1__GetPressureGradientResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetPressureGradient"))
		{	*type = SOAP_TYPE__turb1__GetPressureGradient;
			return soap_in__turb1__GetPressureGradient(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetVectorPotentialGradientResponse"))
		{	*type = SOAP_TYPE__turb1__GetVectorPotentialGradientResponse;
			return soap_in__turb1__GetVectorPotentialGradientResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetVectorPotentialGradient"))
		{	*type = SOAP_TYPE__turb1__GetVectorPotentialGradient;
			return soap_in__turb1__GetVectorPotentialGradient(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetMagneticFieldGradientResponse"))
		{	*type = SOAP_TYPE__turb1__GetMagneticFieldGradientResponse;
			return soap_in__turb1__GetMagneticFieldGradientResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetMagneticFieldGradient"))
		{	*type = SOAP_TYPE__turb1__GetMagneticFieldGradient;
			return soap_in__turb1__GetMagneticFieldGradient(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetVelocityGradientResponse"))
		{	*type = SOAP_TYPE__turb1__GetVelocityGradientResponse;
			return soap_in__turb1__GetVelocityGradientResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetVelocityGradient"))
		{	*type = SOAP_TYPE__turb1__GetVelocityGradient;
			return soap_in__turb1__GetVelocityGradient(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetVelocityAndPressureResponse"))
		{	*type = SOAP_TYPE__turb1__GetVelocityAndPressureResponse;
			return soap_in__turb1__GetVelocityAndPressureResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetVelocityAndPressure"))
		{	*type = SOAP_TYPE__turb1__GetVelocityAndPressure;
			return soap_in__turb1__GetVelocityAndPressure(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetForceResponse"))
		{	*type = SOAP_TYPE__turb1__GetForceResponse;
			return soap_in__turb1__GetForceResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetForce"))
		{	*type = SOAP_TYPE__turb1__GetForce;
			return soap_in__turb1__GetForce(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetRawDensityResponse"))
		{	*type = SOAP_TYPE__turb1__GetRawDensityResponse;
			return soap_in__turb1__GetRawDensityResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetRawDensity"))
		{	*type = SOAP_TYPE__turb1__GetRawDensity;
			return soap_in__turb1__GetRawDensity(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetDensityHessianResponse"))
		{	*type = SOAP_TYPE__turb1__GetDensityHessianResponse;
			return soap_in__turb1__GetDensityHessianResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetDensityHessian"))
		{	*type = SOAP_TYPE__turb1__GetDensityHessian;
			return soap_in__turb1__GetDensityHessian(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetDensityGradientResponse"))
		{	*type = SOAP_TYPE__turb1__GetDensityGradientResponse;
			return soap_in__turb1__GetDensityGradientResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetDensityGradient"))
		{	*type = SOAP_TYPE__turb1__GetDensityGradient;
			return soap_in__turb1__GetDensityGradient(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetDensityResponse"))
		{	*type = SOAP_TYPE__turb1__GetDensityResponse;
			return soap_in__turb1__GetDensityResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetDensity"))
		{	*type = SOAP_TYPE__turb1__GetDensity;
			return soap_in__turb1__GetDensity(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetRawVectorPotentialResponse"))
		{	*type = SOAP_TYPE__turb1__GetRawVectorPotentialResponse;
			return soap_in__turb1__GetRawVectorPotentialResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetRawVectorPotential"))
		{	*type = SOAP_TYPE__turb1__GetRawVectorPotential;
			return soap_in__turb1__GetRawVectorPotential(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetVectorPotentialResponse"))
		{	*type = SOAP_TYPE__turb1__GetVectorPotentialResponse;
			return soap_in__turb1__GetVectorPotentialResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetVectorPotential"))
		{	*type = SOAP_TYPE__turb1__GetVectorPotential;
			return soap_in__turb1__GetVectorPotential(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetRawMagneticFieldResponse"))
		{	*type = SOAP_TYPE__turb1__GetRawMagneticFieldResponse;
			return soap_in__turb1__GetRawMagneticFieldResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetRawMagneticField"))
		{	*type = SOAP_TYPE__turb1__GetRawMagneticField;
			return soap_in__turb1__GetRawMagneticField(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetMagneticFieldResponse"))
		{	*type = SOAP_TYPE__turb1__GetMagneticFieldResponse;
			return soap_in__turb1__GetMagneticFieldResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetMagneticField"))
		{	*type = SOAP_TYPE__turb1__GetMagneticField;
			return soap_in__turb1__GetMagneticField(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetRawPressureResponse"))
		{	*type = SOAP_TYPE__turb1__GetRawPressureResponse;
			return soap_in__turb1__GetRawPressureResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetRawPressure"))
		{	*type = SOAP_TYPE__turb1__GetRawPressure;
			return soap_in__turb1__GetRawPressure(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetPressureResponse"))
		{	*type = SOAP_TYPE__turb1__GetPressureResponse;
			return soap_in__turb1__GetPressureResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetPressure"))
		{	*type = SOAP_TYPE__turb1__GetPressure;
			return soap_in__turb1__GetPressure(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetRawVelocityResponse"))
		{	*type = SOAP_TYPE__turb1__GetRawVelocityResponse;
			return soap_in__turb1__GetRawVelocityResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetRawVelocity"))
		{	*type = SOAP_TYPE__turb1__GetRawVelocity;
			return soap_in__turb1__GetRawVelocity(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetVelocityBatchResponse"))
		{	*type = SOAP_TYPE__turb1__GetVelocityBatchResponse;
			return soap_in__turb1__GetVelocityBatchResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetVelocityBatch"))
		{	*type = SOAP_TYPE__turb1__GetVelocityBatch;
			return soap_in__turb1__GetVelocityBatch(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetVelocityResponse"))
		{	*type = SOAP_TYPE__turb1__GetVelocityResponse;
			return soap_in__turb1__GetVelocityResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:GetVelocity"))
		{	*type = SOAP_TYPE__turb1__GetVelocity;
			return soap_in__turb1__GetVelocity(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:NullOpResponse"))
		{	*type = SOAP_TYPE__turb1__NullOpResponse;
			return soap_in__turb1__NullOpResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "turb1:NullOp"))
		{	*type = SOAP_TYPE__turb1__NullOp;
			return soap_in__turb1__NullOp(soap, NULL, NULL, NULL);
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unexpected element '%s' in input (level=%u, %d)\n", soap->tag, soap->level, soap->body));
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{	(void)tag;
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_float:
		return soap_out_float(soap, tag, id, (const float *)ptr, "xsd:float");
	case SOAP_TYPE_unsignedByte:
		return soap_out_unsignedByte(soap, tag, id, (const unsigned char *)ptr, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedInt:
		return soap_out_unsignedInt(soap, tag, id, (const unsigned int *)ptr, "xsd:unsignedInt");
	case SOAP_TYPE_turb1__TemporalInterpolation:
		return soap_out_turb1__TemporalInterpolation(soap, tag, id, (const enum turb1__TemporalInterpolation *)ptr, "turb1:TemporalInterpolation");
	case SOAP_TYPE_turb1__SpatialInterpolation:
		return soap_out_turb1__SpatialInterpolation(soap, tag, id, (const enum turb1__SpatialInterpolation *)ptr, "turb1:SpatialInterpolation");
	case SOAP_TYPE__turb1__GetLaplacianOfGradientResponse:
		return soap_out__turb1__GetLaplacianOfGradientResponse(soap, "turb1:GetLaplacianOfGradientResponse", id, (const struct _turb1__GetLaplacianOfGradientResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetLaplacianOfGradient:
		return soap_out__turb1__GetLaplacianOfGradient(soap, "turb1:GetLaplacianOfGradient", id, (const struct _turb1__GetLaplacianOfGradient *)ptr, NULL);
	case SOAP_TYPE__turb1__GetThresholdResponse:
		return soap_out__turb1__GetThresholdResponse(soap, "turb1:GetThresholdResponse", id, (const struct _turb1__GetThresholdResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetThreshold:
		return soap_out__turb1__GetThreshold(soap, "turb1:GetThreshold", id, (const struct _turb1__GetThreshold *)ptr, NULL);
	case SOAP_TYPE__turb1__GetBoxFilterGradientResponse:
		return soap_out__turb1__GetBoxFilterGradientResponse(soap, "turb1:GetBoxFilterGradientResponse", id, (const struct _turb1__GetBoxFilterGradientResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetBoxFilterGradient:
		return soap_out__turb1__GetBoxFilterGradient(soap, "turb1:GetBoxFilterGradient", id, (const struct _turb1__GetBoxFilterGradient *)ptr, NULL);
	case SOAP_TYPE__turb1__GetBoxFilterSGSResponse:
		return soap_out__turb1__GetBoxFilterSGSResponse(soap, "turb1:GetBoxFilterSGSResponse", id, (const struct _turb1__GetBoxFilterSGSResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetBoxFilterSGS:
		return soap_out__turb1__GetBoxFilterSGS(soap, "turb1:GetBoxFilterSGS", id, (const struct _turb1__GetBoxFilterSGS *)ptr, NULL);
	case SOAP_TYPE__turb1__GetBoxFilterResponse:
		return soap_out__turb1__GetBoxFilterResponse(soap, "turb1:GetBoxFilterResponse", id, (const struct _turb1__GetBoxFilterResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetBoxFilter:
		return soap_out__turb1__GetBoxFilter(soap, "turb1:GetBoxFilter", id, (const struct _turb1__GetBoxFilter *)ptr, NULL);
	case SOAP_TYPE__turb1__GetPositionResponse:
		return soap_out__turb1__GetPositionResponse(soap, "turb1:GetPositionResponse", id, (const struct _turb1__GetPositionResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetPosition:
		return soap_out__turb1__GetPosition(soap, "turb1:GetPosition", id, (const struct _turb1__GetPosition *)ptr, NULL);
	case SOAP_TYPE__turb1__GetVectorPotentialLaplacianResponse:
		return soap_out__turb1__GetVectorPotentialLaplacianResponse(soap, "turb1:GetVectorPotentialLaplacianResponse", id, (const struct _turb1__GetVectorPotentialLaplacianResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetVectorPotentialLaplacian:
		return soap_out__turb1__GetVectorPotentialLaplacian(soap, "turb1:GetVectorPotentialLaplacian", id, (const struct _turb1__GetVectorPotentialLaplacian *)ptr, NULL);
	case SOAP_TYPE__turb1__GetMagneticFieldLaplacianResponse:
		return soap_out__turb1__GetMagneticFieldLaplacianResponse(soap, "turb1:GetMagneticFieldLaplacianResponse", id, (const struct _turb1__GetMagneticFieldLaplacianResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetMagneticFieldLaplacian:
		return soap_out__turb1__GetMagneticFieldLaplacian(soap, "turb1:GetMagneticFieldLaplacian", id, (const struct _turb1__GetMagneticFieldLaplacian *)ptr, NULL);
	case SOAP_TYPE__turb1__GetVelocityLaplacianResponse:
		return soap_out__turb1__GetVelocityLaplacianResponse(soap, "turb1:GetVelocityLaplacianResponse", id, (const struct _turb1__GetVelocityLaplacianResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetVelocityLaplacian:
		return soap_out__turb1__GetVelocityLaplacian(soap, "turb1:GetVelocityLaplacian", id, (const struct _turb1__GetVelocityLaplacian *)ptr, NULL);
	case SOAP_TYPE__turb1__GetVectorPotentialHessianResponse:
		return soap_out__turb1__GetVectorPotentialHessianResponse(soap, "turb1:GetVectorPotentialHessianResponse", id, (const struct _turb1__GetVectorPotentialHessianResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetVectorPotentialHessian:
		return soap_out__turb1__GetVectorPotentialHessian(soap, "turb1:GetVectorPotentialHessian", id, (const struct _turb1__GetVectorPotentialHessian *)ptr, NULL);
	case SOAP_TYPE__turb1__GetMagneticHessianResponse:
		return soap_out__turb1__GetMagneticHessianResponse(soap, "turb1:GetMagneticHessianResponse", id, (const struct _turb1__GetMagneticHessianResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetMagneticHessian:
		return soap_out__turb1__GetMagneticHessian(soap, "turb1:GetMagneticHessian", id, (const struct _turb1__GetMagneticHessian *)ptr, NULL);
	case SOAP_TYPE__turb1__GetVelocityHessianResponse:
		return soap_out__turb1__GetVelocityHessianResponse(soap, "turb1:GetVelocityHessianResponse", id, (const struct _turb1__GetVelocityHessianResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetVelocityHessian:
		return soap_out__turb1__GetVelocityHessian(soap, "turb1:GetVelocityHessian", id, (const struct _turb1__GetVelocityHessian *)ptr, NULL);
	case SOAP_TYPE__turb1__GetPressureHessianResponse:
		return soap_out__turb1__GetPressureHessianResponse(soap, "turb1:GetPressureHessianResponse", id, (const struct _turb1__GetPressureHessianResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetPressureHessian:
		return soap_out__turb1__GetPressureHessian(soap, "turb1:GetPressureHessian", id, (const struct _turb1__GetPressureHessian *)ptr, NULL);
	case SOAP_TYPE__turb1__GetPressureGradientResponse:
		return soap_out__turb1__GetPressureGradientResponse(soap, "turb1:GetPressureGradientResponse", id, (const struct _turb1__GetPressureGradientResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetPressureGradient:
		return soap_out__turb1__GetPressureGradient(soap, "turb1:GetPressureGradient", id, (const struct _turb1__GetPressureGradient *)ptr, NULL);
	case SOAP_TYPE__turb1__GetVectorPotentialGradientResponse:
		return soap_out__turb1__GetVectorPotentialGradientResponse(soap, "turb1:GetVectorPotentialGradientResponse", id, (const struct _turb1__GetVectorPotentialGradientResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetVectorPotentialGradient:
		return soap_out__turb1__GetVectorPotentialGradient(soap, "turb1:GetVectorPotentialGradient", id, (const struct _turb1__GetVectorPotentialGradient *)ptr, NULL);
	case SOAP_TYPE__turb1__GetMagneticFieldGradientResponse:
		return soap_out__turb1__GetMagneticFieldGradientResponse(soap, "turb1:GetMagneticFieldGradientResponse", id, (const struct _turb1__GetMagneticFieldGradientResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetMagneticFieldGradient:
		return soap_out__turb1__GetMagneticFieldGradient(soap, "turb1:GetMagneticFieldGradient", id, (const struct _turb1__GetMagneticFieldGradient *)ptr, NULL);
	case SOAP_TYPE__turb1__GetVelocityGradientResponse:
		return soap_out__turb1__GetVelocityGradientResponse(soap, "turb1:GetVelocityGradientResponse", id, (const struct _turb1__GetVelocityGradientResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetVelocityGradient:
		return soap_out__turb1__GetVelocityGradient(soap, "turb1:GetVelocityGradient", id, (const struct _turb1__GetVelocityGradient *)ptr, NULL);
	case SOAP_TYPE__turb1__GetVelocityAndPressureResponse:
		return soap_out__turb1__GetVelocityAndPressureResponse(soap, "turb1:GetVelocityAndPressureResponse", id, (const struct _turb1__GetVelocityAndPressureResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetVelocityAndPressure:
		return soap_out__turb1__GetVelocityAndPressure(soap, "turb1:GetVelocityAndPressure", id, (const struct _turb1__GetVelocityAndPressure *)ptr, NULL);
	case SOAP_TYPE__turb1__GetForceResponse:
		return soap_out__turb1__GetForceResponse(soap, "turb1:GetForceResponse", id, (const struct _turb1__GetForceResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetForce:
		return soap_out__turb1__GetForce(soap, "turb1:GetForce", id, (const struct _turb1__GetForce *)ptr, NULL);
	case SOAP_TYPE__turb1__GetRawDensityResponse:
		return soap_out__turb1__GetRawDensityResponse(soap, "turb1:GetRawDensityResponse", id, (const struct _turb1__GetRawDensityResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetRawDensity:
		return soap_out__turb1__GetRawDensity(soap, "turb1:GetRawDensity", id, (const struct _turb1__GetRawDensity *)ptr, NULL);
	case SOAP_TYPE__turb1__GetDensityHessianResponse:
		return soap_out__turb1__GetDensityHessianResponse(soap, "turb1:GetDensityHessianResponse", id, (const struct _turb1__GetDensityHessianResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetDensityHessian:
		return soap_out__turb1__GetDensityHessian(soap, "turb1:GetDensityHessian", id, (const struct _turb1__GetDensityHessian *)ptr, NULL);
	case SOAP_TYPE__turb1__GetDensityGradientResponse:
		return soap_out__turb1__GetDensityGradientResponse(soap, "turb1:GetDensityGradientResponse", id, (const struct _turb1__GetDensityGradientResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetDensityGradient:
		return soap_out__turb1__GetDensityGradient(soap, "turb1:GetDensityGradient", id, (const struct _turb1__GetDensityGradient *)ptr, NULL);
	case SOAP_TYPE__turb1__GetDensityResponse:
		return soap_out__turb1__GetDensityResponse(soap, "turb1:GetDensityResponse", id, (const struct _turb1__GetDensityResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetDensity:
		return soap_out__turb1__GetDensity(soap, "turb1:GetDensity", id, (const struct _turb1__GetDensity *)ptr, NULL);
	case SOAP_TYPE__turb1__GetRawVectorPotentialResponse:
		return soap_out__turb1__GetRawVectorPotentialResponse(soap, "turb1:GetRawVectorPotentialResponse", id, (const struct _turb1__GetRawVectorPotentialResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetRawVectorPotential:
		return soap_out__turb1__GetRawVectorPotential(soap, "turb1:GetRawVectorPotential", id, (const struct _turb1__GetRawVectorPotential *)ptr, NULL);
	case SOAP_TYPE__turb1__GetVectorPotentialResponse:
		return soap_out__turb1__GetVectorPotentialResponse(soap, "turb1:GetVectorPotentialResponse", id, (const struct _turb1__GetVectorPotentialResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetVectorPotential:
		return soap_out__turb1__GetVectorPotential(soap, "turb1:GetVectorPotential", id, (const struct _turb1__GetVectorPotential *)ptr, NULL);
	case SOAP_TYPE__turb1__GetRawMagneticFieldResponse:
		return soap_out__turb1__GetRawMagneticFieldResponse(soap, "turb1:GetRawMagneticFieldResponse", id, (const struct _turb1__GetRawMagneticFieldResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetRawMagneticField:
		return soap_out__turb1__GetRawMagneticField(soap, "turb1:GetRawMagneticField", id, (const struct _turb1__GetRawMagneticField *)ptr, NULL);
	case SOAP_TYPE__turb1__GetMagneticFieldResponse:
		return soap_out__turb1__GetMagneticFieldResponse(soap, "turb1:GetMagneticFieldResponse", id, (const struct _turb1__GetMagneticFieldResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetMagneticField:
		return soap_out__turb1__GetMagneticField(soap, "turb1:GetMagneticField", id, (const struct _turb1__GetMagneticField *)ptr, NULL);
	case SOAP_TYPE__turb1__GetRawPressureResponse:
		return soap_out__turb1__GetRawPressureResponse(soap, "turb1:GetRawPressureResponse", id, (const struct _turb1__GetRawPressureResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetRawPressure:
		return soap_out__turb1__GetRawPressure(soap, "turb1:GetRawPressure", id, (const struct _turb1__GetRawPressure *)ptr, NULL);
	case SOAP_TYPE__turb1__GetPressureResponse:
		return soap_out__turb1__GetPressureResponse(soap, "turb1:GetPressureResponse", id, (const struct _turb1__GetPressureResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetPressure:
		return soap_out__turb1__GetPressure(soap, "turb1:GetPressure", id, (const struct _turb1__GetPressure *)ptr, NULL);
	case SOAP_TYPE__turb1__GetRawVelocityResponse:
		return soap_out__turb1__GetRawVelocityResponse(soap, "turb1:GetRawVelocityResponse", id, (const struct _turb1__GetRawVelocityResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetRawVelocity:
		return soap_out__turb1__GetRawVelocity(soap, "turb1:GetRawVelocity", id, (const struct _turb1__GetRawVelocity *)ptr, NULL);
	case SOAP_TYPE__turb1__GetVelocityBatchResponse:
		return soap_out__turb1__GetVelocityBatchResponse(soap, "turb1:GetVelocityBatchResponse", id, (const struct _turb1__GetVelocityBatchResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetVelocityBatch:
		return soap_out__turb1__GetVelocityBatch(soap, "turb1:GetVelocityBatch", id, (const struct _turb1__GetVelocityBatch *)ptr, NULL);
	case SOAP_TYPE__turb1__GetVelocityResponse:
		return soap_out__turb1__GetVelocityResponse(soap, "turb1:GetVelocityResponse", id, (const struct _turb1__GetVelocityResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__GetVelocity:
		return soap_out__turb1__GetVelocity(soap, "turb1:GetVelocity", id, (const struct _turb1__GetVelocity *)ptr, NULL);
	case SOAP_TYPE__turb1__NullOpResponse:
		return soap_out__turb1__NullOpResponse(soap, "turb1:NullOpResponse", id, (const struct _turb1__NullOpResponse *)ptr, NULL);
	case SOAP_TYPE__turb1__NullOp:
		return soap_out__turb1__NullOp(soap, "turb1:NullOp", id, (const struct _turb1__NullOp *)ptr, NULL);
	case SOAP_TYPE_turb1__ThresholdInfo:
		return soap_out_turb1__ThresholdInfo(soap, tag, id, (const struct turb1__ThresholdInfo *)ptr, "turb1:ThresholdInfo");
	case SOAP_TYPE_turb1__ArrayOfThresholdInfo:
		return soap_out_turb1__ArrayOfThresholdInfo(soap, tag, id, (const struct turb1__ArrayOfThresholdInfo *)ptr, "turb1:ArrayOfThresholdInfo");
	case SOAP_TYPE_turb1__SGSTensor:
		return soap_out_turb1__SGSTensor(soap, tag, id, (const struct turb1__SGSTensor *)ptr, "turb1:SGSTensor");
	case SOAP_TYPE_turb1__ArrayOfSGSTensor:
		return soap_out_turb1__ArrayOfSGSTensor(soap, tag, id, (const struct turb1__ArrayOfSGSTensor *)ptr, "turb1:ArrayOfSGSTensor");
	case SOAP_TYPE_turb1__VelocityHessian:
		return soap_out_turb1__VelocityHessian(soap, tag, id, (const struct turb1__VelocityHessian *)ptr, "turb1:VelocityHessian");
	case SOAP_TYPE_turb1__ArrayOfVelocityHessian:
		return soap_out_turb1__ArrayOfVelocityHessian(soap, tag, id, (const struct turb1__ArrayOfVelocityHessian *)ptr, "turb1:ArrayOfVelocityHessian");
	case SOAP_TYPE_turb1__VelocityGradient:
		return soap_out_turb1__VelocityGradient(soap, tag, id, (const struct turb1__VelocityGradient *)ptr, "turb1:VelocityGradient");
	case SOAP_TYPE_turb1__ArrayOfVelocityGradient:
		return soap_out_turb1__ArrayOfVelocityGradient(soap, tag, id, (const struct turb1__ArrayOfVelocityGradient *)ptr, "turb1:ArrayOfVelocityGradient");
	case SOAP_TYPE_turb1__Vector3P:
		return soap_out_turb1__Vector3P(soap, tag, id, (const struct turb1__Vector3P *)ptr, "turb1:Vector3P");
	case SOAP_TYPE_turb1__ArrayOfVector3P:
		return soap_out_turb1__ArrayOfVector3P(soap, tag, id, (const struct turb1__ArrayOfVector3P *)ptr, "turb1:ArrayOfVector3P");
	case SOAP_TYPE_turb1__PressureHessian:
		return soap_out_turb1__PressureHessian(soap, tag, id, (const struct turb1__PressureHessian *)ptr, "turb1:PressureHessian");
	case SOAP_TYPE_turb1__ArrayOfPressureHessian:
		return soap_out_turb1__ArrayOfPressureHessian(soap, tag, id, (const struct turb1__ArrayOfPressureHessian *)ptr, "turb1:ArrayOfPressureHessian");
	case SOAP_TYPE_turb1__Pressure:
		return soap_out_turb1__Pressure(soap, tag, id, (const struct turb1__Pressure *)ptr, "turb1:Pressure");
	case SOAP_TYPE_turb1__ArrayOfPressure:
		return soap_out_turb1__ArrayOfPressure(soap, tag, id, (const struct turb1__ArrayOfPressure *)ptr, "turb1:ArrayOfPressure");
	case SOAP_TYPE_turb1__Vector3:
		return soap_out_turb1__Vector3(soap, tag, id, (const struct turb1__Vector3 *)ptr, "turb1:Vector3");
	case SOAP_TYPE_turb1__ArrayOfVector3:
		return soap_out_turb1__ArrayOfVector3(soap, tag, id, (const struct turb1__ArrayOfVector3 *)ptr, "turb1:ArrayOfVector3");
	case SOAP_TYPE_turb1__Point3:
		return soap_out_turb1__Point3(soap, tag, id, (const struct turb1__Point3 *)ptr, "turb1:Point3");
	case SOAP_TYPE_turb1__ArrayOfPoint3:
		return soap_out_turb1__ArrayOfPoint3(soap, tag, id, (const struct turb1__ArrayOfPoint3 *)ptr, "turb1:ArrayOfPoint3");
	case SOAP_TYPE_xsd__base64Binary:
		return soap_out_xsd__base64Binary(soap, tag, id, (const struct xsd__base64Binary *)ptr, "xsd:base64Binary");
	case SOAP_TYPE_PointerTo_turb1__GetLaplacianOfGradientResponse:
		return soap_out_PointerTo_turb1__GetLaplacianOfGradientResponse(soap, tag, id, (struct _turb1__GetLaplacianOfGradientResponse *const*)ptr, "turb1:GetLaplacianOfGradientResponse");
	case SOAP_TYPE_PointerTo_turb1__GetLaplacianOfGradient:
		return soap_out_PointerTo_turb1__GetLaplacianOfGradient(soap, tag, id, (struct _turb1__GetLaplacianOfGradient *const*)ptr, "turb1:GetLaplacianOfGradient");
	case SOAP_TYPE_PointerTo_turb1__GetThresholdResponse:
		return soap_out_PointerTo_turb1__GetThresholdResponse(soap, tag, id, (struct _turb1__GetThresholdResponse *const*)ptr, "turb1:GetThresholdResponse");
	case SOAP_TYPE_PointerTo_turb1__GetThreshold:
		return soap_out_PointerTo_turb1__GetThreshold(soap, tag, id, (struct _turb1__GetThreshold *const*)ptr, "turb1:GetThreshold");
	case SOAP_TYPE_PointerTo_turb1__GetBoxFilterGradientResponse:
		return soap_out_PointerTo_turb1__GetBoxFilterGradientResponse(soap, tag, id, (struct _turb1__GetBoxFilterGradientResponse *const*)ptr, "turb1:GetBoxFilterGradientResponse");
	case SOAP_TYPE_PointerTo_turb1__GetBoxFilterGradient:
		return soap_out_PointerTo_turb1__GetBoxFilterGradient(soap, tag, id, (struct _turb1__GetBoxFilterGradient *const*)ptr, "turb1:GetBoxFilterGradient");
	case SOAP_TYPE_PointerTo_turb1__GetBoxFilterSGSResponse:
		return soap_out_PointerTo_turb1__GetBoxFilterSGSResponse(soap, tag, id, (struct _turb1__GetBoxFilterSGSResponse *const*)ptr, "turb1:GetBoxFilterSGSResponse");
	case SOAP_TYPE_PointerTo_turb1__GetBoxFilterSGS:
		return soap_out_PointerTo_turb1__GetBoxFilterSGS(soap, tag, id, (struct _turb1__GetBoxFilterSGS *const*)ptr, "turb1:GetBoxFilterSGS");
	case SOAP_TYPE_PointerTo_turb1__GetBoxFilterResponse:
		return soap_out_PointerTo_turb1__GetBoxFilterResponse(soap, tag, id, (struct _turb1__GetBoxFilterResponse *const*)ptr, "turb1:GetBoxFilterResponse");
	case SOAP_TYPE_PointerTo_turb1__GetBoxFilter:
		return soap_out_PointerTo_turb1__GetBoxFilter(soap, tag, id, (struct _turb1__GetBoxFilter *const*)ptr, "turb1:GetBoxFilter");
	case SOAP_TYPE_PointerTo_turb1__GetPositionResponse:
		return soap_out_PointerTo_turb1__GetPositionResponse(soap, tag, id, (struct _turb1__GetPositionResponse *const*)ptr, "turb1:GetPositionResponse");
	case SOAP_TYPE_PointerTo_turb1__GetPosition:
		return soap_out_PointerTo_turb1__GetPosition(soap, tag, id, (struct _turb1__GetPosition *const*)ptr, "turb1:GetPosition");
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotentialLaplacianResponse:
		return soap_out_PointerTo_turb1__GetVectorPotentialLaplacianResponse(soap, tag, id, (struct _turb1__GetVectorPotentialLaplacianResponse *const*)ptr, "turb1:GetVectorPotentialLaplacianResponse");
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotentialLaplacian:
		return soap_out_PointerTo_turb1__GetVectorPotentialLaplacian(soap, tag, id, (struct _turb1__GetVectorPotentialLaplacian *const*)ptr, "turb1:GetVectorPotentialLaplacian");
	case SOAP_TYPE_PointerTo_turb1__GetMagneticFieldLaplacianResponse:
		return soap_out_PointerTo_turb1__GetMagneticFieldLaplacianResponse(soap, tag, id, (struct _turb1__GetMagneticFieldLaplacianResponse *const*)ptr, "turb1:GetMagneticFieldLaplacianResponse");
	case SOAP_TYPE_PointerTo_turb1__GetMagneticFieldLaplacian:
		return soap_out_PointerTo_turb1__GetMagneticFieldLaplacian(soap, tag, id, (struct _turb1__GetMagneticFieldLaplacian *const*)ptr, "turb1:GetMagneticFieldLaplacian");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityLaplacianResponse:
		return soap_out_PointerTo_turb1__GetVelocityLaplacianResponse(soap, tag, id, (struct _turb1__GetVelocityLaplacianResponse *const*)ptr, "turb1:GetVelocityLaplacianResponse");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityLaplacian:
		return soap_out_PointerTo_turb1__GetVelocityLaplacian(soap, tag, id, (struct _turb1__GetVelocityLaplacian *const*)ptr, "turb1:GetVelocityLaplacian");
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotentialHessianResponse:
		return soap_out_PointerTo_turb1__GetVectorPotentialHessianResponse(soap, tag, id, (struct _turb1__GetVectorPotentialHessianResponse *const*)ptr, "turb1:GetVectorPotentialHessianResponse");
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotentialHessian:
		return soap_out_PointerTo_turb1__GetVectorPotentialHessian(soap, tag, id, (struct _turb1__GetVectorPotentialHessian *const*)ptr, "turb1:GetVectorPotentialHessian");
	case SOAP_TYPE_PointerTo_turb1__GetMagneticHessianResponse:
		return soap_out_PointerTo_turb1__GetMagneticHessianResponse(soap, tag, id, (struct _turb1__GetMagneticHessianResponse *const*)ptr, "turb1:GetMagneticHessianResponse");
	case SOAP_TYPE_PointerTo_turb1__GetMagneticHessian:
		return soap_out_PointerTo_turb1__GetMagneticHessian(soap, tag, id, (struct _turb1__GetMagneticHessian *const*)ptr, "turb1:GetMagneticHessian");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityHessianResponse:
		return soap_out_PointerTo_turb1__GetVelocityHessianResponse(soap, tag, id, (struct _turb1__GetVelocityHessianResponse *const*)ptr, "turb1:GetVelocityHessianResponse");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityHessian:
		return soap_out_PointerTo_turb1__GetVelocityHessian(soap, tag, id, (struct _turb1__GetVelocityHessian *const*)ptr, "turb1:GetVelocityHessian");
	case SOAP_TYPE_PointerTo_turb1__GetPressureHessianResponse:
		return soap_out_PointerTo_turb1__GetPressureHessianResponse(soap, tag, id, (struct _turb1__GetPressureHessianResponse *const*)ptr, "turb1:GetPressureHessianResponse");
	case SOAP_TYPE_PointerTo_turb1__GetPressureHessian:
		return soap_out_PointerTo_turb1__GetPressureHessian(soap, tag, id, (struct _turb1__GetPressureHessian *const*)ptr, "turb1:GetPressureHessian");
	case SOAP_TYPE_PointerTo_turb1__GetPressureGradientResponse:
		return soap_out_PointerTo_turb1__GetPressureGradientResponse(soap, tag, id, (struct _turb1__GetPressureGradientResponse *const*)ptr, "turb1:GetPressureGradientResponse");
	case SOAP_TYPE_PointerTo_turb1__GetPressureGradient:
		return soap_out_PointerTo_turb1__GetPressureGradient(soap, tag, id, (struct _turb1__GetPressureGradient *const*)ptr, "turb1:GetPressureGradient");
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotentialGradientResponse:
		return soap_out_PointerTo_turb1__GetVectorPotentialGradientResponse(soap, tag, id, (struct _turb1__GetVectorPotentialGradientResponse *const*)ptr, "turb1:GetVectorPotentialGradientResponse");
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotentialGradient:
		return soap_out_PointerTo_turb1__GetVectorPotentialGradient(soap, tag, id, (struct _turb1__GetVectorPotentialGradient *const*)ptr, "turb1:GetVectorPotentialGradient");
	case SOAP_TYPE_PointerTo_turb1__GetMagneticFieldGradientResponse:
		return soap_out_PointerTo_turb1__GetMagneticFieldGradientResponse(soap, tag, id, (struct _turb1__GetMagneticFieldGradientResponse *const*)ptr, "turb1:GetMagneticFieldGradientResponse");
	case SOAP_TYPE_PointerTo_turb1__GetMagneticFieldGradient:
		return soap_out_PointerTo_turb1__GetMagneticFieldGradient(soap, tag, id, (struct _turb1__GetMagneticFieldGradient *const*)ptr, "turb1:GetMagneticFieldGradient");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityGradientResponse:
		return soap_out_PointerTo_turb1__GetVelocityGradientResponse(soap, tag, id, (struct _turb1__GetVelocityGradientResponse *const*)ptr, "turb1:GetVelocityGradientResponse");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityGradient:
		return soap_out_PointerTo_turb1__GetVelocityGradient(soap, tag, id, (struct _turb1__GetVelocityGradient *const*)ptr, "turb1:GetVelocityGradient");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityAndPressureResponse:
		return soap_out_PointerTo_turb1__GetVelocityAndPressureResponse(soap, tag, id, (struct _turb1__GetVelocityAndPressureResponse *const*)ptr, "turb1:GetVelocityAndPressureResponse");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityAndPressure:
		return soap_out_PointerTo_turb1__GetVelocityAndPressure(soap, tag, id, (struct _turb1__GetVelocityAndPressure *const*)ptr, "turb1:GetVelocityAndPressure");
	case SOAP_TYPE_PointerTo_turb1__GetForceResponse:
		return soap_out_PointerTo_turb1__GetForceResponse(soap, tag, id, (struct _turb1__GetForceResponse *const*)ptr, "turb1:GetForceResponse");
	case SOAP_TYPE_PointerTo_turb1__GetForce:
		return soap_out_PointerTo_turb1__GetForce(soap, tag, id, (struct _turb1__GetForce *const*)ptr, "turb1:GetForce");
	case SOAP_TYPE_PointerTo_turb1__GetRawDensityResponse:
		return soap_out_PointerTo_turb1__GetRawDensityResponse(soap, tag, id, (struct _turb1__GetRawDensityResponse *const*)ptr, "turb1:GetRawDensityResponse");
	case SOAP_TYPE_PointerTo_turb1__GetRawDensity:
		return soap_out_PointerTo_turb1__GetRawDensity(soap, tag, id, (struct _turb1__GetRawDensity *const*)ptr, "turb1:GetRawDensity");
	case SOAP_TYPE_PointerTo_turb1__GetDensityHessianResponse:
		return soap_out_PointerTo_turb1__GetDensityHessianResponse(soap, tag, id, (struct _turb1__GetDensityHessianResponse *const*)ptr, "turb1:GetDensityHessianResponse");
	case SOAP_TYPE_PointerTo_turb1__GetDensityHessian:
		return soap_out_PointerTo_turb1__GetDensityHessian(soap, tag, id, (struct _turb1__GetDensityHessian *const*)ptr, "turb1:GetDensityHessian");
	case SOAP_TYPE_PointerTo_turb1__GetDensityGradientResponse:
		return soap_out_PointerTo_turb1__GetDensityGradientResponse(soap, tag, id, (struct _turb1__GetDensityGradientResponse *const*)ptr, "turb1:GetDensityGradientResponse");
	case SOAP_TYPE_PointerTo_turb1__GetDensityGradient:
		return soap_out_PointerTo_turb1__GetDensityGradient(soap, tag, id, (struct _turb1__GetDensityGradient *const*)ptr, "turb1:GetDensityGradient");
	case SOAP_TYPE_PointerTo_turb1__GetDensityResponse:
		return soap_out_PointerTo_turb1__GetDensityResponse(soap, tag, id, (struct _turb1__GetDensityResponse *const*)ptr, "turb1:GetDensityResponse");
	case SOAP_TYPE_PointerTo_turb1__GetDensity:
		return soap_out_PointerTo_turb1__GetDensity(soap, tag, id, (struct _turb1__GetDensity *const*)ptr, "turb1:GetDensity");
	case SOAP_TYPE_PointerTo_turb1__GetRawVectorPotentialResponse:
		return soap_out_PointerTo_turb1__GetRawVectorPotentialResponse(soap, tag, id, (struct _turb1__GetRawVectorPotentialResponse *const*)ptr, "turb1:GetRawVectorPotentialResponse");
	case SOAP_TYPE_PointerTo_turb1__GetRawVectorPotential:
		return soap_out_PointerTo_turb1__GetRawVectorPotential(soap, tag, id, (struct _turb1__GetRawVectorPotential *const*)ptr, "turb1:GetRawVectorPotential");
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotentialResponse:
		return soap_out_PointerTo_turb1__GetVectorPotentialResponse(soap, tag, id, (struct _turb1__GetVectorPotentialResponse *const*)ptr, "turb1:GetVectorPotentialResponse");
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotential:
		return soap_out_PointerTo_turb1__GetVectorPotential(soap, tag, id, (struct _turb1__GetVectorPotential *const*)ptr, "turb1:GetVectorPotential");
	case SOAP_TYPE_PointerTo_turb1__GetRawMagneticFieldResponse:
		return soap_out_PointerTo_turb1__GetRawMagneticFieldResponse(soap, tag, id, (struct _turb1__GetRawMagneticFieldResponse *const*)ptr, "turb1:GetRawMagneticFieldResponse");
	case SOAP_TYPE_PointerTo_turb1__GetRawMagneticField:
		return soap_out_PointerTo_turb1__GetRawMagneticField(soap, tag, id, (struct _turb1__GetRawMagneticField *const*)ptr, "turb1:GetRawMagneticField");
	case SOAP_TYPE_PointerTo_turb1__GetMagneticFieldResponse:
		return soap_out_PointerTo_turb1__GetMagneticFieldResponse(soap, tag, id, (struct _turb1__GetMagneticFieldResponse *const*)ptr, "turb1:GetMagneticFieldResponse");
	case SOAP_TYPE_PointerTo_turb1__GetMagneticField:
		return soap_out_PointerTo_turb1__GetMagneticField(soap, tag, id, (struct _turb1__GetMagneticField *const*)ptr, "turb1:GetMagneticField");
	case SOAP_TYPE_PointerTo_turb1__GetRawPressureResponse:
		return soap_out_PointerTo_turb1__GetRawPressureResponse(soap, tag, id, (struct _turb1__GetRawPressureResponse *const*)ptr, "turb1:GetRawPressureResponse");
	case SOAP_TYPE_PointerTo_turb1__GetRawPressure:
		return soap_out_PointerTo_turb1__GetRawPressure(soap, tag, id, (struct _turb1__GetRawPressure *const*)ptr, "turb1:GetRawPressure");
	case SOAP_TYPE_PointerTo_turb1__GetPressureResponse:
		return soap_out_PointerTo_turb1__GetPressureResponse(soap, tag, id, (struct _turb1__GetPressureResponse *const*)ptr, "turb1:GetPressureResponse");
	case SOAP_TYPE_PointerTo_turb1__GetPressure:
		return soap_out_PointerTo_turb1__GetPressure(soap, tag, id, (struct _turb1__GetPressure *const*)ptr, "turb1:GetPressure");
	case SOAP_TYPE_PointerTo_turb1__GetRawVelocityResponse:
		return soap_out_PointerTo_turb1__GetRawVelocityResponse(soap, tag, id, (struct _turb1__GetRawVelocityResponse *const*)ptr, "turb1:GetRawVelocityResponse");
	case SOAP_TYPE_PointerTo_turb1__GetRawVelocity:
		return soap_out_PointerTo_turb1__GetRawVelocity(soap, tag, id, (struct _turb1__GetRawVelocity *const*)ptr, "turb1:GetRawVelocity");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityBatchResponse:
		return soap_out_PointerTo_turb1__GetVelocityBatchResponse(soap, tag, id, (struct _turb1__GetVelocityBatchResponse *const*)ptr, "turb1:GetVelocityBatchResponse");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityBatch:
		return soap_out_PointerTo_turb1__GetVelocityBatch(soap, tag, id, (struct _turb1__GetVelocityBatch *const*)ptr, "turb1:GetVelocityBatch");
	case SOAP_TYPE_PointerTo_turb1__GetVelocityResponse:
		return soap_out_PointerTo_turb1__GetVelocityResponse(soap, tag, id, (struct _turb1__GetVelocityResponse *const*)ptr, "turb1:GetVelocityResponse");
	case SOAP_TYPE_PointerTo_turb1__GetVelocity:
		return soap_out_PointerTo_turb1__GetVelocity(soap, tag, id, (struct _turb1__GetVelocity *const*)ptr, "turb1:GetVelocity");
	case SOAP_TYPE_PointerTo_turb1__NullOpResponse:
		return soap_out_PointerTo_turb1__NullOpResponse(soap, tag, id, (struct _turb1__NullOpResponse *const*)ptr, "turb1:NullOpResponse");
	case SOAP_TYPE_PointerTo_turb1__NullOp:
		return soap_out_PointerTo_turb1__NullOp(soap, tag, id, (struct _turb1__NullOp *const*)ptr, "turb1:NullOp");
	case SOAP_TYPE_PointerToturb1__ArrayOfThresholdInfo:
		return soap_out_PointerToturb1__ArrayOfThresholdInfo(soap, tag, id, (struct turb1__ArrayOfThresholdInfo *const*)ptr, "turb1:ArrayOfThresholdInfo");
	case SOAP_TYPE_PointerToturb1__ArrayOfSGSTensor:
		return soap_out_PointerToturb1__ArrayOfSGSTensor(soap, tag, id, (struct turb1__ArrayOfSGSTensor *const*)ptr, "turb1:ArrayOfSGSTensor");
	case SOAP_TYPE_PointerToturb1__ArrayOfVelocityHessian:
		return soap_out_PointerToturb1__ArrayOfVelocityHessian(soap, tag, id, (struct turb1__ArrayOfVelocityHessian *const*)ptr, "turb1:ArrayOfVelocityHessian");
	case SOAP_TYPE_PointerToturb1__ArrayOfVelocityGradient:
		return soap_out_PointerToturb1__ArrayOfVelocityGradient(soap, tag, id, (struct turb1__ArrayOfVelocityGradient *const*)ptr, "turb1:ArrayOfVelocityGradient");
	case SOAP_TYPE_PointerToturb1__ArrayOfVector3P:
		return soap_out_PointerToturb1__ArrayOfVector3P(soap, tag, id, (struct turb1__ArrayOfVector3P *const*)ptr, "turb1:ArrayOfVector3P");
	case SOAP_TYPE_PointerToturb1__ArrayOfPressureHessian:
		return soap_out_PointerToturb1__ArrayOfPressureHessian(soap, tag, id, (struct turb1__ArrayOfPressureHessian *const*)ptr, "turb1:ArrayOfPressureHessian");
	case SOAP_TYPE_PointerToturb1__ArrayOfPressure:
		return soap_out_PointerToturb1__ArrayOfPressure(soap, tag, id, (struct turb1__ArrayOfPressure *const*)ptr, "turb1:ArrayOfPressure");
	case SOAP_TYPE_PointerToxsd__base64Binary:
		return soap_out_PointerToxsd__base64Binary(soap, tag, id, (struct xsd__base64Binary *const*)ptr, "xsd:base64Binary");
	case SOAP_TYPE_PointerToturb1__ArrayOfVector3:
		return soap_out_PointerToturb1__ArrayOfVector3(soap, tag, id, (struct turb1__ArrayOfVector3 *const*)ptr, "turb1:ArrayOfVector3");
	case SOAP_TYPE_PointerToturb1__ArrayOfPoint3:
		return soap_out_PointerToturb1__ArrayOfPoint3(soap, tag, id, (struct turb1__ArrayOfPoint3 *const*)ptr, "turb1:ArrayOfPoint3");
	case SOAP_TYPE_PointerToturb1__ThresholdInfo:
		return soap_out_PointerToturb1__ThresholdInfo(soap, tag, id, (struct turb1__ThresholdInfo *const*)ptr, "turb1:ThresholdInfo");
	case SOAP_TYPE_PointerToturb1__SGSTensor:
		return soap_out_PointerToturb1__SGSTensor(soap, tag, id, (struct turb1__SGSTensor *const*)ptr, "turb1:SGSTensor");
	case SOAP_TYPE_PointerToturb1__VelocityHessian:
		return soap_out_PointerToturb1__VelocityHessian(soap, tag, id, (struct turb1__VelocityHessian *const*)ptr, "turb1:VelocityHessian");
	case SOAP_TYPE_PointerToturb1__VelocityGradient:
		return soap_out_PointerToturb1__VelocityGradient(soap, tag, id, (struct turb1__VelocityGradient *const*)ptr, "turb1:VelocityGradient");
	case SOAP_TYPE_PointerToturb1__Vector3P:
		return soap_out_PointerToturb1__Vector3P(soap, tag, id, (struct turb1__Vector3P *const*)ptr, "turb1:Vector3P");
	case SOAP_TYPE_PointerToturb1__PressureHessian:
		return soap_out_PointerToturb1__PressureHessian(soap, tag, id, (struct turb1__PressureHessian *const*)ptr, "turb1:PressureHessian");
	case SOAP_TYPE_PointerToturb1__Pressure:
		return soap_out_PointerToturb1__Pressure(soap, tag, id, (struct turb1__Pressure *const*)ptr, "turb1:Pressure");
	case SOAP_TYPE_PointerToturb1__Vector3:
		return soap_out_PointerToturb1__Vector3(soap, tag, id, (struct turb1__Vector3 *const*)ptr, "turb1:Vector3");
	case SOAP_TYPE_PointerToturb1__Point3:
		return soap_out_PointerToturb1__Point3(soap, tag, id, (struct turb1__Point3 *const*)ptr, "turb1:Point3");
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_out_PointerTounsignedByte(soap, tag, id, (unsigned char *const*)ptr, "xsd:unsignedByte");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:QName");
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE___turb3__GetLaplacianOfGradient:
		soap_serialize___turb3__GetLaplacianOfGradient(soap, (const struct __turb3__GetLaplacianOfGradient *)ptr);
		break;
	case SOAP_TYPE___turb3__GetThreshold:
		soap_serialize___turb3__GetThreshold(soap, (const struct __turb3__GetThreshold *)ptr);
		break;
	case SOAP_TYPE___turb3__GetBoxFilterGradient:
		soap_serialize___turb3__GetBoxFilterGradient(soap, (const struct __turb3__GetBoxFilterGradient *)ptr);
		break;
	case SOAP_TYPE___turb3__GetBoxFilterSGS:
		soap_serialize___turb3__GetBoxFilterSGS(soap, (const struct __turb3__GetBoxFilterSGS *)ptr);
		break;
	case SOAP_TYPE___turb3__GetBoxFilter:
		soap_serialize___turb3__GetBoxFilter(soap, (const struct __turb3__GetBoxFilter *)ptr);
		break;
	case SOAP_TYPE___turb3__GetPosition:
		soap_serialize___turb3__GetPosition(soap, (const struct __turb3__GetPosition *)ptr);
		break;
	case SOAP_TYPE___turb3__GetVectorPotentialLaplacian:
		soap_serialize___turb3__GetVectorPotentialLaplacian(soap, (const struct __turb3__GetVectorPotentialLaplacian *)ptr);
		break;
	case SOAP_TYPE___turb3__GetMagneticFieldLaplacian:
		soap_serialize___turb3__GetMagneticFieldLaplacian(soap, (const struct __turb3__GetMagneticFieldLaplacian *)ptr);
		break;
	case SOAP_TYPE___turb3__GetVelocityLaplacian:
		soap_serialize___turb3__GetVelocityLaplacian(soap, (const struct __turb3__GetVelocityLaplacian *)ptr);
		break;
	case SOAP_TYPE___turb3__GetVectorPotentialHessian:
		soap_serialize___turb3__GetVectorPotentialHessian(soap, (const struct __turb3__GetVectorPotentialHessian *)ptr);
		break;
	case SOAP_TYPE___turb3__GetMagneticHessian:
		soap_serialize___turb3__GetMagneticHessian(soap, (const struct __turb3__GetMagneticHessian *)ptr);
		break;
	case SOAP_TYPE___turb3__GetVelocityHessian:
		soap_serialize___turb3__GetVelocityHessian(soap, (const struct __turb3__GetVelocityHessian *)ptr);
		break;
	case SOAP_TYPE___turb3__GetPressureHessian:
		soap_serialize___turb3__GetPressureHessian(soap, (const struct __turb3__GetPressureHessian *)ptr);
		break;
	case SOAP_TYPE___turb3__GetPressureGradient:
		soap_serialize___turb3__GetPressureGradient(soap, (const struct __turb3__GetPressureGradient *)ptr);
		break;
	case SOAP_TYPE___turb3__GetVectorPotentialGradient:
		soap_serialize___turb3__GetVectorPotentialGradient(soap, (const struct __turb3__GetVectorPotentialGradient *)ptr);
		break;
	case SOAP_TYPE___turb3__GetMagneticFieldGradient:
		soap_serialize___turb3__GetMagneticFieldGradient(soap, (const struct __turb3__GetMagneticFieldGradient *)ptr);
		break;
	case SOAP_TYPE___turb3__GetVelocityGradient:
		soap_serialize___turb3__GetVelocityGradient(soap, (const struct __turb3__GetVelocityGradient *)ptr);
		break;
	case SOAP_TYPE___turb3__GetVelocityAndPressure:
		soap_serialize___turb3__GetVelocityAndPressure(soap, (const struct __turb3__GetVelocityAndPressure *)ptr);
		break;
	case SOAP_TYPE___turb3__GetForce:
		soap_serialize___turb3__GetForce(soap, (const struct __turb3__GetForce *)ptr);
		break;
	case SOAP_TYPE___turb3__GetRawDensity:
		soap_serialize___turb3__GetRawDensity(soap, (const struct __turb3__GetRawDensity *)ptr);
		break;
	case SOAP_TYPE___turb3__GetDensityHessian:
		soap_serialize___turb3__GetDensityHessian(soap, (const struct __turb3__GetDensityHessian *)ptr);
		break;
	case SOAP_TYPE___turb3__GetDensityGradient:
		soap_serialize___turb3__GetDensityGradient(soap, (const struct __turb3__GetDensityGradient *)ptr);
		break;
	case SOAP_TYPE___turb3__GetDensity:
		soap_serialize___turb3__GetDensity(soap, (const struct __turb3__GetDensity *)ptr);
		break;
	case SOAP_TYPE___turb3__GetRawVectorPotential:
		soap_serialize___turb3__GetRawVectorPotential(soap, (const struct __turb3__GetRawVectorPotential *)ptr);
		break;
	case SOAP_TYPE___turb3__GetVectorPotential:
		soap_serialize___turb3__GetVectorPotential(soap, (const struct __turb3__GetVectorPotential *)ptr);
		break;
	case SOAP_TYPE___turb3__GetRawMagneticField:
		soap_serialize___turb3__GetRawMagneticField(soap, (const struct __turb3__GetRawMagneticField *)ptr);
		break;
	case SOAP_TYPE___turb3__GetMagneticField:
		soap_serialize___turb3__GetMagneticField(soap, (const struct __turb3__GetMagneticField *)ptr);
		break;
	case SOAP_TYPE___turb3__GetRawPressure:
		soap_serialize___turb3__GetRawPressure(soap, (const struct __turb3__GetRawPressure *)ptr);
		break;
	case SOAP_TYPE___turb3__GetPressure:
		soap_serialize___turb3__GetPressure(soap, (const struct __turb3__GetPressure *)ptr);
		break;
	case SOAP_TYPE___turb3__GetRawVelocity:
		soap_serialize___turb3__GetRawVelocity(soap, (const struct __turb3__GetRawVelocity *)ptr);
		break;
	case SOAP_TYPE___turb3__GetVelocityBatch:
		soap_serialize___turb3__GetVelocityBatch(soap, (const struct __turb3__GetVelocityBatch *)ptr);
		break;
	case SOAP_TYPE___turb3__GetVelocity:
		soap_serialize___turb3__GetVelocity(soap, (const struct __turb3__GetVelocity *)ptr);
		break;
	case SOAP_TYPE___turb3__NullOp:
		soap_serialize___turb3__NullOp(soap, (const struct __turb3__NullOp *)ptr);
		break;
	case SOAP_TYPE___turb2__GetLaplacianOfGradient:
		soap_serialize___turb2__GetLaplacianOfGradient(soap, (const struct __turb2__GetLaplacianOfGradient *)ptr);
		break;
	case SOAP_TYPE___turb2__GetThreshold:
		soap_serialize___turb2__GetThreshold(soap, (const struct __turb2__GetThreshold *)ptr);
		break;
	case SOAP_TYPE___turb2__GetBoxFilterGradient:
		soap_serialize___turb2__GetBoxFilterGradient(soap, (const struct __turb2__GetBoxFilterGradient *)ptr);
		break;
	case SOAP_TYPE___turb2__GetBoxFilterSGS:
		soap_serialize___turb2__GetBoxFilterSGS(soap, (const struct __turb2__GetBoxFilterSGS *)ptr);
		break;
	case SOAP_TYPE___turb2__GetBoxFilter:
		soap_serialize___turb2__GetBoxFilter(soap, (const struct __turb2__GetBoxFilter *)ptr);
		break;
	case SOAP_TYPE___turb2__GetPosition:
		soap_serialize___turb2__GetPosition(soap, (const struct __turb2__GetPosition *)ptr);
		break;
	case SOAP_TYPE___turb2__GetVectorPotentialLaplacian:
		soap_serialize___turb2__GetVectorPotentialLaplacian(soap, (const struct __turb2__GetVectorPotentialLaplacian *)ptr);
		break;
	case SOAP_TYPE___turb2__GetMagneticFieldLaplacian:
		soap_serialize___turb2__GetMagneticFieldLaplacian(soap, (const struct __turb2__GetMagneticFieldLaplacian *)ptr);
		break;
	case SOAP_TYPE___turb2__GetVelocityLaplacian:
		soap_serialize___turb2__GetVelocityLaplacian(soap, (const struct __turb2__GetVelocityLaplacian *)ptr);
		break;
	case SOAP_TYPE___turb2__GetVectorPotentialHessian:
		soap_serialize___turb2__GetVectorPotentialHessian(soap, (const struct __turb2__GetVectorPotentialHessian *)ptr);
		break;
	case SOAP_TYPE___turb2__GetMagneticHessian:
		soap_serialize___turb2__GetMagneticHessian(soap, (const struct __turb2__GetMagneticHessian *)ptr);
		break;
	case SOAP_TYPE___turb2__GetVelocityHessian:
		soap_serialize___turb2__GetVelocityHessian(soap, (const struct __turb2__GetVelocityHessian *)ptr);
		break;
	case SOAP_TYPE___turb2__GetPressureHessian:
		soap_serialize___turb2__GetPressureHessian(soap, (const struct __turb2__GetPressureHessian *)ptr);
		break;
	case SOAP_TYPE___turb2__GetPressureGradient:
		soap_serialize___turb2__GetPressureGradient(soap, (const struct __turb2__GetPressureGradient *)ptr);
		break;
	case SOAP_TYPE___turb2__GetVectorPotentialGradient:
		soap_serialize___turb2__GetVectorPotentialGradient(soap, (const struct __turb2__GetVectorPotentialGradient *)ptr);
		break;
	case SOAP_TYPE___turb2__GetMagneticFieldGradient:
		soap_serialize___turb2__GetMagneticFieldGradient(soap, (const struct __turb2__GetMagneticFieldGradient *)ptr);
		break;
	case SOAP_TYPE___turb2__GetVelocityGradient:
		soap_serialize___turb2__GetVelocityGradient(soap, (const struct __turb2__GetVelocityGradient *)ptr);
		break;
	case SOAP_TYPE___turb2__GetVelocityAndPressure:
		soap_serialize___turb2__GetVelocityAndPressure(soap, (const struct __turb2__GetVelocityAndPressure *)ptr);
		break;
	case SOAP_TYPE___turb2__GetForce:
		soap_serialize___turb2__GetForce(soap, (const struct __turb2__GetForce *)ptr);
		break;
	case SOAP_TYPE___turb2__GetRawDensity:
		soap_serialize___turb2__GetRawDensity(soap, (const struct __turb2__GetRawDensity *)ptr);
		break;
	case SOAP_TYPE___turb2__GetDensityHessian:
		soap_serialize___turb2__GetDensityHessian(soap, (const struct __turb2__GetDensityHessian *)ptr);
		break;
	case SOAP_TYPE___turb2__GetDensityGradient:
		soap_serialize___turb2__GetDensityGradient(soap, (const struct __turb2__GetDensityGradient *)ptr);
		break;
	case SOAP_TYPE___turb2__GetDensity:
		soap_serialize___turb2__GetDensity(soap, (const struct __turb2__GetDensity *)ptr);
		break;
	case SOAP_TYPE___turb2__GetRawVectorPotential:
		soap_serialize___turb2__GetRawVectorPotential(soap, (const struct __turb2__GetRawVectorPotential *)ptr);
		break;
	case SOAP_TYPE___turb2__GetVectorPotential:
		soap_serialize___turb2__GetVectorPotential(soap, (const struct __turb2__GetVectorPotential *)ptr);
		break;
	case SOAP_TYPE___turb2__GetRawMagneticField:
		soap_serialize___turb2__GetRawMagneticField(soap, (const struct __turb2__GetRawMagneticField *)ptr);
		break;
	case SOAP_TYPE___turb2__GetMagneticField:
		soap_serialize___turb2__GetMagneticField(soap, (const struct __turb2__GetMagneticField *)ptr);
		break;
	case SOAP_TYPE___turb2__GetRawPressure:
		soap_serialize___turb2__GetRawPressure(soap, (const struct __turb2__GetRawPressure *)ptr);
		break;
	case SOAP_TYPE___turb2__GetPressure:
		soap_serialize___turb2__GetPressure(soap, (const struct __turb2__GetPressure *)ptr);
		break;
	case SOAP_TYPE___turb2__GetRawVelocity:
		soap_serialize___turb2__GetRawVelocity(soap, (const struct __turb2__GetRawVelocity *)ptr);
		break;
	case SOAP_TYPE___turb2__GetVelocityBatch:
		soap_serialize___turb2__GetVelocityBatch(soap, (const struct __turb2__GetVelocityBatch *)ptr);
		break;
	case SOAP_TYPE___turb2__GetVelocity:
		soap_serialize___turb2__GetVelocity(soap, (const struct __turb2__GetVelocity *)ptr);
		break;
	case SOAP_TYPE___turb2__NullOp:
		soap_serialize___turb2__NullOp(soap, (const struct __turb2__NullOp *)ptr);
		break;
	case SOAP_TYPE__turb1__GetLaplacianOfGradientResponse:
		soap_serialize__turb1__GetLaplacianOfGradientResponse(soap, (const struct _turb1__GetLaplacianOfGradientResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetLaplacianOfGradient:
		soap_serialize__turb1__GetLaplacianOfGradient(soap, (const struct _turb1__GetLaplacianOfGradient *)ptr);
		break;
	case SOAP_TYPE__turb1__GetThresholdResponse:
		soap_serialize__turb1__GetThresholdResponse(soap, (const struct _turb1__GetThresholdResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetThreshold:
		soap_serialize__turb1__GetThreshold(soap, (const struct _turb1__GetThreshold *)ptr);
		break;
	case SOAP_TYPE__turb1__GetBoxFilterGradientResponse:
		soap_serialize__turb1__GetBoxFilterGradientResponse(soap, (const struct _turb1__GetBoxFilterGradientResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetBoxFilterGradient:
		soap_serialize__turb1__GetBoxFilterGradient(soap, (const struct _turb1__GetBoxFilterGradient *)ptr);
		break;
	case SOAP_TYPE__turb1__GetBoxFilterSGSResponse:
		soap_serialize__turb1__GetBoxFilterSGSResponse(soap, (const struct _turb1__GetBoxFilterSGSResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetBoxFilterSGS:
		soap_serialize__turb1__GetBoxFilterSGS(soap, (const struct _turb1__GetBoxFilterSGS *)ptr);
		break;
	case SOAP_TYPE__turb1__GetBoxFilterResponse:
		soap_serialize__turb1__GetBoxFilterResponse(soap, (const struct _turb1__GetBoxFilterResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetBoxFilter:
		soap_serialize__turb1__GetBoxFilter(soap, (const struct _turb1__GetBoxFilter *)ptr);
		break;
	case SOAP_TYPE__turb1__GetPositionResponse:
		soap_serialize__turb1__GetPositionResponse(soap, (const struct _turb1__GetPositionResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetPosition:
		soap_serialize__turb1__GetPosition(soap, (const struct _turb1__GetPosition *)ptr);
		break;
	case SOAP_TYPE__turb1__GetVectorPotentialLaplacianResponse:
		soap_serialize__turb1__GetVectorPotentialLaplacianResponse(soap, (const struct _turb1__GetVectorPotentialLaplacianResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetVectorPotentialLaplacian:
		soap_serialize__turb1__GetVectorPotentialLaplacian(soap, (const struct _turb1__GetVectorPotentialLaplacian *)ptr);
		break;
	case SOAP_TYPE__turb1__GetMagneticFieldLaplacianResponse:
		soap_serialize__turb1__GetMagneticFieldLaplacianResponse(soap, (const struct _turb1__GetMagneticFieldLaplacianResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetMagneticFieldLaplacian:
		soap_serialize__turb1__GetMagneticFieldLaplacian(soap, (const struct _turb1__GetMagneticFieldLaplacian *)ptr);
		break;
	case SOAP_TYPE__turb1__GetVelocityLaplacianResponse:
		soap_serialize__turb1__GetVelocityLaplacianResponse(soap, (const struct _turb1__GetVelocityLaplacianResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetVelocityLaplacian:
		soap_serialize__turb1__GetVelocityLaplacian(soap, (const struct _turb1__GetVelocityLaplacian *)ptr);
		break;
	case SOAP_TYPE__turb1__GetVectorPotentialHessianResponse:
		soap_serialize__turb1__GetVectorPotentialHessianResponse(soap, (const struct _turb1__GetVectorPotentialHessianResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetVectorPotentialHessian:
		soap_serialize__turb1__GetVectorPotentialHessian(soap, (const struct _turb1__GetVectorPotentialHessian *)ptr);
		break;
	case SOAP_TYPE__turb1__GetMagneticHessianResponse:
		soap_serialize__turb1__GetMagneticHessianResponse(soap, (const struct _turb1__GetMagneticHessianResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetMagneticHessian:
		soap_serialize__turb1__GetMagneticHessian(soap, (const struct _turb1__GetMagneticHessian *)ptr);
		break;
	case SOAP_TYPE__turb1__GetVelocityHessianResponse:
		soap_serialize__turb1__GetVelocityHessianResponse(soap, (const struct _turb1__GetVelocityHessianResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetVelocityHessian:
		soap_serialize__turb1__GetVelocityHessian(soap, (const struct _turb1__GetVelocityHessian *)ptr);
		break;
	case SOAP_TYPE__turb1__GetPressureHessianResponse:
		soap_serialize__turb1__GetPressureHessianResponse(soap, (const struct _turb1__GetPressureHessianResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetPressureHessian:
		soap_serialize__turb1__GetPressureHessian(soap, (const struct _turb1__GetPressureHessian *)ptr);
		break;
	case SOAP_TYPE__turb1__GetPressureGradientResponse:
		soap_serialize__turb1__GetPressureGradientResponse(soap, (const struct _turb1__GetPressureGradientResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetPressureGradient:
		soap_serialize__turb1__GetPressureGradient(soap, (const struct _turb1__GetPressureGradient *)ptr);
		break;
	case SOAP_TYPE__turb1__GetVectorPotentialGradientResponse:
		soap_serialize__turb1__GetVectorPotentialGradientResponse(soap, (const struct _turb1__GetVectorPotentialGradientResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetVectorPotentialGradient:
		soap_serialize__turb1__GetVectorPotentialGradient(soap, (const struct _turb1__GetVectorPotentialGradient *)ptr);
		break;
	case SOAP_TYPE__turb1__GetMagneticFieldGradientResponse:
		soap_serialize__turb1__GetMagneticFieldGradientResponse(soap, (const struct _turb1__GetMagneticFieldGradientResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetMagneticFieldGradient:
		soap_serialize__turb1__GetMagneticFieldGradient(soap, (const struct _turb1__GetMagneticFieldGradient *)ptr);
		break;
	case SOAP_TYPE__turb1__GetVelocityGradientResponse:
		soap_serialize__turb1__GetVelocityGradientResponse(soap, (const struct _turb1__GetVelocityGradientResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetVelocityGradient:
		soap_serialize__turb1__GetVelocityGradient(soap, (const struct _turb1__GetVelocityGradient *)ptr);
		break;
	case SOAP_TYPE__turb1__GetVelocityAndPressureResponse:
		soap_serialize__turb1__GetVelocityAndPressureResponse(soap, (const struct _turb1__GetVelocityAndPressureResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetVelocityAndPressure:
		soap_serialize__turb1__GetVelocityAndPressure(soap, (const struct _turb1__GetVelocityAndPressure *)ptr);
		break;
	case SOAP_TYPE__turb1__GetForceResponse:
		soap_serialize__turb1__GetForceResponse(soap, (const struct _turb1__GetForceResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetForce:
		soap_serialize__turb1__GetForce(soap, (const struct _turb1__GetForce *)ptr);
		break;
	case SOAP_TYPE__turb1__GetRawDensityResponse:
		soap_serialize__turb1__GetRawDensityResponse(soap, (const struct _turb1__GetRawDensityResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetRawDensity:
		soap_serialize__turb1__GetRawDensity(soap, (const struct _turb1__GetRawDensity *)ptr);
		break;
	case SOAP_TYPE__turb1__GetDensityHessianResponse:
		soap_serialize__turb1__GetDensityHessianResponse(soap, (const struct _turb1__GetDensityHessianResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetDensityHessian:
		soap_serialize__turb1__GetDensityHessian(soap, (const struct _turb1__GetDensityHessian *)ptr);
		break;
	case SOAP_TYPE__turb1__GetDensityGradientResponse:
		soap_serialize__turb1__GetDensityGradientResponse(soap, (const struct _turb1__GetDensityGradientResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetDensityGradient:
		soap_serialize__turb1__GetDensityGradient(soap, (const struct _turb1__GetDensityGradient *)ptr);
		break;
	case SOAP_TYPE__turb1__GetDensityResponse:
		soap_serialize__turb1__GetDensityResponse(soap, (const struct _turb1__GetDensityResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetDensity:
		soap_serialize__turb1__GetDensity(soap, (const struct _turb1__GetDensity *)ptr);
		break;
	case SOAP_TYPE__turb1__GetRawVectorPotentialResponse:
		soap_serialize__turb1__GetRawVectorPotentialResponse(soap, (const struct _turb1__GetRawVectorPotentialResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetRawVectorPotential:
		soap_serialize__turb1__GetRawVectorPotential(soap, (const struct _turb1__GetRawVectorPotential *)ptr);
		break;
	case SOAP_TYPE__turb1__GetVectorPotentialResponse:
		soap_serialize__turb1__GetVectorPotentialResponse(soap, (const struct _turb1__GetVectorPotentialResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetVectorPotential:
		soap_serialize__turb1__GetVectorPotential(soap, (const struct _turb1__GetVectorPotential *)ptr);
		break;
	case SOAP_TYPE__turb1__GetRawMagneticFieldResponse:
		soap_serialize__turb1__GetRawMagneticFieldResponse(soap, (const struct _turb1__GetRawMagneticFieldResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetRawMagneticField:
		soap_serialize__turb1__GetRawMagneticField(soap, (const struct _turb1__GetRawMagneticField *)ptr);
		break;
	case SOAP_TYPE__turb1__GetMagneticFieldResponse:
		soap_serialize__turb1__GetMagneticFieldResponse(soap, (const struct _turb1__GetMagneticFieldResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetMagneticField:
		soap_serialize__turb1__GetMagneticField(soap, (const struct _turb1__GetMagneticField *)ptr);
		break;
	case SOAP_TYPE__turb1__GetRawPressureResponse:
		soap_serialize__turb1__GetRawPressureResponse(soap, (const struct _turb1__GetRawPressureResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetRawPressure:
		soap_serialize__turb1__GetRawPressure(soap, (const struct _turb1__GetRawPressure *)ptr);
		break;
	case SOAP_TYPE__turb1__GetPressureResponse:
		soap_serialize__turb1__GetPressureResponse(soap, (const struct _turb1__GetPressureResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetPressure:
		soap_serialize__turb1__GetPressure(soap, (const struct _turb1__GetPressure *)ptr);
		break;
	case SOAP_TYPE__turb1__GetRawVelocityResponse:
		soap_serialize__turb1__GetRawVelocityResponse(soap, (const struct _turb1__GetRawVelocityResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetRawVelocity:
		soap_serialize__turb1__GetRawVelocity(soap, (const struct _turb1__GetRawVelocity *)ptr);
		break;
	case SOAP_TYPE__turb1__GetVelocityBatchResponse:
		soap_serialize__turb1__GetVelocityBatchResponse(soap, (const struct _turb1__GetVelocityBatchResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetVelocityBatch:
		soap_serialize__turb1__GetVelocityBatch(soap, (const struct _turb1__GetVelocityBatch *)ptr);
		break;
	case SOAP_TYPE__turb1__GetVelocityResponse:
		soap_serialize__turb1__GetVelocityResponse(soap, (const struct _turb1__GetVelocityResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__GetVelocity:
		soap_serialize__turb1__GetVelocity(soap, (const struct _turb1__GetVelocity *)ptr);
		break;
	case SOAP_TYPE__turb1__NullOpResponse:
		soap_serialize__turb1__NullOpResponse(soap, (const struct _turb1__NullOpResponse *)ptr);
		break;
	case SOAP_TYPE__turb1__NullOp:
		soap_serialize__turb1__NullOp(soap, (const struct _turb1__NullOp *)ptr);
		break;
	case SOAP_TYPE_turb1__ThresholdInfo:
		soap_serialize_turb1__ThresholdInfo(soap, (const struct turb1__ThresholdInfo *)ptr);
		break;
	case SOAP_TYPE_turb1__ArrayOfThresholdInfo:
		soap_serialize_turb1__ArrayOfThresholdInfo(soap, (const struct turb1__ArrayOfThresholdInfo *)ptr);
		break;
	case SOAP_TYPE_turb1__SGSTensor:
		soap_serialize_turb1__SGSTensor(soap, (const struct turb1__SGSTensor *)ptr);
		break;
	case SOAP_TYPE_turb1__ArrayOfSGSTensor:
		soap_serialize_turb1__ArrayOfSGSTensor(soap, (const struct turb1__ArrayOfSGSTensor *)ptr);
		break;
	case SOAP_TYPE_turb1__VelocityHessian:
		soap_serialize_turb1__VelocityHessian(soap, (const struct turb1__VelocityHessian *)ptr);
		break;
	case SOAP_TYPE_turb1__ArrayOfVelocityHessian:
		soap_serialize_turb1__ArrayOfVelocityHessian(soap, (const struct turb1__ArrayOfVelocityHessian *)ptr);
		break;
	case SOAP_TYPE_turb1__VelocityGradient:
		soap_serialize_turb1__VelocityGradient(soap, (const struct turb1__VelocityGradient *)ptr);
		break;
	case SOAP_TYPE_turb1__ArrayOfVelocityGradient:
		soap_serialize_turb1__ArrayOfVelocityGradient(soap, (const struct turb1__ArrayOfVelocityGradient *)ptr);
		break;
	case SOAP_TYPE_turb1__Vector3P:
		soap_serialize_turb1__Vector3P(soap, (const struct turb1__Vector3P *)ptr);
		break;
	case SOAP_TYPE_turb1__ArrayOfVector3P:
		soap_serialize_turb1__ArrayOfVector3P(soap, (const struct turb1__ArrayOfVector3P *)ptr);
		break;
	case SOAP_TYPE_turb1__PressureHessian:
		soap_serialize_turb1__PressureHessian(soap, (const struct turb1__PressureHessian *)ptr);
		break;
	case SOAP_TYPE_turb1__ArrayOfPressureHessian:
		soap_serialize_turb1__ArrayOfPressureHessian(soap, (const struct turb1__ArrayOfPressureHessian *)ptr);
		break;
	case SOAP_TYPE_turb1__Pressure:
		soap_serialize_turb1__Pressure(soap, (const struct turb1__Pressure *)ptr);
		break;
	case SOAP_TYPE_turb1__ArrayOfPressure:
		soap_serialize_turb1__ArrayOfPressure(soap, (const struct turb1__ArrayOfPressure *)ptr);
		break;
	case SOAP_TYPE_turb1__Vector3:
		soap_serialize_turb1__Vector3(soap, (const struct turb1__Vector3 *)ptr);
		break;
	case SOAP_TYPE_turb1__ArrayOfVector3:
		soap_serialize_turb1__ArrayOfVector3(soap, (const struct turb1__ArrayOfVector3 *)ptr);
		break;
	case SOAP_TYPE_turb1__Point3:
		soap_serialize_turb1__Point3(soap, (const struct turb1__Point3 *)ptr);
		break;
	case SOAP_TYPE_turb1__ArrayOfPoint3:
		soap_serialize_turb1__ArrayOfPoint3(soap, (const struct turb1__ArrayOfPoint3 *)ptr);
		break;
	case SOAP_TYPE_xsd__base64Binary:
		soap_serialize_xsd__base64Binary(soap, (const struct xsd__base64Binary *)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetLaplacianOfGradientResponse:
		soap_serialize_PointerTo_turb1__GetLaplacianOfGradientResponse(soap, (struct _turb1__GetLaplacianOfGradientResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetLaplacianOfGradient:
		soap_serialize_PointerTo_turb1__GetLaplacianOfGradient(soap, (struct _turb1__GetLaplacianOfGradient *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetThresholdResponse:
		soap_serialize_PointerTo_turb1__GetThresholdResponse(soap, (struct _turb1__GetThresholdResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetThreshold:
		soap_serialize_PointerTo_turb1__GetThreshold(soap, (struct _turb1__GetThreshold *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetBoxFilterGradientResponse:
		soap_serialize_PointerTo_turb1__GetBoxFilterGradientResponse(soap, (struct _turb1__GetBoxFilterGradientResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetBoxFilterGradient:
		soap_serialize_PointerTo_turb1__GetBoxFilterGradient(soap, (struct _turb1__GetBoxFilterGradient *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetBoxFilterSGSResponse:
		soap_serialize_PointerTo_turb1__GetBoxFilterSGSResponse(soap, (struct _turb1__GetBoxFilterSGSResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetBoxFilterSGS:
		soap_serialize_PointerTo_turb1__GetBoxFilterSGS(soap, (struct _turb1__GetBoxFilterSGS *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetBoxFilterResponse:
		soap_serialize_PointerTo_turb1__GetBoxFilterResponse(soap, (struct _turb1__GetBoxFilterResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetBoxFilter:
		soap_serialize_PointerTo_turb1__GetBoxFilter(soap, (struct _turb1__GetBoxFilter *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetPositionResponse:
		soap_serialize_PointerTo_turb1__GetPositionResponse(soap, (struct _turb1__GetPositionResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetPosition:
		soap_serialize_PointerTo_turb1__GetPosition(soap, (struct _turb1__GetPosition *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotentialLaplacianResponse:
		soap_serialize_PointerTo_turb1__GetVectorPotentialLaplacianResponse(soap, (struct _turb1__GetVectorPotentialLaplacianResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotentialLaplacian:
		soap_serialize_PointerTo_turb1__GetVectorPotentialLaplacian(soap, (struct _turb1__GetVectorPotentialLaplacian *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetMagneticFieldLaplacianResponse:
		soap_serialize_PointerTo_turb1__GetMagneticFieldLaplacianResponse(soap, (struct _turb1__GetMagneticFieldLaplacianResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetMagneticFieldLaplacian:
		soap_serialize_PointerTo_turb1__GetMagneticFieldLaplacian(soap, (struct _turb1__GetMagneticFieldLaplacian *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetVelocityLaplacianResponse:
		soap_serialize_PointerTo_turb1__GetVelocityLaplacianResponse(soap, (struct _turb1__GetVelocityLaplacianResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetVelocityLaplacian:
		soap_serialize_PointerTo_turb1__GetVelocityLaplacian(soap, (struct _turb1__GetVelocityLaplacian *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotentialHessianResponse:
		soap_serialize_PointerTo_turb1__GetVectorPotentialHessianResponse(soap, (struct _turb1__GetVectorPotentialHessianResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotentialHessian:
		soap_serialize_PointerTo_turb1__GetVectorPotentialHessian(soap, (struct _turb1__GetVectorPotentialHessian *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetMagneticHessianResponse:
		soap_serialize_PointerTo_turb1__GetMagneticHessianResponse(soap, (struct _turb1__GetMagneticHessianResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetMagneticHessian:
		soap_serialize_PointerTo_turb1__GetMagneticHessian(soap, (struct _turb1__GetMagneticHessian *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetVelocityHessianResponse:
		soap_serialize_PointerTo_turb1__GetVelocityHessianResponse(soap, (struct _turb1__GetVelocityHessianResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetVelocityHessian:
		soap_serialize_PointerTo_turb1__GetVelocityHessian(soap, (struct _turb1__GetVelocityHessian *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetPressureHessianResponse:
		soap_serialize_PointerTo_turb1__GetPressureHessianResponse(soap, (struct _turb1__GetPressureHessianResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetPressureHessian:
		soap_serialize_PointerTo_turb1__GetPressureHessian(soap, (struct _turb1__GetPressureHessian *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetPressureGradientResponse:
		soap_serialize_PointerTo_turb1__GetPressureGradientResponse(soap, (struct _turb1__GetPressureGradientResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetPressureGradient:
		soap_serialize_PointerTo_turb1__GetPressureGradient(soap, (struct _turb1__GetPressureGradient *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotentialGradientResponse:
		soap_serialize_PointerTo_turb1__GetVectorPotentialGradientResponse(soap, (struct _turb1__GetVectorPotentialGradientResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotentialGradient:
		soap_serialize_PointerTo_turb1__GetVectorPotentialGradient(soap, (struct _turb1__GetVectorPotentialGradient *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetMagneticFieldGradientResponse:
		soap_serialize_PointerTo_turb1__GetMagneticFieldGradientResponse(soap, (struct _turb1__GetMagneticFieldGradientResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetMagneticFieldGradient:
		soap_serialize_PointerTo_turb1__GetMagneticFieldGradient(soap, (struct _turb1__GetMagneticFieldGradient *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetVelocityGradientResponse:
		soap_serialize_PointerTo_turb1__GetVelocityGradientResponse(soap, (struct _turb1__GetVelocityGradientResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetVelocityGradient:
		soap_serialize_PointerTo_turb1__GetVelocityGradient(soap, (struct _turb1__GetVelocityGradient *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetVelocityAndPressureResponse:
		soap_serialize_PointerTo_turb1__GetVelocityAndPressureResponse(soap, (struct _turb1__GetVelocityAndPressureResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetVelocityAndPressure:
		soap_serialize_PointerTo_turb1__GetVelocityAndPressure(soap, (struct _turb1__GetVelocityAndPressure *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetForceResponse:
		soap_serialize_PointerTo_turb1__GetForceResponse(soap, (struct _turb1__GetForceResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetForce:
		soap_serialize_PointerTo_turb1__GetForce(soap, (struct _turb1__GetForce *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetRawDensityResponse:
		soap_serialize_PointerTo_turb1__GetRawDensityResponse(soap, (struct _turb1__GetRawDensityResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetRawDensity:
		soap_serialize_PointerTo_turb1__GetRawDensity(soap, (struct _turb1__GetRawDensity *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetDensityHessianResponse:
		soap_serialize_PointerTo_turb1__GetDensityHessianResponse(soap, (struct _turb1__GetDensityHessianResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetDensityHessian:
		soap_serialize_PointerTo_turb1__GetDensityHessian(soap, (struct _turb1__GetDensityHessian *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetDensityGradientResponse:
		soap_serialize_PointerTo_turb1__GetDensityGradientResponse(soap, (struct _turb1__GetDensityGradientResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetDensityGradient:
		soap_serialize_PointerTo_turb1__GetDensityGradient(soap, (struct _turb1__GetDensityGradient *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetDensityResponse:
		soap_serialize_PointerTo_turb1__GetDensityResponse(soap, (struct _turb1__GetDensityResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetDensity:
		soap_serialize_PointerTo_turb1__GetDensity(soap, (struct _turb1__GetDensity *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetRawVectorPotentialResponse:
		soap_serialize_PointerTo_turb1__GetRawVectorPotentialResponse(soap, (struct _turb1__GetRawVectorPotentialResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetRawVectorPotential:
		soap_serialize_PointerTo_turb1__GetRawVectorPotential(soap, (struct _turb1__GetRawVectorPotential *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotentialResponse:
		soap_serialize_PointerTo_turb1__GetVectorPotentialResponse(soap, (struct _turb1__GetVectorPotentialResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetVectorPotential:
		soap_serialize_PointerTo_turb1__GetVectorPotential(soap, (struct _turb1__GetVectorPotential *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetRawMagneticFieldResponse:
		soap_serialize_PointerTo_turb1__GetRawMagneticFieldResponse(soap, (struct _turb1__GetRawMagneticFieldResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetRawMagneticField:
		soap_serialize_PointerTo_turb1__GetRawMagneticField(soap, (struct _turb1__GetRawMagneticField *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetMagneticFieldResponse:
		soap_serialize_PointerTo_turb1__GetMagneticFieldResponse(soap, (struct _turb1__GetMagneticFieldResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetMagneticField:
		soap_serialize_PointerTo_turb1__GetMagneticField(soap, (struct _turb1__GetMagneticField *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetRawPressureResponse:
		soap_serialize_PointerTo_turb1__GetRawPressureResponse(soap, (struct _turb1__GetRawPressureResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetRawPressure:
		soap_serialize_PointerTo_turb1__GetRawPressure(soap, (struct _turb1__GetRawPressure *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetPressureResponse:
		soap_serialize_PointerTo_turb1__GetPressureResponse(soap, (struct _turb1__GetPressureResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetPressure:
		soap_serialize_PointerTo_turb1__GetPressure(soap, (struct _turb1__GetPressure *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetRawVelocityResponse:
		soap_serialize_PointerTo_turb1__GetRawVelocityResponse(soap, (struct _turb1__GetRawVelocityResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetRawVelocity:
		soap_serialize_PointerTo_turb1__GetRawVelocity(soap, (struct _turb1__GetRawVelocity *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetVelocityBatchResponse:
		soap_serialize_PointerTo_turb1__GetVelocityBatchResponse(soap, (struct _turb1__GetVelocityBatchResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetVelocityBatch:
		soap_serialize_PointerTo_turb1__GetVelocityBatch(soap, (struct _turb1__GetVelocityBatch *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetVelocityResponse:
		soap_serialize_PointerTo_turb1__GetVelocityResponse(soap, (struct _turb1__GetVelocityResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__GetVelocity:
		soap_serialize_PointerTo_turb1__GetVelocity(soap, (struct _turb1__GetVelocity *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__NullOpResponse:
		soap_serialize_PointerTo_turb1__NullOpResponse(soap, (struct _turb1__NullOpResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_turb1__NullOp:
		soap_serialize_PointerTo_turb1__NullOp(soap, (struct _turb1__NullOp *const*)ptr);
		break;
	case SOAP_TYPE_PointerToturb1__ArrayOfThresholdInfo:
		soap_serialize_PointerToturb1__ArrayOfThresholdInfo(soap, (struct turb1__ArrayOfThresholdInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerToturb1__ArrayOfSGSTensor:
		soap_serialize_PointerToturb1__ArrayOfSGSTensor(soap, (struct turb1__ArrayOfSGSTensor *const*)ptr);
		break;
	case SOAP_TYPE_PointerToturb1__ArrayOfVelocityHessian:
		soap_serialize_PointerToturb1__ArrayOfVelocityHessian(soap, (struct turb1__ArrayOfVelocityHessian *const*)ptr);
		break;
	case SOAP_TYPE_PointerToturb1__ArrayOfVelocityGradient:
		soap_serialize_PointerToturb1__ArrayOfVelocityGradient(soap, (struct turb1__ArrayOfVelocityGradient *const*)ptr);
		break;
	case SOAP_TYPE_PointerToturb1__ArrayOfVector3P:
		soap_serialize_PointerToturb1__ArrayOfVector3P(soap, (struct turb1__ArrayOfVector3P *const*)ptr);
		break;
	case SOAP_TYPE_PointerToturb1__ArrayOfPressureHessian:
		soap_serialize_PointerToturb1__ArrayOfPressureHessian(soap, (struct turb1__ArrayOfPressureHessian *const*)ptr);
		break;
	case SOAP_TYPE_PointerToturb1__ArrayOfPressure:
		soap_serialize_PointerToturb1__ArrayOfPressure(soap, (struct turb1__ArrayOfPressure *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__base64Binary:
		soap_serialize_PointerToxsd__base64Binary(soap, (struct xsd__base64Binary *const*)ptr);
		break;
	case SOAP_TYPE_PointerToturb1__ArrayOfVector3:
		soap_serialize_PointerToturb1__ArrayOfVector3(soap, (struct turb1__ArrayOfVector3 *const*)ptr);
		break;
	case SOAP_TYPE_PointerToturb1__ArrayOfPoint3:
		soap_serialize_PointerToturb1__ArrayOfPoint3(soap, (struct turb1__ArrayOfPoint3 *const*)ptr);
		break;
	case SOAP_TYPE_PointerToturb1__ThresholdInfo:
		soap_serialize_PointerToturb1__ThresholdInfo(soap, (struct turb1__ThresholdInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerToturb1__SGSTensor:
		soap_serialize_PointerToturb1__SGSTensor(soap, (struct turb1__SGSTensor *const*)ptr);
		break;
	case SOAP_TYPE_PointerToturb1__VelocityHessian:
		soap_serialize_PointerToturb1__VelocityHessian(soap, (struct turb1__VelocityHessian *const*)ptr);
		break;
	case SOAP_TYPE_PointerToturb1__VelocityGradient:
		soap_serialize_PointerToturb1__VelocityGradient(soap, (struct turb1__VelocityGradient *const*)ptr);
		break;
	case SOAP_TYPE_PointerToturb1__Vector3P:
		soap_serialize_PointerToturb1__Vector3P(soap, (struct turb1__Vector3P *const*)ptr);
		break;
	case SOAP_TYPE_PointerToturb1__PressureHessian:
		soap_serialize_PointerToturb1__PressureHessian(soap, (struct turb1__PressureHessian *const*)ptr);
		break;
	case SOAP_TYPE_PointerToturb1__Pressure:
		soap_serialize_PointerToturb1__Pressure(soap, (struct turb1__Pressure *const*)ptr);
		break;
	case SOAP_TYPE_PointerToturb1__Vector3:
		soap_serialize_PointerToturb1__Vector3(soap, (struct turb1__Vector3 *const*)ptr);
		break;
	case SOAP_TYPE_PointerToturb1__Point3:
		soap_serialize_PointerToturb1__Point3(soap, (struct turb1__Point3 *const*)ptr);
		break;
	case SOAP_TYPE_PointerTounsignedByte:
		soap_serialize_PointerTounsignedByte(soap, (unsigned char *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{	(void)soap; (void)type; (void)tag; (void)id;
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{	char *p;
	p = soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{	(void)soap; (void)type; (void)tag; (void)id;
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{	int *p;
	p = soap_inint(soap, tag, a, type, SOAP_TYPE_int);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag?tag:"int", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_float(struct soap *soap, float *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_float
	*a = SOAP_DEFAULT_float;
#else
	*a = (float)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_float(struct soap *soap, const char *tag, int id, const float *a, const char *type)
{	(void)soap; (void)type; (void)tag; (void)id;
	return soap_outfloat(soap, tag, id, a, type, SOAP_TYPE_float);
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_in_float(struct soap *soap, const char *tag, float *a, const char *type)
{	float *p;
	p = soap_infloat(soap, tag, a, type, SOAP_TYPE_float);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_float(struct soap *soap, const float *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_float);
	if (soap_out_float(soap, tag?tag:"float", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_get_float(struct soap *soap, float *p, const char *tag, const char *type)
{
	if ((p = soap_in_float(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedByte(struct soap *soap, unsigned char *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedByte
	*a = SOAP_DEFAULT_unsignedByte;
#else
	*a = (unsigned char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedByte(struct soap *soap, const char *tag, int id, const unsigned char *a, const char *type)
{	(void)soap; (void)type; (void)tag; (void)id;
	return soap_outunsignedByte(soap, tag, id, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_in_unsignedByte(struct soap *soap, const char *tag, unsigned char *a, const char *type)
{	unsigned char *p;
	p = soap_inunsignedByte(soap, tag, a, type, SOAP_TYPE_unsignedByte);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedByte(struct soap *soap, const unsigned char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedByte);
	if (soap_out_unsignedByte(soap, tag?tag:"unsignedByte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_get_unsignedByte(struct soap *soap, unsigned char *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedByte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedInt(struct soap *soap, unsigned int *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedInt
	*a = SOAP_DEFAULT_unsignedInt;
#else
	*a = (unsigned int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedInt(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{	(void)soap; (void)type; (void)tag; (void)id;
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_unsignedInt(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{	unsigned int *p;
	p = soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_unsignedInt);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedInt(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedInt);
	if (soap_out_unsignedInt(soap, tag?tag:"unsignedInt", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_unsignedInt(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedInt(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_turb1__TemporalInterpolation(struct soap *soap, enum turb1__TemporalInterpolation *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_turb1__TemporalInterpolation
	*a = SOAP_DEFAULT_turb1__TemporalInterpolation;
#else
	*a = (enum turb1__TemporalInterpolation)0;
#endif
}

static const struct soap_code_map soap_codes_turb1__TemporalInterpolation[] =
{	{ (long)turb1__TemporalInterpolation__None, "None" },
	{ (long)turb1__TemporalInterpolation__PCHIP, "PCHIP" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_turb1__TemporalInterpolation2s(struct soap *soap, enum turb1__TemporalInterpolation n)
{	const char *s = soap_code_str(soap_codes_turb1__TemporalInterpolation, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_turb1__TemporalInterpolation(struct soap *soap, const char *tag, int id, const enum turb1__TemporalInterpolation *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_turb1__TemporalInterpolation), type) || soap_send(soap, soap_turb1__TemporalInterpolation2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2turb1__TemporalInterpolation(struct soap *soap, const char *s, enum turb1__TemporalInterpolation *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_turb1__TemporalInterpolation, s);
	if (map)
		*a = (enum turb1__TemporalInterpolation)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum turb1__TemporalInterpolation)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum turb1__TemporalInterpolation * SOAP_FMAC4 soap_in_turb1__TemporalInterpolation(struct soap *soap, const char *tag, enum turb1__TemporalInterpolation *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum turb1__TemporalInterpolation *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_turb1__TemporalInterpolation, sizeof(enum turb1__TemporalInterpolation), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2turb1__TemporalInterpolation(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum turb1__TemporalInterpolation *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_turb1__TemporalInterpolation, 0, sizeof(enum turb1__TemporalInterpolation), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_turb1__TemporalInterpolation(struct soap *soap, const enum turb1__TemporalInterpolation *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_turb1__TemporalInterpolation);
	if (soap_out_turb1__TemporalInterpolation(soap, tag?tag:"turb1:TemporalInterpolation", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum turb1__TemporalInterpolation * SOAP_FMAC4 soap_get_turb1__TemporalInterpolation(struct soap *soap, enum turb1__TemporalInterpolation *p, const char *tag, const char *type)
{
	if ((p = soap_in_turb1__TemporalInterpolation(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_turb1__SpatialInterpolation(struct soap *soap, enum turb1__SpatialInterpolation *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_turb1__SpatialInterpolation
	*a = SOAP_DEFAULT_turb1__SpatialInterpolation;
#else
	*a = (enum turb1__SpatialInterpolation)0;
#endif
}

static const struct soap_code_map soap_codes_turb1__SpatialInterpolation[] =
{	{ (long)turb1__SpatialInterpolation__None, "None" },
	{ (long)turb1__SpatialInterpolation__None_USCOREFd4, "None_Fd4" },
	{ (long)turb1__SpatialInterpolation__None_USCOREFd6, "None_Fd6" },
	{ (long)turb1__SpatialInterpolation__None_USCOREFd8, "None_Fd8" },
	{ (long)turb1__SpatialInterpolation__Fd4Lag4, "Fd4Lag4" },
	{ (long)turb1__SpatialInterpolation__Lag4, "Lag4" },
	{ (long)turb1__SpatialInterpolation__Lag6, "Lag6" },
	{ (long)turb1__SpatialInterpolation__Lag8, "Lag8" },
	{ (long)turb1__SpatialInterpolation__M1Q4, "M1Q4" },
	{ (long)turb1__SpatialInterpolation__M2Q4, "M2Q4" },
	{ (long)turb1__SpatialInterpolation__M3Q4, "M3Q4" },
	{ (long)turb1__SpatialInterpolation__M4Q4, "M4Q4" },
	{ (long)turb1__SpatialInterpolation__M1Q6, "M1Q6" },
	{ (long)turb1__SpatialInterpolation__M2Q6, "M2Q6" },
	{ (long)turb1__SpatialInterpolation__M3Q6, "M3Q6" },
	{ (long)turb1__SpatialInterpolation__M4Q6, "M4Q6" },
	{ (long)turb1__SpatialInterpolation__M1Q8, "M1Q8" },
	{ (long)turb1__SpatialInterpolation__M2Q8, "M2Q8" },
	{ (long)turb1__SpatialInterpolation__M3Q8, "M3Q8" },
	{ (long)turb1__SpatialInterpolation__M4Q8, "M4Q8" },
	{ (long)turb1__SpatialInterpolation__M1Q10, "M1Q10" },
	{ (long)turb1__SpatialInterpolation__M2Q10, "M2Q10" },
	{ (long)turb1__SpatialInterpolation__M3Q10, "M3Q10" },
	{ (long)turb1__SpatialInterpolation__M4Q10, "M4Q10" },
	{ (long)turb1__SpatialInterpolation__M1Q12, "M1Q12" },
	{ (long)turb1__SpatialInterpolation__M2Q12, "M2Q12" },
	{ (long)turb1__SpatialInterpolation__M3Q12, "M3Q12" },
	{ (long)turb1__SpatialInterpolation__M4Q12, "M4Q12" },
	{ (long)turb1__SpatialInterpolation__M1Q14, "M1Q14" },
	{ (long)turb1__SpatialInterpolation__M2Q14, "M2Q14" },
	{ (long)turb1__SpatialInterpolation__M3Q14, "M3Q14" },
	{ (long)turb1__SpatialInterpolation__M4Q14, "M4Q14" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_turb1__SpatialInterpolation2s(struct soap *soap, enum turb1__SpatialInterpolation n)
{	const char *s = soap_code_str(soap_codes_turb1__SpatialInterpolation, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_turb1__SpatialInterpolation(struct soap *soap, const char *tag, int id, const enum turb1__SpatialInterpolation *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_turb1__SpatialInterpolation), type) || soap_send(soap, soap_turb1__SpatialInterpolation2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2turb1__SpatialInterpolation(struct soap *soap, const char *s, enum turb1__SpatialInterpolation *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_turb1__SpatialInterpolation, s);
	if (map)
		*a = (enum turb1__SpatialInterpolation)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 31)))
			return soap->error = SOAP_TYPE;
		*a = (enum turb1__SpatialInterpolation)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum turb1__SpatialInterpolation * SOAP_FMAC4 soap_in_turb1__SpatialInterpolation(struct soap *soap, const char *tag, enum turb1__SpatialInterpolation *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum turb1__SpatialInterpolation *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_turb1__SpatialInterpolation, sizeof(enum turb1__SpatialInterpolation), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2turb1__SpatialInterpolation(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum turb1__SpatialInterpolation *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_turb1__SpatialInterpolation, 0, sizeof(enum turb1__SpatialInterpolation), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_turb1__SpatialInterpolation(struct soap *soap, const enum turb1__SpatialInterpolation *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_turb1__SpatialInterpolation);
	if (soap_out_turb1__SpatialInterpolation(soap, tag?tag:"turb1:SpatialInterpolation", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum turb1__SpatialInterpolation * SOAP_FMAC4 soap_get_turb1__SpatialInterpolation(struct soap *soap, enum turb1__SpatialInterpolation *p, const char *tag, const char *type)
{
	if ((p = soap_in_turb1__SpatialInterpolation(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type))
		return soap->error;
	if (soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, ""))
		return soap->error;
	if (soap_out_string(soap, "faultstring", -1, &a->faultstring, ""))
		return soap->error;
	if (soap_out_string(soap, "faultactor", -1, &a->faultactor, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	size_t soap_flag_faultcode = 1;
	size_t soap_flag_faultstring = 1;
	size_t soap_flag_faultactor = 1;
	size_t soap_flag_detail = 1;
	size_t soap_flag_SOAP_ENV__Code = 1;
	size_t soap_flag_SOAP_ENV__Reason = 1;
	size_t soap_flag_SOAP_ENV__Node = 1;
	size_t soap_flag_SOAP_ENV__Role = 1;
	size_t soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag?tag:"SOAP-ENV:Fault", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type))
		return soap->error;
	if (soap->lang)
		soap_set_attr(soap, "xml:lang", soap->lang, 1);
	if (soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__any = NULL;
	a->__type = 0;
	a->fault = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type))
		return soap->error;
	soap_outliteral(soap, "-any", &a->__any, NULL);
	if (soap_putelement(soap, a->fault, "fault", -1, a->__type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	size_t soap_flag___any = 1;
	size_t soap_flag_fault = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type))
		return soap->error;
	if (soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Value = 1;
	size_t soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag?tag:"SOAP-ENV:Header", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetLaplacianOfGradient(struct soap *soap, struct __turb3__GetLaplacianOfGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetLaplacianOfGradient = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetLaplacianOfGradient(struct soap *soap, const struct __turb3__GetLaplacianOfGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetLaplacianOfGradient(soap, &a->turb1__GetLaplacianOfGradient);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetLaplacianOfGradient(struct soap *soap, const char *tag, int id, const struct __turb3__GetLaplacianOfGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetLaplacianOfGradient(soap, "turb1:GetLaplacianOfGradient", -1, &a->turb1__GetLaplacianOfGradient, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetLaplacianOfGradient * SOAP_FMAC4 soap_in___turb3__GetLaplacianOfGradient(struct soap *soap, const char *tag, struct __turb3__GetLaplacianOfGradient *a, const char *type)
{
	size_t soap_flag_turb1__GetLaplacianOfGradient = 1;
	short soap_flag;
	a = (struct __turb3__GetLaplacianOfGradient *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetLaplacianOfGradient, sizeof(struct __turb3__GetLaplacianOfGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetLaplacianOfGradient(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetLaplacianOfGradient && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetLaplacianOfGradient(soap, "turb1:GetLaplacianOfGradient", &a->turb1__GetLaplacianOfGradient, ""))
				{	soap_flag_turb1__GetLaplacianOfGradient--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetLaplacianOfGradient(struct soap *soap, const struct __turb3__GetLaplacianOfGradient *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetLaplacianOfGradient(soap, tag?tag:"-turb3:GetLaplacianOfGradient", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetLaplacianOfGradient * SOAP_FMAC4 soap_get___turb3__GetLaplacianOfGradient(struct soap *soap, struct __turb3__GetLaplacianOfGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetLaplacianOfGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetThreshold(struct soap *soap, struct __turb3__GetThreshold *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetThreshold = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetThreshold(struct soap *soap, const struct __turb3__GetThreshold *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetThreshold(soap, &a->turb1__GetThreshold);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetThreshold(struct soap *soap, const char *tag, int id, const struct __turb3__GetThreshold *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetThreshold(soap, "turb1:GetThreshold", -1, &a->turb1__GetThreshold, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetThreshold * SOAP_FMAC4 soap_in___turb3__GetThreshold(struct soap *soap, const char *tag, struct __turb3__GetThreshold *a, const char *type)
{
	size_t soap_flag_turb1__GetThreshold = 1;
	short soap_flag;
	a = (struct __turb3__GetThreshold *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetThreshold, sizeof(struct __turb3__GetThreshold), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetThreshold(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetThreshold && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetThreshold(soap, "turb1:GetThreshold", &a->turb1__GetThreshold, ""))
				{	soap_flag_turb1__GetThreshold--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetThreshold(struct soap *soap, const struct __turb3__GetThreshold *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetThreshold(soap, tag?tag:"-turb3:GetThreshold", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetThreshold * SOAP_FMAC4 soap_get___turb3__GetThreshold(struct soap *soap, struct __turb3__GetThreshold *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetThreshold(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetBoxFilterGradient(struct soap *soap, struct __turb3__GetBoxFilterGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetBoxFilterGradient = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetBoxFilterGradient(struct soap *soap, const struct __turb3__GetBoxFilterGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetBoxFilterGradient(soap, &a->turb1__GetBoxFilterGradient);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetBoxFilterGradient(struct soap *soap, const char *tag, int id, const struct __turb3__GetBoxFilterGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetBoxFilterGradient(soap, "turb1:GetBoxFilterGradient", -1, &a->turb1__GetBoxFilterGradient, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetBoxFilterGradient * SOAP_FMAC4 soap_in___turb3__GetBoxFilterGradient(struct soap *soap, const char *tag, struct __turb3__GetBoxFilterGradient *a, const char *type)
{
	size_t soap_flag_turb1__GetBoxFilterGradient = 1;
	short soap_flag;
	a = (struct __turb3__GetBoxFilterGradient *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetBoxFilterGradient, sizeof(struct __turb3__GetBoxFilterGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetBoxFilterGradient(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetBoxFilterGradient && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetBoxFilterGradient(soap, "turb1:GetBoxFilterGradient", &a->turb1__GetBoxFilterGradient, ""))
				{	soap_flag_turb1__GetBoxFilterGradient--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetBoxFilterGradient(struct soap *soap, const struct __turb3__GetBoxFilterGradient *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetBoxFilterGradient(soap, tag?tag:"-turb3:GetBoxFilterGradient", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetBoxFilterGradient * SOAP_FMAC4 soap_get___turb3__GetBoxFilterGradient(struct soap *soap, struct __turb3__GetBoxFilterGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetBoxFilterGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetBoxFilterSGS(struct soap *soap, struct __turb3__GetBoxFilterSGS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetBoxFilterSGS = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetBoxFilterSGS(struct soap *soap, const struct __turb3__GetBoxFilterSGS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetBoxFilterSGS(soap, &a->turb1__GetBoxFilterSGS);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetBoxFilterSGS(struct soap *soap, const char *tag, int id, const struct __turb3__GetBoxFilterSGS *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetBoxFilterSGS(soap, "turb1:GetBoxFilterSGS", -1, &a->turb1__GetBoxFilterSGS, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetBoxFilterSGS * SOAP_FMAC4 soap_in___turb3__GetBoxFilterSGS(struct soap *soap, const char *tag, struct __turb3__GetBoxFilterSGS *a, const char *type)
{
	size_t soap_flag_turb1__GetBoxFilterSGS = 1;
	short soap_flag;
	a = (struct __turb3__GetBoxFilterSGS *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetBoxFilterSGS, sizeof(struct __turb3__GetBoxFilterSGS), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetBoxFilterSGS(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetBoxFilterSGS && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetBoxFilterSGS(soap, "turb1:GetBoxFilterSGS", &a->turb1__GetBoxFilterSGS, ""))
				{	soap_flag_turb1__GetBoxFilterSGS--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetBoxFilterSGS(struct soap *soap, const struct __turb3__GetBoxFilterSGS *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetBoxFilterSGS(soap, tag?tag:"-turb3:GetBoxFilterSGS", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetBoxFilterSGS * SOAP_FMAC4 soap_get___turb3__GetBoxFilterSGS(struct soap *soap, struct __turb3__GetBoxFilterSGS *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetBoxFilterSGS(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetBoxFilter(struct soap *soap, struct __turb3__GetBoxFilter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetBoxFilter = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetBoxFilter(struct soap *soap, const struct __turb3__GetBoxFilter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetBoxFilter(soap, &a->turb1__GetBoxFilter);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetBoxFilter(struct soap *soap, const char *tag, int id, const struct __turb3__GetBoxFilter *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetBoxFilter(soap, "turb1:GetBoxFilter", -1, &a->turb1__GetBoxFilter, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetBoxFilter * SOAP_FMAC4 soap_in___turb3__GetBoxFilter(struct soap *soap, const char *tag, struct __turb3__GetBoxFilter *a, const char *type)
{
	size_t soap_flag_turb1__GetBoxFilter = 1;
	short soap_flag;
	a = (struct __turb3__GetBoxFilter *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetBoxFilter, sizeof(struct __turb3__GetBoxFilter), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetBoxFilter(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetBoxFilter && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetBoxFilter(soap, "turb1:GetBoxFilter", &a->turb1__GetBoxFilter, ""))
				{	soap_flag_turb1__GetBoxFilter--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetBoxFilter(struct soap *soap, const struct __turb3__GetBoxFilter *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetBoxFilter(soap, tag?tag:"-turb3:GetBoxFilter", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetBoxFilter * SOAP_FMAC4 soap_get___turb3__GetBoxFilter(struct soap *soap, struct __turb3__GetBoxFilter *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetBoxFilter(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetPosition(struct soap *soap, struct __turb3__GetPosition *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetPosition = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetPosition(struct soap *soap, const struct __turb3__GetPosition *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetPosition(soap, &a->turb1__GetPosition);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetPosition(struct soap *soap, const char *tag, int id, const struct __turb3__GetPosition *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetPosition(soap, "turb1:GetPosition", -1, &a->turb1__GetPosition, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetPosition * SOAP_FMAC4 soap_in___turb3__GetPosition(struct soap *soap, const char *tag, struct __turb3__GetPosition *a, const char *type)
{
	size_t soap_flag_turb1__GetPosition = 1;
	short soap_flag;
	a = (struct __turb3__GetPosition *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetPosition, sizeof(struct __turb3__GetPosition), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetPosition(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetPosition && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetPosition(soap, "turb1:GetPosition", &a->turb1__GetPosition, ""))
				{	soap_flag_turb1__GetPosition--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetPosition(struct soap *soap, const struct __turb3__GetPosition *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetPosition(soap, tag?tag:"-turb3:GetPosition", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetPosition * SOAP_FMAC4 soap_get___turb3__GetPosition(struct soap *soap, struct __turb3__GetPosition *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetPosition(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetVectorPotentialLaplacian(struct soap *soap, struct __turb3__GetVectorPotentialLaplacian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetVectorPotentialLaplacian = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetVectorPotentialLaplacian(struct soap *soap, const struct __turb3__GetVectorPotentialLaplacian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetVectorPotentialLaplacian(soap, &a->turb1__GetVectorPotentialLaplacian);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetVectorPotentialLaplacian(struct soap *soap, const char *tag, int id, const struct __turb3__GetVectorPotentialLaplacian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetVectorPotentialLaplacian(soap, "turb1:GetVectorPotentialLaplacian", -1, &a->turb1__GetVectorPotentialLaplacian, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetVectorPotentialLaplacian * SOAP_FMAC4 soap_in___turb3__GetVectorPotentialLaplacian(struct soap *soap, const char *tag, struct __turb3__GetVectorPotentialLaplacian *a, const char *type)
{
	size_t soap_flag_turb1__GetVectorPotentialLaplacian = 1;
	short soap_flag;
	a = (struct __turb3__GetVectorPotentialLaplacian *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetVectorPotentialLaplacian, sizeof(struct __turb3__GetVectorPotentialLaplacian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetVectorPotentialLaplacian(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetVectorPotentialLaplacian && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetVectorPotentialLaplacian(soap, "turb1:GetVectorPotentialLaplacian", &a->turb1__GetVectorPotentialLaplacian, ""))
				{	soap_flag_turb1__GetVectorPotentialLaplacian--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetVectorPotentialLaplacian(struct soap *soap, const struct __turb3__GetVectorPotentialLaplacian *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetVectorPotentialLaplacian(soap, tag?tag:"-turb3:GetVectorPotentialLaplacian", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetVectorPotentialLaplacian * SOAP_FMAC4 soap_get___turb3__GetVectorPotentialLaplacian(struct soap *soap, struct __turb3__GetVectorPotentialLaplacian *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetVectorPotentialLaplacian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetMagneticFieldLaplacian(struct soap *soap, struct __turb3__GetMagneticFieldLaplacian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetMagneticFieldLaplacian = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetMagneticFieldLaplacian(struct soap *soap, const struct __turb3__GetMagneticFieldLaplacian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetMagneticFieldLaplacian(soap, &a->turb1__GetMagneticFieldLaplacian);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetMagneticFieldLaplacian(struct soap *soap, const char *tag, int id, const struct __turb3__GetMagneticFieldLaplacian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetMagneticFieldLaplacian(soap, "turb1:GetMagneticFieldLaplacian", -1, &a->turb1__GetMagneticFieldLaplacian, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetMagneticFieldLaplacian * SOAP_FMAC4 soap_in___turb3__GetMagneticFieldLaplacian(struct soap *soap, const char *tag, struct __turb3__GetMagneticFieldLaplacian *a, const char *type)
{
	size_t soap_flag_turb1__GetMagneticFieldLaplacian = 1;
	short soap_flag;
	a = (struct __turb3__GetMagneticFieldLaplacian *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetMagneticFieldLaplacian, sizeof(struct __turb3__GetMagneticFieldLaplacian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetMagneticFieldLaplacian(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetMagneticFieldLaplacian && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetMagneticFieldLaplacian(soap, "turb1:GetMagneticFieldLaplacian", &a->turb1__GetMagneticFieldLaplacian, ""))
				{	soap_flag_turb1__GetMagneticFieldLaplacian--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetMagneticFieldLaplacian(struct soap *soap, const struct __turb3__GetMagneticFieldLaplacian *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetMagneticFieldLaplacian(soap, tag?tag:"-turb3:GetMagneticFieldLaplacian", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetMagneticFieldLaplacian * SOAP_FMAC4 soap_get___turb3__GetMagneticFieldLaplacian(struct soap *soap, struct __turb3__GetMagneticFieldLaplacian *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetMagneticFieldLaplacian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetVelocityLaplacian(struct soap *soap, struct __turb3__GetVelocityLaplacian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetVelocityLaplacian = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetVelocityLaplacian(struct soap *soap, const struct __turb3__GetVelocityLaplacian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetVelocityLaplacian(soap, &a->turb1__GetVelocityLaplacian);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetVelocityLaplacian(struct soap *soap, const char *tag, int id, const struct __turb3__GetVelocityLaplacian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetVelocityLaplacian(soap, "turb1:GetVelocityLaplacian", -1, &a->turb1__GetVelocityLaplacian, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetVelocityLaplacian * SOAP_FMAC4 soap_in___turb3__GetVelocityLaplacian(struct soap *soap, const char *tag, struct __turb3__GetVelocityLaplacian *a, const char *type)
{
	size_t soap_flag_turb1__GetVelocityLaplacian = 1;
	short soap_flag;
	a = (struct __turb3__GetVelocityLaplacian *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetVelocityLaplacian, sizeof(struct __turb3__GetVelocityLaplacian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetVelocityLaplacian(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetVelocityLaplacian && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetVelocityLaplacian(soap, "turb1:GetVelocityLaplacian", &a->turb1__GetVelocityLaplacian, ""))
				{	soap_flag_turb1__GetVelocityLaplacian--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetVelocityLaplacian(struct soap *soap, const struct __turb3__GetVelocityLaplacian *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetVelocityLaplacian(soap, tag?tag:"-turb3:GetVelocityLaplacian", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetVelocityLaplacian * SOAP_FMAC4 soap_get___turb3__GetVelocityLaplacian(struct soap *soap, struct __turb3__GetVelocityLaplacian *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetVelocityLaplacian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetVectorPotentialHessian(struct soap *soap, struct __turb3__GetVectorPotentialHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetVectorPotentialHessian = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetVectorPotentialHessian(struct soap *soap, const struct __turb3__GetVectorPotentialHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetVectorPotentialHessian(soap, &a->turb1__GetVectorPotentialHessian);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetVectorPotentialHessian(struct soap *soap, const char *tag, int id, const struct __turb3__GetVectorPotentialHessian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetVectorPotentialHessian(soap, "turb1:GetVectorPotentialHessian", -1, &a->turb1__GetVectorPotentialHessian, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetVectorPotentialHessian * SOAP_FMAC4 soap_in___turb3__GetVectorPotentialHessian(struct soap *soap, const char *tag, struct __turb3__GetVectorPotentialHessian *a, const char *type)
{
	size_t soap_flag_turb1__GetVectorPotentialHessian = 1;
	short soap_flag;
	a = (struct __turb3__GetVectorPotentialHessian *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetVectorPotentialHessian, sizeof(struct __turb3__GetVectorPotentialHessian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetVectorPotentialHessian(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetVectorPotentialHessian && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetVectorPotentialHessian(soap, "turb1:GetVectorPotentialHessian", &a->turb1__GetVectorPotentialHessian, ""))
				{	soap_flag_turb1__GetVectorPotentialHessian--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetVectorPotentialHessian(struct soap *soap, const struct __turb3__GetVectorPotentialHessian *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetVectorPotentialHessian(soap, tag?tag:"-turb3:GetVectorPotentialHessian", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetVectorPotentialHessian * SOAP_FMAC4 soap_get___turb3__GetVectorPotentialHessian(struct soap *soap, struct __turb3__GetVectorPotentialHessian *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetVectorPotentialHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetMagneticHessian(struct soap *soap, struct __turb3__GetMagneticHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetMagneticHessian = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetMagneticHessian(struct soap *soap, const struct __turb3__GetMagneticHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetMagneticHessian(soap, &a->turb1__GetMagneticHessian);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetMagneticHessian(struct soap *soap, const char *tag, int id, const struct __turb3__GetMagneticHessian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetMagneticHessian(soap, "turb1:GetMagneticHessian", -1, &a->turb1__GetMagneticHessian, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetMagneticHessian * SOAP_FMAC4 soap_in___turb3__GetMagneticHessian(struct soap *soap, const char *tag, struct __turb3__GetMagneticHessian *a, const char *type)
{
	size_t soap_flag_turb1__GetMagneticHessian = 1;
	short soap_flag;
	a = (struct __turb3__GetMagneticHessian *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetMagneticHessian, sizeof(struct __turb3__GetMagneticHessian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetMagneticHessian(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetMagneticHessian && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetMagneticHessian(soap, "turb1:GetMagneticHessian", &a->turb1__GetMagneticHessian, ""))
				{	soap_flag_turb1__GetMagneticHessian--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetMagneticHessian(struct soap *soap, const struct __turb3__GetMagneticHessian *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetMagneticHessian(soap, tag?tag:"-turb3:GetMagneticHessian", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetMagneticHessian * SOAP_FMAC4 soap_get___turb3__GetMagneticHessian(struct soap *soap, struct __turb3__GetMagneticHessian *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetMagneticHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetVelocityHessian(struct soap *soap, struct __turb3__GetVelocityHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetVelocityHessian = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetVelocityHessian(struct soap *soap, const struct __turb3__GetVelocityHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetVelocityHessian(soap, &a->turb1__GetVelocityHessian);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetVelocityHessian(struct soap *soap, const char *tag, int id, const struct __turb3__GetVelocityHessian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetVelocityHessian(soap, "turb1:GetVelocityHessian", -1, &a->turb1__GetVelocityHessian, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetVelocityHessian * SOAP_FMAC4 soap_in___turb3__GetVelocityHessian(struct soap *soap, const char *tag, struct __turb3__GetVelocityHessian *a, const char *type)
{
	size_t soap_flag_turb1__GetVelocityHessian = 1;
	short soap_flag;
	a = (struct __turb3__GetVelocityHessian *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetVelocityHessian, sizeof(struct __turb3__GetVelocityHessian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetVelocityHessian(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetVelocityHessian && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetVelocityHessian(soap, "turb1:GetVelocityHessian", &a->turb1__GetVelocityHessian, ""))
				{	soap_flag_turb1__GetVelocityHessian--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetVelocityHessian(struct soap *soap, const struct __turb3__GetVelocityHessian *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetVelocityHessian(soap, tag?tag:"-turb3:GetVelocityHessian", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetVelocityHessian * SOAP_FMAC4 soap_get___turb3__GetVelocityHessian(struct soap *soap, struct __turb3__GetVelocityHessian *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetVelocityHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetPressureHessian(struct soap *soap, struct __turb3__GetPressureHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetPressureHessian = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetPressureHessian(struct soap *soap, const struct __turb3__GetPressureHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetPressureHessian(soap, &a->turb1__GetPressureHessian);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetPressureHessian(struct soap *soap, const char *tag, int id, const struct __turb3__GetPressureHessian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetPressureHessian(soap, "turb1:GetPressureHessian", -1, &a->turb1__GetPressureHessian, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetPressureHessian * SOAP_FMAC4 soap_in___turb3__GetPressureHessian(struct soap *soap, const char *tag, struct __turb3__GetPressureHessian *a, const char *type)
{
	size_t soap_flag_turb1__GetPressureHessian = 1;
	short soap_flag;
	a = (struct __turb3__GetPressureHessian *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetPressureHessian, sizeof(struct __turb3__GetPressureHessian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetPressureHessian(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetPressureHessian && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetPressureHessian(soap, "turb1:GetPressureHessian", &a->turb1__GetPressureHessian, ""))
				{	soap_flag_turb1__GetPressureHessian--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetPressureHessian(struct soap *soap, const struct __turb3__GetPressureHessian *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetPressureHessian(soap, tag?tag:"-turb3:GetPressureHessian", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetPressureHessian * SOAP_FMAC4 soap_get___turb3__GetPressureHessian(struct soap *soap, struct __turb3__GetPressureHessian *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetPressureHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetPressureGradient(struct soap *soap, struct __turb3__GetPressureGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetPressureGradient = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetPressureGradient(struct soap *soap, const struct __turb3__GetPressureGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetPressureGradient(soap, &a->turb1__GetPressureGradient);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetPressureGradient(struct soap *soap, const char *tag, int id, const struct __turb3__GetPressureGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetPressureGradient(soap, "turb1:GetPressureGradient", -1, &a->turb1__GetPressureGradient, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetPressureGradient * SOAP_FMAC4 soap_in___turb3__GetPressureGradient(struct soap *soap, const char *tag, struct __turb3__GetPressureGradient *a, const char *type)
{
	size_t soap_flag_turb1__GetPressureGradient = 1;
	short soap_flag;
	a = (struct __turb3__GetPressureGradient *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetPressureGradient, sizeof(struct __turb3__GetPressureGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetPressureGradient(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetPressureGradient && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetPressureGradient(soap, "turb1:GetPressureGradient", &a->turb1__GetPressureGradient, ""))
				{	soap_flag_turb1__GetPressureGradient--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetPressureGradient(struct soap *soap, const struct __turb3__GetPressureGradient *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetPressureGradient(soap, tag?tag:"-turb3:GetPressureGradient", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetPressureGradient * SOAP_FMAC4 soap_get___turb3__GetPressureGradient(struct soap *soap, struct __turb3__GetPressureGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetPressureGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetVectorPotentialGradient(struct soap *soap, struct __turb3__GetVectorPotentialGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetVectorPotentialGradient = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetVectorPotentialGradient(struct soap *soap, const struct __turb3__GetVectorPotentialGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetVectorPotentialGradient(soap, &a->turb1__GetVectorPotentialGradient);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetVectorPotentialGradient(struct soap *soap, const char *tag, int id, const struct __turb3__GetVectorPotentialGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetVectorPotentialGradient(soap, "turb1:GetVectorPotentialGradient", -1, &a->turb1__GetVectorPotentialGradient, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetVectorPotentialGradient * SOAP_FMAC4 soap_in___turb3__GetVectorPotentialGradient(struct soap *soap, const char *tag, struct __turb3__GetVectorPotentialGradient *a, const char *type)
{
	size_t soap_flag_turb1__GetVectorPotentialGradient = 1;
	short soap_flag;
	a = (struct __turb3__GetVectorPotentialGradient *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetVectorPotentialGradient, sizeof(struct __turb3__GetVectorPotentialGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetVectorPotentialGradient(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetVectorPotentialGradient && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetVectorPotentialGradient(soap, "turb1:GetVectorPotentialGradient", &a->turb1__GetVectorPotentialGradient, ""))
				{	soap_flag_turb1__GetVectorPotentialGradient--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetVectorPotentialGradient(struct soap *soap, const struct __turb3__GetVectorPotentialGradient *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetVectorPotentialGradient(soap, tag?tag:"-turb3:GetVectorPotentialGradient", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetVectorPotentialGradient * SOAP_FMAC4 soap_get___turb3__GetVectorPotentialGradient(struct soap *soap, struct __turb3__GetVectorPotentialGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetVectorPotentialGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetMagneticFieldGradient(struct soap *soap, struct __turb3__GetMagneticFieldGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetMagneticFieldGradient = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetMagneticFieldGradient(struct soap *soap, const struct __turb3__GetMagneticFieldGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetMagneticFieldGradient(soap, &a->turb1__GetMagneticFieldGradient);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetMagneticFieldGradient(struct soap *soap, const char *tag, int id, const struct __turb3__GetMagneticFieldGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetMagneticFieldGradient(soap, "turb1:GetMagneticFieldGradient", -1, &a->turb1__GetMagneticFieldGradient, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetMagneticFieldGradient * SOAP_FMAC4 soap_in___turb3__GetMagneticFieldGradient(struct soap *soap, const char *tag, struct __turb3__GetMagneticFieldGradient *a, const char *type)
{
	size_t soap_flag_turb1__GetMagneticFieldGradient = 1;
	short soap_flag;
	a = (struct __turb3__GetMagneticFieldGradient *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetMagneticFieldGradient, sizeof(struct __turb3__GetMagneticFieldGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetMagneticFieldGradient(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetMagneticFieldGradient && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetMagneticFieldGradient(soap, "turb1:GetMagneticFieldGradient", &a->turb1__GetMagneticFieldGradient, ""))
				{	soap_flag_turb1__GetMagneticFieldGradient--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetMagneticFieldGradient(struct soap *soap, const struct __turb3__GetMagneticFieldGradient *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetMagneticFieldGradient(soap, tag?tag:"-turb3:GetMagneticFieldGradient", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetMagneticFieldGradient * SOAP_FMAC4 soap_get___turb3__GetMagneticFieldGradient(struct soap *soap, struct __turb3__GetMagneticFieldGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetMagneticFieldGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetVelocityGradient(struct soap *soap, struct __turb3__GetVelocityGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetVelocityGradient = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetVelocityGradient(struct soap *soap, const struct __turb3__GetVelocityGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetVelocityGradient(soap, &a->turb1__GetVelocityGradient);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetVelocityGradient(struct soap *soap, const char *tag, int id, const struct __turb3__GetVelocityGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetVelocityGradient(soap, "turb1:GetVelocityGradient", -1, &a->turb1__GetVelocityGradient, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetVelocityGradient * SOAP_FMAC4 soap_in___turb3__GetVelocityGradient(struct soap *soap, const char *tag, struct __turb3__GetVelocityGradient *a, const char *type)
{
	size_t soap_flag_turb1__GetVelocityGradient = 1;
	short soap_flag;
	a = (struct __turb3__GetVelocityGradient *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetVelocityGradient, sizeof(struct __turb3__GetVelocityGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetVelocityGradient(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetVelocityGradient && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetVelocityGradient(soap, "turb1:GetVelocityGradient", &a->turb1__GetVelocityGradient, ""))
				{	soap_flag_turb1__GetVelocityGradient--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetVelocityGradient(struct soap *soap, const struct __turb3__GetVelocityGradient *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetVelocityGradient(soap, tag?tag:"-turb3:GetVelocityGradient", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetVelocityGradient * SOAP_FMAC4 soap_get___turb3__GetVelocityGradient(struct soap *soap, struct __turb3__GetVelocityGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetVelocityGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetVelocityAndPressure(struct soap *soap, struct __turb3__GetVelocityAndPressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetVelocityAndPressure = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetVelocityAndPressure(struct soap *soap, const struct __turb3__GetVelocityAndPressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetVelocityAndPressure(soap, &a->turb1__GetVelocityAndPressure);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetVelocityAndPressure(struct soap *soap, const char *tag, int id, const struct __turb3__GetVelocityAndPressure *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetVelocityAndPressure(soap, "turb1:GetVelocityAndPressure", -1, &a->turb1__GetVelocityAndPressure, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetVelocityAndPressure * SOAP_FMAC4 soap_in___turb3__GetVelocityAndPressure(struct soap *soap, const char *tag, struct __turb3__GetVelocityAndPressure *a, const char *type)
{
	size_t soap_flag_turb1__GetVelocityAndPressure = 1;
	short soap_flag;
	a = (struct __turb3__GetVelocityAndPressure *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetVelocityAndPressure, sizeof(struct __turb3__GetVelocityAndPressure), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetVelocityAndPressure(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetVelocityAndPressure && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetVelocityAndPressure(soap, "turb1:GetVelocityAndPressure", &a->turb1__GetVelocityAndPressure, ""))
				{	soap_flag_turb1__GetVelocityAndPressure--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetVelocityAndPressure(struct soap *soap, const struct __turb3__GetVelocityAndPressure *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetVelocityAndPressure(soap, tag?tag:"-turb3:GetVelocityAndPressure", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetVelocityAndPressure * SOAP_FMAC4 soap_get___turb3__GetVelocityAndPressure(struct soap *soap, struct __turb3__GetVelocityAndPressure *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetVelocityAndPressure(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetForce(struct soap *soap, struct __turb3__GetForce *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetForce = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetForce(struct soap *soap, const struct __turb3__GetForce *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetForce(soap, &a->turb1__GetForce);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetForce(struct soap *soap, const char *tag, int id, const struct __turb3__GetForce *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetForce(soap, "turb1:GetForce", -1, &a->turb1__GetForce, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetForce * SOAP_FMAC4 soap_in___turb3__GetForce(struct soap *soap, const char *tag, struct __turb3__GetForce *a, const char *type)
{
	size_t soap_flag_turb1__GetForce = 1;
	short soap_flag;
	a = (struct __turb3__GetForce *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetForce, sizeof(struct __turb3__GetForce), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetForce(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetForce && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetForce(soap, "turb1:GetForce", &a->turb1__GetForce, ""))
				{	soap_flag_turb1__GetForce--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetForce(struct soap *soap, const struct __turb3__GetForce *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetForce(soap, tag?tag:"-turb3:GetForce", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetForce * SOAP_FMAC4 soap_get___turb3__GetForce(struct soap *soap, struct __turb3__GetForce *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetForce(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetRawDensity(struct soap *soap, struct __turb3__GetRawDensity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetRawDensity = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetRawDensity(struct soap *soap, const struct __turb3__GetRawDensity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetRawDensity(soap, &a->turb1__GetRawDensity);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetRawDensity(struct soap *soap, const char *tag, int id, const struct __turb3__GetRawDensity *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetRawDensity(soap, "turb1:GetRawDensity", -1, &a->turb1__GetRawDensity, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetRawDensity * SOAP_FMAC4 soap_in___turb3__GetRawDensity(struct soap *soap, const char *tag, struct __turb3__GetRawDensity *a, const char *type)
{
	size_t soap_flag_turb1__GetRawDensity = 1;
	short soap_flag;
	a = (struct __turb3__GetRawDensity *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetRawDensity, sizeof(struct __turb3__GetRawDensity), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetRawDensity(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetRawDensity && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetRawDensity(soap, "turb1:GetRawDensity", &a->turb1__GetRawDensity, ""))
				{	soap_flag_turb1__GetRawDensity--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetRawDensity(struct soap *soap, const struct __turb3__GetRawDensity *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetRawDensity(soap, tag?tag:"-turb3:GetRawDensity", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetRawDensity * SOAP_FMAC4 soap_get___turb3__GetRawDensity(struct soap *soap, struct __turb3__GetRawDensity *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetRawDensity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetDensityHessian(struct soap *soap, struct __turb3__GetDensityHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetDensityHessian = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetDensityHessian(struct soap *soap, const struct __turb3__GetDensityHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetDensityHessian(soap, &a->turb1__GetDensityHessian);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetDensityHessian(struct soap *soap, const char *tag, int id, const struct __turb3__GetDensityHessian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetDensityHessian(soap, "turb1:GetDensityHessian", -1, &a->turb1__GetDensityHessian, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetDensityHessian * SOAP_FMAC4 soap_in___turb3__GetDensityHessian(struct soap *soap, const char *tag, struct __turb3__GetDensityHessian *a, const char *type)
{
	size_t soap_flag_turb1__GetDensityHessian = 1;
	short soap_flag;
	a = (struct __turb3__GetDensityHessian *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetDensityHessian, sizeof(struct __turb3__GetDensityHessian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetDensityHessian(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetDensityHessian && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetDensityHessian(soap, "turb1:GetDensityHessian", &a->turb1__GetDensityHessian, ""))
				{	soap_flag_turb1__GetDensityHessian--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetDensityHessian(struct soap *soap, const struct __turb3__GetDensityHessian *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetDensityHessian(soap, tag?tag:"-turb3:GetDensityHessian", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetDensityHessian * SOAP_FMAC4 soap_get___turb3__GetDensityHessian(struct soap *soap, struct __turb3__GetDensityHessian *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetDensityHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetDensityGradient(struct soap *soap, struct __turb3__GetDensityGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetDensityGradient = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetDensityGradient(struct soap *soap, const struct __turb3__GetDensityGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetDensityGradient(soap, &a->turb1__GetDensityGradient);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetDensityGradient(struct soap *soap, const char *tag, int id, const struct __turb3__GetDensityGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetDensityGradient(soap, "turb1:GetDensityGradient", -1, &a->turb1__GetDensityGradient, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetDensityGradient * SOAP_FMAC4 soap_in___turb3__GetDensityGradient(struct soap *soap, const char *tag, struct __turb3__GetDensityGradient *a, const char *type)
{
	size_t soap_flag_turb1__GetDensityGradient = 1;
	short soap_flag;
	a = (struct __turb3__GetDensityGradient *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetDensityGradient, sizeof(struct __turb3__GetDensityGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetDensityGradient(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetDensityGradient && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetDensityGradient(soap, "turb1:GetDensityGradient", &a->turb1__GetDensityGradient, ""))
				{	soap_flag_turb1__GetDensityGradient--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetDensityGradient(struct soap *soap, const struct __turb3__GetDensityGradient *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetDensityGradient(soap, tag?tag:"-turb3:GetDensityGradient", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetDensityGradient * SOAP_FMAC4 soap_get___turb3__GetDensityGradient(struct soap *soap, struct __turb3__GetDensityGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetDensityGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetDensity(struct soap *soap, struct __turb3__GetDensity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetDensity = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetDensity(struct soap *soap, const struct __turb3__GetDensity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetDensity(soap, &a->turb1__GetDensity);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetDensity(struct soap *soap, const char *tag, int id, const struct __turb3__GetDensity *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetDensity(soap, "turb1:GetDensity", -1, &a->turb1__GetDensity, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetDensity * SOAP_FMAC4 soap_in___turb3__GetDensity(struct soap *soap, const char *tag, struct __turb3__GetDensity *a, const char *type)
{
	size_t soap_flag_turb1__GetDensity = 1;
	short soap_flag;
	a = (struct __turb3__GetDensity *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetDensity, sizeof(struct __turb3__GetDensity), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetDensity(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetDensity && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetDensity(soap, "turb1:GetDensity", &a->turb1__GetDensity, ""))
				{	soap_flag_turb1__GetDensity--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetDensity(struct soap *soap, const struct __turb3__GetDensity *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetDensity(soap, tag?tag:"-turb3:GetDensity", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetDensity * SOAP_FMAC4 soap_get___turb3__GetDensity(struct soap *soap, struct __turb3__GetDensity *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetDensity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetRawVectorPotential(struct soap *soap, struct __turb3__GetRawVectorPotential *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetRawVectorPotential = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetRawVectorPotential(struct soap *soap, const struct __turb3__GetRawVectorPotential *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetRawVectorPotential(soap, &a->turb1__GetRawVectorPotential);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetRawVectorPotential(struct soap *soap, const char *tag, int id, const struct __turb3__GetRawVectorPotential *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetRawVectorPotential(soap, "turb1:GetRawVectorPotential", -1, &a->turb1__GetRawVectorPotential, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetRawVectorPotential * SOAP_FMAC4 soap_in___turb3__GetRawVectorPotential(struct soap *soap, const char *tag, struct __turb3__GetRawVectorPotential *a, const char *type)
{
	size_t soap_flag_turb1__GetRawVectorPotential = 1;
	short soap_flag;
	a = (struct __turb3__GetRawVectorPotential *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetRawVectorPotential, sizeof(struct __turb3__GetRawVectorPotential), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetRawVectorPotential(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetRawVectorPotential && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetRawVectorPotential(soap, "turb1:GetRawVectorPotential", &a->turb1__GetRawVectorPotential, ""))
				{	soap_flag_turb1__GetRawVectorPotential--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetRawVectorPotential(struct soap *soap, const struct __turb3__GetRawVectorPotential *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetRawVectorPotential(soap, tag?tag:"-turb3:GetRawVectorPotential", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetRawVectorPotential * SOAP_FMAC4 soap_get___turb3__GetRawVectorPotential(struct soap *soap, struct __turb3__GetRawVectorPotential *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetRawVectorPotential(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetVectorPotential(struct soap *soap, struct __turb3__GetVectorPotential *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetVectorPotential = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetVectorPotential(struct soap *soap, const struct __turb3__GetVectorPotential *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetVectorPotential(soap, &a->turb1__GetVectorPotential);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetVectorPotential(struct soap *soap, const char *tag, int id, const struct __turb3__GetVectorPotential *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetVectorPotential(soap, "turb1:GetVectorPotential", -1, &a->turb1__GetVectorPotential, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetVectorPotential * SOAP_FMAC4 soap_in___turb3__GetVectorPotential(struct soap *soap, const char *tag, struct __turb3__GetVectorPotential *a, const char *type)
{
	size_t soap_flag_turb1__GetVectorPotential = 1;
	short soap_flag;
	a = (struct __turb3__GetVectorPotential *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetVectorPotential, sizeof(struct __turb3__GetVectorPotential), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetVectorPotential(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetVectorPotential && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetVectorPotential(soap, "turb1:GetVectorPotential", &a->turb1__GetVectorPotential, ""))
				{	soap_flag_turb1__GetVectorPotential--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetVectorPotential(struct soap *soap, const struct __turb3__GetVectorPotential *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetVectorPotential(soap, tag?tag:"-turb3:GetVectorPotential", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetVectorPotential * SOAP_FMAC4 soap_get___turb3__GetVectorPotential(struct soap *soap, struct __turb3__GetVectorPotential *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetVectorPotential(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetRawMagneticField(struct soap *soap, struct __turb3__GetRawMagneticField *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetRawMagneticField = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetRawMagneticField(struct soap *soap, const struct __turb3__GetRawMagneticField *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetRawMagneticField(soap, &a->turb1__GetRawMagneticField);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetRawMagneticField(struct soap *soap, const char *tag, int id, const struct __turb3__GetRawMagneticField *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetRawMagneticField(soap, "turb1:GetRawMagneticField", -1, &a->turb1__GetRawMagneticField, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetRawMagneticField * SOAP_FMAC4 soap_in___turb3__GetRawMagneticField(struct soap *soap, const char *tag, struct __turb3__GetRawMagneticField *a, const char *type)
{
	size_t soap_flag_turb1__GetRawMagneticField = 1;
	short soap_flag;
	a = (struct __turb3__GetRawMagneticField *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetRawMagneticField, sizeof(struct __turb3__GetRawMagneticField), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetRawMagneticField(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetRawMagneticField && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetRawMagneticField(soap, "turb1:GetRawMagneticField", &a->turb1__GetRawMagneticField, ""))
				{	soap_flag_turb1__GetRawMagneticField--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetRawMagneticField(struct soap *soap, const struct __turb3__GetRawMagneticField *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetRawMagneticField(soap, tag?tag:"-turb3:GetRawMagneticField", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetRawMagneticField * SOAP_FMAC4 soap_get___turb3__GetRawMagneticField(struct soap *soap, struct __turb3__GetRawMagneticField *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetRawMagneticField(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetMagneticField(struct soap *soap, struct __turb3__GetMagneticField *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetMagneticField = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetMagneticField(struct soap *soap, const struct __turb3__GetMagneticField *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetMagneticField(soap, &a->turb1__GetMagneticField);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetMagneticField(struct soap *soap, const char *tag, int id, const struct __turb3__GetMagneticField *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetMagneticField(soap, "turb1:GetMagneticField", -1, &a->turb1__GetMagneticField, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetMagneticField * SOAP_FMAC4 soap_in___turb3__GetMagneticField(struct soap *soap, const char *tag, struct __turb3__GetMagneticField *a, const char *type)
{
	size_t soap_flag_turb1__GetMagneticField = 1;
	short soap_flag;
	a = (struct __turb3__GetMagneticField *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetMagneticField, sizeof(struct __turb3__GetMagneticField), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetMagneticField(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetMagneticField && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetMagneticField(soap, "turb1:GetMagneticField", &a->turb1__GetMagneticField, ""))
				{	soap_flag_turb1__GetMagneticField--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetMagneticField(struct soap *soap, const struct __turb3__GetMagneticField *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetMagneticField(soap, tag?tag:"-turb3:GetMagneticField", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetMagneticField * SOAP_FMAC4 soap_get___turb3__GetMagneticField(struct soap *soap, struct __turb3__GetMagneticField *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetMagneticField(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetRawPressure(struct soap *soap, struct __turb3__GetRawPressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetRawPressure = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetRawPressure(struct soap *soap, const struct __turb3__GetRawPressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetRawPressure(soap, &a->turb1__GetRawPressure);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetRawPressure(struct soap *soap, const char *tag, int id, const struct __turb3__GetRawPressure *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetRawPressure(soap, "turb1:GetRawPressure", -1, &a->turb1__GetRawPressure, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetRawPressure * SOAP_FMAC4 soap_in___turb3__GetRawPressure(struct soap *soap, const char *tag, struct __turb3__GetRawPressure *a, const char *type)
{
	size_t soap_flag_turb1__GetRawPressure = 1;
	short soap_flag;
	a = (struct __turb3__GetRawPressure *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetRawPressure, sizeof(struct __turb3__GetRawPressure), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetRawPressure(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetRawPressure && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetRawPressure(soap, "turb1:GetRawPressure", &a->turb1__GetRawPressure, ""))
				{	soap_flag_turb1__GetRawPressure--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetRawPressure(struct soap *soap, const struct __turb3__GetRawPressure *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetRawPressure(soap, tag?tag:"-turb3:GetRawPressure", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetRawPressure * SOAP_FMAC4 soap_get___turb3__GetRawPressure(struct soap *soap, struct __turb3__GetRawPressure *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetRawPressure(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetPressure(struct soap *soap, struct __turb3__GetPressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetPressure = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetPressure(struct soap *soap, const struct __turb3__GetPressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetPressure(soap, &a->turb1__GetPressure);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetPressure(struct soap *soap, const char *tag, int id, const struct __turb3__GetPressure *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetPressure(soap, "turb1:GetPressure", -1, &a->turb1__GetPressure, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetPressure * SOAP_FMAC4 soap_in___turb3__GetPressure(struct soap *soap, const char *tag, struct __turb3__GetPressure *a, const char *type)
{
	size_t soap_flag_turb1__GetPressure = 1;
	short soap_flag;
	a = (struct __turb3__GetPressure *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetPressure, sizeof(struct __turb3__GetPressure), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetPressure(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetPressure && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetPressure(soap, "turb1:GetPressure", &a->turb1__GetPressure, ""))
				{	soap_flag_turb1__GetPressure--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetPressure(struct soap *soap, const struct __turb3__GetPressure *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetPressure(soap, tag?tag:"-turb3:GetPressure", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetPressure * SOAP_FMAC4 soap_get___turb3__GetPressure(struct soap *soap, struct __turb3__GetPressure *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetPressure(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetRawVelocity(struct soap *soap, struct __turb3__GetRawVelocity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetRawVelocity = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetRawVelocity(struct soap *soap, const struct __turb3__GetRawVelocity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetRawVelocity(soap, &a->turb1__GetRawVelocity);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetRawVelocity(struct soap *soap, const char *tag, int id, const struct __turb3__GetRawVelocity *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetRawVelocity(soap, "turb1:GetRawVelocity", -1, &a->turb1__GetRawVelocity, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetRawVelocity * SOAP_FMAC4 soap_in___turb3__GetRawVelocity(struct soap *soap, const char *tag, struct __turb3__GetRawVelocity *a, const char *type)
{
	size_t soap_flag_turb1__GetRawVelocity = 1;
	short soap_flag;
	a = (struct __turb3__GetRawVelocity *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetRawVelocity, sizeof(struct __turb3__GetRawVelocity), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetRawVelocity(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetRawVelocity && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetRawVelocity(soap, "turb1:GetRawVelocity", &a->turb1__GetRawVelocity, ""))
				{	soap_flag_turb1__GetRawVelocity--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetRawVelocity(struct soap *soap, const struct __turb3__GetRawVelocity *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetRawVelocity(soap, tag?tag:"-turb3:GetRawVelocity", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetRawVelocity * SOAP_FMAC4 soap_get___turb3__GetRawVelocity(struct soap *soap, struct __turb3__GetRawVelocity *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetRawVelocity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetVelocityBatch(struct soap *soap, struct __turb3__GetVelocityBatch *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetVelocityBatch = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetVelocityBatch(struct soap *soap, const struct __turb3__GetVelocityBatch *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetVelocityBatch(soap, &a->turb1__GetVelocityBatch);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetVelocityBatch(struct soap *soap, const char *tag, int id, const struct __turb3__GetVelocityBatch *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetVelocityBatch(soap, "turb1:GetVelocityBatch", -1, &a->turb1__GetVelocityBatch, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetVelocityBatch * SOAP_FMAC4 soap_in___turb3__GetVelocityBatch(struct soap *soap, const char *tag, struct __turb3__GetVelocityBatch *a, const char *type)
{
	size_t soap_flag_turb1__GetVelocityBatch = 1;
	short soap_flag;
	a = (struct __turb3__GetVelocityBatch *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetVelocityBatch, sizeof(struct __turb3__GetVelocityBatch), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetVelocityBatch(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetVelocityBatch && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetVelocityBatch(soap, "turb1:GetVelocityBatch", &a->turb1__GetVelocityBatch, ""))
				{	soap_flag_turb1__GetVelocityBatch--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetVelocityBatch(struct soap *soap, const struct __turb3__GetVelocityBatch *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetVelocityBatch(soap, tag?tag:"-turb3:GetVelocityBatch", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetVelocityBatch * SOAP_FMAC4 soap_get___turb3__GetVelocityBatch(struct soap *soap, struct __turb3__GetVelocityBatch *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetVelocityBatch(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__GetVelocity(struct soap *soap, struct __turb3__GetVelocity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetVelocity = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__GetVelocity(struct soap *soap, const struct __turb3__GetVelocity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetVelocity(soap, &a->turb1__GetVelocity);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__GetVelocity(struct soap *soap, const char *tag, int id, const struct __turb3__GetVelocity *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetVelocity(soap, "turb1:GetVelocity", -1, &a->turb1__GetVelocity, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetVelocity * SOAP_FMAC4 soap_in___turb3__GetVelocity(struct soap *soap, const char *tag, struct __turb3__GetVelocity *a, const char *type)
{
	size_t soap_flag_turb1__GetVelocity = 1;
	short soap_flag;
	a = (struct __turb3__GetVelocity *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__GetVelocity, sizeof(struct __turb3__GetVelocity), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__GetVelocity(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetVelocity && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetVelocity(soap, "turb1:GetVelocity", &a->turb1__GetVelocity, ""))
				{	soap_flag_turb1__GetVelocity--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__GetVelocity(struct soap *soap, const struct __turb3__GetVelocity *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__GetVelocity(soap, tag?tag:"-turb3:GetVelocity", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__GetVelocity * SOAP_FMAC4 soap_get___turb3__GetVelocity(struct soap *soap, struct __turb3__GetVelocity *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__GetVelocity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb3__NullOp(struct soap *soap, struct __turb3__NullOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__NullOp = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb3__NullOp(struct soap *soap, const struct __turb3__NullOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__NullOp(soap, &a->turb1__NullOp);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb3__NullOp(struct soap *soap, const char *tag, int id, const struct __turb3__NullOp *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__NullOp(soap, "turb1:NullOp", -1, &a->turb1__NullOp, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__NullOp * SOAP_FMAC4 soap_in___turb3__NullOp(struct soap *soap, const char *tag, struct __turb3__NullOp *a, const char *type)
{
	size_t soap_flag_turb1__NullOp = 1;
	short soap_flag;
	a = (struct __turb3__NullOp *)soap_id_enter(soap, "", a, SOAP_TYPE___turb3__NullOp, sizeof(struct __turb3__NullOp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb3__NullOp(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__NullOp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__NullOp(soap, "turb1:NullOp", &a->turb1__NullOp, ""))
				{	soap_flag_turb1__NullOp--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb3__NullOp(struct soap *soap, const struct __turb3__NullOp *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb3__NullOp(soap, tag?tag:"-turb3:NullOp", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb3__NullOp * SOAP_FMAC4 soap_get___turb3__NullOp(struct soap *soap, struct __turb3__NullOp *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb3__NullOp(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetLaplacianOfGradient(struct soap *soap, struct __turb2__GetLaplacianOfGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetLaplacianOfGradient = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetLaplacianOfGradient(struct soap *soap, const struct __turb2__GetLaplacianOfGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetLaplacianOfGradient(soap, &a->turb1__GetLaplacianOfGradient);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetLaplacianOfGradient(struct soap *soap, const char *tag, int id, const struct __turb2__GetLaplacianOfGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetLaplacianOfGradient(soap, "turb1:GetLaplacianOfGradient", -1, &a->turb1__GetLaplacianOfGradient, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetLaplacianOfGradient * SOAP_FMAC4 soap_in___turb2__GetLaplacianOfGradient(struct soap *soap, const char *tag, struct __turb2__GetLaplacianOfGradient *a, const char *type)
{
	size_t soap_flag_turb1__GetLaplacianOfGradient = 1;
	short soap_flag;
	a = (struct __turb2__GetLaplacianOfGradient *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetLaplacianOfGradient, sizeof(struct __turb2__GetLaplacianOfGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetLaplacianOfGradient(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetLaplacianOfGradient && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetLaplacianOfGradient(soap, "turb1:GetLaplacianOfGradient", &a->turb1__GetLaplacianOfGradient, ""))
				{	soap_flag_turb1__GetLaplacianOfGradient--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetLaplacianOfGradient(struct soap *soap, const struct __turb2__GetLaplacianOfGradient *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetLaplacianOfGradient(soap, tag?tag:"-turb2:GetLaplacianOfGradient", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetLaplacianOfGradient * SOAP_FMAC4 soap_get___turb2__GetLaplacianOfGradient(struct soap *soap, struct __turb2__GetLaplacianOfGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetLaplacianOfGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetThreshold(struct soap *soap, struct __turb2__GetThreshold *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetThreshold = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetThreshold(struct soap *soap, const struct __turb2__GetThreshold *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetThreshold(soap, &a->turb1__GetThreshold);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetThreshold(struct soap *soap, const char *tag, int id, const struct __turb2__GetThreshold *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetThreshold(soap, "turb1:GetThreshold", -1, &a->turb1__GetThreshold, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetThreshold * SOAP_FMAC4 soap_in___turb2__GetThreshold(struct soap *soap, const char *tag, struct __turb2__GetThreshold *a, const char *type)
{
	size_t soap_flag_turb1__GetThreshold = 1;
	short soap_flag;
	a = (struct __turb2__GetThreshold *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetThreshold, sizeof(struct __turb2__GetThreshold), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetThreshold(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetThreshold && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetThreshold(soap, "turb1:GetThreshold", &a->turb1__GetThreshold, ""))
				{	soap_flag_turb1__GetThreshold--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetThreshold(struct soap *soap, const struct __turb2__GetThreshold *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetThreshold(soap, tag?tag:"-turb2:GetThreshold", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetThreshold * SOAP_FMAC4 soap_get___turb2__GetThreshold(struct soap *soap, struct __turb2__GetThreshold *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetThreshold(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetBoxFilterGradient(struct soap *soap, struct __turb2__GetBoxFilterGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetBoxFilterGradient = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetBoxFilterGradient(struct soap *soap, const struct __turb2__GetBoxFilterGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetBoxFilterGradient(soap, &a->turb1__GetBoxFilterGradient);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetBoxFilterGradient(struct soap *soap, const char *tag, int id, const struct __turb2__GetBoxFilterGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetBoxFilterGradient(soap, "turb1:GetBoxFilterGradient", -1, &a->turb1__GetBoxFilterGradient, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetBoxFilterGradient * SOAP_FMAC4 soap_in___turb2__GetBoxFilterGradient(struct soap *soap, const char *tag, struct __turb2__GetBoxFilterGradient *a, const char *type)
{
	size_t soap_flag_turb1__GetBoxFilterGradient = 1;
	short soap_flag;
	a = (struct __turb2__GetBoxFilterGradient *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetBoxFilterGradient, sizeof(struct __turb2__GetBoxFilterGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetBoxFilterGradient(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetBoxFilterGradient && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetBoxFilterGradient(soap, "turb1:GetBoxFilterGradient", &a->turb1__GetBoxFilterGradient, ""))
				{	soap_flag_turb1__GetBoxFilterGradient--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetBoxFilterGradient(struct soap *soap, const struct __turb2__GetBoxFilterGradient *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetBoxFilterGradient(soap, tag?tag:"-turb2:GetBoxFilterGradient", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetBoxFilterGradient * SOAP_FMAC4 soap_get___turb2__GetBoxFilterGradient(struct soap *soap, struct __turb2__GetBoxFilterGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetBoxFilterGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetBoxFilterSGS(struct soap *soap, struct __turb2__GetBoxFilterSGS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetBoxFilterSGS = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetBoxFilterSGS(struct soap *soap, const struct __turb2__GetBoxFilterSGS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetBoxFilterSGS(soap, &a->turb1__GetBoxFilterSGS);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetBoxFilterSGS(struct soap *soap, const char *tag, int id, const struct __turb2__GetBoxFilterSGS *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetBoxFilterSGS(soap, "turb1:GetBoxFilterSGS", -1, &a->turb1__GetBoxFilterSGS, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetBoxFilterSGS * SOAP_FMAC4 soap_in___turb2__GetBoxFilterSGS(struct soap *soap, const char *tag, struct __turb2__GetBoxFilterSGS *a, const char *type)
{
	size_t soap_flag_turb1__GetBoxFilterSGS = 1;
	short soap_flag;
	a = (struct __turb2__GetBoxFilterSGS *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetBoxFilterSGS, sizeof(struct __turb2__GetBoxFilterSGS), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetBoxFilterSGS(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetBoxFilterSGS && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetBoxFilterSGS(soap, "turb1:GetBoxFilterSGS", &a->turb1__GetBoxFilterSGS, ""))
				{	soap_flag_turb1__GetBoxFilterSGS--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetBoxFilterSGS(struct soap *soap, const struct __turb2__GetBoxFilterSGS *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetBoxFilterSGS(soap, tag?tag:"-turb2:GetBoxFilterSGS", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetBoxFilterSGS * SOAP_FMAC4 soap_get___turb2__GetBoxFilterSGS(struct soap *soap, struct __turb2__GetBoxFilterSGS *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetBoxFilterSGS(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetBoxFilter(struct soap *soap, struct __turb2__GetBoxFilter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetBoxFilter = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetBoxFilter(struct soap *soap, const struct __turb2__GetBoxFilter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetBoxFilter(soap, &a->turb1__GetBoxFilter);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetBoxFilter(struct soap *soap, const char *tag, int id, const struct __turb2__GetBoxFilter *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetBoxFilter(soap, "turb1:GetBoxFilter", -1, &a->turb1__GetBoxFilter, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetBoxFilter * SOAP_FMAC4 soap_in___turb2__GetBoxFilter(struct soap *soap, const char *tag, struct __turb2__GetBoxFilter *a, const char *type)
{
	size_t soap_flag_turb1__GetBoxFilter = 1;
	short soap_flag;
	a = (struct __turb2__GetBoxFilter *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetBoxFilter, sizeof(struct __turb2__GetBoxFilter), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetBoxFilter(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetBoxFilter && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetBoxFilter(soap, "turb1:GetBoxFilter", &a->turb1__GetBoxFilter, ""))
				{	soap_flag_turb1__GetBoxFilter--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetBoxFilter(struct soap *soap, const struct __turb2__GetBoxFilter *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetBoxFilter(soap, tag?tag:"-turb2:GetBoxFilter", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetBoxFilter * SOAP_FMAC4 soap_get___turb2__GetBoxFilter(struct soap *soap, struct __turb2__GetBoxFilter *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetBoxFilter(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetPosition(struct soap *soap, struct __turb2__GetPosition *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetPosition = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetPosition(struct soap *soap, const struct __turb2__GetPosition *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetPosition(soap, &a->turb1__GetPosition);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetPosition(struct soap *soap, const char *tag, int id, const struct __turb2__GetPosition *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetPosition(soap, "turb1:GetPosition", -1, &a->turb1__GetPosition, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetPosition * SOAP_FMAC4 soap_in___turb2__GetPosition(struct soap *soap, const char *tag, struct __turb2__GetPosition *a, const char *type)
{
	size_t soap_flag_turb1__GetPosition = 1;
	short soap_flag;
	a = (struct __turb2__GetPosition *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetPosition, sizeof(struct __turb2__GetPosition), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetPosition(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetPosition && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetPosition(soap, "turb1:GetPosition", &a->turb1__GetPosition, ""))
				{	soap_flag_turb1__GetPosition--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetPosition(struct soap *soap, const struct __turb2__GetPosition *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetPosition(soap, tag?tag:"-turb2:GetPosition", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetPosition * SOAP_FMAC4 soap_get___turb2__GetPosition(struct soap *soap, struct __turb2__GetPosition *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetPosition(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetVectorPotentialLaplacian(struct soap *soap, struct __turb2__GetVectorPotentialLaplacian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetVectorPotentialLaplacian = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetVectorPotentialLaplacian(struct soap *soap, const struct __turb2__GetVectorPotentialLaplacian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetVectorPotentialLaplacian(soap, &a->turb1__GetVectorPotentialLaplacian);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetVectorPotentialLaplacian(struct soap *soap, const char *tag, int id, const struct __turb2__GetVectorPotentialLaplacian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetVectorPotentialLaplacian(soap, "turb1:GetVectorPotentialLaplacian", -1, &a->turb1__GetVectorPotentialLaplacian, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetVectorPotentialLaplacian * SOAP_FMAC4 soap_in___turb2__GetVectorPotentialLaplacian(struct soap *soap, const char *tag, struct __turb2__GetVectorPotentialLaplacian *a, const char *type)
{
	size_t soap_flag_turb1__GetVectorPotentialLaplacian = 1;
	short soap_flag;
	a = (struct __turb2__GetVectorPotentialLaplacian *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetVectorPotentialLaplacian, sizeof(struct __turb2__GetVectorPotentialLaplacian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetVectorPotentialLaplacian(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetVectorPotentialLaplacian && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetVectorPotentialLaplacian(soap, "turb1:GetVectorPotentialLaplacian", &a->turb1__GetVectorPotentialLaplacian, ""))
				{	soap_flag_turb1__GetVectorPotentialLaplacian--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetVectorPotentialLaplacian(struct soap *soap, const struct __turb2__GetVectorPotentialLaplacian *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetVectorPotentialLaplacian(soap, tag?tag:"-turb2:GetVectorPotentialLaplacian", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetVectorPotentialLaplacian * SOAP_FMAC4 soap_get___turb2__GetVectorPotentialLaplacian(struct soap *soap, struct __turb2__GetVectorPotentialLaplacian *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetVectorPotentialLaplacian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetMagneticFieldLaplacian(struct soap *soap, struct __turb2__GetMagneticFieldLaplacian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetMagneticFieldLaplacian = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetMagneticFieldLaplacian(struct soap *soap, const struct __turb2__GetMagneticFieldLaplacian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetMagneticFieldLaplacian(soap, &a->turb1__GetMagneticFieldLaplacian);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetMagneticFieldLaplacian(struct soap *soap, const char *tag, int id, const struct __turb2__GetMagneticFieldLaplacian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetMagneticFieldLaplacian(soap, "turb1:GetMagneticFieldLaplacian", -1, &a->turb1__GetMagneticFieldLaplacian, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetMagneticFieldLaplacian * SOAP_FMAC4 soap_in___turb2__GetMagneticFieldLaplacian(struct soap *soap, const char *tag, struct __turb2__GetMagneticFieldLaplacian *a, const char *type)
{
	size_t soap_flag_turb1__GetMagneticFieldLaplacian = 1;
	short soap_flag;
	a = (struct __turb2__GetMagneticFieldLaplacian *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetMagneticFieldLaplacian, sizeof(struct __turb2__GetMagneticFieldLaplacian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetMagneticFieldLaplacian(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetMagneticFieldLaplacian && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetMagneticFieldLaplacian(soap, "turb1:GetMagneticFieldLaplacian", &a->turb1__GetMagneticFieldLaplacian, ""))
				{	soap_flag_turb1__GetMagneticFieldLaplacian--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetMagneticFieldLaplacian(struct soap *soap, const struct __turb2__GetMagneticFieldLaplacian *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetMagneticFieldLaplacian(soap, tag?tag:"-turb2:GetMagneticFieldLaplacian", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetMagneticFieldLaplacian * SOAP_FMAC4 soap_get___turb2__GetMagneticFieldLaplacian(struct soap *soap, struct __turb2__GetMagneticFieldLaplacian *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetMagneticFieldLaplacian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetVelocityLaplacian(struct soap *soap, struct __turb2__GetVelocityLaplacian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetVelocityLaplacian = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetVelocityLaplacian(struct soap *soap, const struct __turb2__GetVelocityLaplacian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetVelocityLaplacian(soap, &a->turb1__GetVelocityLaplacian);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetVelocityLaplacian(struct soap *soap, const char *tag, int id, const struct __turb2__GetVelocityLaplacian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetVelocityLaplacian(soap, "turb1:GetVelocityLaplacian", -1, &a->turb1__GetVelocityLaplacian, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetVelocityLaplacian * SOAP_FMAC4 soap_in___turb2__GetVelocityLaplacian(struct soap *soap, const char *tag, struct __turb2__GetVelocityLaplacian *a, const char *type)
{
	size_t soap_flag_turb1__GetVelocityLaplacian = 1;
	short soap_flag;
	a = (struct __turb2__GetVelocityLaplacian *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetVelocityLaplacian, sizeof(struct __turb2__GetVelocityLaplacian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetVelocityLaplacian(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetVelocityLaplacian && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetVelocityLaplacian(soap, "turb1:GetVelocityLaplacian", &a->turb1__GetVelocityLaplacian, ""))
				{	soap_flag_turb1__GetVelocityLaplacian--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetVelocityLaplacian(struct soap *soap, const struct __turb2__GetVelocityLaplacian *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetVelocityLaplacian(soap, tag?tag:"-turb2:GetVelocityLaplacian", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetVelocityLaplacian * SOAP_FMAC4 soap_get___turb2__GetVelocityLaplacian(struct soap *soap, struct __turb2__GetVelocityLaplacian *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetVelocityLaplacian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetVectorPotentialHessian(struct soap *soap, struct __turb2__GetVectorPotentialHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetVectorPotentialHessian = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetVectorPotentialHessian(struct soap *soap, const struct __turb2__GetVectorPotentialHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetVectorPotentialHessian(soap, &a->turb1__GetVectorPotentialHessian);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetVectorPotentialHessian(struct soap *soap, const char *tag, int id, const struct __turb2__GetVectorPotentialHessian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetVectorPotentialHessian(soap, "turb1:GetVectorPotentialHessian", -1, &a->turb1__GetVectorPotentialHessian, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetVectorPotentialHessian * SOAP_FMAC4 soap_in___turb2__GetVectorPotentialHessian(struct soap *soap, const char *tag, struct __turb2__GetVectorPotentialHessian *a, const char *type)
{
	size_t soap_flag_turb1__GetVectorPotentialHessian = 1;
	short soap_flag;
	a = (struct __turb2__GetVectorPotentialHessian *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetVectorPotentialHessian, sizeof(struct __turb2__GetVectorPotentialHessian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetVectorPotentialHessian(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetVectorPotentialHessian && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetVectorPotentialHessian(soap, "turb1:GetVectorPotentialHessian", &a->turb1__GetVectorPotentialHessian, ""))
				{	soap_flag_turb1__GetVectorPotentialHessian--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetVectorPotentialHessian(struct soap *soap, const struct __turb2__GetVectorPotentialHessian *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetVectorPotentialHessian(soap, tag?tag:"-turb2:GetVectorPotentialHessian", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetVectorPotentialHessian * SOAP_FMAC4 soap_get___turb2__GetVectorPotentialHessian(struct soap *soap, struct __turb2__GetVectorPotentialHessian *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetVectorPotentialHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetMagneticHessian(struct soap *soap, struct __turb2__GetMagneticHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetMagneticHessian = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetMagneticHessian(struct soap *soap, const struct __turb2__GetMagneticHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetMagneticHessian(soap, &a->turb1__GetMagneticHessian);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetMagneticHessian(struct soap *soap, const char *tag, int id, const struct __turb2__GetMagneticHessian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetMagneticHessian(soap, "turb1:GetMagneticHessian", -1, &a->turb1__GetMagneticHessian, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetMagneticHessian * SOAP_FMAC4 soap_in___turb2__GetMagneticHessian(struct soap *soap, const char *tag, struct __turb2__GetMagneticHessian *a, const char *type)
{
	size_t soap_flag_turb1__GetMagneticHessian = 1;
	short soap_flag;
	a = (struct __turb2__GetMagneticHessian *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetMagneticHessian, sizeof(struct __turb2__GetMagneticHessian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetMagneticHessian(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetMagneticHessian && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetMagneticHessian(soap, "turb1:GetMagneticHessian", &a->turb1__GetMagneticHessian, ""))
				{	soap_flag_turb1__GetMagneticHessian--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetMagneticHessian(struct soap *soap, const struct __turb2__GetMagneticHessian *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetMagneticHessian(soap, tag?tag:"-turb2:GetMagneticHessian", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetMagneticHessian * SOAP_FMAC4 soap_get___turb2__GetMagneticHessian(struct soap *soap, struct __turb2__GetMagneticHessian *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetMagneticHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetVelocityHessian(struct soap *soap, struct __turb2__GetVelocityHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetVelocityHessian = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetVelocityHessian(struct soap *soap, const struct __turb2__GetVelocityHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetVelocityHessian(soap, &a->turb1__GetVelocityHessian);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetVelocityHessian(struct soap *soap, const char *tag, int id, const struct __turb2__GetVelocityHessian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetVelocityHessian(soap, "turb1:GetVelocityHessian", -1, &a->turb1__GetVelocityHessian, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetVelocityHessian * SOAP_FMAC4 soap_in___turb2__GetVelocityHessian(struct soap *soap, const char *tag, struct __turb2__GetVelocityHessian *a, const char *type)
{
	size_t soap_flag_turb1__GetVelocityHessian = 1;
	short soap_flag;
	a = (struct __turb2__GetVelocityHessian *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetVelocityHessian, sizeof(struct __turb2__GetVelocityHessian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetVelocityHessian(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetVelocityHessian && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetVelocityHessian(soap, "turb1:GetVelocityHessian", &a->turb1__GetVelocityHessian, ""))
				{	soap_flag_turb1__GetVelocityHessian--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetVelocityHessian(struct soap *soap, const struct __turb2__GetVelocityHessian *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetVelocityHessian(soap, tag?tag:"-turb2:GetVelocityHessian", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetVelocityHessian * SOAP_FMAC4 soap_get___turb2__GetVelocityHessian(struct soap *soap, struct __turb2__GetVelocityHessian *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetVelocityHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetPressureHessian(struct soap *soap, struct __turb2__GetPressureHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetPressureHessian = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetPressureHessian(struct soap *soap, const struct __turb2__GetPressureHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetPressureHessian(soap, &a->turb1__GetPressureHessian);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetPressureHessian(struct soap *soap, const char *tag, int id, const struct __turb2__GetPressureHessian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetPressureHessian(soap, "turb1:GetPressureHessian", -1, &a->turb1__GetPressureHessian, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetPressureHessian * SOAP_FMAC4 soap_in___turb2__GetPressureHessian(struct soap *soap, const char *tag, struct __turb2__GetPressureHessian *a, const char *type)
{
	size_t soap_flag_turb1__GetPressureHessian = 1;
	short soap_flag;
	a = (struct __turb2__GetPressureHessian *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetPressureHessian, sizeof(struct __turb2__GetPressureHessian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetPressureHessian(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetPressureHessian && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetPressureHessian(soap, "turb1:GetPressureHessian", &a->turb1__GetPressureHessian, ""))
				{	soap_flag_turb1__GetPressureHessian--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetPressureHessian(struct soap *soap, const struct __turb2__GetPressureHessian *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetPressureHessian(soap, tag?tag:"-turb2:GetPressureHessian", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetPressureHessian * SOAP_FMAC4 soap_get___turb2__GetPressureHessian(struct soap *soap, struct __turb2__GetPressureHessian *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetPressureHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetPressureGradient(struct soap *soap, struct __turb2__GetPressureGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetPressureGradient = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetPressureGradient(struct soap *soap, const struct __turb2__GetPressureGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetPressureGradient(soap, &a->turb1__GetPressureGradient);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetPressureGradient(struct soap *soap, const char *tag, int id, const struct __turb2__GetPressureGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetPressureGradient(soap, "turb1:GetPressureGradient", -1, &a->turb1__GetPressureGradient, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetPressureGradient * SOAP_FMAC4 soap_in___turb2__GetPressureGradient(struct soap *soap, const char *tag, struct __turb2__GetPressureGradient *a, const char *type)
{
	size_t soap_flag_turb1__GetPressureGradient = 1;
	short soap_flag;
	a = (struct __turb2__GetPressureGradient *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetPressureGradient, sizeof(struct __turb2__GetPressureGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetPressureGradient(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetPressureGradient && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetPressureGradient(soap, "turb1:GetPressureGradient", &a->turb1__GetPressureGradient, ""))
				{	soap_flag_turb1__GetPressureGradient--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetPressureGradient(struct soap *soap, const struct __turb2__GetPressureGradient *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetPressureGradient(soap, tag?tag:"-turb2:GetPressureGradient", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetPressureGradient * SOAP_FMAC4 soap_get___turb2__GetPressureGradient(struct soap *soap, struct __turb2__GetPressureGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetPressureGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetVectorPotentialGradient(struct soap *soap, struct __turb2__GetVectorPotentialGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetVectorPotentialGradient = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetVectorPotentialGradient(struct soap *soap, const struct __turb2__GetVectorPotentialGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetVectorPotentialGradient(soap, &a->turb1__GetVectorPotentialGradient);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetVectorPotentialGradient(struct soap *soap, const char *tag, int id, const struct __turb2__GetVectorPotentialGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetVectorPotentialGradient(soap, "turb1:GetVectorPotentialGradient", -1, &a->turb1__GetVectorPotentialGradient, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetVectorPotentialGradient * SOAP_FMAC4 soap_in___turb2__GetVectorPotentialGradient(struct soap *soap, const char *tag, struct __turb2__GetVectorPotentialGradient *a, const char *type)
{
	size_t soap_flag_turb1__GetVectorPotentialGradient = 1;
	short soap_flag;
	a = (struct __turb2__GetVectorPotentialGradient *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetVectorPotentialGradient, sizeof(struct __turb2__GetVectorPotentialGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetVectorPotentialGradient(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetVectorPotentialGradient && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetVectorPotentialGradient(soap, "turb1:GetVectorPotentialGradient", &a->turb1__GetVectorPotentialGradient, ""))
				{	soap_flag_turb1__GetVectorPotentialGradient--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetVectorPotentialGradient(struct soap *soap, const struct __turb2__GetVectorPotentialGradient *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetVectorPotentialGradient(soap, tag?tag:"-turb2:GetVectorPotentialGradient", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetVectorPotentialGradient * SOAP_FMAC4 soap_get___turb2__GetVectorPotentialGradient(struct soap *soap, struct __turb2__GetVectorPotentialGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetVectorPotentialGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetMagneticFieldGradient(struct soap *soap, struct __turb2__GetMagneticFieldGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetMagneticFieldGradient = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetMagneticFieldGradient(struct soap *soap, const struct __turb2__GetMagneticFieldGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetMagneticFieldGradient(soap, &a->turb1__GetMagneticFieldGradient);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetMagneticFieldGradient(struct soap *soap, const char *tag, int id, const struct __turb2__GetMagneticFieldGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetMagneticFieldGradient(soap, "turb1:GetMagneticFieldGradient", -1, &a->turb1__GetMagneticFieldGradient, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetMagneticFieldGradient * SOAP_FMAC4 soap_in___turb2__GetMagneticFieldGradient(struct soap *soap, const char *tag, struct __turb2__GetMagneticFieldGradient *a, const char *type)
{
	size_t soap_flag_turb1__GetMagneticFieldGradient = 1;
	short soap_flag;
	a = (struct __turb2__GetMagneticFieldGradient *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetMagneticFieldGradient, sizeof(struct __turb2__GetMagneticFieldGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetMagneticFieldGradient(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetMagneticFieldGradient && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetMagneticFieldGradient(soap, "turb1:GetMagneticFieldGradient", &a->turb1__GetMagneticFieldGradient, ""))
				{	soap_flag_turb1__GetMagneticFieldGradient--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetMagneticFieldGradient(struct soap *soap, const struct __turb2__GetMagneticFieldGradient *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetMagneticFieldGradient(soap, tag?tag:"-turb2:GetMagneticFieldGradient", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetMagneticFieldGradient * SOAP_FMAC4 soap_get___turb2__GetMagneticFieldGradient(struct soap *soap, struct __turb2__GetMagneticFieldGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetMagneticFieldGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetVelocityGradient(struct soap *soap, struct __turb2__GetVelocityGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetVelocityGradient = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetVelocityGradient(struct soap *soap, const struct __turb2__GetVelocityGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetVelocityGradient(soap, &a->turb1__GetVelocityGradient);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetVelocityGradient(struct soap *soap, const char *tag, int id, const struct __turb2__GetVelocityGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetVelocityGradient(soap, "turb1:GetVelocityGradient", -1, &a->turb1__GetVelocityGradient, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetVelocityGradient * SOAP_FMAC4 soap_in___turb2__GetVelocityGradient(struct soap *soap, const char *tag, struct __turb2__GetVelocityGradient *a, const char *type)
{
	size_t soap_flag_turb1__GetVelocityGradient = 1;
	short soap_flag;
	a = (struct __turb2__GetVelocityGradient *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetVelocityGradient, sizeof(struct __turb2__GetVelocityGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetVelocityGradient(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetVelocityGradient && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetVelocityGradient(soap, "turb1:GetVelocityGradient", &a->turb1__GetVelocityGradient, ""))
				{	soap_flag_turb1__GetVelocityGradient--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetVelocityGradient(struct soap *soap, const struct __turb2__GetVelocityGradient *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetVelocityGradient(soap, tag?tag:"-turb2:GetVelocityGradient", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetVelocityGradient * SOAP_FMAC4 soap_get___turb2__GetVelocityGradient(struct soap *soap, struct __turb2__GetVelocityGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetVelocityGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetVelocityAndPressure(struct soap *soap, struct __turb2__GetVelocityAndPressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetVelocityAndPressure = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetVelocityAndPressure(struct soap *soap, const struct __turb2__GetVelocityAndPressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetVelocityAndPressure(soap, &a->turb1__GetVelocityAndPressure);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetVelocityAndPressure(struct soap *soap, const char *tag, int id, const struct __turb2__GetVelocityAndPressure *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetVelocityAndPressure(soap, "turb1:GetVelocityAndPressure", -1, &a->turb1__GetVelocityAndPressure, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetVelocityAndPressure * SOAP_FMAC4 soap_in___turb2__GetVelocityAndPressure(struct soap *soap, const char *tag, struct __turb2__GetVelocityAndPressure *a, const char *type)
{
	size_t soap_flag_turb1__GetVelocityAndPressure = 1;
	short soap_flag;
	a = (struct __turb2__GetVelocityAndPressure *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetVelocityAndPressure, sizeof(struct __turb2__GetVelocityAndPressure), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetVelocityAndPressure(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetVelocityAndPressure && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetVelocityAndPressure(soap, "turb1:GetVelocityAndPressure", &a->turb1__GetVelocityAndPressure, ""))
				{	soap_flag_turb1__GetVelocityAndPressure--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetVelocityAndPressure(struct soap *soap, const struct __turb2__GetVelocityAndPressure *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetVelocityAndPressure(soap, tag?tag:"-turb2:GetVelocityAndPressure", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetVelocityAndPressure * SOAP_FMAC4 soap_get___turb2__GetVelocityAndPressure(struct soap *soap, struct __turb2__GetVelocityAndPressure *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetVelocityAndPressure(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetForce(struct soap *soap, struct __turb2__GetForce *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetForce = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetForce(struct soap *soap, const struct __turb2__GetForce *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetForce(soap, &a->turb1__GetForce);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetForce(struct soap *soap, const char *tag, int id, const struct __turb2__GetForce *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetForce(soap, "turb1:GetForce", -1, &a->turb1__GetForce, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetForce * SOAP_FMAC4 soap_in___turb2__GetForce(struct soap *soap, const char *tag, struct __turb2__GetForce *a, const char *type)
{
	size_t soap_flag_turb1__GetForce = 1;
	short soap_flag;
	a = (struct __turb2__GetForce *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetForce, sizeof(struct __turb2__GetForce), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetForce(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetForce && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetForce(soap, "turb1:GetForce", &a->turb1__GetForce, ""))
				{	soap_flag_turb1__GetForce--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetForce(struct soap *soap, const struct __turb2__GetForce *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetForce(soap, tag?tag:"-turb2:GetForce", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetForce * SOAP_FMAC4 soap_get___turb2__GetForce(struct soap *soap, struct __turb2__GetForce *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetForce(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetRawDensity(struct soap *soap, struct __turb2__GetRawDensity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetRawDensity = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetRawDensity(struct soap *soap, const struct __turb2__GetRawDensity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetRawDensity(soap, &a->turb1__GetRawDensity);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetRawDensity(struct soap *soap, const char *tag, int id, const struct __turb2__GetRawDensity *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetRawDensity(soap, "turb1:GetRawDensity", -1, &a->turb1__GetRawDensity, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetRawDensity * SOAP_FMAC4 soap_in___turb2__GetRawDensity(struct soap *soap, const char *tag, struct __turb2__GetRawDensity *a, const char *type)
{
	size_t soap_flag_turb1__GetRawDensity = 1;
	short soap_flag;
	a = (struct __turb2__GetRawDensity *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetRawDensity, sizeof(struct __turb2__GetRawDensity), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetRawDensity(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetRawDensity && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetRawDensity(soap, "turb1:GetRawDensity", &a->turb1__GetRawDensity, ""))
				{	soap_flag_turb1__GetRawDensity--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetRawDensity(struct soap *soap, const struct __turb2__GetRawDensity *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetRawDensity(soap, tag?tag:"-turb2:GetRawDensity", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetRawDensity * SOAP_FMAC4 soap_get___turb2__GetRawDensity(struct soap *soap, struct __turb2__GetRawDensity *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetRawDensity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetDensityHessian(struct soap *soap, struct __turb2__GetDensityHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetDensityHessian = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetDensityHessian(struct soap *soap, const struct __turb2__GetDensityHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetDensityHessian(soap, &a->turb1__GetDensityHessian);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetDensityHessian(struct soap *soap, const char *tag, int id, const struct __turb2__GetDensityHessian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetDensityHessian(soap, "turb1:GetDensityHessian", -1, &a->turb1__GetDensityHessian, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetDensityHessian * SOAP_FMAC4 soap_in___turb2__GetDensityHessian(struct soap *soap, const char *tag, struct __turb2__GetDensityHessian *a, const char *type)
{
	size_t soap_flag_turb1__GetDensityHessian = 1;
	short soap_flag;
	a = (struct __turb2__GetDensityHessian *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetDensityHessian, sizeof(struct __turb2__GetDensityHessian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetDensityHessian(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetDensityHessian && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetDensityHessian(soap, "turb1:GetDensityHessian", &a->turb1__GetDensityHessian, ""))
				{	soap_flag_turb1__GetDensityHessian--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetDensityHessian(struct soap *soap, const struct __turb2__GetDensityHessian *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetDensityHessian(soap, tag?tag:"-turb2:GetDensityHessian", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetDensityHessian * SOAP_FMAC4 soap_get___turb2__GetDensityHessian(struct soap *soap, struct __turb2__GetDensityHessian *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetDensityHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetDensityGradient(struct soap *soap, struct __turb2__GetDensityGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetDensityGradient = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetDensityGradient(struct soap *soap, const struct __turb2__GetDensityGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetDensityGradient(soap, &a->turb1__GetDensityGradient);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetDensityGradient(struct soap *soap, const char *tag, int id, const struct __turb2__GetDensityGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetDensityGradient(soap, "turb1:GetDensityGradient", -1, &a->turb1__GetDensityGradient, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetDensityGradient * SOAP_FMAC4 soap_in___turb2__GetDensityGradient(struct soap *soap, const char *tag, struct __turb2__GetDensityGradient *a, const char *type)
{
	size_t soap_flag_turb1__GetDensityGradient = 1;
	short soap_flag;
	a = (struct __turb2__GetDensityGradient *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetDensityGradient, sizeof(struct __turb2__GetDensityGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetDensityGradient(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetDensityGradient && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetDensityGradient(soap, "turb1:GetDensityGradient", &a->turb1__GetDensityGradient, ""))
				{	soap_flag_turb1__GetDensityGradient--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetDensityGradient(struct soap *soap, const struct __turb2__GetDensityGradient *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetDensityGradient(soap, tag?tag:"-turb2:GetDensityGradient", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetDensityGradient * SOAP_FMAC4 soap_get___turb2__GetDensityGradient(struct soap *soap, struct __turb2__GetDensityGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetDensityGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetDensity(struct soap *soap, struct __turb2__GetDensity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetDensity = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetDensity(struct soap *soap, const struct __turb2__GetDensity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetDensity(soap, &a->turb1__GetDensity);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetDensity(struct soap *soap, const char *tag, int id, const struct __turb2__GetDensity *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetDensity(soap, "turb1:GetDensity", -1, &a->turb1__GetDensity, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetDensity * SOAP_FMAC4 soap_in___turb2__GetDensity(struct soap *soap, const char *tag, struct __turb2__GetDensity *a, const char *type)
{
	size_t soap_flag_turb1__GetDensity = 1;
	short soap_flag;
	a = (struct __turb2__GetDensity *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetDensity, sizeof(struct __turb2__GetDensity), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetDensity(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetDensity && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetDensity(soap, "turb1:GetDensity", &a->turb1__GetDensity, ""))
				{	soap_flag_turb1__GetDensity--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetDensity(struct soap *soap, const struct __turb2__GetDensity *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetDensity(soap, tag?tag:"-turb2:GetDensity", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetDensity * SOAP_FMAC4 soap_get___turb2__GetDensity(struct soap *soap, struct __turb2__GetDensity *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetDensity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetRawVectorPotential(struct soap *soap, struct __turb2__GetRawVectorPotential *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetRawVectorPotential = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetRawVectorPotential(struct soap *soap, const struct __turb2__GetRawVectorPotential *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetRawVectorPotential(soap, &a->turb1__GetRawVectorPotential);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetRawVectorPotential(struct soap *soap, const char *tag, int id, const struct __turb2__GetRawVectorPotential *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetRawVectorPotential(soap, "turb1:GetRawVectorPotential", -1, &a->turb1__GetRawVectorPotential, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetRawVectorPotential * SOAP_FMAC4 soap_in___turb2__GetRawVectorPotential(struct soap *soap, const char *tag, struct __turb2__GetRawVectorPotential *a, const char *type)
{
	size_t soap_flag_turb1__GetRawVectorPotential = 1;
	short soap_flag;
	a = (struct __turb2__GetRawVectorPotential *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetRawVectorPotential, sizeof(struct __turb2__GetRawVectorPotential), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetRawVectorPotential(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetRawVectorPotential && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetRawVectorPotential(soap, "turb1:GetRawVectorPotential", &a->turb1__GetRawVectorPotential, ""))
				{	soap_flag_turb1__GetRawVectorPotential--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetRawVectorPotential(struct soap *soap, const struct __turb2__GetRawVectorPotential *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetRawVectorPotential(soap, tag?tag:"-turb2:GetRawVectorPotential", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetRawVectorPotential * SOAP_FMAC4 soap_get___turb2__GetRawVectorPotential(struct soap *soap, struct __turb2__GetRawVectorPotential *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetRawVectorPotential(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetVectorPotential(struct soap *soap, struct __turb2__GetVectorPotential *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetVectorPotential = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetVectorPotential(struct soap *soap, const struct __turb2__GetVectorPotential *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetVectorPotential(soap, &a->turb1__GetVectorPotential);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetVectorPotential(struct soap *soap, const char *tag, int id, const struct __turb2__GetVectorPotential *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetVectorPotential(soap, "turb1:GetVectorPotential", -1, &a->turb1__GetVectorPotential, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetVectorPotential * SOAP_FMAC4 soap_in___turb2__GetVectorPotential(struct soap *soap, const char *tag, struct __turb2__GetVectorPotential *a, const char *type)
{
	size_t soap_flag_turb1__GetVectorPotential = 1;
	short soap_flag;
	a = (struct __turb2__GetVectorPotential *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetVectorPotential, sizeof(struct __turb2__GetVectorPotential), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetVectorPotential(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetVectorPotential && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetVectorPotential(soap, "turb1:GetVectorPotential", &a->turb1__GetVectorPotential, ""))
				{	soap_flag_turb1__GetVectorPotential--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetVectorPotential(struct soap *soap, const struct __turb2__GetVectorPotential *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetVectorPotential(soap, tag?tag:"-turb2:GetVectorPotential", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetVectorPotential * SOAP_FMAC4 soap_get___turb2__GetVectorPotential(struct soap *soap, struct __turb2__GetVectorPotential *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetVectorPotential(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetRawMagneticField(struct soap *soap, struct __turb2__GetRawMagneticField *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetRawMagneticField = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetRawMagneticField(struct soap *soap, const struct __turb2__GetRawMagneticField *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetRawMagneticField(soap, &a->turb1__GetRawMagneticField);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetRawMagneticField(struct soap *soap, const char *tag, int id, const struct __turb2__GetRawMagneticField *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetRawMagneticField(soap, "turb1:GetRawMagneticField", -1, &a->turb1__GetRawMagneticField, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetRawMagneticField * SOAP_FMAC4 soap_in___turb2__GetRawMagneticField(struct soap *soap, const char *tag, struct __turb2__GetRawMagneticField *a, const char *type)
{
	size_t soap_flag_turb1__GetRawMagneticField = 1;
	short soap_flag;
	a = (struct __turb2__GetRawMagneticField *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetRawMagneticField, sizeof(struct __turb2__GetRawMagneticField), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetRawMagneticField(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetRawMagneticField && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetRawMagneticField(soap, "turb1:GetRawMagneticField", &a->turb1__GetRawMagneticField, ""))
				{	soap_flag_turb1__GetRawMagneticField--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetRawMagneticField(struct soap *soap, const struct __turb2__GetRawMagneticField *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetRawMagneticField(soap, tag?tag:"-turb2:GetRawMagneticField", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetRawMagneticField * SOAP_FMAC4 soap_get___turb2__GetRawMagneticField(struct soap *soap, struct __turb2__GetRawMagneticField *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetRawMagneticField(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetMagneticField(struct soap *soap, struct __turb2__GetMagneticField *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetMagneticField = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetMagneticField(struct soap *soap, const struct __turb2__GetMagneticField *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetMagneticField(soap, &a->turb1__GetMagneticField);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetMagneticField(struct soap *soap, const char *tag, int id, const struct __turb2__GetMagneticField *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetMagneticField(soap, "turb1:GetMagneticField", -1, &a->turb1__GetMagneticField, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetMagneticField * SOAP_FMAC4 soap_in___turb2__GetMagneticField(struct soap *soap, const char *tag, struct __turb2__GetMagneticField *a, const char *type)
{
	size_t soap_flag_turb1__GetMagneticField = 1;
	short soap_flag;
	a = (struct __turb2__GetMagneticField *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetMagneticField, sizeof(struct __turb2__GetMagneticField), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetMagneticField(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetMagneticField && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetMagneticField(soap, "turb1:GetMagneticField", &a->turb1__GetMagneticField, ""))
				{	soap_flag_turb1__GetMagneticField--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetMagneticField(struct soap *soap, const struct __turb2__GetMagneticField *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetMagneticField(soap, tag?tag:"-turb2:GetMagneticField", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetMagneticField * SOAP_FMAC4 soap_get___turb2__GetMagneticField(struct soap *soap, struct __turb2__GetMagneticField *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetMagneticField(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetRawPressure(struct soap *soap, struct __turb2__GetRawPressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetRawPressure = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetRawPressure(struct soap *soap, const struct __turb2__GetRawPressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetRawPressure(soap, &a->turb1__GetRawPressure);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetRawPressure(struct soap *soap, const char *tag, int id, const struct __turb2__GetRawPressure *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetRawPressure(soap, "turb1:GetRawPressure", -1, &a->turb1__GetRawPressure, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetRawPressure * SOAP_FMAC4 soap_in___turb2__GetRawPressure(struct soap *soap, const char *tag, struct __turb2__GetRawPressure *a, const char *type)
{
	size_t soap_flag_turb1__GetRawPressure = 1;
	short soap_flag;
	a = (struct __turb2__GetRawPressure *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetRawPressure, sizeof(struct __turb2__GetRawPressure), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetRawPressure(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetRawPressure && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetRawPressure(soap, "turb1:GetRawPressure", &a->turb1__GetRawPressure, ""))
				{	soap_flag_turb1__GetRawPressure--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetRawPressure(struct soap *soap, const struct __turb2__GetRawPressure *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetRawPressure(soap, tag?tag:"-turb2:GetRawPressure", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetRawPressure * SOAP_FMAC4 soap_get___turb2__GetRawPressure(struct soap *soap, struct __turb2__GetRawPressure *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetRawPressure(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetPressure(struct soap *soap, struct __turb2__GetPressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetPressure = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetPressure(struct soap *soap, const struct __turb2__GetPressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetPressure(soap, &a->turb1__GetPressure);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetPressure(struct soap *soap, const char *tag, int id, const struct __turb2__GetPressure *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetPressure(soap, "turb1:GetPressure", -1, &a->turb1__GetPressure, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetPressure * SOAP_FMAC4 soap_in___turb2__GetPressure(struct soap *soap, const char *tag, struct __turb2__GetPressure *a, const char *type)
{
	size_t soap_flag_turb1__GetPressure = 1;
	short soap_flag;
	a = (struct __turb2__GetPressure *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetPressure, sizeof(struct __turb2__GetPressure), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetPressure(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetPressure && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetPressure(soap, "turb1:GetPressure", &a->turb1__GetPressure, ""))
				{	soap_flag_turb1__GetPressure--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetPressure(struct soap *soap, const struct __turb2__GetPressure *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetPressure(soap, tag?tag:"-turb2:GetPressure", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetPressure * SOAP_FMAC4 soap_get___turb2__GetPressure(struct soap *soap, struct __turb2__GetPressure *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetPressure(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetRawVelocity(struct soap *soap, struct __turb2__GetRawVelocity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetRawVelocity = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetRawVelocity(struct soap *soap, const struct __turb2__GetRawVelocity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetRawVelocity(soap, &a->turb1__GetRawVelocity);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetRawVelocity(struct soap *soap, const char *tag, int id, const struct __turb2__GetRawVelocity *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetRawVelocity(soap, "turb1:GetRawVelocity", -1, &a->turb1__GetRawVelocity, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetRawVelocity * SOAP_FMAC4 soap_in___turb2__GetRawVelocity(struct soap *soap, const char *tag, struct __turb2__GetRawVelocity *a, const char *type)
{
	size_t soap_flag_turb1__GetRawVelocity = 1;
	short soap_flag;
	a = (struct __turb2__GetRawVelocity *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetRawVelocity, sizeof(struct __turb2__GetRawVelocity), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetRawVelocity(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetRawVelocity && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetRawVelocity(soap, "turb1:GetRawVelocity", &a->turb1__GetRawVelocity, ""))
				{	soap_flag_turb1__GetRawVelocity--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetRawVelocity(struct soap *soap, const struct __turb2__GetRawVelocity *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetRawVelocity(soap, tag?tag:"-turb2:GetRawVelocity", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetRawVelocity * SOAP_FMAC4 soap_get___turb2__GetRawVelocity(struct soap *soap, struct __turb2__GetRawVelocity *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetRawVelocity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetVelocityBatch(struct soap *soap, struct __turb2__GetVelocityBatch *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetVelocityBatch = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetVelocityBatch(struct soap *soap, const struct __turb2__GetVelocityBatch *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetVelocityBatch(soap, &a->turb1__GetVelocityBatch);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetVelocityBatch(struct soap *soap, const char *tag, int id, const struct __turb2__GetVelocityBatch *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetVelocityBatch(soap, "turb1:GetVelocityBatch", -1, &a->turb1__GetVelocityBatch, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetVelocityBatch * SOAP_FMAC4 soap_in___turb2__GetVelocityBatch(struct soap *soap, const char *tag, struct __turb2__GetVelocityBatch *a, const char *type)
{
	size_t soap_flag_turb1__GetVelocityBatch = 1;
	short soap_flag;
	a = (struct __turb2__GetVelocityBatch *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetVelocityBatch, sizeof(struct __turb2__GetVelocityBatch), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetVelocityBatch(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetVelocityBatch && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetVelocityBatch(soap, "turb1:GetVelocityBatch", &a->turb1__GetVelocityBatch, ""))
				{	soap_flag_turb1__GetVelocityBatch--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetVelocityBatch(struct soap *soap, const struct __turb2__GetVelocityBatch *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetVelocityBatch(soap, tag?tag:"-turb2:GetVelocityBatch", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetVelocityBatch * SOAP_FMAC4 soap_get___turb2__GetVelocityBatch(struct soap *soap, struct __turb2__GetVelocityBatch *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetVelocityBatch(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__GetVelocity(struct soap *soap, struct __turb2__GetVelocity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__GetVelocity = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__GetVelocity(struct soap *soap, const struct __turb2__GetVelocity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__GetVelocity(soap, &a->turb1__GetVelocity);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__GetVelocity(struct soap *soap, const char *tag, int id, const struct __turb2__GetVelocity *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__GetVelocity(soap, "turb1:GetVelocity", -1, &a->turb1__GetVelocity, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetVelocity * SOAP_FMAC4 soap_in___turb2__GetVelocity(struct soap *soap, const char *tag, struct __turb2__GetVelocity *a, const char *type)
{
	size_t soap_flag_turb1__GetVelocity = 1;
	short soap_flag;
	a = (struct __turb2__GetVelocity *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__GetVelocity, sizeof(struct __turb2__GetVelocity), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__GetVelocity(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__GetVelocity && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__GetVelocity(soap, "turb1:GetVelocity", &a->turb1__GetVelocity, ""))
				{	soap_flag_turb1__GetVelocity--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__GetVelocity(struct soap *soap, const struct __turb2__GetVelocity *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__GetVelocity(soap, tag?tag:"-turb2:GetVelocity", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__GetVelocity * SOAP_FMAC4 soap_get___turb2__GetVelocity(struct soap *soap, struct __turb2__GetVelocity *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__GetVelocity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___turb2__NullOp(struct soap *soap, struct __turb2__NullOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->turb1__NullOp = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___turb2__NullOp(struct soap *soap, const struct __turb2__NullOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_turb1__NullOp(soap, &a->turb1__NullOp);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___turb2__NullOp(struct soap *soap, const char *tag, int id, const struct __turb2__NullOp *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_turb1__NullOp(soap, "turb1:NullOp", -1, &a->turb1__NullOp, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__NullOp * SOAP_FMAC4 soap_in___turb2__NullOp(struct soap *soap, const char *tag, struct __turb2__NullOp *a, const char *type)
{
	size_t soap_flag_turb1__NullOp = 1;
	short soap_flag;
	a = (struct __turb2__NullOp *)soap_id_enter(soap, "", a, SOAP_TYPE___turb2__NullOp, sizeof(struct __turb2__NullOp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___turb2__NullOp(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_turb1__NullOp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_turb1__NullOp(soap, "turb1:NullOp", &a->turb1__NullOp, ""))
				{	soap_flag_turb1__NullOp--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___turb2__NullOp(struct soap *soap, const struct __turb2__NullOp *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___turb2__NullOp(soap, tag?tag:"-turb2:NullOp", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __turb2__NullOp * SOAP_FMAC4 soap_get___turb2__NullOp(struct soap *soap, struct __turb2__NullOp *p, const char *tag, const char *type)
{
	if ((p = soap_in___turb2__NullOp(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetLaplacianOfGradientResponse(struct soap *soap, struct _turb1__GetLaplacianOfGradientResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetLaplacianOfGradientResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetLaplacianOfGradientResponse(struct soap *soap, const struct _turb1__GetLaplacianOfGradientResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfVelocityGradient(soap, &a->GetLaplacianOfGradientResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetLaplacianOfGradientResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetLaplacianOfGradientResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetLaplacianOfGradientResponse), type))
		return soap->error;
	if (a->GetLaplacianOfGradientResult)
		soap_element_result(soap, "turb1:GetLaplacianOfGradientResult");
	if (soap_out_PointerToturb1__ArrayOfVelocityGradient(soap, "turb1:GetLaplacianOfGradientResult", -1, &a->GetLaplacianOfGradientResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetLaplacianOfGradientResponse * SOAP_FMAC4 soap_in__turb1__GetLaplacianOfGradientResponse(struct soap *soap, const char *tag, struct _turb1__GetLaplacianOfGradientResponse *a, const char *type)
{
	size_t soap_flag_GetLaplacianOfGradientResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetLaplacianOfGradientResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetLaplacianOfGradientResponse, sizeof(struct _turb1__GetLaplacianOfGradientResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetLaplacianOfGradientResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetLaplacianOfGradientResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfVelocityGradient(soap, "turb1:GetLaplacianOfGradientResult", &a->GetLaplacianOfGradientResult, "turb1:ArrayOfVelocityGradient"))
				{	soap_flag_GetLaplacianOfGradientResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetLaplacianOfGradientResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetLaplacianOfGradientResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetLaplacianOfGradientResponse, 0, sizeof(struct _turb1__GetLaplacianOfGradientResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetLaplacianOfGradientResponse(struct soap *soap, const struct _turb1__GetLaplacianOfGradientResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetLaplacianOfGradientResponse);
	if (soap_out__turb1__GetLaplacianOfGradientResponse(soap, tag?tag:"turb1:GetLaplacianOfGradientResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetLaplacianOfGradientResponse * SOAP_FMAC4 soap_get__turb1__GetLaplacianOfGradientResponse(struct soap *soap, struct _turb1__GetLaplacianOfGradientResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetLaplacianOfGradientResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetLaplacianOfGradient(struct soap *soap, struct _turb1__GetLaplacianOfGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_string(soap, &a->field);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetLaplacianOfGradient(struct soap *soap, const struct _turb1__GetLaplacianOfGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_string(soap, &a->field);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetLaplacianOfGradient(struct soap *soap, const char *tag, int id, const struct _turb1__GetLaplacianOfGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetLaplacianOfGradient), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:field", -1, &a->field, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetLaplacianOfGradient * SOAP_FMAC4 soap_in__turb1__GetLaplacianOfGradient(struct soap *soap, const char *tag, struct _turb1__GetLaplacianOfGradient *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_field = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetLaplacianOfGradient *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetLaplacianOfGradient, sizeof(struct _turb1__GetLaplacianOfGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetLaplacianOfGradient(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_field && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:field", &a->field, "xsd:string"))
				{	soap_flag_field--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetLaplacianOfGradient *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetLaplacianOfGradient, 0, sizeof(struct _turb1__GetLaplacianOfGradient), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetLaplacianOfGradient(struct soap *soap, const struct _turb1__GetLaplacianOfGradient *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetLaplacianOfGradient);
	if (soap_out__turb1__GetLaplacianOfGradient(soap, tag?tag:"turb1:GetLaplacianOfGradient", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetLaplacianOfGradient * SOAP_FMAC4 soap_get__turb1__GetLaplacianOfGradient(struct soap *soap, struct _turb1__GetLaplacianOfGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetLaplacianOfGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetThresholdResponse(struct soap *soap, struct _turb1__GetThresholdResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetThresholdResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetThresholdResponse(struct soap *soap, const struct _turb1__GetThresholdResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfThresholdInfo(soap, &a->GetThresholdResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetThresholdResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetThresholdResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetThresholdResponse), type))
		return soap->error;
	if (a->GetThresholdResult)
		soap_element_result(soap, "turb1:GetThresholdResult");
	if (soap_out_PointerToturb1__ArrayOfThresholdInfo(soap, "turb1:GetThresholdResult", -1, &a->GetThresholdResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetThresholdResponse * SOAP_FMAC4 soap_in__turb1__GetThresholdResponse(struct soap *soap, const char *tag, struct _turb1__GetThresholdResponse *a, const char *type)
{
	size_t soap_flag_GetThresholdResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetThresholdResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetThresholdResponse, sizeof(struct _turb1__GetThresholdResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetThresholdResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetThresholdResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfThresholdInfo(soap, "turb1:GetThresholdResult", &a->GetThresholdResult, "turb1:ArrayOfThresholdInfo"))
				{	soap_flag_GetThresholdResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetThresholdResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetThresholdResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetThresholdResponse, 0, sizeof(struct _turb1__GetThresholdResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetThresholdResponse(struct soap *soap, const struct _turb1__GetThresholdResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetThresholdResponse);
	if (soap_out__turb1__GetThresholdResponse(soap, tag?tag:"turb1:GetThresholdResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetThresholdResponse * SOAP_FMAC4 soap_get__turb1__GetThresholdResponse(struct soap *soap, struct _turb1__GetThresholdResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetThresholdResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetThreshold(struct soap *soap, struct _turb1__GetThreshold *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_string(soap, &a->field);
	soap_default_float(soap, &a->time);
	soap_default_float(soap, &a->threshold);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_int(soap, &a->X);
	soap_default_int(soap, &a->Y);
	soap_default_int(soap, &a->Z);
	soap_default_int(soap, &a->Xwidth);
	soap_default_int(soap, &a->Ywidth);
	soap_default_int(soap, &a->Zwidth);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetThreshold(struct soap *soap, const struct _turb1__GetThreshold *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_string(soap, &a->field);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetThreshold(struct soap *soap, const char *tag, int id, const struct _turb1__GetThreshold *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetThreshold), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:field", -1, &a->field, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:threshold", -1, &a->threshold, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:X", -1, &a->X, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Y", -1, &a->Y, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Z", -1, &a->Z, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Xwidth", -1, &a->Xwidth, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Ywidth", -1, &a->Ywidth, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Zwidth", -1, &a->Zwidth, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetThreshold * SOAP_FMAC4 soap_in__turb1__GetThreshold(struct soap *soap, const char *tag, struct _turb1__GetThreshold *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_field = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_threshold = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_X = 1;
	size_t soap_flag_Y = 1;
	size_t soap_flag_Z = 1;
	size_t soap_flag_Xwidth = 1;
	size_t soap_flag_Ywidth = 1;
	size_t soap_flag_Zwidth = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetThreshold *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetThreshold, sizeof(struct _turb1__GetThreshold), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetThreshold(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_field && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:field", &a->field, "xsd:string"))
				{	soap_flag_field--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_threshold && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:threshold", &a->threshold, "xsd:float"))
				{	soap_flag_threshold--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_X && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:X", &a->X, "xsd:int"))
				{	soap_flag_X--;
					continue;
				}
			if (soap_flag_Y && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Y", &a->Y, "xsd:int"))
				{	soap_flag_Y--;
					continue;
				}
			if (soap_flag_Z && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Z", &a->Z, "xsd:int"))
				{	soap_flag_Z--;
					continue;
				}
			if (soap_flag_Xwidth && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Xwidth", &a->Xwidth, "xsd:int"))
				{	soap_flag_Xwidth--;
					continue;
				}
			if (soap_flag_Ywidth && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Ywidth", &a->Ywidth, "xsd:int"))
				{	soap_flag_Ywidth--;
					continue;
				}
			if (soap_flag_Zwidth && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Zwidth", &a->Zwidth, "xsd:int"))
				{	soap_flag_Zwidth--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetThreshold *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetThreshold, 0, sizeof(struct _turb1__GetThreshold), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_threshold > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_X > 0 || soap_flag_Y > 0 || soap_flag_Z > 0 || soap_flag_Xwidth > 0 || soap_flag_Ywidth > 0 || soap_flag_Zwidth > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetThreshold(struct soap *soap, const struct _turb1__GetThreshold *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetThreshold);
	if (soap_out__turb1__GetThreshold(soap, tag?tag:"turb1:GetThreshold", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetThreshold * SOAP_FMAC4 soap_get__turb1__GetThreshold(struct soap *soap, struct _turb1__GetThreshold *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetThreshold(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetBoxFilterGradientResponse(struct soap *soap, struct _turb1__GetBoxFilterGradientResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetBoxFilterGradientResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetBoxFilterGradientResponse(struct soap *soap, const struct _turb1__GetBoxFilterGradientResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfVelocityGradient(soap, &a->GetBoxFilterGradientResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetBoxFilterGradientResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetBoxFilterGradientResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetBoxFilterGradientResponse), type))
		return soap->error;
	if (a->GetBoxFilterGradientResult)
		soap_element_result(soap, "turb1:GetBoxFilterGradientResult");
	if (soap_out_PointerToturb1__ArrayOfVelocityGradient(soap, "turb1:GetBoxFilterGradientResult", -1, &a->GetBoxFilterGradientResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetBoxFilterGradientResponse * SOAP_FMAC4 soap_in__turb1__GetBoxFilterGradientResponse(struct soap *soap, const char *tag, struct _turb1__GetBoxFilterGradientResponse *a, const char *type)
{
	size_t soap_flag_GetBoxFilterGradientResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetBoxFilterGradientResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetBoxFilterGradientResponse, sizeof(struct _turb1__GetBoxFilterGradientResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetBoxFilterGradientResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetBoxFilterGradientResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfVelocityGradient(soap, "turb1:GetBoxFilterGradientResult", &a->GetBoxFilterGradientResult, "turb1:ArrayOfVelocityGradient"))
				{	soap_flag_GetBoxFilterGradientResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetBoxFilterGradientResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetBoxFilterGradientResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetBoxFilterGradientResponse, 0, sizeof(struct _turb1__GetBoxFilterGradientResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetBoxFilterGradientResponse(struct soap *soap, const struct _turb1__GetBoxFilterGradientResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetBoxFilterGradientResponse);
	if (soap_out__turb1__GetBoxFilterGradientResponse(soap, tag?tag:"turb1:GetBoxFilterGradientResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetBoxFilterGradientResponse * SOAP_FMAC4 soap_get__turb1__GetBoxFilterGradientResponse(struct soap *soap, struct _turb1__GetBoxFilterGradientResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetBoxFilterGradientResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetBoxFilterGradient(struct soap *soap, struct _turb1__GetBoxFilterGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_string(soap, &a->field);
	soap_default_float(soap, &a->time);
	soap_default_float(soap, &a->filterwidth);
	soap_default_float(soap, &a->spacing);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetBoxFilterGradient(struct soap *soap, const struct _turb1__GetBoxFilterGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_string(soap, &a->field);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetBoxFilterGradient(struct soap *soap, const char *tag, int id, const struct _turb1__GetBoxFilterGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetBoxFilterGradient), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:field", -1, &a->field, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:filterwidth", -1, &a->filterwidth, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:spacing", -1, &a->spacing, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetBoxFilterGradient * SOAP_FMAC4 soap_in__turb1__GetBoxFilterGradient(struct soap *soap, const char *tag, struct _turb1__GetBoxFilterGradient *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_field = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_filterwidth = 1;
	size_t soap_flag_spacing = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetBoxFilterGradient *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetBoxFilterGradient, sizeof(struct _turb1__GetBoxFilterGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetBoxFilterGradient(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_field && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:field", &a->field, "xsd:string"))
				{	soap_flag_field--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_filterwidth && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:filterwidth", &a->filterwidth, "xsd:float"))
				{	soap_flag_filterwidth--;
					continue;
				}
			if (soap_flag_spacing && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:spacing", &a->spacing, "xsd:float"))
				{	soap_flag_spacing--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetBoxFilterGradient *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetBoxFilterGradient, 0, sizeof(struct _turb1__GetBoxFilterGradient), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_filterwidth > 0 || soap_flag_spacing > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetBoxFilterGradient(struct soap *soap, const struct _turb1__GetBoxFilterGradient *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetBoxFilterGradient);
	if (soap_out__turb1__GetBoxFilterGradient(soap, tag?tag:"turb1:GetBoxFilterGradient", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetBoxFilterGradient * SOAP_FMAC4 soap_get__turb1__GetBoxFilterGradient(struct soap *soap, struct _turb1__GetBoxFilterGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetBoxFilterGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetBoxFilterSGSResponse(struct soap *soap, struct _turb1__GetBoxFilterSGSResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetBoxFilterSGSResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetBoxFilterSGSResponse(struct soap *soap, const struct _turb1__GetBoxFilterSGSResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfSGSTensor(soap, &a->GetBoxFilterSGSResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetBoxFilterSGSResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetBoxFilterSGSResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetBoxFilterSGSResponse), type))
		return soap->error;
	if (a->GetBoxFilterSGSResult)
		soap_element_result(soap, "turb1:GetBoxFilterSGSResult");
	if (soap_out_PointerToturb1__ArrayOfSGSTensor(soap, "turb1:GetBoxFilterSGSResult", -1, &a->GetBoxFilterSGSResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetBoxFilterSGSResponse * SOAP_FMAC4 soap_in__turb1__GetBoxFilterSGSResponse(struct soap *soap, const char *tag, struct _turb1__GetBoxFilterSGSResponse *a, const char *type)
{
	size_t soap_flag_GetBoxFilterSGSResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetBoxFilterSGSResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetBoxFilterSGSResponse, sizeof(struct _turb1__GetBoxFilterSGSResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetBoxFilterSGSResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetBoxFilterSGSResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfSGSTensor(soap, "turb1:GetBoxFilterSGSResult", &a->GetBoxFilterSGSResult, "turb1:ArrayOfSGSTensor"))
				{	soap_flag_GetBoxFilterSGSResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetBoxFilterSGSResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetBoxFilterSGSResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetBoxFilterSGSResponse, 0, sizeof(struct _turb1__GetBoxFilterSGSResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetBoxFilterSGSResponse(struct soap *soap, const struct _turb1__GetBoxFilterSGSResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetBoxFilterSGSResponse);
	if (soap_out__turb1__GetBoxFilterSGSResponse(soap, tag?tag:"turb1:GetBoxFilterSGSResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetBoxFilterSGSResponse * SOAP_FMAC4 soap_get__turb1__GetBoxFilterSGSResponse(struct soap *soap, struct _turb1__GetBoxFilterSGSResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetBoxFilterSGSResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetBoxFilterSGS(struct soap *soap, struct _turb1__GetBoxFilterSGS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_string(soap, &a->field);
	soap_default_float(soap, &a->time);
	soap_default_float(soap, &a->filterwidth);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetBoxFilterSGS(struct soap *soap, const struct _turb1__GetBoxFilterSGS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_string(soap, &a->field);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetBoxFilterSGS(struct soap *soap, const char *tag, int id, const struct _turb1__GetBoxFilterSGS *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetBoxFilterSGS), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:field", -1, &a->field, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:filterwidth", -1, &a->filterwidth, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetBoxFilterSGS * SOAP_FMAC4 soap_in__turb1__GetBoxFilterSGS(struct soap *soap, const char *tag, struct _turb1__GetBoxFilterSGS *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_field = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_filterwidth = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetBoxFilterSGS *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetBoxFilterSGS, sizeof(struct _turb1__GetBoxFilterSGS), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetBoxFilterSGS(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_field && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:field", &a->field, "xsd:string"))
				{	soap_flag_field--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_filterwidth && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:filterwidth", &a->filterwidth, "xsd:float"))
				{	soap_flag_filterwidth--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetBoxFilterSGS *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetBoxFilterSGS, 0, sizeof(struct _turb1__GetBoxFilterSGS), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_filterwidth > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetBoxFilterSGS(struct soap *soap, const struct _turb1__GetBoxFilterSGS *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetBoxFilterSGS);
	if (soap_out__turb1__GetBoxFilterSGS(soap, tag?tag:"turb1:GetBoxFilterSGS", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetBoxFilterSGS * SOAP_FMAC4 soap_get__turb1__GetBoxFilterSGS(struct soap *soap, struct _turb1__GetBoxFilterSGS *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetBoxFilterSGS(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetBoxFilterResponse(struct soap *soap, struct _turb1__GetBoxFilterResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetBoxFilterResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetBoxFilterResponse(struct soap *soap, const struct _turb1__GetBoxFilterResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfVector3(soap, &a->GetBoxFilterResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetBoxFilterResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetBoxFilterResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetBoxFilterResponse), type))
		return soap->error;
	if (a->GetBoxFilterResult)
		soap_element_result(soap, "turb1:GetBoxFilterResult");
	if (soap_out_PointerToturb1__ArrayOfVector3(soap, "turb1:GetBoxFilterResult", -1, &a->GetBoxFilterResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetBoxFilterResponse * SOAP_FMAC4 soap_in__turb1__GetBoxFilterResponse(struct soap *soap, const char *tag, struct _turb1__GetBoxFilterResponse *a, const char *type)
{
	size_t soap_flag_GetBoxFilterResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetBoxFilterResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetBoxFilterResponse, sizeof(struct _turb1__GetBoxFilterResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetBoxFilterResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetBoxFilterResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfVector3(soap, "turb1:GetBoxFilterResult", &a->GetBoxFilterResult, "turb1:ArrayOfVector3"))
				{	soap_flag_GetBoxFilterResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetBoxFilterResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetBoxFilterResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetBoxFilterResponse, 0, sizeof(struct _turb1__GetBoxFilterResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetBoxFilterResponse(struct soap *soap, const struct _turb1__GetBoxFilterResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetBoxFilterResponse);
	if (soap_out__turb1__GetBoxFilterResponse(soap, tag?tag:"turb1:GetBoxFilterResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetBoxFilterResponse * SOAP_FMAC4 soap_get__turb1__GetBoxFilterResponse(struct soap *soap, struct _turb1__GetBoxFilterResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetBoxFilterResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetBoxFilter(struct soap *soap, struct _turb1__GetBoxFilter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_string(soap, &a->field);
	soap_default_float(soap, &a->time);
	soap_default_float(soap, &a->filterwidth);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetBoxFilter(struct soap *soap, const struct _turb1__GetBoxFilter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_string(soap, &a->field);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetBoxFilter(struct soap *soap, const char *tag, int id, const struct _turb1__GetBoxFilter *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetBoxFilter), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:field", -1, &a->field, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:filterwidth", -1, &a->filterwidth, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetBoxFilter * SOAP_FMAC4 soap_in__turb1__GetBoxFilter(struct soap *soap, const char *tag, struct _turb1__GetBoxFilter *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_field = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_filterwidth = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetBoxFilter *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetBoxFilter, sizeof(struct _turb1__GetBoxFilter), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetBoxFilter(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_field && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:field", &a->field, "xsd:string"))
				{	soap_flag_field--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_filterwidth && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:filterwidth", &a->filterwidth, "xsd:float"))
				{	soap_flag_filterwidth--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetBoxFilter *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetBoxFilter, 0, sizeof(struct _turb1__GetBoxFilter), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_filterwidth > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetBoxFilter(struct soap *soap, const struct _turb1__GetBoxFilter *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetBoxFilter);
	if (soap_out__turb1__GetBoxFilter(soap, tag?tag:"turb1:GetBoxFilter", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetBoxFilter * SOAP_FMAC4 soap_get__turb1__GetBoxFilter(struct soap *soap, struct _turb1__GetBoxFilter *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetBoxFilter(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetPositionResponse(struct soap *soap, struct _turb1__GetPositionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetPositionResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetPositionResponse(struct soap *soap, const struct _turb1__GetPositionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->GetPositionResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetPositionResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetPositionResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetPositionResponse), type))
		return soap->error;
	if (a->GetPositionResult)
		soap_element_result(soap, "turb1:GetPositionResult");
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:GetPositionResult", -1, &a->GetPositionResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetPositionResponse * SOAP_FMAC4 soap_in__turb1__GetPositionResponse(struct soap *soap, const char *tag, struct _turb1__GetPositionResponse *a, const char *type)
{
	size_t soap_flag_GetPositionResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetPositionResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetPositionResponse, sizeof(struct _turb1__GetPositionResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetPositionResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetPositionResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:GetPositionResult", &a->GetPositionResult, "turb1:ArrayOfPoint3"))
				{	soap_flag_GetPositionResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetPositionResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetPositionResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetPositionResponse, 0, sizeof(struct _turb1__GetPositionResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetPositionResponse(struct soap *soap, const struct _turb1__GetPositionResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetPositionResponse);
	if (soap_out__turb1__GetPositionResponse(soap, tag?tag:"turb1:GetPositionResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetPositionResponse * SOAP_FMAC4 soap_get__turb1__GetPositionResponse(struct soap *soap, struct _turb1__GetPositionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetPositionResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetPosition(struct soap *soap, struct _turb1__GetPosition *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->StartTime);
	soap_default_float(soap, &a->EndTime);
	soap_default_float(soap, &a->dt);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetPosition(struct soap *soap, const struct _turb1__GetPosition *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetPosition(struct soap *soap, const char *tag, int id, const struct _turb1__GetPosition *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetPosition), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:StartTime", -1, &a->StartTime, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:EndTime", -1, &a->EndTime, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:dt", -1, &a->dt, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetPosition * SOAP_FMAC4 soap_in__turb1__GetPosition(struct soap *soap, const char *tag, struct _turb1__GetPosition *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_StartTime = 1;
	size_t soap_flag_EndTime = 1;
	size_t soap_flag_dt = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetPosition *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetPosition, sizeof(struct _turb1__GetPosition), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetPosition(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_StartTime && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:StartTime", &a->StartTime, "xsd:float"))
				{	soap_flag_StartTime--;
					continue;
				}
			if (soap_flag_EndTime && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:EndTime", &a->EndTime, "xsd:float"))
				{	soap_flag_EndTime--;
					continue;
				}
			if (soap_flag_dt && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:dt", &a->dt, "xsd:float"))
				{	soap_flag_dt--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetPosition *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetPosition, 0, sizeof(struct _turb1__GetPosition), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_StartTime > 0 || soap_flag_EndTime > 0 || soap_flag_dt > 0 || soap_flag_spatialInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetPosition(struct soap *soap, const struct _turb1__GetPosition *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetPosition);
	if (soap_out__turb1__GetPosition(soap, tag?tag:"turb1:GetPosition", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetPosition * SOAP_FMAC4 soap_get__turb1__GetPosition(struct soap *soap, struct _turb1__GetPosition *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetPosition(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetVectorPotentialLaplacianResponse(struct soap *soap, struct _turb1__GetVectorPotentialLaplacianResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetVectorPotentialLaplacianResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetVectorPotentialLaplacianResponse(struct soap *soap, const struct _turb1__GetVectorPotentialLaplacianResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfVector3(soap, &a->GetVectorPotentialLaplacianResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetVectorPotentialLaplacianResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetVectorPotentialLaplacianResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetVectorPotentialLaplacianResponse), type))
		return soap->error;
	if (a->GetVectorPotentialLaplacianResult)
		soap_element_result(soap, "turb1:GetVectorPotentialLaplacianResult");
	if (soap_out_PointerToturb1__ArrayOfVector3(soap, "turb1:GetVectorPotentialLaplacianResult", -1, &a->GetVectorPotentialLaplacianResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialLaplacianResponse * SOAP_FMAC4 soap_in__turb1__GetVectorPotentialLaplacianResponse(struct soap *soap, const char *tag, struct _turb1__GetVectorPotentialLaplacianResponse *a, const char *type)
{
	size_t soap_flag_GetVectorPotentialLaplacianResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetVectorPotentialLaplacianResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetVectorPotentialLaplacianResponse, sizeof(struct _turb1__GetVectorPotentialLaplacianResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetVectorPotentialLaplacianResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetVectorPotentialLaplacianResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfVector3(soap, "turb1:GetVectorPotentialLaplacianResult", &a->GetVectorPotentialLaplacianResult, "turb1:ArrayOfVector3"))
				{	soap_flag_GetVectorPotentialLaplacianResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetVectorPotentialLaplacianResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVectorPotentialLaplacianResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetVectorPotentialLaplacianResponse, 0, sizeof(struct _turb1__GetVectorPotentialLaplacianResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetVectorPotentialLaplacianResponse(struct soap *soap, const struct _turb1__GetVectorPotentialLaplacianResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetVectorPotentialLaplacianResponse);
	if (soap_out__turb1__GetVectorPotentialLaplacianResponse(soap, tag?tag:"turb1:GetVectorPotentialLaplacianResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialLaplacianResponse * SOAP_FMAC4 soap_get__turb1__GetVectorPotentialLaplacianResponse(struct soap *soap, struct _turb1__GetVectorPotentialLaplacianResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetVectorPotentialLaplacianResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetVectorPotentialLaplacian(struct soap *soap, struct _turb1__GetVectorPotentialLaplacian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetVectorPotentialLaplacian(struct soap *soap, const struct _turb1__GetVectorPotentialLaplacian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetVectorPotentialLaplacian(struct soap *soap, const char *tag, int id, const struct _turb1__GetVectorPotentialLaplacian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetVectorPotentialLaplacian), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialLaplacian * SOAP_FMAC4 soap_in__turb1__GetVectorPotentialLaplacian(struct soap *soap, const char *tag, struct _turb1__GetVectorPotentialLaplacian *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetVectorPotentialLaplacian *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetVectorPotentialLaplacian, sizeof(struct _turb1__GetVectorPotentialLaplacian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetVectorPotentialLaplacian(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVectorPotentialLaplacian *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetVectorPotentialLaplacian, 0, sizeof(struct _turb1__GetVectorPotentialLaplacian), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetVectorPotentialLaplacian(struct soap *soap, const struct _turb1__GetVectorPotentialLaplacian *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetVectorPotentialLaplacian);
	if (soap_out__turb1__GetVectorPotentialLaplacian(soap, tag?tag:"turb1:GetVectorPotentialLaplacian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialLaplacian * SOAP_FMAC4 soap_get__turb1__GetVectorPotentialLaplacian(struct soap *soap, struct _turb1__GetVectorPotentialLaplacian *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetVectorPotentialLaplacian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetMagneticFieldLaplacianResponse(struct soap *soap, struct _turb1__GetMagneticFieldLaplacianResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetMagneticFieldLaplacianResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetMagneticFieldLaplacianResponse(struct soap *soap, const struct _turb1__GetMagneticFieldLaplacianResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfVector3(soap, &a->GetMagneticFieldLaplacianResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetMagneticFieldLaplacianResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetMagneticFieldLaplacianResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetMagneticFieldLaplacianResponse), type))
		return soap->error;
	if (a->GetMagneticFieldLaplacianResult)
		soap_element_result(soap, "turb1:GetMagneticFieldLaplacianResult");
	if (soap_out_PointerToturb1__ArrayOfVector3(soap, "turb1:GetMagneticFieldLaplacianResult", -1, &a->GetMagneticFieldLaplacianResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetMagneticFieldLaplacianResponse * SOAP_FMAC4 soap_in__turb1__GetMagneticFieldLaplacianResponse(struct soap *soap, const char *tag, struct _turb1__GetMagneticFieldLaplacianResponse *a, const char *type)
{
	size_t soap_flag_GetMagneticFieldLaplacianResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetMagneticFieldLaplacianResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetMagneticFieldLaplacianResponse, sizeof(struct _turb1__GetMagneticFieldLaplacianResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetMagneticFieldLaplacianResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetMagneticFieldLaplacianResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfVector3(soap, "turb1:GetMagneticFieldLaplacianResult", &a->GetMagneticFieldLaplacianResult, "turb1:ArrayOfVector3"))
				{	soap_flag_GetMagneticFieldLaplacianResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetMagneticFieldLaplacianResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetMagneticFieldLaplacianResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetMagneticFieldLaplacianResponse, 0, sizeof(struct _turb1__GetMagneticFieldLaplacianResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetMagneticFieldLaplacianResponse(struct soap *soap, const struct _turb1__GetMagneticFieldLaplacianResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetMagneticFieldLaplacianResponse);
	if (soap_out__turb1__GetMagneticFieldLaplacianResponse(soap, tag?tag:"turb1:GetMagneticFieldLaplacianResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetMagneticFieldLaplacianResponse * SOAP_FMAC4 soap_get__turb1__GetMagneticFieldLaplacianResponse(struct soap *soap, struct _turb1__GetMagneticFieldLaplacianResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetMagneticFieldLaplacianResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetMagneticFieldLaplacian(struct soap *soap, struct _turb1__GetMagneticFieldLaplacian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetMagneticFieldLaplacian(struct soap *soap, const struct _turb1__GetMagneticFieldLaplacian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetMagneticFieldLaplacian(struct soap *soap, const char *tag, int id, const struct _turb1__GetMagneticFieldLaplacian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetMagneticFieldLaplacian), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetMagneticFieldLaplacian * SOAP_FMAC4 soap_in__turb1__GetMagneticFieldLaplacian(struct soap *soap, const char *tag, struct _turb1__GetMagneticFieldLaplacian *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetMagneticFieldLaplacian *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetMagneticFieldLaplacian, sizeof(struct _turb1__GetMagneticFieldLaplacian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetMagneticFieldLaplacian(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetMagneticFieldLaplacian *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetMagneticFieldLaplacian, 0, sizeof(struct _turb1__GetMagneticFieldLaplacian), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetMagneticFieldLaplacian(struct soap *soap, const struct _turb1__GetMagneticFieldLaplacian *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetMagneticFieldLaplacian);
	if (soap_out__turb1__GetMagneticFieldLaplacian(soap, tag?tag:"turb1:GetMagneticFieldLaplacian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetMagneticFieldLaplacian * SOAP_FMAC4 soap_get__turb1__GetMagneticFieldLaplacian(struct soap *soap, struct _turb1__GetMagneticFieldLaplacian *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetMagneticFieldLaplacian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetVelocityLaplacianResponse(struct soap *soap, struct _turb1__GetVelocityLaplacianResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetVelocityLaplacianResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetVelocityLaplacianResponse(struct soap *soap, const struct _turb1__GetVelocityLaplacianResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfVector3(soap, &a->GetVelocityLaplacianResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetVelocityLaplacianResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetVelocityLaplacianResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetVelocityLaplacianResponse), type))
		return soap->error;
	if (a->GetVelocityLaplacianResult)
		soap_element_result(soap, "turb1:GetVelocityLaplacianResult");
	if (soap_out_PointerToturb1__ArrayOfVector3(soap, "turb1:GetVelocityLaplacianResult", -1, &a->GetVelocityLaplacianResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetVelocityLaplacianResponse * SOAP_FMAC4 soap_in__turb1__GetVelocityLaplacianResponse(struct soap *soap, const char *tag, struct _turb1__GetVelocityLaplacianResponse *a, const char *type)
{
	size_t soap_flag_GetVelocityLaplacianResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetVelocityLaplacianResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetVelocityLaplacianResponse, sizeof(struct _turb1__GetVelocityLaplacianResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetVelocityLaplacianResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetVelocityLaplacianResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfVector3(soap, "turb1:GetVelocityLaplacianResult", &a->GetVelocityLaplacianResult, "turb1:ArrayOfVector3"))
				{	soap_flag_GetVelocityLaplacianResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetVelocityLaplacianResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityLaplacianResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetVelocityLaplacianResponse, 0, sizeof(struct _turb1__GetVelocityLaplacianResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetVelocityLaplacianResponse(struct soap *soap, const struct _turb1__GetVelocityLaplacianResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetVelocityLaplacianResponse);
	if (soap_out__turb1__GetVelocityLaplacianResponse(soap, tag?tag:"turb1:GetVelocityLaplacianResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityLaplacianResponse * SOAP_FMAC4 soap_get__turb1__GetVelocityLaplacianResponse(struct soap *soap, struct _turb1__GetVelocityLaplacianResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetVelocityLaplacianResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetVelocityLaplacian(struct soap *soap, struct _turb1__GetVelocityLaplacian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetVelocityLaplacian(struct soap *soap, const struct _turb1__GetVelocityLaplacian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetVelocityLaplacian(struct soap *soap, const char *tag, int id, const struct _turb1__GetVelocityLaplacian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetVelocityLaplacian), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetVelocityLaplacian * SOAP_FMAC4 soap_in__turb1__GetVelocityLaplacian(struct soap *soap, const char *tag, struct _turb1__GetVelocityLaplacian *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetVelocityLaplacian *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetVelocityLaplacian, sizeof(struct _turb1__GetVelocityLaplacian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetVelocityLaplacian(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityLaplacian *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetVelocityLaplacian, 0, sizeof(struct _turb1__GetVelocityLaplacian), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetVelocityLaplacian(struct soap *soap, const struct _turb1__GetVelocityLaplacian *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetVelocityLaplacian);
	if (soap_out__turb1__GetVelocityLaplacian(soap, tag?tag:"turb1:GetVelocityLaplacian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityLaplacian * SOAP_FMAC4 soap_get__turb1__GetVelocityLaplacian(struct soap *soap, struct _turb1__GetVelocityLaplacian *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetVelocityLaplacian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetVectorPotentialHessianResponse(struct soap *soap, struct _turb1__GetVectorPotentialHessianResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetVectorPotentialHessianResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetVectorPotentialHessianResponse(struct soap *soap, const struct _turb1__GetVectorPotentialHessianResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfVelocityHessian(soap, &a->GetVectorPotentialHessianResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetVectorPotentialHessianResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetVectorPotentialHessianResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetVectorPotentialHessianResponse), type))
		return soap->error;
	if (a->GetVectorPotentialHessianResult)
		soap_element_result(soap, "turb1:GetVectorPotentialHessianResult");
	if (soap_out_PointerToturb1__ArrayOfVelocityHessian(soap, "turb1:GetVectorPotentialHessianResult", -1, &a->GetVectorPotentialHessianResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialHessianResponse * SOAP_FMAC4 soap_in__turb1__GetVectorPotentialHessianResponse(struct soap *soap, const char *tag, struct _turb1__GetVectorPotentialHessianResponse *a, const char *type)
{
	size_t soap_flag_GetVectorPotentialHessianResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetVectorPotentialHessianResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetVectorPotentialHessianResponse, sizeof(struct _turb1__GetVectorPotentialHessianResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetVectorPotentialHessianResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetVectorPotentialHessianResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfVelocityHessian(soap, "turb1:GetVectorPotentialHessianResult", &a->GetVectorPotentialHessianResult, "turb1:ArrayOfVelocityHessian"))
				{	soap_flag_GetVectorPotentialHessianResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetVectorPotentialHessianResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVectorPotentialHessianResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetVectorPotentialHessianResponse, 0, sizeof(struct _turb1__GetVectorPotentialHessianResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetVectorPotentialHessianResponse(struct soap *soap, const struct _turb1__GetVectorPotentialHessianResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetVectorPotentialHessianResponse);
	if (soap_out__turb1__GetVectorPotentialHessianResponse(soap, tag?tag:"turb1:GetVectorPotentialHessianResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialHessianResponse * SOAP_FMAC4 soap_get__turb1__GetVectorPotentialHessianResponse(struct soap *soap, struct _turb1__GetVectorPotentialHessianResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetVectorPotentialHessianResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetVectorPotentialHessian(struct soap *soap, struct _turb1__GetVectorPotentialHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetVectorPotentialHessian(struct soap *soap, const struct _turb1__GetVectorPotentialHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetVectorPotentialHessian(struct soap *soap, const char *tag, int id, const struct _turb1__GetVectorPotentialHessian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetVectorPotentialHessian), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialHessian * SOAP_FMAC4 soap_in__turb1__GetVectorPotentialHessian(struct soap *soap, const char *tag, struct _turb1__GetVectorPotentialHessian *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetVectorPotentialHessian *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetVectorPotentialHessian, sizeof(struct _turb1__GetVectorPotentialHessian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetVectorPotentialHessian(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVectorPotentialHessian *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetVectorPotentialHessian, 0, sizeof(struct _turb1__GetVectorPotentialHessian), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetVectorPotentialHessian(struct soap *soap, const struct _turb1__GetVectorPotentialHessian *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetVectorPotentialHessian);
	if (soap_out__turb1__GetVectorPotentialHessian(soap, tag?tag:"turb1:GetVectorPotentialHessian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialHessian * SOAP_FMAC4 soap_get__turb1__GetVectorPotentialHessian(struct soap *soap, struct _turb1__GetVectorPotentialHessian *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetVectorPotentialHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetMagneticHessianResponse(struct soap *soap, struct _turb1__GetMagneticHessianResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetMagneticHessianResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetMagneticHessianResponse(struct soap *soap, const struct _turb1__GetMagneticHessianResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfVelocityHessian(soap, &a->GetMagneticHessianResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetMagneticHessianResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetMagneticHessianResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetMagneticHessianResponse), type))
		return soap->error;
	if (a->GetMagneticHessianResult)
		soap_element_result(soap, "turb1:GetMagneticHessianResult");
	if (soap_out_PointerToturb1__ArrayOfVelocityHessian(soap, "turb1:GetMagneticHessianResult", -1, &a->GetMagneticHessianResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetMagneticHessianResponse * SOAP_FMAC4 soap_in__turb1__GetMagneticHessianResponse(struct soap *soap, const char *tag, struct _turb1__GetMagneticHessianResponse *a, const char *type)
{
	size_t soap_flag_GetMagneticHessianResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetMagneticHessianResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetMagneticHessianResponse, sizeof(struct _turb1__GetMagneticHessianResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetMagneticHessianResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetMagneticHessianResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfVelocityHessian(soap, "turb1:GetMagneticHessianResult", &a->GetMagneticHessianResult, "turb1:ArrayOfVelocityHessian"))
				{	soap_flag_GetMagneticHessianResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetMagneticHessianResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetMagneticHessianResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetMagneticHessianResponse, 0, sizeof(struct _turb1__GetMagneticHessianResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetMagneticHessianResponse(struct soap *soap, const struct _turb1__GetMagneticHessianResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetMagneticHessianResponse);
	if (soap_out__turb1__GetMagneticHessianResponse(soap, tag?tag:"turb1:GetMagneticHessianResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetMagneticHessianResponse * SOAP_FMAC4 soap_get__turb1__GetMagneticHessianResponse(struct soap *soap, struct _turb1__GetMagneticHessianResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetMagneticHessianResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetMagneticHessian(struct soap *soap, struct _turb1__GetMagneticHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetMagneticHessian(struct soap *soap, const struct _turb1__GetMagneticHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetMagneticHessian(struct soap *soap, const char *tag, int id, const struct _turb1__GetMagneticHessian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetMagneticHessian), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetMagneticHessian * SOAP_FMAC4 soap_in__turb1__GetMagneticHessian(struct soap *soap, const char *tag, struct _turb1__GetMagneticHessian *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetMagneticHessian *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetMagneticHessian, sizeof(struct _turb1__GetMagneticHessian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetMagneticHessian(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetMagneticHessian *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetMagneticHessian, 0, sizeof(struct _turb1__GetMagneticHessian), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetMagneticHessian(struct soap *soap, const struct _turb1__GetMagneticHessian *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetMagneticHessian);
	if (soap_out__turb1__GetMagneticHessian(soap, tag?tag:"turb1:GetMagneticHessian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetMagneticHessian * SOAP_FMAC4 soap_get__turb1__GetMagneticHessian(struct soap *soap, struct _turb1__GetMagneticHessian *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetMagneticHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetVelocityHessianResponse(struct soap *soap, struct _turb1__GetVelocityHessianResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetVelocityHessianResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetVelocityHessianResponse(struct soap *soap, const struct _turb1__GetVelocityHessianResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfVelocityHessian(soap, &a->GetVelocityHessianResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetVelocityHessianResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetVelocityHessianResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetVelocityHessianResponse), type))
		return soap->error;
	if (a->GetVelocityHessianResult)
		soap_element_result(soap, "turb1:GetVelocityHessianResult");
	if (soap_out_PointerToturb1__ArrayOfVelocityHessian(soap, "turb1:GetVelocityHessianResult", -1, &a->GetVelocityHessianResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetVelocityHessianResponse * SOAP_FMAC4 soap_in__turb1__GetVelocityHessianResponse(struct soap *soap, const char *tag, struct _turb1__GetVelocityHessianResponse *a, const char *type)
{
	size_t soap_flag_GetVelocityHessianResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetVelocityHessianResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetVelocityHessianResponse, sizeof(struct _turb1__GetVelocityHessianResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetVelocityHessianResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetVelocityHessianResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfVelocityHessian(soap, "turb1:GetVelocityHessianResult", &a->GetVelocityHessianResult, "turb1:ArrayOfVelocityHessian"))
				{	soap_flag_GetVelocityHessianResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetVelocityHessianResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityHessianResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetVelocityHessianResponse, 0, sizeof(struct _turb1__GetVelocityHessianResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetVelocityHessianResponse(struct soap *soap, const struct _turb1__GetVelocityHessianResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetVelocityHessianResponse);
	if (soap_out__turb1__GetVelocityHessianResponse(soap, tag?tag:"turb1:GetVelocityHessianResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityHessianResponse * SOAP_FMAC4 soap_get__turb1__GetVelocityHessianResponse(struct soap *soap, struct _turb1__GetVelocityHessianResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetVelocityHessianResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetVelocityHessian(struct soap *soap, struct _turb1__GetVelocityHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetVelocityHessian(struct soap *soap, const struct _turb1__GetVelocityHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetVelocityHessian(struct soap *soap, const char *tag, int id, const struct _turb1__GetVelocityHessian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetVelocityHessian), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetVelocityHessian * SOAP_FMAC4 soap_in__turb1__GetVelocityHessian(struct soap *soap, const char *tag, struct _turb1__GetVelocityHessian *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetVelocityHessian *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetVelocityHessian, sizeof(struct _turb1__GetVelocityHessian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetVelocityHessian(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityHessian *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetVelocityHessian, 0, sizeof(struct _turb1__GetVelocityHessian), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetVelocityHessian(struct soap *soap, const struct _turb1__GetVelocityHessian *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetVelocityHessian);
	if (soap_out__turb1__GetVelocityHessian(soap, tag?tag:"turb1:GetVelocityHessian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityHessian * SOAP_FMAC4 soap_get__turb1__GetVelocityHessian(struct soap *soap, struct _turb1__GetVelocityHessian *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetVelocityHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetPressureHessianResponse(struct soap *soap, struct _turb1__GetPressureHessianResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetPressureHessianResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetPressureHessianResponse(struct soap *soap, const struct _turb1__GetPressureHessianResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfPressureHessian(soap, &a->GetPressureHessianResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetPressureHessianResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetPressureHessianResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetPressureHessianResponse), type))
		return soap->error;
	if (a->GetPressureHessianResult)
		soap_element_result(soap, "turb1:GetPressureHessianResult");
	if (soap_out_PointerToturb1__ArrayOfPressureHessian(soap, "turb1:GetPressureHessianResult", -1, &a->GetPressureHessianResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetPressureHessianResponse * SOAP_FMAC4 soap_in__turb1__GetPressureHessianResponse(struct soap *soap, const char *tag, struct _turb1__GetPressureHessianResponse *a, const char *type)
{
	size_t soap_flag_GetPressureHessianResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetPressureHessianResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetPressureHessianResponse, sizeof(struct _turb1__GetPressureHessianResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetPressureHessianResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetPressureHessianResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPressureHessian(soap, "turb1:GetPressureHessianResult", &a->GetPressureHessianResult, "turb1:ArrayOfPressureHessian"))
				{	soap_flag_GetPressureHessianResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetPressureHessianResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetPressureHessianResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetPressureHessianResponse, 0, sizeof(struct _turb1__GetPressureHessianResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetPressureHessianResponse(struct soap *soap, const struct _turb1__GetPressureHessianResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetPressureHessianResponse);
	if (soap_out__turb1__GetPressureHessianResponse(soap, tag?tag:"turb1:GetPressureHessianResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetPressureHessianResponse * SOAP_FMAC4 soap_get__turb1__GetPressureHessianResponse(struct soap *soap, struct _turb1__GetPressureHessianResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetPressureHessianResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetPressureHessian(struct soap *soap, struct _turb1__GetPressureHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetPressureHessian(struct soap *soap, const struct _turb1__GetPressureHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetPressureHessian(struct soap *soap, const char *tag, int id, const struct _turb1__GetPressureHessian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetPressureHessian), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetPressureHessian * SOAP_FMAC4 soap_in__turb1__GetPressureHessian(struct soap *soap, const char *tag, struct _turb1__GetPressureHessian *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetPressureHessian *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetPressureHessian, sizeof(struct _turb1__GetPressureHessian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetPressureHessian(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetPressureHessian *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetPressureHessian, 0, sizeof(struct _turb1__GetPressureHessian), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetPressureHessian(struct soap *soap, const struct _turb1__GetPressureHessian *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetPressureHessian);
	if (soap_out__turb1__GetPressureHessian(soap, tag?tag:"turb1:GetPressureHessian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetPressureHessian * SOAP_FMAC4 soap_get__turb1__GetPressureHessian(struct soap *soap, struct _turb1__GetPressureHessian *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetPressureHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetPressureGradientResponse(struct soap *soap, struct _turb1__GetPressureGradientResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetPressureGradientResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetPressureGradientResponse(struct soap *soap, const struct _turb1__GetPressureGradientResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfVector3(soap, &a->GetPressureGradientResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetPressureGradientResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetPressureGradientResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetPressureGradientResponse), type))
		return soap->error;
	if (a->GetPressureGradientResult)
		soap_element_result(soap, "turb1:GetPressureGradientResult");
	if (soap_out_PointerToturb1__ArrayOfVector3(soap, "turb1:GetPressureGradientResult", -1, &a->GetPressureGradientResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetPressureGradientResponse * SOAP_FMAC4 soap_in__turb1__GetPressureGradientResponse(struct soap *soap, const char *tag, struct _turb1__GetPressureGradientResponse *a, const char *type)
{
	size_t soap_flag_GetPressureGradientResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetPressureGradientResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetPressureGradientResponse, sizeof(struct _turb1__GetPressureGradientResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetPressureGradientResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetPressureGradientResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfVector3(soap, "turb1:GetPressureGradientResult", &a->GetPressureGradientResult, "turb1:ArrayOfVector3"))
				{	soap_flag_GetPressureGradientResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetPressureGradientResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetPressureGradientResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetPressureGradientResponse, 0, sizeof(struct _turb1__GetPressureGradientResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetPressureGradientResponse(struct soap *soap, const struct _turb1__GetPressureGradientResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetPressureGradientResponse);
	if (soap_out__turb1__GetPressureGradientResponse(soap, tag?tag:"turb1:GetPressureGradientResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetPressureGradientResponse * SOAP_FMAC4 soap_get__turb1__GetPressureGradientResponse(struct soap *soap, struct _turb1__GetPressureGradientResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetPressureGradientResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetPressureGradient(struct soap *soap, struct _turb1__GetPressureGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetPressureGradient(struct soap *soap, const struct _turb1__GetPressureGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetPressureGradient(struct soap *soap, const char *tag, int id, const struct _turb1__GetPressureGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetPressureGradient), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetPressureGradient * SOAP_FMAC4 soap_in__turb1__GetPressureGradient(struct soap *soap, const char *tag, struct _turb1__GetPressureGradient *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetPressureGradient *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetPressureGradient, sizeof(struct _turb1__GetPressureGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetPressureGradient(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetPressureGradient *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetPressureGradient, 0, sizeof(struct _turb1__GetPressureGradient), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetPressureGradient(struct soap *soap, const struct _turb1__GetPressureGradient *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetPressureGradient);
	if (soap_out__turb1__GetPressureGradient(soap, tag?tag:"turb1:GetPressureGradient", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetPressureGradient * SOAP_FMAC4 soap_get__turb1__GetPressureGradient(struct soap *soap, struct _turb1__GetPressureGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetPressureGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetVectorPotentialGradientResponse(struct soap *soap, struct _turb1__GetVectorPotentialGradientResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetVectorPotentialGradientResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetVectorPotentialGradientResponse(struct soap *soap, const struct _turb1__GetVectorPotentialGradientResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfVelocityGradient(soap, &a->GetVectorPotentialGradientResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetVectorPotentialGradientResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetVectorPotentialGradientResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetVectorPotentialGradientResponse), type))
		return soap->error;
	if (a->GetVectorPotentialGradientResult)
		soap_element_result(soap, "turb1:GetVectorPotentialGradientResult");
	if (soap_out_PointerToturb1__ArrayOfVelocityGradient(soap, "turb1:GetVectorPotentialGradientResult", -1, &a->GetVectorPotentialGradientResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialGradientResponse * SOAP_FMAC4 soap_in__turb1__GetVectorPotentialGradientResponse(struct soap *soap, const char *tag, struct _turb1__GetVectorPotentialGradientResponse *a, const char *type)
{
	size_t soap_flag_GetVectorPotentialGradientResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetVectorPotentialGradientResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetVectorPotentialGradientResponse, sizeof(struct _turb1__GetVectorPotentialGradientResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetVectorPotentialGradientResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetVectorPotentialGradientResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfVelocityGradient(soap, "turb1:GetVectorPotentialGradientResult", &a->GetVectorPotentialGradientResult, "turb1:ArrayOfVelocityGradient"))
				{	soap_flag_GetVectorPotentialGradientResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetVectorPotentialGradientResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVectorPotentialGradientResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetVectorPotentialGradientResponse, 0, sizeof(struct _turb1__GetVectorPotentialGradientResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetVectorPotentialGradientResponse(struct soap *soap, const struct _turb1__GetVectorPotentialGradientResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetVectorPotentialGradientResponse);
	if (soap_out__turb1__GetVectorPotentialGradientResponse(soap, tag?tag:"turb1:GetVectorPotentialGradientResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialGradientResponse * SOAP_FMAC4 soap_get__turb1__GetVectorPotentialGradientResponse(struct soap *soap, struct _turb1__GetVectorPotentialGradientResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetVectorPotentialGradientResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetVectorPotentialGradient(struct soap *soap, struct _turb1__GetVectorPotentialGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetVectorPotentialGradient(struct soap *soap, const struct _turb1__GetVectorPotentialGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetVectorPotentialGradient(struct soap *soap, const char *tag, int id, const struct _turb1__GetVectorPotentialGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetVectorPotentialGradient), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialGradient * SOAP_FMAC4 soap_in__turb1__GetVectorPotentialGradient(struct soap *soap, const char *tag, struct _turb1__GetVectorPotentialGradient *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetVectorPotentialGradient *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetVectorPotentialGradient, sizeof(struct _turb1__GetVectorPotentialGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetVectorPotentialGradient(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVectorPotentialGradient *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetVectorPotentialGradient, 0, sizeof(struct _turb1__GetVectorPotentialGradient), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetVectorPotentialGradient(struct soap *soap, const struct _turb1__GetVectorPotentialGradient *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetVectorPotentialGradient);
	if (soap_out__turb1__GetVectorPotentialGradient(soap, tag?tag:"turb1:GetVectorPotentialGradient", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialGradient * SOAP_FMAC4 soap_get__turb1__GetVectorPotentialGradient(struct soap *soap, struct _turb1__GetVectorPotentialGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetVectorPotentialGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetMagneticFieldGradientResponse(struct soap *soap, struct _turb1__GetMagneticFieldGradientResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetMagneticFieldGradientResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetMagneticFieldGradientResponse(struct soap *soap, const struct _turb1__GetMagneticFieldGradientResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfVelocityGradient(soap, &a->GetMagneticFieldGradientResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetMagneticFieldGradientResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetMagneticFieldGradientResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetMagneticFieldGradientResponse), type))
		return soap->error;
	if (a->GetMagneticFieldGradientResult)
		soap_element_result(soap, "turb1:GetMagneticFieldGradientResult");
	if (soap_out_PointerToturb1__ArrayOfVelocityGradient(soap, "turb1:GetMagneticFieldGradientResult", -1, &a->GetMagneticFieldGradientResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetMagneticFieldGradientResponse * SOAP_FMAC4 soap_in__turb1__GetMagneticFieldGradientResponse(struct soap *soap, const char *tag, struct _turb1__GetMagneticFieldGradientResponse *a, const char *type)
{
	size_t soap_flag_GetMagneticFieldGradientResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetMagneticFieldGradientResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetMagneticFieldGradientResponse, sizeof(struct _turb1__GetMagneticFieldGradientResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetMagneticFieldGradientResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetMagneticFieldGradientResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfVelocityGradient(soap, "turb1:GetMagneticFieldGradientResult", &a->GetMagneticFieldGradientResult, "turb1:ArrayOfVelocityGradient"))
				{	soap_flag_GetMagneticFieldGradientResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetMagneticFieldGradientResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetMagneticFieldGradientResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetMagneticFieldGradientResponse, 0, sizeof(struct _turb1__GetMagneticFieldGradientResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetMagneticFieldGradientResponse(struct soap *soap, const struct _turb1__GetMagneticFieldGradientResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetMagneticFieldGradientResponse);
	if (soap_out__turb1__GetMagneticFieldGradientResponse(soap, tag?tag:"turb1:GetMagneticFieldGradientResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetMagneticFieldGradientResponse * SOAP_FMAC4 soap_get__turb1__GetMagneticFieldGradientResponse(struct soap *soap, struct _turb1__GetMagneticFieldGradientResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetMagneticFieldGradientResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetMagneticFieldGradient(struct soap *soap, struct _turb1__GetMagneticFieldGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetMagneticFieldGradient(struct soap *soap, const struct _turb1__GetMagneticFieldGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetMagneticFieldGradient(struct soap *soap, const char *tag, int id, const struct _turb1__GetMagneticFieldGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetMagneticFieldGradient), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetMagneticFieldGradient * SOAP_FMAC4 soap_in__turb1__GetMagneticFieldGradient(struct soap *soap, const char *tag, struct _turb1__GetMagneticFieldGradient *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetMagneticFieldGradient *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetMagneticFieldGradient, sizeof(struct _turb1__GetMagneticFieldGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetMagneticFieldGradient(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetMagneticFieldGradient *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetMagneticFieldGradient, 0, sizeof(struct _turb1__GetMagneticFieldGradient), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetMagneticFieldGradient(struct soap *soap, const struct _turb1__GetMagneticFieldGradient *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetMagneticFieldGradient);
	if (soap_out__turb1__GetMagneticFieldGradient(soap, tag?tag:"turb1:GetMagneticFieldGradient", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetMagneticFieldGradient * SOAP_FMAC4 soap_get__turb1__GetMagneticFieldGradient(struct soap *soap, struct _turb1__GetMagneticFieldGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetMagneticFieldGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetVelocityGradientResponse(struct soap *soap, struct _turb1__GetVelocityGradientResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetVelocityGradientResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetVelocityGradientResponse(struct soap *soap, const struct _turb1__GetVelocityGradientResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfVelocityGradient(soap, &a->GetVelocityGradientResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetVelocityGradientResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetVelocityGradientResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetVelocityGradientResponse), type))
		return soap->error;
	if (a->GetVelocityGradientResult)
		soap_element_result(soap, "turb1:GetVelocityGradientResult");
	if (soap_out_PointerToturb1__ArrayOfVelocityGradient(soap, "turb1:GetVelocityGradientResult", -1, &a->GetVelocityGradientResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetVelocityGradientResponse * SOAP_FMAC4 soap_in__turb1__GetVelocityGradientResponse(struct soap *soap, const char *tag, struct _turb1__GetVelocityGradientResponse *a, const char *type)
{
	size_t soap_flag_GetVelocityGradientResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetVelocityGradientResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetVelocityGradientResponse, sizeof(struct _turb1__GetVelocityGradientResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetVelocityGradientResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetVelocityGradientResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfVelocityGradient(soap, "turb1:GetVelocityGradientResult", &a->GetVelocityGradientResult, "turb1:ArrayOfVelocityGradient"))
				{	soap_flag_GetVelocityGradientResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetVelocityGradientResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityGradientResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetVelocityGradientResponse, 0, sizeof(struct _turb1__GetVelocityGradientResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetVelocityGradientResponse(struct soap *soap, const struct _turb1__GetVelocityGradientResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetVelocityGradientResponse);
	if (soap_out__turb1__GetVelocityGradientResponse(soap, tag?tag:"turb1:GetVelocityGradientResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityGradientResponse * SOAP_FMAC4 soap_get__turb1__GetVelocityGradientResponse(struct soap *soap, struct _turb1__GetVelocityGradientResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetVelocityGradientResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetVelocityGradient(struct soap *soap, struct _turb1__GetVelocityGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetVelocityGradient(struct soap *soap, const struct _turb1__GetVelocityGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetVelocityGradient(struct soap *soap, const char *tag, int id, const struct _turb1__GetVelocityGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetVelocityGradient), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetVelocityGradient * SOAP_FMAC4 soap_in__turb1__GetVelocityGradient(struct soap *soap, const char *tag, struct _turb1__GetVelocityGradient *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetVelocityGradient *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetVelocityGradient, sizeof(struct _turb1__GetVelocityGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetVelocityGradient(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityGradient *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetVelocityGradient, 0, sizeof(struct _turb1__GetVelocityGradient), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetVelocityGradient(struct soap *soap, const struct _turb1__GetVelocityGradient *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetVelocityGradient);
	if (soap_out__turb1__GetVelocityGradient(soap, tag?tag:"turb1:GetVelocityGradient", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityGradient * SOAP_FMAC4 soap_get__turb1__GetVelocityGradient(struct soap *soap, struct _turb1__GetVelocityGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetVelocityGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetVelocityAndPressureResponse(struct soap *soap, struct _turb1__GetVelocityAndPressureResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetVelocityAndPressureResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetVelocityAndPressureResponse(struct soap *soap, const struct _turb1__GetVelocityAndPressureResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfVector3P(soap, &a->GetVelocityAndPressureResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetVelocityAndPressureResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetVelocityAndPressureResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetVelocityAndPressureResponse), type))
		return soap->error;
	if (a->GetVelocityAndPressureResult)
		soap_element_result(soap, "turb1:GetVelocityAndPressureResult");
	if (soap_out_PointerToturb1__ArrayOfVector3P(soap, "turb1:GetVelocityAndPressureResult", -1, &a->GetVelocityAndPressureResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetVelocityAndPressureResponse * SOAP_FMAC4 soap_in__turb1__GetVelocityAndPressureResponse(struct soap *soap, const char *tag, struct _turb1__GetVelocityAndPressureResponse *a, const char *type)
{
	size_t soap_flag_GetVelocityAndPressureResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetVelocityAndPressureResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetVelocityAndPressureResponse, sizeof(struct _turb1__GetVelocityAndPressureResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetVelocityAndPressureResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetVelocityAndPressureResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfVector3P(soap, "turb1:GetVelocityAndPressureResult", &a->GetVelocityAndPressureResult, "turb1:ArrayOfVector3P"))
				{	soap_flag_GetVelocityAndPressureResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetVelocityAndPressureResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityAndPressureResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetVelocityAndPressureResponse, 0, sizeof(struct _turb1__GetVelocityAndPressureResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetVelocityAndPressureResponse(struct soap *soap, const struct _turb1__GetVelocityAndPressureResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetVelocityAndPressureResponse);
	if (soap_out__turb1__GetVelocityAndPressureResponse(soap, tag?tag:"turb1:GetVelocityAndPressureResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityAndPressureResponse * SOAP_FMAC4 soap_get__turb1__GetVelocityAndPressureResponse(struct soap *soap, struct _turb1__GetVelocityAndPressureResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetVelocityAndPressureResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetVelocityAndPressure(struct soap *soap, struct _turb1__GetVelocityAndPressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetVelocityAndPressure(struct soap *soap, const struct _turb1__GetVelocityAndPressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetVelocityAndPressure(struct soap *soap, const char *tag, int id, const struct _turb1__GetVelocityAndPressure *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetVelocityAndPressure), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetVelocityAndPressure * SOAP_FMAC4 soap_in__turb1__GetVelocityAndPressure(struct soap *soap, const char *tag, struct _turb1__GetVelocityAndPressure *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetVelocityAndPressure *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetVelocityAndPressure, sizeof(struct _turb1__GetVelocityAndPressure), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetVelocityAndPressure(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityAndPressure *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetVelocityAndPressure, 0, sizeof(struct _turb1__GetVelocityAndPressure), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetVelocityAndPressure(struct soap *soap, const struct _turb1__GetVelocityAndPressure *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetVelocityAndPressure);
	if (soap_out__turb1__GetVelocityAndPressure(soap, tag?tag:"turb1:GetVelocityAndPressure", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityAndPressure * SOAP_FMAC4 soap_get__turb1__GetVelocityAndPressure(struct soap *soap, struct _turb1__GetVelocityAndPressure *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetVelocityAndPressure(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetForceResponse(struct soap *soap, struct _turb1__GetForceResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetForceResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetForceResponse(struct soap *soap, const struct _turb1__GetForceResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfVector3(soap, &a->GetForceResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetForceResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetForceResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetForceResponse), type))
		return soap->error;
	if (a->GetForceResult)
		soap_element_result(soap, "turb1:GetForceResult");
	if (soap_out_PointerToturb1__ArrayOfVector3(soap, "turb1:GetForceResult", -1, &a->GetForceResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetForceResponse * SOAP_FMAC4 soap_in__turb1__GetForceResponse(struct soap *soap, const char *tag, struct _turb1__GetForceResponse *a, const char *type)
{
	size_t soap_flag_GetForceResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetForceResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetForceResponse, sizeof(struct _turb1__GetForceResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetForceResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetForceResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfVector3(soap, "turb1:GetForceResult", &a->GetForceResult, "turb1:ArrayOfVector3"))
				{	soap_flag_GetForceResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetForceResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetForceResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetForceResponse, 0, sizeof(struct _turb1__GetForceResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetForceResponse(struct soap *soap, const struct _turb1__GetForceResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetForceResponse);
	if (soap_out__turb1__GetForceResponse(soap, tag?tag:"turb1:GetForceResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetForceResponse * SOAP_FMAC4 soap_get__turb1__GetForceResponse(struct soap *soap, struct _turb1__GetForceResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetForceResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetForce(struct soap *soap, struct _turb1__GetForce *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetForce(struct soap *soap, const struct _turb1__GetForce *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetForce(struct soap *soap, const char *tag, int id, const struct _turb1__GetForce *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetForce), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetForce * SOAP_FMAC4 soap_in__turb1__GetForce(struct soap *soap, const char *tag, struct _turb1__GetForce *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetForce *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetForce, sizeof(struct _turb1__GetForce), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetForce(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetForce *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetForce, 0, sizeof(struct _turb1__GetForce), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetForce(struct soap *soap, const struct _turb1__GetForce *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetForce);
	if (soap_out__turb1__GetForce(soap, tag?tag:"turb1:GetForce", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetForce * SOAP_FMAC4 soap_get__turb1__GetForce(struct soap *soap, struct _turb1__GetForce *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetForce(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetRawDensityResponse(struct soap *soap, struct _turb1__GetRawDensityResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetRawDensityResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetRawDensityResponse(struct soap *soap, const struct _turb1__GetRawDensityResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToxsd__base64Binary(soap, &a->GetRawDensityResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetRawDensityResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetRawDensityResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetRawDensityResponse), type))
		return soap->error;
	if (a->GetRawDensityResult)
		soap_element_result(soap, "turb1:GetRawDensityResult");
	if (soap_out_PointerToxsd__base64Binary(soap, "turb1:GetRawDensityResult", -1, &a->GetRawDensityResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetRawDensityResponse * SOAP_FMAC4 soap_in__turb1__GetRawDensityResponse(struct soap *soap, const char *tag, struct _turb1__GetRawDensityResponse *a, const char *type)
{
	size_t soap_flag_GetRawDensityResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetRawDensityResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetRawDensityResponse, sizeof(struct _turb1__GetRawDensityResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetRawDensityResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetRawDensityResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__base64Binary(soap, "turb1:GetRawDensityResult", &a->GetRawDensityResult, "xsd:base64Binary"))
				{	soap_flag_GetRawDensityResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetRawDensityResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetRawDensityResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetRawDensityResponse, 0, sizeof(struct _turb1__GetRawDensityResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetRawDensityResponse(struct soap *soap, const struct _turb1__GetRawDensityResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetRawDensityResponse);
	if (soap_out__turb1__GetRawDensityResponse(soap, tag?tag:"turb1:GetRawDensityResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetRawDensityResponse * SOAP_FMAC4 soap_get__turb1__GetRawDensityResponse(struct soap *soap, struct _turb1__GetRawDensityResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetRawDensityResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetRawDensity(struct soap *soap, struct _turb1__GetRawDensity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_int(soap, &a->X);
	soap_default_int(soap, &a->Y);
	soap_default_int(soap, &a->Z);
	soap_default_int(soap, &a->Xwidth);
	soap_default_int(soap, &a->Ywidth);
	soap_default_int(soap, &a->Zwidth);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetRawDensity(struct soap *soap, const struct _turb1__GetRawDensity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetRawDensity(struct soap *soap, const char *tag, int id, const struct _turb1__GetRawDensity *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetRawDensity), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:X", -1, &a->X, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Y", -1, &a->Y, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Z", -1, &a->Z, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Xwidth", -1, &a->Xwidth, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Ywidth", -1, &a->Ywidth, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Zwidth", -1, &a->Zwidth, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetRawDensity * SOAP_FMAC4 soap_in__turb1__GetRawDensity(struct soap *soap, const char *tag, struct _turb1__GetRawDensity *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_X = 1;
	size_t soap_flag_Y = 1;
	size_t soap_flag_Z = 1;
	size_t soap_flag_Xwidth = 1;
	size_t soap_flag_Ywidth = 1;
	size_t soap_flag_Zwidth = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetRawDensity *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetRawDensity, sizeof(struct _turb1__GetRawDensity), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetRawDensity(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_X && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:X", &a->X, "xsd:int"))
				{	soap_flag_X--;
					continue;
				}
			if (soap_flag_Y && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Y", &a->Y, "xsd:int"))
				{	soap_flag_Y--;
					continue;
				}
			if (soap_flag_Z && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Z", &a->Z, "xsd:int"))
				{	soap_flag_Z--;
					continue;
				}
			if (soap_flag_Xwidth && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Xwidth", &a->Xwidth, "xsd:int"))
				{	soap_flag_Xwidth--;
					continue;
				}
			if (soap_flag_Ywidth && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Ywidth", &a->Ywidth, "xsd:int"))
				{	soap_flag_Ywidth--;
					continue;
				}
			if (soap_flag_Zwidth && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Zwidth", &a->Zwidth, "xsd:int"))
				{	soap_flag_Zwidth--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetRawDensity *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetRawDensity, 0, sizeof(struct _turb1__GetRawDensity), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_X > 0 || soap_flag_Y > 0 || soap_flag_Z > 0 || soap_flag_Xwidth > 0 || soap_flag_Ywidth > 0 || soap_flag_Zwidth > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetRawDensity(struct soap *soap, const struct _turb1__GetRawDensity *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetRawDensity);
	if (soap_out__turb1__GetRawDensity(soap, tag?tag:"turb1:GetRawDensity", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetRawDensity * SOAP_FMAC4 soap_get__turb1__GetRawDensity(struct soap *soap, struct _turb1__GetRawDensity *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetRawDensity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetDensityHessianResponse(struct soap *soap, struct _turb1__GetDensityHessianResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetDensityHessianResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetDensityHessianResponse(struct soap *soap, const struct _turb1__GetDensityHessianResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfPressureHessian(soap, &a->GetDensityHessianResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetDensityHessianResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetDensityHessianResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetDensityHessianResponse), type))
		return soap->error;
	if (a->GetDensityHessianResult)
		soap_element_result(soap, "turb1:GetDensityHessianResult");
	if (soap_out_PointerToturb1__ArrayOfPressureHessian(soap, "turb1:GetDensityHessianResult", -1, &a->GetDensityHessianResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetDensityHessianResponse * SOAP_FMAC4 soap_in__turb1__GetDensityHessianResponse(struct soap *soap, const char *tag, struct _turb1__GetDensityHessianResponse *a, const char *type)
{
	size_t soap_flag_GetDensityHessianResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetDensityHessianResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetDensityHessianResponse, sizeof(struct _turb1__GetDensityHessianResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetDensityHessianResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetDensityHessianResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPressureHessian(soap, "turb1:GetDensityHessianResult", &a->GetDensityHessianResult, "turb1:ArrayOfPressureHessian"))
				{	soap_flag_GetDensityHessianResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetDensityHessianResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetDensityHessianResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetDensityHessianResponse, 0, sizeof(struct _turb1__GetDensityHessianResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetDensityHessianResponse(struct soap *soap, const struct _turb1__GetDensityHessianResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetDensityHessianResponse);
	if (soap_out__turb1__GetDensityHessianResponse(soap, tag?tag:"turb1:GetDensityHessianResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetDensityHessianResponse * SOAP_FMAC4 soap_get__turb1__GetDensityHessianResponse(struct soap *soap, struct _turb1__GetDensityHessianResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetDensityHessianResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetDensityHessian(struct soap *soap, struct _turb1__GetDensityHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetDensityHessian(struct soap *soap, const struct _turb1__GetDensityHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetDensityHessian(struct soap *soap, const char *tag, int id, const struct _turb1__GetDensityHessian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetDensityHessian), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetDensityHessian * SOAP_FMAC4 soap_in__turb1__GetDensityHessian(struct soap *soap, const char *tag, struct _turb1__GetDensityHessian *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetDensityHessian *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetDensityHessian, sizeof(struct _turb1__GetDensityHessian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetDensityHessian(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetDensityHessian *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetDensityHessian, 0, sizeof(struct _turb1__GetDensityHessian), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetDensityHessian(struct soap *soap, const struct _turb1__GetDensityHessian *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetDensityHessian);
	if (soap_out__turb1__GetDensityHessian(soap, tag?tag:"turb1:GetDensityHessian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetDensityHessian * SOAP_FMAC4 soap_get__turb1__GetDensityHessian(struct soap *soap, struct _turb1__GetDensityHessian *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetDensityHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetDensityGradientResponse(struct soap *soap, struct _turb1__GetDensityGradientResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetDensityGradientResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetDensityGradientResponse(struct soap *soap, const struct _turb1__GetDensityGradientResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfVector3(soap, &a->GetDensityGradientResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetDensityGradientResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetDensityGradientResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetDensityGradientResponse), type))
		return soap->error;
	if (a->GetDensityGradientResult)
		soap_element_result(soap, "turb1:GetDensityGradientResult");
	if (soap_out_PointerToturb1__ArrayOfVector3(soap, "turb1:GetDensityGradientResult", -1, &a->GetDensityGradientResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetDensityGradientResponse * SOAP_FMAC4 soap_in__turb1__GetDensityGradientResponse(struct soap *soap, const char *tag, struct _turb1__GetDensityGradientResponse *a, const char *type)
{
	size_t soap_flag_GetDensityGradientResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetDensityGradientResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetDensityGradientResponse, sizeof(struct _turb1__GetDensityGradientResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetDensityGradientResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetDensityGradientResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfVector3(soap, "turb1:GetDensityGradientResult", &a->GetDensityGradientResult, "turb1:ArrayOfVector3"))
				{	soap_flag_GetDensityGradientResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetDensityGradientResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetDensityGradientResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetDensityGradientResponse, 0, sizeof(struct _turb1__GetDensityGradientResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetDensityGradientResponse(struct soap *soap, const struct _turb1__GetDensityGradientResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetDensityGradientResponse);
	if (soap_out__turb1__GetDensityGradientResponse(soap, tag?tag:"turb1:GetDensityGradientResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetDensityGradientResponse * SOAP_FMAC4 soap_get__turb1__GetDensityGradientResponse(struct soap *soap, struct _turb1__GetDensityGradientResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetDensityGradientResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetDensityGradient(struct soap *soap, struct _turb1__GetDensityGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetDensityGradient(struct soap *soap, const struct _turb1__GetDensityGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetDensityGradient(struct soap *soap, const char *tag, int id, const struct _turb1__GetDensityGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetDensityGradient), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetDensityGradient * SOAP_FMAC4 soap_in__turb1__GetDensityGradient(struct soap *soap, const char *tag, struct _turb1__GetDensityGradient *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetDensityGradient *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetDensityGradient, sizeof(struct _turb1__GetDensityGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetDensityGradient(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetDensityGradient *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetDensityGradient, 0, sizeof(struct _turb1__GetDensityGradient), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetDensityGradient(struct soap *soap, const struct _turb1__GetDensityGradient *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetDensityGradient);
	if (soap_out__turb1__GetDensityGradient(soap, tag?tag:"turb1:GetDensityGradient", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetDensityGradient * SOAP_FMAC4 soap_get__turb1__GetDensityGradient(struct soap *soap, struct _turb1__GetDensityGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetDensityGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetDensityResponse(struct soap *soap, struct _turb1__GetDensityResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetDensityResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetDensityResponse(struct soap *soap, const struct _turb1__GetDensityResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfPressure(soap, &a->GetDensityResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetDensityResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetDensityResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetDensityResponse), type))
		return soap->error;
	if (a->GetDensityResult)
		soap_element_result(soap, "turb1:GetDensityResult");
	if (soap_out_PointerToturb1__ArrayOfPressure(soap, "turb1:GetDensityResult", -1, &a->GetDensityResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetDensityResponse * SOAP_FMAC4 soap_in__turb1__GetDensityResponse(struct soap *soap, const char *tag, struct _turb1__GetDensityResponse *a, const char *type)
{
	size_t soap_flag_GetDensityResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetDensityResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetDensityResponse, sizeof(struct _turb1__GetDensityResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetDensityResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetDensityResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPressure(soap, "turb1:GetDensityResult", &a->GetDensityResult, "turb1:ArrayOfPressure"))
				{	soap_flag_GetDensityResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetDensityResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetDensityResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetDensityResponse, 0, sizeof(struct _turb1__GetDensityResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetDensityResponse(struct soap *soap, const struct _turb1__GetDensityResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetDensityResponse);
	if (soap_out__turb1__GetDensityResponse(soap, tag?tag:"turb1:GetDensityResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetDensityResponse * SOAP_FMAC4 soap_get__turb1__GetDensityResponse(struct soap *soap, struct _turb1__GetDensityResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetDensityResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetDensity(struct soap *soap, struct _turb1__GetDensity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetDensity(struct soap *soap, const struct _turb1__GetDensity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetDensity(struct soap *soap, const char *tag, int id, const struct _turb1__GetDensity *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetDensity), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetDensity * SOAP_FMAC4 soap_in__turb1__GetDensity(struct soap *soap, const char *tag, struct _turb1__GetDensity *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetDensity *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetDensity, sizeof(struct _turb1__GetDensity), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetDensity(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetDensity *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetDensity, 0, sizeof(struct _turb1__GetDensity), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetDensity(struct soap *soap, const struct _turb1__GetDensity *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetDensity);
	if (soap_out__turb1__GetDensity(soap, tag?tag:"turb1:GetDensity", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetDensity * SOAP_FMAC4 soap_get__turb1__GetDensity(struct soap *soap, struct _turb1__GetDensity *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetDensity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetRawVectorPotentialResponse(struct soap *soap, struct _turb1__GetRawVectorPotentialResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetRawVectorPotentialResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetRawVectorPotentialResponse(struct soap *soap, const struct _turb1__GetRawVectorPotentialResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToxsd__base64Binary(soap, &a->GetRawVectorPotentialResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetRawVectorPotentialResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetRawVectorPotentialResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetRawVectorPotentialResponse), type))
		return soap->error;
	if (a->GetRawVectorPotentialResult)
		soap_element_result(soap, "turb1:GetRawVectorPotentialResult");
	if (soap_out_PointerToxsd__base64Binary(soap, "turb1:GetRawVectorPotentialResult", -1, &a->GetRawVectorPotentialResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetRawVectorPotentialResponse * SOAP_FMAC4 soap_in__turb1__GetRawVectorPotentialResponse(struct soap *soap, const char *tag, struct _turb1__GetRawVectorPotentialResponse *a, const char *type)
{
	size_t soap_flag_GetRawVectorPotentialResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetRawVectorPotentialResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetRawVectorPotentialResponse, sizeof(struct _turb1__GetRawVectorPotentialResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetRawVectorPotentialResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetRawVectorPotentialResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__base64Binary(soap, "turb1:GetRawVectorPotentialResult", &a->GetRawVectorPotentialResult, "xsd:base64Binary"))
				{	soap_flag_GetRawVectorPotentialResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetRawVectorPotentialResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetRawVectorPotentialResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetRawVectorPotentialResponse, 0, sizeof(struct _turb1__GetRawVectorPotentialResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetRawVectorPotentialResponse(struct soap *soap, const struct _turb1__GetRawVectorPotentialResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetRawVectorPotentialResponse);
	if (soap_out__turb1__GetRawVectorPotentialResponse(soap, tag?tag:"turb1:GetRawVectorPotentialResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetRawVectorPotentialResponse * SOAP_FMAC4 soap_get__turb1__GetRawVectorPotentialResponse(struct soap *soap, struct _turb1__GetRawVectorPotentialResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetRawVectorPotentialResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetRawVectorPotential(struct soap *soap, struct _turb1__GetRawVectorPotential *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_int(soap, &a->X);
	soap_default_int(soap, &a->Y);
	soap_default_int(soap, &a->Z);
	soap_default_int(soap, &a->Xwidth);
	soap_default_int(soap, &a->Ywidth);
	soap_default_int(soap, &a->Zwidth);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetRawVectorPotential(struct soap *soap, const struct _turb1__GetRawVectorPotential *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetRawVectorPotential(struct soap *soap, const char *tag, int id, const struct _turb1__GetRawVectorPotential *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetRawVectorPotential), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:X", -1, &a->X, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Y", -1, &a->Y, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Z", -1, &a->Z, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Xwidth", -1, &a->Xwidth, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Ywidth", -1, &a->Ywidth, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Zwidth", -1, &a->Zwidth, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetRawVectorPotential * SOAP_FMAC4 soap_in__turb1__GetRawVectorPotential(struct soap *soap, const char *tag, struct _turb1__GetRawVectorPotential *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_X = 1;
	size_t soap_flag_Y = 1;
	size_t soap_flag_Z = 1;
	size_t soap_flag_Xwidth = 1;
	size_t soap_flag_Ywidth = 1;
	size_t soap_flag_Zwidth = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetRawVectorPotential *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetRawVectorPotential, sizeof(struct _turb1__GetRawVectorPotential), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetRawVectorPotential(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_X && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:X", &a->X, "xsd:int"))
				{	soap_flag_X--;
					continue;
				}
			if (soap_flag_Y && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Y", &a->Y, "xsd:int"))
				{	soap_flag_Y--;
					continue;
				}
			if (soap_flag_Z && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Z", &a->Z, "xsd:int"))
				{	soap_flag_Z--;
					continue;
				}
			if (soap_flag_Xwidth && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Xwidth", &a->Xwidth, "xsd:int"))
				{	soap_flag_Xwidth--;
					continue;
				}
			if (soap_flag_Ywidth && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Ywidth", &a->Ywidth, "xsd:int"))
				{	soap_flag_Ywidth--;
					continue;
				}
			if (soap_flag_Zwidth && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Zwidth", &a->Zwidth, "xsd:int"))
				{	soap_flag_Zwidth--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetRawVectorPotential *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetRawVectorPotential, 0, sizeof(struct _turb1__GetRawVectorPotential), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_X > 0 || soap_flag_Y > 0 || soap_flag_Z > 0 || soap_flag_Xwidth > 0 || soap_flag_Ywidth > 0 || soap_flag_Zwidth > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetRawVectorPotential(struct soap *soap, const struct _turb1__GetRawVectorPotential *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetRawVectorPotential);
	if (soap_out__turb1__GetRawVectorPotential(soap, tag?tag:"turb1:GetRawVectorPotential", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetRawVectorPotential * SOAP_FMAC4 soap_get__turb1__GetRawVectorPotential(struct soap *soap, struct _turb1__GetRawVectorPotential *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetRawVectorPotential(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetVectorPotentialResponse(struct soap *soap, struct _turb1__GetVectorPotentialResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetVectorPotentialResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetVectorPotentialResponse(struct soap *soap, const struct _turb1__GetVectorPotentialResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfVector3(soap, &a->GetVectorPotentialResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetVectorPotentialResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetVectorPotentialResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetVectorPotentialResponse), type))
		return soap->error;
	if (a->GetVectorPotentialResult)
		soap_element_result(soap, "turb1:GetVectorPotentialResult");
	if (soap_out_PointerToturb1__ArrayOfVector3(soap, "turb1:GetVectorPotentialResult", -1, &a->GetVectorPotentialResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialResponse * SOAP_FMAC4 soap_in__turb1__GetVectorPotentialResponse(struct soap *soap, const char *tag, struct _turb1__GetVectorPotentialResponse *a, const char *type)
{
	size_t soap_flag_GetVectorPotentialResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetVectorPotentialResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetVectorPotentialResponse, sizeof(struct _turb1__GetVectorPotentialResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetVectorPotentialResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetVectorPotentialResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfVector3(soap, "turb1:GetVectorPotentialResult", &a->GetVectorPotentialResult, "turb1:ArrayOfVector3"))
				{	soap_flag_GetVectorPotentialResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetVectorPotentialResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVectorPotentialResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetVectorPotentialResponse, 0, sizeof(struct _turb1__GetVectorPotentialResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetVectorPotentialResponse(struct soap *soap, const struct _turb1__GetVectorPotentialResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetVectorPotentialResponse);
	if (soap_out__turb1__GetVectorPotentialResponse(soap, tag?tag:"turb1:GetVectorPotentialResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialResponse * SOAP_FMAC4 soap_get__turb1__GetVectorPotentialResponse(struct soap *soap, struct _turb1__GetVectorPotentialResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetVectorPotentialResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetVectorPotential(struct soap *soap, struct _turb1__GetVectorPotential *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetVectorPotential(struct soap *soap, const struct _turb1__GetVectorPotential *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetVectorPotential(struct soap *soap, const char *tag, int id, const struct _turb1__GetVectorPotential *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetVectorPotential), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetVectorPotential * SOAP_FMAC4 soap_in__turb1__GetVectorPotential(struct soap *soap, const char *tag, struct _turb1__GetVectorPotential *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetVectorPotential *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetVectorPotential, sizeof(struct _turb1__GetVectorPotential), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetVectorPotential(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVectorPotential *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetVectorPotential, 0, sizeof(struct _turb1__GetVectorPotential), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetVectorPotential(struct soap *soap, const struct _turb1__GetVectorPotential *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetVectorPotential);
	if (soap_out__turb1__GetVectorPotential(soap, tag?tag:"turb1:GetVectorPotential", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVectorPotential * SOAP_FMAC4 soap_get__turb1__GetVectorPotential(struct soap *soap, struct _turb1__GetVectorPotential *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetVectorPotential(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetRawMagneticFieldResponse(struct soap *soap, struct _turb1__GetRawMagneticFieldResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetRawMagneticFieldResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetRawMagneticFieldResponse(struct soap *soap, const struct _turb1__GetRawMagneticFieldResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToxsd__base64Binary(soap, &a->GetRawMagneticFieldResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetRawMagneticFieldResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetRawMagneticFieldResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetRawMagneticFieldResponse), type))
		return soap->error;
	if (a->GetRawMagneticFieldResult)
		soap_element_result(soap, "turb1:GetRawMagneticFieldResult");
	if (soap_out_PointerToxsd__base64Binary(soap, "turb1:GetRawMagneticFieldResult", -1, &a->GetRawMagneticFieldResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetRawMagneticFieldResponse * SOAP_FMAC4 soap_in__turb1__GetRawMagneticFieldResponse(struct soap *soap, const char *tag, struct _turb1__GetRawMagneticFieldResponse *a, const char *type)
{
	size_t soap_flag_GetRawMagneticFieldResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetRawMagneticFieldResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetRawMagneticFieldResponse, sizeof(struct _turb1__GetRawMagneticFieldResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetRawMagneticFieldResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetRawMagneticFieldResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__base64Binary(soap, "turb1:GetRawMagneticFieldResult", &a->GetRawMagneticFieldResult, "xsd:base64Binary"))
				{	soap_flag_GetRawMagneticFieldResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetRawMagneticFieldResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetRawMagneticFieldResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetRawMagneticFieldResponse, 0, sizeof(struct _turb1__GetRawMagneticFieldResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetRawMagneticFieldResponse(struct soap *soap, const struct _turb1__GetRawMagneticFieldResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetRawMagneticFieldResponse);
	if (soap_out__turb1__GetRawMagneticFieldResponse(soap, tag?tag:"turb1:GetRawMagneticFieldResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetRawMagneticFieldResponse * SOAP_FMAC4 soap_get__turb1__GetRawMagneticFieldResponse(struct soap *soap, struct _turb1__GetRawMagneticFieldResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetRawMagneticFieldResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetRawMagneticField(struct soap *soap, struct _turb1__GetRawMagneticField *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_int(soap, &a->X);
	soap_default_int(soap, &a->Y);
	soap_default_int(soap, &a->Z);
	soap_default_int(soap, &a->Xwidth);
	soap_default_int(soap, &a->Ywidth);
	soap_default_int(soap, &a->Zwidth);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetRawMagneticField(struct soap *soap, const struct _turb1__GetRawMagneticField *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetRawMagneticField(struct soap *soap, const char *tag, int id, const struct _turb1__GetRawMagneticField *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetRawMagneticField), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:X", -1, &a->X, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Y", -1, &a->Y, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Z", -1, &a->Z, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Xwidth", -1, &a->Xwidth, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Ywidth", -1, &a->Ywidth, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Zwidth", -1, &a->Zwidth, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetRawMagneticField * SOAP_FMAC4 soap_in__turb1__GetRawMagneticField(struct soap *soap, const char *tag, struct _turb1__GetRawMagneticField *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_X = 1;
	size_t soap_flag_Y = 1;
	size_t soap_flag_Z = 1;
	size_t soap_flag_Xwidth = 1;
	size_t soap_flag_Ywidth = 1;
	size_t soap_flag_Zwidth = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetRawMagneticField *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetRawMagneticField, sizeof(struct _turb1__GetRawMagneticField), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetRawMagneticField(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_X && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:X", &a->X, "xsd:int"))
				{	soap_flag_X--;
					continue;
				}
			if (soap_flag_Y && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Y", &a->Y, "xsd:int"))
				{	soap_flag_Y--;
					continue;
				}
			if (soap_flag_Z && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Z", &a->Z, "xsd:int"))
				{	soap_flag_Z--;
					continue;
				}
			if (soap_flag_Xwidth && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Xwidth", &a->Xwidth, "xsd:int"))
				{	soap_flag_Xwidth--;
					continue;
				}
			if (soap_flag_Ywidth && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Ywidth", &a->Ywidth, "xsd:int"))
				{	soap_flag_Ywidth--;
					continue;
				}
			if (soap_flag_Zwidth && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Zwidth", &a->Zwidth, "xsd:int"))
				{	soap_flag_Zwidth--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetRawMagneticField *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetRawMagneticField, 0, sizeof(struct _turb1__GetRawMagneticField), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_X > 0 || soap_flag_Y > 0 || soap_flag_Z > 0 || soap_flag_Xwidth > 0 || soap_flag_Ywidth > 0 || soap_flag_Zwidth > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetRawMagneticField(struct soap *soap, const struct _turb1__GetRawMagneticField *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetRawMagneticField);
	if (soap_out__turb1__GetRawMagneticField(soap, tag?tag:"turb1:GetRawMagneticField", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetRawMagneticField * SOAP_FMAC4 soap_get__turb1__GetRawMagneticField(struct soap *soap, struct _turb1__GetRawMagneticField *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetRawMagneticField(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetMagneticFieldResponse(struct soap *soap, struct _turb1__GetMagneticFieldResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetMagneticFieldResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetMagneticFieldResponse(struct soap *soap, const struct _turb1__GetMagneticFieldResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfVector3(soap, &a->GetMagneticFieldResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetMagneticFieldResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetMagneticFieldResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetMagneticFieldResponse), type))
		return soap->error;
	if (a->GetMagneticFieldResult)
		soap_element_result(soap, "turb1:GetMagneticFieldResult");
	if (soap_out_PointerToturb1__ArrayOfVector3(soap, "turb1:GetMagneticFieldResult", -1, &a->GetMagneticFieldResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetMagneticFieldResponse * SOAP_FMAC4 soap_in__turb1__GetMagneticFieldResponse(struct soap *soap, const char *tag, struct _turb1__GetMagneticFieldResponse *a, const char *type)
{
	size_t soap_flag_GetMagneticFieldResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetMagneticFieldResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetMagneticFieldResponse, sizeof(struct _turb1__GetMagneticFieldResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetMagneticFieldResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetMagneticFieldResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfVector3(soap, "turb1:GetMagneticFieldResult", &a->GetMagneticFieldResult, "turb1:ArrayOfVector3"))
				{	soap_flag_GetMagneticFieldResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetMagneticFieldResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetMagneticFieldResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetMagneticFieldResponse, 0, sizeof(struct _turb1__GetMagneticFieldResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetMagneticFieldResponse(struct soap *soap, const struct _turb1__GetMagneticFieldResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetMagneticFieldResponse);
	if (soap_out__turb1__GetMagneticFieldResponse(soap, tag?tag:"turb1:GetMagneticFieldResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetMagneticFieldResponse * SOAP_FMAC4 soap_get__turb1__GetMagneticFieldResponse(struct soap *soap, struct _turb1__GetMagneticFieldResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetMagneticFieldResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetMagneticField(struct soap *soap, struct _turb1__GetMagneticField *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetMagneticField(struct soap *soap, const struct _turb1__GetMagneticField *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetMagneticField(struct soap *soap, const char *tag, int id, const struct _turb1__GetMagneticField *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetMagneticField), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetMagneticField * SOAP_FMAC4 soap_in__turb1__GetMagneticField(struct soap *soap, const char *tag, struct _turb1__GetMagneticField *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetMagneticField *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetMagneticField, sizeof(struct _turb1__GetMagneticField), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetMagneticField(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetMagneticField *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetMagneticField, 0, sizeof(struct _turb1__GetMagneticField), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetMagneticField(struct soap *soap, const struct _turb1__GetMagneticField *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetMagneticField);
	if (soap_out__turb1__GetMagneticField(soap, tag?tag:"turb1:GetMagneticField", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetMagneticField * SOAP_FMAC4 soap_get__turb1__GetMagneticField(struct soap *soap, struct _turb1__GetMagneticField *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetMagneticField(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetRawPressureResponse(struct soap *soap, struct _turb1__GetRawPressureResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetRawPressureResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetRawPressureResponse(struct soap *soap, const struct _turb1__GetRawPressureResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToxsd__base64Binary(soap, &a->GetRawPressureResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetRawPressureResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetRawPressureResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetRawPressureResponse), type))
		return soap->error;
	if (a->GetRawPressureResult)
		soap_element_result(soap, "turb1:GetRawPressureResult");
	if (soap_out_PointerToxsd__base64Binary(soap, "turb1:GetRawPressureResult", -1, &a->GetRawPressureResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetRawPressureResponse * SOAP_FMAC4 soap_in__turb1__GetRawPressureResponse(struct soap *soap, const char *tag, struct _turb1__GetRawPressureResponse *a, const char *type)
{
	size_t soap_flag_GetRawPressureResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetRawPressureResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetRawPressureResponse, sizeof(struct _turb1__GetRawPressureResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetRawPressureResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetRawPressureResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__base64Binary(soap, "turb1:GetRawPressureResult", &a->GetRawPressureResult, "xsd:base64Binary"))
				{	soap_flag_GetRawPressureResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetRawPressureResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetRawPressureResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetRawPressureResponse, 0, sizeof(struct _turb1__GetRawPressureResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetRawPressureResponse(struct soap *soap, const struct _turb1__GetRawPressureResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetRawPressureResponse);
	if (soap_out__turb1__GetRawPressureResponse(soap, tag?tag:"turb1:GetRawPressureResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetRawPressureResponse * SOAP_FMAC4 soap_get__turb1__GetRawPressureResponse(struct soap *soap, struct _turb1__GetRawPressureResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetRawPressureResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetRawPressure(struct soap *soap, struct _turb1__GetRawPressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_int(soap, &a->X);
	soap_default_int(soap, &a->Y);
	soap_default_int(soap, &a->Z);
	soap_default_int(soap, &a->Xwidth);
	soap_default_int(soap, &a->Ywidth);
	soap_default_int(soap, &a->Zwidth);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetRawPressure(struct soap *soap, const struct _turb1__GetRawPressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetRawPressure(struct soap *soap, const char *tag, int id, const struct _turb1__GetRawPressure *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetRawPressure), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:X", -1, &a->X, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Y", -1, &a->Y, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Z", -1, &a->Z, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Xwidth", -1, &a->Xwidth, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Ywidth", -1, &a->Ywidth, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Zwidth", -1, &a->Zwidth, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetRawPressure * SOAP_FMAC4 soap_in__turb1__GetRawPressure(struct soap *soap, const char *tag, struct _turb1__GetRawPressure *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_X = 1;
	size_t soap_flag_Y = 1;
	size_t soap_flag_Z = 1;
	size_t soap_flag_Xwidth = 1;
	size_t soap_flag_Ywidth = 1;
	size_t soap_flag_Zwidth = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetRawPressure *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetRawPressure, sizeof(struct _turb1__GetRawPressure), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetRawPressure(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_X && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:X", &a->X, "xsd:int"))
				{	soap_flag_X--;
					continue;
				}
			if (soap_flag_Y && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Y", &a->Y, "xsd:int"))
				{	soap_flag_Y--;
					continue;
				}
			if (soap_flag_Z && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Z", &a->Z, "xsd:int"))
				{	soap_flag_Z--;
					continue;
				}
			if (soap_flag_Xwidth && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Xwidth", &a->Xwidth, "xsd:int"))
				{	soap_flag_Xwidth--;
					continue;
				}
			if (soap_flag_Ywidth && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Ywidth", &a->Ywidth, "xsd:int"))
				{	soap_flag_Ywidth--;
					continue;
				}
			if (soap_flag_Zwidth && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Zwidth", &a->Zwidth, "xsd:int"))
				{	soap_flag_Zwidth--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetRawPressure *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetRawPressure, 0, sizeof(struct _turb1__GetRawPressure), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_X > 0 || soap_flag_Y > 0 || soap_flag_Z > 0 || soap_flag_Xwidth > 0 || soap_flag_Ywidth > 0 || soap_flag_Zwidth > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetRawPressure(struct soap *soap, const struct _turb1__GetRawPressure *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetRawPressure);
	if (soap_out__turb1__GetRawPressure(soap, tag?tag:"turb1:GetRawPressure", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetRawPressure * SOAP_FMAC4 soap_get__turb1__GetRawPressure(struct soap *soap, struct _turb1__GetRawPressure *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetRawPressure(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetPressureResponse(struct soap *soap, struct _turb1__GetPressureResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetPressureResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetPressureResponse(struct soap *soap, const struct _turb1__GetPressureResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfPressure(soap, &a->GetPressureResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetPressureResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetPressureResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetPressureResponse), type))
		return soap->error;
	if (a->GetPressureResult)
		soap_element_result(soap, "turb1:GetPressureResult");
	if (soap_out_PointerToturb1__ArrayOfPressure(soap, "turb1:GetPressureResult", -1, &a->GetPressureResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetPressureResponse * SOAP_FMAC4 soap_in__turb1__GetPressureResponse(struct soap *soap, const char *tag, struct _turb1__GetPressureResponse *a, const char *type)
{
	size_t soap_flag_GetPressureResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetPressureResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetPressureResponse, sizeof(struct _turb1__GetPressureResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetPressureResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetPressureResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPressure(soap, "turb1:GetPressureResult", &a->GetPressureResult, "turb1:ArrayOfPressure"))
				{	soap_flag_GetPressureResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetPressureResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetPressureResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetPressureResponse, 0, sizeof(struct _turb1__GetPressureResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetPressureResponse(struct soap *soap, const struct _turb1__GetPressureResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetPressureResponse);
	if (soap_out__turb1__GetPressureResponse(soap, tag?tag:"turb1:GetPressureResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetPressureResponse * SOAP_FMAC4 soap_get__turb1__GetPressureResponse(struct soap *soap, struct _turb1__GetPressureResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetPressureResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetPressure(struct soap *soap, struct _turb1__GetPressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetPressure(struct soap *soap, const struct _turb1__GetPressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetPressure(struct soap *soap, const char *tag, int id, const struct _turb1__GetPressure *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetPressure), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetPressure * SOAP_FMAC4 soap_in__turb1__GetPressure(struct soap *soap, const char *tag, struct _turb1__GetPressure *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetPressure *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetPressure, sizeof(struct _turb1__GetPressure), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetPressure(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetPressure *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetPressure, 0, sizeof(struct _turb1__GetPressure), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetPressure(struct soap *soap, const struct _turb1__GetPressure *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetPressure);
	if (soap_out__turb1__GetPressure(soap, tag?tag:"turb1:GetPressure", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetPressure * SOAP_FMAC4 soap_get__turb1__GetPressure(struct soap *soap, struct _turb1__GetPressure *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetPressure(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetRawVelocityResponse(struct soap *soap, struct _turb1__GetRawVelocityResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetRawVelocityResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetRawVelocityResponse(struct soap *soap, const struct _turb1__GetRawVelocityResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToxsd__base64Binary(soap, &a->GetRawVelocityResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetRawVelocityResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetRawVelocityResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetRawVelocityResponse), type))
		return soap->error;
	if (a->GetRawVelocityResult)
		soap_element_result(soap, "turb1:GetRawVelocityResult");
	if (soap_out_PointerToxsd__base64Binary(soap, "turb1:GetRawVelocityResult", -1, &a->GetRawVelocityResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetRawVelocityResponse * SOAP_FMAC4 soap_in__turb1__GetRawVelocityResponse(struct soap *soap, const char *tag, struct _turb1__GetRawVelocityResponse *a, const char *type)
{
	size_t soap_flag_GetRawVelocityResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetRawVelocityResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetRawVelocityResponse, sizeof(struct _turb1__GetRawVelocityResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetRawVelocityResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetRawVelocityResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__base64Binary(soap, "turb1:GetRawVelocityResult", &a->GetRawVelocityResult, "xsd:base64Binary"))
				{	soap_flag_GetRawVelocityResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetRawVelocityResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetRawVelocityResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetRawVelocityResponse, 0, sizeof(struct _turb1__GetRawVelocityResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetRawVelocityResponse(struct soap *soap, const struct _turb1__GetRawVelocityResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetRawVelocityResponse);
	if (soap_out__turb1__GetRawVelocityResponse(soap, tag?tag:"turb1:GetRawVelocityResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetRawVelocityResponse * SOAP_FMAC4 soap_get__turb1__GetRawVelocityResponse(struct soap *soap, struct _turb1__GetRawVelocityResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetRawVelocityResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetRawVelocity(struct soap *soap, struct _turb1__GetRawVelocity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_int(soap, &a->X);
	soap_default_int(soap, &a->Y);
	soap_default_int(soap, &a->Z);
	soap_default_int(soap, &a->Xwidth);
	soap_default_int(soap, &a->Ywidth);
	soap_default_int(soap, &a->Zwidth);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetRawVelocity(struct soap *soap, const struct _turb1__GetRawVelocity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetRawVelocity(struct soap *soap, const char *tag, int id, const struct _turb1__GetRawVelocity *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetRawVelocity), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:X", -1, &a->X, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Y", -1, &a->Y, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Z", -1, &a->Z, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Xwidth", -1, &a->Xwidth, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Ywidth", -1, &a->Ywidth, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:Zwidth", -1, &a->Zwidth, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetRawVelocity * SOAP_FMAC4 soap_in__turb1__GetRawVelocity(struct soap *soap, const char *tag, struct _turb1__GetRawVelocity *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_X = 1;
	size_t soap_flag_Y = 1;
	size_t soap_flag_Z = 1;
	size_t soap_flag_Xwidth = 1;
	size_t soap_flag_Ywidth = 1;
	size_t soap_flag_Zwidth = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetRawVelocity *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetRawVelocity, sizeof(struct _turb1__GetRawVelocity), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetRawVelocity(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_X && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:X", &a->X, "xsd:int"))
				{	soap_flag_X--;
					continue;
				}
			if (soap_flag_Y && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Y", &a->Y, "xsd:int"))
				{	soap_flag_Y--;
					continue;
				}
			if (soap_flag_Z && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Z", &a->Z, "xsd:int"))
				{	soap_flag_Z--;
					continue;
				}
			if (soap_flag_Xwidth && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Xwidth", &a->Xwidth, "xsd:int"))
				{	soap_flag_Xwidth--;
					continue;
				}
			if (soap_flag_Ywidth && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Ywidth", &a->Ywidth, "xsd:int"))
				{	soap_flag_Ywidth--;
					continue;
				}
			if (soap_flag_Zwidth && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:Zwidth", &a->Zwidth, "xsd:int"))
				{	soap_flag_Zwidth--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetRawVelocity *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetRawVelocity, 0, sizeof(struct _turb1__GetRawVelocity), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_X > 0 || soap_flag_Y > 0 || soap_flag_Z > 0 || soap_flag_Xwidth > 0 || soap_flag_Ywidth > 0 || soap_flag_Zwidth > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetRawVelocity(struct soap *soap, const struct _turb1__GetRawVelocity *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetRawVelocity);
	if (soap_out__turb1__GetRawVelocity(soap, tag?tag:"turb1:GetRawVelocity", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetRawVelocity * SOAP_FMAC4 soap_get__turb1__GetRawVelocity(struct soap *soap, struct _turb1__GetRawVelocity *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetRawVelocity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetVelocityBatchResponse(struct soap *soap, struct _turb1__GetVelocityBatchResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetVelocityBatchResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetVelocityBatchResponse(struct soap *soap, const struct _turb1__GetVelocityBatchResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfVector3(soap, &a->GetVelocityBatchResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetVelocityBatchResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetVelocityBatchResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetVelocityBatchResponse), type))
		return soap->error;
	if (a->GetVelocityBatchResult)
		soap_element_result(soap, "turb1:GetVelocityBatchResult");
	if (soap_out_PointerToturb1__ArrayOfVector3(soap, "turb1:GetVelocityBatchResult", -1, &a->GetVelocityBatchResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetVelocityBatchResponse * SOAP_FMAC4 soap_in__turb1__GetVelocityBatchResponse(struct soap *soap, const char *tag, struct _turb1__GetVelocityBatchResponse *a, const char *type)
{
	size_t soap_flag_GetVelocityBatchResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetVelocityBatchResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetVelocityBatchResponse, sizeof(struct _turb1__GetVelocityBatchResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetVelocityBatchResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetVelocityBatchResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfVector3(soap, "turb1:GetVelocityBatchResult", &a->GetVelocityBatchResult, "turb1:ArrayOfVector3"))
				{	soap_flag_GetVelocityBatchResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetVelocityBatchResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityBatchResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetVelocityBatchResponse, 0, sizeof(struct _turb1__GetVelocityBatchResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetVelocityBatchResponse(struct soap *soap, const struct _turb1__GetVelocityBatchResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetVelocityBatchResponse);
	if (soap_out__turb1__GetVelocityBatchResponse(soap, tag?tag:"turb1:GetVelocityBatchResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityBatchResponse * SOAP_FMAC4 soap_get__turb1__GetVelocityBatchResponse(struct soap *soap, struct _turb1__GetVelocityBatchResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetVelocityBatchResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetVelocityBatch(struct soap *soap, struct _turb1__GetVelocityBatch *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetVelocityBatch(struct soap *soap, const struct _turb1__GetVelocityBatch *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetVelocityBatch(struct soap *soap, const char *tag, int id, const struct _turb1__GetVelocityBatch *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetVelocityBatch), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetVelocityBatch * SOAP_FMAC4 soap_in__turb1__GetVelocityBatch(struct soap *soap, const char *tag, struct _turb1__GetVelocityBatch *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetVelocityBatch *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetVelocityBatch, sizeof(struct _turb1__GetVelocityBatch), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetVelocityBatch(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityBatch *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetVelocityBatch, 0, sizeof(struct _turb1__GetVelocityBatch), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetVelocityBatch(struct soap *soap, const struct _turb1__GetVelocityBatch *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetVelocityBatch);
	if (soap_out__turb1__GetVelocityBatch(soap, tag?tag:"turb1:GetVelocityBatch", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityBatch * SOAP_FMAC4 soap_get__turb1__GetVelocityBatch(struct soap *soap, struct _turb1__GetVelocityBatch *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetVelocityBatch(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetVelocityResponse(struct soap *soap, struct _turb1__GetVelocityResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->GetVelocityResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetVelocityResponse(struct soap *soap, const struct _turb1__GetVelocityResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfVector3(soap, &a->GetVelocityResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetVelocityResponse(struct soap *soap, const char *tag, int id, const struct _turb1__GetVelocityResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetVelocityResponse), type))
		return soap->error;
	if (a->GetVelocityResult)
		soap_element_result(soap, "turb1:GetVelocityResult");
	if (soap_out_PointerToturb1__ArrayOfVector3(soap, "turb1:GetVelocityResult", -1, &a->GetVelocityResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetVelocityResponse * SOAP_FMAC4 soap_in__turb1__GetVelocityResponse(struct soap *soap, const char *tag, struct _turb1__GetVelocityResponse *a, const char *type)
{
	size_t soap_flag_GetVelocityResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetVelocityResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetVelocityResponse, sizeof(struct _turb1__GetVelocityResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetVelocityResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetVelocityResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfVector3(soap, "turb1:GetVelocityResult", &a->GetVelocityResult, "turb1:ArrayOfVector3"))
				{	soap_flag_GetVelocityResult--;
					continue;
				}
			soap_check_result(soap, "turb1:GetVelocityResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetVelocityResponse, 0, sizeof(struct _turb1__GetVelocityResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetVelocityResponse(struct soap *soap, const struct _turb1__GetVelocityResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetVelocityResponse);
	if (soap_out__turb1__GetVelocityResponse(soap, tag?tag:"turb1:GetVelocityResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityResponse * SOAP_FMAC4 soap_get__turb1__GetVelocityResponse(struct soap *soap, struct _turb1__GetVelocityResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetVelocityResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__GetVelocity(struct soap *soap, struct _turb1__GetVelocity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	soap_default_string(soap, &a->dataset);
	soap_default_float(soap, &a->time);
	soap_default_turb1__SpatialInterpolation(soap, &a->spatialInterpolation);
	soap_default_turb1__TemporalInterpolation(soap, &a->temporalInterpolation);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__GetVelocity(struct soap *soap, const struct _turb1__GetVelocity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_string(soap, &a->dataset);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__GetVelocity(struct soap *soap, const char *tag, int id, const struct _turb1__GetVelocity *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__GetVelocity), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_string(soap, "turb1:dataset", -1, &a->dataset, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:time", -1, &a->time, ""))
		return soap->error;
	if (soap_out_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", -1, &a->spatialInterpolation, ""))
		return soap->error;
	if (soap_out_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", -1, &a->temporalInterpolation, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__GetVelocity * SOAP_FMAC4 soap_in__turb1__GetVelocity(struct soap *soap, const char *tag, struct _turb1__GetVelocity *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_dataset = 1;
	size_t soap_flag_time = 1;
	size_t soap_flag_spatialInterpolation = 1;
	size_t soap_flag_temporalInterpolation = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__GetVelocity *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__GetVelocity, sizeof(struct _turb1__GetVelocity), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__GetVelocity(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_dataset && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:dataset", &a->dataset, "xsd:string"))
				{	soap_flag_dataset--;
					continue;
				}
			if (soap_flag_time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:time", &a->time, "xsd:float"))
				{	soap_flag_time--;
					continue;
				}
			if (soap_flag_spatialInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__SpatialInterpolation(soap, "turb1:spatialInterpolation", &a->spatialInterpolation, "turb1:SpatialInterpolation"))
				{	soap_flag_spatialInterpolation--;
					continue;
				}
			if (soap_flag_temporalInterpolation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_turb1__TemporalInterpolation(soap, "turb1:temporalInterpolation", &a->temporalInterpolation, "turb1:TemporalInterpolation"))
				{	soap_flag_temporalInterpolation--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocity *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__GetVelocity, 0, sizeof(struct _turb1__GetVelocity), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_time > 0 || soap_flag_spatialInterpolation > 0 || soap_flag_temporalInterpolation > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__GetVelocity(struct soap *soap, const struct _turb1__GetVelocity *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__GetVelocity);
	if (soap_out__turb1__GetVelocity(soap, tag?tag:"turb1:GetVelocity", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocity * SOAP_FMAC4 soap_get__turb1__GetVelocity(struct soap *soap, struct _turb1__GetVelocity *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__GetVelocity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__NullOpResponse(struct soap *soap, struct _turb1__NullOpResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->NullOpResult = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__NullOpResponse(struct soap *soap, const struct _turb1__NullOpResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToturb1__ArrayOfVector3(soap, &a->NullOpResult);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__NullOpResponse(struct soap *soap, const char *tag, int id, const struct _turb1__NullOpResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__NullOpResponse), type))
		return soap->error;
	if (a->NullOpResult)
		soap_element_result(soap, "turb1:NullOpResult");
	if (soap_out_PointerToturb1__ArrayOfVector3(soap, "turb1:NullOpResult", -1, &a->NullOpResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__NullOpResponse * SOAP_FMAC4 soap_in__turb1__NullOpResponse(struct soap *soap, const char *tag, struct _turb1__NullOpResponse *a, const char *type)
{
	size_t soap_flag_NullOpResult = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__NullOpResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__NullOpResponse, sizeof(struct _turb1__NullOpResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__NullOpResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_NullOpResult && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfVector3(soap, "turb1:NullOpResult", &a->NullOpResult, "turb1:ArrayOfVector3"))
				{	soap_flag_NullOpResult--;
					continue;
				}
			soap_check_result(soap, "turb1:NullOpResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__NullOpResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__NullOpResponse, 0, sizeof(struct _turb1__NullOpResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__NullOpResponse(struct soap *soap, const struct _turb1__NullOpResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__NullOpResponse);
	if (soap_out__turb1__NullOpResponse(soap, tag?tag:"turb1:NullOpResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__NullOpResponse * SOAP_FMAC4 soap_get__turb1__NullOpResponse(struct soap *soap, struct _turb1__NullOpResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__NullOpResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__turb1__NullOp(struct soap *soap, struct _turb1__NullOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->authToken);
	a->points = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__turb1__NullOp(struct soap *soap, const struct _turb1__NullOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->authToken);
	soap_serialize_PointerToturb1__ArrayOfPoint3(soap, &a->points);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__turb1__NullOp(struct soap *soap, const char *tag, int id, const struct _turb1__NullOp *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__turb1__NullOp), type))
		return soap->error;
	if (soap_out_string(soap, "turb1:authToken", -1, &a->authToken, ""))
		return soap->error;
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", -1, &a->points, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _turb1__NullOp * SOAP_FMAC4 soap_in__turb1__NullOp(struct soap *soap, const char *tag, struct _turb1__NullOp *a, const char *type)
{
	size_t soap_flag_authToken = 1;
	size_t soap_flag_points = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _turb1__NullOp *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__turb1__NullOp, sizeof(struct _turb1__NullOp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__turb1__NullOp(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "turb1:authToken", &a->authToken, "xsd:string"))
				{	soap_flag_authToken--;
					continue;
				}
			if (soap_flag_points && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToturb1__ArrayOfPoint3(soap, "turb1:points", &a->points, "turb1:ArrayOfPoint3"))
				{	soap_flag_points--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _turb1__NullOp *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__turb1__NullOp, 0, sizeof(struct _turb1__NullOp), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__turb1__NullOp(struct soap *soap, const struct _turb1__NullOp *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__turb1__NullOp);
	if (soap_out__turb1__NullOp(soap, tag?tag:"turb1:NullOp", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__NullOp * SOAP_FMAC4 soap_get__turb1__NullOp(struct soap *soap, struct _turb1__NullOp *p, const char *tag, const char *type)
{
	if ((p = soap_in__turb1__NullOp(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_turb1__ThresholdInfo(struct soap *soap, struct turb1__ThresholdInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->x);
	soap_default_int(soap, &a->y);
	soap_default_int(soap, &a->z);
	soap_default_float(soap, &a->value);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_turb1__ThresholdInfo(struct soap *soap, const struct turb1__ThresholdInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_turb1__ThresholdInfo(struct soap *soap, const char *tag, int id, const struct turb1__ThresholdInfo *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_turb1__ThresholdInfo), type))
		return soap->error;
	if (soap_out_int(soap, "turb1:x", -1, &a->x, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:y", -1, &a->y, ""))
		return soap->error;
	if (soap_out_int(soap, "turb1:z", -1, &a->z, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:value", -1, &a->value, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct turb1__ThresholdInfo * SOAP_FMAC4 soap_in_turb1__ThresholdInfo(struct soap *soap, const char *tag, struct turb1__ThresholdInfo *a, const char *type)
{
	size_t soap_flag_x = 1;
	size_t soap_flag_y = 1;
	size_t soap_flag_z = 1;
	size_t soap_flag_value = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct turb1__ThresholdInfo *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_turb1__ThresholdInfo, sizeof(struct turb1__ThresholdInfo), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_turb1__ThresholdInfo(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_x && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:x", &a->x, "xsd:int"))
				{	soap_flag_x--;
					continue;
				}
			if (soap_flag_y && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:y", &a->y, "xsd:int"))
				{	soap_flag_y--;
					continue;
				}
			if (soap_flag_z && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "turb1:z", &a->z, "xsd:int"))
				{	soap_flag_z--;
					continue;
				}
			if (soap_flag_value && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:value", &a->value, "xsd:float"))
				{	soap_flag_value--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct turb1__ThresholdInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_turb1__ThresholdInfo, 0, sizeof(struct turb1__ThresholdInfo), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_x > 0 || soap_flag_y > 0 || soap_flag_z > 0 || soap_flag_value > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_turb1__ThresholdInfo(struct soap *soap, const struct turb1__ThresholdInfo *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_turb1__ThresholdInfo);
	if (soap_out_turb1__ThresholdInfo(soap, tag?tag:"turb1:ThresholdInfo", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__ThresholdInfo * SOAP_FMAC4 soap_get_turb1__ThresholdInfo(struct soap *soap, struct turb1__ThresholdInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_turb1__ThresholdInfo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_turb1__ArrayOfThresholdInfo(struct soap *soap, struct turb1__ArrayOfThresholdInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeThresholdInfo = 0;
	a->ThresholdInfo = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_turb1__ArrayOfThresholdInfo(struct soap *soap, const struct turb1__ArrayOfThresholdInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->ThresholdInfo)
	{	int i;
		for (i = 0; i < a->__sizeThresholdInfo; i++)
		{
			soap_embedded(soap, a->ThresholdInfo + i, SOAP_TYPE_turb1__ThresholdInfo);
			soap_serialize_turb1__ThresholdInfo(soap, a->ThresholdInfo + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_turb1__ArrayOfThresholdInfo(struct soap *soap, const char *tag, int id, const struct turb1__ArrayOfThresholdInfo *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_turb1__ArrayOfThresholdInfo), type))
		return soap->error;
	if (a->ThresholdInfo)
	{	int i;
		for (i = 0; i < a->__sizeThresholdInfo; i++)
			if (soap_out_turb1__ThresholdInfo(soap, "turb1:ThresholdInfo", -1, a->ThresholdInfo + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct turb1__ArrayOfThresholdInfo * SOAP_FMAC4 soap_in_turb1__ArrayOfThresholdInfo(struct soap *soap, const char *tag, struct turb1__ArrayOfThresholdInfo *a, const char *type)
{
	struct soap_blist *soap_blist_ThresholdInfo = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct turb1__ArrayOfThresholdInfo *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_turb1__ArrayOfThresholdInfo, sizeof(struct turb1__ArrayOfThresholdInfo), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_turb1__ArrayOfThresholdInfo(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "turb1:ThresholdInfo", 1, NULL))
			{	if (a->ThresholdInfo == NULL)
				{	if (soap_blist_ThresholdInfo == NULL)
						soap_blist_ThresholdInfo = soap_new_block(soap);
					a->ThresholdInfo = (struct turb1__ThresholdInfo *)soap_push_block(soap, soap_blist_ThresholdInfo, sizeof(struct turb1__ThresholdInfo));
					if (a->ThresholdInfo == NULL)
						return NULL;
					soap_default_turb1__ThresholdInfo(soap, a->ThresholdInfo);
				}
				soap_revert(soap);
				if (soap_in_turb1__ThresholdInfo(soap, "turb1:ThresholdInfo", a->ThresholdInfo, "turb1:ThresholdInfo"))
				{	a->__sizeThresholdInfo++;
					a->ThresholdInfo = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->ThresholdInfo)
			soap_pop_block(soap, soap_blist_ThresholdInfo);
		if (a->__sizeThresholdInfo)
			a->ThresholdInfo = (struct turb1__ThresholdInfo *)soap_save_block(soap, soap_blist_ThresholdInfo, NULL, 1);
		else
		{	a->ThresholdInfo = NULL;
			if (soap_blist_ThresholdInfo)
				soap_end_block(soap, soap_blist_ThresholdInfo);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct turb1__ArrayOfThresholdInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_turb1__ArrayOfThresholdInfo, 0, sizeof(struct turb1__ArrayOfThresholdInfo), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_turb1__ArrayOfThresholdInfo(struct soap *soap, const struct turb1__ArrayOfThresholdInfo *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_turb1__ArrayOfThresholdInfo);
	if (soap_out_turb1__ArrayOfThresholdInfo(soap, tag?tag:"turb1:ArrayOfThresholdInfo", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__ArrayOfThresholdInfo * SOAP_FMAC4 soap_get_turb1__ArrayOfThresholdInfo(struct soap *soap, struct turb1__ArrayOfThresholdInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_turb1__ArrayOfThresholdInfo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_turb1__SGSTensor(struct soap *soap, struct turb1__SGSTensor *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_float(soap, &a->xx);
	soap_default_float(soap, &a->yy);
	soap_default_float(soap, &a->zz);
	soap_default_float(soap, &a->xy);
	soap_default_float(soap, &a->xz);
	soap_default_float(soap, &a->yz);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_turb1__SGSTensor(struct soap *soap, const struct turb1__SGSTensor *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_turb1__SGSTensor(struct soap *soap, const char *tag, int id, const struct turb1__SGSTensor *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_turb1__SGSTensor), type))
		return soap->error;
	if (soap_out_float(soap, "turb1:xx", -1, &a->xx, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:yy", -1, &a->yy, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:zz", -1, &a->zz, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:xy", -1, &a->xy, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:xz", -1, &a->xz, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:yz", -1, &a->yz, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct turb1__SGSTensor * SOAP_FMAC4 soap_in_turb1__SGSTensor(struct soap *soap, const char *tag, struct turb1__SGSTensor *a, const char *type)
{
	size_t soap_flag_xx = 1;
	size_t soap_flag_yy = 1;
	size_t soap_flag_zz = 1;
	size_t soap_flag_xy = 1;
	size_t soap_flag_xz = 1;
	size_t soap_flag_yz = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct turb1__SGSTensor *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_turb1__SGSTensor, sizeof(struct turb1__SGSTensor), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_turb1__SGSTensor(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_xx && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:xx", &a->xx, "xsd:float"))
				{	soap_flag_xx--;
					continue;
				}
			if (soap_flag_yy && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:yy", &a->yy, "xsd:float"))
				{	soap_flag_yy--;
					continue;
				}
			if (soap_flag_zz && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:zz", &a->zz, "xsd:float"))
				{	soap_flag_zz--;
					continue;
				}
			if (soap_flag_xy && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:xy", &a->xy, "xsd:float"))
				{	soap_flag_xy--;
					continue;
				}
			if (soap_flag_xz && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:xz", &a->xz, "xsd:float"))
				{	soap_flag_xz--;
					continue;
				}
			if (soap_flag_yz && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:yz", &a->yz, "xsd:float"))
				{	soap_flag_yz--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct turb1__SGSTensor *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_turb1__SGSTensor, 0, sizeof(struct turb1__SGSTensor), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_xx > 0 || soap_flag_yy > 0 || soap_flag_zz > 0 || soap_flag_xy > 0 || soap_flag_xz > 0 || soap_flag_yz > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_turb1__SGSTensor(struct soap *soap, const struct turb1__SGSTensor *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_turb1__SGSTensor);
	if (soap_out_turb1__SGSTensor(soap, tag?tag:"turb1:SGSTensor", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__SGSTensor * SOAP_FMAC4 soap_get_turb1__SGSTensor(struct soap *soap, struct turb1__SGSTensor *p, const char *tag, const char *type)
{
	if ((p = soap_in_turb1__SGSTensor(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_turb1__ArrayOfSGSTensor(struct soap *soap, struct turb1__ArrayOfSGSTensor *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeSGSTensor = 0;
	a->SGSTensor = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_turb1__ArrayOfSGSTensor(struct soap *soap, const struct turb1__ArrayOfSGSTensor *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->SGSTensor)
	{	int i;
		for (i = 0; i < a->__sizeSGSTensor; i++)
		{
			soap_embedded(soap, a->SGSTensor + i, SOAP_TYPE_turb1__SGSTensor);
			soap_serialize_turb1__SGSTensor(soap, a->SGSTensor + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_turb1__ArrayOfSGSTensor(struct soap *soap, const char *tag, int id, const struct turb1__ArrayOfSGSTensor *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_turb1__ArrayOfSGSTensor), type))
		return soap->error;
	if (a->SGSTensor)
	{	int i;
		for (i = 0; i < a->__sizeSGSTensor; i++)
			if (soap_out_turb1__SGSTensor(soap, "turb1:SGSTensor", -1, a->SGSTensor + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct turb1__ArrayOfSGSTensor * SOAP_FMAC4 soap_in_turb1__ArrayOfSGSTensor(struct soap *soap, const char *tag, struct turb1__ArrayOfSGSTensor *a, const char *type)
{
	struct soap_blist *soap_blist_SGSTensor = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct turb1__ArrayOfSGSTensor *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_turb1__ArrayOfSGSTensor, sizeof(struct turb1__ArrayOfSGSTensor), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_turb1__ArrayOfSGSTensor(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "turb1:SGSTensor", 1, NULL))
			{	if (a->SGSTensor == NULL)
				{	if (soap_blist_SGSTensor == NULL)
						soap_blist_SGSTensor = soap_new_block(soap);
					a->SGSTensor = (struct turb1__SGSTensor *)soap_push_block(soap, soap_blist_SGSTensor, sizeof(struct turb1__SGSTensor));
					if (a->SGSTensor == NULL)
						return NULL;
					soap_default_turb1__SGSTensor(soap, a->SGSTensor);
				}
				soap_revert(soap);
				if (soap_in_turb1__SGSTensor(soap, "turb1:SGSTensor", a->SGSTensor, "turb1:SGSTensor"))
				{	a->__sizeSGSTensor++;
					a->SGSTensor = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->SGSTensor)
			soap_pop_block(soap, soap_blist_SGSTensor);
		if (a->__sizeSGSTensor)
			a->SGSTensor = (struct turb1__SGSTensor *)soap_save_block(soap, soap_blist_SGSTensor, NULL, 1);
		else
		{	a->SGSTensor = NULL;
			if (soap_blist_SGSTensor)
				soap_end_block(soap, soap_blist_SGSTensor);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct turb1__ArrayOfSGSTensor *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_turb1__ArrayOfSGSTensor, 0, sizeof(struct turb1__ArrayOfSGSTensor), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_turb1__ArrayOfSGSTensor(struct soap *soap, const struct turb1__ArrayOfSGSTensor *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_turb1__ArrayOfSGSTensor);
	if (soap_out_turb1__ArrayOfSGSTensor(soap, tag?tag:"turb1:ArrayOfSGSTensor", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__ArrayOfSGSTensor * SOAP_FMAC4 soap_get_turb1__ArrayOfSGSTensor(struct soap *soap, struct turb1__ArrayOfSGSTensor *p, const char *tag, const char *type)
{
	if ((p = soap_in_turb1__ArrayOfSGSTensor(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_turb1__VelocityHessian(struct soap *soap, struct turb1__VelocityHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_float(soap, &a->d2uxdxdx);
	soap_default_float(soap, &a->d2uxdxdy);
	soap_default_float(soap, &a->d2uxdxdz);
	soap_default_float(soap, &a->d2uxdydy);
	soap_default_float(soap, &a->d2uxdydz);
	soap_default_float(soap, &a->d2uxdzdz);
	soap_default_float(soap, &a->d2uydxdx);
	soap_default_float(soap, &a->d2uydxdy);
	soap_default_float(soap, &a->d2uydxdz);
	soap_default_float(soap, &a->d2uydydy);
	soap_default_float(soap, &a->d2uydydz);
	soap_default_float(soap, &a->d2uydzdz);
	soap_default_float(soap, &a->d2uzdxdx);
	soap_default_float(soap, &a->d2uzdxdy);
	soap_default_float(soap, &a->d2uzdxdz);
	soap_default_float(soap, &a->d2uzdydy);
	soap_default_float(soap, &a->d2uzdydz);
	soap_default_float(soap, &a->d2uzdzdz);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_turb1__VelocityHessian(struct soap *soap, const struct turb1__VelocityHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_turb1__VelocityHessian(struct soap *soap, const char *tag, int id, const struct turb1__VelocityHessian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_turb1__VelocityHessian), type))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2uxdxdx", -1, &a->d2uxdxdx, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2uxdxdy", -1, &a->d2uxdxdy, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2uxdxdz", -1, &a->d2uxdxdz, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2uxdydy", -1, &a->d2uxdydy, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2uxdydz", -1, &a->d2uxdydz, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2uxdzdz", -1, &a->d2uxdzdz, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2uydxdx", -1, &a->d2uydxdx, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2uydxdy", -1, &a->d2uydxdy, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2uydxdz", -1, &a->d2uydxdz, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2uydydy", -1, &a->d2uydydy, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2uydydz", -1, &a->d2uydydz, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2uydzdz", -1, &a->d2uydzdz, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2uzdxdx", -1, &a->d2uzdxdx, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2uzdxdy", -1, &a->d2uzdxdy, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2uzdxdz", -1, &a->d2uzdxdz, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2uzdydy", -1, &a->d2uzdydy, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2uzdydz", -1, &a->d2uzdydz, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2uzdzdz", -1, &a->d2uzdzdz, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct turb1__VelocityHessian * SOAP_FMAC4 soap_in_turb1__VelocityHessian(struct soap *soap, const char *tag, struct turb1__VelocityHessian *a, const char *type)
{
	size_t soap_flag_d2uxdxdx = 1;
	size_t soap_flag_d2uxdxdy = 1;
	size_t soap_flag_d2uxdxdz = 1;
	size_t soap_flag_d2uxdydy = 1;
	size_t soap_flag_d2uxdydz = 1;
	size_t soap_flag_d2uxdzdz = 1;
	size_t soap_flag_d2uydxdx = 1;
	size_t soap_flag_d2uydxdy = 1;
	size_t soap_flag_d2uydxdz = 1;
	size_t soap_flag_d2uydydy = 1;
	size_t soap_flag_d2uydydz = 1;
	size_t soap_flag_d2uydzdz = 1;
	size_t soap_flag_d2uzdxdx = 1;
	size_t soap_flag_d2uzdxdy = 1;
	size_t soap_flag_d2uzdxdz = 1;
	size_t soap_flag_d2uzdydy = 1;
	size_t soap_flag_d2uzdydz = 1;
	size_t soap_flag_d2uzdzdz = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct turb1__VelocityHessian *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_turb1__VelocityHessian, sizeof(struct turb1__VelocityHessian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_turb1__VelocityHessian(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_d2uxdxdx && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2uxdxdx", &a->d2uxdxdx, "xsd:float"))
				{	soap_flag_d2uxdxdx--;
					continue;
				}
			if (soap_flag_d2uxdxdy && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2uxdxdy", &a->d2uxdxdy, "xsd:float"))
				{	soap_flag_d2uxdxdy--;
					continue;
				}
			if (soap_flag_d2uxdxdz && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2uxdxdz", &a->d2uxdxdz, "xsd:float"))
				{	soap_flag_d2uxdxdz--;
					continue;
				}
			if (soap_flag_d2uxdydy && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2uxdydy", &a->d2uxdydy, "xsd:float"))
				{	soap_flag_d2uxdydy--;
					continue;
				}
			if (soap_flag_d2uxdydz && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2uxdydz", &a->d2uxdydz, "xsd:float"))
				{	soap_flag_d2uxdydz--;
					continue;
				}
			if (soap_flag_d2uxdzdz && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2uxdzdz", &a->d2uxdzdz, "xsd:float"))
				{	soap_flag_d2uxdzdz--;
					continue;
				}
			if (soap_flag_d2uydxdx && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2uydxdx", &a->d2uydxdx, "xsd:float"))
				{	soap_flag_d2uydxdx--;
					continue;
				}
			if (soap_flag_d2uydxdy && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2uydxdy", &a->d2uydxdy, "xsd:float"))
				{	soap_flag_d2uydxdy--;
					continue;
				}
			if (soap_flag_d2uydxdz && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2uydxdz", &a->d2uydxdz, "xsd:float"))
				{	soap_flag_d2uydxdz--;
					continue;
				}
			if (soap_flag_d2uydydy && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2uydydy", &a->d2uydydy, "xsd:float"))
				{	soap_flag_d2uydydy--;
					continue;
				}
			if (soap_flag_d2uydydz && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2uydydz", &a->d2uydydz, "xsd:float"))
				{	soap_flag_d2uydydz--;
					continue;
				}
			if (soap_flag_d2uydzdz && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2uydzdz", &a->d2uydzdz, "xsd:float"))
				{	soap_flag_d2uydzdz--;
					continue;
				}
			if (soap_flag_d2uzdxdx && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2uzdxdx", &a->d2uzdxdx, "xsd:float"))
				{	soap_flag_d2uzdxdx--;
					continue;
				}
			if (soap_flag_d2uzdxdy && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2uzdxdy", &a->d2uzdxdy, "xsd:float"))
				{	soap_flag_d2uzdxdy--;
					continue;
				}
			if (soap_flag_d2uzdxdz && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2uzdxdz", &a->d2uzdxdz, "xsd:float"))
				{	soap_flag_d2uzdxdz--;
					continue;
				}
			if (soap_flag_d2uzdydy && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2uzdydy", &a->d2uzdydy, "xsd:float"))
				{	soap_flag_d2uzdydy--;
					continue;
				}
			if (soap_flag_d2uzdydz && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2uzdydz", &a->d2uzdydz, "xsd:float"))
				{	soap_flag_d2uzdydz--;
					continue;
				}
			if (soap_flag_d2uzdzdz && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2uzdzdz", &a->d2uzdzdz, "xsd:float"))
				{	soap_flag_d2uzdzdz--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct turb1__VelocityHessian *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_turb1__VelocityHessian, 0, sizeof(struct turb1__VelocityHessian), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_d2uxdxdx > 0 || soap_flag_d2uxdxdy > 0 || soap_flag_d2uxdxdz > 0 || soap_flag_d2uxdydy > 0 || soap_flag_d2uxdydz > 0 || soap_flag_d2uxdzdz > 0 || soap_flag_d2uydxdx > 0 || soap_flag_d2uydxdy > 0 || soap_flag_d2uydxdz > 0 || soap_flag_d2uydydy > 0 || soap_flag_d2uydydz > 0 || soap_flag_d2uydzdz > 0 || soap_flag_d2uzdxdx > 0 || soap_flag_d2uzdxdy > 0 || soap_flag_d2uzdxdz > 0 || soap_flag_d2uzdydy > 0 || soap_flag_d2uzdydz > 0 || soap_flag_d2uzdzdz > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_turb1__VelocityHessian(struct soap *soap, const struct turb1__VelocityHessian *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_turb1__VelocityHessian);
	if (soap_out_turb1__VelocityHessian(soap, tag?tag:"turb1:VelocityHessian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__VelocityHessian * SOAP_FMAC4 soap_get_turb1__VelocityHessian(struct soap *soap, struct turb1__VelocityHessian *p, const char *tag, const char *type)
{
	if ((p = soap_in_turb1__VelocityHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_turb1__ArrayOfVelocityHessian(struct soap *soap, struct turb1__ArrayOfVelocityHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeVelocityHessian = 0;
	a->VelocityHessian = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_turb1__ArrayOfVelocityHessian(struct soap *soap, const struct turb1__ArrayOfVelocityHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->VelocityHessian)
	{	int i;
		for (i = 0; i < a->__sizeVelocityHessian; i++)
		{
			soap_embedded(soap, a->VelocityHessian + i, SOAP_TYPE_turb1__VelocityHessian);
			soap_serialize_turb1__VelocityHessian(soap, a->VelocityHessian + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_turb1__ArrayOfVelocityHessian(struct soap *soap, const char *tag, int id, const struct turb1__ArrayOfVelocityHessian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_turb1__ArrayOfVelocityHessian), type))
		return soap->error;
	if (a->VelocityHessian)
	{	int i;
		for (i = 0; i < a->__sizeVelocityHessian; i++)
			if (soap_out_turb1__VelocityHessian(soap, "turb1:VelocityHessian", -1, a->VelocityHessian + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct turb1__ArrayOfVelocityHessian * SOAP_FMAC4 soap_in_turb1__ArrayOfVelocityHessian(struct soap *soap, const char *tag, struct turb1__ArrayOfVelocityHessian *a, const char *type)
{
	struct soap_blist *soap_blist_VelocityHessian = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct turb1__ArrayOfVelocityHessian *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_turb1__ArrayOfVelocityHessian, sizeof(struct turb1__ArrayOfVelocityHessian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_turb1__ArrayOfVelocityHessian(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "turb1:VelocityHessian", 1, NULL))
			{	if (a->VelocityHessian == NULL)
				{	if (soap_blist_VelocityHessian == NULL)
						soap_blist_VelocityHessian = soap_new_block(soap);
					a->VelocityHessian = (struct turb1__VelocityHessian *)soap_push_block(soap, soap_blist_VelocityHessian, sizeof(struct turb1__VelocityHessian));
					if (a->VelocityHessian == NULL)
						return NULL;
					soap_default_turb1__VelocityHessian(soap, a->VelocityHessian);
				}
				soap_revert(soap);
				if (soap_in_turb1__VelocityHessian(soap, "turb1:VelocityHessian", a->VelocityHessian, "turb1:VelocityHessian"))
				{	a->__sizeVelocityHessian++;
					a->VelocityHessian = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->VelocityHessian)
			soap_pop_block(soap, soap_blist_VelocityHessian);
		if (a->__sizeVelocityHessian)
			a->VelocityHessian = (struct turb1__VelocityHessian *)soap_save_block(soap, soap_blist_VelocityHessian, NULL, 1);
		else
		{	a->VelocityHessian = NULL;
			if (soap_blist_VelocityHessian)
				soap_end_block(soap, soap_blist_VelocityHessian);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct turb1__ArrayOfVelocityHessian *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_turb1__ArrayOfVelocityHessian, 0, sizeof(struct turb1__ArrayOfVelocityHessian), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_turb1__ArrayOfVelocityHessian(struct soap *soap, const struct turb1__ArrayOfVelocityHessian *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_turb1__ArrayOfVelocityHessian);
	if (soap_out_turb1__ArrayOfVelocityHessian(soap, tag?tag:"turb1:ArrayOfVelocityHessian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__ArrayOfVelocityHessian * SOAP_FMAC4 soap_get_turb1__ArrayOfVelocityHessian(struct soap *soap, struct turb1__ArrayOfVelocityHessian *p, const char *tag, const char *type)
{
	if ((p = soap_in_turb1__ArrayOfVelocityHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_turb1__VelocityGradient(struct soap *soap, struct turb1__VelocityGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_float(soap, &a->duxdx);
	soap_default_float(soap, &a->duxdy);
	soap_default_float(soap, &a->duxdz);
	soap_default_float(soap, &a->duydx);
	soap_default_float(soap, &a->duydy);
	soap_default_float(soap, &a->duydz);
	soap_default_float(soap, &a->duzdx);
	soap_default_float(soap, &a->duzdy);
	soap_default_float(soap, &a->duzdz);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_turb1__VelocityGradient(struct soap *soap, const struct turb1__VelocityGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_turb1__VelocityGradient(struct soap *soap, const char *tag, int id, const struct turb1__VelocityGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_turb1__VelocityGradient), type))
		return soap->error;
	if (soap_out_float(soap, "turb1:duxdx", -1, &a->duxdx, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:duxdy", -1, &a->duxdy, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:duxdz", -1, &a->duxdz, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:duydx", -1, &a->duydx, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:duydy", -1, &a->duydy, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:duydz", -1, &a->duydz, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:duzdx", -1, &a->duzdx, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:duzdy", -1, &a->duzdy, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:duzdz", -1, &a->duzdz, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct turb1__VelocityGradient * SOAP_FMAC4 soap_in_turb1__VelocityGradient(struct soap *soap, const char *tag, struct turb1__VelocityGradient *a, const char *type)
{
	size_t soap_flag_duxdx = 1;
	size_t soap_flag_duxdy = 1;
	size_t soap_flag_duxdz = 1;
	size_t soap_flag_duydx = 1;
	size_t soap_flag_duydy = 1;
	size_t soap_flag_duydz = 1;
	size_t soap_flag_duzdx = 1;
	size_t soap_flag_duzdy = 1;
	size_t soap_flag_duzdz = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct turb1__VelocityGradient *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_turb1__VelocityGradient, sizeof(struct turb1__VelocityGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_turb1__VelocityGradient(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_duxdx && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:duxdx", &a->duxdx, "xsd:float"))
				{	soap_flag_duxdx--;
					continue;
				}
			if (soap_flag_duxdy && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:duxdy", &a->duxdy, "xsd:float"))
				{	soap_flag_duxdy--;
					continue;
				}
			if (soap_flag_duxdz && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:duxdz", &a->duxdz, "xsd:float"))
				{	soap_flag_duxdz--;
					continue;
				}
			if (soap_flag_duydx && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:duydx", &a->duydx, "xsd:float"))
				{	soap_flag_duydx--;
					continue;
				}
			if (soap_flag_duydy && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:duydy", &a->duydy, "xsd:float"))
				{	soap_flag_duydy--;
					continue;
				}
			if (soap_flag_duydz && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:duydz", &a->duydz, "xsd:float"))
				{	soap_flag_duydz--;
					continue;
				}
			if (soap_flag_duzdx && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:duzdx", &a->duzdx, "xsd:float"))
				{	soap_flag_duzdx--;
					continue;
				}
			if (soap_flag_duzdy && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:duzdy", &a->duzdy, "xsd:float"))
				{	soap_flag_duzdy--;
					continue;
				}
			if (soap_flag_duzdz && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:duzdz", &a->duzdz, "xsd:float"))
				{	soap_flag_duzdz--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct turb1__VelocityGradient *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_turb1__VelocityGradient, 0, sizeof(struct turb1__VelocityGradient), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_duxdx > 0 || soap_flag_duxdy > 0 || soap_flag_duxdz > 0 || soap_flag_duydx > 0 || soap_flag_duydy > 0 || soap_flag_duydz > 0 || soap_flag_duzdx > 0 || soap_flag_duzdy > 0 || soap_flag_duzdz > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_turb1__VelocityGradient(struct soap *soap, const struct turb1__VelocityGradient *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_turb1__VelocityGradient);
	if (soap_out_turb1__VelocityGradient(soap, tag?tag:"turb1:VelocityGradient", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__VelocityGradient * SOAP_FMAC4 soap_get_turb1__VelocityGradient(struct soap *soap, struct turb1__VelocityGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in_turb1__VelocityGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_turb1__ArrayOfVelocityGradient(struct soap *soap, struct turb1__ArrayOfVelocityGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeVelocityGradient = 0;
	a->VelocityGradient = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_turb1__ArrayOfVelocityGradient(struct soap *soap, const struct turb1__ArrayOfVelocityGradient *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->VelocityGradient)
	{	int i;
		for (i = 0; i < a->__sizeVelocityGradient; i++)
		{
			soap_embedded(soap, a->VelocityGradient + i, SOAP_TYPE_turb1__VelocityGradient);
			soap_serialize_turb1__VelocityGradient(soap, a->VelocityGradient + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_turb1__ArrayOfVelocityGradient(struct soap *soap, const char *tag, int id, const struct turb1__ArrayOfVelocityGradient *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_turb1__ArrayOfVelocityGradient), type))
		return soap->error;
	if (a->VelocityGradient)
	{	int i;
		for (i = 0; i < a->__sizeVelocityGradient; i++)
			if (soap_out_turb1__VelocityGradient(soap, "turb1:VelocityGradient", -1, a->VelocityGradient + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct turb1__ArrayOfVelocityGradient * SOAP_FMAC4 soap_in_turb1__ArrayOfVelocityGradient(struct soap *soap, const char *tag, struct turb1__ArrayOfVelocityGradient *a, const char *type)
{
	struct soap_blist *soap_blist_VelocityGradient = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct turb1__ArrayOfVelocityGradient *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_turb1__ArrayOfVelocityGradient, sizeof(struct turb1__ArrayOfVelocityGradient), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_turb1__ArrayOfVelocityGradient(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "turb1:VelocityGradient", 1, NULL))
			{	if (a->VelocityGradient == NULL)
				{	if (soap_blist_VelocityGradient == NULL)
						soap_blist_VelocityGradient = soap_new_block(soap);
					a->VelocityGradient = (struct turb1__VelocityGradient *)soap_push_block(soap, soap_blist_VelocityGradient, sizeof(struct turb1__VelocityGradient));
					if (a->VelocityGradient == NULL)
						return NULL;
					soap_default_turb1__VelocityGradient(soap, a->VelocityGradient);
				}
				soap_revert(soap);
				if (soap_in_turb1__VelocityGradient(soap, "turb1:VelocityGradient", a->VelocityGradient, "turb1:VelocityGradient"))
				{	a->__sizeVelocityGradient++;
					a->VelocityGradient = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->VelocityGradient)
			soap_pop_block(soap, soap_blist_VelocityGradient);
		if (a->__sizeVelocityGradient)
			a->VelocityGradient = (struct turb1__VelocityGradient *)soap_save_block(soap, soap_blist_VelocityGradient, NULL, 1);
		else
		{	a->VelocityGradient = NULL;
			if (soap_blist_VelocityGradient)
				soap_end_block(soap, soap_blist_VelocityGradient);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct turb1__ArrayOfVelocityGradient *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_turb1__ArrayOfVelocityGradient, 0, sizeof(struct turb1__ArrayOfVelocityGradient), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_turb1__ArrayOfVelocityGradient(struct soap *soap, const struct turb1__ArrayOfVelocityGradient *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_turb1__ArrayOfVelocityGradient);
	if (soap_out_turb1__ArrayOfVelocityGradient(soap, tag?tag:"turb1:ArrayOfVelocityGradient", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__ArrayOfVelocityGradient * SOAP_FMAC4 soap_get_turb1__ArrayOfVelocityGradient(struct soap *soap, struct turb1__ArrayOfVelocityGradient *p, const char *tag, const char *type)
{
	if ((p = soap_in_turb1__ArrayOfVelocityGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_turb1__Vector3P(struct soap *soap, struct turb1__Vector3P *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_float(soap, &a->x);
	soap_default_float(soap, &a->y);
	soap_default_float(soap, &a->z);
	soap_default_float(soap, &a->p);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_turb1__Vector3P(struct soap *soap, const struct turb1__Vector3P *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_turb1__Vector3P(struct soap *soap, const char *tag, int id, const struct turb1__Vector3P *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_turb1__Vector3P), type))
		return soap->error;
	if (soap_out_float(soap, "turb1:x", -1, &a->x, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:y", -1, &a->y, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:z", -1, &a->z, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:p", -1, &a->p, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct turb1__Vector3P * SOAP_FMAC4 soap_in_turb1__Vector3P(struct soap *soap, const char *tag, struct turb1__Vector3P *a, const char *type)
{
	size_t soap_flag_x = 1;
	size_t soap_flag_y = 1;
	size_t soap_flag_z = 1;
	size_t soap_flag_p = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct turb1__Vector3P *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_turb1__Vector3P, sizeof(struct turb1__Vector3P), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_turb1__Vector3P(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_x && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:x", &a->x, "xsd:float"))
				{	soap_flag_x--;
					continue;
				}
			if (soap_flag_y && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:y", &a->y, "xsd:float"))
				{	soap_flag_y--;
					continue;
				}
			if (soap_flag_z && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:z", &a->z, "xsd:float"))
				{	soap_flag_z--;
					continue;
				}
			if (soap_flag_p && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:p", &a->p, "xsd:float"))
				{	soap_flag_p--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct turb1__Vector3P *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_turb1__Vector3P, 0, sizeof(struct turb1__Vector3P), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_x > 0 || soap_flag_y > 0 || soap_flag_z > 0 || soap_flag_p > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_turb1__Vector3P(struct soap *soap, const struct turb1__Vector3P *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_turb1__Vector3P);
	if (soap_out_turb1__Vector3P(soap, tag?tag:"turb1:Vector3P", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__Vector3P * SOAP_FMAC4 soap_get_turb1__Vector3P(struct soap *soap, struct turb1__Vector3P *p, const char *tag, const char *type)
{
	if ((p = soap_in_turb1__Vector3P(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_turb1__ArrayOfVector3P(struct soap *soap, struct turb1__ArrayOfVector3P *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeVector3P = 0;
	a->Vector3P = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_turb1__ArrayOfVector3P(struct soap *soap, const struct turb1__ArrayOfVector3P *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->Vector3P)
	{	int i;
		for (i = 0; i < a->__sizeVector3P; i++)
		{
			soap_embedded(soap, a->Vector3P + i, SOAP_TYPE_turb1__Vector3P);
			soap_serialize_turb1__Vector3P(soap, a->Vector3P + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_turb1__ArrayOfVector3P(struct soap *soap, const char *tag, int id, const struct turb1__ArrayOfVector3P *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_turb1__ArrayOfVector3P), type))
		return soap->error;
	if (a->Vector3P)
	{	int i;
		for (i = 0; i < a->__sizeVector3P; i++)
			if (soap_out_turb1__Vector3P(soap, "turb1:Vector3P", -1, a->Vector3P + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct turb1__ArrayOfVector3P * SOAP_FMAC4 soap_in_turb1__ArrayOfVector3P(struct soap *soap, const char *tag, struct turb1__ArrayOfVector3P *a, const char *type)
{
	struct soap_blist *soap_blist_Vector3P = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct turb1__ArrayOfVector3P *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_turb1__ArrayOfVector3P, sizeof(struct turb1__ArrayOfVector3P), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_turb1__ArrayOfVector3P(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "turb1:Vector3P", 1, NULL))
			{	if (a->Vector3P == NULL)
				{	if (soap_blist_Vector3P == NULL)
						soap_blist_Vector3P = soap_new_block(soap);
					a->Vector3P = (struct turb1__Vector3P *)soap_push_block(soap, soap_blist_Vector3P, sizeof(struct turb1__Vector3P));
					if (a->Vector3P == NULL)
						return NULL;
					soap_default_turb1__Vector3P(soap, a->Vector3P);
				}
				soap_revert(soap);
				if (soap_in_turb1__Vector3P(soap, "turb1:Vector3P", a->Vector3P, "turb1:Vector3P"))
				{	a->__sizeVector3P++;
					a->Vector3P = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->Vector3P)
			soap_pop_block(soap, soap_blist_Vector3P);
		if (a->__sizeVector3P)
			a->Vector3P = (struct turb1__Vector3P *)soap_save_block(soap, soap_blist_Vector3P, NULL, 1);
		else
		{	a->Vector3P = NULL;
			if (soap_blist_Vector3P)
				soap_end_block(soap, soap_blist_Vector3P);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct turb1__ArrayOfVector3P *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_turb1__ArrayOfVector3P, 0, sizeof(struct turb1__ArrayOfVector3P), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_turb1__ArrayOfVector3P(struct soap *soap, const struct turb1__ArrayOfVector3P *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_turb1__ArrayOfVector3P);
	if (soap_out_turb1__ArrayOfVector3P(soap, tag?tag:"turb1:ArrayOfVector3P", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__ArrayOfVector3P * SOAP_FMAC4 soap_get_turb1__ArrayOfVector3P(struct soap *soap, struct turb1__ArrayOfVector3P *p, const char *tag, const char *type)
{
	if ((p = soap_in_turb1__ArrayOfVector3P(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_turb1__PressureHessian(struct soap *soap, struct turb1__PressureHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_float(soap, &a->d2pdxdx);
	soap_default_float(soap, &a->d2pdxdy);
	soap_default_float(soap, &a->d2pdxdz);
	soap_default_float(soap, &a->d2pdydy);
	soap_default_float(soap, &a->d2pdydz);
	soap_default_float(soap, &a->d2pdzdz);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_turb1__PressureHessian(struct soap *soap, const struct turb1__PressureHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_turb1__PressureHessian(struct soap *soap, const char *tag, int id, const struct turb1__PressureHessian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_turb1__PressureHessian), type))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2pdxdx", -1, &a->d2pdxdx, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2pdxdy", -1, &a->d2pdxdy, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2pdxdz", -1, &a->d2pdxdz, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2pdydy", -1, &a->d2pdydy, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2pdydz", -1, &a->d2pdydz, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:d2pdzdz", -1, &a->d2pdzdz, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct turb1__PressureHessian * SOAP_FMAC4 soap_in_turb1__PressureHessian(struct soap *soap, const char *tag, struct turb1__PressureHessian *a, const char *type)
{
	size_t soap_flag_d2pdxdx = 1;
	size_t soap_flag_d2pdxdy = 1;
	size_t soap_flag_d2pdxdz = 1;
	size_t soap_flag_d2pdydy = 1;
	size_t soap_flag_d2pdydz = 1;
	size_t soap_flag_d2pdzdz = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct turb1__PressureHessian *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_turb1__PressureHessian, sizeof(struct turb1__PressureHessian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_turb1__PressureHessian(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_d2pdxdx && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2pdxdx", &a->d2pdxdx, "xsd:float"))
				{	soap_flag_d2pdxdx--;
					continue;
				}
			if (soap_flag_d2pdxdy && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2pdxdy", &a->d2pdxdy, "xsd:float"))
				{	soap_flag_d2pdxdy--;
					continue;
				}
			if (soap_flag_d2pdxdz && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2pdxdz", &a->d2pdxdz, "xsd:float"))
				{	soap_flag_d2pdxdz--;
					continue;
				}
			if (soap_flag_d2pdydy && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2pdydy", &a->d2pdydy, "xsd:float"))
				{	soap_flag_d2pdydy--;
					continue;
				}
			if (soap_flag_d2pdydz && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2pdydz", &a->d2pdydz, "xsd:float"))
				{	soap_flag_d2pdydz--;
					continue;
				}
			if (soap_flag_d2pdzdz && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:d2pdzdz", &a->d2pdzdz, "xsd:float"))
				{	soap_flag_d2pdzdz--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct turb1__PressureHessian *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_turb1__PressureHessian, 0, sizeof(struct turb1__PressureHessian), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_d2pdxdx > 0 || soap_flag_d2pdxdy > 0 || soap_flag_d2pdxdz > 0 || soap_flag_d2pdydy > 0 || soap_flag_d2pdydz > 0 || soap_flag_d2pdzdz > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_turb1__PressureHessian(struct soap *soap, const struct turb1__PressureHessian *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_turb1__PressureHessian);
	if (soap_out_turb1__PressureHessian(soap, tag?tag:"turb1:PressureHessian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__PressureHessian * SOAP_FMAC4 soap_get_turb1__PressureHessian(struct soap *soap, struct turb1__PressureHessian *p, const char *tag, const char *type)
{
	if ((p = soap_in_turb1__PressureHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_turb1__ArrayOfPressureHessian(struct soap *soap, struct turb1__ArrayOfPressureHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizePressureHessian = 0;
	a->PressureHessian = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_turb1__ArrayOfPressureHessian(struct soap *soap, const struct turb1__ArrayOfPressureHessian *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->PressureHessian)
	{	int i;
		for (i = 0; i < a->__sizePressureHessian; i++)
		{
			soap_embedded(soap, a->PressureHessian + i, SOAP_TYPE_turb1__PressureHessian);
			soap_serialize_turb1__PressureHessian(soap, a->PressureHessian + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_turb1__ArrayOfPressureHessian(struct soap *soap, const char *tag, int id, const struct turb1__ArrayOfPressureHessian *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_turb1__ArrayOfPressureHessian), type))
		return soap->error;
	if (a->PressureHessian)
	{	int i;
		for (i = 0; i < a->__sizePressureHessian; i++)
			if (soap_out_turb1__PressureHessian(soap, "turb1:PressureHessian", -1, a->PressureHessian + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct turb1__ArrayOfPressureHessian * SOAP_FMAC4 soap_in_turb1__ArrayOfPressureHessian(struct soap *soap, const char *tag, struct turb1__ArrayOfPressureHessian *a, const char *type)
{
	struct soap_blist *soap_blist_PressureHessian = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct turb1__ArrayOfPressureHessian *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_turb1__ArrayOfPressureHessian, sizeof(struct turb1__ArrayOfPressureHessian), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_turb1__ArrayOfPressureHessian(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "turb1:PressureHessian", 1, NULL))
			{	if (a->PressureHessian == NULL)
				{	if (soap_blist_PressureHessian == NULL)
						soap_blist_PressureHessian = soap_new_block(soap);
					a->PressureHessian = (struct turb1__PressureHessian *)soap_push_block(soap, soap_blist_PressureHessian, sizeof(struct turb1__PressureHessian));
					if (a->PressureHessian == NULL)
						return NULL;
					soap_default_turb1__PressureHessian(soap, a->PressureHessian);
				}
				soap_revert(soap);
				if (soap_in_turb1__PressureHessian(soap, "turb1:PressureHessian", a->PressureHessian, "turb1:PressureHessian"))
				{	a->__sizePressureHessian++;
					a->PressureHessian = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->PressureHessian)
			soap_pop_block(soap, soap_blist_PressureHessian);
		if (a->__sizePressureHessian)
			a->PressureHessian = (struct turb1__PressureHessian *)soap_save_block(soap, soap_blist_PressureHessian, NULL, 1);
		else
		{	a->PressureHessian = NULL;
			if (soap_blist_PressureHessian)
				soap_end_block(soap, soap_blist_PressureHessian);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct turb1__ArrayOfPressureHessian *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_turb1__ArrayOfPressureHessian, 0, sizeof(struct turb1__ArrayOfPressureHessian), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_turb1__ArrayOfPressureHessian(struct soap *soap, const struct turb1__ArrayOfPressureHessian *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_turb1__ArrayOfPressureHessian);
	if (soap_out_turb1__ArrayOfPressureHessian(soap, tag?tag:"turb1:ArrayOfPressureHessian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__ArrayOfPressureHessian * SOAP_FMAC4 soap_get_turb1__ArrayOfPressureHessian(struct soap *soap, struct turb1__ArrayOfPressureHessian *p, const char *tag, const char *type)
{
	if ((p = soap_in_turb1__ArrayOfPressureHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_turb1__Pressure(struct soap *soap, struct turb1__Pressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_float(soap, &a->p);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_turb1__Pressure(struct soap *soap, const struct turb1__Pressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_turb1__Pressure(struct soap *soap, const char *tag, int id, const struct turb1__Pressure *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_turb1__Pressure), type))
		return soap->error;
	if (soap_out_float(soap, "turb1:p", -1, &a->p, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct turb1__Pressure * SOAP_FMAC4 soap_in_turb1__Pressure(struct soap *soap, const char *tag, struct turb1__Pressure *a, const char *type)
{
	size_t soap_flag_p = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct turb1__Pressure *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_turb1__Pressure, sizeof(struct turb1__Pressure), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_turb1__Pressure(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_p && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:p", &a->p, "xsd:float"))
				{	soap_flag_p--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct turb1__Pressure *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_turb1__Pressure, 0, sizeof(struct turb1__Pressure), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_p > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_turb1__Pressure(struct soap *soap, const struct turb1__Pressure *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_turb1__Pressure);
	if (soap_out_turb1__Pressure(soap, tag?tag:"turb1:Pressure", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__Pressure * SOAP_FMAC4 soap_get_turb1__Pressure(struct soap *soap, struct turb1__Pressure *p, const char *tag, const char *type)
{
	if ((p = soap_in_turb1__Pressure(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_turb1__ArrayOfPressure(struct soap *soap, struct turb1__ArrayOfPressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizePressure = 0;
	a->Pressure = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_turb1__ArrayOfPressure(struct soap *soap, const struct turb1__ArrayOfPressure *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->Pressure)
	{	int i;
		for (i = 0; i < a->__sizePressure; i++)
		{
			soap_embedded(soap, a->Pressure + i, SOAP_TYPE_turb1__Pressure);
			soap_serialize_turb1__Pressure(soap, a->Pressure + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_turb1__ArrayOfPressure(struct soap *soap, const char *tag, int id, const struct turb1__ArrayOfPressure *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_turb1__ArrayOfPressure), type))
		return soap->error;
	if (a->Pressure)
	{	int i;
		for (i = 0; i < a->__sizePressure; i++)
			if (soap_out_turb1__Pressure(soap, "turb1:Pressure", -1, a->Pressure + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct turb1__ArrayOfPressure * SOAP_FMAC4 soap_in_turb1__ArrayOfPressure(struct soap *soap, const char *tag, struct turb1__ArrayOfPressure *a, const char *type)
{
	struct soap_blist *soap_blist_Pressure = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct turb1__ArrayOfPressure *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_turb1__ArrayOfPressure, sizeof(struct turb1__ArrayOfPressure), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_turb1__ArrayOfPressure(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "turb1:Pressure", 1, NULL))
			{	if (a->Pressure == NULL)
				{	if (soap_blist_Pressure == NULL)
						soap_blist_Pressure = soap_new_block(soap);
					a->Pressure = (struct turb1__Pressure *)soap_push_block(soap, soap_blist_Pressure, sizeof(struct turb1__Pressure));
					if (a->Pressure == NULL)
						return NULL;
					soap_default_turb1__Pressure(soap, a->Pressure);
				}
				soap_revert(soap);
				if (soap_in_turb1__Pressure(soap, "turb1:Pressure", a->Pressure, "turb1:Pressure"))
				{	a->__sizePressure++;
					a->Pressure = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->Pressure)
			soap_pop_block(soap, soap_blist_Pressure);
		if (a->__sizePressure)
			a->Pressure = (struct turb1__Pressure *)soap_save_block(soap, soap_blist_Pressure, NULL, 1);
		else
		{	a->Pressure = NULL;
			if (soap_blist_Pressure)
				soap_end_block(soap, soap_blist_Pressure);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct turb1__ArrayOfPressure *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_turb1__ArrayOfPressure, 0, sizeof(struct turb1__ArrayOfPressure), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_turb1__ArrayOfPressure(struct soap *soap, const struct turb1__ArrayOfPressure *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_turb1__ArrayOfPressure);
	if (soap_out_turb1__ArrayOfPressure(soap, tag?tag:"turb1:ArrayOfPressure", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__ArrayOfPressure * SOAP_FMAC4 soap_get_turb1__ArrayOfPressure(struct soap *soap, struct turb1__ArrayOfPressure *p, const char *tag, const char *type)
{
	if ((p = soap_in_turb1__ArrayOfPressure(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_turb1__Vector3(struct soap *soap, struct turb1__Vector3 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_float(soap, &a->x);
	soap_default_float(soap, &a->y);
	soap_default_float(soap, &a->z);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_turb1__Vector3(struct soap *soap, const struct turb1__Vector3 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_turb1__Vector3(struct soap *soap, const char *tag, int id, const struct turb1__Vector3 *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_turb1__Vector3), type))
		return soap->error;
	if (soap_out_float(soap, "turb1:x", -1, &a->x, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:y", -1, &a->y, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:z", -1, &a->z, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct turb1__Vector3 * SOAP_FMAC4 soap_in_turb1__Vector3(struct soap *soap, const char *tag, struct turb1__Vector3 *a, const char *type)
{
	size_t soap_flag_x = 1;
	size_t soap_flag_y = 1;
	size_t soap_flag_z = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct turb1__Vector3 *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_turb1__Vector3, sizeof(struct turb1__Vector3), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_turb1__Vector3(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_x && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:x", &a->x, "xsd:float"))
				{	soap_flag_x--;
					continue;
				}
			if (soap_flag_y && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:y", &a->y, "xsd:float"))
				{	soap_flag_y--;
					continue;
				}
			if (soap_flag_z && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:z", &a->z, "xsd:float"))
				{	soap_flag_z--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct turb1__Vector3 *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_turb1__Vector3, 0, sizeof(struct turb1__Vector3), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_x > 0 || soap_flag_y > 0 || soap_flag_z > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_turb1__Vector3(struct soap *soap, const struct turb1__Vector3 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_turb1__Vector3);
	if (soap_out_turb1__Vector3(soap, tag?tag:"turb1:Vector3", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__Vector3 * SOAP_FMAC4 soap_get_turb1__Vector3(struct soap *soap, struct turb1__Vector3 *p, const char *tag, const char *type)
{
	if ((p = soap_in_turb1__Vector3(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_turb1__ArrayOfVector3(struct soap *soap, struct turb1__ArrayOfVector3 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeVector3 = 0;
	a->Vector3 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_turb1__ArrayOfVector3(struct soap *soap, const struct turb1__ArrayOfVector3 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->Vector3)
	{	int i;
		for (i = 0; i < a->__sizeVector3; i++)
		{
			soap_embedded(soap, a->Vector3 + i, SOAP_TYPE_turb1__Vector3);
			soap_serialize_turb1__Vector3(soap, a->Vector3 + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_turb1__ArrayOfVector3(struct soap *soap, const char *tag, int id, const struct turb1__ArrayOfVector3 *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_turb1__ArrayOfVector3), type))
		return soap->error;
	if (a->Vector3)
	{	int i;
		for (i = 0; i < a->__sizeVector3; i++)
			if (soap_out_turb1__Vector3(soap, "turb1:Vector3", -1, a->Vector3 + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct turb1__ArrayOfVector3 * SOAP_FMAC4 soap_in_turb1__ArrayOfVector3(struct soap *soap, const char *tag, struct turb1__ArrayOfVector3 *a, const char *type)
{
	struct soap_blist *soap_blist_Vector3 = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct turb1__ArrayOfVector3 *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_turb1__ArrayOfVector3, sizeof(struct turb1__ArrayOfVector3), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_turb1__ArrayOfVector3(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "turb1:Vector3", 1, NULL))
			{	if (a->Vector3 == NULL)
				{	if (soap_blist_Vector3 == NULL)
						soap_blist_Vector3 = soap_new_block(soap);
					a->Vector3 = (struct turb1__Vector3 *)soap_push_block(soap, soap_blist_Vector3, sizeof(struct turb1__Vector3));
					if (a->Vector3 == NULL)
						return NULL;
					soap_default_turb1__Vector3(soap, a->Vector3);
				}
				soap_revert(soap);
				if (soap_in_turb1__Vector3(soap, "turb1:Vector3", a->Vector3, "turb1:Vector3"))
				{	a->__sizeVector3++;
					a->Vector3 = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->Vector3)
			soap_pop_block(soap, soap_blist_Vector3);
		if (a->__sizeVector3)
			a->Vector3 = (struct turb1__Vector3 *)soap_save_block(soap, soap_blist_Vector3, NULL, 1);
		else
		{	a->Vector3 = NULL;
			if (soap_blist_Vector3)
				soap_end_block(soap, soap_blist_Vector3);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct turb1__ArrayOfVector3 *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_turb1__ArrayOfVector3, 0, sizeof(struct turb1__ArrayOfVector3), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_turb1__ArrayOfVector3(struct soap *soap, const struct turb1__ArrayOfVector3 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_turb1__ArrayOfVector3);
	if (soap_out_turb1__ArrayOfVector3(soap, tag?tag:"turb1:ArrayOfVector3", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__ArrayOfVector3 * SOAP_FMAC4 soap_get_turb1__ArrayOfVector3(struct soap *soap, struct turb1__ArrayOfVector3 *p, const char *tag, const char *type)
{
	if ((p = soap_in_turb1__ArrayOfVector3(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_turb1__Point3(struct soap *soap, struct turb1__Point3 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_float(soap, &a->x);
	soap_default_float(soap, &a->y);
	soap_default_float(soap, &a->z);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_turb1__Point3(struct soap *soap, const struct turb1__Point3 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_turb1__Point3(struct soap *soap, const char *tag, int id, const struct turb1__Point3 *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_turb1__Point3), type))
		return soap->error;
	if (soap_out_float(soap, "turb1:x", -1, &a->x, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:y", -1, &a->y, ""))
		return soap->error;
	if (soap_out_float(soap, "turb1:z", -1, &a->z, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct turb1__Point3 * SOAP_FMAC4 soap_in_turb1__Point3(struct soap *soap, const char *tag, struct turb1__Point3 *a, const char *type)
{
	size_t soap_flag_x = 1;
	size_t soap_flag_y = 1;
	size_t soap_flag_z = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct turb1__Point3 *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_turb1__Point3, sizeof(struct turb1__Point3), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_turb1__Point3(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_x && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:x", &a->x, "xsd:float"))
				{	soap_flag_x--;
					continue;
				}
			if (soap_flag_y && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:y", &a->y, "xsd:float"))
				{	soap_flag_y--;
					continue;
				}
			if (soap_flag_z && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "turb1:z", &a->z, "xsd:float"))
				{	soap_flag_z--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct turb1__Point3 *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_turb1__Point3, 0, sizeof(struct turb1__Point3), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_x > 0 || soap_flag_y > 0 || soap_flag_z > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_turb1__Point3(struct soap *soap, const struct turb1__Point3 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_turb1__Point3);
	if (soap_out_turb1__Point3(soap, tag?tag:"turb1:Point3", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__Point3 * SOAP_FMAC4 soap_get_turb1__Point3(struct soap *soap, struct turb1__Point3 *p, const char *tag, const char *type)
{
	if ((p = soap_in_turb1__Point3(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_turb1__ArrayOfPoint3(struct soap *soap, struct turb1__ArrayOfPoint3 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizePoint3 = 0;
	a->Point3 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_turb1__ArrayOfPoint3(struct soap *soap, const struct turb1__ArrayOfPoint3 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->Point3)
	{	int i;
		for (i = 0; i < a->__sizePoint3; i++)
		{
			soap_embedded(soap, a->Point3 + i, SOAP_TYPE_turb1__Point3);
			soap_serialize_turb1__Point3(soap, a->Point3 + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_turb1__ArrayOfPoint3(struct soap *soap, const char *tag, int id, const struct turb1__ArrayOfPoint3 *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_turb1__ArrayOfPoint3), type))
		return soap->error;
	if (a->Point3)
	{	int i;
		for (i = 0; i < a->__sizePoint3; i++)
			if (soap_out_turb1__Point3(soap, "turb1:Point3", -1, a->Point3 + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct turb1__ArrayOfPoint3 * SOAP_FMAC4 soap_in_turb1__ArrayOfPoint3(struct soap *soap, const char *tag, struct turb1__ArrayOfPoint3 *a, const char *type)
{
	struct soap_blist *soap_blist_Point3 = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct turb1__ArrayOfPoint3 *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_turb1__ArrayOfPoint3, sizeof(struct turb1__ArrayOfPoint3), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_turb1__ArrayOfPoint3(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "turb1:Point3", 1, NULL))
			{	if (a->Point3 == NULL)
				{	if (soap_blist_Point3 == NULL)
						soap_blist_Point3 = soap_new_block(soap);
					a->Point3 = (struct turb1__Point3 *)soap_push_block(soap, soap_blist_Point3, sizeof(struct turb1__Point3));
					if (a->Point3 == NULL)
						return NULL;
					soap_default_turb1__Point3(soap, a->Point3);
				}
				soap_revert(soap);
				if (soap_in_turb1__Point3(soap, "turb1:Point3", a->Point3, "turb1:Point3"))
				{	a->__sizePoint3++;
					a->Point3 = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->Point3)
			soap_pop_block(soap, soap_blist_Point3);
		if (a->__sizePoint3)
			a->Point3 = (struct turb1__Point3 *)soap_save_block(soap, soap_blist_Point3, NULL, 1);
		else
		{	a->Point3 = NULL;
			if (soap_blist_Point3)
				soap_end_block(soap, soap_blist_Point3);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct turb1__ArrayOfPoint3 *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_turb1__ArrayOfPoint3, 0, sizeof(struct turb1__ArrayOfPoint3), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_turb1__ArrayOfPoint3(struct soap *soap, const struct turb1__ArrayOfPoint3 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_turb1__ArrayOfPoint3);
	if (soap_out_turb1__ArrayOfPoint3(soap, tag?tag:"turb1:ArrayOfPoint3", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__ArrayOfPoint3 * SOAP_FMAC4 soap_get_turb1__ArrayOfPoint3(struct soap *soap, struct turb1__ArrayOfPoint3 *p, const char *tag, const char *type)
{
	if ((p = soap_in_turb1__ArrayOfPoint3(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__base64Binary(struct soap *soap, struct xsd__base64Binary *a)
{	(void)soap;
	(void)soap; /* appease -Wall -Werror */
	a->__size = 0;
	a->__ptr = NULL;
	a->id = NULL;
	a->type = NULL;
	a->options = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__base64Binary(struct soap *soap, struct xsd__base64Binary const*a)
{
	if (a->__ptr && !soap_array_reference(soap, a, (struct soap_array*)&a->__ptr, 1, SOAP_TYPE_xsd__base64Binary))
		if (a->id || a->type)
			soap->mode |= SOAP_ENC_DIME;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__base64Binary(struct soap *soap, const char *tag, int id, const struct xsd__base64Binary *a, const char *type)
{
#ifndef WITH_LEANER
	id = soap_attachment(soap, tag, id, a, (struct soap_array*)&a->__ptr, a->id, a->type, a->options, 1, type, SOAP_TYPE_xsd__base64Binary);
#else
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_xsd__base64Binary);
#endif
	if (id < 0)
		return soap->error;
	if (soap_element_begin_out(soap, tag, id, type))
		return soap->error;
	if (soap_putbase64(soap, a->__ptr, a->__size))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct xsd__base64Binary * SOAP_FMAC4 soap_in_xsd__base64Binary(struct soap *soap, const char *tag, struct xsd__base64Binary *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":base64Binary") && soap_match_tag(soap, soap->type, ":base64"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct xsd__base64Binary *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__base64Binary, sizeof(struct xsd__base64Binary), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_xsd__base64Binary(soap, a);
	if (soap->body && !*soap->href)
	{
		a->__ptr = soap_getbase64(soap, &a->__size, 0);
#ifndef WITH_LEANER
		if (soap_xop_forward(soap, &a->__ptr, &a->__size, &a->id, &a->type, &a->options))
			return NULL;
#endif
		if ((!a->__ptr && soap->error) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{
#ifndef WITH_LEANER
		if (*soap->href != '#')
		{	if (soap_dime_forward(soap, &a->__ptr, &a->__size, &a->id, &a->type, &a->options))
				return NULL;
		}
		else
#endif
			a = (struct xsd__base64Binary *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xsd__base64Binary, 0, sizeof(struct xsd__base64Binary), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__base64Binary(struct soap *soap, const struct xsd__base64Binary *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, (struct soap_array*)&a->__ptr, 1, tag, SOAP_TYPE_xsd__base64Binary);
	if (soap_out_xsd__base64Binary(soap, tag?tag:"xsd:base64Binary", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xsd__base64Binary * SOAP_FMAC4 soap_get_xsd__base64Binary(struct soap *soap, struct xsd__base64Binary *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__base64Binary(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetLaplacianOfGradientResponse(struct soap *soap, struct _turb1__GetLaplacianOfGradientResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetLaplacianOfGradientResponse))
		soap_serialize__turb1__GetLaplacianOfGradientResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetLaplacianOfGradientResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetLaplacianOfGradientResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetLaplacianOfGradientResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetLaplacianOfGradientResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetLaplacianOfGradientResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetLaplacianOfGradientResponse(struct soap *soap, const char *tag, struct _turb1__GetLaplacianOfGradientResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetLaplacianOfGradientResponse **)soap_malloc(soap, sizeof(struct _turb1__GetLaplacianOfGradientResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetLaplacianOfGradientResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetLaplacianOfGradientResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetLaplacianOfGradientResponse, sizeof(struct _turb1__GetLaplacianOfGradientResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetLaplacianOfGradientResponse(struct soap *soap, struct _turb1__GetLaplacianOfGradientResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetLaplacianOfGradientResponse);
	if (soap_out_PointerTo_turb1__GetLaplacianOfGradientResponse(soap, tag?tag:"turb1:GetLaplacianOfGradientResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetLaplacianOfGradientResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetLaplacianOfGradientResponse(struct soap *soap, struct _turb1__GetLaplacianOfGradientResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetLaplacianOfGradientResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetLaplacianOfGradient(struct soap *soap, struct _turb1__GetLaplacianOfGradient *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetLaplacianOfGradient))
		soap_serialize__turb1__GetLaplacianOfGradient(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetLaplacianOfGradient(struct soap *soap, const char *tag, int id, struct _turb1__GetLaplacianOfGradient *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetLaplacianOfGradient);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetLaplacianOfGradient(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetLaplacianOfGradient ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetLaplacianOfGradient(struct soap *soap, const char *tag, struct _turb1__GetLaplacianOfGradient **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetLaplacianOfGradient **)soap_malloc(soap, sizeof(struct _turb1__GetLaplacianOfGradient *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetLaplacianOfGradient(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetLaplacianOfGradient **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetLaplacianOfGradient, sizeof(struct _turb1__GetLaplacianOfGradient), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetLaplacianOfGradient(struct soap *soap, struct _turb1__GetLaplacianOfGradient *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetLaplacianOfGradient);
	if (soap_out_PointerTo_turb1__GetLaplacianOfGradient(soap, tag?tag:"turb1:GetLaplacianOfGradient", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetLaplacianOfGradient ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetLaplacianOfGradient(struct soap *soap, struct _turb1__GetLaplacianOfGradient **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetLaplacianOfGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetThresholdResponse(struct soap *soap, struct _turb1__GetThresholdResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetThresholdResponse))
		soap_serialize__turb1__GetThresholdResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetThresholdResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetThresholdResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetThresholdResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetThresholdResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetThresholdResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetThresholdResponse(struct soap *soap, const char *tag, struct _turb1__GetThresholdResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetThresholdResponse **)soap_malloc(soap, sizeof(struct _turb1__GetThresholdResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetThresholdResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetThresholdResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetThresholdResponse, sizeof(struct _turb1__GetThresholdResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetThresholdResponse(struct soap *soap, struct _turb1__GetThresholdResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetThresholdResponse);
	if (soap_out_PointerTo_turb1__GetThresholdResponse(soap, tag?tag:"turb1:GetThresholdResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetThresholdResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetThresholdResponse(struct soap *soap, struct _turb1__GetThresholdResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetThresholdResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetThreshold(struct soap *soap, struct _turb1__GetThreshold *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetThreshold))
		soap_serialize__turb1__GetThreshold(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetThreshold(struct soap *soap, const char *tag, int id, struct _turb1__GetThreshold *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetThreshold);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetThreshold(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetThreshold ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetThreshold(struct soap *soap, const char *tag, struct _turb1__GetThreshold **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetThreshold **)soap_malloc(soap, sizeof(struct _turb1__GetThreshold *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetThreshold(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetThreshold **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetThreshold, sizeof(struct _turb1__GetThreshold), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetThreshold(struct soap *soap, struct _turb1__GetThreshold *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetThreshold);
	if (soap_out_PointerTo_turb1__GetThreshold(soap, tag?tag:"turb1:GetThreshold", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetThreshold ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetThreshold(struct soap *soap, struct _turb1__GetThreshold **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetThreshold(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetBoxFilterGradientResponse(struct soap *soap, struct _turb1__GetBoxFilterGradientResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetBoxFilterGradientResponse))
		soap_serialize__turb1__GetBoxFilterGradientResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetBoxFilterGradientResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetBoxFilterGradientResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetBoxFilterGradientResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetBoxFilterGradientResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetBoxFilterGradientResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetBoxFilterGradientResponse(struct soap *soap, const char *tag, struct _turb1__GetBoxFilterGradientResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetBoxFilterGradientResponse **)soap_malloc(soap, sizeof(struct _turb1__GetBoxFilterGradientResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetBoxFilterGradientResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetBoxFilterGradientResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetBoxFilterGradientResponse, sizeof(struct _turb1__GetBoxFilterGradientResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetBoxFilterGradientResponse(struct soap *soap, struct _turb1__GetBoxFilterGradientResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetBoxFilterGradientResponse);
	if (soap_out_PointerTo_turb1__GetBoxFilterGradientResponse(soap, tag?tag:"turb1:GetBoxFilterGradientResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetBoxFilterGradientResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetBoxFilterGradientResponse(struct soap *soap, struct _turb1__GetBoxFilterGradientResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetBoxFilterGradientResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetBoxFilterGradient(struct soap *soap, struct _turb1__GetBoxFilterGradient *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetBoxFilterGradient))
		soap_serialize__turb1__GetBoxFilterGradient(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetBoxFilterGradient(struct soap *soap, const char *tag, int id, struct _turb1__GetBoxFilterGradient *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetBoxFilterGradient);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetBoxFilterGradient(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetBoxFilterGradient ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetBoxFilterGradient(struct soap *soap, const char *tag, struct _turb1__GetBoxFilterGradient **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetBoxFilterGradient **)soap_malloc(soap, sizeof(struct _turb1__GetBoxFilterGradient *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetBoxFilterGradient(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetBoxFilterGradient **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetBoxFilterGradient, sizeof(struct _turb1__GetBoxFilterGradient), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetBoxFilterGradient(struct soap *soap, struct _turb1__GetBoxFilterGradient *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetBoxFilterGradient);
	if (soap_out_PointerTo_turb1__GetBoxFilterGradient(soap, tag?tag:"turb1:GetBoxFilterGradient", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetBoxFilterGradient ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetBoxFilterGradient(struct soap *soap, struct _turb1__GetBoxFilterGradient **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetBoxFilterGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetBoxFilterSGSResponse(struct soap *soap, struct _turb1__GetBoxFilterSGSResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetBoxFilterSGSResponse))
		soap_serialize__turb1__GetBoxFilterSGSResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetBoxFilterSGSResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetBoxFilterSGSResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetBoxFilterSGSResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetBoxFilterSGSResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetBoxFilterSGSResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetBoxFilterSGSResponse(struct soap *soap, const char *tag, struct _turb1__GetBoxFilterSGSResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetBoxFilterSGSResponse **)soap_malloc(soap, sizeof(struct _turb1__GetBoxFilterSGSResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetBoxFilterSGSResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetBoxFilterSGSResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetBoxFilterSGSResponse, sizeof(struct _turb1__GetBoxFilterSGSResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetBoxFilterSGSResponse(struct soap *soap, struct _turb1__GetBoxFilterSGSResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetBoxFilterSGSResponse);
	if (soap_out_PointerTo_turb1__GetBoxFilterSGSResponse(soap, tag?tag:"turb1:GetBoxFilterSGSResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetBoxFilterSGSResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetBoxFilterSGSResponse(struct soap *soap, struct _turb1__GetBoxFilterSGSResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetBoxFilterSGSResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetBoxFilterSGS(struct soap *soap, struct _turb1__GetBoxFilterSGS *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetBoxFilterSGS))
		soap_serialize__turb1__GetBoxFilterSGS(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetBoxFilterSGS(struct soap *soap, const char *tag, int id, struct _turb1__GetBoxFilterSGS *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetBoxFilterSGS);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetBoxFilterSGS(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetBoxFilterSGS ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetBoxFilterSGS(struct soap *soap, const char *tag, struct _turb1__GetBoxFilterSGS **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetBoxFilterSGS **)soap_malloc(soap, sizeof(struct _turb1__GetBoxFilterSGS *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetBoxFilterSGS(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetBoxFilterSGS **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetBoxFilterSGS, sizeof(struct _turb1__GetBoxFilterSGS), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetBoxFilterSGS(struct soap *soap, struct _turb1__GetBoxFilterSGS *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetBoxFilterSGS);
	if (soap_out_PointerTo_turb1__GetBoxFilterSGS(soap, tag?tag:"turb1:GetBoxFilterSGS", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetBoxFilterSGS ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetBoxFilterSGS(struct soap *soap, struct _turb1__GetBoxFilterSGS **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetBoxFilterSGS(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetBoxFilterResponse(struct soap *soap, struct _turb1__GetBoxFilterResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetBoxFilterResponse))
		soap_serialize__turb1__GetBoxFilterResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetBoxFilterResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetBoxFilterResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetBoxFilterResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetBoxFilterResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetBoxFilterResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetBoxFilterResponse(struct soap *soap, const char *tag, struct _turb1__GetBoxFilterResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetBoxFilterResponse **)soap_malloc(soap, sizeof(struct _turb1__GetBoxFilterResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetBoxFilterResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetBoxFilterResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetBoxFilterResponse, sizeof(struct _turb1__GetBoxFilterResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetBoxFilterResponse(struct soap *soap, struct _turb1__GetBoxFilterResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetBoxFilterResponse);
	if (soap_out_PointerTo_turb1__GetBoxFilterResponse(soap, tag?tag:"turb1:GetBoxFilterResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetBoxFilterResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetBoxFilterResponse(struct soap *soap, struct _turb1__GetBoxFilterResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetBoxFilterResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetBoxFilter(struct soap *soap, struct _turb1__GetBoxFilter *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetBoxFilter))
		soap_serialize__turb1__GetBoxFilter(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetBoxFilter(struct soap *soap, const char *tag, int id, struct _turb1__GetBoxFilter *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetBoxFilter);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetBoxFilter(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetBoxFilter ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetBoxFilter(struct soap *soap, const char *tag, struct _turb1__GetBoxFilter **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetBoxFilter **)soap_malloc(soap, sizeof(struct _turb1__GetBoxFilter *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetBoxFilter(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetBoxFilter **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetBoxFilter, sizeof(struct _turb1__GetBoxFilter), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetBoxFilter(struct soap *soap, struct _turb1__GetBoxFilter *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetBoxFilter);
	if (soap_out_PointerTo_turb1__GetBoxFilter(soap, tag?tag:"turb1:GetBoxFilter", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetBoxFilter ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetBoxFilter(struct soap *soap, struct _turb1__GetBoxFilter **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetBoxFilter(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetPositionResponse(struct soap *soap, struct _turb1__GetPositionResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetPositionResponse))
		soap_serialize__turb1__GetPositionResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetPositionResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetPositionResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetPositionResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetPositionResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetPositionResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetPositionResponse(struct soap *soap, const char *tag, struct _turb1__GetPositionResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetPositionResponse **)soap_malloc(soap, sizeof(struct _turb1__GetPositionResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetPositionResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetPositionResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetPositionResponse, sizeof(struct _turb1__GetPositionResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetPositionResponse(struct soap *soap, struct _turb1__GetPositionResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetPositionResponse);
	if (soap_out_PointerTo_turb1__GetPositionResponse(soap, tag?tag:"turb1:GetPositionResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetPositionResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetPositionResponse(struct soap *soap, struct _turb1__GetPositionResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetPositionResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetPosition(struct soap *soap, struct _turb1__GetPosition *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetPosition))
		soap_serialize__turb1__GetPosition(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetPosition(struct soap *soap, const char *tag, int id, struct _turb1__GetPosition *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetPosition);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetPosition(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetPosition ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetPosition(struct soap *soap, const char *tag, struct _turb1__GetPosition **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetPosition **)soap_malloc(soap, sizeof(struct _turb1__GetPosition *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetPosition(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetPosition **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetPosition, sizeof(struct _turb1__GetPosition), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetPosition(struct soap *soap, struct _turb1__GetPosition *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetPosition);
	if (soap_out_PointerTo_turb1__GetPosition(soap, tag?tag:"turb1:GetPosition", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetPosition ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetPosition(struct soap *soap, struct _turb1__GetPosition **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetPosition(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetVectorPotentialLaplacianResponse(struct soap *soap, struct _turb1__GetVectorPotentialLaplacianResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetVectorPotentialLaplacianResponse))
		soap_serialize__turb1__GetVectorPotentialLaplacianResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetVectorPotentialLaplacianResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetVectorPotentialLaplacianResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetVectorPotentialLaplacianResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetVectorPotentialLaplacianResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialLaplacianResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetVectorPotentialLaplacianResponse(struct soap *soap, const char *tag, struct _turb1__GetVectorPotentialLaplacianResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetVectorPotentialLaplacianResponse **)soap_malloc(soap, sizeof(struct _turb1__GetVectorPotentialLaplacianResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetVectorPotentialLaplacianResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVectorPotentialLaplacianResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetVectorPotentialLaplacianResponse, sizeof(struct _turb1__GetVectorPotentialLaplacianResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetVectorPotentialLaplacianResponse(struct soap *soap, struct _turb1__GetVectorPotentialLaplacianResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetVectorPotentialLaplacianResponse);
	if (soap_out_PointerTo_turb1__GetVectorPotentialLaplacianResponse(soap, tag?tag:"turb1:GetVectorPotentialLaplacianResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialLaplacianResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetVectorPotentialLaplacianResponse(struct soap *soap, struct _turb1__GetVectorPotentialLaplacianResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetVectorPotentialLaplacianResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetVectorPotentialLaplacian(struct soap *soap, struct _turb1__GetVectorPotentialLaplacian *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetVectorPotentialLaplacian))
		soap_serialize__turb1__GetVectorPotentialLaplacian(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetVectorPotentialLaplacian(struct soap *soap, const char *tag, int id, struct _turb1__GetVectorPotentialLaplacian *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetVectorPotentialLaplacian);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetVectorPotentialLaplacian(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialLaplacian ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetVectorPotentialLaplacian(struct soap *soap, const char *tag, struct _turb1__GetVectorPotentialLaplacian **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetVectorPotentialLaplacian **)soap_malloc(soap, sizeof(struct _turb1__GetVectorPotentialLaplacian *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetVectorPotentialLaplacian(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVectorPotentialLaplacian **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetVectorPotentialLaplacian, sizeof(struct _turb1__GetVectorPotentialLaplacian), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetVectorPotentialLaplacian(struct soap *soap, struct _turb1__GetVectorPotentialLaplacian *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetVectorPotentialLaplacian);
	if (soap_out_PointerTo_turb1__GetVectorPotentialLaplacian(soap, tag?tag:"turb1:GetVectorPotentialLaplacian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialLaplacian ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetVectorPotentialLaplacian(struct soap *soap, struct _turb1__GetVectorPotentialLaplacian **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetVectorPotentialLaplacian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetMagneticFieldLaplacianResponse(struct soap *soap, struct _turb1__GetMagneticFieldLaplacianResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetMagneticFieldLaplacianResponse))
		soap_serialize__turb1__GetMagneticFieldLaplacianResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetMagneticFieldLaplacianResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetMagneticFieldLaplacianResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetMagneticFieldLaplacianResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetMagneticFieldLaplacianResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetMagneticFieldLaplacianResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetMagneticFieldLaplacianResponse(struct soap *soap, const char *tag, struct _turb1__GetMagneticFieldLaplacianResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetMagneticFieldLaplacianResponse **)soap_malloc(soap, sizeof(struct _turb1__GetMagneticFieldLaplacianResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetMagneticFieldLaplacianResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetMagneticFieldLaplacianResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetMagneticFieldLaplacianResponse, sizeof(struct _turb1__GetMagneticFieldLaplacianResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetMagneticFieldLaplacianResponse(struct soap *soap, struct _turb1__GetMagneticFieldLaplacianResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetMagneticFieldLaplacianResponse);
	if (soap_out_PointerTo_turb1__GetMagneticFieldLaplacianResponse(soap, tag?tag:"turb1:GetMagneticFieldLaplacianResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetMagneticFieldLaplacianResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetMagneticFieldLaplacianResponse(struct soap *soap, struct _turb1__GetMagneticFieldLaplacianResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetMagneticFieldLaplacianResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetMagneticFieldLaplacian(struct soap *soap, struct _turb1__GetMagneticFieldLaplacian *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetMagneticFieldLaplacian))
		soap_serialize__turb1__GetMagneticFieldLaplacian(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetMagneticFieldLaplacian(struct soap *soap, const char *tag, int id, struct _turb1__GetMagneticFieldLaplacian *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetMagneticFieldLaplacian);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetMagneticFieldLaplacian(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetMagneticFieldLaplacian ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetMagneticFieldLaplacian(struct soap *soap, const char *tag, struct _turb1__GetMagneticFieldLaplacian **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetMagneticFieldLaplacian **)soap_malloc(soap, sizeof(struct _turb1__GetMagneticFieldLaplacian *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetMagneticFieldLaplacian(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetMagneticFieldLaplacian **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetMagneticFieldLaplacian, sizeof(struct _turb1__GetMagneticFieldLaplacian), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetMagneticFieldLaplacian(struct soap *soap, struct _turb1__GetMagneticFieldLaplacian *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetMagneticFieldLaplacian);
	if (soap_out_PointerTo_turb1__GetMagneticFieldLaplacian(soap, tag?tag:"turb1:GetMagneticFieldLaplacian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetMagneticFieldLaplacian ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetMagneticFieldLaplacian(struct soap *soap, struct _turb1__GetMagneticFieldLaplacian **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetMagneticFieldLaplacian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetVelocityLaplacianResponse(struct soap *soap, struct _turb1__GetVelocityLaplacianResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetVelocityLaplacianResponse))
		soap_serialize__turb1__GetVelocityLaplacianResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetVelocityLaplacianResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetVelocityLaplacianResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetVelocityLaplacianResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetVelocityLaplacianResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetVelocityLaplacianResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetVelocityLaplacianResponse(struct soap *soap, const char *tag, struct _turb1__GetVelocityLaplacianResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetVelocityLaplacianResponse **)soap_malloc(soap, sizeof(struct _turb1__GetVelocityLaplacianResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetVelocityLaplacianResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityLaplacianResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetVelocityLaplacianResponse, sizeof(struct _turb1__GetVelocityLaplacianResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetVelocityLaplacianResponse(struct soap *soap, struct _turb1__GetVelocityLaplacianResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetVelocityLaplacianResponse);
	if (soap_out_PointerTo_turb1__GetVelocityLaplacianResponse(soap, tag?tag:"turb1:GetVelocityLaplacianResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityLaplacianResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetVelocityLaplacianResponse(struct soap *soap, struct _turb1__GetVelocityLaplacianResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetVelocityLaplacianResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetVelocityLaplacian(struct soap *soap, struct _turb1__GetVelocityLaplacian *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetVelocityLaplacian))
		soap_serialize__turb1__GetVelocityLaplacian(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetVelocityLaplacian(struct soap *soap, const char *tag, int id, struct _turb1__GetVelocityLaplacian *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetVelocityLaplacian);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetVelocityLaplacian(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetVelocityLaplacian ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetVelocityLaplacian(struct soap *soap, const char *tag, struct _turb1__GetVelocityLaplacian **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetVelocityLaplacian **)soap_malloc(soap, sizeof(struct _turb1__GetVelocityLaplacian *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetVelocityLaplacian(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityLaplacian **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetVelocityLaplacian, sizeof(struct _turb1__GetVelocityLaplacian), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetVelocityLaplacian(struct soap *soap, struct _turb1__GetVelocityLaplacian *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetVelocityLaplacian);
	if (soap_out_PointerTo_turb1__GetVelocityLaplacian(soap, tag?tag:"turb1:GetVelocityLaplacian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityLaplacian ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetVelocityLaplacian(struct soap *soap, struct _turb1__GetVelocityLaplacian **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetVelocityLaplacian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetVectorPotentialHessianResponse(struct soap *soap, struct _turb1__GetVectorPotentialHessianResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetVectorPotentialHessianResponse))
		soap_serialize__turb1__GetVectorPotentialHessianResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetVectorPotentialHessianResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetVectorPotentialHessianResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetVectorPotentialHessianResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetVectorPotentialHessianResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialHessianResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetVectorPotentialHessianResponse(struct soap *soap, const char *tag, struct _turb1__GetVectorPotentialHessianResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetVectorPotentialHessianResponse **)soap_malloc(soap, sizeof(struct _turb1__GetVectorPotentialHessianResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetVectorPotentialHessianResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVectorPotentialHessianResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetVectorPotentialHessianResponse, sizeof(struct _turb1__GetVectorPotentialHessianResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetVectorPotentialHessianResponse(struct soap *soap, struct _turb1__GetVectorPotentialHessianResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetVectorPotentialHessianResponse);
	if (soap_out_PointerTo_turb1__GetVectorPotentialHessianResponse(soap, tag?tag:"turb1:GetVectorPotentialHessianResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialHessianResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetVectorPotentialHessianResponse(struct soap *soap, struct _turb1__GetVectorPotentialHessianResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetVectorPotentialHessianResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetVectorPotentialHessian(struct soap *soap, struct _turb1__GetVectorPotentialHessian *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetVectorPotentialHessian))
		soap_serialize__turb1__GetVectorPotentialHessian(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetVectorPotentialHessian(struct soap *soap, const char *tag, int id, struct _turb1__GetVectorPotentialHessian *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetVectorPotentialHessian);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetVectorPotentialHessian(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialHessian ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetVectorPotentialHessian(struct soap *soap, const char *tag, struct _turb1__GetVectorPotentialHessian **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetVectorPotentialHessian **)soap_malloc(soap, sizeof(struct _turb1__GetVectorPotentialHessian *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetVectorPotentialHessian(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVectorPotentialHessian **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetVectorPotentialHessian, sizeof(struct _turb1__GetVectorPotentialHessian), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetVectorPotentialHessian(struct soap *soap, struct _turb1__GetVectorPotentialHessian *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetVectorPotentialHessian);
	if (soap_out_PointerTo_turb1__GetVectorPotentialHessian(soap, tag?tag:"turb1:GetVectorPotentialHessian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialHessian ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetVectorPotentialHessian(struct soap *soap, struct _turb1__GetVectorPotentialHessian **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetVectorPotentialHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetMagneticHessianResponse(struct soap *soap, struct _turb1__GetMagneticHessianResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetMagneticHessianResponse))
		soap_serialize__turb1__GetMagneticHessianResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetMagneticHessianResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetMagneticHessianResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetMagneticHessianResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetMagneticHessianResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetMagneticHessianResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetMagneticHessianResponse(struct soap *soap, const char *tag, struct _turb1__GetMagneticHessianResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetMagneticHessianResponse **)soap_malloc(soap, sizeof(struct _turb1__GetMagneticHessianResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetMagneticHessianResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetMagneticHessianResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetMagneticHessianResponse, sizeof(struct _turb1__GetMagneticHessianResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetMagneticHessianResponse(struct soap *soap, struct _turb1__GetMagneticHessianResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetMagneticHessianResponse);
	if (soap_out_PointerTo_turb1__GetMagneticHessianResponse(soap, tag?tag:"turb1:GetMagneticHessianResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetMagneticHessianResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetMagneticHessianResponse(struct soap *soap, struct _turb1__GetMagneticHessianResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetMagneticHessianResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetMagneticHessian(struct soap *soap, struct _turb1__GetMagneticHessian *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetMagneticHessian))
		soap_serialize__turb1__GetMagneticHessian(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetMagneticHessian(struct soap *soap, const char *tag, int id, struct _turb1__GetMagneticHessian *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetMagneticHessian);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetMagneticHessian(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetMagneticHessian ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetMagneticHessian(struct soap *soap, const char *tag, struct _turb1__GetMagneticHessian **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetMagneticHessian **)soap_malloc(soap, sizeof(struct _turb1__GetMagneticHessian *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetMagneticHessian(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetMagneticHessian **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetMagneticHessian, sizeof(struct _turb1__GetMagneticHessian), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetMagneticHessian(struct soap *soap, struct _turb1__GetMagneticHessian *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetMagneticHessian);
	if (soap_out_PointerTo_turb1__GetMagneticHessian(soap, tag?tag:"turb1:GetMagneticHessian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetMagneticHessian ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetMagneticHessian(struct soap *soap, struct _turb1__GetMagneticHessian **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetMagneticHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetVelocityHessianResponse(struct soap *soap, struct _turb1__GetVelocityHessianResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetVelocityHessianResponse))
		soap_serialize__turb1__GetVelocityHessianResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetVelocityHessianResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetVelocityHessianResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetVelocityHessianResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetVelocityHessianResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetVelocityHessianResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetVelocityHessianResponse(struct soap *soap, const char *tag, struct _turb1__GetVelocityHessianResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetVelocityHessianResponse **)soap_malloc(soap, sizeof(struct _turb1__GetVelocityHessianResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetVelocityHessianResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityHessianResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetVelocityHessianResponse, sizeof(struct _turb1__GetVelocityHessianResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetVelocityHessianResponse(struct soap *soap, struct _turb1__GetVelocityHessianResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetVelocityHessianResponse);
	if (soap_out_PointerTo_turb1__GetVelocityHessianResponse(soap, tag?tag:"turb1:GetVelocityHessianResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityHessianResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetVelocityHessianResponse(struct soap *soap, struct _turb1__GetVelocityHessianResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetVelocityHessianResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetVelocityHessian(struct soap *soap, struct _turb1__GetVelocityHessian *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetVelocityHessian))
		soap_serialize__turb1__GetVelocityHessian(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetVelocityHessian(struct soap *soap, const char *tag, int id, struct _turb1__GetVelocityHessian *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetVelocityHessian);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetVelocityHessian(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetVelocityHessian ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetVelocityHessian(struct soap *soap, const char *tag, struct _turb1__GetVelocityHessian **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetVelocityHessian **)soap_malloc(soap, sizeof(struct _turb1__GetVelocityHessian *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetVelocityHessian(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityHessian **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetVelocityHessian, sizeof(struct _turb1__GetVelocityHessian), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetVelocityHessian(struct soap *soap, struct _turb1__GetVelocityHessian *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetVelocityHessian);
	if (soap_out_PointerTo_turb1__GetVelocityHessian(soap, tag?tag:"turb1:GetVelocityHessian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityHessian ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetVelocityHessian(struct soap *soap, struct _turb1__GetVelocityHessian **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetVelocityHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetPressureHessianResponse(struct soap *soap, struct _turb1__GetPressureHessianResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetPressureHessianResponse))
		soap_serialize__turb1__GetPressureHessianResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetPressureHessianResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetPressureHessianResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetPressureHessianResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetPressureHessianResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetPressureHessianResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetPressureHessianResponse(struct soap *soap, const char *tag, struct _turb1__GetPressureHessianResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetPressureHessianResponse **)soap_malloc(soap, sizeof(struct _turb1__GetPressureHessianResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetPressureHessianResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetPressureHessianResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetPressureHessianResponse, sizeof(struct _turb1__GetPressureHessianResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetPressureHessianResponse(struct soap *soap, struct _turb1__GetPressureHessianResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetPressureHessianResponse);
	if (soap_out_PointerTo_turb1__GetPressureHessianResponse(soap, tag?tag:"turb1:GetPressureHessianResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetPressureHessianResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetPressureHessianResponse(struct soap *soap, struct _turb1__GetPressureHessianResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetPressureHessianResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetPressureHessian(struct soap *soap, struct _turb1__GetPressureHessian *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetPressureHessian))
		soap_serialize__turb1__GetPressureHessian(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetPressureHessian(struct soap *soap, const char *tag, int id, struct _turb1__GetPressureHessian *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetPressureHessian);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetPressureHessian(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetPressureHessian ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetPressureHessian(struct soap *soap, const char *tag, struct _turb1__GetPressureHessian **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetPressureHessian **)soap_malloc(soap, sizeof(struct _turb1__GetPressureHessian *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetPressureHessian(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetPressureHessian **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetPressureHessian, sizeof(struct _turb1__GetPressureHessian), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetPressureHessian(struct soap *soap, struct _turb1__GetPressureHessian *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetPressureHessian);
	if (soap_out_PointerTo_turb1__GetPressureHessian(soap, tag?tag:"turb1:GetPressureHessian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetPressureHessian ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetPressureHessian(struct soap *soap, struct _turb1__GetPressureHessian **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetPressureHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetPressureGradientResponse(struct soap *soap, struct _turb1__GetPressureGradientResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetPressureGradientResponse))
		soap_serialize__turb1__GetPressureGradientResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetPressureGradientResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetPressureGradientResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetPressureGradientResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetPressureGradientResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetPressureGradientResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetPressureGradientResponse(struct soap *soap, const char *tag, struct _turb1__GetPressureGradientResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetPressureGradientResponse **)soap_malloc(soap, sizeof(struct _turb1__GetPressureGradientResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetPressureGradientResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetPressureGradientResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetPressureGradientResponse, sizeof(struct _turb1__GetPressureGradientResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetPressureGradientResponse(struct soap *soap, struct _turb1__GetPressureGradientResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetPressureGradientResponse);
	if (soap_out_PointerTo_turb1__GetPressureGradientResponse(soap, tag?tag:"turb1:GetPressureGradientResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetPressureGradientResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetPressureGradientResponse(struct soap *soap, struct _turb1__GetPressureGradientResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetPressureGradientResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetPressureGradient(struct soap *soap, struct _turb1__GetPressureGradient *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetPressureGradient))
		soap_serialize__turb1__GetPressureGradient(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetPressureGradient(struct soap *soap, const char *tag, int id, struct _turb1__GetPressureGradient *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetPressureGradient);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetPressureGradient(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetPressureGradient ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetPressureGradient(struct soap *soap, const char *tag, struct _turb1__GetPressureGradient **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetPressureGradient **)soap_malloc(soap, sizeof(struct _turb1__GetPressureGradient *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetPressureGradient(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetPressureGradient **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetPressureGradient, sizeof(struct _turb1__GetPressureGradient), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetPressureGradient(struct soap *soap, struct _turb1__GetPressureGradient *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetPressureGradient);
	if (soap_out_PointerTo_turb1__GetPressureGradient(soap, tag?tag:"turb1:GetPressureGradient", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetPressureGradient ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetPressureGradient(struct soap *soap, struct _turb1__GetPressureGradient **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetPressureGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetVectorPotentialGradientResponse(struct soap *soap, struct _turb1__GetVectorPotentialGradientResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetVectorPotentialGradientResponse))
		soap_serialize__turb1__GetVectorPotentialGradientResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetVectorPotentialGradientResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetVectorPotentialGradientResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetVectorPotentialGradientResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetVectorPotentialGradientResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialGradientResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetVectorPotentialGradientResponse(struct soap *soap, const char *tag, struct _turb1__GetVectorPotentialGradientResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetVectorPotentialGradientResponse **)soap_malloc(soap, sizeof(struct _turb1__GetVectorPotentialGradientResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetVectorPotentialGradientResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVectorPotentialGradientResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetVectorPotentialGradientResponse, sizeof(struct _turb1__GetVectorPotentialGradientResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetVectorPotentialGradientResponse(struct soap *soap, struct _turb1__GetVectorPotentialGradientResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetVectorPotentialGradientResponse);
	if (soap_out_PointerTo_turb1__GetVectorPotentialGradientResponse(soap, tag?tag:"turb1:GetVectorPotentialGradientResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialGradientResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetVectorPotentialGradientResponse(struct soap *soap, struct _turb1__GetVectorPotentialGradientResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetVectorPotentialGradientResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetVectorPotentialGradient(struct soap *soap, struct _turb1__GetVectorPotentialGradient *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetVectorPotentialGradient))
		soap_serialize__turb1__GetVectorPotentialGradient(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetVectorPotentialGradient(struct soap *soap, const char *tag, int id, struct _turb1__GetVectorPotentialGradient *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetVectorPotentialGradient);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetVectorPotentialGradient(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialGradient ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetVectorPotentialGradient(struct soap *soap, const char *tag, struct _turb1__GetVectorPotentialGradient **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetVectorPotentialGradient **)soap_malloc(soap, sizeof(struct _turb1__GetVectorPotentialGradient *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetVectorPotentialGradient(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVectorPotentialGradient **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetVectorPotentialGradient, sizeof(struct _turb1__GetVectorPotentialGradient), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetVectorPotentialGradient(struct soap *soap, struct _turb1__GetVectorPotentialGradient *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetVectorPotentialGradient);
	if (soap_out_PointerTo_turb1__GetVectorPotentialGradient(soap, tag?tag:"turb1:GetVectorPotentialGradient", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialGradient ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetVectorPotentialGradient(struct soap *soap, struct _turb1__GetVectorPotentialGradient **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetVectorPotentialGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetMagneticFieldGradientResponse(struct soap *soap, struct _turb1__GetMagneticFieldGradientResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetMagneticFieldGradientResponse))
		soap_serialize__turb1__GetMagneticFieldGradientResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetMagneticFieldGradientResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetMagneticFieldGradientResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetMagneticFieldGradientResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetMagneticFieldGradientResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetMagneticFieldGradientResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetMagneticFieldGradientResponse(struct soap *soap, const char *tag, struct _turb1__GetMagneticFieldGradientResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetMagneticFieldGradientResponse **)soap_malloc(soap, sizeof(struct _turb1__GetMagneticFieldGradientResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetMagneticFieldGradientResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetMagneticFieldGradientResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetMagneticFieldGradientResponse, sizeof(struct _turb1__GetMagneticFieldGradientResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetMagneticFieldGradientResponse(struct soap *soap, struct _turb1__GetMagneticFieldGradientResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetMagneticFieldGradientResponse);
	if (soap_out_PointerTo_turb1__GetMagneticFieldGradientResponse(soap, tag?tag:"turb1:GetMagneticFieldGradientResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetMagneticFieldGradientResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetMagneticFieldGradientResponse(struct soap *soap, struct _turb1__GetMagneticFieldGradientResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetMagneticFieldGradientResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetMagneticFieldGradient(struct soap *soap, struct _turb1__GetMagneticFieldGradient *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetMagneticFieldGradient))
		soap_serialize__turb1__GetMagneticFieldGradient(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetMagneticFieldGradient(struct soap *soap, const char *tag, int id, struct _turb1__GetMagneticFieldGradient *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetMagneticFieldGradient);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetMagneticFieldGradient(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetMagneticFieldGradient ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetMagneticFieldGradient(struct soap *soap, const char *tag, struct _turb1__GetMagneticFieldGradient **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetMagneticFieldGradient **)soap_malloc(soap, sizeof(struct _turb1__GetMagneticFieldGradient *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetMagneticFieldGradient(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetMagneticFieldGradient **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetMagneticFieldGradient, sizeof(struct _turb1__GetMagneticFieldGradient), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetMagneticFieldGradient(struct soap *soap, struct _turb1__GetMagneticFieldGradient *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetMagneticFieldGradient);
	if (soap_out_PointerTo_turb1__GetMagneticFieldGradient(soap, tag?tag:"turb1:GetMagneticFieldGradient", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetMagneticFieldGradient ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetMagneticFieldGradient(struct soap *soap, struct _turb1__GetMagneticFieldGradient **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetMagneticFieldGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetVelocityGradientResponse(struct soap *soap, struct _turb1__GetVelocityGradientResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetVelocityGradientResponse))
		soap_serialize__turb1__GetVelocityGradientResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetVelocityGradientResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetVelocityGradientResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetVelocityGradientResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetVelocityGradientResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetVelocityGradientResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetVelocityGradientResponse(struct soap *soap, const char *tag, struct _turb1__GetVelocityGradientResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetVelocityGradientResponse **)soap_malloc(soap, sizeof(struct _turb1__GetVelocityGradientResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetVelocityGradientResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityGradientResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetVelocityGradientResponse, sizeof(struct _turb1__GetVelocityGradientResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetVelocityGradientResponse(struct soap *soap, struct _turb1__GetVelocityGradientResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetVelocityGradientResponse);
	if (soap_out_PointerTo_turb1__GetVelocityGradientResponse(soap, tag?tag:"turb1:GetVelocityGradientResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityGradientResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetVelocityGradientResponse(struct soap *soap, struct _turb1__GetVelocityGradientResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetVelocityGradientResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetVelocityGradient(struct soap *soap, struct _turb1__GetVelocityGradient *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetVelocityGradient))
		soap_serialize__turb1__GetVelocityGradient(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetVelocityGradient(struct soap *soap, const char *tag, int id, struct _turb1__GetVelocityGradient *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetVelocityGradient);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetVelocityGradient(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetVelocityGradient ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetVelocityGradient(struct soap *soap, const char *tag, struct _turb1__GetVelocityGradient **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetVelocityGradient **)soap_malloc(soap, sizeof(struct _turb1__GetVelocityGradient *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetVelocityGradient(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityGradient **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetVelocityGradient, sizeof(struct _turb1__GetVelocityGradient), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetVelocityGradient(struct soap *soap, struct _turb1__GetVelocityGradient *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetVelocityGradient);
	if (soap_out_PointerTo_turb1__GetVelocityGradient(soap, tag?tag:"turb1:GetVelocityGradient", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityGradient ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetVelocityGradient(struct soap *soap, struct _turb1__GetVelocityGradient **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetVelocityGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetVelocityAndPressureResponse(struct soap *soap, struct _turb1__GetVelocityAndPressureResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetVelocityAndPressureResponse))
		soap_serialize__turb1__GetVelocityAndPressureResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetVelocityAndPressureResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetVelocityAndPressureResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetVelocityAndPressureResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetVelocityAndPressureResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetVelocityAndPressureResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetVelocityAndPressureResponse(struct soap *soap, const char *tag, struct _turb1__GetVelocityAndPressureResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetVelocityAndPressureResponse **)soap_malloc(soap, sizeof(struct _turb1__GetVelocityAndPressureResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetVelocityAndPressureResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityAndPressureResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetVelocityAndPressureResponse, sizeof(struct _turb1__GetVelocityAndPressureResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetVelocityAndPressureResponse(struct soap *soap, struct _turb1__GetVelocityAndPressureResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetVelocityAndPressureResponse);
	if (soap_out_PointerTo_turb1__GetVelocityAndPressureResponse(soap, tag?tag:"turb1:GetVelocityAndPressureResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityAndPressureResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetVelocityAndPressureResponse(struct soap *soap, struct _turb1__GetVelocityAndPressureResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetVelocityAndPressureResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetVelocityAndPressure(struct soap *soap, struct _turb1__GetVelocityAndPressure *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetVelocityAndPressure))
		soap_serialize__turb1__GetVelocityAndPressure(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetVelocityAndPressure(struct soap *soap, const char *tag, int id, struct _turb1__GetVelocityAndPressure *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetVelocityAndPressure);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetVelocityAndPressure(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetVelocityAndPressure ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetVelocityAndPressure(struct soap *soap, const char *tag, struct _turb1__GetVelocityAndPressure **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetVelocityAndPressure **)soap_malloc(soap, sizeof(struct _turb1__GetVelocityAndPressure *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetVelocityAndPressure(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityAndPressure **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetVelocityAndPressure, sizeof(struct _turb1__GetVelocityAndPressure), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetVelocityAndPressure(struct soap *soap, struct _turb1__GetVelocityAndPressure *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetVelocityAndPressure);
	if (soap_out_PointerTo_turb1__GetVelocityAndPressure(soap, tag?tag:"turb1:GetVelocityAndPressure", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityAndPressure ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetVelocityAndPressure(struct soap *soap, struct _turb1__GetVelocityAndPressure **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetVelocityAndPressure(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetForceResponse(struct soap *soap, struct _turb1__GetForceResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetForceResponse))
		soap_serialize__turb1__GetForceResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetForceResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetForceResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetForceResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetForceResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetForceResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetForceResponse(struct soap *soap, const char *tag, struct _turb1__GetForceResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetForceResponse **)soap_malloc(soap, sizeof(struct _turb1__GetForceResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetForceResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetForceResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetForceResponse, sizeof(struct _turb1__GetForceResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetForceResponse(struct soap *soap, struct _turb1__GetForceResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetForceResponse);
	if (soap_out_PointerTo_turb1__GetForceResponse(soap, tag?tag:"turb1:GetForceResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetForceResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetForceResponse(struct soap *soap, struct _turb1__GetForceResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetForceResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetForce(struct soap *soap, struct _turb1__GetForce *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetForce))
		soap_serialize__turb1__GetForce(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetForce(struct soap *soap, const char *tag, int id, struct _turb1__GetForce *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetForce);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetForce(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetForce ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetForce(struct soap *soap, const char *tag, struct _turb1__GetForce **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetForce **)soap_malloc(soap, sizeof(struct _turb1__GetForce *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetForce(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetForce **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetForce, sizeof(struct _turb1__GetForce), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetForce(struct soap *soap, struct _turb1__GetForce *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetForce);
	if (soap_out_PointerTo_turb1__GetForce(soap, tag?tag:"turb1:GetForce", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetForce ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetForce(struct soap *soap, struct _turb1__GetForce **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetForce(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetRawDensityResponse(struct soap *soap, struct _turb1__GetRawDensityResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetRawDensityResponse))
		soap_serialize__turb1__GetRawDensityResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetRawDensityResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetRawDensityResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetRawDensityResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetRawDensityResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetRawDensityResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetRawDensityResponse(struct soap *soap, const char *tag, struct _turb1__GetRawDensityResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetRawDensityResponse **)soap_malloc(soap, sizeof(struct _turb1__GetRawDensityResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetRawDensityResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetRawDensityResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetRawDensityResponse, sizeof(struct _turb1__GetRawDensityResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetRawDensityResponse(struct soap *soap, struct _turb1__GetRawDensityResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetRawDensityResponse);
	if (soap_out_PointerTo_turb1__GetRawDensityResponse(soap, tag?tag:"turb1:GetRawDensityResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetRawDensityResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetRawDensityResponse(struct soap *soap, struct _turb1__GetRawDensityResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetRawDensityResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetRawDensity(struct soap *soap, struct _turb1__GetRawDensity *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetRawDensity))
		soap_serialize__turb1__GetRawDensity(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetRawDensity(struct soap *soap, const char *tag, int id, struct _turb1__GetRawDensity *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetRawDensity);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetRawDensity(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetRawDensity ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetRawDensity(struct soap *soap, const char *tag, struct _turb1__GetRawDensity **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetRawDensity **)soap_malloc(soap, sizeof(struct _turb1__GetRawDensity *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetRawDensity(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetRawDensity **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetRawDensity, sizeof(struct _turb1__GetRawDensity), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetRawDensity(struct soap *soap, struct _turb1__GetRawDensity *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetRawDensity);
	if (soap_out_PointerTo_turb1__GetRawDensity(soap, tag?tag:"turb1:GetRawDensity", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetRawDensity ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetRawDensity(struct soap *soap, struct _turb1__GetRawDensity **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetRawDensity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetDensityHessianResponse(struct soap *soap, struct _turb1__GetDensityHessianResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetDensityHessianResponse))
		soap_serialize__turb1__GetDensityHessianResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetDensityHessianResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetDensityHessianResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetDensityHessianResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetDensityHessianResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetDensityHessianResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetDensityHessianResponse(struct soap *soap, const char *tag, struct _turb1__GetDensityHessianResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetDensityHessianResponse **)soap_malloc(soap, sizeof(struct _turb1__GetDensityHessianResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetDensityHessianResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetDensityHessianResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetDensityHessianResponse, sizeof(struct _turb1__GetDensityHessianResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetDensityHessianResponse(struct soap *soap, struct _turb1__GetDensityHessianResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetDensityHessianResponse);
	if (soap_out_PointerTo_turb1__GetDensityHessianResponse(soap, tag?tag:"turb1:GetDensityHessianResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetDensityHessianResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetDensityHessianResponse(struct soap *soap, struct _turb1__GetDensityHessianResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetDensityHessianResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetDensityHessian(struct soap *soap, struct _turb1__GetDensityHessian *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetDensityHessian))
		soap_serialize__turb1__GetDensityHessian(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetDensityHessian(struct soap *soap, const char *tag, int id, struct _turb1__GetDensityHessian *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetDensityHessian);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetDensityHessian(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetDensityHessian ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetDensityHessian(struct soap *soap, const char *tag, struct _turb1__GetDensityHessian **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetDensityHessian **)soap_malloc(soap, sizeof(struct _turb1__GetDensityHessian *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetDensityHessian(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetDensityHessian **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetDensityHessian, sizeof(struct _turb1__GetDensityHessian), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetDensityHessian(struct soap *soap, struct _turb1__GetDensityHessian *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetDensityHessian);
	if (soap_out_PointerTo_turb1__GetDensityHessian(soap, tag?tag:"turb1:GetDensityHessian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetDensityHessian ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetDensityHessian(struct soap *soap, struct _turb1__GetDensityHessian **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetDensityHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetDensityGradientResponse(struct soap *soap, struct _turb1__GetDensityGradientResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetDensityGradientResponse))
		soap_serialize__turb1__GetDensityGradientResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetDensityGradientResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetDensityGradientResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetDensityGradientResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetDensityGradientResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetDensityGradientResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetDensityGradientResponse(struct soap *soap, const char *tag, struct _turb1__GetDensityGradientResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetDensityGradientResponse **)soap_malloc(soap, sizeof(struct _turb1__GetDensityGradientResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetDensityGradientResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetDensityGradientResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetDensityGradientResponse, sizeof(struct _turb1__GetDensityGradientResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetDensityGradientResponse(struct soap *soap, struct _turb1__GetDensityGradientResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetDensityGradientResponse);
	if (soap_out_PointerTo_turb1__GetDensityGradientResponse(soap, tag?tag:"turb1:GetDensityGradientResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetDensityGradientResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetDensityGradientResponse(struct soap *soap, struct _turb1__GetDensityGradientResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetDensityGradientResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetDensityGradient(struct soap *soap, struct _turb1__GetDensityGradient *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetDensityGradient))
		soap_serialize__turb1__GetDensityGradient(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetDensityGradient(struct soap *soap, const char *tag, int id, struct _turb1__GetDensityGradient *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetDensityGradient);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetDensityGradient(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetDensityGradient ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetDensityGradient(struct soap *soap, const char *tag, struct _turb1__GetDensityGradient **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetDensityGradient **)soap_malloc(soap, sizeof(struct _turb1__GetDensityGradient *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetDensityGradient(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetDensityGradient **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetDensityGradient, sizeof(struct _turb1__GetDensityGradient), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetDensityGradient(struct soap *soap, struct _turb1__GetDensityGradient *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetDensityGradient);
	if (soap_out_PointerTo_turb1__GetDensityGradient(soap, tag?tag:"turb1:GetDensityGradient", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetDensityGradient ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetDensityGradient(struct soap *soap, struct _turb1__GetDensityGradient **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetDensityGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetDensityResponse(struct soap *soap, struct _turb1__GetDensityResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetDensityResponse))
		soap_serialize__turb1__GetDensityResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetDensityResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetDensityResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetDensityResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetDensityResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetDensityResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetDensityResponse(struct soap *soap, const char *tag, struct _turb1__GetDensityResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetDensityResponse **)soap_malloc(soap, sizeof(struct _turb1__GetDensityResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetDensityResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetDensityResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetDensityResponse, sizeof(struct _turb1__GetDensityResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetDensityResponse(struct soap *soap, struct _turb1__GetDensityResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetDensityResponse);
	if (soap_out_PointerTo_turb1__GetDensityResponse(soap, tag?tag:"turb1:GetDensityResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetDensityResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetDensityResponse(struct soap *soap, struct _turb1__GetDensityResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetDensityResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetDensity(struct soap *soap, struct _turb1__GetDensity *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetDensity))
		soap_serialize__turb1__GetDensity(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetDensity(struct soap *soap, const char *tag, int id, struct _turb1__GetDensity *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetDensity);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetDensity(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetDensity ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetDensity(struct soap *soap, const char *tag, struct _turb1__GetDensity **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetDensity **)soap_malloc(soap, sizeof(struct _turb1__GetDensity *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetDensity(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetDensity **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetDensity, sizeof(struct _turb1__GetDensity), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetDensity(struct soap *soap, struct _turb1__GetDensity *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetDensity);
	if (soap_out_PointerTo_turb1__GetDensity(soap, tag?tag:"turb1:GetDensity", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetDensity ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetDensity(struct soap *soap, struct _turb1__GetDensity **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetDensity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetRawVectorPotentialResponse(struct soap *soap, struct _turb1__GetRawVectorPotentialResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetRawVectorPotentialResponse))
		soap_serialize__turb1__GetRawVectorPotentialResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetRawVectorPotentialResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetRawVectorPotentialResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetRawVectorPotentialResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetRawVectorPotentialResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetRawVectorPotentialResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetRawVectorPotentialResponse(struct soap *soap, const char *tag, struct _turb1__GetRawVectorPotentialResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetRawVectorPotentialResponse **)soap_malloc(soap, sizeof(struct _turb1__GetRawVectorPotentialResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetRawVectorPotentialResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetRawVectorPotentialResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetRawVectorPotentialResponse, sizeof(struct _turb1__GetRawVectorPotentialResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetRawVectorPotentialResponse(struct soap *soap, struct _turb1__GetRawVectorPotentialResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetRawVectorPotentialResponse);
	if (soap_out_PointerTo_turb1__GetRawVectorPotentialResponse(soap, tag?tag:"turb1:GetRawVectorPotentialResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetRawVectorPotentialResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetRawVectorPotentialResponse(struct soap *soap, struct _turb1__GetRawVectorPotentialResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetRawVectorPotentialResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetRawVectorPotential(struct soap *soap, struct _turb1__GetRawVectorPotential *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetRawVectorPotential))
		soap_serialize__turb1__GetRawVectorPotential(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetRawVectorPotential(struct soap *soap, const char *tag, int id, struct _turb1__GetRawVectorPotential *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetRawVectorPotential);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetRawVectorPotential(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetRawVectorPotential ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetRawVectorPotential(struct soap *soap, const char *tag, struct _turb1__GetRawVectorPotential **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetRawVectorPotential **)soap_malloc(soap, sizeof(struct _turb1__GetRawVectorPotential *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetRawVectorPotential(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetRawVectorPotential **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetRawVectorPotential, sizeof(struct _turb1__GetRawVectorPotential), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetRawVectorPotential(struct soap *soap, struct _turb1__GetRawVectorPotential *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetRawVectorPotential);
	if (soap_out_PointerTo_turb1__GetRawVectorPotential(soap, tag?tag:"turb1:GetRawVectorPotential", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetRawVectorPotential ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetRawVectorPotential(struct soap *soap, struct _turb1__GetRawVectorPotential **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetRawVectorPotential(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetVectorPotentialResponse(struct soap *soap, struct _turb1__GetVectorPotentialResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetVectorPotentialResponse))
		soap_serialize__turb1__GetVectorPotentialResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetVectorPotentialResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetVectorPotentialResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetVectorPotentialResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetVectorPotentialResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetVectorPotentialResponse(struct soap *soap, const char *tag, struct _turb1__GetVectorPotentialResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetVectorPotentialResponse **)soap_malloc(soap, sizeof(struct _turb1__GetVectorPotentialResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetVectorPotentialResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVectorPotentialResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetVectorPotentialResponse, sizeof(struct _turb1__GetVectorPotentialResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetVectorPotentialResponse(struct soap *soap, struct _turb1__GetVectorPotentialResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetVectorPotentialResponse);
	if (soap_out_PointerTo_turb1__GetVectorPotentialResponse(soap, tag?tag:"turb1:GetVectorPotentialResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVectorPotentialResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetVectorPotentialResponse(struct soap *soap, struct _turb1__GetVectorPotentialResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetVectorPotentialResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetVectorPotential(struct soap *soap, struct _turb1__GetVectorPotential *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetVectorPotential))
		soap_serialize__turb1__GetVectorPotential(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetVectorPotential(struct soap *soap, const char *tag, int id, struct _turb1__GetVectorPotential *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetVectorPotential);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetVectorPotential(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetVectorPotential ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetVectorPotential(struct soap *soap, const char *tag, struct _turb1__GetVectorPotential **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetVectorPotential **)soap_malloc(soap, sizeof(struct _turb1__GetVectorPotential *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetVectorPotential(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVectorPotential **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetVectorPotential, sizeof(struct _turb1__GetVectorPotential), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetVectorPotential(struct soap *soap, struct _turb1__GetVectorPotential *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetVectorPotential);
	if (soap_out_PointerTo_turb1__GetVectorPotential(soap, tag?tag:"turb1:GetVectorPotential", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVectorPotential ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetVectorPotential(struct soap *soap, struct _turb1__GetVectorPotential **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetVectorPotential(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetRawMagneticFieldResponse(struct soap *soap, struct _turb1__GetRawMagneticFieldResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetRawMagneticFieldResponse))
		soap_serialize__turb1__GetRawMagneticFieldResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetRawMagneticFieldResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetRawMagneticFieldResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetRawMagneticFieldResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetRawMagneticFieldResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetRawMagneticFieldResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetRawMagneticFieldResponse(struct soap *soap, const char *tag, struct _turb1__GetRawMagneticFieldResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetRawMagneticFieldResponse **)soap_malloc(soap, sizeof(struct _turb1__GetRawMagneticFieldResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetRawMagneticFieldResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetRawMagneticFieldResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetRawMagneticFieldResponse, sizeof(struct _turb1__GetRawMagneticFieldResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetRawMagneticFieldResponse(struct soap *soap, struct _turb1__GetRawMagneticFieldResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetRawMagneticFieldResponse);
	if (soap_out_PointerTo_turb1__GetRawMagneticFieldResponse(soap, tag?tag:"turb1:GetRawMagneticFieldResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetRawMagneticFieldResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetRawMagneticFieldResponse(struct soap *soap, struct _turb1__GetRawMagneticFieldResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetRawMagneticFieldResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetRawMagneticField(struct soap *soap, struct _turb1__GetRawMagneticField *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetRawMagneticField))
		soap_serialize__turb1__GetRawMagneticField(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetRawMagneticField(struct soap *soap, const char *tag, int id, struct _turb1__GetRawMagneticField *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetRawMagneticField);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetRawMagneticField(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetRawMagneticField ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetRawMagneticField(struct soap *soap, const char *tag, struct _turb1__GetRawMagneticField **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetRawMagneticField **)soap_malloc(soap, sizeof(struct _turb1__GetRawMagneticField *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetRawMagneticField(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetRawMagneticField **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetRawMagneticField, sizeof(struct _turb1__GetRawMagneticField), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetRawMagneticField(struct soap *soap, struct _turb1__GetRawMagneticField *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetRawMagneticField);
	if (soap_out_PointerTo_turb1__GetRawMagneticField(soap, tag?tag:"turb1:GetRawMagneticField", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetRawMagneticField ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetRawMagneticField(struct soap *soap, struct _turb1__GetRawMagneticField **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetRawMagneticField(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetMagneticFieldResponse(struct soap *soap, struct _turb1__GetMagneticFieldResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetMagneticFieldResponse))
		soap_serialize__turb1__GetMagneticFieldResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetMagneticFieldResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetMagneticFieldResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetMagneticFieldResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetMagneticFieldResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetMagneticFieldResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetMagneticFieldResponse(struct soap *soap, const char *tag, struct _turb1__GetMagneticFieldResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetMagneticFieldResponse **)soap_malloc(soap, sizeof(struct _turb1__GetMagneticFieldResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetMagneticFieldResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetMagneticFieldResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetMagneticFieldResponse, sizeof(struct _turb1__GetMagneticFieldResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetMagneticFieldResponse(struct soap *soap, struct _turb1__GetMagneticFieldResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetMagneticFieldResponse);
	if (soap_out_PointerTo_turb1__GetMagneticFieldResponse(soap, tag?tag:"turb1:GetMagneticFieldResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetMagneticFieldResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetMagneticFieldResponse(struct soap *soap, struct _turb1__GetMagneticFieldResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetMagneticFieldResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetMagneticField(struct soap *soap, struct _turb1__GetMagneticField *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetMagneticField))
		soap_serialize__turb1__GetMagneticField(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetMagneticField(struct soap *soap, const char *tag, int id, struct _turb1__GetMagneticField *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetMagneticField);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetMagneticField(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetMagneticField ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetMagneticField(struct soap *soap, const char *tag, struct _turb1__GetMagneticField **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetMagneticField **)soap_malloc(soap, sizeof(struct _turb1__GetMagneticField *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetMagneticField(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetMagneticField **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetMagneticField, sizeof(struct _turb1__GetMagneticField), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetMagneticField(struct soap *soap, struct _turb1__GetMagneticField *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetMagneticField);
	if (soap_out_PointerTo_turb1__GetMagneticField(soap, tag?tag:"turb1:GetMagneticField", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetMagneticField ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetMagneticField(struct soap *soap, struct _turb1__GetMagneticField **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetMagneticField(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetRawPressureResponse(struct soap *soap, struct _turb1__GetRawPressureResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetRawPressureResponse))
		soap_serialize__turb1__GetRawPressureResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetRawPressureResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetRawPressureResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetRawPressureResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetRawPressureResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetRawPressureResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetRawPressureResponse(struct soap *soap, const char *tag, struct _turb1__GetRawPressureResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetRawPressureResponse **)soap_malloc(soap, sizeof(struct _turb1__GetRawPressureResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetRawPressureResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetRawPressureResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetRawPressureResponse, sizeof(struct _turb1__GetRawPressureResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetRawPressureResponse(struct soap *soap, struct _turb1__GetRawPressureResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetRawPressureResponse);
	if (soap_out_PointerTo_turb1__GetRawPressureResponse(soap, tag?tag:"turb1:GetRawPressureResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetRawPressureResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetRawPressureResponse(struct soap *soap, struct _turb1__GetRawPressureResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetRawPressureResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetRawPressure(struct soap *soap, struct _turb1__GetRawPressure *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetRawPressure))
		soap_serialize__turb1__GetRawPressure(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetRawPressure(struct soap *soap, const char *tag, int id, struct _turb1__GetRawPressure *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetRawPressure);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetRawPressure(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetRawPressure ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetRawPressure(struct soap *soap, const char *tag, struct _turb1__GetRawPressure **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetRawPressure **)soap_malloc(soap, sizeof(struct _turb1__GetRawPressure *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetRawPressure(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetRawPressure **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetRawPressure, sizeof(struct _turb1__GetRawPressure), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetRawPressure(struct soap *soap, struct _turb1__GetRawPressure *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetRawPressure);
	if (soap_out_PointerTo_turb1__GetRawPressure(soap, tag?tag:"turb1:GetRawPressure", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetRawPressure ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetRawPressure(struct soap *soap, struct _turb1__GetRawPressure **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetRawPressure(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetPressureResponse(struct soap *soap, struct _turb1__GetPressureResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetPressureResponse))
		soap_serialize__turb1__GetPressureResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetPressureResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetPressureResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetPressureResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetPressureResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetPressureResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetPressureResponse(struct soap *soap, const char *tag, struct _turb1__GetPressureResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetPressureResponse **)soap_malloc(soap, sizeof(struct _turb1__GetPressureResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetPressureResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetPressureResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetPressureResponse, sizeof(struct _turb1__GetPressureResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetPressureResponse(struct soap *soap, struct _turb1__GetPressureResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetPressureResponse);
	if (soap_out_PointerTo_turb1__GetPressureResponse(soap, tag?tag:"turb1:GetPressureResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetPressureResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetPressureResponse(struct soap *soap, struct _turb1__GetPressureResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetPressureResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetPressure(struct soap *soap, struct _turb1__GetPressure *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetPressure))
		soap_serialize__turb1__GetPressure(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetPressure(struct soap *soap, const char *tag, int id, struct _turb1__GetPressure *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetPressure);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetPressure(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetPressure ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetPressure(struct soap *soap, const char *tag, struct _turb1__GetPressure **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetPressure **)soap_malloc(soap, sizeof(struct _turb1__GetPressure *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetPressure(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetPressure **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetPressure, sizeof(struct _turb1__GetPressure), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetPressure(struct soap *soap, struct _turb1__GetPressure *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetPressure);
	if (soap_out_PointerTo_turb1__GetPressure(soap, tag?tag:"turb1:GetPressure", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetPressure ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetPressure(struct soap *soap, struct _turb1__GetPressure **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetPressure(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetRawVelocityResponse(struct soap *soap, struct _turb1__GetRawVelocityResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetRawVelocityResponse))
		soap_serialize__turb1__GetRawVelocityResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetRawVelocityResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetRawVelocityResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetRawVelocityResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetRawVelocityResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetRawVelocityResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetRawVelocityResponse(struct soap *soap, const char *tag, struct _turb1__GetRawVelocityResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetRawVelocityResponse **)soap_malloc(soap, sizeof(struct _turb1__GetRawVelocityResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetRawVelocityResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetRawVelocityResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetRawVelocityResponse, sizeof(struct _turb1__GetRawVelocityResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetRawVelocityResponse(struct soap *soap, struct _turb1__GetRawVelocityResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetRawVelocityResponse);
	if (soap_out_PointerTo_turb1__GetRawVelocityResponse(soap, tag?tag:"turb1:GetRawVelocityResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetRawVelocityResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetRawVelocityResponse(struct soap *soap, struct _turb1__GetRawVelocityResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetRawVelocityResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetRawVelocity(struct soap *soap, struct _turb1__GetRawVelocity *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetRawVelocity))
		soap_serialize__turb1__GetRawVelocity(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetRawVelocity(struct soap *soap, const char *tag, int id, struct _turb1__GetRawVelocity *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetRawVelocity);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetRawVelocity(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetRawVelocity ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetRawVelocity(struct soap *soap, const char *tag, struct _turb1__GetRawVelocity **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetRawVelocity **)soap_malloc(soap, sizeof(struct _turb1__GetRawVelocity *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetRawVelocity(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetRawVelocity **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetRawVelocity, sizeof(struct _turb1__GetRawVelocity), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetRawVelocity(struct soap *soap, struct _turb1__GetRawVelocity *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetRawVelocity);
	if (soap_out_PointerTo_turb1__GetRawVelocity(soap, tag?tag:"turb1:GetRawVelocity", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetRawVelocity ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetRawVelocity(struct soap *soap, struct _turb1__GetRawVelocity **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetRawVelocity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetVelocityBatchResponse(struct soap *soap, struct _turb1__GetVelocityBatchResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetVelocityBatchResponse))
		soap_serialize__turb1__GetVelocityBatchResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetVelocityBatchResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetVelocityBatchResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetVelocityBatchResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetVelocityBatchResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetVelocityBatchResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetVelocityBatchResponse(struct soap *soap, const char *tag, struct _turb1__GetVelocityBatchResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetVelocityBatchResponse **)soap_malloc(soap, sizeof(struct _turb1__GetVelocityBatchResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetVelocityBatchResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityBatchResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetVelocityBatchResponse, sizeof(struct _turb1__GetVelocityBatchResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetVelocityBatchResponse(struct soap *soap, struct _turb1__GetVelocityBatchResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetVelocityBatchResponse);
	if (soap_out_PointerTo_turb1__GetVelocityBatchResponse(soap, tag?tag:"turb1:GetVelocityBatchResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityBatchResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetVelocityBatchResponse(struct soap *soap, struct _turb1__GetVelocityBatchResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetVelocityBatchResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetVelocityBatch(struct soap *soap, struct _turb1__GetVelocityBatch *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetVelocityBatch))
		soap_serialize__turb1__GetVelocityBatch(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetVelocityBatch(struct soap *soap, const char *tag, int id, struct _turb1__GetVelocityBatch *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetVelocityBatch);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetVelocityBatch(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetVelocityBatch ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetVelocityBatch(struct soap *soap, const char *tag, struct _turb1__GetVelocityBatch **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetVelocityBatch **)soap_malloc(soap, sizeof(struct _turb1__GetVelocityBatch *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetVelocityBatch(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityBatch **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetVelocityBatch, sizeof(struct _turb1__GetVelocityBatch), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetVelocityBatch(struct soap *soap, struct _turb1__GetVelocityBatch *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetVelocityBatch);
	if (soap_out_PointerTo_turb1__GetVelocityBatch(soap, tag?tag:"turb1:GetVelocityBatch", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityBatch ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetVelocityBatch(struct soap *soap, struct _turb1__GetVelocityBatch **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetVelocityBatch(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetVelocityResponse(struct soap *soap, struct _turb1__GetVelocityResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetVelocityResponse))
		soap_serialize__turb1__GetVelocityResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetVelocityResponse(struct soap *soap, const char *tag, int id, struct _turb1__GetVelocityResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetVelocityResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetVelocityResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetVelocityResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetVelocityResponse(struct soap *soap, const char *tag, struct _turb1__GetVelocityResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetVelocityResponse **)soap_malloc(soap, sizeof(struct _turb1__GetVelocityResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetVelocityResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocityResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetVelocityResponse, sizeof(struct _turb1__GetVelocityResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetVelocityResponse(struct soap *soap, struct _turb1__GetVelocityResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetVelocityResponse);
	if (soap_out_PointerTo_turb1__GetVelocityResponse(soap, tag?tag:"turb1:GetVelocityResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocityResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetVelocityResponse(struct soap *soap, struct _turb1__GetVelocityResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetVelocityResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__GetVelocity(struct soap *soap, struct _turb1__GetVelocity *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__GetVelocity))
		soap_serialize__turb1__GetVelocity(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__GetVelocity(struct soap *soap, const char *tag, int id, struct _turb1__GetVelocity *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__GetVelocity);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__GetVelocity(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__GetVelocity ** SOAP_FMAC4 soap_in_PointerTo_turb1__GetVelocity(struct soap *soap, const char *tag, struct _turb1__GetVelocity **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__GetVelocity **)soap_malloc(soap, sizeof(struct _turb1__GetVelocity *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__GetVelocity(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__GetVelocity **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__GetVelocity, sizeof(struct _turb1__GetVelocity), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__GetVelocity(struct soap *soap, struct _turb1__GetVelocity *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__GetVelocity);
	if (soap_out_PointerTo_turb1__GetVelocity(soap, tag?tag:"turb1:GetVelocity", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__GetVelocity ** SOAP_FMAC4 soap_get_PointerTo_turb1__GetVelocity(struct soap *soap, struct _turb1__GetVelocity **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__GetVelocity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__NullOpResponse(struct soap *soap, struct _turb1__NullOpResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__NullOpResponse))
		soap_serialize__turb1__NullOpResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__NullOpResponse(struct soap *soap, const char *tag, int id, struct _turb1__NullOpResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__NullOpResponse);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__NullOpResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__NullOpResponse ** SOAP_FMAC4 soap_in_PointerTo_turb1__NullOpResponse(struct soap *soap, const char *tag, struct _turb1__NullOpResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__NullOpResponse **)soap_malloc(soap, sizeof(struct _turb1__NullOpResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__NullOpResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__NullOpResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__NullOpResponse, sizeof(struct _turb1__NullOpResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__NullOpResponse(struct soap *soap, struct _turb1__NullOpResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__NullOpResponse);
	if (soap_out_PointerTo_turb1__NullOpResponse(soap, tag?tag:"turb1:NullOpResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__NullOpResponse ** SOAP_FMAC4 soap_get_PointerTo_turb1__NullOpResponse(struct soap *soap, struct _turb1__NullOpResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__NullOpResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_turb1__NullOp(struct soap *soap, struct _turb1__NullOp *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__turb1__NullOp))
		soap_serialize__turb1__NullOp(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_turb1__NullOp(struct soap *soap, const char *tag, int id, struct _turb1__NullOp *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__turb1__NullOp);
	if (id < 0)
		return soap->error;
	return soap_out__turb1__NullOp(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _turb1__NullOp ** SOAP_FMAC4 soap_in_PointerTo_turb1__NullOp(struct soap *soap, const char *tag, struct _turb1__NullOp **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _turb1__NullOp **)soap_malloc(soap, sizeof(struct _turb1__NullOp *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__turb1__NullOp(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _turb1__NullOp **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__turb1__NullOp, sizeof(struct _turb1__NullOp), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_turb1__NullOp(struct soap *soap, struct _turb1__NullOp *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_turb1__NullOp);
	if (soap_out_PointerTo_turb1__NullOp(soap, tag?tag:"turb1:NullOp", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _turb1__NullOp ** SOAP_FMAC4 soap_get_PointerTo_turb1__NullOp(struct soap *soap, struct _turb1__NullOp **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_turb1__NullOp(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToturb1__ArrayOfThresholdInfo(struct soap *soap, struct turb1__ArrayOfThresholdInfo *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_turb1__ArrayOfThresholdInfo))
		soap_serialize_turb1__ArrayOfThresholdInfo(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToturb1__ArrayOfThresholdInfo(struct soap *soap, const char *tag, int id, struct turb1__ArrayOfThresholdInfo *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_turb1__ArrayOfThresholdInfo);
	if (id < 0)
		return soap->error;
	return soap_out_turb1__ArrayOfThresholdInfo(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct turb1__ArrayOfThresholdInfo ** SOAP_FMAC4 soap_in_PointerToturb1__ArrayOfThresholdInfo(struct soap *soap, const char *tag, struct turb1__ArrayOfThresholdInfo **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct turb1__ArrayOfThresholdInfo **)soap_malloc(soap, sizeof(struct turb1__ArrayOfThresholdInfo *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_turb1__ArrayOfThresholdInfo(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct turb1__ArrayOfThresholdInfo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_turb1__ArrayOfThresholdInfo, sizeof(struct turb1__ArrayOfThresholdInfo), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToturb1__ArrayOfThresholdInfo(struct soap *soap, struct turb1__ArrayOfThresholdInfo *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToturb1__ArrayOfThresholdInfo);
	if (soap_out_PointerToturb1__ArrayOfThresholdInfo(soap, tag?tag:"turb1:ArrayOfThresholdInfo", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__ArrayOfThresholdInfo ** SOAP_FMAC4 soap_get_PointerToturb1__ArrayOfThresholdInfo(struct soap *soap, struct turb1__ArrayOfThresholdInfo **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToturb1__ArrayOfThresholdInfo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToturb1__ArrayOfSGSTensor(struct soap *soap, struct turb1__ArrayOfSGSTensor *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_turb1__ArrayOfSGSTensor))
		soap_serialize_turb1__ArrayOfSGSTensor(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToturb1__ArrayOfSGSTensor(struct soap *soap, const char *tag, int id, struct turb1__ArrayOfSGSTensor *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_turb1__ArrayOfSGSTensor);
	if (id < 0)
		return soap->error;
	return soap_out_turb1__ArrayOfSGSTensor(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct turb1__ArrayOfSGSTensor ** SOAP_FMAC4 soap_in_PointerToturb1__ArrayOfSGSTensor(struct soap *soap, const char *tag, struct turb1__ArrayOfSGSTensor **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct turb1__ArrayOfSGSTensor **)soap_malloc(soap, sizeof(struct turb1__ArrayOfSGSTensor *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_turb1__ArrayOfSGSTensor(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct turb1__ArrayOfSGSTensor **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_turb1__ArrayOfSGSTensor, sizeof(struct turb1__ArrayOfSGSTensor), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToturb1__ArrayOfSGSTensor(struct soap *soap, struct turb1__ArrayOfSGSTensor *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToturb1__ArrayOfSGSTensor);
	if (soap_out_PointerToturb1__ArrayOfSGSTensor(soap, tag?tag:"turb1:ArrayOfSGSTensor", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__ArrayOfSGSTensor ** SOAP_FMAC4 soap_get_PointerToturb1__ArrayOfSGSTensor(struct soap *soap, struct turb1__ArrayOfSGSTensor **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToturb1__ArrayOfSGSTensor(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToturb1__ArrayOfVelocityHessian(struct soap *soap, struct turb1__ArrayOfVelocityHessian *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_turb1__ArrayOfVelocityHessian))
		soap_serialize_turb1__ArrayOfVelocityHessian(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToturb1__ArrayOfVelocityHessian(struct soap *soap, const char *tag, int id, struct turb1__ArrayOfVelocityHessian *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_turb1__ArrayOfVelocityHessian);
	if (id < 0)
		return soap->error;
	return soap_out_turb1__ArrayOfVelocityHessian(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct turb1__ArrayOfVelocityHessian ** SOAP_FMAC4 soap_in_PointerToturb1__ArrayOfVelocityHessian(struct soap *soap, const char *tag, struct turb1__ArrayOfVelocityHessian **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct turb1__ArrayOfVelocityHessian **)soap_malloc(soap, sizeof(struct turb1__ArrayOfVelocityHessian *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_turb1__ArrayOfVelocityHessian(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct turb1__ArrayOfVelocityHessian **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_turb1__ArrayOfVelocityHessian, sizeof(struct turb1__ArrayOfVelocityHessian), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToturb1__ArrayOfVelocityHessian(struct soap *soap, struct turb1__ArrayOfVelocityHessian *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToturb1__ArrayOfVelocityHessian);
	if (soap_out_PointerToturb1__ArrayOfVelocityHessian(soap, tag?tag:"turb1:ArrayOfVelocityHessian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__ArrayOfVelocityHessian ** SOAP_FMAC4 soap_get_PointerToturb1__ArrayOfVelocityHessian(struct soap *soap, struct turb1__ArrayOfVelocityHessian **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToturb1__ArrayOfVelocityHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToturb1__ArrayOfVelocityGradient(struct soap *soap, struct turb1__ArrayOfVelocityGradient *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_turb1__ArrayOfVelocityGradient))
		soap_serialize_turb1__ArrayOfVelocityGradient(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToturb1__ArrayOfVelocityGradient(struct soap *soap, const char *tag, int id, struct turb1__ArrayOfVelocityGradient *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_turb1__ArrayOfVelocityGradient);
	if (id < 0)
		return soap->error;
	return soap_out_turb1__ArrayOfVelocityGradient(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct turb1__ArrayOfVelocityGradient ** SOAP_FMAC4 soap_in_PointerToturb1__ArrayOfVelocityGradient(struct soap *soap, const char *tag, struct turb1__ArrayOfVelocityGradient **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct turb1__ArrayOfVelocityGradient **)soap_malloc(soap, sizeof(struct turb1__ArrayOfVelocityGradient *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_turb1__ArrayOfVelocityGradient(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct turb1__ArrayOfVelocityGradient **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_turb1__ArrayOfVelocityGradient, sizeof(struct turb1__ArrayOfVelocityGradient), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToturb1__ArrayOfVelocityGradient(struct soap *soap, struct turb1__ArrayOfVelocityGradient *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToturb1__ArrayOfVelocityGradient);
	if (soap_out_PointerToturb1__ArrayOfVelocityGradient(soap, tag?tag:"turb1:ArrayOfVelocityGradient", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__ArrayOfVelocityGradient ** SOAP_FMAC4 soap_get_PointerToturb1__ArrayOfVelocityGradient(struct soap *soap, struct turb1__ArrayOfVelocityGradient **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToturb1__ArrayOfVelocityGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToturb1__ArrayOfVector3P(struct soap *soap, struct turb1__ArrayOfVector3P *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_turb1__ArrayOfVector3P))
		soap_serialize_turb1__ArrayOfVector3P(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToturb1__ArrayOfVector3P(struct soap *soap, const char *tag, int id, struct turb1__ArrayOfVector3P *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_turb1__ArrayOfVector3P);
	if (id < 0)
		return soap->error;
	return soap_out_turb1__ArrayOfVector3P(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct turb1__ArrayOfVector3P ** SOAP_FMAC4 soap_in_PointerToturb1__ArrayOfVector3P(struct soap *soap, const char *tag, struct turb1__ArrayOfVector3P **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct turb1__ArrayOfVector3P **)soap_malloc(soap, sizeof(struct turb1__ArrayOfVector3P *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_turb1__ArrayOfVector3P(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct turb1__ArrayOfVector3P **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_turb1__ArrayOfVector3P, sizeof(struct turb1__ArrayOfVector3P), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToturb1__ArrayOfVector3P(struct soap *soap, struct turb1__ArrayOfVector3P *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToturb1__ArrayOfVector3P);
	if (soap_out_PointerToturb1__ArrayOfVector3P(soap, tag?tag:"turb1:ArrayOfVector3P", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__ArrayOfVector3P ** SOAP_FMAC4 soap_get_PointerToturb1__ArrayOfVector3P(struct soap *soap, struct turb1__ArrayOfVector3P **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToturb1__ArrayOfVector3P(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToturb1__ArrayOfPressureHessian(struct soap *soap, struct turb1__ArrayOfPressureHessian *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_turb1__ArrayOfPressureHessian))
		soap_serialize_turb1__ArrayOfPressureHessian(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToturb1__ArrayOfPressureHessian(struct soap *soap, const char *tag, int id, struct turb1__ArrayOfPressureHessian *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_turb1__ArrayOfPressureHessian);
	if (id < 0)
		return soap->error;
	return soap_out_turb1__ArrayOfPressureHessian(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct turb1__ArrayOfPressureHessian ** SOAP_FMAC4 soap_in_PointerToturb1__ArrayOfPressureHessian(struct soap *soap, const char *tag, struct turb1__ArrayOfPressureHessian **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct turb1__ArrayOfPressureHessian **)soap_malloc(soap, sizeof(struct turb1__ArrayOfPressureHessian *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_turb1__ArrayOfPressureHessian(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct turb1__ArrayOfPressureHessian **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_turb1__ArrayOfPressureHessian, sizeof(struct turb1__ArrayOfPressureHessian), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToturb1__ArrayOfPressureHessian(struct soap *soap, struct turb1__ArrayOfPressureHessian *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToturb1__ArrayOfPressureHessian);
	if (soap_out_PointerToturb1__ArrayOfPressureHessian(soap, tag?tag:"turb1:ArrayOfPressureHessian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__ArrayOfPressureHessian ** SOAP_FMAC4 soap_get_PointerToturb1__ArrayOfPressureHessian(struct soap *soap, struct turb1__ArrayOfPressureHessian **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToturb1__ArrayOfPressureHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToturb1__ArrayOfPressure(struct soap *soap, struct turb1__ArrayOfPressure *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_turb1__ArrayOfPressure))
		soap_serialize_turb1__ArrayOfPressure(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToturb1__ArrayOfPressure(struct soap *soap, const char *tag, int id, struct turb1__ArrayOfPressure *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_turb1__ArrayOfPressure);
	if (id < 0)
		return soap->error;
	return soap_out_turb1__ArrayOfPressure(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct turb1__ArrayOfPressure ** SOAP_FMAC4 soap_in_PointerToturb1__ArrayOfPressure(struct soap *soap, const char *tag, struct turb1__ArrayOfPressure **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct turb1__ArrayOfPressure **)soap_malloc(soap, sizeof(struct turb1__ArrayOfPressure *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_turb1__ArrayOfPressure(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct turb1__ArrayOfPressure **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_turb1__ArrayOfPressure, sizeof(struct turb1__ArrayOfPressure), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToturb1__ArrayOfPressure(struct soap *soap, struct turb1__ArrayOfPressure *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToturb1__ArrayOfPressure);
	if (soap_out_PointerToturb1__ArrayOfPressure(soap, tag?tag:"turb1:ArrayOfPressure", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__ArrayOfPressure ** SOAP_FMAC4 soap_get_PointerToturb1__ArrayOfPressure(struct soap *soap, struct turb1__ArrayOfPressure **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToturb1__ArrayOfPressure(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxsd__base64Binary(struct soap *soap, struct xsd__base64Binary *const*a)
{
	if (*a)
		soap_serialize_xsd__base64Binary(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxsd__base64Binary(struct soap *soap, const char *tag, int id, struct xsd__base64Binary *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_xsd__base64Binary);
	if (id < 0)
		return soap->error;
	return soap_out_xsd__base64Binary(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct xsd__base64Binary ** SOAP_FMAC4 soap_in_PointerToxsd__base64Binary(struct soap *soap, const char *tag, struct xsd__base64Binary **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct xsd__base64Binary **)soap_malloc(soap, sizeof(struct xsd__base64Binary *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_xsd__base64Binary(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct xsd__base64Binary **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xsd__base64Binary, sizeof(struct xsd__base64Binary), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxsd__base64Binary(struct soap *soap, struct xsd__base64Binary *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxsd__base64Binary);
	if (soap_out_PointerToxsd__base64Binary(soap, tag?tag:"xsd:base64Binary", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xsd__base64Binary ** SOAP_FMAC4 soap_get_PointerToxsd__base64Binary(struct soap *soap, struct xsd__base64Binary **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxsd__base64Binary(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToturb1__ArrayOfVector3(struct soap *soap, struct turb1__ArrayOfVector3 *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_turb1__ArrayOfVector3))
		soap_serialize_turb1__ArrayOfVector3(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToturb1__ArrayOfVector3(struct soap *soap, const char *tag, int id, struct turb1__ArrayOfVector3 *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_turb1__ArrayOfVector3);
	if (id < 0)
		return soap->error;
	return soap_out_turb1__ArrayOfVector3(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct turb1__ArrayOfVector3 ** SOAP_FMAC4 soap_in_PointerToturb1__ArrayOfVector3(struct soap *soap, const char *tag, struct turb1__ArrayOfVector3 **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct turb1__ArrayOfVector3 **)soap_malloc(soap, sizeof(struct turb1__ArrayOfVector3 *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_turb1__ArrayOfVector3(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct turb1__ArrayOfVector3 **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_turb1__ArrayOfVector3, sizeof(struct turb1__ArrayOfVector3), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToturb1__ArrayOfVector3(struct soap *soap, struct turb1__ArrayOfVector3 *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToturb1__ArrayOfVector3);
	if (soap_out_PointerToturb1__ArrayOfVector3(soap, tag?tag:"turb1:ArrayOfVector3", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__ArrayOfVector3 ** SOAP_FMAC4 soap_get_PointerToturb1__ArrayOfVector3(struct soap *soap, struct turb1__ArrayOfVector3 **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToturb1__ArrayOfVector3(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToturb1__ArrayOfPoint3(struct soap *soap, struct turb1__ArrayOfPoint3 *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_turb1__ArrayOfPoint3))
		soap_serialize_turb1__ArrayOfPoint3(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToturb1__ArrayOfPoint3(struct soap *soap, const char *tag, int id, struct turb1__ArrayOfPoint3 *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_turb1__ArrayOfPoint3);
	if (id < 0)
		return soap->error;
	return soap_out_turb1__ArrayOfPoint3(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct turb1__ArrayOfPoint3 ** SOAP_FMAC4 soap_in_PointerToturb1__ArrayOfPoint3(struct soap *soap, const char *tag, struct turb1__ArrayOfPoint3 **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct turb1__ArrayOfPoint3 **)soap_malloc(soap, sizeof(struct turb1__ArrayOfPoint3 *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_turb1__ArrayOfPoint3(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct turb1__ArrayOfPoint3 **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_turb1__ArrayOfPoint3, sizeof(struct turb1__ArrayOfPoint3), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToturb1__ArrayOfPoint3(struct soap *soap, struct turb1__ArrayOfPoint3 *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToturb1__ArrayOfPoint3);
	if (soap_out_PointerToturb1__ArrayOfPoint3(soap, tag?tag:"turb1:ArrayOfPoint3", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__ArrayOfPoint3 ** SOAP_FMAC4 soap_get_PointerToturb1__ArrayOfPoint3(struct soap *soap, struct turb1__ArrayOfPoint3 **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToturb1__ArrayOfPoint3(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToturb1__ThresholdInfo(struct soap *soap, struct turb1__ThresholdInfo *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_turb1__ThresholdInfo))
		soap_serialize_turb1__ThresholdInfo(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToturb1__ThresholdInfo(struct soap *soap, const char *tag, int id, struct turb1__ThresholdInfo *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_turb1__ThresholdInfo);
	if (id < 0)
		return soap->error;
	return soap_out_turb1__ThresholdInfo(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct turb1__ThresholdInfo ** SOAP_FMAC4 soap_in_PointerToturb1__ThresholdInfo(struct soap *soap, const char *tag, struct turb1__ThresholdInfo **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct turb1__ThresholdInfo **)soap_malloc(soap, sizeof(struct turb1__ThresholdInfo *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_turb1__ThresholdInfo(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct turb1__ThresholdInfo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_turb1__ThresholdInfo, sizeof(struct turb1__ThresholdInfo), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToturb1__ThresholdInfo(struct soap *soap, struct turb1__ThresholdInfo *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToturb1__ThresholdInfo);
	if (soap_out_PointerToturb1__ThresholdInfo(soap, tag?tag:"turb1:ThresholdInfo", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__ThresholdInfo ** SOAP_FMAC4 soap_get_PointerToturb1__ThresholdInfo(struct soap *soap, struct turb1__ThresholdInfo **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToturb1__ThresholdInfo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToturb1__SGSTensor(struct soap *soap, struct turb1__SGSTensor *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_turb1__SGSTensor))
		soap_serialize_turb1__SGSTensor(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToturb1__SGSTensor(struct soap *soap, const char *tag, int id, struct turb1__SGSTensor *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_turb1__SGSTensor);
	if (id < 0)
		return soap->error;
	return soap_out_turb1__SGSTensor(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct turb1__SGSTensor ** SOAP_FMAC4 soap_in_PointerToturb1__SGSTensor(struct soap *soap, const char *tag, struct turb1__SGSTensor **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct turb1__SGSTensor **)soap_malloc(soap, sizeof(struct turb1__SGSTensor *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_turb1__SGSTensor(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct turb1__SGSTensor **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_turb1__SGSTensor, sizeof(struct turb1__SGSTensor), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToturb1__SGSTensor(struct soap *soap, struct turb1__SGSTensor *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToturb1__SGSTensor);
	if (soap_out_PointerToturb1__SGSTensor(soap, tag?tag:"turb1:SGSTensor", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__SGSTensor ** SOAP_FMAC4 soap_get_PointerToturb1__SGSTensor(struct soap *soap, struct turb1__SGSTensor **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToturb1__SGSTensor(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToturb1__VelocityHessian(struct soap *soap, struct turb1__VelocityHessian *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_turb1__VelocityHessian))
		soap_serialize_turb1__VelocityHessian(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToturb1__VelocityHessian(struct soap *soap, const char *tag, int id, struct turb1__VelocityHessian *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_turb1__VelocityHessian);
	if (id < 0)
		return soap->error;
	return soap_out_turb1__VelocityHessian(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct turb1__VelocityHessian ** SOAP_FMAC4 soap_in_PointerToturb1__VelocityHessian(struct soap *soap, const char *tag, struct turb1__VelocityHessian **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct turb1__VelocityHessian **)soap_malloc(soap, sizeof(struct turb1__VelocityHessian *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_turb1__VelocityHessian(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct turb1__VelocityHessian **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_turb1__VelocityHessian, sizeof(struct turb1__VelocityHessian), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToturb1__VelocityHessian(struct soap *soap, struct turb1__VelocityHessian *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToturb1__VelocityHessian);
	if (soap_out_PointerToturb1__VelocityHessian(soap, tag?tag:"turb1:VelocityHessian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__VelocityHessian ** SOAP_FMAC4 soap_get_PointerToturb1__VelocityHessian(struct soap *soap, struct turb1__VelocityHessian **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToturb1__VelocityHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToturb1__VelocityGradient(struct soap *soap, struct turb1__VelocityGradient *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_turb1__VelocityGradient))
		soap_serialize_turb1__VelocityGradient(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToturb1__VelocityGradient(struct soap *soap, const char *tag, int id, struct turb1__VelocityGradient *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_turb1__VelocityGradient);
	if (id < 0)
		return soap->error;
	return soap_out_turb1__VelocityGradient(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct turb1__VelocityGradient ** SOAP_FMAC4 soap_in_PointerToturb1__VelocityGradient(struct soap *soap, const char *tag, struct turb1__VelocityGradient **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct turb1__VelocityGradient **)soap_malloc(soap, sizeof(struct turb1__VelocityGradient *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_turb1__VelocityGradient(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct turb1__VelocityGradient **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_turb1__VelocityGradient, sizeof(struct turb1__VelocityGradient), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToturb1__VelocityGradient(struct soap *soap, struct turb1__VelocityGradient *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToturb1__VelocityGradient);
	if (soap_out_PointerToturb1__VelocityGradient(soap, tag?tag:"turb1:VelocityGradient", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__VelocityGradient ** SOAP_FMAC4 soap_get_PointerToturb1__VelocityGradient(struct soap *soap, struct turb1__VelocityGradient **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToturb1__VelocityGradient(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToturb1__Vector3P(struct soap *soap, struct turb1__Vector3P *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_turb1__Vector3P))
		soap_serialize_turb1__Vector3P(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToturb1__Vector3P(struct soap *soap, const char *tag, int id, struct turb1__Vector3P *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_turb1__Vector3P);
	if (id < 0)
		return soap->error;
	return soap_out_turb1__Vector3P(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct turb1__Vector3P ** SOAP_FMAC4 soap_in_PointerToturb1__Vector3P(struct soap *soap, const char *tag, struct turb1__Vector3P **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct turb1__Vector3P **)soap_malloc(soap, sizeof(struct turb1__Vector3P *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_turb1__Vector3P(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct turb1__Vector3P **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_turb1__Vector3P, sizeof(struct turb1__Vector3P), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToturb1__Vector3P(struct soap *soap, struct turb1__Vector3P *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToturb1__Vector3P);
	if (soap_out_PointerToturb1__Vector3P(soap, tag?tag:"turb1:Vector3P", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__Vector3P ** SOAP_FMAC4 soap_get_PointerToturb1__Vector3P(struct soap *soap, struct turb1__Vector3P **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToturb1__Vector3P(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToturb1__PressureHessian(struct soap *soap, struct turb1__PressureHessian *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_turb1__PressureHessian))
		soap_serialize_turb1__PressureHessian(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToturb1__PressureHessian(struct soap *soap, const char *tag, int id, struct turb1__PressureHessian *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_turb1__PressureHessian);
	if (id < 0)
		return soap->error;
	return soap_out_turb1__PressureHessian(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct turb1__PressureHessian ** SOAP_FMAC4 soap_in_PointerToturb1__PressureHessian(struct soap *soap, const char *tag, struct turb1__PressureHessian **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct turb1__PressureHessian **)soap_malloc(soap, sizeof(struct turb1__PressureHessian *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_turb1__PressureHessian(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct turb1__PressureHessian **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_turb1__PressureHessian, sizeof(struct turb1__PressureHessian), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToturb1__PressureHessian(struct soap *soap, struct turb1__PressureHessian *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToturb1__PressureHessian);
	if (soap_out_PointerToturb1__PressureHessian(soap, tag?tag:"turb1:PressureHessian", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__PressureHessian ** SOAP_FMAC4 soap_get_PointerToturb1__PressureHessian(struct soap *soap, struct turb1__PressureHessian **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToturb1__PressureHessian(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToturb1__Pressure(struct soap *soap, struct turb1__Pressure *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_turb1__Pressure))
		soap_serialize_turb1__Pressure(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToturb1__Pressure(struct soap *soap, const char *tag, int id, struct turb1__Pressure *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_turb1__Pressure);
	if (id < 0)
		return soap->error;
	return soap_out_turb1__Pressure(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct turb1__Pressure ** SOAP_FMAC4 soap_in_PointerToturb1__Pressure(struct soap *soap, const char *tag, struct turb1__Pressure **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct turb1__Pressure **)soap_malloc(soap, sizeof(struct turb1__Pressure *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_turb1__Pressure(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct turb1__Pressure **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_turb1__Pressure, sizeof(struct turb1__Pressure), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToturb1__Pressure(struct soap *soap, struct turb1__Pressure *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToturb1__Pressure);
	if (soap_out_PointerToturb1__Pressure(soap, tag?tag:"turb1:Pressure", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__Pressure ** SOAP_FMAC4 soap_get_PointerToturb1__Pressure(struct soap *soap, struct turb1__Pressure **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToturb1__Pressure(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToturb1__Vector3(struct soap *soap, struct turb1__Vector3 *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_turb1__Vector3))
		soap_serialize_turb1__Vector3(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToturb1__Vector3(struct soap *soap, const char *tag, int id, struct turb1__Vector3 *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_turb1__Vector3);
	if (id < 0)
		return soap->error;
	return soap_out_turb1__Vector3(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct turb1__Vector3 ** SOAP_FMAC4 soap_in_PointerToturb1__Vector3(struct soap *soap, const char *tag, struct turb1__Vector3 **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct turb1__Vector3 **)soap_malloc(soap, sizeof(struct turb1__Vector3 *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_turb1__Vector3(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct turb1__Vector3 **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_turb1__Vector3, sizeof(struct turb1__Vector3), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToturb1__Vector3(struct soap *soap, struct turb1__Vector3 *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToturb1__Vector3);
	if (soap_out_PointerToturb1__Vector3(soap, tag?tag:"turb1:Vector3", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__Vector3 ** SOAP_FMAC4 soap_get_PointerToturb1__Vector3(struct soap *soap, struct turb1__Vector3 **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToturb1__Vector3(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToturb1__Point3(struct soap *soap, struct turb1__Point3 *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_turb1__Point3))
		soap_serialize_turb1__Point3(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToturb1__Point3(struct soap *soap, const char *tag, int id, struct turb1__Point3 *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_turb1__Point3);
	if (id < 0)
		return soap->error;
	return soap_out_turb1__Point3(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct turb1__Point3 ** SOAP_FMAC4 soap_in_PointerToturb1__Point3(struct soap *soap, const char *tag, struct turb1__Point3 **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct turb1__Point3 **)soap_malloc(soap, sizeof(struct turb1__Point3 *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_turb1__Point3(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct turb1__Point3 **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_turb1__Point3, sizeof(struct turb1__Point3), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToturb1__Point3(struct soap *soap, struct turb1__Point3 *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToturb1__Point3);
	if (soap_out_PointerToturb1__Point3(soap, tag?tag:"turb1:Point3", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct turb1__Point3 ** SOAP_FMAC4 soap_get_PointerToturb1__Point3(struct soap *soap, struct turb1__Point3 **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToturb1__Point3(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTounsignedByte(struct soap *soap, unsigned char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTounsignedByte(struct soap *soap, const char *tag, int id, unsigned char *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_unsignedByte);
	if (id < 0)
		return soap->error;
	return soap_out_unsignedByte(soap, tag, id, *a, type);
}

SOAP_FMAC3 unsigned char ** SOAP_FMAC4 soap_in_PointerTounsignedByte(struct soap *soap, const char *tag, unsigned char **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (unsigned char **)soap_malloc(soap, sizeof(unsigned char *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_unsignedByte(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (unsigned char **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_unsignedByte, sizeof(unsigned char), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTounsignedByte(struct soap *soap, unsigned char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTounsignedByte);
	if (soap_out_PointerTounsignedByte(soap, tag?tag:"unsignedByte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 unsigned char ** SOAP_FMAC4 soap_get_PointerTounsignedByte(struct soap *soap, unsigned char **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTounsignedByte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#ifdef __cplusplus
}
#endif

#if defined(__BORLANDC__)
#pragma option pop
#pragma option pop
#endif

/* End of soapC.c */
