#!/usr/bin/env python
# -*- coding: utf-8  -*-
################################################################################
#
#  pyLOCSMS -- Python Interface to LOC Store Management Suite
#  Copyright © 2013-2014 Lance Edgar
#
#  This file is part of pyLOCSMS.
#
#  pyLOCSMS is free software: you can redistribute it and/or modify it under
#  the terms of the GNU General Public License as published by the Free
#  Software Foundation, either version 3 of the License, or (at your option)
#  any later version.
#
#  pyLOCSMS is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
#  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
#  details.
#
#  You should have received a copy of the GNU General Public License along with
#  pyLOCSMS.  If not, see <http://www.gnu.org/licenses/>.
#
################################################################################

"""
Database Interface
"""

from sqlalchemy.orm import sessionmaker
from sqlalchemy.event import listen


Session = sessionmaker()


def make_session_readonly(session):
    """
    Make a session effectively read-only.

    This function is typically meant to be called only once during
    initialization.  It will apply a listener to the session so that any
    attempts to flush data to the underlying database will fail.

    .. note::
       This approach is likely a poor one.  For instance it is probably far
       better to use a read-only account when connecting to the database in the
       first place.  Therefore this "convenience" API may eventually go away.

    :param session: Must be either a ``Session`` class, or instance thereof.
    """
    listen(session, u'before_flush', except_on_flush)

    
def except_on_flush(session, flush_context, instances):
    """
    Raise an exception when an attempt is made to flush a session.
    """
    raise Exception(u"This session is read-only, but a flush has been attempted.")
