#!/usr/bin/env python
# -*- coding: utf-8  -*-
################################################################################
#
#  pyLOCSMS -- Python Interface to LOC Store Management Suite
#  Copyright © 2013-2014 Lance Edgar
#
#  This file is part of pyLOCSMS.
#
#  pyLOCSMS is free software: you can redistribute it and/or modify it under
#  the terms of the GNU General Public License as published by the Free
#  Software Foundation, either version 3 of the License, or (at your option)
#  any later version.
#
#  pyLOCSMS is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
#  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
#  details.
#
#  You should have received a copy of the GNU General Public License along with
#  pyLOCSMS.  If not, see <http://www.gnu.org/licenses/>.
#
################################################################################

import sys
import os.path
from setuptools import setup, find_packages


here = os.path.abspath(os.path.dirname(__file__))
execfile(os.path.join(here, u'locsms', u'_version.py'))
README = open(os.path.join(here, u'README.txt')).read()


requires = [
    #
    # Version numbers within comments below have specific meanings.
    # Basically the 'low' value is a "soft low," and 'high' a "soft high."
    # In other words:
    #
    # If either a 'low' or 'high' value exists, the primary point to be
    # made about the value is that it represents the most current (stable)
    # version available for the package (assuming typical public access
    # methods) whenever this project was started and/or documented.
    # Therefore:
    #
    # If a 'low' version is present, you should know that attempts to use
    # versions of the package significantly older than the 'low' version
    # may not yield happy results.  (A "hard" high limit may or may not be
    # indicated by a true version requirement.)
    #
    # Similarly, if a 'high' version is present, and especially if this
    # project has laid dormant for a while, you may need to refactor a bit
    # when attempting to support a more recent version of the package.  (A
    # "hard" low limit should be indicated by a true version requirement
    # when a 'high' version is present.)
    #
    # In any case, developers and other users are encouraged to play
    # outside the lines with regard to these soft limits.  If bugs are
    # encountered then they should be filed as such.
    #
    # package                           # low                   high

    u'pyodbc',                          # 3.0.7
    u'SQLAlchemy',                      # 0.8.2
    ]


# Python < 2.7 has a standard library in need of supplementation.
if sys.version_info < (2, 7):
    requires += [
        #
        # package                       # low                   high

        u'argparse',                    # 1.2.1
        ]


extras = {

    u'docs': [
        #
        # package                       # low                   high

        u'Sphinx',                      # 1.2
        u'sphinxcontrib-programoutput', # 0.8
        ],

    u'tests': [
        #
        # package                       # low                   high

        u'nose',                        # 1.3.0
        u'coverage',                    # 3.6
        u'mock',                        # 1.0.1
        u'fixture',                     # 1.5
        ],
    }


setup(
    name = u"pyLOCSMS",
    version = __version__,
    author = u"Lance Edgar",
    author_email = u"lance@edbob.org",
    url = u"http://rattailproject.org/",
    license = u"GNU GPL v3",
    description = u"Python Interface to LOC Store Management Suite",
    long_description = README,

    classifiers = [
        u'Development Status :: 3 - Alpha',
        u'Intended Audience :: Developers',
        u'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)',
        u'Natural Language :: English',
        u'Operating System :: OS Independent',
        u'Programming Language :: Python',
        u'Programming Language :: Python :: 2.6',
        u'Programming Language :: Python :: 2.7',
        u'Topic :: Software Development :: Libraries :: Python Modules',
        ],

    install_requires = requires,
    extras_require = extras,
    tests_require = [u'pyLOCSMS[tests]'],
    test_suite = u'nose.collector',

    packages = find_packages(exclude=[u'tests.*', u'tests']),

    entry_points = {

        u'console_scripts': [
            u'locsms-load-backup = locsms.db.load:generate_load_backup',
            u'locsms-load-restore = locsms.db.load:restore_load_backup',
            u'locsms-generate-model = locsms.db.util:generate_model_command',
            ],
        },
    )
