# -*- coding: utf-8 -*-
"""
Created on Tue Sep  9 22:51:41 2014

@author: lucadelu
"""

import subprocess
try:
    import osgeo.gdal as gdal
except ImportError:
    try:
        import gdal
    except ImportError:
        raise 'Python GDAL library not found, please install python-gdal'
import os

lstcolortable = "\
0 255 255 255\n\
9657.5 0 0 40\n\
11657.5 91 10 168\n\
12407.5 91 50 128\n\
12657.5 50 0 150\n\
12907.5 4 25 130\n\
13157.5 8 54 106\n\
13257.5 4 20 150\n\
13407.5 0 50 255\n\
13557.5 8 10 118\n\
13654.42755 8 113 155\n\
13658.19275 8 118 157\n\
13662.029699999999 8 123 158\n\
13665.93835 8 128 159\n\
13669.918750000001 8 133 159\n\
13673.97085 8 136 160\n\
13678.094649999999 8 140 162\n\
13682.290199999999 8 145 163\n\
13686.55745 8 150 165\n\
13690.8964 8 156 166\n\
13695.3071 8 161 167\n\
13699.789500000001 8 166 169\n\
13704.343650000001 8 172 172\n\
13708.969450000001 8 177 177\n\
13713.66705 8 182 182\n\
13718.436299999999 8 187 187\n\
13723.2773 8 192 192\n\
13728.190049999999 8 197 197\n\
13733.17445 8 200 200\n\
13738.230600000001 8 204 204\n\
13743.3585 8 209 209\n\
13748.5581 8 213 213\n\
13753.829400000001 8 216 216\n\
13759.172399999999 8 219 219\n\
13764.587149999999 8 222 222\n\
13770.07365 8 225 225\n\
13775.631799999999 8 227 227\n\
13781.261699999999 8 230 230\n\
13786.96335 8 233 233\n\
13792.736699999999 8 235 235\n\
13798.581749999999 8 237 236\n\
13804.4985 8 238 234\n\
13810.486999999999 8 238 229\n\
13816.547200000001 8 238 223\n\
13822.67915 8 237 216\n\
13828.882799999999 8 235 209\n\
13835.158149999999 8 234 202\n\
13841.50525 8 232 192\n\
13847.92405 8 231 178\n\
13854.4146 8 230 162\n\
13860.976849999999 8 229 147\n\
13867.6108 8 227 133\n\
13874.31645 8 226 123\n\
13881.093849999999 8 224 116\n\
13887.942999999999 8 221 114\n\
13894.863799999999 8 219 114\n\
13901.856400000001 8 216 115\n\
13908.92065 8 213 117\n\
13916.05665 8 209 118\n\
13923.264349999999 8 204 118\n\
13930.543799999999 8 199 117\n\
13937.894899999999 8 193 115\n\
13945.317800000001 8 188 112\n\
13952.81235 8 184 107\n\
13960.378650000001 8 181 99\n\
13968.0167 8 178 91\n\
13975.72645 8 175 84\n\
13983.507900000001 8 172 81\n\
13991.36105 8 169 80\n\
13999.28595 8 164 80\n\
14007.28255 8 159 80\n\
14015.350899999999 8 153 80\n\
14023.490949999999 8 148 79\n\
14031.7027 8 143 79\n\
14039.986199999999 8 138 79\n\
14048.341399999999 8 134 78\n\
14056.76835 8 132 75\n\
14065.267 8 134 70\n\
14073.83735 8 137 63\n\
14082.4794 8 140 56\n\
14091.1932 8 140 48\n\
14099.97875 8 139 37\n\
14108.835950000001 9 138 24\n\
14117.7649 14 139 14\n\
14126.765600000001 24 141 9\n\
14135.838 37 146 8\n\
14144.982099999999 47 151 8\n\
14154.197899999999 52 156 8\n\
14163.48545 55 161 8\n\
14172.84475 57 166 8\n\
14182.2757 60 172 8\n\
14191.778399999999 65 177 8\n\
14201.352849999999 70 182 8\n\
14210.998949999999 75 187 8\n\
14220.716850000001 80 192 8\n\
14230.5064 85 196 8\n\
14240.367700000001 89 199 8\n\
14250.3007 95 201 8\n\
14260.30545 103 204 8\n\
14270.3819 110 206 8\n\
14280.530049999999 118 209 8\n\
14290.749949999999 126 211 8\n\
14301.04155 134 214 8\n\
14311.404850000001 142 217 8\n\
14321.839900000001 151 219 8\n\
14332.346649999999 160 222 8\n\
14342.925149999999 169 225 8\n\
14353.575349999999 179 227 8\n\
14364.29725 187 229 8\n\
14375.090899999999 195 230 8\n\
14385.956249999999 205 230 8\n\
14396.8933 215 230 8\n\
14407.902099999999 223 229 8\n\
14418.982599999999 226 227 8\n\
14430.13485 225 224 8\n\
14441.3588 224 221 8\n\
14452.65445 224 217 8\n\
14464.021849999999 224 211 8\n\
14475.460950000001 224 205 8\n\
14486.971750000001 224 198 8\n\
14498.5543 224 191 8\n\
14510.208549999999 224 185 8\n\
14521.93455 224 180 8\n\
14533.7322 224 174 8\n\
14545.601650000001 224 166 8\n\
14557.542750000001 224 159 8\n\
14569.5556 224 151 8\n\
14581.6402 224 143 8\n\
14593.79645 224 135 8\n\
14606.024450000001 224 127 8\n\
14618.324199999999 224 119 8\n\
14630.69565 224 111 8\n\
14643.138800000001 224 103 8\n\
14655.65365 224 95 8\n\
14668.240250000001 224 89 8\n\
14680.8986 224 84 8\n\
14693.6286 224 78 8\n\
14706.430350000001 223 70 8\n\
14719.30385 223 63 8\n\
14732.24905 223 55 8\n\
14745.265950000001 222 46 8\n\
14758.35455 221 37 8\n\
14771.5149 219 28 8\n\
14784.746950000001 216 19 8\n\
14798.05075 213 12 8\n\
14811.42625 209 9 8\n\
14824.873449999999 204 8 8\n\
14838.392400000001 200 8 8\n\
14851.983050000001 196 8 8\n\
14865.64545 190 8 8\n\
14879.37955 182 8 8\n\
14893.18535 175 8 8\n\
14907.06285 167 8 8\n\
14921.0121 159 8 8\n\
14935.033100000001 151 8 8\n\
14949.125749999999 143 8 8\n\
14963.290199999999 135 8 8\n\
14977.5263 127 8 8\n\
14991.834150000001 120 8 8\n\
15006.2137 115 8 8\n\
15020.665000000001 110 8 8\n\
15035.18795 104 8 8\n\
15049.7827 108 13 13\n\
15064.4491 112 19 19\n\
15079.187250000001 114 22 22\n\
15093.997149999999 115 26 26\n\
15108.87875 118 30 30\n\
15123.832050000001 119 34 33\n\
15138.857050000001 121 38 38\n\
15153.953799999999 123 41 41\n\
15169.12225 125 45 45\n\
15184.362450000001 127 49 49\n\
15199.674349999999 128 52 53\n\
15215.05795 130 56 56\n\
15230.513300000001 132 60 60\n\
15246.040349999999 134 64 63\n\
15261.639150000001 136 67 67\n\
15277.309649999999 138 71 70\n\
15293.05185 140 75 74\n\
15308.865750000001 142 79 78\n\
15324.751399999999 143 82 82\n\
15340.7088 145 85 85\n\
15356.73785 147 89 90\n\
15372.83865 149 93 93\n\
15389.011200000001 150 97 97\n\
15405.255450000001 152 100 100\n\
15421.571400000001 154 104 104\n\
15437.959049999999 156 107 108\n\
15454.418449999999 158 112 111\n\
15470.9496 160 115 115\n\
15487.5524 162 119 119\n\
15504.22695 164 123 123\n\
15520.973249999999 165 126 126\n\
15537.7912 168 130 130\n\
15554.68095 169 134 134\n\
15571.64235 170 138 137\n\
15588.675499999999 173 141 141\n\
15605.780350000001 175 145 145\n\
15622.95695 176 149 149\n\
15640.205250000001 178 153 153\n\
15657.525250000001 181 156 156\n\
15674.916999999999 182 159 159\n\
15692.380450000001 183 163 163\n\
15709.9156 185 167 167\n\
15727.522499999999 188 170 171\n\
15745.2011 190 174 174\n\
15762.95145 191 178 178\n\
15780.773499999999 193 182 182\n\
15798.66725 195 185 185\n\
15816.632750000001 197 189 189\n\
15834.66995 199 192 193\n\
15852.778850000001 200 197 197\n\
15870.959500000001 202 200 201\n\
"
#
#lstcolortable = "\
#0 255 255 255\n\
#9657 0 0 40\n\
#15870 202 200 201\n\
#"


def hdf2png(hdffile, layer=1):
    src_ds = gdal.Open(hdffile)
    layers = src_ds.GetSubDatasets()
    output = hdffile.split('.')[:-1]
    output.append('png')
    outname = '.'.join(output)
    pid = os.getpid()
    colortable = open('colortable_{p}'.format(p=pid), 'w')
    colortable.write(lstcolortable)
    colortable.close()
    subprocess.call(['gdaldem', 'color-relief', '-of', 'PNG', layers[layer][0],
                     colortable.name, outname])
    #os.remove(colortable.name)
    return outname


def tif2png(tiffile):
    output = tiffile.split('.')[:-1]
    output.append('png')
    pid = os.getpid()
    colortable = open('colortable_{p}'.format(p=pid), 'w')
    colortable.write(lstcolortable)
    colortable.close()
    subprocess.call(['gdaldem', 'color-relief', '-of', 'PNG', tiffile,
                     colortable.name, '.'.join(output)])
    os.remove(colortable.name)
    return '.'.join(output)
