#!/usr/bin/env python
# -*- coding: utf-8  -*-
################################################################################
#
#  pyScanMaster -- Python Interface to ScanMaster POS
#  Copyright © 2013 Sacramento Natural Foods Co-op, Inc
#
#  This file is part of pyScanMaster.
#
#  pyScanMaster is free software: you can redistribute it and/or modify it
#  under the terms of the GNU General Public License as published by the Free
#  Software Foundation, either version 3 of the License, or (at your option)
#  any later version.
#
#  pyScanMaster is distributed in the hope that it will be useful, but WITHOUT
#  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
#  more details.
#
#  You should have received a copy of the GNU General Public License along with
#  pyScanMaster.  If not, see <http://www.gnu.org/licenses/>.
#
################################################################################

"""
Enumerations
"""


ACCOUNT_ACTIVITY_CHARGE         = 'C'
ACCOUNT_ACTIVITY_PAYMENT        = 'P'

ACCOUNT_ACTIVITIES = {
    ACCOUNT_ACTIVITY_CHARGE     : "Charge",
    ACCOUNT_ACTIVITY_PAYMENT    : "Payment",
    }


EJ_TRANSACTION_TYPE_SALE                = 11
EJ_TRANSACTION_TYPE_RETURN              = 12
EJ_TRANSACTION_TYPE_MEDIA_CASHING       = 13
EJ_TRANSACTION_TYPE_PAID_OUT            = 15
EJ_TRANSACTION_TYPE_SUSPEND             = 18
EJ_TRANSACTION_TYPE_CANCEL              = 19
EJ_TRANSACTION_TYPE_PICKUP              = 31
EJ_TRANSACTION_TYPE_MEDIA_SWAP          = 33
EJ_TRANSACTION_TYPE_NO_SALE             = 34
EJ_TRANSACTION_TYPE_SIGN_ON             = 41
EJ_TRANSACTION_TYPE_SIGN_OFF            = 42

EJ_TRANSACTION_TYPES = {
    EJ_TRANSACTION_TYPE_SALE            : "Sale",
    EJ_TRANSACTION_TYPE_RETURN          : "Refund/Return",
    EJ_TRANSACTION_TYPE_MEDIA_CASHING   : "Media Cashing",
    EJ_TRANSACTION_TYPE_PAID_OUT        : "Paid Out",
    EJ_TRANSACTION_TYPE_SUSPEND         : "Suspend",
    EJ_TRANSACTION_TYPE_CANCEL          : "Cancel",
    EJ_TRANSACTION_TYPE_PICKUP          : "Pickup",
    EJ_TRANSACTION_TYPE_MEDIA_SWAP      : "Media Swap",
    EJ_TRANSACTION_TYPE_NO_SALE         : "No Sale",
    EJ_TRANSACTION_TYPE_SIGN_ON         : "Sign On",
    EJ_TRANSACTION_TYPE_SIGN_OFF        : "Sign Off",
    }
