# Highlight.js

Highlight.js нужен для подсветки синтаксиса в примерах кода в блогах,
форумах и вообще на любых веб-страницах. Пользоваться им очень просто,
потому что работает он автоматически: сам находит блоки кода, сам
определяет язык, сам подсвечивает.

Автоопределением языка можно управлять, когда оно не справляется само (см.
дальше "Эвристика").


## Подключение и использование

В загруженном архиве лежит файл "highlight.pack.js" -- полная сжатая версия
библиотеки для работы. Все несжатые исходные файлы также есть в пакете, поэтому
не стесняйтесь в них смотреть!

Скрипт подключается одним файлом и одним вызовом инициализирующей
функции:

    <script type="text/javascript" src="highlight.pack.js"></script>
    <script type="text/javascript">
      hljs.initHighlightingOnLoad();
    </script>

Также вы можете заменить символы TAB ('\x09'), используемые для отступов, на
фиксированное количество пробелов или на отдельный `<span>`, чтобы задать ему
какой-нибудь специальный стиль:

    <script type="text/javascript">
      hljs.tabReplace = '    '; // 4 spaces
      // ... or
      hljs.tabReplace = '<span class="indent">\t</span>';

      hljs.initHighlightingOnLoad();
    </script>

Дальше скрипт ищет на странице конструкции `<pre><code>...</code></pre>`,
которые традиционно используются для написания кода, и код в них
размечается на куски, помеченные разными значениями классов.


### Инициализация вручную

Если вы используете другие теги для блоков кода, вы можете инициализировать их
явно с помощью функции `highlightBlock(code, tabReplace)`. Она принимает
DOM-элемент с текстом расцвечиваемого кода и опционально - строчку для замены
символов TAB.

Например с использованием jQuery код инициализации может выглядеть так:

    $(document).ready(function() {
      $('pre code').each(function(i, e) {hljs.highlightBlock(e, '    ')});
    });

Если ваш блок кода использует `<br>` вместо переводов строки (т.е. если это не
`<pre>`), передайте `true` третьим параметром в `highlightBlock`:

    $('div.code').each(function(i, e) {hljs.highlightBlock(e, null, true)});


### Выбор стилей

Размеченным классами элементам кода можно задать желаемые стили например так:

    .comment {
      color: gray;
    }

    .keyword {
      font-weight: bold;
    }

    .python .string {
      color: blue;
    }

    .html .atribute .value {
      color: green;
    }

В комплекте с highlight.js идут несколько стилевых тем в директории styles,
которые можно использовать напрямую или как основу для собственных экспериментов.

Полный список классов приведён в файле [crossref.txt][cr].

[cr]: http://github.com/isagalaev/highlight.js/blob/master/classref.txt


## Экспорт

В файле export.html находится небольшая программка, которая показывает и дает
скопировать непосредственно HTML-код подсветки для любого заданного фрагмента кода.
Это может понадобится например на сайте, на котором нельзя подключить сам скрипт
highlight.js.


## Эвристика

Определение языка, на котором написан фрагмент, делается с помощью
довольно простой эвристики: программа пытается расцветить фрагмент всеми
языками подряд, и для каждого языка считает количество подошедших
синтаксически конструкций и ключевых слов. Для какого языка нашлось больше,
тот и выбирается.

Это означает, что в коротких фрагментах высока вероятность ошибки, что
периодически и случается. Чтобы указать язык фрагмента явно, надо написать
его название в виде класса к элементу `<code>`:

    <pre><code class="html">...</code></pre>

Можно использовать рекомендованные в HTML5 названия классов:
"language-html", "language-php". Также можно назначать классы на элемент
`<pre>`.

Чтобы запретить расцветку фрагмента вообще, используется класс "no-highlight":

    <pre><code class="no-highlight">...</code></pre>


## Координаты

- Версия: 6.0
- URL:    http://softwaremaniacs.org/soft/highlight/
- Автор:  Иван Сагалаев (<Maniac@SoftwareManiacs.Org>)

Лицензионное соглашение читайте в файле LICENSE.
Список соавторов читайте в файле AUTHORS.ru.txt
