/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.smac.executors;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrunner.AlgorithmRunner;
import ca.ubc.cs.beta.aclib.algorithmrunner.AutomaticConfiguratorFactory;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;

public class AlgorithmRunConfiguratorExecutor {
    public static Scanner getScannerForFile(String file) throws FileNotFoundException {
        File f = new File(file);
        Scanner pstream = new Scanner(new FileInputStream(f));
        return pstream;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: " + AlgorithmRunConfiguratorExecutor.class.getCanonicalName() + " <filename> <outfile>.\n");
            System.out.println("That file: <algo>\n<exec_path>\n<param_filename>\n<oncluster>\n");
            System.out.println("Every line after that: <instance_filename> <seed> <cutoff_time> <param_string>");
            System.out.println("One result per line is written into the outfile, in the same order as in <filename>.");
            System.exit(-1);
        }
        try {
            Scanner infile = AlgorithmRunConfiguratorExecutor.getScannerForFile(args[0]);
            String algo = infile.nextLine();
            String exec_path = infile.nextLine();
            String param_filename = infile.nextLine();
            String oncluster = infile.nextLine();
            File f = new File(param_filename);
            if (!f.exists()) {
                throw new FileNotFoundException("Cannot find Parameter File");
            }
            ParamConfigurationSpace paramFile = new ParamConfigurationSpace(f);
            AlgorithmExecutionConfig execConfig = new AlgorithmExecutionConfig(algo, exec_path, paramFile, false, false, 500.0);
            f = new File(args[1]);
            if (!f.createNewFile()) {
                // empty if block
            }
            System.out.println("[WARN]: File Format not robust to spaces");
            LinkedList<RunConfig> runConfigs = new LinkedList<RunConfig>();
            while (infile.hasNextLine()) {
                String line = infile.nextLine();
                String[] lineArgs = line.split("\\s+", 4);
                if (lineArgs.length != 4) {
                    throw new IllegalArgumentException("Line " + line + " should have been of the form <instance_filename> <seed> <cutoff_time> <param_string>");
                }
                ParamConfiguration param = paramFile.getConfigurationFromString(lineArgs[3], ParamConfiguration.StringFormat.STATEFILE_SYNTAX);
                RunConfig runConfig = new RunConfig(new ProblemInstanceSeedPair(new ProblemInstance(lineArgs[0]), Long.valueOf(lineArgs[1]).longValue()), Double.valueOf(lineArgs[2]).doubleValue(), param);
                runConfigs.add(runConfig);
            }
            System.out.println("[INFO]: Found " + runConfigs.size() + " runs");
            PrintWriter resultFileOut = new PrintWriter(new FileOutputStream(f));
            boolean concurrent = true;
            AlgorithmRunner runner = concurrent ? AutomaticConfiguratorFactory.getConcurrentAlgorithmRunner((AlgorithmExecutionConfig)execConfig, runConfigs) : AutomaticConfiguratorFactory.getSingleThreadedAlgorithmRunner((AlgorithmExecutionConfig)execConfig, runConfigs);
            List runResults = runner.run();
            for (AlgorithmRun run : runResults) {
                resultFileOut.write(run.getResultLine() + "\n");
            }
            resultFileOut.close();
            return;
        }
        catch (NumberFormatException e) {
            System.err.println("[ERROR]: Input file is malformed (invalid numerical value) : " + e.getMessage());
        }
        catch (NoSuchElementException e) {
            System.err.println("[ERROR]: Input file is malformed (expected atleast one more line)");
        }
        catch (FileNotFoundException e) {
            System.err.println("[ERROR]: Can't find input file: " + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(-1);
    }
}

