/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.smac.executors;

import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.configspace.ParamFileHelper;
import ca.ubc.cs.beta.aclib.exceptions.FeatureNotFoundException;
import ca.ubc.cs.beta.aclib.exceptions.StateSerializationException;
import ca.ubc.cs.beta.aclib.exceptions.TrajectoryDivergenceException;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.misc.logback.MarkerFilter;
import ca.ubc.cs.beta.aclib.misc.logging.LoggingMarker;
import ca.ubc.cs.beta.aclib.misc.random.SeedableRandomSingleton;
import ca.ubc.cs.beta.aclib.misc.version.VersionTracker;
import ca.ubc.cs.beta.aclib.model.builder.HashCodeVerifyingModelBuilder;
import ca.ubc.cs.beta.aclib.objectives.OverallObjective;
import ca.ubc.cs.beta.aclib.objectives.RunObjective;
import ca.ubc.cs.beta.aclib.options.AlgorithmExecutionOptions;
import ca.ubc.cs.beta.aclib.options.ConfigToLaTeX;
import ca.ubc.cs.beta.aclib.options.SMACOptions;
import ca.ubc.cs.beta.aclib.options.ScenarioOptions;
import ca.ubc.cs.beta.aclib.probleminstance.InstanceListWithSeeds;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceHelper;
import ca.ubc.cs.beta.aclib.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.state.StateDeserializer;
import ca.ubc.cs.beta.aclib.state.StateFactory;
import ca.ubc.cs.beta.aclib.state.legacy.LegacyStateFactory;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorBuilder;
import ca.ubc.cs.beta.aclib.trajectoryfile.TrajectoryFileEntry;
import ca.ubc.cs.beta.smac.AbstractAlgorithmFramework;
import ca.ubc.cs.beta.smac.SequentialModelBasedAlgorithmConfiguration;
import ca.ubc.cs.beta.smac.state.nullFactory.NullStateFactory;
import ca.ubc.cs.beta.smac.validation.Validator;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class AutomaticConfigurator {
    private static List<ProblemInstance> instances;
    private static List<ProblemInstance> testInstances;
    private static Logger logger;
    private static Marker exception;
    private static Marker stackTrace;
    private static InstanceSeedGenerator instanceSeedGen;
    private static InstanceSeedGenerator testInstanceSeedGen;
    private static String logLocation;
    private static String instanceFileAbsolutePath;
    private static String instanceFeatureFileAbsolutePath;
    private static Pattern modelHashCodePattern;

    public static void main(String[] args) {
        int returnValue = AutomaticConfigurator.oldMain(args);
        logger.info("Returning with value: {}", (Object)returnValue);
        System.exit(returnValue);
    }

    public static int oldMain(String[] args) {
        try {
            AbstractAlgorithmFramework smac;
            boolean verifySATCompatible;
            NullStateFactory sf;
            NullStateFactory restoreSF;
            SMACOptions options = AutomaticConfigurator.parseCLIOptions(args);
            logger.info("Automatic Configurator Started");
            SeedableRandomSingleton.setSeed((long)(options.numRun + options.seedOffset));
            Random rand = SeedableRandomSingleton.getRandom();
            switch (options.statedeSerializer) {
                case NULL: {
                    restoreSF = new NullStateFactory();
                    break;
                }
                case LEGACY: {
                    restoreSF = new LegacyStateFactory(options.scenarioConfig.outputDirectory + File.separator + options.runGroupName + File.separator + "state-run" + options.numRun + File.separator, options.restoreStateFrom);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("State Serializer specified is not supported");
                }
            }
            String paramFile = options.scenarioConfig.paramFileDelegate.paramFile;
            logger.info("Parsing Parameter Space File", (Object)paramFile);
            ParamConfigurationSpace configSpace = null;
            String[] possiblePaths = new String[]{paramFile, options.experimentDir + File.separator + paramFile, options.scenarioConfig.algoExecOptions.algoExecDir + File.separator + paramFile};
            String lastParamFilePath = null;
            for (String path : possiblePaths) {
                try {
                    logger.debug("Trying param file in path {} ", (Object)path);
                    lastParamFilePath = path;
                    configSpace = ParamFileHelper.getParamFileParser((String)path, (long)(options.numRun + options.seedOffset + 1000000L));
                    break;
                }
                catch (IllegalStateException e) {
                    if (e.getCause() instanceof FileNotFoundException) continue;
                    logger.warn("Error occured while trying to parse is {}", (Object)e.getMessage());
                }
            }
            if (configSpace == null) {
                throw new ParameterException("Could not find a valid parameter file, please check if there was a previous error");
            }
            String algoExecDir = options.scenarioConfig.algoExecOptions.algoExecDir;
            File f2 = new File(algoExecDir);
            if (!f2.isAbsolute()) {
                f2 = new File(options.experimentDir + File.separator + algoExecDir);
            }
            AlgorithmExecutionConfig execConfig = new AlgorithmExecutionConfig(options.scenarioConfig.algoExecOptions.algoExec, f2.getAbsolutePath(), configSpace, false, options.scenarioConfig.algoExecOptions.deterministic, options.scenarioConfig.cutoffTime);
            switch (options.stateSerializer) {
                case NULL: {
                    sf = new NullStateFactory();
                    break;
                }
                case LEGACY: {
                    String savePath = options.scenarioConfig.outputDirectory + File.separator + options.runGroupName + File.separator + "state-run" + options.numRun + File.separator;
                    File saveLocation = new File(savePath);
                    if (!saveLocation.isAbsolute()) {
                        savePath = options.experimentDir + File.separator + savePath;
                    }
                    sf = new LegacyStateFactory(savePath, options.restoreStateFrom);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("State Serializer specified is not supported");
                }
            }
            if (options.scenarioConfig.algoExecOptions.verifySAT == null) {
                boolean verifySATCompatible2 = ProblemInstanceHelper.isVerifySATCompatible(instances);
                if (verifySATCompatible2) {
                    logger.debug("Instance Specific Information is compatible with Verifying SAT, enabling option");
                    options.scenarioConfig.algoExecOptions.verifySAT = true;
                } else {
                    logger.debug("Instance Specific Information is NOT compatible with Verifying SAT, disabling option");
                    options.scenarioConfig.algoExecOptions.verifySAT = false;
                }
            } else if (options.scenarioConfig.algoExecOptions.verifySAT.booleanValue() && !(verifySATCompatible = ProblemInstanceHelper.isVerifySATCompatible(instances))) {
                logger.warn("Verify SAT set to true, but some instances have instance specific information that isn't in {SAT, SATISFIABLE, UNKNOWN, UNSAT, UNSATISFIABLE}");
            }
            ParamConfiguration initialIncumbent = configSpace.getConfigurationFromString(options.initialIncumbent, ParamConfiguration.StringFormat.NODB_SYNTAX);
            if (!initialIncumbent.equals((Object)configSpace.getDefaultConfiguration())) {
                logger.info("Initial Incumbent set to \"{}\" ", (Object)initialIncumbent.getFormattedParamString(ParamConfiguration.StringFormat.NODB_SYNTAX));
            } else {
                logger.info("Initial Incumbent is the default \"{}\" ", (Object)initialIncumbent.getFormattedParamString(ParamConfiguration.StringFormat.NODB_SYNTAX));
            }
            TargetAlgorithmEvaluator algoEval = TargetAlgorithmEvaluatorBuilder.getTargetAlgorithmEvaluator((ScenarioOptions)options.scenarioConfig, (AlgorithmExecutionConfig)execConfig);
            if (options.modelHashCodeFile != null) {
                logger.info("Algorithm Execution will verify model Hash Codes");
                AutomaticConfigurator.parseModelHashCodes(options.modelHashCodeFile);
            }
            switch (options.execMode) {
                case ROAR: {
                    smac = new AbstractAlgorithmFramework(options, instances, testInstances, algoEval, sf, configSpace, instanceSeedGen, rand, initialIncumbent);
                    break;
                }
                case SMAC: {
                    smac = new SequentialModelBasedAlgorithmConfiguration(options, instances, testInstances, algoEval, options.expFunc.getFunction(), sf, configSpace, instanceSeedGen, rand, initialIncumbent);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Execution Mode Specified is not supported");
                }
            }
            if (options.saveContextWithState) {
                sf.copyFileToStateDir("param-file.txt", new File(lastParamFilePath));
                if (instanceFileAbsolutePath != null) {
                    sf.copyFileToStateDir("instances.txt", new File(instanceFileAbsolutePath));
                }
                if (instanceFeatureFileAbsolutePath != null) {
                    sf.copyFileToStateDir("instance-features.txt", new File(instanceFeatureFileAbsolutePath));
                }
                if (options.scenarioConfig.scenarioFile != null && options.scenarioConfig.scenarioFile.exists()) {
                    sf.copyFileToStateDir("scenario.txt", options.scenarioConfig.scenarioFile);
                }
            }
            if (options.restoreIteration != null) {
                AutomaticConfigurator.restoreState(options, restoreSF, smac, configSpace, options.scenarioConfig.intraInstanceObj, options.scenarioConfig.interInstanceObj, options.scenarioConfig.runObj, instances, execConfig);
            }
            smac.run();
            if (options.doValidation) {
                if (options.validationOptions.maxTimestamp == -1.0) {
                    options.validationOptions.maxTimestamp = options.scenarioConfig.tunerTimeout;
                }
                TargetAlgorithmEvaluator validatingTae = TargetAlgorithmEvaluatorBuilder.getTargetAlgorithmEvaluator((ScenarioOptions)options.scenarioConfig, (AlgorithmExecutionConfig)execConfig, (boolean)false);
                String outputDir = options.scenarioConfig.outputDirectory + File.separator + options.runGroupName + File.separator;
                List<TrajectoryFileEntry> tfes = smac.getTrajectoryFileEntries();
                SortedMap<TrajectoryFileEntry, Double> performance = new Validator().validate(testInstances, options.validationOptions, options.scenarioConfig.cutoffTime, testInstanceSeedGen, validatingTae, outputDir, options.scenarioConfig.runObj, options.scenarioConfig.intraInstanceObj, options.scenarioConfig.interInstanceObj, tfes, options.numRun);
                smac.logIncumbentPerformance(performance);
                smac.afterValidationStatistics();
                smac.logSMACResult(performance);
            }
            logger.info("SMAC Completed Successfully. Log: " + logLocation);
            return 0;
        }
        catch (Throwable t) {
            System.out.flush();
            System.err.flush();
            System.err.println("Error occured running SMAC ( " + t.getClass().getSimpleName() + " : " + t.getMessage() + ")\nError Log: " + logLocation);
            System.err.flush();
            if (logger != null) {
                logger.error(exception, "Message: {}", (Object)t.getMessage());
                if (!(t instanceof ParameterException)) {
                    logger.info("Maybe try running in DEBUG mode if you are missing information");
                    logger.error(exception, "Exception:{}", (Object)t.getClass().getCanonicalName());
                    StringWriter sWriter = new StringWriter();
                    PrintWriter writer = new PrintWriter(sWriter);
                    t.printStackTrace(writer);
                    logger.error(stackTrace, "StackTrace:{}", (Object)sWriter.toString());
                }
                logger.info("Exiting SMAC with failure. Log: " + logLocation);
                logger.info("Please see above for the available options. Further information is available in the following documents:");
                logger.info("- The FAQ (doc/faq.pdf) contains commonly asked questions regarding troubleshooting, and usage.");
                logger.info("- The Quickstart Guide (doc/quickstart.pdf) gives a simple example for getting up and running.");
                logger.info("- The Manual (doc/manual.pdf) contains detailed information on file format semantics.");
                t = t.getCause();
            } else if (t instanceof ParameterException) {
                System.err.println(t.getMessage());
            } else {
                t.printStackTrace();
            }
            if (t instanceof ParameterException) {
                return 1;
            }
            if (t instanceof StateSerializationException) {
                return 3;
            }
            if (t instanceof TrajectoryDivergenceException) {
                return 2;
            }
            return 255;
        }
    }

    private static void restoreState(SMACOptions options, StateFactory sf, AbstractAlgorithmFramework smac, ParamConfigurationSpace configSpace, OverallObjective intraInstanceObjective, OverallObjective interInstanceObjective, RunObjective runObj, List<ProblemInstance> instances, AlgorithmExecutionConfig execConfig) {
        if (options.restoreIteration < 0) {
            throw new ParameterException("Iteration must be a non-negative integer");
        }
        StateDeserializer sd = sf.getStateDeserializer("it", options.restoreIteration.intValue(), configSpace, intraInstanceObjective, interInstanceObjective, runObj, instances, execConfig);
        smac.restoreState(sd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SMACOptions parseCLIOptions(String[] args) throws ParameterException, IOException {
        SMACOptions config = new SMACOptions();
        JCommander com = new JCommander((Object)config, true, true);
        com.setProgramName("smac");
        try {
            try {
                AutomaticConfigurator.checkArgsForUsageScreenValues(args, config);
                com.parse(args);
                File outputDir = new File(config.scenarioConfig.outputDirectory);
                if (!outputDir.exists()) {
                    outputDir.mkdir();
                }
            }
            finally {
                System.setProperty("OUTPUTDIR", config.scenarioConfig.outputDirectory);
                System.setProperty("RUNGROUPDIR", config.runGroupName);
                System.setProperty("NUMRUN", String.valueOf(config.numRun));
                System.setProperty("STDOUT-LEVEL", config.consoleLogLevel.name());
                System.setProperty("ROOT-LEVEL", config.logLevel.name());
                logLocation = config.scenarioConfig.outputDirectory + File.separator + config.runGroupName + File.separator + "log-run" + config.numRun + ".txt";
                System.out.println("*****************************\nLogging to: " + logLocation + "\n*****************************");
                logger = LoggerFactory.getLogger(AutomaticConfigurator.class);
                exception = MarkerFactory.getMarker((String)"EXCEPTION");
                stackTrace = MarkerFactory.getMarker((String)"STACKTRACE");
                VersionTracker.setClassLoader((ClassLoader)TargetAlgorithmEvaluatorBuilder.getClassLoader((AlgorithmExecutionOptions)config.scenarioConfig.algoExecOptions));
                VersionTracker.logVersions();
            }
            logger.trace("Command Line Options Parsed");
            if (config.adaptiveCapping == null) {
                switch (config.scenarioConfig.runObj) {
                    case RUNTIME: {
                        config.adaptiveCapping = true;
                        break;
                    }
                    case QUALITY: {
                        config.adaptiveCapping = false;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Not sure what to default too");
                    }
                }
            }
            AutomaticConfigurator.validateObjectiveCombinations(config.scenarioConfig, config.adaptiveCapping);
            AutomaticConfigurator.logCallString(args);
            if (config.scenarioConfig.algoExecOptions.logAllCallStrings) {
                MarkerFilter.accept((LoggingMarker)LoggingMarker.COMMAND_LINE_CALL);
            } else {
                MarkerFilter.deny((LoggingMarker)LoggingMarker.COMMAND_LINE_CALL);
            }
            if (config.scenarioConfig.algoExecOptions.logAllProcessOutput) {
                MarkerFilter.accept((LoggingMarker)LoggingMarker.FULL_PROCESS_OUTPUT);
            } else {
                MarkerFilter.deny((LoggingMarker)LoggingMarker.FULL_PROCESS_OUTPUT);
            }
            if (config.logLevel.lessVerbose(config.consoleLogLevel)) {
                logger.warn("The console has been set to be more verbose than the log. This is generally an error, except if you have modified the conf.xml to have certain loggers be more specific");
            }
            if (logger.isDebugEnabled()) {
                TreeMap<String, String> env = new TreeMap<String, String>(System.getenv());
                StringBuilder sb = new StringBuilder();
                for (String envName : env.keySet()) {
                    sb.append(envName).append("=").append((String)env.get(envName)).append("\n");
                }
                logger.debug("==========Enviroment Variables===========\n{}", (Object)sb.toString());
                TreeMap<Object, Object> props = new TreeMap<Object, Object>(System.getProperties());
                sb = new StringBuilder();
                for (Map.Entry ent : props.entrySet()) {
                    sb.append(ent.getKey().toString()).append("=").append(ent.getValue().toString()).append("\n");
                }
                String hostname = "[UNABLE TO DETERMINE HOSTNAME]";
                try {
                    hostname = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
                logger.debug("Hostname:{}", (Object)hostname);
                logger.debug("==========System Properties==============\n{}", (Object)sb.toString());
            }
            logger.info("==========Configuration Options==========\n{}", (Object)config.toString());
            logger.info("Parsing instances from {}", (Object)config.scenarioConfig.instanceFile);
            InstanceListWithSeeds ilws = ProblemInstanceHelper.getInstances((String)config.scenarioConfig.instanceFile, (String)config.experimentDir, (String)config.scenarioConfig.instanceFeatureFile, (boolean)config.scenarioConfig.checkInstanceFilesExist, (long)(config.numRun + config.seedOffset + 1L), (boolean)config.scenarioConfig.algoExecOptions.deterministic);
            instanceFileAbsolutePath = ilws.getInstanceFileAbsolutePath();
            instanceFeatureFileAbsolutePath = ilws.getInstanceFeatureFileAbsolutePath();
            instanceSeedGen = ilws.getSeedGen();
            logger.info("Instance Seed Generator reports {} seeds ", (Object)instanceSeedGen.getInitialInstanceSeedCount());
            if (!instanceSeedGen.allInstancesHaveSameNumberOfSeeds()) {
                logger.error("Instance Seed Generator reports that some instances have a different number of seeds than others");
                throw new ParameterException("All Training Instances must have the same number of seeds in this version of SMAC");
            }
            logger.info("Instance Seed Generator reports that all instances have the same number of available seeds");
            instances = ilws.getInstances();
            logger.info("Parsing test instances from {}", (Object)config.scenarioConfig.testInstanceFile);
            try {
                ilws = ProblemInstanceHelper.getInstances((String)config.scenarioConfig.testInstanceFile, (String)config.experimentDir, (String)config.scenarioConfig.instanceFeatureFile, (boolean)config.scenarioConfig.checkInstanceFilesExist, (long)(config.numRun + config.seedOffset + 2L), (boolean)config.scenarioConfig.algoExecOptions.deterministic);
            }
            catch (FeatureNotFoundException e) {
                ilws = ProblemInstanceHelper.getInstances((String)config.scenarioConfig.testInstanceFile, (String)config.experimentDir, null, (boolean)config.scenarioConfig.checkInstanceFilesExist, (long)(config.numRun + config.seedOffset + 2L), (boolean)config.scenarioConfig.algoExecOptions.deterministic);
            }
            testInstances = ilws.getInstances();
            testInstanceSeedGen = ilws.getSeedGen();
            logger.info("Test Instance Seed Generator reports {} seeds ", (Object)testInstanceSeedGen.getInitialInstanceSeedCount());
            if (testInstanceSeedGen.allInstancesHaveSameNumberOfSeeds()) {
                logger.info("Test Seed Generator reports that all instances have the same number of available seeds");
            } else {
                logger.info("Test Seed Generator reports that the number of seeds per instance varies.");
            }
            List names = TargetAlgorithmEvaluatorBuilder.getAvailableTargetAlgorithmEvaluators((AlgorithmExecutionOptions)config.scenarioConfig.algoExecOptions);
            for (String name : names) {
                logger.debug("Target Algorithm Evaluator Available {} ", (Object)name);
            }
            try {
                if (ManagementFactory.getThreadMXBean().isThreadCpuTimeEnabled()) {
                    logger.debug("JVM Supports CPU Timing Measurements");
                } else {
                    logger.warn("This Java Virtual Machine has CPU Time Measurements disabled, tunerTimeout will not contain any SMAC Execution Time.");
                }
            }
            catch (UnsupportedOperationException e) {
                logger.warn("This Java Virtual Machine does not support CPU Time Measurements, tunerTimeout will not contain any SMAC Execution Time Information (http://docs.oracle.com/javase/1.5.0/docs/api/java/lang/management/ThreadMXBean.html#setThreadCpuTimeEnabled(boolean))");
            }
            if (config.numRun + config.seedOffset < 0L) {
                logger.warn("NumRun {} plus Seed Offset {} should be positive, things may not seed correctly", (Object)config.numRun, (Object)config.seedOffset);
            }
            return config;
        }
        catch (IOException e) {
            try {
                ConfigToLaTeX.usage((List)ConfigToLaTeX.getParameters(com.getObjects().get(0)));
            }
            catch (Exception e1) {
                logger.error("Exception occured while trying to generate usage screen", (Throwable)e1);
                logger.error("This exception did NOT cause SMAC to crash");
            }
            throw e;
        }
        catch (ParameterException e) {
            try {
                ConfigToLaTeX.usage((List)ConfigToLaTeX.getParameters(com.getObjects().get(0)));
            }
            catch (Exception e1) {
                logger.error("Exception occured while trying to generate usage screen", (Throwable)e1);
                logger.error("This exception did NOT cause SMAC to crash");
            }
            throw e;
        }
    }

    private static void checkArgsForUsageScreenValues(String[] args, SMACOptions config) {
        try {
            String[] versionNames;
            String[] hiddenNames;
            String[] helpNames;
            HashSet<String> possibleValues = new HashSet<String>(Arrays.asList(args));
            for (String helpName : helpNames = config.getClass().getField("showHelp").getAnnotation(Parameter.class).names()) {
                if (!possibleValues.contains(helpName)) continue;
                ConfigToLaTeX.usage((List)ConfigToLaTeX.getParameters((Object)config));
                System.exit(0);
            }
            for (String helpName : hiddenNames = config.getClass().getField("showHiddenParameters").getAnnotation(Parameter.class).names()) {
                if (!possibleValues.contains(helpName)) continue;
                ConfigToLaTeX.usage((List)ConfigToLaTeX.getParameters((Object)config), (boolean)true);
                System.exit(0);
            }
            for (String helpName : versionNames = config.getClass().getField("showVersion").getAnnotation(Parameter.class).names()) {
                if (!possibleValues.contains(helpName)) continue;
                System.setProperty("logback.configurationFile", "logback-off.xml");
                VersionTracker.setClassLoader((ClassLoader)TargetAlgorithmEvaluatorBuilder.getClassLoader((AlgorithmExecutionOptions)config.scenarioConfig.algoExecOptions));
                System.out.println(VersionTracker.getVersionInformation());
                System.exit(0);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static void validateObjectiveCombinations(ScenarioOptions scenarioConfig, boolean adaptiveCapping) {
        switch (scenarioConfig.interInstanceObj) {
            case MEAN: {
                break;
            }
            default: {
                throw new ParameterException("Model does not currently support an inter-instance objective other than " + OverallObjective.MEAN);
            }
        }
        switch (scenarioConfig.runObj) {
            case RUNTIME: {
                break;
            }
            case QUALITY: {
                if (!scenarioConfig.intraInstanceObj.equals((Object)OverallObjective.MEAN)) {
                    throw new ParameterException("To optimize quality you MUST use an intra-instance objective of " + OverallObjective.MEAN);
                }
                if (!adaptiveCapping) break;
                throw new ParameterException("You can only use Adaptive Capping when using " + RunObjective.RUNTIME + " as an objective");
            }
        }
    }

    private static int getConsoleSize() {
        return 160;
    }

    private static void logCallString(String[] args) {
        StringBuilder sb = new StringBuilder("java -cp ");
        sb.append(System.getProperty("java.class.path")).append(" ");
        sb.append(AutomaticConfigurator.class.getCanonicalName()).append(" ");
        for (String arg : args) {
            boolean escape = false;
            if (arg.contains(" ")) {
                escape = true;
                arg = arg.replaceAll(" ", "\\ ");
            }
            if (escape) {
                sb.append("\"");
            }
            sb.append(arg);
            if (escape) {
                sb.append("\"");
            }
            sb.append(" ");
        }
        logger.info("Call String:");
        logger.info("{}", (Object)sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseModelHashCodes(File modelHashCodeFile) {
        logger.info("Model Hash Code File Passed {}", (Object)modelHashCodeFile.getAbsolutePath());
        LinkedList<Integer> modelHashCodeQueue = new LinkedList<Integer>();
        LinkedList<Integer> preprocessedHashCodeQueue = new LinkedList<Integer>();
        BufferedReader bin = null;
        try {
            try {
                String line;
                bin = new BufferedReader(new FileReader(modelHashCodeFile));
                int hashCodeCount = 0;
                int lineCount = 1;
                while ((line = bin.readLine()) != null) {
                    Matcher m = modelHashCodePattern.matcher(line);
                    if (m.find()) {
                        Object[] array = new Object[]{++hashCodeCount, lineCount, line};
                        logger.debug("Found Model Hash Code #{} on line #{} with contents:{}", array);
                        boolean preprocessed = line.substring(0, 1).equals("P");
                        int colonIndex = line.indexOf(":");
                        String lineSubStr = line.substring(colonIndex + 1).trim();
                        if (!preprocessed) {
                            modelHashCodeQueue.add(Integer.valueOf(lineSubStr));
                        } else {
                            preprocessedHashCodeQueue.add(Integer.valueOf(lineSubStr));
                        }
                    } else {
                        logger.trace("No Hash Code found on line: {}", (Object)line);
                    }
                    ++lineCount;
                }
                if (hashCodeCount == 0) {
                    logger.warn("Hash Code File Specified, but we found no hash codes");
                }
            }
            finally {
                if (bin != null) {
                    bin.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashCodeVerifyingModelBuilder.modelHashes = modelHashCodeQueue;
        HashCodeVerifyingModelBuilder.preprocessedHashes = preprocessedHashCodeQueue;
    }

    static {
        logLocation = "<NO LOG LOCATION SPECIFIED, FAILURE MUST HAVE OCCURED EARLY>";
        modelHashCodePattern = Pattern.compile("^(Preprocessed|Random) Forest Built with Hash Code:\\s*\\d+?\\z");
    }
}

