/*
 * Decompiled with CFR 0.152.
 */
package org.StructureGraphic.v1;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;

public class TextUtils {
    public static final int fontSize = 12;
    public static final String fontName = "SansSerif";
    public static final int fontStyle = 0;
    public static final boolean antialias = true;
    public static final boolean fractionalMetrics = false;
    public static final Font font = new Font("SansSerif", 0, 12);
    public static final FontRenderContext fc = new FontRenderContext(null, true, false);

    public static Rectangle2D measureText(String text) {
        double width = 0.0;
        double height = 0.0;
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        for (String line : text.split("\n")) {
            TextLayout layout = new TextLayout(line, font, fc);
            Rectangle2D rect = layout.getBounds();
            width = Math.max(width, rect.getWidth());
            height += rect.getHeight();
            minX = Math.min(minX, rect.getX());
            minY = Math.min(minX, rect.getY());
        }
        return new Rectangle2D.Double(minX, minY, width, height);
    }

    public static void drawCenteredText(Graphics2D g2, String text, float cx, float cy) {
        Rectangle2D r = TextUtils.measureText(text);
        float xOff = (float)((double)cx - r.getWidth() / 2.0 - r.getX());
        float YOff = (float)((double)cy - r.getHeight() / 2.0 - r.getY());
        for (String line : text.split("\n")) {
            TextLayout layout = new TextLayout(line, font, fc);
            layout.draw(g2, xOff + 0.0f, YOff);
            YOff = (float)((double)YOff + layout.getBounds().getHeight());
        }
    }
}

