/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.models.fastrf;

import ca.ubc.cs.beta.models.fastrf.Regtree;
import ca.ubc.cs.beta.models.fastrf.RegtreeBuildParams;
import ca.ubc.cs.beta.models.fastrf.RoundingMode;
import ca.ubc.cs.beta.models.fastrf.utils.Utils;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;

public strictfp class RegtreeFit {
    private static Random r;
    private static long seed;
    private static final int RAND_MAX = 0x7FFFFFFE;
    private static final double INVALID_CRITVAL = -1.0E13;
    private static int[][] dataIdxs;
    private static double[] y;
    private static double ybar;
    private static double[] catmeans;
    private static int[] catcounts;
    private static double[] ycum;
    private static int[] ycountcum;
    private static int[] uniqueIdxs;
    private static int[] dataRowsHere;
    private static int[] sorder;
    private static int[] maxlocs;
    private static int numleft;
    private static int numright;
    private static int[] leftside;
    private static int[] rightside;

    private static int rand() {
        int retn = r.nextInt(Integer.MAX_VALUE);
        return retn;
    }

    public static Regtree fit(double[][] allTheta, double[][] allX, double[] y, RegtreeBuildParams params) {
        Random r = params.random;
        if (r == null) {
            r = new Random();
            if (params.seed != -1L) {
                r.setSeed(params.seed);
            }
        }
        int N = y.length;
        int numTheta = allTheta.length;
        int numX = allX == null ? 0 : allX.length;
        int[][] dataIdxs = new int[N][2];
        for (int i = 0; i < N; ++i) {
            dataIdxs[i][0] = numTheta == 0 ? 0 : r.nextInt(numTheta);
            dataIdxs[i][1] = numX == 0 ? 0 : r.nextInt(numX);
        }
        return RegtreeFit.fit(allTheta, allX, dataIdxs, y, params);
    }

    public static Regtree fit(double[][] allTheta, double[][] allX, int[][] dataIdxs, double[] y, RegtreeBuildParams params) {
        int i;
        Object ynodeX;
        int i2;
        Object ynodeTheta;
        int j;
        int i3;
        int i4;
        int i5;
        long startTime;
        boolean printDebug = false;
        if (RoundingMode.ROUND_NUMBERS_FOR_MATLAB_SYNC) {
            System.out.println("dataIdxs" + Arrays.deepToString((Object[])dataIdxs));
        }
        long currentTime = startTime = new Date().getTime();
        if (dataIdxs == null || dataIdxs.length == 0) {
            throw new RuntimeException("Cannot build a tree with no data.");
        }
        int N = dataIdxs.length;
        if (y.length != N) {
            throw new RuntimeException("The number of data points and the number of responses must be the same.");
        }
        r = params.random;
        if (r == null) {
            r = new Random();
            if (params.seed != -1L) {
                r.setSeed(params.seed);
            }
        }
        seed = params.seed;
        int numTheta = allTheta == null ? 0 : ((double[][])allTheta).length;
        int numX = allX == null ? 0 : ((double[][])allX).length;
        int numThetavars = allTheta == null ? 0 : allTheta[0].length;
        int numXvars = allX == null ? 0 : allX[0].length;
        int nvars = numThetavars + numXvars;
        boolean[] hasThetaIdx = new boolean[numTheta + 1];
        boolean[] hasXIdx = new boolean[numX + 1];
        if (numTheta != 0) {
            for (i5 = 0; i5 < N; ++i5) {
                hasThetaIdx[dataIdxs[i5][0]] = true;
            }
        }
        if (numX != 0) {
            for (i5 = 0; i5 < N; ++i5) {
                hasXIdx[dataIdxs[i5][1]] = true;
            }
        }
        int[] numMissingThetaIdxsBeforeThis = new int[numTheta + 1];
        int[] numMissingXIdxsBeforeThis = new int[numX + 1];
        int numMissing = 0;
        for (i4 = 0; i4 <= numTheta; ++i4) {
            numMissingThetaIdxsBeforeThis[i4] = numMissing++;
            if (hasThetaIdx[i4]) continue;
        }
        numMissing = 0;
        for (i4 = 0; i4 <= numX; ++i4) {
            numMissingXIdxsBeforeThis[i4] = numMissing++;
            if (hasXIdx[i4]) continue;
        }
        double[][] actualAllTheta = new double[numTheta - numMissingThetaIdxsBeforeThis[numTheta]][];
        int counter = 0;
        for (int i6 = 0; i6 < numTheta; ++i6) {
            if (!hasThetaIdx[i6]) continue;
            actualAllTheta[counter++] = allTheta[i6];
        }
        allTheta = actualAllTheta;
        numTheta = ((double[][])allTheta).length;
        double[][] actualAllX = new double[numX - numMissingXIdxsBeforeThis[numX]][];
        int counter2 = 0;
        for (int i7 = 0; i7 < numX; ++i7) {
            if (!hasXIdx[i7]) continue;
            actualAllX[counter2++] = allX[i7];
        }
        allX = actualAllX;
        numX = ((double[][])allX).length;
        int[][] newDataIdxs = new int[N][2];
        for (int i8 = 0; i8 < N; ++i8) {
            int thetaIdx = dataIdxs[i8][0];
            int xIdx = dataIdxs[i8][1];
            newDataIdxs[i8][0] = numTheta != 0 ? thetaIdx - numMissingThetaIdxsBeforeThis[thetaIdx] : 0;
            newDataIdxs[i8][1] = numX != 0 ? xIdx - numMissingXIdxsBeforeThis[xIdx] : 0;
        }
        dataIdxs = newDataIdxs;
        RegtreeFit.dataIdxs = dataIdxs;
        RegtreeFit.y = y;
        int[] catDomainSizes = params.catDomainSizes;
        if (catDomainSizes != null && catDomainSizes.length != nvars) {
            throw new RuntimeException("catDomainSizes must be of the same length as size(X, 2), i.e. " + nvars + ", but is " + catDomainSizes.length);
        }
        int maxDomSize = 0;
        for (int i9 = 0; i9 < nvars; ++i9) {
            if (catDomainSizes[i9] <= maxDomSize) continue;
            maxDomSize = catDomainSizes[i9];
        }
        int[][] condParents = params.condParents;
        int[][][] condParentVals = params.condParentVals;
        double ratioFeatures = params.ratioFeatures;
        int splitMin = params.splitMin;
        int[] nodenumber = new int[2 * N];
        int[] nodesize = new int[2 * N];
        nodesize[0] = N;
        int[] cutvar = new int[2 * N];
        double[] cutpoint = new double[2 * N];
        int[] leftchildren = new int[2 * N];
        int[] rightchildren = new int[2 * N];
        int[] parent = new int[2 * N];
        double[][] ysub = new double[2 * N][];
        int ncatsplit = 0;
        int[][] catsplit = new int[2 * N][];
        int[] randomPermutation = new int[nvars];
        double[] variableValuesHere = new double[N];
        dataRowsHere = new int[Math.max(N, maxDomSize)];
        uniqueIdxs = new int[N];
        catmeans = new double[maxDomSize];
        catcounts = new int[maxDomSize];
        int numBestLeft = 0;
        int numBestRight = 0;
        int[] bestLeft = new int[maxDomSize];
        int[] bestRight = new int[maxDomSize];
        leftside = new int[maxDomSize];
        rightside = new int[maxDomSize];
        maxlocs = new int[Math.max(N, maxDomSize) - 1];
        ycum = new double[Math.max(N, maxDomSize) + 1];
        ycountcum = new int[Math.max(N, maxDomSize) + 1];
        boolean[] yGoesLeft = new boolean[N];
        boolean[] primaryGoesLeft = new boolean[Math.max(numTheta, numX)];
        sorder = new int[Math.max(N, maxDomSize)];
        double ystd = Utils.var(y);
        int[][] sortedTheta = new int[numThetavars][];
        int[][] sortedX = new int[numXvars][];
        int[] index_into_dataIdxs_here = new int[N];
        double[] temp = new double[Math.max(numTheta, numX)];
        for (i3 = 0; i3 < numThetavars; ++i3) {
            if (catDomainSizes[i3] != 0) continue;
            for (j = 0; j < numTheta; ++j) {
                temp[j] = allTheta[j][i3];
            }
            sortedTheta[i3] = new int[numTheta];
            RegtreeFit.rankSort(temp, numTheta, sortedTheta[i3]);
        }
        for (i3 = 0; i3 < numXvars; ++i3) {
            if (catDomainSizes[i3 + numThetavars] != 0) continue;
            for (j = 0; j < numX; ++j) {
                temp[j] = allX[j][i3];
            }
            sortedX[i3] = new int[numX];
            RegtreeFit.rankSort(temp, numX, sortedX[i3]);
        }
        RegtreeFit.rankSort(y, N, index_into_dataIdxs_here);
        temp = null;
        int[][] y_node = new int[2 * N][];
        int[][][] y_Theta = new int[2 * N][][];
        int[][][] y_X = new int[2 * N][][];
        y_node[0] = index_into_dataIdxs_here;
        if ((double)N * Math.log10(N) < (double)numTheta || numTheta == 0) {
            y_Theta[0] = null;
        } else {
            ynodeTheta = new int[numTheta][];
            int[] Thetacount = new int[numTheta];
            for (i2 = 0; i2 < N; ++i2) {
                int n = dataIdxs[i2][0];
                Thetacount[n] = Thetacount[n] + 1;
            }
            for (i2 = 0; i2 < numTheta; ++i2) {
                ynodeTheta[i2] = new int[Thetacount[i2]];
            }
            i2 = 0;
            while (i2 < N) {
                int idx;
                int dataIdx = index_into_dataIdxs_here[i2];
                int n = idx = dataIdxs[dataIdx][0];
                int n2 = Thetacount[n] - 1;
                Thetacount[n] = n2;
                ynodeTheta[idx][n2] = i2++;
            }
            Thetacount = null;
            y_Theta[0] = ynodeTheta;
        }
        if ((double)N * Math.log10(N) < (double)numX || numX == 0) {
            y_X[0] = null;
        } else {
            ynodeX = new int[numX][];
            int[] Xcount = new int[numX];
            for (i2 = 0; i2 < N; ++i2) {
                int n = dataIdxs[i2][1];
                Xcount[n] = Xcount[n] + 1;
            }
            for (i2 = 0; i2 < numX; ++i2) {
                ynodeX[i2] = new int[Xcount[i2]];
            }
            i2 = 0;
            while (i2 < N) {
                int idx;
                int n = idx = dataIdxs[index_into_dataIdxs_here[i2]][1];
                int n3 = Xcount[n] - 1;
                Xcount[n] = n3;
                ynodeX[idx][n3] = i2++;
            }
            Xcount = null;
            y_X[0] = ynodeX;
        }
        int[] stack = new int[N];
        stack[0] = 0;
        int stacktop = 0;
        int numNodes = 1;
        if (printDebug) {
            long l = -currentTime;
            currentTime = new Date().getTime();
            System.out.println("Setup took " + (l + currentTime) + " milliseconds.");
        }
        while (stacktop >= 0) {
            long diff;
            int tnode = stack[stacktop--];
            index_into_dataIdxs_here = y_node[tnode];
            ynodeTheta = y_Theta[tnode];
            ynodeX = y_X[tnode];
            y_node[tnode] = null;
            y_Theta[tnode] = null;
            y_X[tnode] = null;
            int Nnode = nodesize[tnode];
            if (Nnode == 0) {
                throw new RuntimeException("ERROR! Nnode is 0 (split gave zero data points to this node!?)");
            }
            double ysum = 0.0;
            double ysumOfSq = 0.0;
            double ymax = -1.0E13;
            double ymin = 1.0E13;
            for (int i10 = 0; i10 < Nnode; ++i10) {
                int idx = index_into_dataIdxs_here[i10];
                ysum += y[idx];
                ysumOfSq += y[idx] * y[idx];
                if (y[idx] > ymax) {
                    ymax = y[idx];
                }
                if (!(y[idx] < ymin)) continue;
                ymin = y[idx];
            }
            ybar = ysum / (double)Nnode;
            double mincost = Nnode == 1 ? 0.0 : (ysumOfSq - ysum * ysum / (double)Nnode) / (double)(Nnode - 1);
            boolean impure = mincost > 1.0E-20 * ystd;
            impure = ymax - ymin > 1.0E-10;
            cutvar[tnode] = 0;
            if (impure && Nnode >= splitMin) {
                int i11;
                int nvarsenabled = 0;
                if (condParents == null) {
                    nvarsenabled = nvars;
                    for (i11 = 0; i11 < nvars; ++i11) {
                        randomPermutation[i11] = i11;
                    }
                } else {
                    for (i11 = 0; i11 < nvars; ++i11) {
                        boolean isenabled = true;
                        if (condParents[i11] != null) {
                            for (int j2 = 0; j2 < condParents[i11].length; ++j2) {
                                int[] compatibleValues = RegtreeFit.getCompatibleValues(tnode, condParents[i11][j2], N, parent, cutvar, cutpoint, leftchildren, rightchildren, catsplit, catDomainSizes);
                                for (int k = 0; k < compatibleValues.length; ++k) {
                                    boolean isokvalue = false;
                                    for (int l = 0; l < condParentVals[i11][j2].length; ++l) {
                                        if (compatibleValues[k] != condParentVals[i11][j2][l]) continue;
                                        isokvalue = true;
                                        break;
                                    }
                                    if (isokvalue) continue;
                                    isenabled = false;
                                    break;
                                }
                                if (!isenabled) break;
                            }
                        }
                        if (!isenabled) continue;
                        randomPermutation[nvarsenabled++] = i11;
                    }
                }
                RegtreeFit.shuffle(randomPermutation, nvarsenabled);
                int bestvar = -1;
                double bestcut = 0.0;
                double bestcrit = -1.0E12;
                for (int i12 = 0; i12 < nvarsenabled; ++i12) {
                    int is_X;
                    Object allData;
                    Object ynodeData;
                    int[][] sortedData;
                    int numData;
                    int varIdx;
                    boolean is_nextvar_cat;
                    int nextvar = randomPermutation[i12];
                    boolean bl = is_nextvar_cat = catDomainSizes[nextvar] != 0;
                    if (nextvar < numThetavars) {
                        varIdx = nextvar;
                        numData = numTheta;
                        sortedData = sortedTheta;
                        ynodeData = ynodeTheta;
                        allData = allTheta;
                        is_X = 0;
                    } else {
                        varIdx = nextvar - numThetavars;
                        numData = numX;
                        sortedData = sortedX;
                        ynodeData = ynodeX;
                        allData = allX;
                        is_X = 1;
                    }
                    double critval = -1.0E13;
                    double cutval = -1.0E13;
                    if (is_nextvar_cat) {
                        int domSize = catDomainSizes[nextvar];
                        critval = RegtreeFit.critval_cat(varIdx, is_X, allData, Nnode, index_into_dataIdxs_here, domSize);
                        if (critval > bestcrit + 1.0E-10) {
                            int j3;
                            bestcrit = critval;
                            bestvar = nextvar;
                            numBestLeft = numleft;
                            numBestRight = numright;
                            for (j3 = 0; j3 < numBestLeft; ++j3) {
                                bestLeft[j3] = leftside[j3];
                            }
                            for (j3 = 0; j3 < numBestRight; ++j3) {
                                bestRight[j3] = rightside[j3];
                            }
                        }
                    } else {
                        int[] results = RegtreeFit.prepare_for_cont_critval(varIdx, is_X, numData, sortedData, allData, Nnode, index_into_dataIdxs_here, ynodeData, variableValuesHere);
                        if (results == null) continue;
                        int numUniqData = results[0];
                        int numUniqValues = results[1];
                        double[] result = RegtreeFit.critval_cont(numUniqData, numUniqValues, uniqueIdxs, index_into_dataIdxs_here, ynodeData, dataRowsHere, variableValuesHere);
                        critval = result[0];
                        cutval = result[1];
                        if (critval > bestcrit + 1.0E-10) {
                            bestcrit = critval;
                            bestvar = nextvar;
                            bestcut = cutval;
                        }
                    }
                    if (critval != -1.0E13 && i12 >= Math.max(1, (int)(ratioFeatures * (double)nvarsenabled)) - 1 && bestcrit > -1.0E11) break;
                }
                if (bestvar != -1) {
                    Object ySecondaryRight;
                    Object yPrimaryRight;
                    int is_X;
                    int[][][] y_Secondary;
                    Object ynodeSecondary;
                    int numSecondary;
                    int[][][] y_Primary;
                    Object allPrimary;
                    Object ynodePrimary;
                    int numPrimary;
                    int varIdx;
                    if (bestvar < numThetavars) {
                        varIdx = bestvar;
                        numPrimary = numTheta;
                        ynodePrimary = ynodeTheta;
                        allPrimary = allTheta;
                        y_Primary = y_Theta;
                        numSecondary = numX;
                        ynodeSecondary = ynodeX;
                        y_Secondary = y_X;
                        is_X = 0;
                    } else {
                        varIdx = bestvar - numThetavars;
                        numPrimary = numX;
                        ynodePrimary = ynodeX;
                        allPrimary = allX;
                        y_Primary = y_X;
                        numSecondary = numTheta;
                        ynodeSecondary = ynodeTheta;
                        y_Secondary = y_Theta;
                        is_X = 1;
                    }
                    int nleft = 0;
                    int nright = 0;
                    if (catDomainSizes[bestvar] != 0) {
                        int nextval;
                        int i13;
                        int i14;
                        cutvar[tnode] = -(bestvar + 1);
                        cutpoint[tnode] = ncatsplit;
                        int[] compatibleValues = RegtreeFit.getCompatibleValues(tnode, bestvar, N, parent, cutvar, cutpoint, leftchildren, rightchildren, catsplit, catDomainSizes);
                        int[] missing_values_for_left = new int[compatibleValues.length];
                        int[] missing_values_for_right = new int[compatibleValues.length];
                        for (i14 = 0; i14 < catDomainSizes[bestvar]; ++i14) {
                            RegtreeFit.dataRowsHere[i14] = 0;
                        }
                        for (i14 = 0; i14 < numBestLeft; ++i14) {
                            RegtreeFit.dataRowsHere[bestLeft[i14] - 1] = 1;
                        }
                        for (i14 = 0; i14 < numBestRight; ++i14) {
                            RegtreeFit.dataRowsHere[bestRight[i14] - 1] = 1;
                        }
                        int num_missing_to_left = 0;
                        int num_missing_to_right = 0;
                        for (i13 = 0; i13 < compatibleValues.length; ++i13) {
                            int nextValue = compatibleValues[i13];
                            if (dataRowsHere[nextValue - 1] != 0) continue;
                            if (RegtreeFit.rand() % 2 == 0) {
                                missing_values_for_left[num_missing_to_left++] = nextValue;
                                continue;
                            }
                            missing_values_for_right[num_missing_to_right++] = nextValue;
                        }
                        catsplit[ncatsplit] = new int[num_missing_to_left + numBestLeft];
                        for (i13 = 0; i13 < num_missing_to_left; ++i13) {
                            nextval = missing_values_for_left[i13];
                            RegtreeFit.leftside[nextval - 1] = 1;
                            catsplit[ncatsplit][i13] = nextval;
                        }
                        for (i13 = 0; i13 < numBestLeft; ++i13) {
                            nextval = bestLeft[i13];
                            RegtreeFit.leftside[nextval - 1] = 1;
                            catsplit[ncatsplit][num_missing_to_left + i13] = nextval;
                        }
                        Arrays.sort(catsplit[ncatsplit]);
                        catsplit[ncatsplit + N] = new int[num_missing_to_right + numBestRight];
                        for (i13 = 0; i13 < num_missing_to_right; ++i13) {
                            nextval = missing_values_for_right[i13];
                            RegtreeFit.leftside[nextval - 1] = 0;
                            catsplit[ncatsplit + N][i13] = nextval;
                        }
                        for (i13 = 0; i13 < numBestRight; ++i13) {
                            nextval = bestRight[i13];
                            RegtreeFit.leftside[nextval - 1] = 0;
                            catsplit[ncatsplit + N][num_missing_to_right + i13] = nextval;
                        }
                        Arrays.sort(catsplit[ncatsplit + N]);
                        ++ncatsplit;
                        if (ynodePrimary == null) {
                            for (i13 = 0; i13 < Nnode; ++i13) {
                                int idx = index_into_dataIdxs_here[i13];
                                double xVal = allPrimary[dataIdxs[idx][is_X]][varIdx];
                                if (leftside[(int)(xVal - 0.5)] == 1) {
                                    ++nleft;
                                    yGoesLeft[i13] = true;
                                    continue;
                                }
                                ++nright;
                                yGoesLeft[i13] = false;
                            }
                        } else {
                            for (i13 = 0; i13 < numPrimary; ++i13) {
                                int j4;
                                if (leftside[(int)(allPrimary[i13][varIdx] - 0.5)] == 1) {
                                    primaryGoesLeft[i13] = true;
                                    if (ynodePrimary[i13] == null) continue;
                                    for (j4 = 0; j4 < ynodePrimary[i13].length; ++j4) {
                                        ++nleft;
                                        yGoesLeft[ynodePrimary[i13][j4]] = true;
                                    }
                                    continue;
                                }
                                primaryGoesLeft[i13] = false;
                                if (ynodePrimary[i13] == null) continue;
                                for (j4 = 0; j4 < ynodePrimary[i13].length; ++j4) {
                                    ++nright;
                                    yGoesLeft[ynodePrimary[i13][j4]] = false;
                                }
                            }
                        }
                    } else {
                        cutvar[tnode] = bestvar + 1;
                        cutpoint[tnode] = bestcut;
                        if (ynodePrimary == null) {
                            for (int i15 = 0; i15 < Nnode; ++i15) {
                                int idx = index_into_dataIdxs_here[i15];
                                double xVal = allPrimary[dataIdxs[idx][is_X]][varIdx];
                                if (xVal <= bestcut) {
                                    ++nleft;
                                    yGoesLeft[i15] = true;
                                    continue;
                                }
                                ++nright;
                                yGoesLeft[i15] = false;
                            }
                        } else {
                            for (int i16 = 0; i16 < numPrimary; ++i16) {
                                int j5;
                                if (allPrimary[i16][varIdx] <= bestcut) {
                                    primaryGoesLeft[i16] = true;
                                    if (ynodePrimary[i16] == null) continue;
                                    for (j5 = 0; j5 < ynodePrimary[i16].length; ++j5) {
                                        ++nleft;
                                        yGoesLeft[ynodePrimary[i16][j5]] = true;
                                    }
                                    continue;
                                }
                                primaryGoesLeft[i16] = false;
                                if (ynodePrimary[i16] == null) continue;
                                for (j5 = 0; j5 < ynodePrimary[i16].length; ++j5) {
                                    ++nright;
                                    yGoesLeft[ynodePrimary[i16][j5]] = false;
                                }
                            }
                        }
                    }
                    if (nleft == 0 || nright == 0) {
                        throw new RuntimeException("Empty side after splitting!");
                    }
                    int[] ynodeLeft = new int[nleft];
                    int[] ynodeRight = new int[nright];
                    int leftCounter = 0;
                    int rightCounter = 0;
                    for (int i17 = 0; i17 < Nnode; ++i17) {
                        if (yGoesLeft[i17]) {
                            ynodeLeft[leftCounter] = index_into_dataIdxs_here[i17];
                            index_into_dataIdxs_here[i17] = leftCounter++;
                            continue;
                        }
                        ynodeRight[rightCounter] = index_into_dataIdxs_here[i17];
                        index_into_dataIdxs_here[i17] = rightCounter++;
                    }
                    y_node[numNodes] = ynodeLeft;
                    y_node[numNodes + 1] = ynodeRight;
                    boolean naiveSortPrimaryLeft = ynodePrimary == null || (double)nleft * Math.log10(nleft) < (double)numPrimary;
                    boolean naiveSortPrimaryRight = ynodePrimary == null || (double)nright * Math.log10(nright) < (double)numPrimary;
                    Object yPrimaryLeft = naiveSortPrimaryLeft ? (int[][])null : (Object)new int[numPrimary][];
                    Object object = yPrimaryRight = naiveSortPrimaryRight ? (int[][])null : (Object)new int[numPrimary][];
                    if (!naiveSortPrimaryLeft || !naiveSortPrimaryRight) {
                        for (int i18 = 0; i18 < numPrimary; ++i18) {
                            int j6;
                            if (primaryGoesLeft[i18]) {
                                if (naiveSortPrimaryLeft) continue;
                                yPrimaryLeft[i18] = ynodePrimary[i18];
                                if (yPrimaryLeft[i18] == null) continue;
                                for (j6 = 0; j6 < yPrimaryLeft[i18].length; ++j6) {
                                    yPrimaryLeft[i18][j6] = index_into_dataIdxs_here[yPrimaryLeft[i18][j6]];
                                }
                                continue;
                            }
                            if (naiveSortPrimaryRight) continue;
                            yPrimaryRight[i18] = ynodePrimary[i18];
                            if (yPrimaryRight[i18] == null) continue;
                            for (j6 = 0; j6 < yPrimaryRight[i18].length; ++j6) {
                                yPrimaryRight[i18][j6] = index_into_dataIdxs_here[yPrimaryRight[i18][j6]];
                            }
                        }
                    }
                    y_Primary[numNodes] = yPrimaryLeft;
                    y_Primary[numNodes + 1] = yPrimaryRight;
                    boolean naiveSortSecondaryLeft = ynodeSecondary == null || (double)nleft * Math.log10(nleft) < (double)numSecondary;
                    boolean naiveSortSecondaryRight = ynodeSecondary == null || (double)nright * Math.log10(nright) < (double)numSecondary;
                    Object ySecondaryLeft = naiveSortSecondaryLeft ? (int[][])null : (Object)new int[numSecondary][];
                    Object object2 = ySecondaryRight = naiveSortSecondaryRight ? (int[][])null : (Object)new int[numSecondary][];
                    if (!naiveSortSecondaryLeft || !naiveSortSecondaryRight) {
                        for (int i19 = 0; i19 < numSecondary; ++i19) {
                            if (ynodeSecondary[i19] == null) continue;
                            int[] thisynodeSecondary = ynodeSecondary[i19];
                            int numySecondaryLeft = 0;
                            int numySecondaryRight = 0;
                            for (int j7 = 0; j7 < thisynodeSecondary.length; ++j7) {
                                if (yGoesLeft[thisynodeSecondary[j7]]) {
                                    ++numySecondaryLeft;
                                    continue;
                                }
                                ++numySecondaryRight;
                            }
                            int[] ySecondaryLeft_i = naiveSortSecondaryLeft ? null : new int[numySecondaryLeft];
                            int[] ySecondaryRight_i = naiveSortSecondaryRight ? null : new int[numySecondaryRight];
                            numySecondaryLeft = 0;
                            numySecondaryRight = 0;
                            for (int j8 = 0; j8 < thisynodeSecondary.length; ++j8) {
                                if (yGoesLeft[thisynodeSecondary[j8]]) {
                                    if (naiveSortSecondaryLeft) continue;
                                    ySecondaryLeft_i[numySecondaryLeft++] = index_into_dataIdxs_here[thisynodeSecondary[j8]];
                                    continue;
                                }
                                if (naiveSortSecondaryRight) continue;
                                ySecondaryRight_i[numySecondaryRight++] = index_into_dataIdxs_here[thisynodeSecondary[j8]];
                            }
                            if (numySecondaryLeft != 0) {
                                ySecondaryLeft[i19] = ySecondaryLeft_i;
                            }
                            if (numySecondaryRight == 0) continue;
                            ySecondaryRight[i19] = ySecondaryRight_i;
                        }
                    }
                    y_Secondary[numNodes] = ySecondaryLeft;
                    y_Secondary[numNodes + 1] = ySecondaryRight;
                    leftchildren[tnode] = numNodes;
                    rightchildren[tnode] = numNodes + 1;
                    nodenumber[numNodes] = numNodes;
                    nodenumber[numNodes + 1] = numNodes + 1;
                    parent[numNodes] = tnode;
                    parent[numNodes + 1] = tnode;
                    nodesize[numNodes] = nleft;
                    nodesize[numNodes + 1] = nright;
                    stack[++stacktop] = numNodes;
                    stack[++stacktop] = numNodes + 1;
                    numNodes += 2;
                }
            }
            if (cutvar[tnode] == 0) {
                ysub[tnode] = new double[Nnode];
                for (int i20 = 0; i20 < Nnode; ++i20) {
                    int idx = index_into_dataIdxs_here[i20];
                    ysub[tnode][i20] = y[idx];
                }
            }
            if (!printDebug || (diff = -currentTime + (currentTime = new Date().getTime())) <= 1000L) continue;
            System.out.println("Node " + tnode + " had " + Nnode + " data points and took " + diff + " milliseconds.");
        }
        Regtree tree = new Regtree(numNodes, ncatsplit, params.storeResponses, params.logModel);
        System.arraycopy(nodenumber, 0, tree.node, 0, numNodes);
        System.arraycopy(parent, 0, tree.parent, 0, numNodes);
        System.arraycopy(cutvar, 0, tree.var, 0, numNodes);
        System.arraycopy(cutpoint, 0, tree.cut, 0, numNodes);
        System.arraycopy(nodesize, 0, tree.nodesize, 0, numNodes);
        tree.npred = nvars;
        int nextnode = -1;
        for (i = 0; i < ncatsplit; ++i) {
            int j9;
            while (cutvar[++nextnode] >= 0) {
            }
            int[] tmp = new int[catDomainSizes[-cutvar[nextnode] - 1]];
            Arrays.fill(tmp, -1);
            int cs_idx = (int)cutpoint[nextnode];
            int[] cs = catsplit[cs_idx];
            for (j9 = 0; j9 < cs.length; ++j9) {
                tmp[cs[j9] - 1] = 0;
            }
            cs = catsplit[cs_idx + N];
            for (j9 = 0; j9 < cs.length; ++j9) {
                tmp[cs[j9] - 1] = 1;
            }
            tree.catsplit[cs_idx] = tmp;
        }
        for (i = 0; i < numNodes; ++i) {
            int Nnode;
            tree.children[i][0] = leftchildren[i];
            tree.children[i][1] = rightchildren[i];
            int n = Nnode = leftchildren[i] == 0 ? nodesize[i] : 0;
            if (Nnode == 0) continue;
            if (params.storeResponses) {
                tree.ysub[i] = new double[Nnode];
                if (tree.logModel > 0) {
                    for (int n4 = 0; n4 < Nnode; ++n4) {
                        tree.ysub[i][n4] = Math.pow(10.0, ysub[i][n4]);
                    }
                    continue;
                }
                System.arraycopy(ysub[i], 0, tree.ysub[i], 0, Nnode);
                continue;
            }
            double sum = 0.0;
            double sumOfSq = 0.0;
            for (int j10 = 0; j10 < Nnode; ++j10) {
                double next = ysub[i][j10];
                if (tree.logModel > 0) {
                    next = Math.pow(10.0, next);
                }
                sum += next;
                sumOfSq += next * next;
            }
            tree.ysub[i][0] = sum;
            tree.ysub[i][1] = sumOfSq;
        }
        tree.recalculateStats();
        sorder = null;
        maxlocs = null;
        RegtreeFit.dataIdxs = null;
        RegtreeFit.y = null;
        catmeans = null;
        catcounts = null;
        ycum = null;
        ycountcum = null;
        uniqueIdxs = null;
        dataRowsHere = null;
        leftside = null;
        rightside = null;
        if (printDebug) {
            System.out.println("Building the tree took a total of " + (new Date().getTime() - startTime) + " milliseconds.");
        }
        return tree;
    }

    private static int[] prepare_for_cont_critval(int varIdx, int is_X, int numData, int[][] sortedData, double[][] allData, int Nnode, int[] index_into_dataIdxs_here, int[][] ynodeData, double[] variableValuesHere) {
        int numUniqData = 0;
        int numUniqValues = 0;
        if (ynodeData == null) {
            for (int j = 0; j < Nnode; ++j) {
                int idx = index_into_dataIdxs_here[j];
                variableValuesHere[j] = allData[dataIdxs[idx][is_X]][varIdx];
            }
            RegtreeFit.rankSort(variableValuesHere, Nnode, sorder);
            double prevValue = variableValuesHere[sorder[0]];
            RegtreeFit.uniqueIdxs[numUniqValues++] = 0;
            for (int j = 1; j < Nnode; ++j) {
                double nextValue = variableValuesHere[sorder[j]];
                if (prevValue + 1.0E-10 < nextValue) {
                    RegtreeFit.uniqueIdxs[numUniqValues++] = j;
                }
                prevValue = nextValue;
            }
            numUniqData = Nnode;
        } else {
            double prevValue = 0.0;
            for (int j = 0; j < numData; ++j) {
                int nextIdx = sortedData[varIdx][j];
                int[] yhere = ynodeData[nextIdx];
                if (yhere == null) continue;
                double nextValue = allData[nextIdx][varIdx];
                if (numUniqValues == 0 || prevValue + 1.0E-10 < nextValue) {
                    RegtreeFit.uniqueIdxs[numUniqValues] = numUniqData;
                    variableValuesHere[numUniqValues++] = nextValue;
                }
                prevValue = nextValue;
                RegtreeFit.dataRowsHere[numUniqData++] = nextIdx;
            }
        }
        if (numUniqValues <= 1) {
            return null;
        }
        return new int[]{numUniqData, numUniqValues};
    }

    private static double[] critval_cont(int numUniqData, int numUniqValues, int[] uniqueIdxs, int[] index_into_dataIdxs_here, int[][] ynodeData, int[] dataRowsHere, double[] variableValuesHere) {
        double next;
        double prev;
        int j;
        double critval = -1.0E13;
        RegtreeFit.ycum[0] = 0.0;
        RegtreeFit.ycountcum[0] = 0;
        if (ynodeData == null) {
            for (j = 1; j <= numUniqData; ++j) {
                RegtreeFit.ycum[j] = ycum[j - 1] + y[index_into_dataIdxs_here[sorder[j - 1]]] - ybar;
                RegtreeFit.ycountcum[j] = ycountcum[j - 1] + 1;
            }
        } else {
            for (j = 1; j <= numUniqData; ++j) {
                int[] ynodeIdxsHere = ynodeData[dataRowsHere[j - 1]];
                int numYValuesHere = ynodeIdxsHere.length;
                double sumYValuesHere = 0.0;
                for (int k : ynodeIdxsHere) {
                    sumYValuesHere += y[index_into_dataIdxs_here[k]];
                }
                RegtreeFit.ycum[j] = ycum[j - 1] + sumYValuesHere - (double)numYValuesHere * ybar;
                RegtreeFit.ycountcum[j] = ycountcum[j - 1] + numYValuesHere;
            }
        }
        double ytotal = ycum[numUniqData];
        int numytotal = ycountcum[numUniqData];
        int numlocs_with_max_crit = 0;
        for (int j2 = 1; j2 < numUniqValues; ++j2) {
            int idx = uniqueIdxs[j2];
            double yc = ycum[idx];
            double ssx = yc * yc / (double)ycountcum[idx] + (ytotal - yc) * (ytotal - yc) / (double)(numytotal - ycountcum[idx]);
            if (!(ssx > critval - 1.0E-10)) continue;
            if (ssx > critval + 1.0E-10) {
                critval = ssx;
                numlocs_with_max_crit = 0;
            }
            RegtreeFit.maxlocs[numlocs_with_max_crit++] = j2 - 1;
        }
        int maxloc = maxlocs[RegtreeFit.rand() % numlocs_with_max_crit];
        double u = (double)RegtreeFit.rand() * 1.0 / 2.147483646E9;
        if (ynodeData == null) {
            prev = variableValuesHere[sorder[uniqueIdxs[maxloc]]];
            next = variableValuesHere[sorder[uniqueIdxs[maxloc + 1]]];
        } else {
            prev = variableValuesHere[maxloc];
            next = variableValuesHere[maxloc + 1];
        }
        double cutval = 0.0;
        if (next - prev < 1.8999999999999998E-6) {
            cutval = (next + prev) / 2.0;
        } else {
            cutval = (1.0 - u) * (prev + 1.0E-6) + u * (next - 1.0E-6);
            if (cutval < prev + 1.0E-8 || cutval > next - 1.0E-8) {
                throw new RuntimeException("random splitpoint has to lie in between the upper and lower limit");
            }
        }
        return new double[]{critval, cutval};
    }

    private static double critval_cat(int varIdx, int var_is_X, double[][] allData, int Nnode, int[] index_into_dataIdxs_here, int domSize) {
        int j;
        int maxloc;
        int j2;
        double critval = -1.0E13;
        Arrays.fill(catmeans, 0, domSize, 0.0);
        Arrays.fill(catcounts, 0, domSize, 0);
        for (int j3 = 0; j3 < Nnode; ++j3) {
            int category;
            int idx = index_into_dataIdxs_here[j3];
            int n = category = (int)(allData[dataIdxs[idx][var_is_X]][varIdx] - 0.5);
            catmeans[n] = catmeans[n] + y[idx];
            int n2 = category;
            catcounts[n2] = catcounts[n2] + 1;
        }
        int numtotal = 0;
        for (j2 = 0; j2 < domSize; ++j2) {
            if (catcounts[j2] != 0) {
                ++numtotal;
                int n = j2;
                catmeans[n] = catmeans[n] / (double)catcounts[j2];
                continue;
            }
            RegtreeFit.catmeans[j2] = Double.POSITIVE_INFINITY;
        }
        if (numtotal <= 1) {
            return critval;
        }
        RegtreeFit.rankSort(catmeans, domSize, sorder);
        RegtreeFit.ycum[0] = 0.0;
        RegtreeFit.ycountcum[0] = 0;
        for (j2 = 1; j2 <= numtotal; ++j2) {
            int idx = sorder[j2 - 1];
            RegtreeFit.ycum[j2] = ycum[j2 - 1] + (double)catcounts[idx] * (catmeans[idx] - ybar);
            RegtreeFit.ycountcum[j2] = ycountcum[j2 - 1] + catcounts[idx];
        }
        double ytotal = ycum[numtotal];
        int numytotal = ycountcum[numtotal];
        int numlocs_with_max_crit = 0;
        for (int j4 = 1; j4 < numtotal; ++j4) {
            double ssx = ycum[j4] * ycum[j4] / (double)ycountcum[j4] + (ytotal - ycum[j4]) * (ytotal - ycum[j4]) / (double)(numytotal - ycountcum[j4]);
            if (!(ssx > critval - 1.0E-10)) continue;
            if (ssx > critval + 1.0E-10) {
                critval = ssx;
                numlocs_with_max_crit = 0;
            }
            RegtreeFit.maxlocs[numlocs_with_max_crit++] = j4;
        }
        numleft = maxloc = maxlocs[RegtreeFit.rand() % numlocs_with_max_crit];
        numright = numtotal - numleft;
        for (j = 0; j < numleft; ++j) {
            RegtreeFit.leftside[j] = sorder[j] + 1;
        }
        for (j = 0; j < numright; ++j) {
            RegtreeFit.rightside[j] = sorder[j + numleft] + 1;
        }
        return critval;
    }

    private static int[] getCompatibleValues(int currnode, int var, int N, int[] parent, int[] cutvar, double[] cutpoint, int[] leftchildren, int[] rightchildren, int[][] catsplit, int[] catDomainSizes) {
        int[] compatibleValues = null;
        while (currnode > 0) {
            int parent_node = parent[currnode];
            if (-cutvar[parent_node] - 1 == var) {
                int catsplit_index = (int)cutpoint[parent_node];
                if (leftchildren[parent_node] == currnode) {
                    compatibleValues = catsplit[catsplit_index];
                    break;
                }
                if (rightchildren[parent_node] == currnode) {
                    compatibleValues = catsplit[catsplit_index + N];
                    break;
                }
                throw new RuntimeException("currnode must be either left or right child of its parent.");
            }
            currnode = parent_node;
        }
        if (currnode == 0) {
            compatibleValues = new int[catDomainSizes[var]];
            for (int i = 0; i < compatibleValues.length; ++i) {
                compatibleValues[i] = i + 1;
            }
        }
        return compatibleValues;
    }

    private static void rankSort(double[] arr, int len, int[] sorder) {
        for (int i = 0; i < len; ++i) {
            sorder[i] = i;
        }
        RegtreeFit.dp_quick(arr, sorder, 0, len - 1);
    }

    private static void shuffle(int[] arr, int n) {
        for (int i = 0; i < n - 1; ++i) {
            int j = i + RegtreeFit.rand() / (0x7FFFFFFE / (n - i) + 1);
            int t = arr[j];
            arr[j] = arr[i];
            arr[i] = t;
        }
    }

    private static void dp_quick(double[] input, int[] sorder, int min, int max) {
        while (max - min > 0) {
            int i = min;
            int j = max;
            double pivot = input[sorder[i + j >> 1]];
            while (true) {
                if (input[sorder[i]] < pivot) {
                    ++i;
                    continue;
                }
                while (input[sorder[j]] > pivot) {
                    --j;
                }
                if (i >= j) break;
                int t = sorder[i];
                sorder[i] = sorder[j];
                sorder[j] = t;
                if (++i >= --j) break;
            }
            while (min < j && input[sorder[j]] == pivot) {
                --j;
            }
            if (min < j) {
                RegtreeFit.dp_quick(input, sorder, min, j);
            }
            while (i < max && input[sorder[i]] == pivot) {
                ++i;
            }
            min = i;
        }
    }
}

