/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.algorithmrun;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.misc.watch.StopWatch;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;

public abstract class AbstractAlgorithmRun
implements Runnable,
AlgorithmRun {
    private static final long serialVersionUID = -1860615761848618478L;
    protected final RunConfig runConfig;
    protected final AlgorithmExecutionConfig execConfig;
    private RunResult acResult;
    private double runtime;
    private double runLength;
    private double quality;
    private long resultSeed;
    private String resultLine;
    private String rawResultLine;
    private boolean runCompleted = false;
    private boolean runResultWellFormed = false;
    private double wallClockTime = 0.0;
    private StopWatch wallClockTimer = new StopWatch();
    private String additionalRunData = "";

    protected synchronized void setResult(RunResult acResult, double runtime, double runLength, double quality, long resultSeed, String rawResultLine, String additionalRunData) {
        this.acResult = acResult;
        this.runtime = runtime;
        this.runLength = runLength;
        this.quality = quality;
        this.resultSeed = resultSeed;
        this.resultLine = acResult.name() + ", " + runtime + ", " + runLength + ", " + quality + ", " + resultSeed;
        if (additionalRunData.trim().length() > 0) {
            this.resultLine = this.resultLine + "," + additionalRunData;
            this.additionalRunData = additionalRunData;
        }
        this.rawResultLine = rawResultLine;
        this.runResultWellFormed = true;
        this.runCompleted = true;
    }

    protected void setAbortResult(String rawResultLine) {
        this.setResult(RunResult.ABORT, this.runConfig.getCutoffTime(), 0.0, 0.0, this.runConfig.getProblemInstanceSeedPair().getSeed(), rawResultLine, "");
    }

    protected void setCrashResult(String rawResultLine) {
        this.setResult(RunResult.CRASHED, this.runConfig.getCutoffTime(), 0.0, 0.0, this.runConfig.getProblemInstanceSeedPair().getSeed(), rawResultLine, "");
    }

    protected void startWallclockTimer() {
        this.wallClockTimer.start();
    }

    protected void stopWallclockTimer() {
        this.wallClockTime = (double)this.wallClockTimer.stop() / 1000.0;
    }

    protected synchronized void setResult(RunResult acResult, double runtime, double runLength, double quality, long resultSeed, String resultLine, String rawResultLine, boolean runResultWellFormed, String additionalRunData) {
        this.acResult = acResult;
        this.runtime = runtime;
        this.runLength = runLength;
        this.quality = quality;
        this.resultSeed = resultSeed;
        this.resultLine = resultLine;
        this.rawResultLine = rawResultLine;
        this.runResultWellFormed = runResultWellFormed;
        this.runCompleted = true;
        this.additionalRunData = additionalRunData;
    }

    public AbstractAlgorithmRun(AlgorithmExecutionConfig execConfig, RunConfig runConfig) {
        if (execConfig == null || runConfig == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this.runConfig = runConfig;
        this.execConfig = execConfig;
    }

    @Override
    public abstract void run();

    @Override
    public final Object call() {
        this.run();
        return null;
    }

    @Override
    public final AlgorithmExecutionConfig getExecutionConfig() {
        return this.execConfig;
    }

    @Override
    public final RunConfig getRunConfig() {
        return this.runConfig;
    }

    @Override
    public final RunResult getRunResult() {
        if (!this.isRunResultWellFormed()) {
            throw new IllegalStateException("Execution Result was not well formed");
        }
        return this.acResult;
    }

    @Override
    public final double getRuntime() {
        if (!this.isRunResultWellFormed()) {
            throw new IllegalStateException("Execution Result was not well formed");
        }
        return this.runtime;
    }

    @Override
    public final double getRunLength() {
        if (!this.isRunResultWellFormed()) {
            throw new IllegalStateException("Execution Result was not well formed");
        }
        return this.runLength;
    }

    @Override
    public final double getQuality() {
        if (!this.isRunResultWellFormed()) {
            throw new IllegalStateException("Execution Result was not well formed");
        }
        return this.quality;
    }

    @Override
    public final long getResultSeed() {
        if (!this.isRunResultWellFormed()) {
            throw new IllegalStateException("Execution Result was not well formed");
        }
        return this.resultSeed;
    }

    @Override
    public final String getResultLine() {
        if (!this.isRunResultWellFormed()) {
            throw new IllegalStateException("Execution Result was not well formed");
        }
        return this.resultLine;
    }

    @Override
    public final synchronized boolean isRunCompleted() {
        return this.runCompleted;
    }

    @Override
    public final synchronized boolean isRunResultWellFormed() {
        if (!this.isRunCompleted()) {
            throw new IllegalStateException("Run has not yet completed: " + this.toString());
        }
        return this.runResultWellFormed;
    }

    @Override
    public final String rawResultLine() {
        if (!this.isRunCompleted()) {
            throw new IllegalStateException("Run has not yet completed: " + this.toString());
        }
        return this.rawResultLine;
    }

    public int hashCode() {
        return this.runConfig.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractAlgorithmRun) {
            AbstractAlgorithmRun aro = (AbstractAlgorithmRun)o;
            return aro.execConfig.equals(this.execConfig) && aro.runConfig.equals(this.runConfig);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.execConfig.toString()).append("\n");
        sb.append(this.runConfig.toString());
        sb.append("\nResult Line:" + this.resultLine);
        sb.append("\nRawResultLine:" + this.rawResultLine);
        sb.append("\nrunCompleted:" + this.runCompleted);
        sb.append("\nacResult:" + (Object)((Object)this.acResult));
        sb.append("\nAdditional Run Data:" + this.additionalRunData);
        sb.append("\nClass:" + this.getClass().getSimpleName());
        return sb.toString();
    }

    protected void setWallclockExecutionTime(double time) {
        if (time < 0.0) {
            throw new IllegalArgumentException("Time must be positive");
        }
        this.wallClockTime = time;
    }

    @Override
    public double getWallclockExecutionTime() {
        return this.wallClockTime;
    }

    @Override
    public String getAdditionalRunData() {
        return this.additionalRunData;
    }
}

