/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.configspace;

import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ec.util.MersenneTwister;
import java.io.File;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class ParamFileHelper {
    private static ConcurrentHashMap<String, ParamConfigurationSpace> paramFiles = new ConcurrentHashMap();

    public static ParamConfigurationSpace getParamFileParser(String filename, long seedForRandomSampling) {
        return ParamFileHelper.getParamFileParser(new File(filename), seedForRandomSampling);
    }

    public static ParamConfigurationSpace getParamFileParser(File file, long seedForRandomSampling) {
        ParamConfigurationSpace param = paramFiles.get(file.getAbsolutePath());
        if (param == null) {
            param = new ParamConfigurationSpace(file, (Random)new MersenneTwister(seedForRandomSampling));
            ParamConfigurationSpace p = paramFiles.putIfAbsent(file.getAbsolutePath(), param);
            if (p == null) {
                return param;
            }
            return p;
        }
        return param;
    }

    public static void clear() {
        paramFiles.clear();
    }
}

