/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.misc.math;

import ca.ubc.cs.beta.aclib.misc.random.SeedableRandomSingleton;
import ca.ubc.cs.beta.models.fastrf.utils.Hash;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math.stat.StatUtils;

public class ArrayMathOps {
    public static double exp(double x) {
        return Math.pow(Math.E, x);
    }

    public static double log(double x) {
        return Math.log(x);
    }

    public static double pow(double x, double y) {
        return Math.pow(x, y);
    }

    public static double sqrt(double x) {
        return Math.sqrt(x);
    }

    public static double[] sqrt(double[] x) {
        double[] y = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = Math.sqrt(x[i]);
        }
        return y;
    }

    public static double[] times(double x1, double[] x2) {
        double[] y = new double[x2.length];
        for (int i = 0; i < x2.length; ++i) {
            y[i] = x1 * x2[i];
        }
        return y;
    }

    public static double[] pow(double base, double[] exp) {
        double[] y = new double[exp.length];
        for (int i = 0; i < exp.length; ++i) {
            y[i] = Math.pow(base, exp[i]);
        }
        return y;
    }

    public static double[] exp(double[] x) {
        return ArrayMathOps.pow(Math.E, x);
    }

    public static double[][] transpose(double[][] matrix) {
        double[][] transpose = new double[matrix[0].length][matrix.length];
        for (int i = 0; i < transpose.length; ++i) {
            for (int j = 0; j < transpose[0].length; ++j) {
                transpose[i][j] = matrix[j][i];
            }
        }
        return transpose;
    }

    public static int matlabHashCode(double[][] matrix) {
        String s = Arrays.deepToString((Object[])matrix);
        if (s.length() > 250) {
            s = s.substring(0, 249) + "...";
        }
        return Math.abs(Hash.hash((double[][])matrix)) % 32462867;
    }

    public static <X> List<X> permute(List<X> list) {
        ArrayList<X> newList = new ArrayList<X>(list.size());
        int[] perms = SeedableRandomSingleton.getPermutation(list.size(), 0);
        for (int i = 0; i < list.size(); ++i) {
            newList.add(list.get(perms[i]));
        }
        return newList;
    }

    public static double[][] copy(double[][] matrix) {
        double[][] newMatrix = new double[matrix.length][];
        for (int i = 0; i < matrix.length; ++i) {
            newMatrix[i] = (double[])matrix[i].clone();
        }
        return newMatrix;
    }

    public static double[] stripNans(double[] values) {
        int count = 0;
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            ++count;
        }
        double[] newVals = new double[count];
        count = 0;
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            newVals[count] = values[i];
            ++count;
        }
        return newVals;
    }

    public static double meanIgnoreNaNs(double[] values) {
        return StatUtils.mean((double[])ArrayMathOps.stripNans(values));
    }

    public static double stdDevIgnoreNaNs(double[] values) {
        return Math.sqrt(StatUtils.variance((double[])ArrayMathOps.stripNans(values)));
    }

    public static double[] normalize(double[] values, double mean, double stdDev) {
        values = (double[])values.clone();
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            values[i] = values[i] - mean;
            if (!(stdDev > 0.0)) continue;
            int n = i;
            values[n] = values[n] / stdDev;
        }
        return values;
    }

    public static double[] abs(double[] values) {
        values = (double[])values.clone();
        for (int i = 0; i < values.length; ++i) {
            values[i] = Math.abs(values[i]);
        }
        return values;
    }

    public static double max(double[] values) {
        if (values.length == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        double max = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (!(values[i] > max)) continue;
            max = values[i];
        }
        return max;
    }

    public static double maxIgnoreNaNs(double[] values) {
        return ArrayMathOps.max(ArrayMathOps.stripNans(values));
    }
}

