/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.state.legacy;

import au.com.bytecode.opencsv.CSVReader;
import ca.ubc.cs.beta.aclib.algorithmrun.ExistingAlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.exceptions.DuplicateRunException;
import ca.ubc.cs.beta.aclib.exceptions.StateSerializationException;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.objectives.OverallObjective;
import ca.ubc.cs.beta.aclib.objectives.RunObjective;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.runhistory.NewRunHistory;
import ca.ubc.cs.beta.aclib.runhistory.RunHistory;
import ca.ubc.cs.beta.aclib.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.seedgenerator.RandomInstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.state.RandomPoolType;
import ca.ubc.cs.beta.aclib.state.StateDeserializer;
import ca.ubc.cs.beta.aclib.state.legacy.LegacyStateFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyStateDeserializer
implements StateDeserializer {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final RunHistory runHistory;
    private final InstanceSeedGenerator instanceSeedGenerator;
    private final EnumMap<RandomPoolType, Random> randomMap;
    private final int iteration;
    private final ParamConfiguration incumbent;
    private static int newSeeds = 1024;
    private final boolean incompleteSavedState;
    public static final int RUN_ITERATION_INDEX = 11;
    public final double cutoffTime;
    private ParamConfiguration potentialIncumbent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LegacyStateDeserializer(String restoreFromPath, String id, int iteration, ParamConfigurationSpace configSpace, OverallObjective intraInstanceObjective, OverallObjective interInstanceObjective, RunObjective runObj, List<ProblemInstance> instances, AlgorithmExecutionConfig execConfig) {
        if (configSpace == null) {
            throw new IllegalArgumentException("Config Space cannot be null");
        }
        if (interInstanceObjective == null) {
            throw new IllegalArgumentException("Inter Instance Objective cannot be null");
        }
        if (intraInstanceObjective == null) {
            throw new IllegalArgumentException("Intra Instance Objective cannot be null");
        }
        if (runObj == null) {
            throw new IllegalArgumentException("Run Objective cannot be null");
        }
        if (instances == null) {
            throw new IllegalArgumentException("Instances cannot be null");
        }
        if (execConfig == null) {
            throw new IllegalArgumentException("execConfig cannot be null");
        }
        this.cutoffTime = execConfig.getAlgorithmCutoffTime();
        if (instances.size() == 0) {
            this.log.warn("Got empty instance list, except in the trivial case this will result in an exception");
        }
        Object[] args = new Object[]{iteration, id, restoreFromPath};
        this.log.info("Trying to restore iteration: {} id: {} from path: {}", args);
        try {
            HashMap<Integer, ParamConfiguration> configMap;
            FileLocations f;
            block66: {
                f = this.getLocations(restoreFromPath, id, iteration);
                f.validate();
                this.log.trace("Run and Results File: {}", (Object)f.runHistoryFile.getAbsolutePath());
                if (f.paramStringsFile != null) {
                    this.log.trace("Param Strings File: {}", (Object)f.paramStringsFile.getAbsolutePath());
                }
                if (f.uniqConfigFile != null) {
                    this.log.trace("Param Strings File: {}", (Object)f.uniqConfigFile.getAbsolutePath());
                }
                if (f.javaObjDumpFile != null) {
                    this.log.trace("Java Objective Dump File: {}", (Object)f.javaObjDumpFile.getAbsolutePath());
                } else {
                    this.log.trace("Java Objective Dump File: null");
                }
                if (f.javaObjDumpFile != null) {
                    this.incompleteSavedState = false;
                    ObjectInputStream oReader = null;
                    try {
                        oReader = new ObjectInputStream(new FileInputStream(f.javaObjDumpFile));
                        int storedIteration = oReader.readInt();
                        if (storedIteration != iteration) {
                            throw new IllegalStateException("File Found claimed to be for iteration " + iteration + " but contained iteration " + storedIteration + " in file: " + f.javaObjDumpFile.getAbsolutePath());
                        }
                        this.iteration = storedIteration;
                        this.randomMap = (EnumMap)oReader.readObject();
                        this.instanceSeedGenerator = (InstanceSeedGenerator)oReader.readObject();
                        String paramString = (String)oReader.readObject();
                        if (paramString != null) {
                            this.incumbent = configSpace.getConfigurationFromString(paramString, ParamConfiguration.StringFormat.STATEFILE_SYNTAX);
                        }
                        this.incumbent = null;
                    }
                    finally {
                        if (oReader != null) {
                            oReader.close();
                        }
                    }
                } else {
                    this.incompleteSavedState = true;
                    this.randomMap = null;
                    this.instanceSeedGenerator = new RandomInstanceSeedGenerator(0, 0L);
                    this.iteration = iteration;
                    this.incumbent = null;
                }
                BufferedReader reader = null;
                configMap = new HashMap<Integer, ParamConfiguration>();
                try {
                    Integer configId;
                    String[] lineResults;
                    String line;
                    if (f.paramStringsFile != null) {
                        this.log.info("Parsing Parameter Settings from: {}", (Object)f.paramStringsFile.getAbsolutePath());
                        reader = new BufferedReader(new FileReader(f.paramStringsFile));
                        line = null;
                        while ((line = reader.readLine()) != null) {
                            this.log.trace("Parsing config line: {}", (Object)line);
                            lineResults = line.split(":", 2);
                            if (lineResults.length != 2) {
                                throw new IllegalArgumentException("Configuration Param Strings File is corrupted, no colon detected on line: \"" + line + "\"");
                            }
                            configId = Integer.valueOf(lineResults[0]);
                            configMap.put(configId, configSpace.getConfigurationFromString(lineResults[1], ParamConfiguration.StringFormat.STATEFILE_SYNTAX));
                        }
                        break block66;
                    }
                    if (f.uniqConfigFile != null) {
                        this.log.info("Parsing Parameter Settings from: {}", (Object)f.uniqConfigFile.getAbsolutePath());
                        this.log.warn("Parameter Settings specified in array format, which is less portable than paramString format");
                        reader = new BufferedReader(new FileReader(f.uniqConfigFile));
                        line = null;
                        while ((line = reader.readLine()) != null) {
                            this.log.trace("Parsing config line: {}", (Object)line);
                            lineResults = line.split(",", 2);
                            if (lineResults.length != 2) {
                                throw new IllegalArgumentException("Configuration Param Strings File is corrupted, no comma detected on line: \"" + line + "\"");
                            }
                            configId = Integer.valueOf(lineResults[0]);
                            configMap.put(configId, configSpace.getConfigurationFromString(lineResults[1], ParamConfiguration.StringFormat.ARRAY_STRING_SYNTAX));
                        }
                        break block66;
                    }
                    throw new IllegalStateException("One of Unique Configuration File, or Param Strings File should have been non-null, cannot continue");
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            HashMap<Integer, ProblemInstance> instanceMap = new HashMap<Integer, ProblemInstance>();
            for (ProblemInstance instance : instances) {
                instanceMap.put(instance.getInstanceID(), instance);
            }
            this.runHistory = new NewRunHistory(this.instanceSeedGenerator, intraInstanceObjective, interInstanceObjective, runObj);
            CSVReader runlist = null;
            try {
                runlist = new CSVReader((Reader)new FileReader(f.runHistoryFile));
                Object[] runHistoryLine = null;
                int i = 0;
                boolean seedErrorLogged = false;
                while ((runHistoryLine = runlist.readNext()) != null) {
                    ++i;
                    try {
                        long seed;
                        double cutOffTime;
                        boolean isCensored;
                        ProblemInstance pi;
                        int thetaIdx;
                        block67: {
                            if (runHistoryLine[0].trim().equals("Run Number")) continue;
                            thetaIdx = Integer.valueOf(runHistoryLine[1]);
                            int instanceIdx = Integer.valueOf((String)runHistoryLine[2]);
                            pi = (ProblemInstance)instanceMap.get(instanceIdx);
                            if (pi == null) {
                                throw new StateSerializationException("Run History file referenced a Instance ID that does not exist (Column 3) on line: " + Arrays.toString(runHistoryLine) + " we know about " + instances.size() + " instances");
                            }
                            isCensored = !((String)runHistoryLine[4]).trim().equals("0");
                            cutOffTime = Double.valueOf((String)runHistoryLine[5]);
                            seed = -1L;
                            try {
                                seed = Long.valueOf((String)runHistoryLine[6]);
                            }
                            catch (NumberFormatException e) {
                                seed = Double.valueOf((String)runHistoryLine[6]).longValue();
                                if (Double.isNaN(seed) || Double.isInfinite(seed)) {
                                    throw new StateSerializationException("Encountered Illegal Seed Value (either Infinite or Nan) (Column 7) in line: " + Arrays.toString(runHistoryLine));
                                }
                                if (seedErrorLogged) break block67;
                                this.log.warn("Seed value specified in imprecise format on line {}  contents: {}", (Object)i, (Object)runHistoryLine);
                                seedErrorLogged = true;
                            }
                        }
                        double runtime = Double.valueOf(((String)runHistoryLine[7]).trim().replaceAll("Inf$", "Infinity"));
                        if (Double.isNaN(runtime) || Double.isInfinite(runtime)) {
                            throw new StateSerializationException("Encountered an Illegal Runtime value (Infinity or NaN) (Column 8) on line: " + Arrays.toString(runHistoryLine));
                        }
                        double runLength = -1.0;
                        try {
                            runLength = Double.valueOf(((String)runHistoryLine[8]).trim().replaceAll("Inf$", "Infinity"));
                        }
                        catch (NumberFormatException e) {
                            throw new StateSerializationException("Encountered an Illegal Runlength Value (Column 9) on line: " + Arrays.toString(runHistoryLine));
                        }
                        RunResult runResult = runHistoryLine.length >= 14 ? RunResult.getAutomaticConfiguratorResultForKey((String)runHistoryLine[13]) : RunResult.getAutomaticConfiguratorResultForCode(Integer.valueOf((String)runHistoryLine[9]));
                        String additionalRunData = "";
                        if (runHistoryLine.length >= 15) {
                            additionalRunData = ((String)runHistoryLine[14]).trim();
                        }
                        double wallClockTime = 0.0;
                        if (runHistoryLine.length >= 16) {
                            wallClockTime = Double.valueOf(((String)runHistoryLine[15]).trim());
                        }
                        double quality = Double.valueOf(((String)runHistoryLine[10]).trim().replaceAll("Inf$", "Infinity"));
                        int runIteration = Integer.valueOf((String)runHistoryLine[11]);
                        if (runIteration > iteration) break;
                        if (runIteration < this.runHistory.getIteration()) {
                            this.log.warn("Out of order run detected in line {} (Column 11), current iteration is: {}, this may be a corrupt file, or MATLAB deleting previously capped runs ", (Object)Arrays.toString(runHistoryLine), (Object)this.runHistory.getIteration());
                            runIteration = this.runHistory.getIteration();
                        }
                        while (runIteration > this.runHistory.getIteration()) {
                            this.runHistory.incrementIteration();
                        }
                        if (runtime > execConfig.getAlgorithmCutoffTime()) {
                            runtime = execConfig.getAlgorithmCutoffTime();
                            runResult = RunResult.TIMEOUT;
                            cutOffTime = runtime;
                            this.log.info("Cutoff time discrepancy detected while restoring state for line {}, marking run as TIMEOUT with runtime {}", (Object)Arrays.toString(runHistoryLine), (Object)runtime);
                        } else if (runtime < execConfig.getAlgorithmCutoffTime() && runResult.equals((Object)RunResult.TIMEOUT) && !isCensored) {
                            this.log.info("Cutoff time discrepancy detected while restoring state for line {}, marking run as TIMEOUT and Censored with runtime {}", (Object)Arrays.toString(runHistoryLine), (Object)runtime);
                            isCensored = true;
                        }
                        ProblemInstanceSeedPair pisp = new ProblemInstanceSeedPair(pi, seed);
                        RunConfig runConfig = new RunConfig(pisp, cutOffTime, (ParamConfiguration)configMap.get(thetaIdx), isCensored);
                        StringBuffer resultLine = new StringBuffer();
                        resultLine.append(runResult.getResultCode()).append(", ");
                        resultLine.append(runtime).append(", ");
                        resultLine.append(runLength).append(", ");
                        resultLine.append(quality).append(", ");
                        resultLine.append(seed);
                        if (additionalRunData.length() > 0) {
                            resultLine.append(",").append(additionalRunData);
                        }
                        ExistingAlgorithmRun run = new ExistingAlgorithmRun(execConfig, runConfig, resultLine.toString(), wallClockTime);
                        this.log.trace("Appending new run to runHistory: ", (Object)run);
                        try {
                            this.runHistory.append(run);
                        }
                        catch (DuplicateRunException e) {
                            if (seed == -1L) {
                                this.log.trace("Seed is -1 which means it was deterministic, logging run with a new seed");
                                seed = newSeeds++;
                                resultLine.append(runResult.getResultCode()).append(", ");
                                resultLine.append(runtime).append(", ");
                                resultLine.append(runLength).append(", ");
                                resultLine.append(quality).append(", ");
                                resultLine.append(seed);
                                run = new ExistingAlgorithmRun(execConfig, runConfig, resultLine.toString());
                                this.log.trace("Appending new run to runHistory: ", (Object)run);
                                try {
                                    this.runHistory.append(run);
                                }
                                catch (DuplicateRunException e2) {
                                    this.log.info("Could not restore run, duplicate run detected again for deterministic run: {} on line {} ", (Object)run, (Object)Arrays.toString(runHistoryLine));
                                }
                                continue;
                            }
                            this.log.error("Duplicate Run Detected dropped {} from line: {}", (Object)run, (Object)Arrays.toString(runHistoryLine));
                        }
                    }
                    catch (StateSerializationException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw new StateSerializationException("Error occured while parsing the following line of the runHistory file: " + i + " data " + Arrays.toString(runHistoryLine), e);
                    }
                }
                if (this.incumbent == null) {
                    this.log.info("No incumbent found in state files, doing our best to select the incumbent, may not be identical but should be indistinguishable");
                    RunHistory runHistory = this.getRunHistory();
                    Set<ParamConfiguration> configs = runHistory.getUniqueParamConfigurations();
                    HashSet<ParamConfiguration> possibleIncumbents = new HashSet<ParamConfiguration>();
                    int maxPISPS = 0;
                    for (ParamConfiguration config : configs) {
                        int configPISPCount = runHistory.getNumberOfUniqueProblemInstanceSeedPairsForConfiguration(config);
                        if (maxPISPS < configPISPCount) {
                            maxPISPS = configPISPCount;
                            possibleIncumbents.clear();
                            possibleIncumbents.add(config);
                            continue;
                        }
                        if (maxPISPS != configPISPCount) continue;
                        possibleIncumbents.add(config);
                    }
                    double minEmpiricalCost = Double.POSITIVE_INFINITY;
                    Set<ProblemInstance> instancesRan = runHistory.getUniqueInstancesRan();
                    ParamConfiguration potentialIncumbent = null;
                    for (ParamConfiguration config : possibleIncumbents) {
                        double thisEmpiricalCost = runHistory.getEmpiricalCost(config, instancesRan, this.cutoffTime);
                        if (!(thisEmpiricalCost < minEmpiricalCost)) continue;
                        minEmpiricalCost = thisEmpiricalCost;
                        potentialIncumbent = config;
                    }
                    this.potentialIncumbent = potentialIncumbent;
                } else {
                    this.potentialIncumbent = null;
                }
            }
            finally {
                if (runlist != null) {
                    runlist.close();
                }
            }
        }
        catch (IOException e) {
            throw new StateSerializationException("Could not restore state", e);
        }
        catch (ClassNotFoundException e) {
            throw new StateSerializationException("Java Serialization Failed", e);
        }
        this.log.info("Successfully restored iteration: {} id: {} from path: {}", args);
    }

    @Override
    public RunHistory getRunHistory() {
        return this.runHistory;
    }

    @Override
    public Random getPRNG(RandomPoolType t) {
        if (this.incompleteSavedState) {
            throw new StateSerializationException("This is an incomplete state with no java objects found");
        }
        return this.randomMap.get((Object)t);
    }

    @Override
    public InstanceSeedGenerator getInstanceSeedGenerator() {
        if (this.incompleteSavedState) {
            throw new StateSerializationException("This is an incomplete state with no java objects found");
        }
        return this.instanceSeedGenerator;
    }

    private FileLocations getLocations(String path, String id, int iteration) {
        FileLocations f = new FileLocations();
        File restoreDirectory = new File(path);
        HashSet<String> filenames = new HashSet<String>();
        if (!restoreDirectory.exists()) {
            throw new IllegalArgumentException("Restore Directory specified: " + path + " does not exist");
        }
        filenames.addAll(Arrays.asList(restoreDirectory.list()));
        int savedFileIteration = 0;
        boolean filesFound = false;
        int maxIteration = this.getMaxIterationInDirectory(restoreDirectory, id);
        for (savedFileIteration = iteration; savedFileIteration <= 2 * maxIteration; ++savedFileIteration) {
            if (filenames.contains(LegacyStateFactory.getRunAndResultsFilename("", id, savedFileIteration))) {
                if (filenames.contains(LegacyStateFactory.getParamStringsFilename("", id, savedFileIteration))) {
                    f.runHistoryFile = new File(LegacyStateFactory.getRunAndResultsFilename(path, id, savedFileIteration));
                    f.paramStringsFile = new File(LegacyStateFactory.getParamStringsFilename(path, id, savedFileIteration));
                    filesFound = true;
                    break;
                }
                this.log.warn("Didn't find paramStrings file: {} but did find Run and Results file: {}, it's possible saved state directory structure is corrupted.", (Object)LegacyStateFactory.getParamStringsFilename(path, id, savedFileIteration), (Object)LegacyStateFactory.getRunAndResultsFilename(path, id, savedFileIteration));
                continue;
            }
            if (!filenames.contains(LegacyStateFactory.getParamStringsFilename("", "CRASH", savedFileIteration))) continue;
            if (filenames.contains(LegacyStateFactory.getRunAndResultsFilename("", "CRASH", savedFileIteration))) {
                filesFound = true;
                f.runHistoryFile = new File(LegacyStateFactory.getRunAndResultsFilename(path, "CRASH", savedFileIteration));
                f.paramStringsFile = new File(LegacyStateFactory.getParamStringsFilename(path, "CRASH", savedFileIteration));
                break;
            }
            this.log.warn("Found paramStrings file: {} but no Run and Results file: {}, it's possible saved state directory structure is corrupted.", (Object)LegacyStateFactory.getUniqConfigurationsFilename(path, id, savedFileIteration), (Object)LegacyStateFactory.getParamStringsFilename(path, id, savedFileIteration));
        }
        if (!filesFound && filenames.contains(LegacyStateFactory.getRunAndResultsFilename("", "", "", ""))) {
            f.runHistoryFile = new File(LegacyStateFactory.getRunAndResultsFilename(path, "", "", ""));
            if (filenames.contains(LegacyStateFactory.getParamStringsFilename("", "", "", ""))) {
                f.paramStringsFile = new File(LegacyStateFactory.getParamStringsFilename(path, "", "", ""));
                filesFound = true;
            } else if (filenames.contains(LegacyStateFactory.getUniqConfigurationsFilename("", "", "", ""))) {
                f.uniqConfigFile = new File(LegacyStateFactory.getUniqConfigurationsFilename(path, "", "", ""));
                filesFound = true;
            } else {
                this.log.warn("Didn't find paramStrings file: {} but did find Run and Results file: {}, it's possible saved state directory structure is corrupted.", (Object)LegacyStateFactory.getParamStringsFilename(path, id, savedFileIteration), (Object)f.runHistoryFile.getAbsolutePath());
                f.runHistoryFile = null;
            }
        }
        if (!filesFound) {
            throw new StateSerializationException("Could not find data files to restore iteration " + iteration + " with id " + id + " in path " + path);
        }
        f.javaObjDumpFile = new File(LegacyStateFactory.getJavaObjectDumpFilename(path, id, iteration));
        if (!f.javaObjDumpFile.exists()) {
            this.log.info("Could not find object dump file to restore from {}", (Object)f.javaObjDumpFile.getAbsolutePath());
            f.javaObjDumpFile = new File(LegacyStateFactory.getJavaQuickBackObjectDumpFilename(path, id, iteration));
            if (LegacyStateFactory.readIterationFromObjectFile(f.javaObjDumpFile) != iteration) {
                this.log.info("Could not find object dump file to restore from {}", (Object)f.javaObjDumpFile.getAbsolutePath());
                f.javaObjDumpFile = new File(LegacyStateFactory.getJavaQuickObjectDumpFilename(path, id, iteration));
                if (LegacyStateFactory.readIterationFromObjectFile(f.javaObjDumpFile) != iteration) {
                    this.log.info("Could not find object dump file to restore from {}", (Object)f.javaObjDumpFile.getAbsolutePath());
                    f.javaObjDumpFile = new File(LegacyStateFactory.getJavaObjectDumpFilename(path, "CRASH", iteration));
                    if (LegacyStateFactory.readIterationFromObjectFile(f.javaObjDumpFile) != iteration) {
                        this.log.info("Could not find object dump file to restore from {}, No Java Object Dump will be loaded", (Object)f.javaObjDumpFile.getAbsolutePath());
                        f.javaObjDumpFile = null;
                    }
                }
            }
        }
        return f;
    }

    private int getMaxIterationInDirectory(File restoreDirectory, String id) {
        String[] subfiles = restoreDirectory.list();
        Pattern p = Pattern.compile(Pattern.quote(id) + "(\\d+)\\z");
        int maxIteration = 0;
        for (String file : subfiles) {
            file = file.trim().substring(0, file.trim().length() - 4);
            Matcher m = p.matcher(file);
            while (m.find()) {
                int myIteration = 0;
                try {
                    myIteration = Integer.valueOf(m.group(1));
                }
                catch (NumberFormatException e) {
                    this.log.warn("Weird filename encountered that looked like a integer, but wasn't {}, while autodetecting iteration", (Object)file);
                    continue;
                }
                if (myIteration <= maxIteration) continue;
                maxIteration = myIteration;
            }
        }
        return maxIteration;
    }

    @Override
    public int getIteration() {
        return this.iteration;
    }

    @Override
    public ParamConfiguration getIncumbent() {
        if (this.incumbent == null && this.incompleteSavedState) {
            return this.potentialIncumbent;
        }
        return this.incumbent;
    }

    private class FileLocations {
        public File uniqConfigFile;
        public File runHistoryFile;
        public File paramStringsFile;
        public File javaObjDumpFile;

        private FileLocations() {
        }

        public void validate() {
            if (this.runHistoryFile != null && !this.runHistoryFile.exists()) {
                throw new StateSerializationException("Run History File does not exist");
            }
            if (this.javaObjDumpFile != null && !this.javaObjDumpFile.exists()) {
                throw new StateSerializationException("Java Object File does not exist");
            }
            if (this.paramStringsFile != null && !this.paramStringsFile.exists()) {
                throw new StateSerializationException("Param Strings File does not exist");
            }
            if (this.uniqConfigFile != null && !this.uniqConfigFile.exists()) {
                throw new StateSerializationException("Unique Config File does not exist");
            }
        }
    }
}

