/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.AbstractTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifySATTargetAlgorithmEvaluator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private static transient Logger log = LoggerFactory.getLogger(VerifySATTargetAlgorithmEvaluator.class);
    private static final Set<String> satResponses = new HashSet<String>();
    private static final Set<String> unsatResponses = new HashSet<String>();

    public VerifySATTargetAlgorithmEvaluator(TargetAlgorithmEvaluator tae) {
        super(tae);
    }

    @Override
    public List<AlgorithmRun> evaluateRun(RunConfig rc) {
        return this.evaluateRun(Collections.singletonList(rc));
    }

    @Override
    public List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs) {
        List<AlgorithmRun> runs = this.tae.evaluateRun(runConfigs);
        for (AlgorithmRun run : runs) {
            switch (run.getRunResult()) {
                case SAT: {
                    Object[] args;
                    if (unsatResponses.contains(run.getRunConfig().getProblemInstanceSeedPair().getInstance().getInstanceSpecificInformation())) {
                        args = new Object[]{run.getRunResult(), run.getRunConfig().getProblemInstanceSeedPair().getInstance().getInstanceSpecificInformation(), run};
                        log.error("Mismatch occured between instance specific information and target algorithm for run (Saw: <{}>, Expected: <{}>): {} ", args);
                        break;
                    }
                    if (!run.getRunConfig().getProblemInstanceSeedPair().getInstance().getInstanceSpecificInformation().equals("UNKNOWN")) break;
                    args = new Object[]{run.getRunResult(), run.getRunConfig().getProblemInstanceSeedPair().getInstance().getInstanceSpecificInformation(), run};
                    log.warn("Mismatch occured between instance specific information and target algorithm for run (Saw: <{}>, Expected: <{}>): {} ", args);
                    break;
                }
                case UNSAT: {
                    Object[] args;
                    if (satResponses.contains(run.getRunConfig().getProblemInstanceSeedPair().getInstance().getInstanceSpecificInformation())) {
                        args = new Object[]{run.getRunResult(), run.getRunConfig().getProblemInstanceSeedPair().getInstance().getInstanceSpecificInformation(), run};
                        log.error("Mismatch occured between instance specific information and target algorithm for run (Saw: <{}>, Expected: <{}> ): {} ", args);
                        break;
                    }
                    if (!run.getRunConfig().getProblemInstanceSeedPair().getInstance().getInstanceSpecificInformation().equals("UNKNOWN")) break;
                    args = new Object[]{run.getRunResult(), run.getRunConfig().getProblemInstanceSeedPair().getInstance().getInstanceSpecificInformation(), run};
                    log.warn("Mismatch occured between instance specific information and target algorithm for run (Saw: <{}>, Expected: <{}>): {} ", args);
                    break;
                }
            }
        }
        return runs;
    }

    static {
        String[] mySatResponses = new String[]{"SAT", "SATISFIABLE"};
        String[] myUnsatResponses = new String[]{"UNSAT", "UNSATISFIABLE"};
        satResponses.addAll(Arrays.asList(mySatResponses));
        unsatResponses.addAll(Arrays.asList(myUnsatResponses));
    }
}

