/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.trajectoryfile;

import au.com.bytecode.opencsv.CSVReader;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.misc.csvhelpers.ConfigCSVFileHelper;
import ca.ubc.cs.beta.aclib.trajectoryfile.TrajectoryFileEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrajectoryFileParser {
    private static final Logger log = LoggerFactory.getLogger(TrajectoryFileParser.class);

    private static ConcurrentSkipListMap<Double, TrajectoryFileEntry> parseSMACTrajectoryFile(ConfigCSVFileHelper configs, ParamConfigurationSpace configSpace) {
        ConcurrentSkipListMap<Double, TrajectoryFileEntry> skipList = new ConcurrentSkipListMap<Double, TrajectoryFileEntry>();
        for (int i = 0; i < configs.getNumberOfDataRows(); ++i) {
            String time = configs.getStringDataValue(i, 0);
            StringBuilder sb = new StringBuilder();
            String[] dataRow = configs.getDataRow(i);
            ParamConfiguration configObj = configSpace.getEmptyConfiguration();
            for (int j = 5; j < dataRow.length; ++j) {
                String[] splitValues = dataRow[j].split("=");
                configObj.put(splitValues[0], splitValues[1].replaceAll("'", ""));
                sb.append("").append(dataRow[j]).append(" ");
            }
            double tunerTime = Double.valueOf(dataRow[0]);
            double empericalPerformance = Double.valueOf(dataRow[1]);
            double overhead = Double.valueOf(dataRow[4]);
            TrajectoryFileEntry tfe = new TrajectoryFileEntry(configObj, tunerTime, empericalPerformance, overhead);
            skipList.put(Double.valueOf(time), tfe);
        }
        return skipList;
    }

    private static ConcurrentSkipListMap<Double, TrajectoryFileEntry> parseParamILSTrajectoryFile(ConfigCSVFileHelper configs, ParamConfigurationSpace configSpace) {
        ConcurrentSkipListMap<Double, TrajectoryFileEntry> skipList = new ConcurrentSkipListMap<Double, TrajectoryFileEntry>();
        ArrayList<String> paramNames = new ArrayList<String>(configSpace.getParameterNames());
        Collections.sort(paramNames);
        for (int i = 0; i < configs.getNumberOfDataRows(); ++i) {
            String time = configs.getStringDataValue(i, 0);
            String[] dataRow = configs.getDataRow(i);
            ParamConfiguration configObj = configSpace.getEmptyConfiguration();
            int dataOffset = 5;
            for (int j = 0; j < paramNames.size(); ++j) {
                configObj.put((String)paramNames.get(j), dataRow[j + dataOffset]);
            }
            double tunerTime = Double.valueOf(dataRow[0]);
            Double empericalPerformance = Double.valueOf(dataRow[1]);
            Double overhead = Double.valueOf(dataRow[4]);
            TrajectoryFileEntry tfe = new TrajectoryFileEntry(configObj, tunerTime, empericalPerformance, overhead);
            skipList.put(Double.valueOf(time), tfe);
        }
        return skipList;
    }

    public static ConcurrentSkipListMap<Double, TrajectoryFileEntry> parseTrajectoryFile(ConfigCSVFileHelper configs, ParamConfigurationSpace configSpace) {
        ConcurrentSkipListMap<Double, TrajectoryFileEntry> skipList;
        try {
            skipList = TrajectoryFileParser.parseSMACTrajectoryFile(configs, configSpace);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.info("Trajectory File is not in SMAC Format, falling back to ParamILS Format");
            skipList = TrajectoryFileParser.parseParamILSTrajectoryFile(configs, configSpace);
        }
        return skipList;
    }

    public static ConcurrentSkipListMap<Double, TrajectoryFileEntry> parseTrajectoryFile(File trajectoryFile, ParamConfigurationSpace configSpace) throws FileNotFoundException, IOException {
        CSVReader configCSV = new CSVReader((Reader)new FileReader(trajectoryFile));
        ConfigCSVFileHelper configs = new ConfigCSVFileHelper(configCSV.readAll(), 1, 0);
        return TrajectoryFileParser.parseTrajectoryFile(configs, configSpace);
    }

    public static List<TrajectoryFileEntry> parseTrajectoryFileAsList(File trajectoryFile, ParamConfigurationSpace configSpace) throws FileNotFoundException, IOException {
        ConcurrentSkipListMap<Double, TrajectoryFileEntry> parseTrajectoryFile = TrajectoryFileParser.parseTrajectoryFile(trajectoryFile, configSpace);
        ArrayList<TrajectoryFileEntry> tfes = new ArrayList<TrajectoryFileEntry>(parseTrajectoryFile.size());
        for (TrajectoryFileEntry tfe : parseTrajectoryFile.values()) {
            tfes.add(tfe);
        }
        return tfes;
    }
}

