/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.smac;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.exceptions.DeveloperMadeABooBooException;
import ca.ubc.cs.beta.aclib.exceptions.DuplicateRunException;
import ca.ubc.cs.beta.aclib.misc.random.SeedableRandomSingleton;
import ca.ubc.cs.beta.aclib.misc.watch.AutoStartStopWatch;
import ca.ubc.cs.beta.aclib.options.SMACOptions;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.runhistory.NewRunHistory;
import ca.ubc.cs.beta.aclib.runhistory.RunHistory;
import ca.ubc.cs.beta.aclib.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.state.RandomPoolType;
import ca.ubc.cs.beta.aclib.state.StateDeserializer;
import ca.ubc.cs.beta.aclib.state.StateFactory;
import ca.ubc.cs.beta.aclib.state.StateSerializer;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.trajectoryfile.TrajectoryFileEntry;
import ca.ubc.cs.beta.smac.ac.exceptions.OutOfTimeException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractAlgorithmFramework {
    protected Random rand;
    protected RunHistory runHistory;
    protected final long applicationStartTime = System.currentTimeMillis();
    protected final ParamConfigurationSpace configSpace;
    protected final double cutoffTime;
    protected final List<ProblemInstance> instances;
    protected final List<ProblemInstance> testInstances;
    protected final TargetAlgorithmEvaluator algoEval;
    protected final SMACOptions options;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final StateFactory stateFactory;
    private final FileWriter trajectoryFileWriter;
    private final FileWriter trajectoryFileWriterCSV;
    private int iteration = 0;
    protected ParamConfiguration incumbent = null;
    private final int MAX_RUNS_FOR_INCUMBENT;
    private final List<TrajectoryFileEntry> tfes = new ArrayList<TrajectoryFileEntry>();
    private double sumOfWallClockTime = 0.0;
    private double sumOfReportedAlgorithmRunTime = 0.0;
    protected final InstanceSeedGenerator instanceSeedGen;
    private final ParamConfiguration initialIncumbent;
    double unaccountedRunTime = 0.0;
    boolean outOfTime = false;
    private String lastLogMessage = "No statistics logged";
    private double lastEmpericalPerformance = Double.NaN;
    private ParamConfiguration lastIncumbent = null;
    private static Object currentIncumbentCost;
    private final double BEST_POSSIBLE_VALUE = 0.0;
    private final double UNCOMPETITIVE_CAPTIME = 0.0;

    public AbstractAlgorithmFramework(SMACOptions smacOptions, List<ProblemInstance> instances, List<ProblemInstance> testInstances, TargetAlgorithmEvaluator algoEval, StateFactory stateFactory, ParamConfigurationSpace configSpace, InstanceSeedGenerator instanceSeedGen, Random rand, ParamConfiguration initialIncumbent) {
        this.instances = instances;
        this.testInstances = testInstances;
        this.cutoffTime = smacOptions.scenarioConfig.cutoffTime;
        this.options = smacOptions;
        this.rand = rand;
        this.algoEval = algoEval;
        this.stateFactory = stateFactory;
        this.configSpace = configSpace;
        this.runHistory = new NewRunHistory(instanceSeedGen, smacOptions.scenarioConfig.intraInstanceObj, smacOptions.scenarioConfig.interInstanceObj, smacOptions.scenarioConfig.runObj);
        this.instanceSeedGen = instanceSeedGen;
        this.initialIncumbent = initialIncumbent;
        long time = System.currentTimeMillis();
        Date d = new Date(time);
        DateFormat df = DateFormat.getDateTimeInstance();
        this.log.info("Automatic Configuration Start Time is {}", (Object)df.format(d));
        if (instanceSeedGen.getInitialInstanceSeedCount() < this.options.maxIncumbentRuns) {
            this.log.info("Clamping number of runs to {} due to lack of instance/seeds pairs", (Object)instanceSeedGen.getInitialInstanceSeedCount());
            this.MAX_RUNS_FOR_INCUMBENT = instanceSeedGen.getInitialInstanceSeedCount();
        } else {
            this.MAX_RUNS_FOR_INCUMBENT = smacOptions.maxIncumbentRuns;
            this.log.info("Maximimum Number of Runs for the Incumbent Initialized to {}", (Object)this.MAX_RUNS_FOR_INCUMBENT);
        }
        try {
            String outputFileName = this.options.scenarioConfig.outputDirectory + File.separator + this.options.runGroupName + File.separator + "traj-run-" + this.options.numRun + ".txt";
            this.trajectoryFileWriter = new FileWriter(new File(outputFileName));
            this.log.info("Trajectory File Writing To: {}", (Object)outputFileName);
            String outputFileNameCSV = this.options.scenarioConfig.outputDirectory + File.separator + this.options.runGroupName + File.separator + "traj-run-" + this.options.numRun + ".csv";
            this.trajectoryFileWriterCSV = new FileWriter(new File(outputFileNameCSV));
            this.log.info("Trajectory File Writing To: {}", (Object)outputFileNameCSV);
            this.trajectoryFileWriter.write(this.options.runGroupName + ", " + this.options.numRun + "\n");
            this.trajectoryFileWriterCSV.write(this.options.runGroupName + ", " + this.options.numRun + "\n");
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create trajectory file: ", e);
        }
    }

    public ParamConfiguration getInitialIncumbent() {
        return this.initialIncumbent;
    }

    public ParamConfiguration getIncumbent() {
        return this.incumbent;
    }

    public void restoreState(StateDeserializer sd) {
        this.log.info("Restoring State");
        this.rand = sd.getPRNG(RandomPoolType.SEEDABLE_RANDOM_SINGLETON);
        SeedableRandomSingleton.setRandom((Random)this.rand);
        this.configSpace.setPRNG(sd.getPRNG(RandomPoolType.PARAM_CONFIG));
        this.iteration = sd.getIteration();
        this.runHistory = sd.getRunHistory();
        this.incumbent = sd.getIncumbent();
        this.log.info("Incumbent Set To {}", (Object)this.incumbent);
        this.algoEval.seek(this.runHistory.getAlgorithmRuns());
        this.log.info("Restored to Iteration {}", (Object)this.iteration);
    }

    protected boolean have_to_stop(int iteration) {
        return this.have_to_stop(iteration, 0.0);
    }

    protected boolean have_to_stop(int iteration, double nextRunTime) {
        this.outOfTime = true;
        if (this.getTunerTime() + nextRunTime > (double)this.options.scenarioConfig.tunerTimeout) {
            this.unaccountedRunTime = nextRunTime;
            this.log.info("Run cost {} greater than tuner timeout {}", (Object)(this.runHistory.getTotalRunCost() + nextRunTime), (Object)this.options.scenarioConfig.tunerTimeout);
            return true;
        }
        this.unaccountedRunTime = 0.0;
        if (iteration > this.options.numIteratations) {
            this.log.info("Iteration {} greater than number permitted {}", (Object)iteration, (Object)this.options.numIteratations);
            return true;
        }
        if ((long)this.runHistory.getAlgorithmRunData().size() >= this.options.totalNumRunsLimit) {
            this.log.info("Number of runs {} is greater than the number permitted {}", (Object)this.runHistory.getAlgorithmRunData().size(), (Object)this.options.totalNumRunsLimit);
            return true;
        }
        this.outOfTime = false;
        return false;
    }

    public void logIncumbent() {
        this.logIncumbent(-1);
    }

    public long getCPUTime() {
        try {
            ThreadMXBean b = ManagementFactory.getThreadMXBean();
            long cpuTime = 0L;
            for (long threadID : b.getAllThreadIds()) {
                long threadTime = b.getThreadCpuTime(threadID);
                if (threadTime == -1L) {
                    this.log.debug("JVM does not have CPU Time enabled");
                    return 0L;
                }
                cpuTime += threadTime;
            }
            return cpuTime;
        }
        catch (UnsupportedOperationException e) {
            this.log.debug("JVM does not support CPU Time measurements");
            return 0L;
        }
    }

    public long getCPUUserTime() {
        try {
            ThreadMXBean b = ManagementFactory.getThreadMXBean();
            long cpuTime = 0L;
            for (long threadID : b.getAllThreadIds()) {
                long threadTime = b.getThreadUserTime(threadID);
                if (threadTime == -1L) {
                    this.log.debug("JVM does not have CPU Time enabled");
                    return 0L;
                }
                cpuTime += threadTime;
            }
            return cpuTime;
        }
        catch (UnsupportedOperationException e) {
            this.log.debug("JVM does not support CPU Time measurements");
            return 0L;
        }
    }

    public void logIncumbent(int iteration) {
        if (iteration > 0) {
            Object[] arr = new Object[]{iteration, this.runHistory.getThetaIdx(this.incumbent), this.incumbent};
            this.log.info("At end of iteration {}, incumbent is {} ({}) ", arr);
        } else {
            this.log.info("Incumbent currently is: {} ({}) ", (Object)this.runHistory.getThetaIdx(this.incumbent), (Object)this.incumbent);
        }
        this.writeIncumbent();
    }

    protected void logRuntimeStatistics() {
        double wallTime = (double)(System.currentTimeMillis() - this.applicationStartTime) / 1000.0;
        double tunerTime = this.getTunerTime();
        Object[] arr = new Object[]{this.iteration, this.runHistory.getThetaIdx(this.incumbent) + " (" + this.incumbent + ")", this.runHistory.getTotalNumRunsOfConfig(this.incumbent), this.runHistory.getInstancesRan(this.incumbent).size(), this.runHistory.getUniqueParamConfigurations().size(), this.runHistory.getEmpiricalCost(this.incumbent, this.runHistory.getUniqueInstancesRan(), this.cutoffTime), this.runHistory.getAlgorithmRuns().size(), wallTime, (double)this.options.runtimeLimit - wallTime, tunerTime, (double)this.options.scenarioConfig.tunerTimeout - tunerTime, this.runHistory.getTotalRunCost(), (double)this.getCPUTime() / 1000.0 / 1000.0 / 1000.0, (double)this.getCPUUserTime() / 1000.0 / 1000.0 / 1000.0, this.sumOfReportedAlgorithmRunTime, this.sumOfWallClockTime, (double)Runtime.getRuntime().maxMemory() / 1024.0 / 1024.0, (double)Runtime.getRuntime().totalMemory() / 1024.0 / 1024.0, (double)Runtime.getRuntime().freeMemory() / 1024.0 / 1024.0};
        this.lastLogMessage = "*****Runtime Statistics*****\n Iteration: " + arr[0] + "\n Incumbent ID: " + arr[1] + "\n Number of Runs for Incumbent: " + arr[2] + "\n Number of Instances for Incumbent: " + arr[3] + "\n Number of Configurations Run: " + arr[4] + "\n Performance of the Incumbent: " + arr[5] + "\n Total Number of runs performed: " + arr[6] + "\n Wallclock time: " + arr[7] + " s" + "\n Wallclock time remaining: " + arr[8] + " s" + "\n Configuration time budget used: " + arr[9] + " s" + "\n Configuration time budget remaining: " + arr[10] + " s" + "\n Sum of Target Algorithm Execution Times (treating minimum value as 0.1): " + arr[11] + " s" + "\n CPU time of Configurator: " + arr[12] + " s" + "\n User time of Configurator: " + arr[13] + " s" + "\n Total Reported Algorithm Runtime: " + arr[14] + " s" + "\n Sum of Measured Wallclock Runtime: " + arr[15] + " s" + "\n Max Memory: " + arr[16] + " MB" + "\n Total Java Memory: " + arr[17] + " MB" + "\n Free Java Memory: " + arr[18] + " MB";
        this.log.info(this.lastLogMessage);
    }

    public void afterValidationStatistics() {
        this.log.info(this.lastLogMessage);
    }

    private void writeIncumbent() {
        this.writeIncumbent(this.getTunerTime() + this.unaccountedRunTime, this.runHistory.getEmpiricalCost(this.incumbent, this.runHistory.getUniqueInstancesRan(), this.cutoffTime));
    }

    private void writeIncumbent(double tunerTime, double empericalPerformance) {
        if (this.incumbent.equals((Object)this.lastIncumbent) && this.lastEmpericalPerformance == empericalPerformance && !this.outOfTime) {
            return;
        }
        this.lastEmpericalPerformance = empericalPerformance;
        this.lastIncumbent = this.incumbent;
        int thetaIdxInc = this.runHistory.getThetaIdx(this.incumbent);
        double acTime = (double)this.getCPUTime() / 1000.0 / 1000.0 / 1000.0;
        double wallTime = (double)(System.currentTimeMillis() - this.applicationStartTime) / 1000.0;
        String paramString = this.incumbent.getFormattedParamString(ParamConfiguration.StringFormat.STATEFILE_SYNTAX);
        TrajectoryFileEntry tfe = new TrajectoryFileEntry(this.incumbent, tunerTime, empericalPerformance, acTime);
        this.tfes.add(tfe);
        String outLine = tunerTime + ", " + empericalPerformance + ", " + wallTime + ", " + thetaIdxInc + ", " + acTime + ", " + paramString + "\n";
        try {
            this.trajectoryFileWriter.write(outLine);
            this.trajectoryFileWriter.flush();
            this.trajectoryFileWriterCSV.write(outLine);
            this.trajectoryFileWriterCSV.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not update trajectory file", e);
        }
    }

    public int getIteration() {
        return this.iteration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            try {
                if (this.iteration == 0) {
                    this.incumbent = this.initialIncumbent;
                    this.log.info("Initial Incumbent set as Incumbent: {}", (Object)this.incumbent);
                    this.iteration = 0;
                    boolean firstRun = true;
                    int N = this.options.initialIncumbentRuns;
                    N = Math.min(N, this.instances.size());
                    N = Math.min(N, this.options.maxIncumbentRuns);
                    this.log.debug("Scheduling initial configuration for {} runs", (Object)N);
                    for (int i = 0; i < N; ++i) {
                        ProblemInstanceSeedPair pisp = this.runHistory.getRandomInstanceSeedWithFewestRunsFor(this.incumbent, this.instances, this.rand);
                        this.log.trace("New Problem Instance Seed Pair generated {}", (Object)pisp);
                        RunConfig incumbentRunConfig = this.getRunConfig(pisp, this.cutoffTime, this.incumbent);
                        this.writeIncumbent(0.0, Double.MAX_VALUE);
                        try {
                            this.evaluateRun(incumbentRunConfig);
                            continue;
                        }
                        catch (OutOfTimeException e) {
                            this.log.warn("Ran out of time while evaluating the initial configuration on the first run, this is most likely a configuration error");
                            try {
                                this.runHistory.append(e.getAlgorithmRun());
                                continue;
                            }
                            catch (DuplicateRunException e1) {
                                throw new DeveloperMadeABooBooException((Exception)((Object)e1));
                            }
                        }
                    }
                    this.logConfiguration("New Incumbent", this.incumbent);
                    this.logIncumbent(this.iteration);
                    this.logRuntimeStatistics();
                }
                try {
                    while (!this.have_to_stop(this.iteration + 1)) {
                        if (this.shouldSave()) {
                            this.saveState();
                        }
                        this.runHistory.incrementIteration();
                        ++this.iteration;
                        this.log.info("Starting Iteration {}", (Object)this.iteration);
                        AutoStartStopWatch t = new AutoStartStopWatch();
                        this.learnModel(this.runHistory, this.configSpace);
                        this.log.info("Model Learn Time: {} (s)", (Object)((double)t.time() / 1000.0));
                        ArrayList<ParamConfiguration> challengers = new ArrayList<ParamConfiguration>();
                        challengers.addAll(this.selectConfigurations());
                        double learnModelTime = (double)t.stop() / 1000.0;
                        double intensifyTime = Math.ceil(learnModelTime) * (this.options.intensificationPercentage / (1.0 - this.options.intensificationPercentage));
                        this.intensify(challengers, intensifyTime);
                        this.logIncumbent(this.iteration);
                        this.logRuntimeStatistics();
                    }
                }
                catch (OutOfTimeException e) {
                    this.logIncumbent(this.iteration);
                    this.logRuntimeStatistics();
                }
                this.saveState("it", true);
                this.log.info("SMAC Completed");
                if (this.options.cleanOldStatesOnSuccess) {
                    this.log.info("Cleaning old states");
                    this.stateFactory.purgePreviousStates();
                }
            }
            catch (RuntimeException e) {
                try {
                    this.saveState("CRASH", true);
                }
                catch (RuntimeException e2) {
                    this.log.error("SMAC has encountered an exception, and encountered another exception while trying to save the local state. NOTE: THIS PARTICULAR ERROR DID NOT CAUSE SMAC TO FAIL, the original culprit follows further below. (This second error is potentially another / seperate issue, or a disk failure of some kind.) When submitting bug/error reports, please include enough context for *BOTH* exceptions \n  ", (Throwable)e2);
                    throw e;
                }
                throw e;
            }
        }
        finally {
            try {
                this.trajectoryFileWriter.close();
            }
            catch (IOException e) {
                this.log.error("Trying to close Trajectory File failed with exception {}", (Throwable)e);
            }
        }
    }

    protected boolean shouldSave() {
        return true;
    }

    private void saveState() {
        this.saveState("it", (this.iteration - 1 & this.iteration) == 0);
    }

    private void saveState(String id, boolean saveFullState) {
        StateSerializer state = this.stateFactory.getStateSerializer(id, this.iteration);
        state.setPRNG(RandomPoolType.SEEDABLE_RANDOM_SINGLETON, SeedableRandomSingleton.getRandom());
        state.setPRNG(RandomPoolType.PARAM_CONFIG, this.configSpace.getPRNG());
        if (saveFullState) {
            state.setRunHistory(this.runHistory);
        }
        state.setInstanceSeedGenerator(this.runHistory.getInstanceSeedGenerator());
        state.setIncumbent(this.incumbent);
        state.save();
    }

    protected void learnModel(RunHistory runHistory, ParamConfigurationSpace configSpace) {
    }

    public void logIncumbentPerformance(SortedMap<TrajectoryFileEntry, Double> tfePerformance) {
        TrajectoryFileEntry tfe = null;
        double testSetPerformance = Double.POSITIVE_INFINITY;
        ParamConfiguration lastIncumbent = null;
        double lastEmpericalPerformance = Double.POSITIVE_INFINITY;
        double lastTestSetPerformance = Double.POSITIVE_INFINITY;
        for (Map.Entry<TrajectoryFileEntry, Double> ents : tfePerformance.entrySet()) {
            Object[] args2;
            tfe = ents.getKey();
            double empericalPerformance = tfe.getEmpericalPerformance();
            testSetPerformance = ents.getValue();
            double tunerTime = tfe.getTunerTime();
            ParamConfiguration formerIncumbent = tfe.getConfiguration();
            if (formerIncumbent.equals(lastIncumbent) && empericalPerformance == lastEmpericalPerformance && lastTestSetPerformance == testSetPerformance) continue;
            lastIncumbent = formerIncumbent;
            lastEmpericalPerformance = empericalPerformance;
            lastTestSetPerformance = testSetPerformance;
            if (Double.isInfinite(testSetPerformance)) {
                args2 = new Object[]{this.runHistory.getThetaIdx(formerIncumbent), formerIncumbent, tunerTime, empericalPerformance};
                this.log.info("Total Objective of Incumbent {} ({}) at time {} on training set: {}", args2);
                continue;
            }
            args2 = new Object[]{this.runHistory.getThetaIdx(formerIncumbent), formerIncumbent, tunerTime, empericalPerformance, testSetPerformance};
            this.log.info("Total Objective of Incumbent {} ({}) at time {} on training set: {}; on test set: {}", args2);
        }
    }

    public void logSMACResult(SortedMap<TrajectoryFileEntry, Double> tfePerformance) {
        TrajectoryFileEntry tfe = null;
        double testSetPerformance = Double.POSITIVE_INFINITY;
        tfe = tfePerformance.lastKey();
        testSetPerformance = (Double)tfePerformance.get(tfe);
        if (tfe != null && !tfe.getConfiguration().equals((Object)this.incumbent)) {
            throw new IllegalStateException("Last TFE should be Incumbent");
        }
        ProblemInstanceSeedPair pisp = (ProblemInstanceSeedPair)this.runHistory.getAlgorithmInstanceSeedPairsRan(this.incumbent).iterator().next();
        RunConfig runConfig = new RunConfig(pisp, this.cutoffTime, this.incumbent);
        String cmd = this.algoEval.getManualCallString(runConfig);
        Object[] args = new Object[]{this.runHistory.getThetaIdx(this.incumbent), this.incumbent, cmd};
        this.log.info("**********************************************");
        if (Double.isInfinite(testSetPerformance)) {
            Object[] args2 = new Object[]{this.runHistory.getThetaIdx(this.incumbent), this.incumbent, this.runHistory.getEmpiricalCost(this.incumbent, this.runHistory.getUniqueInstancesRan(), this.cutoffTime)};
            this.log.info("Total Objective of Final Incumbent {} ({}) on training set: {}", args2);
        } else {
            Object[] args2 = new Object[]{this.runHistory.getThetaIdx(this.incumbent), this.incumbent, this.runHistory.getEmpiricalCost(this.incumbent, this.runHistory.getUniqueInstancesRan(), this.cutoffTime), testSetPerformance};
            this.log.info("Total Objective of Final Incumbent {} ({}) on training set: {}; on test set: {}", args2);
        }
        this.log.info("Sample Call for Final Incumbent {} ({}) \n{} ", args);
        this.log.info("Complete Configuration (no inactive conditionals):{}", (Object)this.incumbent.getFormattedParamString(ParamConfiguration.StringFormat.STATEFILE_SYNTAX_NO_INACTIVE));
        this.log.info("Complete Configuration (including inactive conditionals):{}", (Object)this.incumbent.getFormattedParamString(ParamConfiguration.StringFormat.STATEFILE_SYNTAX));
    }

    protected List<ParamConfiguration> selectConfigurations() {
        ParamConfiguration c = this.configSpace.getRandomConfiguration();
        this.log.debug("Selecting a random configuration {}", (Object)c);
        return Collections.singletonList(c);
    }

    private void intensify(List<ParamConfiguration> challengers, double timeBound) {
        double initialTime = this.runHistory.getTotalRunCost();
        this.log.info("Calling intensify with {} challenger(s)", (Object)challengers.size());
        for (int i = 0; i < challengers.size(); ++i) {
            double timeUsed = this.runHistory.getTotalRunCost() - initialTime;
            if (timeUsed > timeBound && i > 1) {
                this.log.info("Out of time for intensification timeBound: {} (s); used: {}  (s)", (Object)timeBound, (Object)timeUsed);
                break;
            }
            this.log.info("Intensification timeBound: {} (s); used: {}  (s)", (Object)timeBound, (Object)timeUsed);
            this.challengeIncumbent(challengers.get(i));
        }
    }

    private void challengeIncumbent(ParamConfiguration challenger) {
        if (this.runHistory.getTotalNumRunsOfConfig(this.incumbent) < this.MAX_RUNS_FOR_INCUMBENT) {
            this.log.debug("Performing additional run with the incumbent ");
            ProblemInstanceSeedPair pisp = this.runHistory.getRandomInstanceSeedWithFewestRunsFor(this.incumbent, this.instances, this.rand);
            RunConfig incumbentRunConfig = this.getRunConfig(pisp, this.cutoffTime, this.incumbent);
            this.evaluateRun(incumbentRunConfig);
        } else {
            this.log.debug("Already have performed max runs ({}) for incumbent", (Object)this.MAX_RUNS_FOR_INCUMBENT);
        }
        if (challenger.equals((Object)this.incumbent)) {
            Object[] args = new Object[]{this.runHistory.getThetaIdx(challenger), challenger, this.runHistory.getThetaIdx(this.incumbent), this.incumbent};
            this.log.info("Challenger {} ({}) is equal to the incumbent {} ({}); not evaluating it further ", args);
            return;
        }
        int N = this.options.initialChallengeRuns;
        while (true) {
            HashSet sMissing = new HashSet(this.runHistory.getAlgorithmInstanceSeedPairsRan(this.incumbent));
            sMissing.removeAll(this.runHistory.getAlgorithmInstanceSeedPairsRan(challenger));
            List<ProblemInstanceSeedPair> aMissing = new ArrayList();
            aMissing.addAll(sMissing);
            int runsToMake = Math.min(N, aMissing.size());
            if (runsToMake == 0) {
                this.log.info("Aborting challenge of incumbent. Incumbent has " + this.runHistory.getTotalNumRunsOfConfig(this.incumbent) + " runs, challenger has " + this.runHistory.getTotalNumRunsOfConfig(challenger) + " runs, and the maximum runs for any config is set to " + this.MAX_RUNS_FOR_INCUMBENT + ".");
                return;
            }
            Collections.sort(aMissing);
            int[] permutations = SeedableRandomSingleton.getPermutation((int)aMissing.size(), (int)0);
            SeedableRandomSingleton.permuteList(aMissing, (int[])permutations);
            aMissing = aMissing.subList(0, runsToMake);
            if (this.log.isTraceEnabled()) {
                for (ProblemInstanceSeedPair pisp : aMissing) {
                    this.log.trace("Missing Problem Instance Seed Pair {}", (Object)pisp);
                }
            }
            this.log.trace("Permuting elements according to {}", (Object)Arrays.toString(permutations));
            double bound_inc = Double.POSITIVE_INFINITY;
            HashSet<ProblemInstance> missingInstances = null;
            HashSet<ProblemInstance> missingPlusCommon = null;
            if (this.options.adaptiveCapping.booleanValue()) {
                missingInstances = new HashSet<ProblemInstance>();
                for (int i = 0; i < runsToMake; ++i) {
                    missingInstances.add(((ProblemInstanceSeedPair)aMissing.get(i)).getInstance());
                }
                missingPlusCommon = new HashSet<ProblemInstance>();
                missingPlusCommon.addAll(missingInstances);
                Set piCommon = this.runHistory.getInstancesRan(this.incumbent);
                piCommon.retainAll(this.runHistory.getInstancesRan(challenger));
                missingPlusCommon.addAll(piCommon);
                bound_inc = this.runHistory.getEmpiricalCost(this.incumbent, missingPlusCommon, this.cutoffTime) + Math.pow(10.0, -3.0);
            }
            Object[] args2 = new Object[]{N, this.runHistory.getThetaIdx(challenger), challenger, bound_inc};
            this.log.info("Performing up to {} run(s) for challenger {} ({}) up to a total bound of {} ", args2);
            ArrayList<RunConfig> runsToEval = new ArrayList<RunConfig>(this.options.scenarioConfig.algoExecOptions.maxConcurrentAlgoExecs);
            if (this.options.adaptiveCapping.booleanValue() && this.incumbentImpossibleToBeat(challenger, (ProblemInstanceSeedPair)aMissing.get(0), aMissing, missingPlusCommon, this.cutoffTime, bound_inc)) {
                this.log.info("Challenger cannot beat incumbent => scheduling empty run");
                runsToEval.add(this.getBoundedRunConfig(aMissing.get(0), 0.0, challenger));
                if (runsToMake != 1) {
                    throw new IllegalStateException("Error in empty run scheduling: empty runs should only be scheduled in first iteration of intensify.");
                }
            } else {
                for (int i = 0; i < runsToMake; ++i) {
                    RunConfig runConfig;
                    ProblemInstanceSeedPair pisp = (ProblemInstanceSeedPair)aMissing.get(0);
                    if (this.options.adaptiveCapping.booleanValue()) {
                        double capTime = this.computeCap(challenger, pisp, aMissing, missingPlusCommon, this.cutoffTime, bound_inc);
                        if (capTime < this.cutoffTime) {
                            if (capTime <= 0.0) break;
                            runConfig = this.getBoundedRunConfig(pisp, capTime, challenger);
                        } else {
                            runConfig = this.getRunConfig(pisp, this.cutoffTime, challenger);
                        }
                    } else {
                        runConfig = this.getRunConfig(pisp, this.cutoffTime, challenger);
                    }
                    runsToEval.add(runConfig);
                    sMissing.remove(pisp);
                    aMissing.remove(0);
                    if (runsToEval.size() != this.options.scenarioConfig.algoExecOptions.maxConcurrentAlgoExecs) continue;
                    this.evaluateRun(runsToEval);
                    runsToEval.clear();
                }
            }
            if (runsToEval.size() > 0) {
                this.evaluateRun(runsToEval);
                runsToEval.clear();
            }
            Set piCommon = this.runHistory.getInstancesRan(this.incumbent);
            piCommon.retainAll(this.runHistory.getInstancesRan(challenger));
            double incCost = this.runHistory.getEmpiricalCost(this.incumbent, piCommon, this.cutoffTime);
            double chalCost = this.runHistory.getEmpiricalCost(challenger, piCommon, this.cutoffTime);
            Object[] args = new Object[]{piCommon.size(), this.runHistory.getUniqueInstancesRan().size(), this.runHistory.getThetaIdx(challenger), challenger.getFriendlyIDHex(), chalCost, this.runHistory.getThetaIdx(this.incumbent), this.incumbent, incCost};
            this.log.info("Based on {} common runs on (up to) {} instances, challenger {} ({})  has a lower bound {} and incumbent {} ({}) has obj {}", args);
            if (incCost + Math.pow(10.0, -6.0) < chalCost) {
                this.log.info("Challenger {} ({}) is worse; aborting its evaluation", (Object)this.runHistory.getThetaIdx(challenger), (Object)challenger);
                break;
            }
            if (sMissing.isEmpty()) {
                if (chalCost < incCost - Math.pow(10.0, -6.0)) {
                    this.changeIncumbentTo(challenger);
                    break;
                }
                this.log.info("Challenger {} ({}) has all the runs of the incumbent, but did not outperform it", (Object)this.runHistory.getThetaIdx(challenger), (Object)challenger);
                break;
            }
            Object[] args3 = new Object[]{this.runHistory.getThetaIdx(challenger), challenger, N *= 2};
            this.log.trace("Increasing additional number of runs for challenger {} ({}) to : {} ", args3);
        }
    }

    private void logConfiguration(String type, ParamConfiguration challenger) {
        ProblemInstanceSeedPair pisp = (ProblemInstanceSeedPair)this.runHistory.getAlgorithmInstanceSeedPairsRan(this.incumbent).iterator().next();
        RunConfig config = new RunConfig(pisp, this.cutoffTime, challenger);
        String cmd = this.algoEval.getManualCallString(config);
        Object[] args = new Object[]{type, this.runHistory.getThetaIdx(challenger), challenger, cmd};
        this.log.info("Sample Call for {} {} ({}) \n{} ", args);
    }

    private void changeIncumbentTo(ParamConfiguration challenger) {
        this.incumbent = challenger;
        this.updateIncumbentCost();
        this.log.info("Incumbent Changed to: {} ({})", (Object)this.runHistory.getThetaIdx(challenger), (Object)challenger);
        this.logConfiguration("New Incumbent", challenger);
    }

    private double computeCap(ParamConfiguration challenger, ProblemInstanceSeedPair pisp, List<ProblemInstanceSeedPair> aMissing, Set<ProblemInstance> instanceSet, double cutofftime, double bound_inc) {
        if (this.incumbentImpossibleToBeat(challenger, pisp, aMissing, instanceSet, cutofftime, bound_inc)) {
            return 0.0;
        }
        return this.computeCapBinSearch(challenger, pisp, aMissing, instanceSet, cutofftime, bound_inc, 0.0, cutofftime);
    }

    private boolean incumbentImpossibleToBeat(ParamConfiguration challenger, ProblemInstanceSeedPair pisp, List<ProblemInstanceSeedPair> aMissing, Set<ProblemInstance> instanceSet, double cutofftime, double bound_inc) {
        return this.lowerBoundOnEmpiricalPerformance(challenger, pisp, aMissing, instanceSet, cutofftime, 0.0) > bound_inc;
    }

    private double computeCapBinSearch(ParamConfiguration challenger, ProblemInstanceSeedPair pisp, List<ProblemInstanceSeedPair> aMissing, Set<ProblemInstance> missingInstances, double cutofftime, double bound_inc, double lowerBound, double upperBound) {
        if (upperBound - lowerBound < Math.pow(10.0, -6.0)) {
            double capTime = upperBound + Math.pow(10.0, -3.0);
            return capTime * this.options.capSlack + this.options.capAddSlack;
        }
        double mean = (upperBound + lowerBound) / 2.0;
        double predictedPerformance = this.lowerBoundOnEmpiricalPerformance(challenger, pisp, aMissing, missingInstances, cutofftime, mean);
        if (predictedPerformance < bound_inc) {
            return this.computeCapBinSearch(challenger, pisp, aMissing, missingInstances, cutofftime, bound_inc, mean, upperBound);
        }
        return this.computeCapBinSearch(challenger, pisp, aMissing, missingInstances, cutofftime, bound_inc, lowerBound, mean);
    }

    private double lowerBoundOnEmpiricalPerformance(ParamConfiguration challenger, ProblemInstanceSeedPair pisp, List<ProblemInstanceSeedPair> aMissing, Set<ProblemInstance> instanceSet, double cutofftime, double probe) {
        HashMap hallucinatedValues = new HashMap();
        for (ProblemInstanceSeedPair missingPisp : aMissing) {
            ProblemInstance pi = missingPisp.getInstance();
            if (hallucinatedValues.get(pi) == null) {
                hallucinatedValues.put(pi, new HashMap());
            }
            double hallucinatedValue = 0.0;
            if (pisp.equals((Object)missingPisp)) {
                hallucinatedValue = probe;
            }
            ((Map)hallucinatedValues.get(pi)).put(missingPisp.getSeed(), hallucinatedValue);
        }
        return this.runHistory.getEmpiricalCost(challenger, instanceSet, cutofftime, hallucinatedValues);
    }

    private void updateIncumbentCost() {
        currentIncumbentCost = this.runHistory.getEmpiricalCost(this.incumbent, new HashSet<ProblemInstance>(this.instances), this.cutoffTime);
        this.log.debug("Incumbent Cost now: {}", currentIncumbentCost);
    }

    protected RunConfig getRunConfig(ProblemInstanceSeedPair pisp, double cutofftime, ParamConfiguration configuration) {
        RunConfig rc = new RunConfig(pisp, cutofftime, configuration);
        this.log.trace("RunConfig generated {}", (Object)rc);
        return rc;
    }

    private RunConfig getBoundedRunConfig(ProblemInstanceSeedPair pisp, double capTime, ParamConfiguration challenger) {
        RunConfig rc = new RunConfig(pisp, capTime, challenger, true);
        this.log.trace("RunConfig generated {}", (Object)rc);
        return rc;
    }

    protected List<AlgorithmRun> updateRunHistory(List<AlgorithmRun> runs) {
        for (AlgorithmRun run : runs) {
            try {
                if (this.have_to_stop(this.iteration, run.getRuntime())) {
                    throw new OutOfTimeException(run);
                }
                this.sumOfWallClockTime += run.getWallclockExecutionTime();
                this.sumOfReportedAlgorithmRunTime += run.getRuntime();
                this.runHistory.append(run);
            }
            catch (DuplicateRunException e) {
                throw new IllegalStateException(e);
            }
        }
        return runs;
    }

    protected List<AlgorithmRun> evaluateRun(RunConfig runConfig) {
        return this.evaluateRun(Collections.singletonList(runConfig));
    }

    protected List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs) {
        boolean i = false;
        this.log.info("Iteration {}: Scheduling {} run(s):", (Object)this.iteration, (Object)runConfigs.size());
        for (RunConfig rc : runConfigs) {
            Object[] args = new Object[]{this.iteration, this.runHistory.getThetaIdx(rc.getParamConfiguration()), rc.getParamConfiguration(), rc.getProblemInstanceSeedPair().getInstance().getInstanceID(), rc.getProblemInstanceSeedPair().getSeed(), rc.getCutoffTime()};
            this.log.info("Iteration {}: Scheduling run for config {} ({}) on instance {} with seed {} and captime {}", args);
        }
        List completedRuns = this.algoEval.evaluateRun(runConfigs);
        for (AlgorithmRun run : completedRuns) {
            RunConfig rc = run.getRunConfig();
            Object[] args = new Object[]{this.iteration, this.runHistory.getThetaIdx(rc.getParamConfiguration()), rc.getParamConfiguration(), rc.getProblemInstanceSeedPair().getInstance().getInstanceID(), rc.getProblemInstanceSeedPair().getSeed(), rc.getCutoffTime(), run.getRunResult(), this.options.scenarioConfig.runObj.getObjective(run), run.getWallclockExecutionTime()};
            this.log.info("Iteration {}: Completed run for config {} ({}) on instance {} with seed {} and captime {} => Result: {}, response: {}, wallclock time: {} seconds", args);
        }
        this.updateRunHistory(completedRuns);
        return completedRuns;
    }

    public double getTunerTime() {
        double cpuTime = 0.0;
        if (this.options.countSMACTimeAsTunerTime) {
            cpuTime = (double)this.getCPUTime() / 1000.0 / 1000.0 / 1000.0;
        }
        return cpuTime + this.runHistory.getTotalRunCost();
    }

    public double getEmpericalPerformance(ParamConfiguration config) {
        HashSet<ProblemInstance> pis = new HashSet<ProblemInstance>();
        pis.addAll(this.instances);
        return this.runHistory.getEmpiricalCost(config, pis, this.cutoffTime);
    }

    public List<TrajectoryFileEntry> getTrajectoryFileEntries() {
        return Collections.unmodifiableList(this.tfes);
    }
}

